/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import java.beans.ConstructorProperties;
import org.prebid.server.auction.model.BidInfo;
import org.prebid.server.auction.model.TargetingInfo;
import org.prebid.server.cache.model.CacheInfo;
import org.prebid.server.proto.openrtb.ext.response.BidType;

public final class BidInfo {
    private final Bid bid;
    private final Imp correspondingImp;
    private final String bidCurrency;
    private final String bidder;
    private final BidType bidType;
    private final CacheInfo cacheInfo;
    private final String lineItemId;
    private final String lineItemSource;
    private final TargetingInfo targetingInfo;
    private final String category;
    private final Boolean satisfiedPriority;

    public String getBidId() {
        ObjectNode extNode = this.bid != null ? this.bid.getExt() : null;
        JsonNode bidIdNode = extNode != null ? extNode.path("prebid").path("bidid") : null;
        String generatedBidId = bidIdNode != null && bidIdNode.isTextual() ? bidIdNode.textValue() : null;
        String bidId = this.bid != null ? this.bid.getId() : null;
        return generatedBidId != null ? generatedBidId : bidId;
    }

    @ConstructorProperties(value={"bid", "correspondingImp", "bidCurrency", "bidder", "bidType", "cacheInfo", "lineItemId", "lineItemSource", "targetingInfo", "category", "satisfiedPriority"})
    BidInfo(Bid bid, Imp correspondingImp, String bidCurrency, String bidder, BidType bidType, CacheInfo cacheInfo, String lineItemId, String lineItemSource, TargetingInfo targetingInfo, String category, Boolean satisfiedPriority) {
        this.bid = bid;
        this.correspondingImp = correspondingImp;
        this.bidCurrency = bidCurrency;
        this.bidder = bidder;
        this.bidType = bidType;
        this.cacheInfo = cacheInfo;
        this.lineItemId = lineItemId;
        this.lineItemSource = lineItemSource;
        this.targetingInfo = targetingInfo;
        this.category = category;
        this.satisfiedPriority = satisfiedPriority;
    }

    public static BidInfoBuilder builder() {
        return new BidInfoBuilder();
    }

    public BidInfoBuilder toBuilder() {
        return new BidInfoBuilder().bid(this.bid).correspondingImp(this.correspondingImp).bidCurrency(this.bidCurrency).bidder(this.bidder).bidType(this.bidType).cacheInfo(this.cacheInfo).lineItemId(this.lineItemId).lineItemSource(this.lineItemSource).targetingInfo(this.targetingInfo).category(this.category).satisfiedPriority(this.satisfiedPriority);
    }

    public Bid getBid() {
        return this.bid;
    }

    public Imp getCorrespondingImp() {
        return this.correspondingImp;
    }

    public String getBidCurrency() {
        return this.bidCurrency;
    }

    public String getBidder() {
        return this.bidder;
    }

    public BidType getBidType() {
        return this.bidType;
    }

    public CacheInfo getCacheInfo() {
        return this.cacheInfo;
    }

    public String getLineItemId() {
        return this.lineItemId;
    }

    public String getLineItemSource() {
        return this.lineItemSource;
    }

    public TargetingInfo getTargetingInfo() {
        return this.targetingInfo;
    }

    public String getCategory() {
        return this.category;
    }

    public Boolean getSatisfiedPriority() {
        return this.satisfiedPriority;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidInfo)) {
            return false;
        }
        BidInfo other = (BidInfo)o;
        Boolean this$satisfiedPriority = this.getSatisfiedPriority();
        Boolean other$satisfiedPriority = other.getSatisfiedPriority();
        if (this$satisfiedPriority == null ? other$satisfiedPriority != null : !((Object)this$satisfiedPriority).equals(other$satisfiedPriority)) {
            return false;
        }
        Bid this$bid = this.getBid();
        Bid other$bid = other.getBid();
        if (this$bid == null ? other$bid != null : !this$bid.equals(other$bid)) {
            return false;
        }
        Imp this$correspondingImp = this.getCorrespondingImp();
        Imp other$correspondingImp = other.getCorrespondingImp();
        if (this$correspondingImp == null ? other$correspondingImp != null : !this$correspondingImp.equals(other$correspondingImp)) {
            return false;
        }
        String this$bidCurrency = this.getBidCurrency();
        String other$bidCurrency = other.getBidCurrency();
        if (this$bidCurrency == null ? other$bidCurrency != null : !this$bidCurrency.equals(other$bidCurrency)) {
            return false;
        }
        String this$bidder = this.getBidder();
        String other$bidder = other.getBidder();
        if (this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder)) {
            return false;
        }
        BidType this$bidType = this.getBidType();
        BidType other$bidType = other.getBidType();
        if (this$bidType == null ? other$bidType != null : !this$bidType.equals(other$bidType)) {
            return false;
        }
        CacheInfo this$cacheInfo = this.getCacheInfo();
        CacheInfo other$cacheInfo = other.getCacheInfo();
        if (this$cacheInfo == null ? other$cacheInfo != null : !this$cacheInfo.equals(other$cacheInfo)) {
            return false;
        }
        String this$lineItemId = this.getLineItemId();
        String other$lineItemId = other.getLineItemId();
        if (this$lineItemId == null ? other$lineItemId != null : !this$lineItemId.equals(other$lineItemId)) {
            return false;
        }
        String this$lineItemSource = this.getLineItemSource();
        String other$lineItemSource = other.getLineItemSource();
        if (this$lineItemSource == null ? other$lineItemSource != null : !this$lineItemSource.equals(other$lineItemSource)) {
            return false;
        }
        TargetingInfo this$targetingInfo = this.getTargetingInfo();
        TargetingInfo other$targetingInfo = other.getTargetingInfo();
        if (this$targetingInfo == null ? other$targetingInfo != null : !this$targetingInfo.equals(other$targetingInfo)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !this$category.equals(other$category));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $satisfiedPriority = this.getSatisfiedPriority();
        result = result * 59 + ($satisfiedPriority == null ? 43 : ((Object)$satisfiedPriority).hashCode());
        Bid $bid = this.getBid();
        result = result * 59 + ($bid == null ? 43 : $bid.hashCode());
        Imp $correspondingImp = this.getCorrespondingImp();
        result = result * 59 + ($correspondingImp == null ? 43 : $correspondingImp.hashCode());
        String $bidCurrency = this.getBidCurrency();
        result = result * 59 + ($bidCurrency == null ? 43 : $bidCurrency.hashCode());
        String $bidder = this.getBidder();
        result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
        BidType $bidType = this.getBidType();
        result = result * 59 + ($bidType == null ? 43 : $bidType.hashCode());
        CacheInfo $cacheInfo = this.getCacheInfo();
        result = result * 59 + ($cacheInfo == null ? 43 : $cacheInfo.hashCode());
        String $lineItemId = this.getLineItemId();
        result = result * 59 + ($lineItemId == null ? 43 : $lineItemId.hashCode());
        String $lineItemSource = this.getLineItemSource();
        result = result * 59 + ($lineItemSource == null ? 43 : $lineItemSource.hashCode());
        TargetingInfo $targetingInfo = this.getTargetingInfo();
        result = result * 59 + ($targetingInfo == null ? 43 : $targetingInfo.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        return result;
    }

    public String toString() {
        return "BidInfo(bid=" + this.getBid() + ", correspondingImp=" + this.getCorrespondingImp() + ", bidCurrency=" + this.getBidCurrency() + ", bidder=" + this.getBidder() + ", bidType=" + this.getBidType() + ", cacheInfo=" + this.getCacheInfo() + ", lineItemId=" + this.getLineItemId() + ", lineItemSource=" + this.getLineItemSource() + ", targetingInfo=" + this.getTargetingInfo() + ", category=" + this.getCategory() + ", satisfiedPriority=" + this.getSatisfiedPriority() + ")";
    }
}

