/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import java.beans.ConstructorProperties;
import org.prebid.server.auction.model.AuctionParticipation;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.auction.model.BidderResponse;

public final class AuctionParticipation {
    private final String bidder;
    private final BidderRequest bidderRequest;
    private final BidderResponse bidderResponse;
    private final boolean requestBlocked;
    private final boolean analyticsBlocked;

    public AuctionParticipation with(BidderResponse bidderResponse) {
        return this.toBuilder().bidderResponse(bidderResponse).build();
    }

    @ConstructorProperties(value={"bidder", "bidderRequest", "bidderResponse", "requestBlocked", "analyticsBlocked"})
    AuctionParticipation(String bidder, BidderRequest bidderRequest, BidderResponse bidderResponse, boolean requestBlocked, boolean analyticsBlocked) {
        this.bidder = bidder;
        this.bidderRequest = bidderRequest;
        this.bidderResponse = bidderResponse;
        this.requestBlocked = requestBlocked;
        this.analyticsBlocked = analyticsBlocked;
    }

    public static AuctionParticipationBuilder builder() {
        return new AuctionParticipationBuilder();
    }

    public AuctionParticipationBuilder toBuilder() {
        return new AuctionParticipationBuilder().bidder(this.bidder).bidderRequest(this.bidderRequest).bidderResponse(this.bidderResponse).requestBlocked(this.requestBlocked).analyticsBlocked(this.analyticsBlocked);
    }

    public String getBidder() {
        return this.bidder;
    }

    public BidderRequest getBidderRequest() {
        return this.bidderRequest;
    }

    public BidderResponse getBidderResponse() {
        return this.bidderResponse;
    }

    public boolean isRequestBlocked() {
        return this.requestBlocked;
    }

    public boolean isAnalyticsBlocked() {
        return this.analyticsBlocked;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuctionParticipation)) {
            return false;
        }
        AuctionParticipation other = (AuctionParticipation)o;
        if (this.isRequestBlocked() != other.isRequestBlocked()) {
            return false;
        }
        if (this.isAnalyticsBlocked() != other.isAnalyticsBlocked()) {
            return false;
        }
        String this$bidder = this.getBidder();
        String other$bidder = other.getBidder();
        if (this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder)) {
            return false;
        }
        BidderRequest this$bidderRequest = this.getBidderRequest();
        BidderRequest other$bidderRequest = other.getBidderRequest();
        if (this$bidderRequest == null ? other$bidderRequest != null : !this$bidderRequest.equals(other$bidderRequest)) {
            return false;
        }
        BidderResponse this$bidderResponse = this.getBidderResponse();
        BidderResponse other$bidderResponse = other.getBidderResponse();
        return !(this$bidderResponse == null ? other$bidderResponse != null : !this$bidderResponse.equals(other$bidderResponse));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRequestBlocked() ? 79 : 97);
        result = result * 59 + (this.isAnalyticsBlocked() ? 79 : 97);
        String $bidder = this.getBidder();
        result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
        BidderRequest $bidderRequest = this.getBidderRequest();
        result = result * 59 + ($bidderRequest == null ? 43 : $bidderRequest.hashCode());
        BidderResponse $bidderResponse = this.getBidderResponse();
        result = result * 59 + ($bidderResponse == null ? 43 : $bidderResponse.hashCode());
        return result;
    }

    public String toString() {
        return "AuctionParticipation(bidder=" + this.getBidder() + ", bidderRequest=" + this.getBidderRequest() + ", bidderResponse=" + this.getBidderResponse() + ", requestBlocked=" + this.isRequestBlocked() + ", analyticsBlocked=" + this.isAnalyticsBlocked() + ")";
    }
}

