/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp;

import io.vertx.core.Future;
import java.util.List;
import java.util.Objects;
import org.prebid.server.auction.gpp.GppService;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextCreator;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.model.privacy.Privacy;
import org.prebid.server.auction.gpp.model.privacy.TcfEuV2Privacy;
import org.prebid.server.auction.model.SetuidContext;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.model.PrivacyContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class SetuidGppService {
    private final GppService gppService;

    public SetuidGppService(GppService gppService) {
        this.gppService = Objects.requireNonNull(gppService);
    }

    public Future<GppContext> contextFrom(SetuidContext setuidContext) {
        GppContextWrapper initialGppContextWrapper = SetuidGppService.contextFrom((PrivacyContext)setuidContext.getPrivacyContext());
        GppContextWrapper gppContextWrapper = this.gppService.processContext(initialGppContextWrapper);
        return Future.succeededFuture((Object)gppContextWrapper.getGppContext());
    }

    private static GppContextWrapper contextFrom(PrivacyContext privacyContext) {
        org.prebid.server.privacy.model.Privacy privacy = privacyContext.getPrivacy();
        String gpp = privacy.getGpp();
        List gppSid = privacy.getGppSid();
        Integer gdpr = SetuidGppService.toInt((String)privacy.getGdpr());
        String consent = privacy.getConsentString();
        return GppContextCreator.from((String)gpp, (List)gppSid).with((Privacy)TcfEuV2Privacy.of((Integer)gdpr, (String)consent)).build();
    }

    private static Integer toInt(String string) {
        try {
            return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public SetuidContext updateSetuidContext(SetuidContext setuidContext) {
        GppContext gppContext = setuidContext.getGppContext();
        PrivacyContext privacyContext = setuidContext.getPrivacyContext();
        org.prebid.server.privacy.model.Privacy privacy = privacyContext.getPrivacy();
        GppContext.Regions regions = gppContext.regions();
        TcfEuV2Privacy tcfEuV2Privacy = regions.getTcfEuV2Privacy();
        UpdateResult updatedGdpr = SetuidGppService.updateResult((Object)SetuidGppService.toInt((String)privacy.getGdpr()), (Object)(tcfEuV2Privacy != null ? tcfEuV2Privacy.getGdpr() : null));
        UpdateResult updatedConsent = SetuidGppService.updateResult((Object)privacy.getConsentString(), (Object)(tcfEuV2Privacy != null ? tcfEuV2Privacy.getConsent() : null));
        return updatedGdpr.isUpdated() || updatedConsent.isUpdated() ? setuidContext.toBuilder().privacyContext(PrivacyContext.of((org.prebid.server.privacy.model.Privacy)privacy.toBuilder().gdpr(((Integer)updatedGdpr.getValue()).toString()).consentString((String)updatedConsent.getValue()).build(), (TcfContext)privacyContext.getTcfContext(), (String)privacyContext.getIpAddress())).build() : setuidContext;
    }

    private static <T> UpdateResult<T> updateResult(T original, T gpp) {
        return original == null && gpp != null ? UpdateResult.updated(gpp) : UpdateResult.unaltered(original);
    }
}

