/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.User;
import io.vertx.core.Future;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.prebid.server.auction.gpp.GppService;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextCreator;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.model.privacy.Privacy;
import org.prebid.server.auction.gpp.model.privacy.TcfEuV2Privacy;
import org.prebid.server.auction.gpp.model.privacy.UspV1Privacy;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuctionGppService {
    private final GppService gppService;

    public AuctionGppService(GppService gppService) {
        this.gppService = Objects.requireNonNull(gppService);
    }

    public Future<GppContext> contextFrom(AuctionContext auctionContext) {
        GppContextWrapper initialGppContextWrapper = AuctionGppService.contextFrom((BidRequest)auctionContext.getBidRequest());
        GppContextWrapper gppContextWrapper = this.gppService.processContext(initialGppContextWrapper);
        AuctionGppService.enrichWithErrors((AuctionContext)auctionContext, (List)gppContextWrapper.getErrors());
        return Future.succeededFuture((Object)gppContextWrapper.getGppContext());
    }

    private static GppContextWrapper contextFrom(BidRequest bidRequest) {
        Regs regs = bidRequest.getRegs();
        String gpp = regs != null ? regs.getGpp() : null;
        List gppSid = regs != null ? regs.getGppSid() : null;
        Integer gdpr = AuctionGppService.gdpr((Regs)regs);
        String consent = AuctionGppService.consent((User)bidRequest.getUser());
        String usPrivacy = AuctionGppService.usPrivacy((Regs)regs);
        return GppContextCreator.from((String)gpp, (List)gppSid).with((Privacy)TcfEuV2Privacy.of((Integer)gdpr, (String)consent)).with((Privacy)UspV1Privacy.of((String)usPrivacy)).build();
    }

    private static Integer gdpr(Regs regs) {
        Optional<Regs> regsOptional = Optional.ofNullable(regs);
        return regsOptional.map(Regs::getGdpr).or(() -> regsOptional.map(Regs::getExt).map(ExtRegs::getGdpr)).orElse(null);
    }

    private static String consent(User user) {
        Optional<User> userOptional = Optional.ofNullable(user);
        return userOptional.map(User::getConsent).or(() -> userOptional.map(User::getExt).map(ExtUser::getConsent)).orElse(null);
    }

    private static String usPrivacy(Regs regs) {
        Optional<Regs> regsOptional = Optional.ofNullable(regs);
        return regsOptional.map(Regs::getUsPrivacy).or(() -> regsOptional.map(Regs::getExt).map(ExtRegs::getUsPrivacy)).orElse(null);
    }

    private static void enrichWithErrors(AuctionContext auctionContext, List<String> errors) {
        if (auctionContext.getDebugContext().isDebugEnabled()) {
            auctionContext.getDebugWarnings().addAll(errors);
        }
    }

    public BidRequest updateBidRequest(BidRequest bidRequest, AuctionContext auctionContext) {
        GppContext gppContext = auctionContext.getGppContext();
        UpdateResult updatedUser = AuctionGppService.updateUser((User)bidRequest.getUser(), (GppContext)gppContext);
        UpdateResult updatedRegs = AuctionGppService.updateRegs((Regs)bidRequest.getRegs(), (GppContext)gppContext);
        return updatedUser.isUpdated() || updatedRegs.isUpdated() ? bidRequest.toBuilder().user((User)updatedUser.getValue()).regs((Regs)updatedRegs.getValue()).build() : bidRequest;
    }

    private static UpdateResult<User> updateUser(User user, GppContext gppContext) {
        UpdateResult updatedConsent = AuctionGppService.updateConsent((User)user, (GppContext)gppContext);
        return updatedConsent.isUpdated() ? UpdateResult.updated((Object)Optional.ofNullable(user).map(User::toBuilder).orElseGet(User::builder).consent((String)updatedConsent.getValue()).build()) : UpdateResult.unaltered((Object)user);
    }

    private static UpdateResult<String> updateConsent(User user, GppContext gppContext) {
        TcfEuV2Privacy tcfEuV2Privacy = gppContext.regions().getTcfEuV2Privacy();
        return AuctionGppService.updateResult((Object)(user != null ? user.getConsent() : null), (Object)(tcfEuV2Privacy != null ? tcfEuV2Privacy.getConsent() : null));
    }

    private static <T> UpdateResult<T> updateResult(T original, T gpp) {
        return original == null && gpp != null ? UpdateResult.updated(gpp) : UpdateResult.unaltered(original);
    }

    private static UpdateResult<Regs> updateRegs(Regs regs, GppContext gppContext) {
        UpdateResult updatedGdpr = AuctionGppService.updateGdpr((Regs)regs, (GppContext)gppContext);
        UpdateResult updatedUsPrivacy = AuctionGppService.updateUsPrivacy((Regs)regs, (GppContext)gppContext);
        return updatedGdpr.isUpdated() || updatedUsPrivacy.isUpdated() ? UpdateResult.updated((Object)Optional.ofNullable(regs).map(Regs::toBuilder).orElseGet(Regs::builder).gdpr((Integer)updatedGdpr.getValue()).usPrivacy((String)updatedUsPrivacy.getValue()).build()) : UpdateResult.unaltered((Object)regs);
    }

    private static UpdateResult<Integer> updateGdpr(Regs regs, GppContext gppContext) {
        TcfEuV2Privacy tcfEuV2Privacy = gppContext.regions().getTcfEuV2Privacy();
        return AuctionGppService.updateResult((Object)(regs != null ? regs.getGdpr() : null), (Object)(tcfEuV2Privacy != null ? tcfEuV2Privacy.getGdpr() : null));
    }

    private static UpdateResult<String> updateUsPrivacy(Regs regs, GppContext gppContext) {
        UspV1Privacy uspV1Privacy = gppContext.regions().getUspV1Privacy();
        return AuctionGppService.updateResult((Object)(regs != null ? regs.getUsPrivacy() : null), (Object)(uspV1Privacy != null ? uspV1Privacy.getUsPrivacy() : null));
    }
}

