/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.response.Bid;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.CpmRange;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.TargetingKeywordsCreator;
import org.prebid.server.auction.TargetingKeywordsResolver;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;

/*
 * Exception performing whole class analysis ignored.
 */
public class TargetingKeywordsCreator {
    private static final String HB_ENV_KEY = "hb_env";
    private static final String HB_ENV_APP_VALUE = "mobile-app";
    private static final String HB_BIDDER_KEY = "hb_bidder";
    private static final String HB_PB_KEY = "hb_pb";
    private static final String HB_SIZE_KEY = "hb_size";
    private static final String HB_CACHE_ID_KEY = "hb_cache_id";
    private static final String HB_VAST_ID_KEY = "hb_uuid";
    private static final String HB_DEAL_KEY = "hb_deal";
    private static final String HB_CACHE_HOST_KEY = "hb_cache_host";
    private static final String HB_CACHE_PATH_KEY = "hb_cache_path";
    private static final String HB_CATEGORY_DURATION_KEY = "hb_pb_cat_dur";
    private static final String HB_FORMAT_KEY = "hb_format";
    private static final String DEFAULT_CPM = "0.0";
    private final PriceGranularity priceGranularity;
    private final boolean includeWinners;
    private final boolean includeBidderKeys;
    private final boolean alwaysIncludeDeals;
    private final boolean includeFormat;
    private final boolean isApp;
    private final int truncateAttrChars;
    private final String cacheHost;
    private final String cachePath;
    private final TargetingKeywordsResolver resolver;

    private TargetingKeywordsCreator(PriceGranularity priceGranularity, boolean includeWinners, boolean includeBidderKeys, boolean alwaysIncludeDeals, boolean includeFormat, boolean isApp, int truncateAttrChars, String cacheHost, String cachePath, TargetingKeywordsResolver resolver) {
        this.priceGranularity = priceGranularity;
        this.includeWinners = includeWinners;
        this.includeBidderKeys = includeBidderKeys;
        this.alwaysIncludeDeals = alwaysIncludeDeals;
        this.includeFormat = includeFormat;
        this.isApp = isApp;
        this.truncateAttrChars = truncateAttrChars;
        this.cacheHost = cacheHost;
        this.cachePath = cachePath;
        this.resolver = resolver;
    }

    public static TargetingKeywordsCreator create(ExtPriceGranularity extPriceGranularity, boolean includeWinners, boolean includeBidderKeys, boolean alwaysIncludeDeals, boolean includeFormat, boolean isApp, int truncateAttrChars, String cacheHost, String cachePath, TargetingKeywordsResolver resolver) {
        return new TargetingKeywordsCreator(PriceGranularity.createFromExtPriceGranularity((ExtPriceGranularity)extPriceGranularity), includeWinners, includeBidderKeys, alwaysIncludeDeals, includeFormat, isApp, truncateAttrChars, cacheHost, cachePath, resolver);
    }

    Map<String, String> makeFor(Bid bid, String bidder, boolean winningBid, String cacheId, String format, String vastCacheId, String categoryDuration) {
        Map keywords = this.makeFor(bidder, winningBid, bid.getPrice(), bid.getW(), bid.getH(), cacheId, vastCacheId, categoryDuration, format, bid.getDealid());
        if (this.resolver == null) {
            return this.truncateKeys(keywords);
        }
        HashMap augmentedKeywords = new HashMap(keywords);
        augmentedKeywords.putAll(this.resolver.resolve(bid, bidder));
        return this.truncateKeys(augmentedKeywords);
    }

    private Map<String, String> makeFor(String bidder, boolean winningBid, BigDecimal price, Integer width, Integer height, String cacheId, String vastCacheId, String categoryDuration, String format, String dealId) {
        boolean includeDealBid = this.alwaysIncludeDeals && StringUtils.isNotEmpty((CharSequence)dealId);
        KeywordMap keywordMap = new KeywordMap(bidder, winningBid, this.includeWinners, this.includeBidderKeys || includeDealBid, Collections.emptySet());
        String roundedCpm = this.isPriceGranularityValid() ? CpmRange.fromCpm((BigDecimal)price, (PriceGranularity)this.priceGranularity) : "0.0";
        keywordMap.put("hb_pb", roundedCpm);
        keywordMap.put("hb_bidder", bidder);
        String hbSize = TargetingKeywordsCreator.sizeFrom((Integer)width, (Integer)height);
        if (hbSize != null) {
            keywordMap.put("hb_size", hbSize);
        }
        if (StringUtils.isNotBlank((CharSequence)cacheId)) {
            keywordMap.put("hb_cache_id", cacheId);
        }
        if (StringUtils.isNotBlank((CharSequence)vastCacheId)) {
            keywordMap.put("hb_uuid", vastCacheId);
        }
        if ((StringUtils.isNotBlank((CharSequence)vastCacheId) || StringUtils.isNotBlank((CharSequence)cacheId)) && this.cacheHost != null && this.cachePath != null) {
            keywordMap.put("hb_cache_host", this.cacheHost);
            keywordMap.put("hb_cache_path", this.cachePath);
        }
        if (StringUtils.isNotBlank((CharSequence)format) && this.includeFormat) {
            keywordMap.put("hb_format", format);
        }
        if (StringUtils.isNotBlank((CharSequence)dealId)) {
            keywordMap.put("hb_deal", dealId);
        }
        if (this.isApp) {
            keywordMap.put("hb_env", "mobile-app");
        }
        if (StringUtils.isNotBlank((CharSequence)categoryDuration)) {
            keywordMap.put("hb_pb_cat_dur", categoryDuration);
        }
        return keywordMap.asMap();
    }

    private boolean isPriceGranularityValid() {
        return this.priceGranularity != null;
    }

    private static String sizeFrom(Integer width, Integer height) {
        return width != null && width != 0 && height != null && height != 0 ? "%sx%s".formatted(width, height) : null;
    }

    private Map<String, String> truncateKeys(Map<String, String> keyValues) {
        return this.truncateAttrChars > 0 ? keyValues.entrySet().stream().collect(Collectors.toMap(keyValue -> this.truncateKey((String)keyValue.getKey()), Map.Entry::getValue, (key1, key2) -> key1)) : keyValues;
    }

    private String truncateKey(String key) {
        return key.length() > this.truncateAttrChars ? key.substring(0, this.truncateAttrChars) : key;
    }
}

