/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.ActivityInfrastructure;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.impl.ActivityInvocationPayloadImpl;
import org.prebid.server.activity.infrastructure.payload.impl.PrivacyEnforcementServiceActivityInvocationPayload;
import org.prebid.server.auction.BidderAliases;
import org.prebid.server.auction.ImplicitParametersExtractor;
import org.prebid.server.auction.IpAddressHelper;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.BidderPrivacyResult;
import org.prebid.server.auction.model.IpAddress;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.CountryCodeMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.privacy.PrivacyExtractor;
import org.prebid.server.privacy.ccpa.Ccpa;
import org.prebid.server.privacy.gdpr.TcfDefinerService;
import org.prebid.server.privacy.gdpr.VendorIdResolver;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.RequestLogInfo;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.gdpr.model.TcfResponse;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.privacy.model.PrivacyContext;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.request.CookieSyncRequest;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountCcpaConfig;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.AccountPrivacyConfig;
import org.prebid.server.settings.model.EnabledForRequestType;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrivacyEnforcementService {
    private static final String CATCH_ALL_BIDDERS = "*";
    private static final DecimalFormat ROUND_TWO_DECIMALS = new DecimalFormat("###.##", DecimalFormatSymbols.getInstance(Locale.US));
    private static final User EMPTY_USER = User.builder().build();
    private final BidderCatalog bidderCatalog;
    private final PrivacyExtractor privacyExtractor;
    private final TcfDefinerService tcfDefinerService;
    private final ImplicitParametersExtractor implicitParametersExtractor;
    private final IpAddressHelper ipAddressHelper;
    private final Metrics metrics;
    private final CountryCodeMapper countryCodeMapper;
    private final boolean ccpaEnforce;
    private final boolean lmtEnforce;

    public PrivacyEnforcementService(BidderCatalog bidderCatalog, PrivacyExtractor privacyExtractor, TcfDefinerService tcfDefinerService, ImplicitParametersExtractor implicitParametersExtractor, IpAddressHelper ipAddressHelper, Metrics metrics, CountryCodeMapper countryCodeMapper, boolean ccpaEnforce, boolean lmtEnforce) {
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.privacyExtractor = Objects.requireNonNull(privacyExtractor);
        this.tcfDefinerService = Objects.requireNonNull(tcfDefinerService);
        this.implicitParametersExtractor = Objects.requireNonNull(implicitParametersExtractor);
        this.ipAddressHelper = Objects.requireNonNull(ipAddressHelper);
        this.metrics = Objects.requireNonNull(metrics);
        this.countryCodeMapper = Objects.requireNonNull(countryCodeMapper);
        this.ccpaEnforce = ccpaEnforce;
        this.lmtEnforce = lmtEnforce;
    }

    public Future<PrivacyContext> contextFromBidRequest(AuctionContext auctionContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        List errors = auctionContext.getPrebidErrors();
        Account account = auctionContext.getAccount();
        MetricName requestType = auctionContext.getRequestTypeMetric();
        Timeout timeout = auctionContext.getTimeout();
        Privacy privacy = this.privacyExtractor.validPrivacyFrom(bidRequest, errors);
        Device device = bidRequest.getDevice();
        String alpha2CountryCode = this.resolveAlpha2CountryCode(device);
        String effectiveIpAddress = this.resolveIpAddress(device, privacy);
        AccountGdprConfig accountGdpr = PrivacyEnforcementService.accountGdprConfig((Account)account);
        String accountId = account.getId();
        RequestLogInfo requestLogInfo = PrivacyEnforcementService.requestLogInfo((MetricName)requestType, (BidRequest)bidRequest, (String)accountId);
        return this.tcfDefinerService.resolveTcfContext(privacy, alpha2CountryCode, effectiveIpAddress, accountGdpr, requestType, requestLogInfo, timeout).map(tcfContext -> PrivacyEnforcementService.logWarnings((List)auctionContext.getDebugWarnings(), (TcfContext)tcfContext)).map(tcfContext -> PrivacyContext.of((Privacy)privacy, (TcfContext)tcfContext, (String)tcfContext.getIpAddress()));
    }

    private static TcfContext logWarnings(List<String> debugWarnings, TcfContext tcfContext) {
        debugWarnings.addAll(tcfContext.getWarnings());
        return tcfContext;
    }

    private String resolveAlpha2CountryCode(Device device) {
        Geo geo = device != null ? device.getGeo() : null;
        String alpha3CountryCode = geo != null ? geo.getCountry() : null;
        return this.countryCodeMapper.mapToAlpha2(alpha3CountryCode);
    }

    private String resolveIpAddress(Device device, Privacy privacy) {
        String ipV6Address;
        String ipV4Address;
        boolean shouldBeMasked = PrivacyEnforcementService.isCoppaMaskingRequired((Privacy)privacy) || PrivacyEnforcementService.isLmtEnabled((Device)device);
        String string = ipV4Address = device != null ? device.getIp() : null;
        if (StringUtils.isNotBlank((CharSequence)ipV4Address)) {
            return shouldBeMasked ? this.ipAddressHelper.maskIpv4(ipV4Address) : ipV4Address;
        }
        String string2 = ipV6Address = device != null ? device.getIpv6() : null;
        if (StringUtils.isNotBlank((CharSequence)ipV6Address)) {
            return shouldBeMasked ? this.ipAddressHelper.anonymizeIpv6(ipV6Address) : ipV6Address;
        }
        return null;
    }

    public Future<PrivacyContext> contextFromSetuidRequest(HttpServerRequest httpRequest, Account account, Timeout timeout) {
        Privacy privacy = this.privacyExtractor.validPrivacyFromSetuidRequest(httpRequest);
        String ipAddress = this.resolveIpFromRequest(httpRequest);
        AccountGdprConfig accountGdpr = PrivacyEnforcementService.accountGdprConfig((Account)account);
        String accountId = account.getId();
        RequestLogInfo requestLogInfo = PrivacyEnforcementService.requestLogInfo((MetricName)MetricName.setuid, null, (String)accountId);
        return this.tcfDefinerService.resolveTcfContext(privacy, ipAddress, accountGdpr, MetricName.setuid, requestLogInfo, timeout).map(tcfContext -> PrivacyContext.of((Privacy)privacy, (TcfContext)tcfContext));
    }

    public Future<PrivacyContext> contextFromCookieSyncRequest(CookieSyncRequest cookieSyncRequest, HttpServerRequest httpRequest, Account account, Timeout timeout) {
        Privacy privacy = this.privacyExtractor.validPrivacyFrom(cookieSyncRequest);
        String ipAddress = this.resolveIpFromRequest(httpRequest);
        AccountGdprConfig accountGdpr = PrivacyEnforcementService.accountGdprConfig((Account)account);
        String accountId = account.getId();
        RequestLogInfo requestLogInfo = PrivacyEnforcementService.requestLogInfo((MetricName)MetricName.cookiesync, null, (String)accountId);
        return this.tcfDefinerService.resolveTcfContext(privacy, ipAddress, accountGdpr, MetricName.cookiesync, requestLogInfo, timeout).map(tcfContext -> PrivacyContext.of((Privacy)privacy, (TcfContext)tcfContext));
    }

    private String resolveIpFromRequest(HttpServerRequest request) {
        MultiMap headers = request.headers();
        String host = request.remoteAddress().host();
        List requestIps = this.implicitParametersExtractor.ipFrom(headers, host);
        return requestIps.stream().map(arg_0 -> ((IpAddressHelper)this.ipAddressHelper).toIpAddress(arg_0)).filter(Objects::nonNull).map(IpAddress::getIp).findFirst().orElse(null);
    }

    private static RequestLogInfo requestLogInfo(MetricName requestType, BidRequest bidRequest, String accountId) {
        if (Objects.equals(requestType, MetricName.openrtb2web)) {
            Site site = bidRequest != null ? bidRequest.getSite() : null;
            String refUrl = site != null ? site.getRef() : null;
            return RequestLogInfo.of((MetricName)requestType, (String)refUrl, (String)accountId);
        }
        return RequestLogInfo.of((MetricName)requestType, null, (String)accountId);
    }

    Future<List<BidderPrivacyResult>> mask(AuctionContext auctionContext, Map<String, User> bidderToUser, List<String> bidders, BidderAliases aliases) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        Account account = auctionContext.getAccount();
        MetricName requestType = auctionContext.getRequestTypeMetric();
        Device device = bidRequest.getDevice();
        PrivacyContext privacyContext = auctionContext.getPrivacyContext();
        Privacy privacy = privacyContext.getPrivacy();
        if (PrivacyEnforcementService.isCoppaMaskingRequired((Privacy)privacy)) {
            return Future.succeededFuture((Object)this.maskCoppa(bidderToUser, device));
        }
        this.updateCcpaMetrics(privacy.getCcpa());
        Map ccpaResult = this.ccpaResult(bidRequest, account, bidders, aliases, device, bidderToUser, privacy, requestType);
        HashSet<String> biddersToApplyTcf = new HashSet<String>(bidders);
        biddersToApplyTcf.removeAll(ccpaResult.keySet());
        return this.getBidderToEnforcementAction(privacyContext.getTcfContext(), biddersToApplyTcf, aliases, account).map(bidderToEnforcement -> this.updatePrivacyMetrics(bidderToEnforcement, aliases, requestType, bidderToUser, device)).map(bidderToEnforcement -> this.getBidderToPrivacyResult(bidderToEnforcement, biddersToApplyTcf, bidderToUser, device)).map(gdprResult -> PrivacyEnforcementService.merge((Map)ccpaResult, (List)gdprResult)).map(bidderPrivacyResults -> this.applyActivityRestrictions(bidderPrivacyResults, auctionContext));
    }

    public Future<Map<Integer, PrivacyEnforcementAction>> resultForVendorIds(Set<Integer> vendorIds, TcfContext tcfContext) {
        return this.tcfDefinerService.resultForVendorIds(vendorIds, tcfContext).map(TcfResponse::getActions);
    }

    private Map<String, BidderPrivacyResult> ccpaResult(BidRequest bidRequest, Account account, List<String> bidders, BidderAliases aliases, Device device, Map<String, User> bidderToUser, Privacy privacy, MetricName requestType) {
        return this.isCcpaEnforced(privacy.getCcpa(), account, requestType) ? this.maskCcpa(this.extractCcpaEnforcedBidders(bidders, bidRequest, aliases), device, bidderToUser) : Collections.emptyMap();
    }

    public boolean isCcpaEnforced(Ccpa ccpa, Account account) {
        boolean shouldEnforceCcpa = this.isCcpaEnabled(account);
        return shouldEnforceCcpa && ccpa.isEnforced();
    }

    private boolean isCcpaEnforced(Ccpa ccpa, Account account, MetricName requestType) {
        boolean shouldEnforceCcpa = this.isCcpaEnabled(account, requestType);
        return shouldEnforceCcpa && ccpa.isEnforced();
    }

    private Boolean isCcpaEnabled(Account account) {
        AccountPrivacyConfig accountPrivacyConfig = account.getPrivacy();
        AccountCcpaConfig accountCcpaConfig = accountPrivacyConfig != null ? accountPrivacyConfig.getCcpa() : null;
        Boolean accountCcpaEnabled = accountCcpaConfig != null ? accountCcpaConfig.getEnabled() : null;
        return (Boolean)ObjectUtils.defaultIfNull((Object)accountCcpaEnabled, (Object)this.ccpaEnforce);
    }

    private boolean isCcpaEnabled(Account account, MetricName requestType) {
        Boolean accountCcpaEnabled;
        AccountPrivacyConfig accountPrivacyConfig = account.getPrivacy();
        AccountCcpaConfig accountCcpaConfig = accountPrivacyConfig != null ? accountPrivacyConfig.getCcpa() : null;
        Boolean bl = accountCcpaEnabled = accountCcpaConfig != null ? accountCcpaConfig.getEnabled() : null;
        if (requestType == null) {
            return (Boolean)ObjectUtils.defaultIfNull((Object)accountCcpaEnabled, (Object)this.ccpaEnforce);
        }
        EnabledForRequestType enabledForRequestType = accountCcpaConfig != null ? accountCcpaConfig.getEnabledForRequestType() : null;
        Boolean enabledForType = enabledForRequestType != null ? enabledForRequestType.isEnabledFor(requestType) : null;
        return (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{enabledForType, accountCcpaEnabled, this.ccpaEnforce});
    }

    private Map<String, BidderPrivacyResult> maskCcpa(Set<String> biddersToMask, Device device, Map<String, User> bidderToUser) {
        return biddersToMask.stream().collect(Collectors.toMap(Function.identity(), bidder -> BidderPrivacyResult.builder().requestBidder(bidder).user(this.maskCcpaUser((User)bidderToUser.get(bidder))).device(this.maskCcpaDevice(device)).build()));
    }

    private User maskCcpaUser(User user) {
        if (user != null) {
            return PrivacyEnforcementService.nullIfEmpty((User)user.toBuilder().id(null).buyeruid(null).geo(PrivacyEnforcementService.maskGeoDefault((Geo)user.getGeo())).eids(null).ext(PrivacyEnforcementService.maskUserExt((ExtUser)user.getExt())).build());
        }
        return null;
    }

    private Device maskCcpaDevice(Device device) {
        if (device != null) {
            return device.toBuilder().ip(this.ipAddressHelper.maskIpv4(device.getIp())).ipv6(this.ipAddressHelper.anonymizeIpv6(device.getIpv6())).geo(PrivacyEnforcementService.maskGeoDefault((Geo)device.getGeo())).ifa(null).macsha1(null).macmd5(null).dpidsha1(null).dpidmd5(null).didsha1(null).didmd5(null).build();
        }
        return null;
    }

    private static boolean isCoppaMaskingRequired(Privacy privacy) {
        return privacy.getCoppa() == 1;
    }

    private List<BidderPrivacyResult> maskCoppa(Map<String, User> bidderToUser, Device device) {
        this.metrics.updatePrivacyCoppaMetric();
        return bidderToUser.entrySet().stream().map(bidderAndUser -> BidderPrivacyResult.builder().requestBidder((String)bidderAndUser.getKey()).user(this.maskCoppaUser((User)bidderAndUser.getValue())).device(this.maskCoppaDevice(device)).build()).toList();
    }

    private User maskCoppaUser(User user) {
        if (user != null) {
            return PrivacyEnforcementService.nullIfEmpty((User)user.toBuilder().id(null).yob(null).gender(null).buyeruid(null).geo(PrivacyEnforcementService.maskGeoForCoppa((Geo)user.getGeo())).eids(null).ext(PrivacyEnforcementService.maskUserExt((ExtUser)user.getExt())).build());
        }
        return null;
    }

    private Device maskCoppaDevice(Device device) {
        if (device != null) {
            return device.toBuilder().ip(this.ipAddressHelper.maskIpv4(device.getIp())).ipv6(this.ipAddressHelper.anonymizeIpv6(device.getIpv6())).geo(PrivacyEnforcementService.maskGeoForCoppa((Geo)device.getGeo())).ifa(null).macsha1(null).macmd5(null).dpidsha1(null).dpidmd5(null).didsha1(null).didmd5(null).build();
        }
        return null;
    }

    private static Geo maskGeoForCoppa(Geo geo) {
        Geo updatedGeo = geo != null ? geo.toBuilder().lat(null).lon(null).metro(null).city(null).zip(null).build() : null;
        return updatedGeo == null || updatedGeo.equals((Object)Geo.EMPTY) ? null : updatedGeo;
    }

    private Future<Map<String, PrivacyEnforcementAction>> getBidderToEnforcementAction(TcfContext tcfContext, Set<String> bidders, BidderAliases aliases, Account account) {
        return this.tcfDefinerService.resultForBidderNames(Collections.unmodifiableSet(bidders), VendorIdResolver.of((BidderAliases)aliases, (BidderCatalog)this.bidderCatalog), tcfContext, PrivacyEnforcementService.accountGdprConfig((Account)account)).map(tcfResponse -> PrivacyEnforcementService.mapTcfResponseToEachBidder((TcfResponse)tcfResponse, (Set)bidders));
    }

    private Set<String> extractCcpaEnforcedBidders(List<String> bidders, BidRequest bidRequest, BidderAliases aliases) {
        List nosaleBidders;
        HashSet<String> ccpaEnforcedBidders = new HashSet<String>(bidders);
        ExtRequest extBidRequest = bidRequest.getExt();
        ExtRequestPrebid extRequestPrebid = extBidRequest != null ? extBidRequest.getPrebid() : null;
        List list = nosaleBidders = extRequestPrebid != null ? ListUtils.emptyIfNull((List)extRequestPrebid.getNosale()) : Collections.emptyList();
        if (nosaleBidders.size() == 1 && nosaleBidders.contains("*")) {
            ccpaEnforcedBidders.clear();
        } else {
            nosaleBidders.forEach(ccpaEnforcedBidders::remove);
        }
        ccpaEnforcedBidders.removeIf(bidder -> !this.bidderCatalog.bidderInfoByName(aliases.resolveBidder(bidder)).isCcpaEnforced());
        return ccpaEnforcedBidders;
    }

    private static Map<String, PrivacyEnforcementAction> mapTcfResponseToEachBidder(TcfResponse<String> tcfResponse, Set<String> bidders) {
        Map bidderNameToAction = tcfResponse.getActions();
        return bidders.stream().collect(Collectors.toMap(Function.identity(), bidderNameToAction::get));
    }

    private void updateCcpaMetrics(Ccpa ccpa) {
        this.metrics.updatePrivacyCcpaMetrics(ccpa.isNotEmpty(), ccpa.isEnforced());
    }

    private Map<String, PrivacyEnforcementAction> updatePrivacyMetrics(Map<String, PrivacyEnforcementAction> bidderToEnforcement, BidderAliases aliases, MetricName requestType, Map<String, User> bidderToUser, Device device) {
        for (Map.Entry<String, PrivacyEnforcementAction> bidderEnforcement : bidderToEnforcement.entrySet()) {
            String bidder = bidderEnforcement.getKey();
            PrivacyEnforcementAction enforcement = bidderEnforcement.getValue();
            boolean requestBlocked = enforcement.isBlockBidderRequest();
            User user = bidderToUser.get(bidder);
            boolean userIdRemoved = enforcement.isRemoveUserIds();
            if (requestBlocked || userIdRemoved && !PrivacyEnforcementService.shouldMaskUser((User)user)) {
                userIdRemoved = false;
            }
            boolean geoMasked = enforcement.isMaskGeo();
            if (requestBlocked || geoMasked && !PrivacyEnforcementService.shouldMaskGeo((User)user, (Device)device)) {
                geoMasked = false;
            }
            boolean analyticsBlocked = !requestBlocked && enforcement.isBlockAnalyticsReport();
            this.metrics.updateAuctionTcfMetrics(aliases.resolveBidder(bidder), requestType, userIdRemoved, geoMasked, analyticsBlocked, requestBlocked);
        }
        if (this.lmtEnforce && PrivacyEnforcementService.isLmtEnabled((Device)device)) {
            this.metrics.updatePrivacyLmtMetric();
        }
        return bidderToEnforcement;
    }

    private static boolean shouldMaskUser(User user) {
        if (user == null) {
            return false;
        }
        if (user.getId() != null || user.getBuyeruid() != null) {
            return true;
        }
        return CollectionUtils.isNotEmpty((Collection)user.getEids());
    }

    private static boolean shouldMaskGeo(User user, Device device) {
        return user != null && user.getGeo() != null || device != null && device.getGeo() != null;
    }

    private List<BidderPrivacyResult> getBidderToPrivacyResult(Map<String, PrivacyEnforcementAction> bidderToEnforcement, Set<String> bidders, Map<String, User> bidderToUser, Device device) {
        boolean isLmtEnabled = this.lmtEnforce && PrivacyEnforcementService.isLmtEnabled((Device)device);
        return bidderToUser.entrySet().stream().filter(entry -> bidders.contains(entry.getKey())).map(bidderUserEntry -> this.createBidderPrivacyResult((User)bidderUserEntry.getValue(), device, (String)bidderUserEntry.getKey(), isLmtEnabled, bidderToEnforcement)).toList();
    }

    private BidderPrivacyResult createBidderPrivacyResult(User user, Device device, String bidder, boolean isLmtEnabled, Map<String, PrivacyEnforcementAction> bidderToEnforcement) {
        PrivacyEnforcementAction privacyEnforcementAction = bidderToEnforcement.get(bidder);
        boolean blockBidderRequest = privacyEnforcementAction.isBlockBidderRequest();
        boolean blockAnalyticsReport = privacyEnforcementAction.isBlockAnalyticsReport();
        if (blockBidderRequest) {
            return BidderPrivacyResult.builder().requestBidder(bidder).blockedRequestByTcf(true).blockedAnalyticsByTcf(blockAnalyticsReport).build();
        }
        boolean maskGeo = privacyEnforcementAction.isMaskGeo() || isLmtEnabled;
        boolean maskUserIds = privacyEnforcementAction.isRemoveUserIds() || isLmtEnabled;
        User maskedUser = this.maskTcfUser(user, maskUserIds, maskGeo);
        boolean maskIp = privacyEnforcementAction.isMaskDeviceIp() || isLmtEnabled;
        boolean maskInfo = privacyEnforcementAction.isMaskDeviceInfo() || isLmtEnabled;
        Device maskedDevice = this.maskTcfDevice(device, maskIp, maskGeo, maskInfo);
        return BidderPrivacyResult.builder().requestBidder(bidder).user(maskedUser).device(maskedDevice).blockedAnalyticsByTcf(blockAnalyticsReport).build();
    }

    private User maskTcfUser(User user, boolean maskUserIds, boolean maskGeo) {
        if (user != null) {
            User.UserBuilder userBuilder = user.toBuilder();
            if (maskGeo) {
                userBuilder.geo(PrivacyEnforcementService.maskGeoDefault((Geo)user.getGeo()));
            }
            if (maskUserIds) {
                userBuilder.id(null).buyeruid(null).eids(null).ext(PrivacyEnforcementService.maskUserExt((ExtUser)user.getExt()));
            }
            return PrivacyEnforcementService.nullIfEmpty((User)userBuilder.build());
        }
        return null;
    }

    private Device maskTcfDevice(Device device, boolean maskIp, boolean maskGeo, boolean maskInfo) {
        if (device != null) {
            Device.DeviceBuilder deviceBuilder = device.toBuilder();
            if (maskIp) {
                deviceBuilder.ip(this.ipAddressHelper.maskIpv4(device.getIp())).ipv6(this.ipAddressHelper.anonymizeIpv6(device.getIpv6()));
            }
            if (maskGeo) {
                deviceBuilder.geo(PrivacyEnforcementService.maskGeoDefault((Geo)device.getGeo()));
            }
            if (maskInfo) {
                deviceBuilder.ifa(null).macsha1(null).macmd5(null).dpidsha1(null).dpidmd5(null).didsha1(null).didmd5(null);
            }
            return deviceBuilder.build();
        }
        return null;
    }

    private static Geo maskGeoDefault(Geo geo) {
        if (geo != null) {
            return geo.toBuilder().lat(PrivacyEnforcementService.maskGeoCoordinate((Float)geo.getLat())).lon(PrivacyEnforcementService.maskGeoCoordinate((Float)geo.getLon())).build();
        }
        return null;
    }

    private static Float maskGeoCoordinate(Float coordinate) {
        return coordinate != null ? Float.valueOf(ROUND_TWO_DECIMALS.format(coordinate)) : null;
    }

    private static ExtUser maskUserExt(ExtUser userExt) {
        return userExt != null ? PrivacyEnforcementService.nullIfEmpty((ExtUser)userExt.toBuilder().digitrust(null).build()) : null;
    }

    private static ExtUser nullIfEmpty(ExtUser userExt) {
        return userExt.isEmpty() ? null : userExt;
    }

    private static User nullIfEmpty(User user) {
        return Objects.equals(user, EMPTY_USER) ? null : user;
    }

    private static boolean isLmtEnabled(Device device) {
        return device != null && Objects.equals(device.getLmt(), 1);
    }

    private List<BidderPrivacyResult> applyActivityRestrictions(List<BidderPrivacyResult> bidderPrivacyResults, AuctionContext auctionContext) {
        return bidderPrivacyResults.stream().map(bidderPrivacyResult -> this.applyActivityRestrictions(bidderPrivacyResult, auctionContext)).toList();
    }

    private BidderPrivacyResult applyActivityRestrictions(BidderPrivacyResult bidderPrivacyResult, AuctionContext auctionContext) {
        ActivityInfrastructure activityInfrastructure = auctionContext.getActivityInfrastructure();
        String bidder = bidderPrivacyResult.getRequestBidder();
        User user = bidderPrivacyResult.getUser();
        Device device = bidderPrivacyResult.getDevice();
        Geo geo = device != null ? device.getGeo() : null;
        PrivacyEnforcementServiceActivityInvocationPayload activityInvocationPayload = PrivacyEnforcementServiceActivityInvocationPayload.of((ActivityInvocationPayload)ActivityInvocationPayloadImpl.of((ComponentType)ComponentType.BIDDER, (String)bidder), (String)(geo != null ? geo.getCountry() : null), (String)(geo != null ? geo.getRegion() : null), (String)Optional.ofNullable(auctionContext.getBidRequest().getRegs()).map(Regs::getExt).map(ExtRegs::getGpc).orElse(null));
        boolean disallowTransmitUfpd = !activityInfrastructure.isAllowed(Activity.TRANSMIT_UFPD, (ActivityInvocationPayload)activityInvocationPayload);
        boolean disallowTransmitGeo = !activityInfrastructure.isAllowed(Activity.TRANSMIT_GEO, (ActivityInvocationPayload)activityInvocationPayload);
        User resolvedUser = disallowTransmitUfpd || disallowTransmitGeo ? this.maskUserConsideringActivityRestrictions(user, disallowTransmitUfpd, disallowTransmitGeo) : user;
        Device resolvedDevice = disallowTransmitUfpd || disallowTransmitGeo ? this.maskDeviceConsideringActivityRestrictions(device, disallowTransmitUfpd, disallowTransmitGeo) : device;
        return bidderPrivacyResult.toBuilder().user(resolvedUser).device(resolvedDevice).build();
    }

    public User maskUserConsideringActivityRestrictions(User user, boolean disallowTransmitUfpd, boolean disallowTransmitGeo) {
        if (!disallowTransmitGeo && !disallowTransmitUfpd || user == null) {
            return user;
        }
        User.UserBuilder userBuilder = user.toBuilder();
        if (disallowTransmitUfpd) {
            ExtUser extUser = user.getExt();
            userBuilder.id(null).buyeruid(null).yob(null).gender(null).data(null).eids(null).ext(extUser != null ? PrivacyEnforcementService.nullIfEmpty((ExtUser)extUser.toBuilder().data(null).build()) : null);
        }
        if (disallowTransmitGeo) {
            userBuilder.geo(PrivacyEnforcementService.maskGeoDefault((Geo)user.getGeo()));
        }
        return userBuilder.build();
    }

    public Device maskDeviceConsideringActivityRestrictions(Device device, boolean disallowTransmitUfpd, boolean disallowTransmitGeo) {
        if (!disallowTransmitGeo && !disallowTransmitUfpd) {
            return device;
        }
        return this.maskTcfDevice(device, disallowTransmitGeo, disallowTransmitGeo, disallowTransmitUfpd);
    }

    private static List<BidderPrivacyResult> merge(Map<String, BidderPrivacyResult> ccpaResult, List<BidderPrivacyResult> gdprResult) {
        ArrayList<BidderPrivacyResult> result = new ArrayList<BidderPrivacyResult>(ccpaResult.values());
        result.addAll(gdprResult);
        return result;
    }

    private static AccountGdprConfig accountGdprConfig(Account account) {
        AccountPrivacyConfig privacyConfig = account.getPrivacy();
        return privacyConfig != null ? privacyConfig.getGdpr() : null;
    }
}

