/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.DataObject;
import com.iab.openrtb.request.ImageObject;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Native;
import com.iab.openrtb.request.Request;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Asset;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.Response;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import java.math.BigDecimal;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.StoredRequestProcessor;
import org.prebid.server.auction.TargetingKeywordsCreator;
import org.prebid.server.auction.TargetingKeywordsResolver;
import org.prebid.server.auction.WinningBidComparatorFactory;
import org.prebid.server.auction.categorymapping.CategoryMappingService;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.AuctionParticipation;
import org.prebid.server.auction.model.BidInfo;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.auction.model.BidRejectionTracker;
import org.prebid.server.auction.model.BidRequestCacheInfo;
import org.prebid.server.auction.model.BidderResponse;
import org.prebid.server.auction.model.BidderResponseInfo;
import org.prebid.server.auction.model.CachedDebugLog;
import org.prebid.server.auction.model.CategoryMappingResult;
import org.prebid.server.auction.model.MultiBidConfig;
import org.prebid.server.auction.model.TargetingInfo;
import org.prebid.server.auction.model.debug.DebugContext;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.bidder.model.BidderSeatBidInfo;
import org.prebid.server.cache.CacheService;
import org.prebid.server.cache.model.CacheContext;
import org.prebid.server.cache.model.CacheInfo;
import org.prebid.server.cache.model.CacheServiceResult;
import org.prebid.server.cache.model.DebugHttpCall;
import org.prebid.server.deals.model.DeepDebugLog;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.events.EventsContext;
import org.prebid.server.events.EventsService;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.hooks.execution.HookStageExecutor;
import org.prebid.server.hooks.execution.model.HookStageExecutionResult;
import org.prebid.server.hooks.v1.bidder.AllProcessedBidResponsesPayload;
import org.prebid.server.hooks.v1.bidder.BidderResponsePayload;
import org.prebid.server.identity.IdGenerator;
import org.prebid.server.identity.IdGeneratorType;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtDealLine;
import org.prebid.server.proto.openrtb.ext.request.ExtImp;
import org.prebid.server.proto.openrtb.ext.request.ExtImpAuctionEnvironment;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtMediaTypePriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtOptions;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidChannel;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.CacheAsset;
import org.prebid.server.proto.openrtb.ext.response.Events;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponse;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponseFledge;
import org.prebid.server.proto.openrtb.ext.response.ExtBidResponsePrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidderError;
import org.prebid.server.proto.openrtb.ext.response.ExtDebugPgmetrics;
import org.prebid.server.proto.openrtb.ext.response.ExtDebugTrace;
import org.prebid.server.proto.openrtb.ext.response.ExtHttpCall;
import org.prebid.server.proto.openrtb.ext.response.ExtResponseCache;
import org.prebid.server.proto.openrtb.ext.response.ExtResponseDebug;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceDeal;
import org.prebid.server.proto.openrtb.ext.response.FledgeAuctionConfig;
import org.prebid.server.proto.openrtb.ext.response.seatnonbid.NonBid;
import org.prebid.server.proto.openrtb.ext.response.seatnonbid.SeatNonBid;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountAnalyticsConfig;
import org.prebid.server.settings.model.AccountAuctionConfig;
import org.prebid.server.settings.model.AccountAuctionEventConfig;
import org.prebid.server.settings.model.AccountEventsConfig;
import org.prebid.server.settings.model.VideoStoredDataResult;
import org.prebid.server.util.LineItemUtil;
import org.prebid.server.util.StreamUtil;
import org.prebid.server.vast.VastModifier;

/*
 * Exception performing whole class analysis ignored.
 */
public class BidResponseCreator {
    private static final String CACHE = "cache";
    private static final String PREBID_EXT = "prebid";
    private static final Integer DEFAULT_BID_LIMIT_MIN = 1;
    private final CacheService cacheService;
    private final BidderCatalog bidderCatalog;
    private final VastModifier vastModifier;
    private final EventsService eventsService;
    private final StoredRequestProcessor storedRequestProcessor;
    private final WinningBidComparatorFactory winningBidComparatorFactory;
    private final IdGenerator bidIdGenerator;
    private final HookStageExecutor hookStageExecutor;
    private final CategoryMappingService categoryMappingService;
    private final int truncateAttrChars;
    private final Clock clock;
    private final JacksonMapper mapper;
    private final String cacheHost;
    private final String cachePath;
    private final String cacheAssetUrlTemplate;

    public BidResponseCreator(CacheService cacheService, BidderCatalog bidderCatalog, VastModifier vastModifier, EventsService eventsService, StoredRequestProcessor storedRequestProcessor, WinningBidComparatorFactory winningBidComparatorFactory, IdGenerator bidIdGenerator, HookStageExecutor hookStageExecutor, CategoryMappingService categoryMappingService, int truncateAttrChars, Clock clock, JacksonMapper mapper) {
        this.cacheService = Objects.requireNonNull(cacheService);
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.vastModifier = Objects.requireNonNull(vastModifier);
        this.eventsService = Objects.requireNonNull(eventsService);
        this.storedRequestProcessor = Objects.requireNonNull(storedRequestProcessor);
        this.winningBidComparatorFactory = Objects.requireNonNull(winningBidComparatorFactory);
        this.bidIdGenerator = Objects.requireNonNull(bidIdGenerator);
        this.hookStageExecutor = Objects.requireNonNull(hookStageExecutor);
        this.categoryMappingService = Objects.requireNonNull(categoryMappingService);
        this.truncateAttrChars = BidResponseCreator.validateTruncateAttrChars((int)truncateAttrChars);
        this.clock = Objects.requireNonNull(clock);
        this.mapper = Objects.requireNonNull(mapper);
        this.cacheHost = Objects.requireNonNull(cacheService.getEndpointHost());
        this.cachePath = Objects.requireNonNull(cacheService.getEndpointPath());
        this.cacheAssetUrlTemplate = Objects.requireNonNull(cacheService.getCachedAssetURLTemplate());
    }

    private static int validateTruncateAttrChars(int truncateAttrChars) {
        if (truncateAttrChars < 0 || truncateAttrChars > 255) {
            throw new IllegalArgumentException("truncateAttrChars must be between 0 and 255");
        }
        return truncateAttrChars;
    }

    Future<BidResponse> create(AuctionContext auctionContext, BidRequestCacheInfo cacheInfo, Map<String, MultiBidConfig> bidderToMultiBids) {
        List auctionParticipations = auctionContext.getAuctionParticipations();
        List imps = auctionContext.getBidRequest().getImp();
        EventsContext eventsContext = this.createEventsContext(auctionContext);
        List<BidderResponse> bidderResponses = auctionParticipations.stream().filter(auctionParticipation -> !auctionParticipation.isRequestBlocked()).map(AuctionParticipation::getBidderResponse).toList();
        return this.videoStoredDataResult(auctionContext).compose(videoStoredDataResult -> this.invokeProcessedBidderResponseHooks(this.updateBids(bidderResponses, videoStoredDataResult, auctionContext, eventsContext, imps), auctionContext).compose(updatedResponses -> this.invokeAllProcessedBidResponsesHook(updatedResponses, auctionContext)).compose(updatedResponses -> this.createCategoryMapping(auctionContext, updatedResponses)).compose(categoryMappingResult -> this.cacheBidsAndCreateResponse(this.toBidderResponseInfos(categoryMappingResult, imps), auctionContext, cacheInfo, bidderToMultiBids, videoStoredDataResult, eventsContext)).map(bidResponse -> BidResponseCreator.populateSeatNonBid((AuctionContext)auctionContext, (BidResponse)bidResponse)));
    }

    private List<BidderResponse> updateBids(List<BidderResponse> bidderResponses, VideoStoredDataResult videoStoredDataResult, AuctionContext auctionContext, EventsContext eventsContext, List<Imp> imps) {
        ArrayList<BidderResponse> result = new ArrayList<BidderResponse>();
        for (BidderResponse bidderResponse : bidderResponses) {
            String bidder = bidderResponse.getBidder();
            ArrayList<BidderBid> modifiedBidderBids = new ArrayList<BidderBid>();
            BidderSeatBid seatBid = bidderResponse.getSeatBid();
            for (BidderBid bidderBid : seatBid.getBids()) {
                Bid receivedBid = bidderBid.getBid();
                BidType bidType = bidderBid.getType();
                Imp correspondingImp = BidResponseCreator.correspondingImp((Bid)receivedBid, imps);
                ExtDealLine extDealLine = LineItemUtil.extDealLineFrom((Bid)receivedBid, (Imp)correspondingImp, (JacksonMapper)this.mapper);
                String lineItemId = extDealLine != null ? extDealLine.getLineItemId() : null;
                Bid updatedBid = this.updateBid(receivedBid, bidType, bidder, videoStoredDataResult, auctionContext, eventsContext, lineItemId);
                modifiedBidderBids.add(bidderBid.toBuilder().bid(updatedBid).build());
            }
            BidderSeatBid modifiedSeatBid = seatBid.with(modifiedBidderBids);
            result.add(bidderResponse.with(modifiedSeatBid));
        }
        return result;
    }

    private Bid updateBid(Bid bid, BidType bidType, String bidder, VideoStoredDataResult videoStoredDataResult, AuctionContext auctionContext, EventsContext eventsContext, String lineItemId) {
        Account account = auctionContext.getAccount();
        List debugWarnings = auctionContext.getDebugWarnings();
        String generatedBidId = this.bidIdGenerator.getType() != IdGeneratorType.none ? this.bidIdGenerator.generateId() : null;
        String effectiveBidId = (String)ObjectUtils.defaultIfNull((Object)generatedBidId, (Object)bid.getId());
        return bid.toBuilder().adm(this.updateBidAdm(bid, bidType, bidder, account, eventsContext, effectiveBidId, debugWarnings, lineItemId)).ext(this.updateBidExt(bid, bidType, bidder, account, videoStoredDataResult, eventsContext, generatedBidId, effectiveBidId, lineItemId)).build();
    }

    private String updateBidAdm(Bid bid, BidType bidType, String bidder, Account account, EventsContext eventsContext, String effectiveBidId, List<String> debugWarnings, String lineItemId) {
        String bidAdm = bid.getAdm();
        return BidType.video.equals((Object)bidType) ? this.vastModifier.createBidVastXml(bidder, bidAdm, bid.getNurl(), effectiveBidId, account.getId(), eventsContext, debugWarnings, lineItemId) : bidAdm;
    }

    private ObjectNode updateBidExt(Bid bid, BidType bidType, String bidder, Account account, VideoStoredDataResult videoStoredDataResult, EventsContext eventsContext, String generatedBidId, String effectiveBidId, String lineItemId) {
        ExtBidPrebid updatedExtBidPrebid = this.updateBidExtPrebid(bid, bidType, bidder, account, videoStoredDataResult, eventsContext, generatedBidId, effectiveBidId, lineItemId);
        ObjectNode existingBidExt = bid.getExt();
        ObjectNode updatedBidExt = this.mapper.mapper().createObjectNode();
        if (existingBidExt != null && !existingBidExt.isEmpty()) {
            updatedBidExt.setAll(existingBidExt);
        }
        updatedBidExt.set("prebid", this.mapper.mapper().valueToTree((Object)updatedExtBidPrebid));
        return updatedBidExt;
    }

    private ExtBidPrebid updateBidExtPrebid(Bid bid, BidType bidType, String bidder, Account account, VideoStoredDataResult videoStoredDataResult, EventsContext eventsContext, String generatedBidId, String effectiveBidId, String lineItemId) {
        Video storedVideo = (Video)videoStoredDataResult.getImpIdToStoredVideo().get(bid.getImpid());
        Events events = this.createEvents(bidder, account, effectiveBidId, eventsContext, lineItemId);
        ExtBidPrebidVideo extBidPrebidVideo = this.getExtBidPrebidVideo(bid.getExt()).orElse(null);
        ExtBidPrebid.ExtBidPrebidBuilder extBidPrebidBuilder = this.getExtPrebid(bid.getExt(), ExtBidPrebid.class).map(ExtBidPrebid::toBuilder).orElseGet(ExtBidPrebid::builder);
        return extBidPrebidBuilder.bidid(generatedBidId).type(bidType).storedRequestAttributes(storedVideo).events(events).video(extBidPrebidVideo).build();
    }

    private static boolean isEmptyBidderResponses(List<BidderResponseInfo> bidderResponseInfos) {
        return bidderResponseInfos.isEmpty() || bidderResponseInfos.stream().map(bidderResponseInfo -> bidderResponseInfo.getSeatBid().getBidsInfos()).allMatch(CollectionUtils::isEmpty);
    }

    private List<BidderResponseInfo> toBidderResponseInfos(CategoryMappingResult categoryMappingResult, List<Imp> imps) {
        ArrayList<BidderResponseInfo> result = new ArrayList<BidderResponseInfo>();
        List bidderResponses = categoryMappingResult.getBidderResponses();
        for (BidderResponse bidderResponse : bidderResponses) {
            String bidder = bidderResponse.getBidder();
            ArrayList<BidInfo> bidInfos = new ArrayList<BidInfo>();
            BidderSeatBid seatBid = bidderResponse.getSeatBid();
            for (BidderBid bidderBid : seatBid.getBids()) {
                Bid bid = bidderBid.getBid();
                BidType type = bidderBid.getType();
                BidInfo bidInfo = this.toBidInfo(bid, type, imps, bidder, categoryMappingResult);
                bidInfos.add(bidInfo);
            }
            BidderSeatBidInfo bidderSeatBidInfo = BidderSeatBidInfo.of(bidInfos, (List)seatBid.getHttpCalls(), (List)seatBid.getErrors(), (List)seatBid.getWarnings(), (List)seatBid.getFledgeAuctionConfigs());
            result.add(BidderResponseInfo.of((String)bidder, (BidderSeatBidInfo)bidderSeatBidInfo, (int)bidderResponse.getResponseTime()));
        }
        return result;
    }

    private BidInfo toBidInfo(Bid bid, BidType type, List<Imp> imps, String bidder, CategoryMappingResult categoryMappingResult) {
        Imp correspondingImp = BidResponseCreator.correspondingImp((Bid)bid, imps);
        ExtDealLine extDealLine = LineItemUtil.extDealLineFrom((Bid)bid, (Imp)correspondingImp, (JacksonMapper)this.mapper);
        String lineItemId = extDealLine != null ? extDealLine.getLineItemId() : null;
        return BidInfo.builder().bid(bid).bidType(type).bidder(bidder).correspondingImp(correspondingImp).lineItemId(lineItemId).category(categoryMappingResult.getCategory(bid)).satisfiedPriority(categoryMappingResult.isBidSatisfiesPriority(bid)).build();
    }

    private static Imp correspondingImp(Bid bid, List<Imp> imps) {
        String impId = bid.getImpid();
        return (Imp)BidResponseCreator.correspondingImp((String)impId, imps).orElseThrow(() -> new PreBidException("Bid with impId %s doesn't have matched imp".formatted(impId)));
    }

    private static Optional<Imp> correspondingImp(String impId, List<Imp> imps) {
        return imps.stream().filter(imp -> Objects.equals(impId, imp.getId())).findFirst();
    }

    private Future<List<BidderResponse>> invokeProcessedBidderResponseHooks(List<BidderResponse> bidderResponses, AuctionContext auctionContext) {
        return CompositeFuture.join((List)bidderResponses.stream().map(bidderResponse -> this.hookStageExecutor.executeProcessedBidderResponseStage(bidderResponse, auctionContext).map(stageResult -> BidResponseCreator.rejectBidderResponseOrProceed((HookStageExecutionResult)stageResult, (BidderResponse)bidderResponse))).collect(Collectors.toCollection(ArrayList::new))).map(CompositeFuture::list);
    }

    private Future<List<BidderResponse>> invokeAllProcessedBidResponsesHook(List<BidderResponse> bidderResponses, AuctionContext auctionContext) {
        return this.hookStageExecutor.executeAllProcessedBidResponsesStage(bidderResponses, auctionContext).map(HookStageExecutionResult::getPayload).map(AllProcessedBidResponsesPayload::bidResponses);
    }

    private static BidderResponse rejectBidderResponseOrProceed(HookStageExecutionResult<BidderResponsePayload> stageResult, BidderResponse bidderResponse) {
        List bids = stageResult.isShouldReject() ? Collections.emptyList() : ((BidderResponsePayload)stageResult.getPayload()).bids();
        return bidderResponse.with(bidderResponse.getSeatBid().with(bids));
    }

    private Future<CategoryMappingResult> createCategoryMapping(AuctionContext auctionContext, List<BidderResponse> bidderResponses) {
        return this.categoryMappingService.createCategoryMapping(bidderResponses, auctionContext.getBidRequest(), auctionContext.getTimeout()).map(categoryMappingResult -> BidResponseCreator.addCategoryMappingErrors((CategoryMappingResult)categoryMappingResult, (AuctionContext)auctionContext));
    }

    private static CategoryMappingResult addCategoryMappingErrors(CategoryMappingResult categoryMappingResult, AuctionContext auctionContext) {
        auctionContext.getPrebidErrors().addAll(CollectionUtils.emptyIfNull((Collection)categoryMappingResult.getErrors()));
        return categoryMappingResult;
    }

    private Future<BidResponse> cacheBidsAndCreateResponse(List<BidderResponseInfo> bidderResponses, AuctionContext auctionContext, BidRequestCacheInfo cacheInfo, Map<String, MultiBidConfig> bidderToMultiBids, VideoStoredDataResult videoStoredDataResult, EventsContext eventsContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        if (BidResponseCreator.isEmptyBidderResponses(bidderResponses)) {
            ExtBidResponse extBidResponse = this.toExtBidResponse(bidderResponses, auctionContext, CacheServiceResult.empty(), VideoStoredDataResult.empty(), eventsContext.getAuctionTimestamp().longValue(), null);
            CachedDebugLog cachedDebugLog = auctionContext.getCachedDebugLog();
            if (BidResponseCreator.isCachedDebugEnabled((CachedDebugLog)cachedDebugLog)) {
                cachedDebugLog.setExtBidResponse(extBidResponse);
            }
            return Future.succeededFuture((Object)BidResponse.builder().id(bidRequest.getId()).cur((String)bidRequest.getCur().get(0)).nbr(Integer.valueOf(0)).seatbid(Collections.emptyList()).ext(extBidResponse).build());
        }
        ExtRequestTargeting targeting = BidResponseCreator.targeting((BidRequest)bidRequest);
        TxnLog txnLog = auctionContext.getTxnLog();
        List bidderResponseInfos = this.toBidderResponseWithTargetingBidInfos(bidderResponses, bidderToMultiBids, BidResponseCreator.preferDeals((ExtRequestTargeting)targeting), txnLog);
        Set bidInfos = bidderResponseInfos.stream().map(BidderResponseInfo::getSeatBid).map(BidderSeatBidInfo::getBidsInfos).filter(CollectionUtils::isNotEmpty).flatMap(Collection::stream).collect(Collectors.toSet());
        Set winningBidInfos = targeting == null ? null : bidInfos.stream().filter(bidInfo -> bidInfo.getTargetingInfo().isWinningBid()).collect(Collectors.toSet());
        BidResponseCreator.updateSentToClientTxnLog((TxnLog)txnLog, bidInfos);
        Set bidsToCache = cacheInfo.isShouldCacheWinningBidsOnly() ? winningBidInfos : bidInfos;
        return this.cacheBids(bidsToCache, auctionContext, cacheInfo, eventsContext).map(cacheResult -> this.toBidResponse(bidderResponseInfos, auctionContext, targeting, cacheInfo, cacheResult, videoStoredDataResult, eventsContext));
    }

    private static ExtRequestTargeting targeting(BidRequest bidRequest) {
        ExtRequest ext = bidRequest.getExt();
        ExtRequestPrebid prebid = ext != null ? ext.getPrebid() : null;
        return prebid != null ? prebid.getTargeting() : null;
    }

    private static boolean preferDeals(ExtRequestTargeting targeting) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)(targeting != null ? targeting.getPreferdeals() : null), (boolean)false);
    }

    private List<BidderResponseInfo> toBidderResponseWithTargetingBidInfos(List<BidderResponseInfo> bidderResponses, Map<String, MultiBidConfig> bidderToMultiBids, boolean preferDeals, TxnLog txnLog) {
        Map bidderResponseToReducedBidInfos = bidderResponses.stream().collect(Collectors.toMap(Function.identity(), bidderResponse -> this.toSortedMultiBidInfo(bidderResponse, bidderToMultiBids, preferDeals)));
        Map<String, Map<String, List<BidInfo>>> impIdToBidderToBidInfos = bidderResponseToReducedBidInfos.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(bidInfo -> bidInfo.getCorrespondingImp().getId(), Collectors.groupingBy(BidInfo::getBidder)));
        HashSet winningBids = new HashSet();
        HashSet winningBidsByBidder = new HashSet();
        for (Map<String, List<BidInfo>> bidderToBidInfos : impIdToBidderToBidInfos.values()) {
            bidderToBidInfos.values().forEach(winningBidsByBidder::addAll);
            bidderToBidInfos.values().stream().flatMap(Collection::stream).max(this.winningBidComparatorFactory.create(preferDeals)).ifPresent(winningBids::add);
        }
        Map<String, Set> impIdToLineItemIds = impIdToBidderToBidInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, impIdToBidderToBidInfoEntry -> BidResponseCreator.toLineItemIds(((Map)impIdToBidderToBidInfoEntry.getValue()).values())));
        BidResponseCreator.updateTopMatchAndLostAuctionLineItemsMetric(winningBids, (TxnLog)txnLog, impIdToLineItemIds);
        return bidderResponseToReducedBidInfos.entrySet().stream().map(responseToBidInfos -> BidResponseCreator.injectBidInfoWithTargeting((BidderResponseInfo)((BidderResponseInfo)responseToBidInfos.getKey()), (List)((List)responseToBidInfos.getValue()), (Map)bidderToMultiBids, (Set)winningBids, (Set)winningBidsByBidder)).toList();
    }

    private List<BidInfo> toSortedMultiBidInfo(BidderResponseInfo bidderResponse, Map<String, MultiBidConfig> bidderToMultiBids, boolean preferDeals) {
        List bidInfos = bidderResponse.getSeatBid().getBidsInfos();
        Map<String, List<BidInfo>> impIdToBidInfos = bidInfos.stream().collect(Collectors.groupingBy(bidInfo -> bidInfo.getCorrespondingImp().getId()));
        MultiBidConfig multiBid = bidderToMultiBids.get(bidderResponse.getBidder());
        Integer bidLimit = multiBid != null ? multiBid.getMaxBids() : DEFAULT_BID_LIMIT_MIN;
        return impIdToBidInfos.values().stream().map(infos -> this.sortReducedBidInfo(infos, bidLimit.intValue(), preferDeals)).flatMap(Collection::stream).toList();
    }

    private List<BidInfo> sortReducedBidInfo(List<BidInfo> bidInfos, int limit, boolean preferDeals) {
        return bidInfos.stream().sorted(this.winningBidComparatorFactory.create(preferDeals).reversed()).limit(limit).toList();
    }

    private static Set<String> toLineItemIds(Collection<List<BidInfo>> bidInfos) {
        return bidInfos.stream().flatMap(Collection::stream).map(BidInfo::getLineItemId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static void updateTopMatchAndLostAuctionLineItemsMetric(Set<BidInfo> winningBidInfos, TxnLog txnLog, Map<String, Set<String>> impToLineItemIds) {
        for (BidInfo winningBidInfo : winningBidInfos) {
            String winningLineItemId = winningBidInfo.getLineItemId();
            if (winningLineItemId == null) continue;
            txnLog.lineItemSentToClientAsTopMatch().add(winningLineItemId);
            String impIdOfWinningBid = winningBidInfo.getBid().getImpid();
            impToLineItemIds.get(impIdOfWinningBid).stream().filter(lineItemId -> !Objects.equals(lineItemId, winningLineItemId)).forEach(lineItemId -> ((Set)txnLog.lostAuctionToLineItems().get(lineItemId)).add(winningLineItemId));
        }
    }

    private static BidderResponseInfo injectBidInfoWithTargeting(BidderResponseInfo bidderResponseInfo, List<BidInfo> bidderBidInfos, Map<String, MultiBidConfig> bidderToMultiBids, Set<BidInfo> winningBids, Set<BidInfo> winningBidsByBidder) {
        String bidder = bidderResponseInfo.getBidder();
        List bidInfosWithTargeting = BidResponseCreator.toBidInfoWithTargeting(bidderBidInfos, (String)bidder, bidderToMultiBids, winningBids, winningBidsByBidder);
        BidderSeatBidInfo seatBid = bidderResponseInfo.getSeatBid();
        BidderSeatBidInfo modifiedSeatBid = seatBid.with(bidInfosWithTargeting);
        return bidderResponseInfo.with(modifiedSeatBid);
    }

    private static List<BidInfo> toBidInfoWithTargeting(List<BidInfo> bidderBidInfos, String bidder, Map<String, MultiBidConfig> bidderToMultiBids, Set<BidInfo> winningBids, Set<BidInfo> winningBidsByBidder) {
        Map<String, List<BidInfo>> impIdToBidInfos = bidderBidInfos.stream().collect(Collectors.groupingBy(bidInfo -> bidInfo.getCorrespondingImp().getId()));
        return impIdToBidInfos.values().stream().map(bidInfos -> BidResponseCreator.injectTargeting((List)bidInfos, (String)bidder, (Map)bidderToMultiBids, (Set)winningBids, (Set)winningBidsByBidder)).flatMap(Collection::stream).toList();
    }

    private static List<BidInfo> injectTargeting(List<BidInfo> bidderImpIdBidInfos, String bidder, Map<String, MultiBidConfig> bidderToMultiBids, Set<BidInfo> winningBids, Set<BidInfo> winningBidsByBidder) {
        ArrayList<BidInfo> result = new ArrayList<BidInfo>();
        MultiBidConfig multiBid = bidderToMultiBids.get(bidder);
        String bidderCodePrefix = multiBid != null ? multiBid.getTargetBidderCodePrefix() : null;
        int multiBidSize = bidderImpIdBidInfos.size();
        for (int i = 0; i < multiBidSize; ++i) {
            boolean isFirstBid;
            boolean bl = isFirstBid = i == 0;
            String targetingBidderCode = isFirstBid ? bidder : (bidderCodePrefix == null ? null : bidderCodePrefix + (i + 1));
            BidInfo bidInfo = bidderImpIdBidInfos.get(i);
            TargetingInfo targetingInfo = TargetingInfo.builder().isTargetingEnabled(targetingBidderCode != null).isBidderWinningBid(winningBidsByBidder.contains(bidInfo)).isWinningBid(winningBids.contains(bidInfo)).isAddTargetBidderCode(targetingBidderCode != null && multiBidSize > 1).bidderCode(targetingBidderCode).build();
            BidInfo modifiedBidInfo = bidInfo.toBuilder().targetingInfo(targetingInfo).build();
            result.add(modifiedBidInfo);
        }
        return result;
    }

    private static void updateSentToClientTxnLog(TxnLog txnLog, Set<BidInfo> bidInfos) {
        bidInfos.stream().map(BidInfo::getLineItemId).filter(Objects::nonNull).forEach(lineItemId -> txnLog.lineItemsSentToClient().add(lineItemId));
    }

    private ExtBidResponse toExtBidResponse(List<BidderResponseInfo> bidderResponseInfos, AuctionContext auctionContext, CacheServiceResult cacheResult, VideoStoredDataResult videoStoredDataResult, long auctionTimestamp, Map<String, List<ExtBidderError>> bidErrors) {
        DebugContext debugContext = auctionContext.getDebugContext();
        boolean debugEnabled = debugContext.isDebugEnabled();
        ExtResponseDebug extResponseDebug = BidResponseCreator.toExtResponseDebug(bidderResponseInfos, (AuctionContext)auctionContext, (CacheServiceResult)cacheResult, (boolean)debugEnabled);
        Map errors = this.toExtBidderErrors(bidderResponseInfos, auctionContext, cacheResult, videoStoredDataResult, bidErrors);
        Map warnings = BidResponseCreator.toExtBidderWarnings(bidderResponseInfos, (AuctionContext)auctionContext);
        Map responseTimeMillis = BidResponseCreator.toResponseTimes(bidderResponseInfos, (CacheServiceResult)cacheResult);
        ExtBidResponseFledge extBidResponseFledge = this.toExtBidResponseFledge(bidderResponseInfos, auctionContext);
        ExtBidResponsePrebid prebid = this.toExtBidResponsePrebid(auctionTimestamp, auctionContext.getBidRequest(), extBidResponseFledge);
        return ExtBidResponse.builder().debug(extResponseDebug).errors(errors).warnings(warnings).responsetimemillis(responseTimeMillis).tmaxrequest(auctionContext.getBidRequest().getTmax()).prebid(prebid).build();
    }

    private ExtBidResponsePrebid toExtBidResponsePrebid(long auctionTimestamp, BidRequest bidRequest, ExtBidResponseFledge extBidResponseFledge) {
        JsonNode passThrough = Optional.ofNullable(bidRequest).map(BidRequest::getExt).map(ExtRequest::getPrebid).map(ExtRequestPrebid::getPassthrough).orElse(null);
        return ExtBidResponsePrebid.builder().auctiontimestamp(Long.valueOf(auctionTimestamp)).passthrough(passThrough).fledge(extBidResponseFledge).build();
    }

    private ExtBidResponseFledge toExtBidResponseFledge(List<BidderResponseInfo> bidderResponseInfos, AuctionContext auctionContext) {
        List imps = auctionContext.getBidRequest().getImp();
        List fledgeConfigs = bidderResponseInfos.stream().flatMap(bidderResponseInfo -> this.fledgeConfigsForBidder(bidderResponseInfo, imps)).toList();
        return !fledgeConfigs.isEmpty() ? ExtBidResponseFledge.of(fledgeConfigs) : null;
    }

    private Stream<FledgeAuctionConfig> fledgeConfigsForBidder(BidderResponseInfo bidderResponseInfo, List<Imp> imps) {
        return Optional.ofNullable(bidderResponseInfo.getSeatBid().getFledgeAuctionConfigs()).stream().flatMap(Collection::stream).filter(fledgeConfig -> this.validateFledgeConfig(fledgeConfig, imps)).map(fledgeConfig -> BidResponseCreator.fledgeConfigWithBidder((FledgeAuctionConfig)fledgeConfig, (String)bidderResponseInfo.getBidder()));
    }

    private boolean validateFledgeConfig(FledgeAuctionConfig fledgeAuctionConfig, List<Imp> imps) {
        ExtImpAuctionEnvironment fledgeEnabled = BidResponseCreator.correspondingImp((String)fledgeAuctionConfig.getImpId(), imps).map(Imp::getExt).map(ext -> (ExtImpAuctionEnvironment)this.convertValue((JsonNode)ext, "ae", ExtImpAuctionEnvironment.class)).orElse(ExtImpAuctionEnvironment.SERVER_SIDE_AUCTION);
        return fledgeEnabled == ExtImpAuctionEnvironment.ON_DEVICE_IG_AUCTION_FLEDGE;
    }

    private static FledgeAuctionConfig fledgeConfigWithBidder(FledgeAuctionConfig fledgeConfig, String bidderName) {
        return fledgeConfig.toBuilder().bidder(bidderName).adapter(bidderName).build();
    }

    private static ExtResponseDebug toExtResponseDebug(List<BidderResponseInfo> bidderResponseInfos, AuctionContext auctionContext, CacheServiceResult cacheResult, boolean debugEnabled) {
        Map httpCalls = debugEnabled ? BidResponseCreator.toExtHttpCalls(bidderResponseInfos, (CacheServiceResult)cacheResult, (Map)auctionContext.getDebugHttpCalls()) : null;
        BidRequest bidRequest = debugEnabled ? auctionContext.getBidRequest() : null;
        ExtDebugPgmetrics extDebugPgmetrics = debugEnabled ? BidResponseCreator.toExtDebugPgmetrics((TxnLog)auctionContext.getTxnLog()) : null;
        ExtDebugTrace extDebugTrace = BidResponseCreator.toExtDebugTrace((AuctionContext)auctionContext);
        return ObjectUtils.anyNotNull((Object[])new Object[]{httpCalls, bidRequest, extDebugPgmetrics, extDebugTrace}) ? ExtResponseDebug.of((Map)httpCalls, (BidRequest)bidRequest, (ExtDebugPgmetrics)extDebugPgmetrics, (ExtDebugTrace)extDebugTrace) : null;
    }

    private Future<CacheServiceResult> cacheBids(Set<BidInfo> bidsToCache, AuctionContext auctionContext, BidRequestCacheInfo cacheInfo, EventsContext eventsContext) {
        if (!cacheInfo.isDoCaching()) {
            return Future.succeededFuture((Object)CacheServiceResult.of(null, null, (Map)BidResponseCreator.toMapBidsWithEmptyCacheIds(bidsToCache)));
        }
        List<BidInfo> bidsValidToBeCached = bidsToCache.stream().filter(BidResponseCreator::isValidForCaching).toList();
        CacheContext cacheContext = CacheContext.builder().cacheBidsTtl(cacheInfo.getCacheBidsTtl()).cacheVideoBidsTtl(cacheInfo.getCacheVideoBidsTtl()).shouldCacheBids(cacheInfo.isShouldCacheBids()).shouldCacheVideoBids(cacheInfo.isShouldCacheVideoBids()).build();
        return this.cacheService.cacheBidsOpenrtb(bidsValidToBeCached, auctionContext, cacheContext, eventsContext).map(cacheResult -> BidResponseCreator.addNotCachedBids((CacheServiceResult)cacheResult, (Set)bidsToCache));
    }

    private static boolean isValidForCaching(BidInfo bidInfo) {
        Bid bid = bidInfo.getBid();
        BigDecimal price = bid.getPrice();
        return bid.getDealid() != null ? price.compareTo(BigDecimal.ZERO) >= 0 : price.compareTo(BigDecimal.ZERO) > 0;
    }

    private static Map<Bid, CacheInfo> toMapBidsWithEmptyCacheIds(Set<BidInfo> bids) {
        return bids.stream().map(BidInfo::getBid).collect(Collectors.toMap(Function.identity(), ignored -> CacheInfo.empty()));
    }

    private static CacheServiceResult addNotCachedBids(CacheServiceResult cacheResult, Set<BidInfo> bidInfos) {
        Map bidToCacheId = cacheResult.getCacheBids();
        if (bidInfos.size() > bidToCacheId.size()) {
            HashMap<Bid, CacheInfo> updatedBidToCacheInfo = new HashMap<Bid, CacheInfo>(bidToCacheId);
            for (BidInfo bidInfo : bidInfos) {
                Bid bid = bidInfo.getBid();
                if (updatedBidToCacheInfo.containsKey(bid)) continue;
                updatedBidToCacheInfo.put(bid, CacheInfo.empty());
            }
            return CacheServiceResult.of((DebugHttpCall)cacheResult.getHttpCall(), (Throwable)cacheResult.getError(), updatedBidToCacheInfo);
        }
        return cacheResult;
    }

    private static Map<String, List<ExtHttpCall>> toExtHttpCalls(List<BidderResponseInfo> bidderResponses, CacheServiceResult cacheResult, Map<String, List<DebugHttpCall>> contextHttpCalls) {
        Map<String, List> bidderHttpCalls = bidderResponses.stream().filter(bidderResponse -> CollectionUtils.isNotEmpty((Collection)bidderResponse.getSeatBid().getHttpCalls())).collect(Collectors.toMap(BidderResponseInfo::getBidder, bidderResponse -> bidderResponse.getSeatBid().getHttpCalls()));
        DebugHttpCall httpCall = cacheResult.getHttpCall();
        ExtHttpCall cacheExtHttpCall = httpCall != null ? BidResponseCreator.toExtHttpCall((DebugHttpCall)httpCall) : null;
        Map cacheHttpCalls = cacheExtHttpCall != null ? Collections.singletonMap("cache", Collections.singletonList(cacheExtHttpCall)) : Collections.emptyMap();
        Map<String, List> contextExtHttpCalls = contextHttpCalls.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, serviceToHttpCall -> ((List)serviceToHttpCall.getValue()).stream().map(BidResponseCreator::toExtHttpCall).toList()));
        HashMap<String, List<ExtHttpCall>> httpCalls = new HashMap<String, List<ExtHttpCall>>();
        httpCalls.putAll(bidderHttpCalls);
        httpCalls.putAll(cacheHttpCalls);
        httpCalls.putAll(contextExtHttpCalls);
        return httpCalls.isEmpty() ? null : httpCalls;
    }

    private static ExtHttpCall toExtHttpCall(DebugHttpCall debugHttpCall) {
        return ExtHttpCall.builder().uri(debugHttpCall.getRequestUri()).requestbody(debugHttpCall.getRequestBody()).status(debugHttpCall.getResponseStatus()).responsebody(debugHttpCall.getResponseBody()).requestheaders(debugHttpCall.getRequestHeaders()).build();
    }

    private static ExtDebugPgmetrics toExtDebugPgmetrics(TxnLog txnLog) {
        ExtDebugPgmetrics extDebugPgmetrics = ExtDebugPgmetrics.builder().matchedDomainTargeting(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsMatchedDomainTargeting())).matchedWholeTargeting(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsMatchedWholeTargeting())).matchedTargetingFcapped(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsMatchedTargetingFcapped())).matchedTargetingFcapLookupFailed(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsMatchedTargetingFcapLookupFailed())).readyToServe(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsReadyToServe())).pacingDeferred(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsPacingDeferred())).sentToBidder(BidResponseCreator.nullIfEmpty((Map)txnLog.lineItemsSentToBidder())).sentToBidderAsTopMatch(BidResponseCreator.nullIfEmpty((Map)txnLog.lineItemsSentToBidderAsTopMatch())).receivedFromBidder(BidResponseCreator.nullIfEmpty((Map)txnLog.lineItemsReceivedFromBidder())).responseInvalidated(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsResponseInvalidated())).sentToClient(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemsSentToClient())).sentToClientAsTopMatch(BidResponseCreator.nullIfEmpty((Set)txnLog.lineItemSentToClientAsTopMatch())).build();
        return extDebugPgmetrics.equals((Object)ExtDebugPgmetrics.EMPTY) ? null : extDebugPgmetrics;
    }

    private static ExtDebugTrace toExtDebugTrace(AuctionContext auctionContext) {
        ArrayList activityInfrastructureTrace;
        boolean activityInfrastructureTraceEnabled;
        DeepDebugLog deepDebugLog = auctionContext.getDeepDebugLog();
        boolean dealsTraceEnabled = deepDebugLog.isDeepDebugEnabled();
        boolean bl = activityInfrastructureTraceEnabled = auctionContext.getDebugContext().getTraceLevel() != null;
        if (!dealsTraceEnabled && !activityInfrastructureTraceEnabled) {
            return null;
        }
        List entries = dealsTraceEnabled ? deepDebugLog.entries() : null;
        List<ExtTraceDeal> dealsTrace = dealsTraceEnabled ? entries.stream().filter(extTraceDeal -> StringUtils.isEmpty((CharSequence)extTraceDeal.getLineItemId())).toList() : null;
        Map lineItemsTrace = dealsTraceEnabled ? entries.stream().filter(extTraceDeal -> StringUtils.isNotEmpty((CharSequence)extTraceDeal.getLineItemId())).collect(Collectors.groupingBy(ExtTraceDeal::getLineItemId, Collectors.toList())) : null;
        ArrayList arrayList = activityInfrastructureTrace = activityInfrastructureTraceEnabled ? new ArrayList(auctionContext.getActivityInfrastructure().debugTrace()) : null;
        return CollectionUtils.isNotEmpty((Collection)entries) || CollectionUtils.isNotEmpty(activityInfrastructureTrace) ? ExtDebugTrace.of(CollectionUtils.isEmpty(dealsTrace) ? null : dealsTrace, MapUtils.isEmpty(lineItemsTrace) ? null : lineItemsTrace, CollectionUtils.isEmpty(activityInfrastructureTrace) ? null : activityInfrastructureTrace) : null;
    }

    private Map<String, List<ExtBidderError>> toExtBidderErrors(List<BidderResponseInfo> bidderResponses, AuctionContext auctionContext, CacheServiceResult cacheResult, VideoStoredDataResult videoStoredDataResult, Map<String, List<ExtBidderError>> bidErrors) {
        HashMap<String, List<ExtBidderError>> errors = new HashMap<String, List<ExtBidderError>>();
        errors.putAll(BidResponseCreator.extractBidderErrors(bidderResponses));
        errors.putAll(this.extractDeprecatedBiddersErrors(auctionContext.getBidRequest()));
        errors.putAll(BidResponseCreator.extractPrebidErrors((VideoStoredDataResult)videoStoredDataResult, (AuctionContext)auctionContext));
        errors.putAll(BidResponseCreator.extractCacheErrors((CacheServiceResult)cacheResult));
        if (MapUtils.isNotEmpty(bidErrors)) {
            BidResponseCreator.addBidErrors(errors, bidErrors);
        }
        return errors.isEmpty() ? null : errors;
    }

    private static Map<String, List<ExtBidderError>> extractBidderErrors(Collection<BidderResponseInfo> bidderResponses) {
        return bidderResponses.stream().filter(bidderResponse -> CollectionUtils.isNotEmpty((Collection)bidderResponse.getSeatBid().getErrors())).collect(Collectors.toMap(BidderResponseInfo::getBidder, bidderResponse -> BidResponseCreator.errorsDetails((List)bidderResponse.getSeatBid().getErrors())));
    }

    private static Map<String, List<ExtBidderError>> extractBidderWarnings(Collection<BidderResponseInfo> bidderResponses) {
        return bidderResponses.stream().filter(bidderResponse -> CollectionUtils.isNotEmpty((Collection)bidderResponse.getSeatBid().getWarnings())).collect(Collectors.toMap(BidderResponseInfo::getBidder, bidderResponse -> BidResponseCreator.errorsDetails((List)bidderResponse.getSeatBid().getWarnings())));
    }

    private static List<ExtBidderError> errorsDetails(List<BidderError> errors) {
        return errors.stream().map(bidderError -> ExtBidderError.of((int)bidderError.getType().getCode(), (String)bidderError.getMessage(), (Set)BidResponseCreator.nullIfEmpty((Set)bidderError.getImpIds()))).collect(Collectors.toCollection(ArrayList::new));
    }

    private Map<String, List<ExtBidderError>> extractDeprecatedBiddersErrors(BidRequest bidRequest) {
        return bidRequest.getImp().stream().flatMap(imp -> Optional.ofNullable(imp.getExt()).flatMap(ext -> this.getExtPrebid(ext, ExtImpPrebid.class)).map(ExtImpPrebid::getBidder).map(ObjectNode::fieldNames).map(StreamUtil::asStream).orElseGet(Stream::empty)).distinct().filter(arg_0 -> ((BidderCatalog)this.bidderCatalog).isDeprecatedName(arg_0)).collect(Collectors.toMap(Function.identity(), bidder -> Collections.singletonList(ExtBidderError.of((int)BidderError.Type.bad_input.getCode(), (String)this.bidderCatalog.errorForDeprecatedName(bidder)))));
    }

    private static Map<String, List<ExtBidderError>> extractPrebidErrors(VideoStoredDataResult videoStoredDataResult, AuctionContext auctionContext) {
        List storedErrors = BidResponseCreator.extractStoredErrors((VideoStoredDataResult)videoStoredDataResult);
        List contextErrors = BidResponseCreator.extractContextErrors((AuctionContext)auctionContext);
        if (storedErrors.isEmpty() && contextErrors.isEmpty()) {
            return Collections.emptyMap();
        }
        List collectedErrors = Stream.concat(contextErrors.stream(), storedErrors.stream()).toList();
        return Collections.singletonMap("prebid", collectedErrors);
    }

    private static List<ExtBidderError> extractStoredErrors(VideoStoredDataResult videoStoredDataResult) {
        List errors = videoStoredDataResult.getErrors();
        if (CollectionUtils.isNotEmpty((Collection)errors)) {
            return errors.stream().map(message -> ExtBidderError.of((int)BidderError.Type.generic.getCode(), (String)message)).toList();
        }
        return Collections.emptyList();
    }

    private static List<ExtBidderError> extractContextErrors(AuctionContext auctionContext) {
        return auctionContext.getPrebidErrors().stream().map(message -> ExtBidderError.of((int)BidderError.Type.generic.getCode(), (String)message)).toList();
    }

    private static Map<String, List<ExtBidderError>> extractCacheErrors(CacheServiceResult cacheResult) {
        Throwable error = cacheResult.getError();
        if (error != null) {
            ExtBidderError extBidderError = ExtBidderError.of((int)BidderError.Type.generic.getCode(), (String)error.getMessage());
            return Collections.singletonMap("cache", Collections.singletonList(extBidderError));
        }
        return Collections.emptyMap();
    }

    private static void addBidErrors(Map<String, List<ExtBidderError>> errors, Map<String, List<ExtBidderError>> bidErrors) {
        for (Map.Entry<String, List<ExtBidderError>> errorEntry : bidErrors.entrySet()) {
            List<ExtBidderError> extBidderErrors = errors.get(errorEntry.getKey());
            if (extBidderErrors != null) {
                extBidderErrors.addAll((Collection<ExtBidderError>)errorEntry.getValue());
                continue;
            }
            errors.put(errorEntry.getKey(), errorEntry.getValue());
        }
    }

    private static Map<String, List<ExtBidderError>> toExtBidderWarnings(List<BidderResponseInfo> bidderResponses, AuctionContext auctionContext) {
        HashMap<String, List<ExtBidderError>> warnings = new HashMap<String, List<ExtBidderError>>();
        warnings.putAll(BidResponseCreator.extractContextWarnings((AuctionContext)auctionContext));
        warnings.putAll(BidResponseCreator.extractBidderWarnings(bidderResponses));
        return warnings.isEmpty() ? null : warnings;
    }

    private static Map<String, List<ExtBidderError>> extractContextWarnings(AuctionContext auctionContext) {
        List<ExtBidderError> contextWarnings = auctionContext.getDebugWarnings().stream().map(message -> ExtBidderError.of((int)BidderError.Type.generic.getCode(), (String)message)).toList();
        return contextWarnings.isEmpty() ? Collections.emptyMap() : Collections.singletonMap("prebid", contextWarnings);
    }

    private static Map<String, Integer> toResponseTimes(Collection<BidderResponseInfo> bidderResponses, CacheServiceResult cacheResult) {
        Integer cacheResponseTime;
        Map<String, Integer> responseTimeMillis = bidderResponses.stream().collect(Collectors.toMap(BidderResponseInfo::getBidder, BidderResponseInfo::getResponseTime));
        DebugHttpCall debugHttpCall = cacheResult.getHttpCall();
        Integer n = cacheResponseTime = debugHttpCall != null ? debugHttpCall.getResponseTimeMillis() : null;
        if (cacheResponseTime != null) {
            responseTimeMillis.put("cache", cacheResponseTime);
        }
        return responseTimeMillis;
    }

    private BidResponse toBidResponse(List<BidderResponseInfo> bidderResponseInfos, AuctionContext auctionContext, ExtRequestTargeting targeting, BidRequestCacheInfo requestCacheInfo, CacheServiceResult cacheResult, VideoStoredDataResult videoStoredDataResult, EventsContext eventsContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        Account account = auctionContext.getAccount();
        HashMap bidErrors = new HashMap();
        List<SeatBid> seatBids = bidderResponseInfos.stream().map(BidderResponseInfo::getSeatBid).map(BidderSeatBidInfo::getBidsInfos).filter(CollectionUtils::isNotEmpty).map(bidInfos -> this.toSeatBid(bidInfos, targeting, bidRequest, requestCacheInfo, cacheResult.getCacheBids(), account, bidErrors)).toList();
        Long auctionTimestamp = eventsContext.getAuctionTimestamp();
        ExtBidResponse extBidResponse = this.toExtBidResponse(bidderResponseInfos, auctionContext, cacheResult, videoStoredDataResult, auctionTimestamp.longValue(), bidErrors);
        CachedDebugLog cachedDebugLog = auctionContext.getCachedDebugLog();
        if (BidResponseCreator.isCachedDebugEnabled((CachedDebugLog)cachedDebugLog)) {
            cachedDebugLog.setExtBidResponse(extBidResponse);
        }
        return BidResponse.builder().id(bidRequest.getId()).cur((String)bidRequest.getCur().get(0)).seatbid(seatBids).ext(extBidResponse).build();
    }

    private Future<VideoStoredDataResult> videoStoredDataResult(AuctionContext auctionContext) {
        List imps = auctionContext.getBidRequest().getImp();
        String accountId = auctionContext.getAccount().getId();
        Timeout timeout = auctionContext.getTimeout();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<Imp> storedVideoInjectableImps = new ArrayList<Imp>();
        for (Imp imp : imps) {
            try {
                if (!this.checkEchoVideoAttrs(imp)) continue;
                storedVideoInjectableImps.add(imp);
            }
            catch (InvalidRequestException e) {
                errors.add(e.getMessage());
            }
        }
        return this.storedRequestProcessor.videoStoredDataResult(accountId, storedVideoInjectableImps, errors, timeout).otherwise(throwable -> VideoStoredDataResult.of(Collections.emptyMap(), Collections.singletonList(throwable.getMessage())));
    }

    private boolean checkEchoVideoAttrs(Imp imp) {
        if (imp.getExt() != null) {
            try {
                ExtImp extImp = (ExtImp)this.mapper.mapper().treeToValue((TreeNode)imp.getExt(), ExtImp.class);
                ExtImpPrebid prebid = extImp.getPrebid();
                ExtOptions options = prebid != null ? prebid.getOptions() : null;
                Boolean echoVideoAttrs = options != null ? options.getEchoVideoAttrs() : null;
                return BooleanUtils.toBoolean((Boolean)echoVideoAttrs);
            }
            catch (JsonProcessingException e) {
                throw new InvalidRequestException("Incorrect Imp extension format for Imp with id " + imp.getId() + ": " + e.getMessage());
            }
        }
        return false;
    }

    private SeatBid toSeatBid(List<BidInfo> bidInfos, ExtRequestTargeting targeting, BidRequest bidRequest, BidRequestCacheInfo requestCacheInfo, Map<Bid, CacheInfo> bidToCacheInfo, Account account, Map<String, List<ExtBidderError>> bidErrors) {
        String bidder = bidInfos.stream().map(BidInfo::getBidder).findFirst().orElseThrow(() -> new IllegalArgumentException("Bidder was not defined for bidInfo"));
        List<Bid> bids = bidInfos.stream().map(bidInfo -> this.injectAdmWithCacheInfo(bidInfo, requestCacheInfo, bidToCacheInfo, bidErrors)).filter(Objects::nonNull).map(bidInfo -> this.toBid(bidInfo, targeting, bidRequest, account)).filter(Objects::nonNull).toList();
        return SeatBid.builder().seat(bidder).bid(bids).group(Integer.valueOf(0)).build();
    }

    private BidInfo injectAdmWithCacheInfo(BidInfo bidInfo, BidRequestCacheInfo requestCacheInfo, Map<Bid, CacheInfo> bidsWithCacheIds, Map<String, List<ExtBidderError>> bidErrors) {
        Bid bid = bidInfo.getBid();
        BidType bidType = bidInfo.getBidType();
        String bidder = bidInfo.getBidder();
        Imp correspondingImp = bidInfo.getCorrespondingImp();
        CacheInfo cacheInfo = bidsWithCacheIds.get(bid);
        String cacheId = cacheInfo != null ? cacheInfo.getCacheId() : null;
        String videoCacheId = cacheInfo != null ? cacheInfo.getVideoCacheId() : null;
        String modifiedBidAdm = bid.getAdm();
        if (videoCacheId != null && !requestCacheInfo.isReturnCreativeVideoBids() || cacheId != null && !requestCacheInfo.isReturnCreativeBids()) {
            modifiedBidAdm = null;
        }
        if (bidType.equals((Object)BidType.xNative) && modifiedBidAdm != null) {
            try {
                modifiedBidAdm = this.createNativeMarkup(modifiedBidAdm, correspondingImp);
            }
            catch (PreBidException e) {
                bidErrors.computeIfAbsent(bidder, ignored -> new ArrayList()).add(ExtBidderError.of((int)BidderError.Type.bad_server_response.getCode(), (String)e.getMessage()));
                return null;
            }
        }
        Bid modifiedBid = bid.toBuilder().adm(modifiedBidAdm).build();
        return bidInfo.toBuilder().bid(modifiedBid).cacheInfo(cacheInfo).build();
    }

    private Bid toBid(BidInfo bidInfo, ExtRequestTargeting targeting, BidRequest bidRequest, Account account) {
        Map targetingKeywords;
        TargetingInfo targetingInfo = bidInfo.getTargetingInfo();
        BidType bidType = bidInfo.getBidType();
        Bid bid = bidInfo.getBid();
        CacheInfo cacheInfo = bidInfo.getCacheInfo();
        String cacheId = cacheInfo != null ? cacheInfo.getCacheId() : null;
        String videoCacheId = cacheInfo != null ? cacheInfo.getVideoCacheId() : null;
        boolean isApp = bidRequest.getApp() != null;
        String bidderCode = targetingInfo.getBidderCode();
        if (targeting != null && targetingInfo.isTargetingEnabled() && targetingInfo.isBidderWinningBid()) {
            TargetingKeywordsCreator keywordsCreator = this.resolveKeywordsCreator(bidType, targeting, isApp, bidRequest, account);
            boolean isWinningBid = targetingInfo.isWinningBid();
            String categoryDuration = bidInfo.getCategory();
            targetingKeywords = keywordsCreator != null ? keywordsCreator.makeFor(bid, bidderCode, isWinningBid, cacheId, bidType.getName(), videoCacheId, categoryDuration) : null;
        } else {
            targetingKeywords = null;
        }
        CacheAsset bids = cacheId != null ? this.toCacheAsset(cacheId) : null;
        CacheAsset vastXml = videoCacheId != null ? this.toCacheAsset(videoCacheId) : null;
        ExtResponseCache cache = bids != null || vastXml != null ? ExtResponseCache.of((CacheAsset)bids, (CacheAsset)vastXml) : null;
        ObjectNode originalBidExt = bid.getExt();
        Boolean dealsTierSatisfied = bidInfo.getSatisfiedPriority();
        ExtBidPrebid updatedExtBidPrebid = this.getExtPrebid(originalBidExt, ExtBidPrebid.class).map(ExtBidPrebid::toBuilder).orElseGet(ExtBidPrebid::builder).targeting(MapUtils.isNotEmpty((Map)targetingKeywords) ? targetingKeywords : null).targetBidderCode(targetingInfo.isAddTargetBidderCode() ? bidderCode : null).dealTierSatisfied(dealsTierSatisfied).cache(cache).passThrough(this.extractPassThrough(bidInfo.getCorrespondingImp())).build();
        ObjectNode updatedBidExt = originalBidExt != null ? originalBidExt.deepCopy() : this.mapper.mapper().createObjectNode();
        updatedBidExt.set("prebid", this.mapper.mapper().valueToTree((Object)updatedExtBidPrebid));
        Integer ttl = cacheInfo != null ? (Integer)ObjectUtils.max((Comparable[])new Integer[]{cacheInfo.getTtl(), cacheInfo.getVideoTtl()}) : null;
        return bid.toBuilder().ext(updatedBidExt).exp(ttl).build();
    }

    private JsonNode extractPassThrough(Imp imp) {
        return Optional.ofNullable(imp.getExt()).flatMap(ext -> this.getExtPrebid(ext, ExtImpPrebid.class)).map(ExtImpPrebid::getPassthrough).orElse(null);
    }

    private String createNativeMarkup(String bidAdm, Imp correspondingImp) {
        Response nativeMarkup;
        try {
            nativeMarkup = (Response)this.mapper.decodeValue(bidAdm, Response.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage());
        }
        List responseAssets = nativeMarkup.getAssets();
        if (CollectionUtils.isNotEmpty((Collection)responseAssets)) {
            Request nativeRequest;
            Native nativeImp;
            Native native_ = nativeImp = correspondingImp != null ? correspondingImp.getXNative() : null;
            if (nativeImp == null) {
                throw new PreBidException("Could not find native imp");
            }
            try {
                nativeRequest = (Request)this.mapper.mapper().readValue(nativeImp.getRequest(), Request.class);
            }
            catch (JsonProcessingException e) {
                throw new PreBidException(e.getMessage());
            }
            responseAssets.forEach(asset -> BidResponseCreator.setAssetTypes((Asset)asset, (List)nativeRequest.getAssets()));
            return this.mapper.encodeToString((Object)nativeMarkup);
        }
        return bidAdm;
    }

    private static void setAssetTypes(Asset responseAsset, List<com.iab.openrtb.request.Asset> requestAssets) {
        Integer type;
        if (responseAsset.getImg() != null) {
            ImageObject img = BidResponseCreator.getAssetById((Integer)responseAsset.getId(), requestAssets).getImg();
            Integer n = type = img != null ? img.getType() : null;
            if (type != null) {
                responseAsset.getImg().setType(type);
            } else {
                Integer assetId = responseAsset.getId();
                throw new PreBidException("Response has an Image asset with ID:'%s' present that doesn't exist in the request".formatted(assetId != null ? assetId : ""));
            }
        }
        if (responseAsset.getData() != null) {
            DataObject data = BidResponseCreator.getAssetById((Integer)responseAsset.getId(), requestAssets).getData();
            Integer n = type = data != null ? data.getType() : null;
            if (type != null) {
                responseAsset.getData().setType(type);
            } else {
                throw new PreBidException("Response has a Data asset with ID:%s present that doesn't exist in the request".formatted(responseAsset.getId()));
            }
        }
    }

    private static com.iab.openrtb.request.Asset getAssetById(Integer assetId, List<com.iab.openrtb.request.Asset> requestAssets) {
        return requestAssets.stream().filter(asset -> Objects.equals(assetId, asset.getId())).findFirst().orElse(com.iab.openrtb.request.Asset.EMPTY);
    }

    private EventsContext createEventsContext(AuctionContext auctionContext) {
        return EventsContext.builder().auctionId(auctionContext.getBidRequest().getId()).enabledForAccount(BidResponseCreator.eventsEnabledForAccount((AuctionContext)auctionContext)).enabledForRequest(BidResponseCreator.eventsEnabledForRequest((AuctionContext)auctionContext)).auctionTimestamp(Long.valueOf(this.auctionTimestamp(auctionContext))).integration(BidResponseCreator.integrationFrom((AuctionContext)auctionContext)).build();
    }

    private static boolean eventsEnabledForAccount(AuctionContext auctionContext) {
        AccountAuctionConfig accountAuctionConfig = auctionContext.getAccount().getAuction();
        AccountEventsConfig accountEventsConfig = accountAuctionConfig != null ? accountAuctionConfig.getEvents() : null;
        Boolean accountEventsEnabled = accountEventsConfig != null ? accountEventsConfig.getEnabled() : null;
        return BooleanUtils.isTrue((Boolean)accountEventsEnabled);
    }

    private static boolean eventsEnabledForRequest(AuctionContext auctionContext) {
        return BidResponseCreator.eventsEnabledForChannel((AuctionContext)auctionContext) || BidResponseCreator.eventsAllowedByRequest((AuctionContext)auctionContext);
    }

    private static boolean eventsEnabledForChannel(AuctionContext auctionContext) {
        Map channelConfig = Optional.ofNullable(auctionContext.getAccount().getAnalytics()).map(AccountAnalyticsConfig::getAuctionEvents).map(AccountAuctionEventConfig::getEvents).orElseGet(AccountAnalyticsConfig::fallbackAuctionEvents);
        String channelFromRequest = BidResponseCreator.channelFromRequest((BidRequest)auctionContext.getBidRequest());
        return channelConfig.entrySet().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)channelFromRequest, (CharSequence)((CharSequence)entry.getKey()))).findFirst().map(entry -> BooleanUtils.isTrue((Boolean)((Boolean)entry.getValue()))).orElse(Boolean.FALSE);
    }

    private static String channelFromRequest(BidRequest bidRequest) {
        ExtRequest ext = bidRequest.getExt();
        ExtRequestPrebid prebid = ext != null ? ext.getPrebid() : null;
        ExtRequestPrebidChannel channel = prebid != null ? prebid.getChannel() : null;
        return channel != null ? BidResponseCreator.recogniseChannelName((String)channel.getName()) : null;
    }

    private static String recogniseChannelName(String channelName) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"pbjs", (CharSequence)channelName)) {
            return "web";
        }
        return channelName;
    }

    private static boolean eventsAllowedByRequest(AuctionContext auctionContext) {
        ExtRequest ext = auctionContext.getBidRequest().getExt();
        ExtRequestPrebid prebid = ext != null ? ext.getPrebid() : null;
        return prebid != null && prebid.getEvents() != null;
    }

    private long auctionTimestamp(AuctionContext auctionContext) {
        ExtRequest ext = auctionContext.getBidRequest().getExt();
        ExtRequestPrebid prebid = ext != null ? ext.getPrebid() : null;
        Long auctionTimestamp = prebid != null ? prebid.getAuctiontimestamp() : null;
        return auctionTimestamp != null ? auctionTimestamp.longValue() : this.clock.millis();
    }

    private static String integrationFrom(AuctionContext auctionContext) {
        ExtRequest ext = auctionContext.getBidRequest().getExt();
        ExtRequestPrebid prebid = ext != null ? ext.getPrebid() : null;
        return prebid != null ? prebid.getIntegration() : null;
    }

    private Events createEvents(String bidder, Account account, String bidId, EventsContext eventsContext, String lineItemId) {
        if (!eventsContext.isEnabledForAccount()) {
            return null;
        }
        return eventsContext.isEnabledForRequest() || StringUtils.isNotEmpty((CharSequence)lineItemId) ? this.eventsService.createEvent(bidId, bidder, account.getId(), lineItemId, eventsContext.isEnabledForRequest(), eventsContext) : null;
    }

    private TargetingKeywordsCreator resolveKeywordsCreator(BidType bidType, ExtRequestTargeting targeting, boolean isApp, BidRequest bidRequest, Account account) {
        Map keywordsCreatorByBidType = this.keywordsCreatorByBidType(targeting, isApp, bidRequest, account);
        return keywordsCreatorByBidType.getOrDefault(bidType, this.keywordsCreator(targeting, isApp, bidRequest, account));
    }

    private TargetingKeywordsCreator keywordsCreator(ExtRequestTargeting targeting, boolean isApp, BidRequest bidRequest, Account account) {
        JsonNode priceGranularityNode = targeting.getPricegranularity();
        return priceGranularityNode == null || priceGranularityNode.isNull() ? null : this.createKeywordsCreator(targeting, isApp, priceGranularityNode, bidRequest, account);
    }

    private Map<BidType, TargetingKeywordsCreator> keywordsCreatorByBidType(ExtRequestTargeting targeting, boolean isApp, BidRequest bidRequest, Account account) {
        ObjectNode xNative;
        boolean isNativeNull;
        ObjectNode video;
        boolean isVideoNull;
        boolean isBannerNull;
        ExtMediaTypePriceGranularity mediaTypePriceGranularity = targeting.getMediatypepricegranularity();
        if (mediaTypePriceGranularity == null) {
            return Collections.emptyMap();
        }
        EnumMap<BidType, TargetingKeywordsCreator> result = new EnumMap<BidType, TargetingKeywordsCreator>(BidType.class);
        ObjectNode banner = mediaTypePriceGranularity.getBanner();
        boolean bl = isBannerNull = banner == null || banner.isNull();
        if (!isBannerNull) {
            result.put(BidType.banner, this.createKeywordsCreator(targeting, isApp, (JsonNode)banner, bidRequest, account));
        }
        boolean bl2 = isVideoNull = (video = mediaTypePriceGranularity.getVideo()) == null || video.isNull();
        if (!isVideoNull) {
            result.put(BidType.video, this.createKeywordsCreator(targeting, isApp, (JsonNode)video, bidRequest, account));
        }
        boolean bl3 = isNativeNull = (xNative = mediaTypePriceGranularity.getXNative()) == null || xNative.isNull();
        if (!isNativeNull) {
            result.put(BidType.xNative, this.createKeywordsCreator(targeting, isApp, (JsonNode)xNative, bidRequest, account));
        }
        return result;
    }

    private TargetingKeywordsCreator createKeywordsCreator(ExtRequestTargeting targeting, boolean isApp, JsonNode priceGranularity, BidRequest bidRequest, Account account) {
        return TargetingKeywordsCreator.create((ExtPriceGranularity)this.parsePriceGranularity(priceGranularity), (boolean)BooleanUtils.toBoolean((Boolean)targeting.getIncludewinners()), (boolean)BooleanUtils.toBoolean((Boolean)targeting.getIncludebidderkeys()), (boolean)BooleanUtils.toBoolean((Boolean)targeting.getAlwaysincludedeals()), (boolean)BooleanUtils.isTrue((Boolean)targeting.getIncludeformat()), (boolean)isApp, (int)this.resolveTruncateAttrChars(targeting, account), (String)this.cacheHost, (String)this.cachePath, (TargetingKeywordsResolver)TargetingKeywordsResolver.create((BidRequest)bidRequest, (JacksonMapper)this.mapper));
    }

    private int resolveTruncateAttrChars(ExtRequestTargeting targeting, Account account) {
        AccountAuctionConfig accountAuctionConfig = account.getAuction();
        Integer accountTruncateTargetAttr = accountAuctionConfig != null ? accountAuctionConfig.getTruncateTargetAttr() : null;
        return (Integer)ObjectUtils.firstNonNull((Object[])new Integer[]{BidResponseCreator.truncateAttrCharsOrNull((Integer)targeting.getTruncateattrchars()), BidResponseCreator.truncateAttrCharsOrNull((Integer)accountTruncateTargetAttr), this.truncateAttrChars});
    }

    private static Integer truncateAttrCharsOrNull(Integer value) {
        return value != null && value >= 0 && value <= 255 ? value : null;
    }

    private static boolean isCachedDebugEnabled(CachedDebugLog cachedDebugLog) {
        return cachedDebugLog != null && cachedDebugLog.isEnabled();
    }

    private ExtPriceGranularity parsePriceGranularity(JsonNode priceGranularity) {
        try {
            return (ExtPriceGranularity)this.mapper.mapper().treeToValue((TreeNode)priceGranularity, ExtPriceGranularity.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding bidRequest.prebid.targeting.pricegranularity: " + e.getMessage(), (Throwable)e);
        }
    }

    private static BidResponse populateSeatNonBid(AuctionContext auctionContext, BidResponse bidResponse) {
        if (!auctionContext.getDebugContext().isShouldReturnAllBidStatuses()) {
            return bidResponse;
        }
        List<SeatNonBid> seatNonBids = auctionContext.getBidRejectionTrackers().entrySet().stream().map(entry -> BidResponseCreator.toSeatNonBid((String)((String)entry.getKey()), (BidRejectionTracker)((BidRejectionTracker)entry.getValue()))).filter(seatNonBid -> !seatNonBid.getNonBid().isEmpty()).toList();
        ExtBidResponse updatedExtBidResponse = Optional.ofNullable(bidResponse.getExt()).map(ExtBidResponse::toBuilder).orElseGet(ExtBidResponse::builder).seatnonbid(seatNonBids).build();
        return bidResponse.toBuilder().ext(updatedExtBidResponse).build();
    }

    private static SeatNonBid toSeatNonBid(String bidder, BidRejectionTracker bidRejectionTracker) {
        List<NonBid> nonBid = bidRejectionTracker.getRejectionReasons().entrySet().stream().map(entry -> NonBid.of((String)((String)entry.getKey()), (BidRejectionReason)((BidRejectionReason)entry.getValue()))).toList();
        return SeatNonBid.of((String)bidder, nonBid);
    }

    private CacheAsset toCacheAsset(String cacheId) {
        return CacheAsset.of((String)this.cacheAssetUrlTemplate.concat(cacheId), (String)cacheId);
    }

    private static <T> Set<T> nullIfEmpty(Set<T> set) {
        if (set.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> nullIfEmpty(Map<K, V> map) {
        if (map.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableMap(map);
    }

    private Optional<ExtBidPrebidVideo> getExtBidPrebidVideo(ObjectNode bidExt) {
        return this.getExtPrebid(bidExt, ExtBidPrebid.class).map(ExtBidPrebid::getVideo);
    }

    private <T> Optional<T> getExtPrebid(ObjectNode extNode, Class<T> extClass) {
        return Optional.ofNullable(extNode).filter(ext -> ext.hasNonNull("prebid")).map(ext -> this.convertValue((JsonNode)extNode, "prebid", extClass));
    }

    private <T> T convertValue(JsonNode jsonNode, String key, Class<T> typeClass) {
        try {
            return (T)this.mapper.mapper().convertValue((Object)jsonNode.get(key), typeClass);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }
}

