/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.analytics.reporter.pubstack;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.zip.GZIPOutputStream;
import org.prebid.server.analytics.reporter.pubstack.model.PubstackAnalyticsProperties;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class PubstackEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(PubstackEventHandler.class);
    private static final String SCOPE_FIELD_NAME = "scope";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String GZIP = "gzip";
    private static final String NEW_LINE = "\n";
    private volatile boolean enabled;
    private volatile String endpoint;
    private volatile String scopeId;
    private final long maxByteSize;
    private final long maxEventCount;
    private final long reportTtlMillis;
    private final long timeoutMs;
    private final Vertx vertx;
    private final JacksonMapper jacksonMapper;
    private final HttpClient httpClient;
    private final ReentrantLock lockOnSend;
    private final AtomicReference<Queue<String>> events;
    private final MultiMap headers;
    private final AtomicLong byteSize;
    private volatile long reportTimerId;

    public PubstackEventHandler(PubstackAnalyticsProperties pubstackAnalyticsProperties, boolean enabled, String endpoint, JacksonMapper jacksonMapper, HttpClient httpClient, Vertx vertx) {
        this.enabled = enabled;
        this.endpoint = HttpUtil.validateUrl((String)endpoint);
        this.scopeId = pubstackAnalyticsProperties.getScopeId();
        this.maxByteSize = pubstackAnalyticsProperties.getSizeBytes().intValue();
        this.maxEventCount = pubstackAnalyticsProperties.getCount().intValue();
        this.reportTtlMillis = pubstackAnalyticsProperties.getReportTtlMs();
        this.timeoutMs = pubstackAnalyticsProperties.getTimeoutMs();
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.vertx = Objects.requireNonNull(vertx);
        this.lockOnSend = new ReentrantLock();
        this.events = new AtomicReference(new ConcurrentLinkedQueue());
        this.headers = PubstackEventHandler.makeHeaders();
        this.byteSize = new AtomicLong();
        if (enabled) {
            this.reportTimerId = this.setReportTtlTimer();
        }
    }

    public <T> void handle(T event) {
        if (this.enabled) {
            this.buffer(event);
            this.reportEventsOnCondition(byteSize -> byteSize.get() > this.maxByteSize, (Object)this.byteSize);
            this.reportEventsOnCondition(eventsReference -> (long)((Queue)eventsReference.get()).size() > this.maxEventCount, (Object)this.events);
        }
    }

    public void reportEvents() {
        if (this.enabled) {
            this.reportEventsOnCondition(events -> ((Queue)events.get()).size() > 0, (Object)this.events);
        }
    }

    public void updateConfig(boolean enabled, String endpoint, String scopeId) {
        this.updateTimerOnEnabling(enabled);
        this.enabled = enabled;
        this.endpoint = endpoint;
        this.scopeId = scopeId;
    }

    private <T> void buffer(T event) {
        ObjectNode eventNode = (ObjectNode)this.jacksonMapper.mapper().valueToTree(event);
        eventNode.put("scope", this.scopeId);
        String jsonEvent = this.jacksonMapper.encodeToString((Object)eventNode);
        ((Queue)this.events.get()).add(jsonEvent);
        this.byteSize.getAndAdd(jsonEvent.getBytes().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> boolean reportEventsOnCondition(Predicate<T> conditionToSend, T conditionValue) {
        boolean requestWasSent = false;
        if (conditionToSend.test(conditionValue)) {
            this.lockOnSend.lock();
            try {
                if (conditionToSend.test(conditionValue)) {
                    requestWasSent = true;
                    this.sendEvents(this.events);
                }
            }
            catch (Exception exception) {
                logger.error((Object)"[pubstack] Failed to send analytics report to endpoint {0} with a reason {1}", new Object[]{this.endpoint, exception.getMessage()});
            }
            finally {
                this.lockOnSend.unlock();
            }
        }
        return requestWasSent;
    }

    private void sendEvents(AtomicReference<Queue<String>> events) {
        String url = HttpUtil.validateUrl((String)this.endpoint);
        Queue copyToSend = events.getAndSet(new ConcurrentLinkedQueue());
        this.resetReportEventsConditions();
        this.httpClient.request(HttpMethod.POST, url, this.headers, PubstackEventHandler.toGzippedBytes((Queue)copyToSend), this.timeoutMs).onComplete(arg_0 -> this.handleReportResponse(arg_0));
    }

    private void resetReportEventsConditions() {
        this.byteSize.set(0L);
        this.vertx.cancelTimer(this.reportTimerId);
        this.reportTimerId = this.setReportTtlTimer();
    }

    private static byte[] toGzippedBytes(Queue<String> events) {
        return PubstackEventHandler.gzip((String)String.join((CharSequence)"\n", events));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] gzip(String value) {
        try (ByteArrayOutputStream obj = new ByteArrayOutputStream();){
            byte[] byArray;
            try (GZIPOutputStream gzip = new GZIPOutputStream(obj);){
                gzip.write(value.getBytes(StandardCharsets.UTF_8));
                gzip.finish();
                byArray = obj.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new PreBidException("[pubstack] failed to compress, skip the events : " + e.getMessage());
        }
    }

    private void handleReportResponse(AsyncResult<HttpClientResponse> result) {
        if (result.failed()) {
            logger.error((Object)"[pubstack] Failed to send events to endpoint {0} with a reason: {1}", new Object[]{this.endpoint, result.cause().getMessage()});
        } else {
            HttpClientResponse httpClientResponse = (HttpClientResponse)result.result();
            int statusCode = httpClientResponse.getStatusCode();
            if (statusCode != HttpResponseStatus.OK.code()) {
                logger.error((Object)"[pubstack] Wrong code received {0} instead of 200", new Object[]{statusCode});
            }
        }
    }

    private long setReportTtlTimer() {
        return this.vertx.setTimer(this.reportTtlMillis, timerId -> this.sendOnTimer());
    }

    private void sendOnTimer() {
        boolean requestWasSent = this.reportEventsOnCondition(events -> ((Queue)events.get()).size() > 0, (Object)this.events);
        if (!requestWasSent) {
            this.setReportTtlTimer();
        }
    }

    private void updateTimerOnEnabling(boolean enabled) {
        if (this.enabled && !enabled) {
            this.vertx.cancelTimer(this.reportTimerId);
        } else if (!this.enabled && enabled) {
            this.reportTimerId = this.setReportTtlTimer();
        }
    }

    private static MultiMap makeHeaders() {
        return MultiMap.caseInsensitiveMultiMap().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/octet-stream").add(HttpHeaders.CONTENT_ENCODING, (CharSequence)"gzip");
    }
}

