/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.analytics.reporter.log;

import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import org.prebid.server.analytics.AnalyticsReporter;
import org.prebid.server.analytics.model.AmpEvent;
import org.prebid.server.analytics.model.AuctionEvent;
import org.prebid.server.analytics.model.CookieSyncEvent;
import org.prebid.server.analytics.model.NotificationEvent;
import org.prebid.server.analytics.model.SetuidEvent;
import org.prebid.server.analytics.model.VideoEvent;
import org.prebid.server.analytics.reporter.log.model.LogEvent;
import org.prebid.server.json.JacksonMapper;

public class LogAnalyticsReporter
implements AnalyticsReporter {
    public static final Logger logger = LoggerFactory.getLogger(LogAnalyticsReporter.class);
    private final JacksonMapper mapper;

    public LogAnalyticsReporter(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public <T> Future<Void> processEvent(T event) {
        LogEvent logEvent;
        if (event instanceof AmpEvent) {
            AmpEvent ampEvent = (AmpEvent)event;
            logEvent = LogEvent.of((String)"/openrtb2/amp", (Object)ampEvent.getBidResponse());
        } else if (event instanceof AuctionEvent) {
            AuctionEvent auctionEvent = (AuctionEvent)event;
            logEvent = LogEvent.of((String)"/openrtb2/auction", (Object)auctionEvent.getBidResponse());
        } else if (event instanceof CookieSyncEvent) {
            CookieSyncEvent cookieSyncEvent = (CookieSyncEvent)event;
            logEvent = LogEvent.of((String)"/cookie_sync", (Object)cookieSyncEvent.getBidderStatus());
        } else if (event instanceof NotificationEvent) {
            NotificationEvent notificationEvent = (NotificationEvent)event;
            logEvent = LogEvent.of((String)"/event", (Object)(notificationEvent.getType() + notificationEvent.getBidId()));
        } else if (event instanceof SetuidEvent) {
            SetuidEvent setuidEvent = (SetuidEvent)event;
            logEvent = LogEvent.of((String)"/setuid", (Object)(setuidEvent.getBidder() + ":" + setuidEvent.getUid() + ":" + setuidEvent.getSuccess()));
        } else if (event instanceof VideoEvent) {
            VideoEvent videoEvent = (VideoEvent)event;
            logEvent = LogEvent.of((String)"/openrtb2/video", (Object)videoEvent.getBidResponse());
        } else {
            logEvent = LogEvent.of((String)"unknown", null);
        }
        logger.debug((Object)this.mapper.encodeToString((Object)logEvent));
        return Future.succeededFuture();
    }

    public int vendorId() {
        return 0;
    }

    public String name() {
        return "logAnalytics";
    }
}

