/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.rule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.GeoActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.GpcActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.rule.AbstractMatchRule;
import org.prebid.server.activity.infrastructure.rule.GeoRule;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GeoRule
extends AbstractMatchRule
implements Loggable {
    private final Set<ComponentType> componentTypes;
    private final Set<String> componentNames;
    private final boolean sidsMatched;
    private final List<GeoCode> geoCodes;
    private final String gpc;
    private final boolean allowed;

    public GeoRule(Set<ComponentType> componentTypes, Set<String> componentNames, boolean sidsMatched, List<GeoCode> geoCodes, String gpc, boolean allowed) {
        this.componentTypes = componentTypes;
        this.componentNames = componentNames;
        this.sidsMatched = sidsMatched;
        this.geoCodes = geoCodes;
        this.gpc = gpc;
        this.allowed = allowed;
    }

    public boolean matches(ActivityInvocationPayload activityInvocationPayload) {
        return !(!this.sidsMatched || this.geoCodes != null && !this.matchesOneOfGeoCodes(activityInvocationPayload) || this.gpc != null && !this.matchesGpc(activityInvocationPayload) || this.componentTypes != null && !this.componentTypes.contains(activityInvocationPayload.componentType()) || this.componentNames != null && !this.componentNames.contains(activityInvocationPayload.componentName()));
    }

    private boolean matchesOneOfGeoCodes(ActivityInvocationPayload activityInvocationPayload) {
        if (activityInvocationPayload instanceof GeoActivityInvocationPayload) {
            GeoActivityInvocationPayload geoPayload = (GeoActivityInvocationPayload)activityInvocationPayload;
            return this.geoCodes.stream().anyMatch(geoCode -> GeoRule.matchesGeoCode((GeoCode)geoCode, (GeoActivityInvocationPayload)geoPayload));
        }
        return true;
    }

    private static boolean matchesGeoCode(GeoCode geoCode, GeoActivityInvocationPayload geoPayload) {
        String region = geoCode.getRegion();
        return StringUtils.equalsIgnoreCase((CharSequence)geoCode.getCountry(), (CharSequence)geoPayload.country()) && (region == null || StringUtils.equalsIgnoreCase((CharSequence)region, (CharSequence)geoPayload.region()));
    }

    private boolean matchesGpc(ActivityInvocationPayload activityInvocationPayload) {
        if (activityInvocationPayload instanceof GpcActivityInvocationPayload) {
            GpcActivityInvocationPayload gpcActivityInvocationPayload = (GpcActivityInvocationPayload)activityInvocationPayload;
            return this.gpc.equals(gpcActivityInvocationPayload.gpc());
        }
        return true;
    }

    public boolean allowed() {
        return this.allowed;
    }

    public JsonNode asLogEntry(ObjectMapper mapper) {
        return mapper.valueToTree((Object)new GeoRuleLogEntry(this.componentTypes, this.componentNames, this.sidsMatched, this.geoCodes, this.gpc, this.allowed));
    }
}

