/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.uscustomlogic;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.USCustomLogicDataSupplier;
import org.prebid.server.activity.infrastructure.privacy.uscustomlogic.USCustomLogicGppReader;

public class USCustomLogicDataSupplier
implements Supplier<Map<String, Object>> {
    private final USCustomLogicGppReader gppReader;

    private USCustomLogicDataSupplier(USCustomLogicGppReader gppReader) {
        this.gppReader = Objects.requireNonNull(gppReader);
    }

    public static USCustomLogicDataSupplier of(USCustomLogicGppReader gppReader) {
        return new USCustomLogicDataSupplier(gppReader);
    }

    @Override
    public Map<String, Object> get() {
        DataAggregator dataAggregator = new DataAggregator();
        dataAggregator.put("Version", this.gppReader.getVersion());
        dataAggregator.put("Gpc", this.gppReader.getGpc());
        dataAggregator.put("GpcSegmentType", this.gppReader.getGpcSegmentType());
        dataAggregator.put("GpcSegmentIncluded", this.gppReader.getGpcSegmentIncluded());
        dataAggregator.put("SaleOptOut", this.gppReader.getSaleOptOut());
        dataAggregator.put("SaleOptOutNotice", this.gppReader.getSaleOptOutNotice());
        dataAggregator.put("SharingNotice", this.gppReader.getSharingNotice());
        dataAggregator.put("SharingOptOut", this.gppReader.getSharingOptOut());
        dataAggregator.put("SharingOptOutNotice", this.gppReader.getSharingOptOutNotice());
        dataAggregator.put("TargetedAdvertisingOptOut", this.gppReader.getTargetedAdvertisingOptOut());
        dataAggregator.put("TargetedAdvertisingOptOutNotice", this.gppReader.getTargetedAdvertisingOptOutNotice());
        dataAggregator.put("SensitiveDataLimitUseNotice", this.gppReader.getSensitiveDataLimitUseNotice());
        dataAggregator.put("SensitiveDataProcessing", this.gppReader.getSensitiveDataProcessing());
        dataAggregator.put("SensitiveDataProcessingOptOutNotice", this.gppReader.getSensitiveDataProcessingOptOutNotice());
        dataAggregator.put("KnownChildSensitiveDataConsents", this.gppReader.getKnownChildSensitiveDataConsents());
        dataAggregator.put("PersonalDataConsents", this.gppReader.getPersonalDataConsents());
        dataAggregator.put("MspaCoveredTransaction", this.gppReader.getMspaCoveredTransaction());
        dataAggregator.put("MspaServiceProviderMode", this.gppReader.getMspaServiceProviderMode());
        dataAggregator.put("MspaOptOutOptionMode", this.gppReader.getMspaOptOutOptionMode());
        return dataAggregator.data();
    }
}

