/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.payload.impl;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.Regs;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.GeoActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.payload.GpcActivityInvocationPayload;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;

public final class BidRequestActivityInvocationPayload
implements GeoActivityInvocationPayload,
GpcActivityInvocationPayload {
    private final ActivityInvocationPayload componentInfo;
    private final BidRequest bidRequest;

    public String country() {
        return Optional.ofNullable(this.bidRequest.getDevice()).map(Device::getGeo).map(Geo::getCountry).orElse(null);
    }

    public String region() {
        return Optional.ofNullable(this.bidRequest.getDevice()).map(Device::getGeo).map(Geo::getRegion).orElse(null);
    }

    public String gpc() {
        return Optional.ofNullable(this.bidRequest.getRegs()).map(Regs::getExt).map(ExtRegs::getGpc).orElse(null);
    }

    @ConstructorProperties(value={"componentInfo", "bidRequest"})
    private BidRequestActivityInvocationPayload(ActivityInvocationPayload componentInfo, BidRequest bidRequest) {
        this.componentInfo = componentInfo;
        this.bidRequest = bidRequest;
    }

    public static BidRequestActivityInvocationPayload of(ActivityInvocationPayload componentInfo, BidRequest bidRequest) {
        return new BidRequestActivityInvocationPayload(componentInfo, bidRequest);
    }

    public ActivityInvocationPayload componentInfo() {
        return this.componentInfo;
    }

    public BidRequest bidRequest() {
        return this.bidRequest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BidRequestActivityInvocationPayload)) {
            return false;
        }
        BidRequestActivityInvocationPayload other = (BidRequestActivityInvocationPayload)o;
        ActivityInvocationPayload this$componentInfo = this.componentInfo();
        ActivityInvocationPayload other$componentInfo = other.componentInfo();
        if (this$componentInfo == null ? other$componentInfo != null : !this$componentInfo.equals(other$componentInfo)) {
            return false;
        }
        BidRequest this$bidRequest = this.bidRequest();
        BidRequest other$bidRequest = other.bidRequest();
        return !(this$bidRequest == null ? other$bidRequest != null : !this$bidRequest.equals(other$bidRequest));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ActivityInvocationPayload $componentInfo = this.componentInfo();
        result = result * 59 + ($componentInfo == null ? 43 : $componentInfo.hashCode());
        BidRequest $bidRequest = this.bidRequest();
        result = result * 59 + ($bidRequest == null ? 43 : $bidRequest.hashCode());
        return result;
    }

    public String toString() {
        return "BidRequestActivityInvocationPayload(componentInfo=" + this.componentInfo() + ", bidRequest=" + this.bidRequest() + ")";
    }

    public ComponentType componentType() {
        return this.componentInfo().componentType();
    }

    public String componentName() {
        return this.componentInfo().componentName();
    }
}

