<?php
require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_waterfall extends Plugins_InvocationTags
{
    /**
     * Return name of plugin
     *
     * @return string
     */
    function getName()
    {
        return $this->translate("VAST Waterfall");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */

    function getNameEN()
    {
        return 'Waterfall';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    function isAllowed($extra = null)
    {
        $isAllowed = parent::isAllowed($extra);
        return true;
    }

    function getOrder()
    {
        parent::getOrder();
        return 34;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */

    function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        $options = array(
            'vastversion' => 1,
            //'limit'         => MAX_PLUGINS_INVOCATION_TAGS_STANDARD
        );
        return $options;
    }

    function vastversion()
    {
        $maxInvocation = &$this->maxInvocation;
        $vastversion = (!empty($maxInvocation->position)) ?
            $maxInvocation->vastversion : $_POST['vastversion'];;

        $option = '';
        $option .= "<tr><td width='30'><img src='" . OX::assetPath() . "/images/spacer.gif' height='5' width='100%'></td></tr>";

        $option .= "<tr><td width='30'>&nbsp;</td>";
        $option .= "<td width='200'>Vast Version</td><td width='100'>";
        $option .= "<select name='vastversion' id='vastversion' selected>";
        $option .= " <option value='' disabled selected>Choose Version</option>";
        $option .= "<option value='waterfall'" . ($vastversion == 'waterfall' ? "selected='selected'" : '') . " style='width:250px;'>waterfall</option>
		 <option value='waterfall4'" . ($vastversion == 'waterfall4' ? "selected='selected'" : '') . " style='width:250px;' >waterfall 4</option>
		 <option value='waterfall41'" . ($vastversion == 'waterfall41' ? "selected='selected'" : '') . " style='width:250px;' >waterfall 4.1</option>
		&nbsp</td></tr>";
        $option .= "</select>";
        $option .= "<tr><td width='30'><img src='" . OX::assetPath() . "/images/spacer.gif' height='5' width='100%'></td></tr>";

        return $option;
    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    function generateInvocationCode()
    {
        $aComments = array(
            'SSL Delivery Comment' => '',
            'Comment'              => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
        );
        parent::prepareCommonInvocationData($aComments);
        $conf = $GLOBALS['_MAX']['CONF'];
        $mi = &$this->maxInvocation;
        $zoneid = $mi->zoneid;
        $limit = $mi->limit;

        $vastversion = $mi->vastversion;
        if ($_POST['vastversion'] != NULL) {
            $vastversion = $_POST['vastversion'];
        } else {
            $vastversion = "waterfall";
        }
        if ($GLOBALS['_MAX']['SSL_REQUEST']) {
            $djprotocol = 'https://';
        } else {
            $djprotocol = 'http://';
        }
        $way = $djprotocol . $conf['webpath']['deliverVastUrl'];
        if ($mi->dadposition == 1) {
            $vtype = 'preroll';
        } else if ($mi->dadposition == 2) {
            $vtype = 'midroll';
        } else if ($mi->dadposition == 3) {
            $vtype = 'postroll';
        } else {
            $vtype = 'postroll';
        }

        $api = $mi->apiframework;
        $iprog = $mi->iconprogram;

        if (!empty($mi->limit)) {
            $limit = '&limit=' . $mi->limit;
        }

        $buffer = $way . "/fc.php?script=rmVideo&zoneid=$zoneid&format=$vastversion"."$limit";
        return $buffer;
    }

    function setInvocation(&$invocation)
    {
        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;
    }
}
