<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/

/**
 * @package    OpenXPlugin
 * @subpackage InvocationTags
 * @author     Radek Maciaszek <radek@m3.net>
 *
 */

require_once LIB_PATH . '/Extension/invocationTags/InvocationTags.php';
require_once MAX_PATH . '/lib/max/Plugin/Translation.php';

/**
 *
 * Invocation tag plugin.
 *
 */
class Plugins_InvocationTags_OxInvocationTags_Lbanner extends Plugins_InvocationTags
{

    /**
     * Return name of plugin
     *s
     * @return string
     */
    function getName()
    {
        return $this->translate("L Banner Tag");
    }

    /**
     * Return the English name of the plugin. Used when
     * generating translation keys based on the plugin
     * name.
     *
     * @return string An English string describing the class.
     */
    function getNameEN()
    {
        return 'L Banner Tag';
    }

    /**
     * Check if plugin is allowed
     *
     * @return boolean  True - allowed, false - not allowed
     */
    function isAllowed($extra = null)
    {
        //$isAllowed = parent::isAllowed($extra);
        return true;
    }

    function getOrder()
    {
       // parent::getOrder();
        return 13;
    }

    /**
     * Return list of options
     *
     * @return array    Group of options
     */
    function getOptionsList()
    {
        if (is_array($this->defaultOptions)) {
            if (in_array('cacheBuster', $this->defaultOptions)) {
                unset($this->defaultOptions['cacheBuster']);
            }
        }
        $options = array (
            //~ 'spacer'      => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'what'          => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ //'clientid'      => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'refresh'     => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'campaignid'    => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'block'         => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'target'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'source'        => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'withtext'      => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'blockcampaign' => MAX_PLUGINS_INVOCATION_TAGS_STANDARD,
            //~ 'charset'       => MAX_PLUGINS_INVOCATION_TAGS_STANDARD
        );

        return $options;
    }

    /**
     * Return invocation code for this plugin (codetype)
     *
     * @return string
     */
    function generateInvocationCode()
    {
        $aComments = array(
            'SSL Delivery Comment' => '',
            'Comment'              => $this->translate("
  * This noscript section of this tag only shows image banners. There
  * is no width or height in these banners, so if you want these tags to
  * allocate space for the ad before it shows, you will need to add this
  * information to the <img> tag.
  *
  * If you do not want to deal with the intricities of the noscript
  * section, delete the tag (from <noscript>... to </noscript>). On
  * average, the noscript tag is called from less than 1% of internet
  * users."),
            );
        parent::prepareCommonInvocationData($aComments);

       
		

        
        // Support for 3rd party server clicktracking
       
        $conf = $GLOBALS['_MAX']['CONF'];
        $path = $conf['webpath']['deliverVastUrl'];


     
        
           $mi = &$this->maxInvocation;
	$zoneid=$mi->zoneid;

	if ($GLOBALS['_MAX']['SSL_REQUEST']) {
					$djprotocol='https://';
					}
					else
					{
					$djprotocol='http://';
					}
	$buffer=$djprotocol.$path."/api/request.php?zoneid=$zoneid&type=1";
	
	
        return $buffer;
    }

    function setInvocation(&$invocation) {
        $this->maxInvocation = &$invocation;
        $this->maxInvocation->canDetectCharset = true;
    }

}

?>
