package main

import (
	"context"
	"crypto/tls"
	"encoding/base64"
	"encoding/json"
	"encoding/xml"
	"fmt"
	"gocron"
	"gorilla/mux"
	"log"
	"net/http"
	"net/url"
	"ssp/ad"
	"ssp/clickClient"
	"ssp/clickConnect"
	"ssp/constants"
	"ssp/customapi"
	"ssp/logger"
	"ssp/redisClient"
	"ssp/validate"
	"ssp/vastxmlstructs"
	"strconv"
	"time"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

var redisclient = redisClient.Initialize()

// Home Function
func home(w http.ResponseWriter, r *http.Request) {

	html := `<html>
				<title>Golang SSP API</title>    
				<body>
					<h1>` + `Golang SSP API` + `</h1>
				</body>
			</html>`
	w.Write([]byte(fmt.Sprintf(html)))
}

// Home Function
func validataion(w http.ResponseWriter, r *http.Request) {
	html := `loaderio-492353c0ec8629e10bc4d816e68b7e76`
	w.Write([]byte(fmt.Sprintf(html)))
}

// Function for calculating request elapsed time
func elapsed(what string) func() {
	start := time.Now()
	return func() {
		log.Printf("%s took %v\n", what, time.Since(start))
	}
}

// Function for processing incoming request
func processRequest(w http.ResponseWriter, r *http.Request) {

	ResponseArray := make(map[string]interface{})
	RequestArray := &customapi.CustomRequest{}

	// create header
	w.Header().Add("Content-Type", "application/json")

	err := json.NewDecoder(r.Body).Decode(&RequestArray)

	if err != nil {
		ResponseArray["message"] = "Request Error"
		w.WriteHeader(http.StatusBadRequest)
		json.NewEncoder(w).Encode(ResponseArray)
		return
	}

	ResponseArray, err = getAD(RequestArray)

	//~ return

	if err != nil {
		ResponseArray["message"] = err.Error()
		w.WriteHeader(http.StatusBadRequest)
		json.NewEncoder(w).Encode(ResponseArray)
		return
	} else {
		w.WriteHeader(http.StatusOK)
		json.NewEncoder(w).Encode(ResponseArray)
		return
	}
}

// Function for getting AD
func getAD(RequestArray *customapi.CustomRequest) (map[string]interface{}, error) {
	Channel := make(chan map[string]interface{})
	ResponseArray := make(map[string]interface{})
	ErrorArray := validate.ValidateRequest(RequestArray)

	if len(ErrorArray) == 0 {
		go ad.Ssp_adprocessing(Channel, RequestArray, redisclient)
		ResponseArray = <-Channel
		return ResponseArray, nil
	} else {
		return ResponseArray, ErrorArray[0]
	}
}

// Function for processing Win Notice request
func processWinnotice(w http.ResponseWriter, r *http.Request) {
	//~ id := r.URL.Query().Get("id")
	//~ bidderid := r.URL.Query().Get("bidderid")
	nurl, err := base64.StdEncoding.DecodeString(r.URL.Query().Get("nurl"))
	if err != nil {
		logger.Log.Println("Error : ", err.Error())
		return
	}
	// Make a cURL get request
	resp, err := http.Get(string(nurl))
	// Log error when request not successful
	if err != nil {
		logger.Log.Println("Error : ", err.Error())
		return
	}

	// Close response body
	defer resp.Body.Close()
}

// Function for processing Win Notice request
func processBillingnotice(w http.ResponseWriter, r *http.Request) {

	// id := r.URL.Query().Get("id")
	//~ bidderid := r.URL.Query().Get("bidderid")

	burl, err := base64.StdEncoding.DecodeString(r.URL.Query().Get("burl"))
	if err != nil {
		logger.Log.Println("Error : ", err.Error())
		return
	}
	// Make a cURL get request
	resp, err := http.Get(string(burl))

	// Log error when request not successful
	if err != nil {
		logger.Log.Println("Error : ", err.Error())
		return
	}

	// Close response body
	defer resp.Body.Close()

}

// Function for processing Ad Click request
func processImpUrl(w http.ResponseWriter, r *http.Request) {
	// ProcessDetails := make(map[string]interface{})
	zoneid := r.URL.Query().Get("zoneid")
	// bannerid := r.URL.Query().Get("bannerid")
	// campaignid := r.URL.Query().Get("campaignid")
	bidderid := r.URL.Query().Get("bidderid")
	requestid := r.URL.Query().Get("requestid")
	banner_type := r.URL.Query().Get("banner_type")
	price := r.URL.Query().Get("won_price")

	bidder_id, _ := strconv.Atoi(bidderid)
	zone_id, _ := strconv.Atoi(zoneid)

	auction_price := StringToFloat(price, 64)
	Track_win(requestid, bidder_id, zone_id, banner_type, auction_price)

}

func Track_win(request_id string, dsp_id int, zone_id int, banner_type string, won_price float64) {

	clickClient.Track_win(request_id, uint16(dsp_id), uint64(zone_id), banner_type, won_price)
}

// Function for coverting float to string
func StringToFloat(str string, bit int) float64 {
	if flt, err := strconv.ParseFloat(str, bit); err == nil {
		return flt
	}
	return 0
}

// Function for processing Loss Notice request
func processLossnotice(w http.ResponseWriter, r *http.Request) {
	id := r.URL.Query().Get("id")
	bidderid := r.URL.Query().Get("bidderid")
	log.Println("loss", id)
	log.Println("loss", bidderid)
	lurl, err := base64.StdEncoding.DecodeString(r.URL.Query().Get("lurl"))
	if err != nil {
		logger.Log.Println("Error : ", err.Error())
		return
	}
	// Make a cURL get request
	resp, err := http.Get(string(lurl))

	// Log error when request not successful
	if err != nil {
		logger.Log.Println("Error : ", err.Error())
		return
	}

	// Close response body
	defer resp.Body.Close()
}

// Function for processing Loss Notice request
func processVastWrapper(w http.ResponseWriter, r *http.Request) {

	var (
		x   []byte
		err error
	)
	xmlS := &vastxmlstructs.VastTypes{}
	key := r.URL.Query().Get("key")
	err = redisclient.GetKey(key, xmlS)

	if xmlS.VAST2 != nil {
		x, err = xml.MarshalIndent(xmlS.VAST2, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	} else if xmlS.WVAST2 != nil {
		x, err = xml.MarshalIndent(xmlS.WVAST2, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	} else if xmlS.VAST3 != nil {
		x, err = xml.MarshalIndent(xmlS.VAST3, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	} else if xmlS.WVAST3 != nil {
		x, err = xml.MarshalIndent(xmlS.WVAST3, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	} else if xmlS.VAST4 != nil {
		x, err = xml.MarshalIndent(xmlS.VAST4, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	} else if xmlS.WVAST4 != nil {
		x, err = xml.MarshalIndent(xmlS.WVAST4, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	} else if xmlS.VAST41 != nil {
		x, err = xml.MarshalIndent(xmlS.VAST41, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	} else if xmlS.WVAST41 != nil {
		x, err = xml.MarshalIndent(xmlS.WVAST41, "", "  ")
		if err != nil {
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
	}
	if err != nil {
		logger.Log.Println("Key : "+key+" expired or error in getting redis key: ", err.Error())
		http.Error(w, "Not Found", http.StatusNotFound)
		return
	}

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(r.Header.Get("Referer"))
	w.Header().Set("Content-Type", "text/xml; charset=utf-8")
	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	w.Write(x)
}

func VastWrapper(w http.ResponseWriter, r *http.Request) {

	key := r.URL.Query().Get("overlaykey")
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(r.Header.Get("Referer"))
	w.Header().Set("Content-Type", "text/xml; charset=utf-8")
	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	var (
		err error
	)
	var xmlS string
	err = redisclient.GetKey(key, &xmlS)

	if err != nil {
		http.Error(w, "Not Found", http.StatusNotFound)
		return
	}

	w.Write([]byte(xmlS))
}

func GetMin(k int) (m int) {
	if k <= 15 && k >= 0 {
		m = 0
	} else if k <= 30 && k > 15 {
		m = 15
	} else if k <= 45 && k > 30 {
		m = 30
	} else if k <= 59 && k > 45 {
		m = 45
	}
	return
}

// Function for getting minutes
func GetMinalt(k int) (m int) {

	if k%5 > 0 {
		m = k - (k % 5)

	}

	return

}

// Function for processing Loss Notice request
func processVastTracking(w http.ResponseWriter, r *http.Request) {

	zoneid, _ := strconv.Atoi(r.URL.Query().Get("zoneid"))
	exchangeid, _ := strconv.Atoi(r.URL.Query().Get("exchangeid"))
	event := r.URL.Query().Get("event")

	clickClient.Track_vast(uint16(exchangeid), uint64(zoneid), event)
	return
}

// Function for adding extra zeros
func AddZeros(count int) (result string) {
	if len(strconv.Itoa(count)) == 1 {
		result = "0" + strconv.Itoa(count)
	} else {
		result = strconv.Itoa(count)
	}
	return
}

func Clickhouse_Cron() {

	fmt.Println("cron started")
	ctx := context.Background()
	t := time.Now()
	// t := time.Date(2024, time.January, 5, 13, 00, 0, 0, time.UTC)
	// fmt.Println("New Time:", t)
	/* layout := "2006-01-02 15:04:05"
	str := "2020-04-28 18:00:00"
	t, _ := time.Parse(layout, str)
	log.Println(t) */
	yC := t.Year()
	monC := AddZeros(int(t.Month()))
	dC := AddZeros(t.Day())
	hC := AddZeros(t.Hour())
	layout := "2006-01-02 15:04:00"
	str := strconv.Itoa(yC) + "-" + monC + "-" + dC + " " + hC + ":00:00"
	t, _ = time.Parse(layout, str)
	start := t.Add(time.Duration(-60) * time.Minute).Format("2006-01-02 15:04:05")

	// Example query
	query := `INSERT INTO ssp_dj_hourly_table( * ) SELECT bidderid,zoneid,pmp_deal,banner_type,TEMP.country_code,TEMP.country_name,TEMP.domain,TEMP.os,TEMP.ip,TEMP.user_agent,TEMP.language,TEMP.currency,TEMP.user_age,TEMP.user_gender,TEMP.browser,TEMP.device_type,TEMP.device_make,TEMP.device_model,TEMP.page_url,TEMP.ref_url,SUM(TEMP.req_c) AS req_c,SUM(TEMP.res_c) AS res_c,SUM(TEMP.win_c) AS win_c,SUM(TEMP.imp_c) AS imp_c,SUM(TEMP.won_p) AS won_p,SUM(TEMP.adm_r) AS adm_r,TEMP.time FROM( SELECT toStartOfHour(t1.datatime) time,t1.bidderid bidderid,t1.zoneid zoneid,0 As pmp_deal,t1.banner_type banner_type,t1.country_code country_code,t1.country_name country_name,t1.domain domain,t1.os os,t1.ip ip,t1.user_agent user_agent,t1.language language,t1.currency currency,t1.user_age user_age,t1.user_gender user_gender,t1.browser browser,t1.device_type device_type,t1.device_make device_make,t1.device_model device_model,t1.page_url page_url,t1.ref_url ref_url,SUM(ifNull(t1.request_count, 0)) AS req_c,SUM(ifNull(t2.response_count, 0)) AS res_c,0 AS win_c,0 AS imp_c,0 AS won_p,0 AS adm_r FROM ssp_dj_request_stats AS t1 LEFT JOIN ssp_dj_response_stats AS t2 ON t1.request_id = t2.request_id WHERE toStartOfHour(t1.datatime) = '` + start + `' GROUP BY t1.request_id,t1.bidderid,t1.zoneid,t1.banner_type,t1.country_code,t1.country_name,t1.domain,t1.os,t1.ip,t1.user_agent,t1.language,t1.currency,t1.user_age,t1.user_gender,t1.browser,t1.device_type,t1.device_make,t1.device_model,t1.page_url,t1.ref_url,toStartOfHour(t1.datatime) UNION ALL SELECT toStartOfHour(t1.datatime) time,t1.bidderid bidderid,t1.zoneid zoneid,0 As pmp_deal,t1.banner_type banner_type,t1.country_code country_code,t1.country_name country_name,t1.domain domain,t1.os os,t1.ip ip,t1.user_agent user_agent,t1.language language,t1.currency currency,t1.user_age user_age,t1.user_gender user_gender,t1.browser browser,t1.device_type device_type,t1.device_make device_make,t1.device_model device_model,t1.page_url page_url,t1.ref_url ref_url,0 AS req_c,0 AS res_c,SUM(ifNull(t3.win_count, 0)) AS win_c,SUM(ifNull(t3.imp_count, 0)) AS imp_c,SUM(ifNull(CAST(t3.won_price, 'Decimal64(6)'), 0)) AS won_p,SUM(ifNull(CAST(t3.admin_share, 'Decimal64(6)'), 0)) AS adm_r FROM ssp_dj_request_stats AS t1 JOIN ssp_dj_win_stats AS t3 ON t1.request_id = t3.request_id WHERE toStartOfHour(t1.datatime) = '` + start + `' GROUP BY t1.request_id,t1.bidderid,t1.zoneid,t1.banner_type,t1.country_code,t1.country_name,t1.domain,t1.os,t1.ip,t1.user_agent,t1.language,t1.currency,t1.user_age,t1.user_gender,t1.browser,t1.device_type,t1.device_make,t1.device_model,t1.page_url,t1.ref_url,toStartOfHour(t1.datatime))as TEMP GROUP BY TEMP.time,bidderid,zoneid,pmp_deal,banner_type,TEMP.country_code,TEMP.country_name,TEMP.domain,TEMP.os,TEMP.ip,TEMP.user_agent,TEMP.language,TEMP.currency,TEMP.user_age,TEMP.user_gender,TEMP.browser,TEMP.device_type,TEMP.device_make,TEMP.device_model,TEMP.page_url,TEMP.ref_url`

	Client := clickConnect.ClickhouseConnection()
	defer Client.Close()
	input := proto.Input{}
	if err := Client.Do(ctx, ch.Query{
		Body:  query,
		Input: input,
	}); err != nil {
		fmt.Println(err)
	}

	vast_query := `INSERT INTO ssp_dj_vast_report (*) SELECT t1.bidderid,t1.zoneid,t1.event,SUM(ifNull(t1.count, 0)) AS event_count, toStartOfHour(t1.datatime) AS time FROM ssp_dj_vast_stats AS t1 WHERE toStartOfHour(t1.datatime) = '` + start + `' GROUP BY bidderid,zoneid,event,toStartOfHour(t1.datatime)`

	if err1 := Client.Do(ctx, ch.Query{
		Body:  vast_query,
		Input: input,
	}); err1 != nil {
		fmt.Println(err1)
	}

	table_name := []string{"ssp_dj_request_stats", "ssp_dj_response_stats", "ssp_dj_win_stats", "ssp_dj_vast_stats"}
	for i := 0; i < len(table_name); i++ {
		truncate_query := `ALTER TABLE ` + table_name[i] + ` DELETE WHERE toStartOfHour(datatime)='` + start + `'`
		if err := Client.Do(ctx, ch.Query{
			Body:  truncate_query,
			Input: input,
		}); err != nil {
			fmt.Println(err)
		}
	}
	fmt.Println("cron completed ", start)

}

// Cron Function
func executeCronJob() {

	//  Vast migration cron for every hour

	gocron.Every(1).Hour().Do(Clickhouse_Cron)
	<-gocron.Start()
}

func main() {
	// Concurrently execute cron functions
	go executeCronJob()

	ipAddr := constants.AppHost
	logger.Log.Println("Server started at " + constants.AppProtocol + ipAddr + constants.AppPort)
	log.Println("Server started at " + constants.AppProtocol + ipAddr + constants.AppPort)

	// http.Handler
	router := mux.NewRouter().StrictSlash(true)
	router.HandleFunc("/", home)
	router.HandleFunc("/loaderio-492353c0ec8629e10bc4d816e68b7e76.txt", validataion).Methods("GET")
	router.HandleFunc("/loaderio-492353c0ec8629e10bc4d816e68b7e76", validataion).Methods("GET")
	router.HandleFunc("/loaderio-492353c0ec8629e10bc4d816e68b7e76.html	", validataion).Methods("GET")

	router.HandleFunc(constants.SSPEndPoint, processRequest).Methods("POST")
	router.HandleFunc(constants.WinNoticeEndPoint, processWinnotice).Methods("GET")
	router.HandleFunc(constants.BillingNoticeEndPoint, processBillingnotice).Methods("GET")
	router.HandleFunc(constants.ImpUrlEndPoint, processImpUrl).Methods("GET")
	router.HandleFunc(constants.LossNoticeEndPoint, processLossnotice).Methods("GET")
	router.HandleFunc(constants.VastWrapperEndPoint, processVastWrapper).Methods("GET")
	router.HandleFunc(constants.VastTrackingEndPoint, processVastTracking).Methods("GET")
	router.HandleFunc("/VastWrapper", VastWrapper).Methods("GET")
	srv := &http.Server{
		Addr:    constants.AppPort,
		Handler: router,
		TLSConfig: &tls.Config{
			MinVersion:               tls.VersionTLS13,
			PreferServerCipherSuites: true,
		},
	}

	srv.SetKeepAlivesEnabled(false)

	if err := srv.ListenAndServeTLS(constants.CertFile, constants.KeyFile); err != nil {
		panic(err)
	}

	// if err := http.ListenAndServe(constants.AppPortraw, router); err != nil {
	// 	panic(err)
	// }
}
