package validate

import (
	"errors"
	"ssp/customapi"
)

func ValidateRequest(req *customapi.CustomRequest) []error {
	if req.ID == "" {
		return []error{errors.New("CustomRequest: request ID missing")}
	} else if req.TMax == 0 {
		return []error{errors.New("CustomRequest: tmax missing")}
	} else if len(req.Imp) == 0 {
		return []error{errors.New("CustomRequest: request has no impressions")}
	}
	
	for _, imp := range req.Imp {
		if err := (&imp).Validate(); err != nil {
			return []error{errors.New("CustomRequest: impression Format Error")}
		}
	}
	return nil
}
