package tracking

import (
	"context"
	"fmt"
	"ssp/clickConnect"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Win_notice struct {
	Request_id       proto.ColUUID
	Bidderid         proto.ColUInt16
	Zoneid           proto.ColUInt64
	Banner_type      proto.ColStr
	Win_count        proto.ColUInt8
	Impression_count proto.ColUInt8
	Won_price        proto.ColFloat64
	Admin_share      proto.ColFloat64
	Date_time        proto.ColDateTime
}

func Track_win(Client *ch.Client, ad_win *Win_notice) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "request_id", Data: &ad_win.Request_id},
		{Name: "bidderid", Data: &ad_win.Bidderid},
		{Name: "zoneid", Data: &ad_win.Zoneid},
		{Name: "banner_type", Data: &ad_win.Banner_type},
		{Name: "win_count", Data: &ad_win.Win_count},
		{Name: "imp_count", Data: &ad_win.Impression_count},
		{Name: "won_price", Data: &ad_win.Won_price},
		{Name: "datatime", Data: &ad_win.Date_time},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("ssp_dj_win_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
