package tracking

import (
	"context"
	"fmt"
	"ssp/clickConnect"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type VastCount struct {
	Bidderid  proto.ColUInt16
	Zoneid    proto.ColUInt64
	Event     proto.ColStr
	Count     proto.ColUInt8
	Date_time proto.ColDateTime
}

func Track_vast_event(Client *ch.Client, vast_count *VastCount) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "bidderid", Data: &vast_count.Bidderid},
		{Name: "zoneid", Data: &vast_count.Zoneid},
		{Name: "event", Data: &vast_count.Event},
		{Name: "count", Data: &vast_count.Count},
		{Name: "datatime", Data: &vast_count.Date_time},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("ssp_dj_vast_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
