package tracking

import (
	"context"
	"fmt"
	"ssp/clickConnect"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Track_Response struct {
	Request_id  proto.ColUUID
	Bidderid    proto.ColUInt16
	Zoneid      proto.ColUInt64
	Banner_type proto.ColStr
	Res_count   proto.ColUInt8
	Date_time   proto.ColDateTime
}

func Track_res(Client *ch.Client, ad_res *Track_Response) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "request_id", Data: &ad_res.Request_id},
		{Name: "bidderid", Data: &ad_res.Bidderid},
		{Name: "zoneid", Data: &ad_res.Zoneid},
		{Name: "banner_type", Data: &ad_res.Banner_type},
		{Name: "response_count", Data: &ad_res.Res_count},
		{Name: "datatime", Data: &ad_res.Date_time},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("ssp_dj_response_stats"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
