package tracking

import (
	"context"
	"fmt"
	"ssp/clickConnect"

	"github.com/ClickHouse/ch-go"
	"github.com/ClickHouse/ch-go/proto"
)

type Bkt_c struct {
	Request_id  proto.ColUUID
	Bidderid    proto.ColUInt16
	Adid        proto.ColUInt16
	Click_count proto.ColUInt64
	Date_time   proto.ColDateTime
}

func Track_click(Client *ch.Client, ad_clk *Bkt_c) error {

	ctx := context.Background()

	input := proto.Input{
		{Name: "request_id", Data: &ad_clk.Request_id},
		{Name: "bidderid", Data: &ad_clk.Bidderid},
		{Name: "ad_id", Data: &ad_clk.Adid},
		{Name: "click_count", Data: &ad_clk.Click_count},
		{Name: "datatime", Data: &ad_clk.Date_time},
	}

	Client = clickConnect.ClickhouseConnection()
	defer Client.Close()
	if err4 := Client.Do(ctx, ch.Query{
		Body:  input.Into("dj_data_bkt_c"), // helper that generates INSERT INTO query with all columns
		Input: input,
	}); err4 != nil {
		fmt.Println(err4)
	}

	// if _, err := conn.NewInsert().Model(&ad_req).Exec(context.Background()); err != nil {
	// 	panic(err)
	// }
	return nil
}
