package request25

import (
	"ssp/customapi"

	//~ "fmt"
	openrtb "openrtb/openrtb2.5"
)

// Function for forming the common objects in v2.5
func FormCommonObjects(channel chan *openrtb.BidRequest, req *customapi.CustomRequest) {

	bidRequest := &openrtb.BidRequest{}
	bidRequest.ID = req.ID

	// Impression Object
	bidRequest.Imp = make([]openrtb.Impression, len(req.Imp))
	for k, v := range req.Imp {
		bidRequest.Imp[k].ID = v.ID
		bidRequest.Imp[k].Secure = req.Restrictions.Secure

		bidRequest.Imp[k].BidFloor = v.BidFloor
		bidRequest.Imp[k].Metric = make([]openrtb.Metric, len(v.Metric))
		for k1, v1 := range v.Metric {
			bidRequest.Imp[k].Metric[k1].Type = v1.Type
			bidRequest.Imp[k].Metric[k1].Value = v1.Value
			bidRequest.Imp[k].Metric[k1].Vendor = v1.Vendor
			bidRequest.Imp[k].Metric[k1].Ext = v1.Ext
		}

		bidRequest.Imp[k].Secure = req.Restrictions.Secure

		// Banner Object
		if v.Banner != nil {
			var ban openrtb.Banner
			ban.Mimes = v.Banner.Mimes
			ban.W = v.Banner.W
			ban.H = v.Banner.H
			ban.Pos = v.Banner.Pos
			ban.ID = v.Banner.ID

			bidRequest.Imp[k].Banner = &ban
		}

		// Video Object
		if v.Video != nil {
			var vid openrtb.Video
			vid.Mimes = v.Video.Mimes
			vid.MinDuration = v.Video.MinDuration
			vid.MaxDuration = v.Video.MaxDuration
			vid.Protocols = v.Video.Protocols
			vid.Protocol = v.Video.Protocol
			vid.W = v.Video.W
			vid.H = v.Video.H
			vid.StartDelay = v.Video.StartDelay
			vid.Linearity = v.Video.Linearity
			vid.Skip = v.Video.Skip
			vid.SkipMin = v.Video.SkipMin
			vid.SkipAfter = v.Video.SkipAfter
			vid.Sequence = v.Video.Sequence
			vid.BAttr = v.Video.BAttr
			vid.MaxExtended = v.Video.MaxExtended
			vid.MinBitrate = v.Video.MinBitrate
			vid.MaxBitrate = v.Video.MaxBitrate
			vid.BoxingAllowed = v.Video.BoxingAllowed
			vid.PlaybackMethod = v.Video.PlaybackMethod
			vid.Delivery = v.Video.Delivery
			vid.Pos = v.Video.Pos
			if len(v.Video.CompanionAd) > 0 {
				vid.CompanionAd = make([]openrtb.Banner, len(v.Video.CompanionAd))
				for k1, v1 := range v.Video.CompanionAd {
					vid.CompanionAd[k1].W = v1.W
					vid.CompanionAd[k1].H = v1.H
					vid.CompanionAd[k1].Mimes = v1.Mimes
					vid.CompanionAd[k1].Pos = v1.Pos
					vid.CompanionAd[k1].ID = v1.ID
				}
			}
			vid.Api = v.Video.Api
			vid.CompanionType = v.Video.CompanionType
			vid.Placement = v.Video.Placement
			vid.Ext = v.Video.Ext

			bidRequest.Imp[k].Video = &vid
		}

		// Audio Object
		if v.Audio != nil {
			var aud openrtb.Audio
			aud.Mimes = v.Audio.Mimes
			aud.MinDuration = v.Audio.MinDuration
			aud.MaxDuration = v.Audio.MaxDuration
			aud.Protocols = v.Audio.Protocols
			aud.StartDelay = v.Audio.StartDelay
			aud.Sequence = v.Audio.Sequence
			aud.BAttr = v.Audio.BAttr
			aud.MaxExtended = v.Audio.MaxExtended
			aud.MinBitrate = v.Audio.MinBitrate
			aud.MaxBitrate = v.Audio.MaxBitrate
			aud.Delivery = v.Audio.Delivery
			if len(v.Audio.CompanionAd) > 0 {
				aud.CompanionAd = make([]openrtb.Banner, len(v.Audio.CompanionAd))
				for k1, v1 := range v.Audio.CompanionAd {
					aud.CompanionAd[k1].W = v1.W
					aud.CompanionAd[k1].H = v1.H
					aud.CompanionAd[k1].Mimes = v1.Mimes
					aud.CompanionAd[k1].Pos = v1.Pos
					aud.CompanionAd[k1].ID = v1.ID
				}
			}
			aud.CompanionType = v.Audio.CompanionType
			aud.MaxSequence = v.Audio.MaxSequence
			aud.API = v.Audio.API
			aud.Feed = v.Audio.Feed
			aud.Stitched = v.Audio.Stitched
			aud.NVol = v.Audio.NVol
			aud.Ext = v.Audio.Ext

			bidRequest.Imp[k].Audio = &aud
		}

		// Native Object
		if v.Native != nil {
			var nat openrtb.Native
			var req openrtb.Nativefmt
			if len(v.Native.Request.Asset) > 0 {
				var ass []*openrtb.Asset
				ass = make([]*openrtb.Asset, len(v.Native.Request.Asset))

				for k1, v1 := range v.Native.Request.Asset {

					if v1 != nil {

						var ast openrtb.Asset
						ast.Id = v1.Id
						ast.Req = v1.Req

						if v1.Title != nil {
							var astTitle openrtb.Title
							astTitle.Len = v1.Title.Len
							ast.Title = &astTitle
						}

						if v1.Img != nil {
							var astImg openrtb.Img
							astImg.Type = v1.Img.Type
							astImg.W = v1.Img.W
							astImg.Wmin = v1.Img.Wmin
							astImg.H = v1.Img.H
							astImg.Hmin = v1.Img.Hmin
							astImg.Mime = v1.Img.Mime
							ast.Img = &astImg
						}

						if v1.Data != nil {
							var astData openrtb.DataN
							astData.Len = v1.Data.Len
							astData.Type = v1.Data.Type
							ast.Data = &astData
						}

						// Video Object
						if v1.Video != nil {
							var vid openrtb.Video
							vid.Mimes = v1.Video.Mimes
							vid.MinDuration = v1.Video.MinDuration
							vid.MaxDuration = v1.Video.MaxDuration
							vid.Protocols = v1.Video.Protocols
							vid.Protocol = v1.Video.Protocol
							vid.W = v1.Video.W
							vid.H = v1.Video.H
							vid.StartDelay = v1.Video.StartDelay
							vid.Linearity = v1.Video.Linearity
							vid.Skip = v1.Video.Skip
							vid.SkipMin = v1.Video.SkipMin
							vid.SkipAfter = v1.Video.SkipAfter
							vid.Sequence = v1.Video.Sequence
							vid.BAttr = v1.Video.BAttr
							vid.MaxExtended = v1.Video.MaxExtended
							vid.MinBitrate = v1.Video.MinBitrate
							vid.MaxBitrate = v1.Video.MaxBitrate
							vid.BoxingAllowed = v1.Video.BoxingAllowed
							vid.PlaybackMethod = v1.Video.PlaybackMethod
							vid.Delivery = v1.Video.Delivery
							vid.Pos = v1.Video.Pos
							if len(v1.Video.CompanionAd) > 0 {
								vid.CompanionAd = make([]openrtb.Banner, len(v1.Video.CompanionAd))
								for k2, v2 := range v1.Video.CompanionAd {
									vid.CompanionAd[k2].W = v2.W
									vid.CompanionAd[k2].H = v2.H
									vid.CompanionAd[k2].Mimes = v2.Mimes
									vid.CompanionAd[k2].Pos = v2.Pos
									vid.CompanionAd[k2].ID = v2.ID
								}
							}
							vid.Api = v1.Video.Api
							vid.CompanionType = v1.Video.CompanionType
							vid.Placement = v1.Video.Placement
							vid.Ext = v1.Video.Ext
							ast.Video = &vid
						}
						ass[k1] = &ast

					}
				}

				req.Asset = ass

				nat.Request = &req

			}

			bidRequest.Imp[k].Native = &nat
		}

		// PMP Object
		if v.Pmp != nil {
			var pmp openrtb.Pmp
			pmp.Private = v.Pmp.Private
			if len(v.Pmp.Deals) > 0 && v.Pmp.Private != 0 {
				pmp.Deals = make([]openrtb.Deal, len(v.Pmp.Deals))
				for k1, v1 := range v.Pmp.Deals {
					pmp.Deals[k1].ID = v1.ID
					pmp.Deals[k1].BidFloor = v1.Flr
				}
			}
			pmp.Ext = v.Pmp.Ext
			bidRequest.Imp[k].Pmp = &pmp
		}
	}

	// Site Object
	if req.Site != nil && req.Site.ID != "" {
		var site openrtb.Site
		var publisher openrtb.Publisher
		site.Inventory.ID = req.Site.ID
		site.Inventory.Name = req.Site.Name
		site.Inventory.Domain = req.Site.Domain
		site.Inventory.Cat = req.Site.Inventory.Cat
		site.Inventory.SectionCat = req.Site.Inventory.SectionCat
		site.Inventory.PageCat = req.Site.PageCat
		site.Inventory.PrivacyPolicy = req.Site.PrivacyPolicy
		if req.Site.Inventory.Publisher != nil {
			publisher.ID = req.Site.Inventory.Publisher.ID
			publisher.Name = req.Site.Inventory.Publisher.Name
			publisher.Cat = req.Site.Inventory.Publisher.Cat
			publisher.Domain = req.Site.Inventory.Publisher.Domain
			publisher.Ext = req.Site.Inventory.Publisher.Ext
			site.Inventory.Publisher = &publisher
		}
		site.Inventory.Keywords = req.Site.Inventory.Keywords
		site.Amp = req.Site.Amp
		site.Page = req.Site.Page
		site.Ref = req.Site.Ref
		site.Search = req.Site.Search
		site.Mobile = req.Site.Mobile
		bidRequest.Site = &site
	}

	// App Object
	if req.App != nil && req.App.Bundle != "" {
		var app openrtb.App
		var publisher openrtb.Publisher
		app.Inventory.ID = req.App.ID
		app.Inventory.Name = req.App.Name
		app.Inventory.Domain = req.App.Domain
		app.Inventory.Cat = req.App.Cat
		app.Inventory.SectionCat = req.App.SectionCat
		app.Inventory.PageCat = req.App.PageCat
		app.Inventory.PrivacyPolicy = req.App.PrivacyPolicy
		if req.App.Inventory.Publisher != nil {
			publisher.ID = req.App.Inventory.Publisher.ID
			publisher.Name = req.App.Inventory.Publisher.Name
			publisher.Cat = req.App.Inventory.Publisher.Cat
			publisher.Domain = req.App.Inventory.Publisher.Domain
			publisher.Ext = req.App.Inventory.Publisher.Ext
			app.Inventory.Publisher = &publisher
		}
		app.Inventory.Keywords = req.App.Inventory.Keywords
		app.Bundle = req.App.Bundle
		app.StoreURL = req.App.StoreURL
		app.Ver = req.App.Ver
		app.Paid = req.App.Paid
		bidRequest.App = &app
	}

	// Device Object
	if req.Device != nil {
		var device openrtb.Device
		var geo openrtb.Geo
		device.UA = req.Device.UA
		if req.Device.Geo != nil {
			geo.Lat = req.Device.Geo.Lat
			geo.Lon = req.Device.Geo.Lon
			geo.Type = req.Device.Geo.Type
			geo.Accuracy = req.Device.Geo.Accuracy
			geo.LastFix = req.Device.Geo.LastFix
			geo.IPService = req.Device.Geo.IPService
			geo.Country = req.Device.Geo.Country
			geo.Region = req.Device.Geo.Region
			geo.RegionFIPS104 = req.Device.Geo.RegionFIPS104
			geo.Metro = req.Device.Geo.Metro
			geo.City = req.Device.Geo.City
			geo.Zip = req.Device.Geo.Zip
			geo.UTCOffset = req.Device.Geo.UTCOffset
			geo.Ext = req.Device.Geo.Ext
			device.Geo = &geo
		}
		device.DNT = req.Device.DNT
		device.LMT = req.Device.LMT
		device.IP = req.Device.IP
		device.IPv6 = req.Device.IPv6
		device.DeviceType = req.Device.DeviceType
		device.Make = req.Device.Make
		device.Model = req.Device.Model
		device.OS = req.Device.OS
		device.OSVer = req.Device.OSVer
		device.HwVer = req.Device.HwVer
		device.H = req.Device.H
		device.W = req.Device.W
		device.PPI = req.Device.PPI
		device.PxRatio = req.Device.PxRatio
		device.JS = req.Device.JS
		device.GeoFetch = req.Device.GeoFetch
		device.FlashVer = req.Device.FlashVer
		device.Language = req.Device.Language
		device.Carrier = req.Device.Carrier
		device.MCCMNC = req.Device.MCCMNC
		device.IFA = req.Device.IFA
		device.IDSHA1 = req.Device.IDSHA1
		device.IDMD5 = req.Device.IDMD5
		device.PIDSHA1 = req.Device.PIDSHA1
		device.PIDMD5 = req.Device.PIDMD5
		device.MacSHA1 = req.Device.MacSHA1
		device.MacMD5 = req.Device.MacMD5
		device.Ext = req.Device.Ext
		bidRequest.Device = &device
	}

	// User Object
	if req.User != nil {
		var user openrtb.User
		var geo openrtb.Geo
		user.ID = req.User.ID
		user.Consent = req.User.Consent
		user.BuyerID = req.User.BuyerID
		user.BuyerUID = req.User.BuyerUID
		user.YOB = req.User.YOB
		user.Gender = req.User.Gender
		user.Keywords = req.User.Keywords
		user.CustomData = req.User.CustomData
		if req.User.Geo != nil {
			geo.Lat = req.User.Geo.Lat
			geo.Lon = req.User.Geo.Lon
			geo.Type = req.User.Geo.Type
			geo.Accuracy = req.User.Geo.Accuracy
			geo.LastFix = req.User.Geo.LastFix
			geo.IPService = req.User.Geo.IPService
			geo.Country = req.User.Geo.Country
			geo.Region = req.User.Geo.Region
			geo.RegionFIPS104 = req.User.Geo.RegionFIPS104
			geo.Metro = req.User.Geo.Metro
			geo.City = req.User.Geo.City
			geo.Zip = req.User.Geo.Zip
			geo.UTCOffset = req.User.Geo.UTCOffset
			geo.Ext = req.User.Geo.Ext
			user.Geo = &geo
		}

		if len(req.User.Data) > 0 {
			user.Data = make([]openrtb.Data, len(req.User.Data))
			for k, v := range req.User.Data {
				user.Data[k].ID = v.ID
				user.Data[k].Name = v.Name
				if len(v.Segment) > 0 {
					user.Data[k].Segment = make([]openrtb.Segment, len(v.Segment))
					for k1, v1 := range v.Segment {
						user.Data[k].Segment[k1].ID = v1.ID
						user.Data[k].Segment[k1].Name = v1.Name
						user.Data[k].Segment[k1].Value = v1.Value
						user.Data[k].Segment[k1].Ext = v1.Ext
					}
				}
				user.Data[k].Ext = v.Ext
			}
		}
		user.Ext = req.User.Ext
		bidRequest.User = &user
	}

	// Regulations Object
	if req.Regs != nil {
		var regs openrtb.Regulations
		regs.Coppa = req.Regs.Coppa
		regs.Ext = req.Regs.Ext
		bidRequest.Regs = &regs
	}

	// Restrictions Object
	if req.Restrictions != nil {
		bidRequest.Test = req.Restrictions.Test
		bidRequest.BAdv = req.Restrictions.Badv
		bidRequest.BApp = req.Restrictions.Bapp
		bidRequest.Bcat = req.Restrictions.Bcat
	}

	channel <- bidRequest
}
