package logger

import (
	"flag"
	"go/build"
	"log"
	"os"
	"ssp/constants"
)

var (
	Log *log.Logger
)

func init() {
	// set location of log file
	var logpath = build.Default.GOPATH + constants.LogFile
	flag.Parse()
	var file, err1 = os.OpenFile(logpath, os.O_RDWR|os.O_CREATE|os.O_APPEND, 0666)
	if err1 != nil {
		panic(err1)
	}
	Log = log.New(file, "", log.LstdFlags|log.Lshortfile)
}
