package clickConnect

import (
	"context"
	"fmt"
	"net"
	"ssp/constants"

	"github.com/ClickHouse/ch-go"
)

func ClickhouseConnection() *ch.Client {
	// fmt.Println("CLICKHOUSE CONNECTED")

	ctx := context.Background()

	conn, err := net.Dial("tcp", constants.ClickHost+":"+constants.ClickPort)
	if err != nil {
		// handle error
	}

	Client, _ := ch.Connect(ctx, conn, ch.Options{
		Address:  constants.ClickHost + ":" + constants.ClickPort,
		Database: constants.ClickDbName,
		User:     constants.ClickUser,
		Password: constants.ClickPass,
	})

	err2 := Client.Ping(ctx)
	if err2 != nil {
		fmt.Println(err2)
	}
	return Client

}
