package clickClient

import (
	"context"
	"fmt"
	"log"
	"ssp/clickConnect"
	"ssp/redisClient"
	"ssp/tracking"
	"sync"
	"time"

	"github.com/ClickHouse/ch-go"

	uuid "github.com/google/uuid"
)

var Client *ch.Client
var ctx = context.Background()
var mu sync.Mutex

var redisclient = redisClient.Initialize()

func init() {
	Client = clickConnect.ClickhouseConnection()
}

func Track_request(request_id string, bidder_id uint16, zoneid uint64, banner_type string, country_code string, domain string, os string, ip string, user_agent string, language string, currency string, user_age string, user_gender string, browser string, device_type string, device_make string, device_model string, page_url string, ref_url string) error {

	// fmt.Println("Track_request")
	var Track_Req tracking.Track_request

	var req_count uint8
	req_count = 1
	var country_name string

	country_1 := make(map[string]interface{})
	country_2 := make(map[string]interface{})
	country_3 := make(map[string]interface{})
	country_4 := make(map[string]interface{})

	if country_code != "" {
		arr1 := redisclient.GetKey("country_1", &country_1)
		if arr1 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr1.Error())
		}
		arr2 := redisclient.GetKey("country_2", &country_2)
		if arr2 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr2.Error())
		}
		arr3 := redisclient.GetKey("country_3", &country_3)
		if arr3 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr3.Error())
		}
		arr4 := redisclient.GetKey("country_4", &country_4)
		if arr4 != nil {
			fmt.Println("Key expired or error in getting redis key: ", arr4.Error())
		}

		if val1, err1 := country_1[fmt.Sprint(country_code)]; err1 {
			country_name = fmt.Sprint(val1)
		} else if val2, err2 := country_2[fmt.Sprint(country_code)]; err2 {
			country_name = fmt.Sprint(val2)
		} else if val3, err3 := country_3[fmt.Sprint(country_code)]; err3 {
			country_name = fmt.Sprint(val3)
		} else if val4, err4 := country_4[fmt.Sprint(country_code)]; err4 {
			country_name = fmt.Sprint(val4)
		}
	}

	Track_Req.Request_id.Append(StringToUUID(request_id))
	Track_Req.Bidderid.Append(bidder_id)
	Track_Req.Zoneid.Append(zoneid)
	Track_Req.Banner_type.Append(banner_type)
	Track_Req.Country_code.Append(country_code)
	Track_Req.Country_Name.Append(country_name)
	Track_Req.Domain.Append(domain)
	Track_Req.Os.Append(os)
	Track_Req.Ip.Append(ip)
	Track_Req.User_agent.Append(user_agent)
	Track_Req.Language.Append(language)
	Track_Req.Currency.Append(currency)
	Track_Req.User_age.Append(user_age)
	Track_Req.User_gender.Append(user_gender)
	Track_Req.Browser.Append(browser)
	Track_Req.Device_type.Append(device_type)
	Track_Req.Device_make.Append(device_make)
	Track_Req.Device_model.Append(device_model)
	Track_Req.Page_url.Append(page_url)
	Track_Req.Ref_url.Append(ref_url)
	Track_Req.Req_count.Append(req_count)
	Track_Req.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_req(Client, &Track_Req)

	if err != nil {
		// fmt.Printf("error %+v", err)
		// fmt.Println(err)
	}
	mu.Unlock()

	return nil

}

func Track_response(request_id string, bidderid uint16, zoneid uint64, banner_type string) error {

	var Response_Stats tracking.Track_Response
	var response_count uint8
	response_count = 1

	Response_Stats.Request_id.Append(StringToUUID(request_id))
	Response_Stats.Bidderid.Append(bidderid)
	Response_Stats.Zoneid.Append(zoneid)
	Response_Stats.Banner_type.Append(banner_type)
	Response_Stats.Res_count.Append(response_count)
	Response_Stats.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_res(Client, &Response_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_win(request_id string, bidderid uint16, zoneid uint64, banner_type string, won_price float64) error {

	var win_Stats tracking.Win_notice

	var win_count, imp_count uint8
	win_count, imp_count = 1, 1

	win_Stats.Request_id.Append(StringToUUID(request_id))
	win_Stats.Bidderid.Append(bidderid)
	win_Stats.Zoneid.Append(zoneid)
	win_Stats.Banner_type.Append(banner_type)
	win_Stats.Win_count.Append(win_count)
	win_Stats.Impression_count.Append(imp_count)
	win_Stats.Won_price.Append(won_price)
	win_Stats.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_win(Client, &win_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_vast(bidderid uint16, zoneid uint64, event string) error {

	var vast tracking.VastCount
	var vast_count uint8
	vast_count = 1

	vast.Bidderid.Append(bidderid)
	vast.Zoneid.Append(zoneid)
	vast.Event.Append(event)
	vast.Count.Append(vast_count)
	vast.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_vast_event(Client, &vast)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func Track_click(request_id string, bidderid uint16, adid uint16, click_count uint64) error {

	var click_Stats tracking.Bkt_c

	click_Stats.Request_id.Append(StringToUUID(request_id))
	click_Stats.Bidderid.Append(bidderid)
	click_Stats.Adid.Append(adid)
	click_Stats.Click_count.Append(click_count)
	click_Stats.Date_time.Append(time.Now())

	mu.Lock()
	// if Client.IsClosed() == true {
	// 	fmt.Println(" #### CLIENT IS CLOSED AND RESTART CONNECTION")
	// 	ClickhouseConnection()
	// }
	err := tracking.Track_click(Client, &click_Stats)
	if err != nil {
		log.Printf("Insert product failed with error %s", err)
		return err
	}
	mu.Unlock()

	return nil
}

func StringToUUID(id string) uuid.UUID {
	u3, err := uuid.Parse(id)
	if err != nil {
		log.Printf("failed to parse UUID %q: %v", u3, err)
	}
	return u3
}
