package ad

import (
	"encoding/base64"
	"encoding/hex"
	"encoding/json"
	"fmt"
	"log"
	"ssp/blowfishClient"
	"ssp/clickClient"
	"ssp/constants"
	"ssp/curl"
	"ssp/customapi"
	"ssp/logger"
	"ssp/redisClient"
	"ssp/request25"
	"ssp/vastxml"
	"strconv"
	"strings"
	"time"

	//~ b64 "encoding/base64"

	//~ "math/rand"
	openrtb "openrtb/openrtb2.5"

	"github.com/gofrs/uuid"
	"github.com/mssola/user_agent"
)

type bidderResponse struct {
	Bidderid       int
	At             int     `json:"at"`
	SeconBidBuffer float64 `json:"seconBidBuffer"`
	Response       interface{}
}

type result struct {
	cr customapi.CustomResponse
	p  float64
}

// Function for processing ad
func Ssp_adprocessing(channel chan map[string]interface{}, req *customapi.CustomRequest, redisclient *redisClient.RedisClient) {
	var (
		i       int
		req25   *openrtb.BidRequest
		jsonReq []byte
		err     error
		// responseId string
		zoneid, logurl, passkey, userid string
	)
	if req.Others != nil {
		passkey = req.Others.Passkey
		userid = req.Others.Userid
	}
	zoneid = req.Site.ID
	output := make(map[string]interface{})
	arrRes := make([]bidderResponse, len(req.Dsp))
	req25Channel := make(chan *openrtb.BidRequest)

	go request25.FormCommonObjects(req25Channel, req)

	req25 = <-req25Channel

	u1 := uuid.Must(uuid.NewV4())
	request_Id := u1.String()
	var site_id, banner_type string

	if req.Imp[0].Banner != nil {
		banner_type = "banner"
	} else if req.Imp[0].Video != nil {
		banner_type = "video"
	} else if req.Imp[0].Audio != nil {
		banner_type = "audio"
	} else if req.Imp[0].Native != nil {
		banner_type = "native"
	}

	if req.Site != nil {
		site_id = req.Site.ID
	}
	zone_id, _ := strconv.Atoi(site_id)

	for _, v := range req.Dsp {
		if v.Ver == "2.5" {

			req25.TMax = req.TMax
			req25.Cur = v.Cur
			req25.AuctionType = v.AT
			// Source Object
			if v.Source != nil {
				var src openrtb.Source
				src.TransactionID = v.Source.TID
				req25.Source = &src
			}
			jsonReq, err = json.Marshal(req25)
			if err != nil {
				logger.Log.Println("Error :", err.Error())
			}
		}

		TrackRequest(request_Id, req, v.Cur, v.ID, banner_type)

		if site_id != "6" {
			curlChannel := make(chan []byte)

			fmt.Println("Req", string(jsonReq))
			fmt.Println()

			go curl.SendRequest(curlChannel, jsonReq, v.Ping_url, v.Ver, req.TMax, v.Gzip)
			response := <-curlChannel

			if len(response) > 0 {

				if v.Ver == "2.5" {

					res25 := &openrtb.BidResponse{}

					fmt.Println("Res", string(response))

					err = json.Unmarshal(response, res25)

					if err != nil {
						logger.Log.Println("Error :", err.Error())
					}
					if res25 != nil {
						// responseId = res25.ID
						arrRes[i].Bidderid = v.ID
						arrRes[i].At = v.AT
						arrRes[i].SeconBidBuffer = v.SeconBidBuffer
						arrRes[i].Response = res25

					}

				}
				i++

				Track_Response(request_Id, v.ID, zone_id, banner_type)

			}
		}
	}

	res, lnotices := GetHighestBid(arrRes)

	for k, v := range res {

		ch := make(chan string, 1)

		go replaceMacros(ch, v, v.NURL)

		if strings.Contains(v.Adm, "<VAST") {
			logurl = constants.AppProtocol + constants.AppHost + constants.ImpUrlEndPoint + "?bannerid=" + v.AdID + "&campaignid=" + v.CID + "&zoneid=" + strconv.Itoa(zone_id) + "&id=" + v.ID + "&requestid=" + request_Id + "&bidderid=" + strconv.Itoa(v.Bidderid) + "&banner_type=" + banner_type + "&won_price=" + fmt.Sprint(float64(v.Price)/float64(1000)) + "&passkey=" + passkey + "&user_id=" + userid
		} else {
			logurl = constants.AppProtocol + constants.AppHost + constants.ImpUrlEndPoint + "?bannerid=" + v.AdID + "&campaignid=" + v.CID + "&zoneid=" + strconv.Itoa(zone_id) + "&id=" + v.ID + "&requestid=" + request_Id + "&bidderid=" + strconv.Itoa(v.Bidderid) + "&banner_type=" + banner_type + "&won_price=" + fmt.Sprint(float64(v.Price)/float64(1000))
		}

		v.NURL = constants.AppProtocol + constants.AppHost + constants.AppPort + constants.WinNoticeEndPoint + "?id=" + v.ID + "&bidderid=" + strconv.Itoa(v.Bidderid) + "&nurl=" + base64.StdEncoding.EncodeToString([]byte(<-ch))

		curl.SendWNotices(v.NURL)

		if !strings.Contains(v.Adm, "<VAST") {
			imp_url := "<img src=" + logurl + " width='0' height='0'/>"
			v.Adm = strings.Replace(v.Adm, "</div>", imp_url+"</div>", -1)
			// Track_win(request_Id, v.Bidderid, zone_id, banner_type, float64(v.Price)/float64(1000))
		}

		if strings.Contains(v.Adm, "native") {
			// Unmarshal the JSON string into a map
			var data map[string]interface{}
			err := json.Unmarshal([]byte(v.Adm), &data)
			if err != nil {
				log.Printf("Error unmarshalling JSON: %v", err)
			}

			// Navigate to the imptrackers field
			native := data["native"].(map[string]interface{})
			imptrackers := native["imptrackers"].([]interface{})

			// Append the new URL to imptrackers
			imptrackers = append(imptrackers, logurl)
			native["imptrackers"] = imptrackers

			// Marshal the updated JSON back to a string
			updatedJSONBytes, err := json.Marshal(data)
			if err != nil {
				log.Printf("Error marshalling updated JSON: %v", err)
			}
			// Convert the []byte result to a string
			v.Adm = string(updatedJSONBytes)
		}
		go replaceMacros(ch, v, v.BURL)

		v.Adm = strings.Replace(v.Adm, "{ad_network_id}", strconv.Itoa(v.Bidderid), -1)
		v.Adm = strings.Replace(v.Adm, "{days}", "30", -1)

		v.BURL = constants.AppProtocol + constants.AppHost + constants.BillingNoticeEndPoint + "?id=" + v.ID + "&bidderid=" + strconv.Itoa(v.Bidderid) + "&burl=" + base64.StdEncoding.EncodeToString([]byte(<-ch))
		if strings.Contains(v.Adm, "<VAST") {

			key := v.AdID + "-" + v.CID + "-" + v.ID

			vasturl := constants.AppProtocol + constants.AppHost + constants.VastWrapperEndPoint + "?key=" + key

			go vastxml.SaveVastXml(v.Adm, key, redisclient)

			log.Println(vasturl)

			if strings.Contains(v.Adm, "<Linear") && (strings.Contains(v.Adm, "<InLine>") || strings.Contains(v.Adm, "<Wrapper")) {

				v.Adm = `<VAST version="4.1"><Ad id="` + v.AdID + `:0.0-0" >
						<Wrapper>
							<AdSystem><![CDATA[` + constants.AppName + `]]></AdSystem>
							<Impression>
	   							<![CDATA[` + logurl + `]]>
							</Impression>
	 						<Impression>
	   							<![CDATA[` + v.BURL + `]]>
							</Impression>
							<VASTAdTagURI><![CDATA[` + vasturl + `]]></VASTAdTagURI>
							<Creatives>
								<Creative>
	 								<Linear>
										<Duration></Duration>
										<TrackingEvents>
		  									<Tracking event="start"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=start]]></Tracking>
		  									<Tracking event="firstQuartile"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=firstquartile]]></Tracking>
											<Tracking event="midpoint"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=midpoint]]></Tracking>
											<Tracking event="thirdQuartile"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=thirdquartile]]></Tracking>
											<Tracking event="complete"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=complete]]></Tracking>
											<Tracking event="pause"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=pause]]></Tracking>
											<Tracking event="mute"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=mute]]></Tracking>
											<Tracking event="fullscreen"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=fullscreen]]></Tracking>
											<Tracking event="unmute"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=unmute]]></Tracking>
											<Tracking event="creativeView"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=creativeView]]></Tracking>
											<Tracking event="acceptInvitation"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=acceptInvitation]]></Tracking>
											<Tracking event="rewind"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=rewind]]></Tracking>
											<Tracking event="resume"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=resume]]> </Tracking>
										</TrackingEvents>
									</Linear>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad></VAST>`

			} else if strings.Contains(v.Adm, `<NonLinearAds>`) && (strings.Contains(v.Adm, `<InLine>`) || strings.Contains(v.Adm, `<Wrapper`)) {

				key1 := v.AdID + "-" + v.CID + "-over" + v.ID

				redisclient.SetKey(key1, v.Adm, time.Minute*constants.RedisExpInMin)
				vasturl1 := constants.AppProtocol + constants.AppHost + "/VastWrapper?overlaykey=" + key1

				log.Println(vasturl1)

				v.Adm = `<VAST version="4.1"><Ad id="` + v.AdID + `:0.0-0" >
						<Wrapper>
							<AdSystem><![CDATA[` + constants.AppName + `]]></AdSystem>
							<Impression>
	   							<![CDATA[` + logurl + `]]>
							</Impression>
	 						<Impression>
	   							<![CDATA[` + v.BURL + `]]>
							</Impression>
							<VASTAdTagURI><![CDATA[` + vasturl1 + `]]></VASTAdTagURI>
							<Creatives>
								<Creative id="` + v.AdID + `" sequence="1">
	 								<NonLinearAds>
										<TrackingEvents>
		  									<Tracking event="creativeView"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=creativeView]]></Tracking>
		  									<Tracking event="adExpand"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=adExpand]]></Tracking>
											<Tracking event="adCollapse"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=adCollapse]]></Tracking>
											<Tracking event="acceptInvitation"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=acceptInvitation]]></Tracking>
											<Tracking event="close"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=close]]></Tracking>
											<Tracking event="overlayViewDuration"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=overlayViewDuration]]></Tracking>
											<Tracking event="otherAdInteraction"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=otherAdInteraction]]></Tracking>
											<Tracking event="minimize"><![CDATA[` + constants.AppProtocol + constants.AppHost + constants.VastTrackingEndPoint + `?zoneid=` + zoneid + `&exchangeid=` + strconv.Itoa(v.Bidderid) + `&event=minimize]]></Tracking>
										</TrackingEvents>
									</NonLinearAds>
									<NonLinear> </NonLinear>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad></VAST>`

			}
		}

		res[k] = v
	}

	output["ads"] = res
	channel <- output
	if len(lnotices) > 0 {
		curl.SendLNotices(lnotices)
	}
}

func TrackRequest(request_id string, req *customapi.CustomRequest, cur []string, dsp_id int, banner_type string) {
	t := time.Now()
	y := t.Year()
	var user_age int
	var currency, country, domain, os, ip, ua, lan, make, model, device_type, page, ref, gender, site_id string

	if len(cur) > 0 {
		currency = ArrayToString(cur, ",")
	}
	if req.Device.Geo != nil {

		country = req.Device.Geo.Country
	}
	if req.Site != nil {
		domain = req.Site.Domain
		site_id = req.Site.ID
		page = req.Site.Page
		ref = req.Site.Ref
	}
	if req.Device != nil {
		os = req.Device.OS
		ip = req.Device.IP
		ua = req.Device.UA
		lan = req.Device.Language
		make = req.Device.Make
		model = req.Device.Model
		// device_type = fmt.Sprint(req.Device.DeviceType)
		if req.Device.DeviceType == 1 || req.Device.DeviceType == 4 {
			device_type = "Mobile"
		} else if req.Device.DeviceType == 2 {
			device_type = "Personal Computer"
		} else if req.Device.DeviceType == 3 {
			device_type = "Connected TV"
		} else if req.Device.DeviceType == 5 {
			device_type = "Tablet"
		} else if req.Device.DeviceType == 6 {
			device_type = "Connected Device"
		} else if req.Device.DeviceType == 7 {
			device_type = "Set top Box"
		}
	}

	if req.User != nil {
		gender = req.User.Gender
		if req.User.YOB != 0 {
			user_age = y - req.User.YOB
		}
	}
	userAgent := ua
	uagent := user_agent.New(userAgent)
	browser, _ := uagent.Browser()

	zone_id, _ := strconv.Atoi(site_id)

	clickClient.Track_request(request_id, uint16(dsp_id), uint64(zone_id), banner_type, country, domain, os, ip, ua, lan, currency, fmt.Sprint(user_age), gender, browser, device_type, make, model, page, ref)
}

func Track_Response(request_id string, dsp_id int, zone_id int, banner_type string) {

	clickClient.Track_response(request_id, uint16(dsp_id), uint64(zone_id), banner_type)
}

func Track_win(request_id string, dsp_id int, zone_id int, banner_type string, won_price float64) {

	clickClient.Track_win(request_id, uint16(dsp_id), uint64(zone_id), banner_type, won_price)
}

// Function for coverting array to string
func ArrayToString(a interface{}, delim string) string {
	return strings.Trim(strings.Replace(fmt.Sprint(a), " ", delim, -1), "[]")
}

func replaceMacros(ch chan string, wn customapi.CustomResponse, s string) {
	wNotice := s
	wNotice = strings.Replace(wNotice, "${AUCTION_ID}", wn.ID, -1)
	wNotice = strings.Replace(wNotice, "${OPENRTB_ID}", wn.ID, -1)
	wNotice = strings.Replace(wNotice, "${AUCTION_BID_ID}", wn.BidID, -1)
	wNotice = strings.Replace(wNotice, "${OPENRTB_BID_ID}", wn.BidID, -1)
	wNotice = strings.Replace(wNotice, "${AUCTION_IMP_ID}", wn.Imp, -1)
	wNotice = strings.Replace(wNotice, "${OPENRTB_ITEM_ID}", wn.Imp, -1)
	if strings.Contains(wNotice, "${AUCTION_PRICE:BF}") {

		p := blowfishClient.BlowfishEncrypt([]byte(strconv.FormatFloat(wn.Price, 'f', 2, 64)), []byte(constants.BlowfishKey))

		wNotice = strings.Replace(wNotice, "${AUCTION_PRICE:BF}", hex.EncodeToString(p), -1)
	} else {
		wNotice = strings.Replace(wNotice, "${AUCTION_PRICE}", strconv.FormatFloat(wn.Price, 'f', 2, 64), -1)
	}
	if strings.Contains(wNotice, "${OPENRTB_PRICE:BF}") {
		p := blowfishClient.BlowfishEncrypt([]byte(strconv.FormatFloat(wn.Price, 'f', 2, 64)), []byte(constants.BlowfishKey))
		wNotice = strings.Replace(wNotice, "${OPENRTB_PRICE:BF}", hex.EncodeToString(p), -1)
	} else {
		wNotice = strings.Replace(wNotice, "${OPENRTB_PRICE}", strconv.FormatFloat(wn.Price, 'f', 2, 64), -1)
	}
	wNotice = strings.Replace(wNotice, "${AUCTION_SEAT_ID}", wn.Seat, -1)
	wNotice = strings.Replace(wNotice, "${OPENRTB_SEAT_ID}", wn.Seat, -1)
	wNotice = strings.Replace(wNotice, "${AUCTION_AD_ID}", wn.AdID, -1)
	wNotice = strings.Replace(wNotice, "${OPENRTB_MEDIA_ID}", wn.AdID, -1)
	wNotice = strings.Replace(wNotice, "${AUCTION_CURRENCY}", wn.Currency, -1)
	wNotice = strings.Replace(wNotice, "${OPENRTB_CURRENCY}", wn.Currency, -1)
	wNotice = strings.Replace(wNotice, "${AUCTION_LOSS}", "102", -1)
	wNotice = strings.Replace(wNotice, "${OPENRTB_LOSS}", "102", -1)
	ch <- wNotice
}

func GetHighestBid(arrRes []bidderResponse) (map[string]customapi.CustomResponse, []string) {

	var lnotices []string
	mp := make(map[string]customapi.CustomResponse)

	for _, v := range arrRes {

		if v.Response != nil {

			var cr customapi.CustomResponse
			switch t := v.Response.(type) {

			case *openrtb.BidResponse:
				for _, v1 := range t.SeatBid {
					if len(v1.Bid) > 0 {
						var p float64
						ch := make(chan result, 1)
						go new25(ch, t.ID, t.BidID, t.Currency, v1, v.Bidderid)
						for res := range ch {
							p = res.p
							cr = res.cr
						}
						if val, ok := mp[v1.Bid[0].ImpID]; ok {
							if val.Price < p {

								if v.At == 2 {
									cr.Price = cr.Price + v.SeconBidBuffer
								}
								mp[v1.Bid[0].ImpID] = cr
							} else {
								ch := make(chan string, 1)
								go replaceMacros(ch, cr, v1.Bid[0].LURL)
								url := constants.AppProtocol + constants.AppHost + constants.AppPort + constants.LossNoticeEndPoint + "?id=" + t.ID + "&bidderid=" + strconv.Itoa(v.Bidderid) + "&lurl=" + base64.StdEncoding.EncodeToString([]byte(<-ch))
								lnotices = append(lnotices, url)
							}
						} else {
							ch := make(chan result, 1)
							go new25(ch, t.ID, t.BidID, t.Currency, v1, v.Bidderid)
							for res := range ch {
								p = res.p
								cr = res.cr
							}
							if v.At == 2 {
								cr.Price = cr.Price + v.SeconBidBuffer
							}
							mp[v1.Bid[0].ImpID] = cr
						}
					}
				}
			}
		}
	}

	return mp, lnotices
}

func new25(ch chan result, id string, bidid string, cur string, v1 openrtb.SeatBid, bidderid int) {
	defer close(ch)
	res := new(result)
	res.p = v1.Bid[0].Price

	for _, v2 := range v1.Bid {

		if v2.Price >= res.p {
			res.cr.ID = id
			res.cr.BidID = bidid
			res.cr.Currency = cur
			res.cr.Seat = v1.Seat
			res.cr.Imp = v2.ImpID
			res.cr.AdID = v2.AdID
			res.cr.CID = v2.CampaignID
			res.cr.Adm = v2.AdMarkup
			res.p = v2.Price
			res.cr.Price = v2.Price
			res.cr.BURL = v2.BURL
			res.cr.NURL = v2.NURL
			res.cr.Bidderid = bidderid
		}
	}
	ch <- *res
}
