package rhandler

import (
	"alpha/adDelivery"
	"alpha/adDelivery/helper"
	"fmt"
	"net/http"
	"net/url"
	"time"
)

// Home function for home handler
func Home(w http.ResponseWriter, r *http.Request) {

	html := `<html>
		<head>
			<title>Ad Delivery System</title>
		</head>
		<body>
			<h1>Ad Delivery System</h1>
		</body>
	</html>`
	w.Write([]byte(html))
}

func AsyncJs(w http.ResponseWriter, r *http.Request) {
	content := adDelivery.AsyncJs(w, r)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Content-Type", "text/html; charset=utf-8")

	// Set the default value for Access-Control-Allow-Origin
	w.Header().Set("Access-Control-Allow-Origin", "*")

	// Try to parse the "loc" URL parameter
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		// If parsing is successful, set Access-Control-Allow-Origin based on the parsed URL
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	} else {
		// If parsing fails, try to get Access-Control-Allow-Origin from the Referer header
		u, _ := url.Parse(r.Header.Get("Referer"))
		w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	}

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	w.Write([]byte(content))
}

func Video(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.VideoTag(w, r)
	// deviceSession := helper.GetUrlParam(r, "deviceSession")
	// rand := helper.GetUrlParam(r, "rand")
	// adDuration := helper.GetUrlParam(r, "adDuration")
	// clientIp := helper.GetUrlParam(r, "clientIp")
	// ref := helper.GetUrlParam(r, "ref")
	// ua := helper.GetUrlParam(r, "ua")
	// uuid := helper.GetUrlParam(r, "uuid")
	// segUpid := helper.GetUrlParam(r, "segUpid")
	// pid := helper.GetUrlParam(r, "pid")
	// passKey := helper.GetUrlParam(r, "passKey")
	// user_id := helper.GetUrlParam(r, "user_id")

	// fmt.Println("deviceSession", deviceSession)
	// fmt.Println("rand", rand)
	// fmt.Println("adDuration", adDuration)
	// fmt.Println("clientIp", clientIp)
	// fmt.Println("ref", ref)
	// fmt.Println("ua", ua)
	// fmt.Println("uuid", uuid)
	// fmt.Println("segUpid", segUpid)
	// fmt.Println("pid", pid)
	// fmt.Println("passKey", passKey)
	// fmt.Println("user_id", user_id)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Content-Type", "application/xml")
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(r.Header.Get("Referer"))

	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	w.Write([]byte(content))
}

func Audio(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.AudioTag(w, r)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Content-Type", "application/xml")
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(r.Header.Get("Referer"))

	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	w.Write([]byte(content))

}

func Ajs(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.AjsTag(w, r)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Content-Type", "text/html; charset=utf-8")

	// Set the default value for Access-Control-Allow-Origin
	w.Header().Set("Access-Control-Allow-Origin", "*")

	// Try to parse the "loc" URL parameter
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		// If parsing is successful, set Access-Control-Allow-Origin based on the parsed URL
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	} else {
		// If parsing fails, try to get Access-Control-Allow-Origin from the Referer header
		u, _ := url.Parse(r.Header.Get("Referer"))
		w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	}

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	w.Write([]byte(content))

}

func Async(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.AsyncTag(w, r)

	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Content-Type", "text/html; charset=utf-8")

	// Set the default value for Access-Control-Allow-Origin
	w.Header().Set("Access-Control-Allow-Origin", "*")

	// Try to parse the "loc" URL parameter
	m, err := url.Parse(helper.GetUrlParam(r, "loc"))
	if err == nil {
		// If parsing is successful, set Access-Control-Allow-Origin based on the parsed URL
		w.Header().Set("Access-Control-Allow-Origin", m.Scheme+"://"+m.Host)
	} else {
		// If parsing fails, try to get Access-Control-Allow-Origin from the Referer header
		u, _ := url.Parse(r.Header.Get("Referer"))
		w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	}

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	// allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	// w.Header().Set("Access-Control-Allow-Origin", "*")
	// //u, _ := url.Parse(helper.GetUrlParam(r, "loc"))
	// w.Header().Set("Access-Control-Allow-Origin", "https://platform.brackenads.com")
	// w.Header().Set("Access-Control-Allow-Credentials", "true")
	// w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	// w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	// w.Header().Set("Access-Control-Expose-Headers", "Authorization")

	w.Write([]byte(content))
}

func Iframe(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.IframeTag(w, r)

	w.Write([]byte(content))
}

func Outstream(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.Outstream(w, r)

	w.Write([]byte(content))
}

func Vastxml(w http.ResponseWriter, r *http.Request) {

	content := adDelivery.Vastxml(w, r)

	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Origin", "https://platform.brackenads.com")
	w.Header().Set("Content-Type", "text/xml;charset=UTF-8")

	w.Write([]byte(content))
}

func Request_sdk(w http.ResponseWriter, r *http.Request) {

	w.Header().Set("Content-Type", "application/json")
	content := adDelivery.Request_sdk(w, r)

	w.Write([]byte(content))
}

func Cookiesync(w http.ResponseWriter, r *http.Request) {

	// v := helper.GetUrlParam(r, "v")
	put := helper.GetUrlParam(r, "put")
	expire := helper.GetUrlParam(r, "expire")
	expired := time.Now().AddDate(0, 0, helper.StringToInt(expire))
	c := http.Cookie{
		Name:    "DSP_COOK",
		Value:   put,
		Expires: expired,
	}

	http.SetCookie(w, &c)
}

func TestResponse(w http.ResponseWriter, r *http.Request) {
	loc, _ := time.LoadLocation("UTC")
	var timenow int64 = time.Now().In(loc).UnixNano() / 1000000
	fmt.Println("Request Start time :", timenow)
	content := "Test response"
	allowedHeaders := "Accept, Content-Type, Content-Length, Accept-Encoding, Authorization,X-CSRF-Token"
	w.Header().Set("Access-Control-Allow-Origin", "*")
	u, _ := url.Parse(helper.GetUrlParam(r, "loc"))
	w.Header().Set("Content-Type", "text/json; charset=utf-8")
	w.Header().Set("Access-Control-Allow-Origin", u.Scheme+"://"+u.Host)
	w.Header().Set("Access-Control-Allow-Credentials", "true")
	w.Header().Set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, PUT, DELETE")
	w.Header().Set("Access-Control-Allow-Headers", allowedHeaders)
	w.Header().Set("Access-Control-Expose-Headers", "Authorization")
	w.Write([]byte(content))
	locc, _ := time.LoadLocation("UTC")
	var timenoww int64 = time.Now().In(locc).UnixNano() / 1000000
	fmt.Println("Request End time :", timenoww)
}
