package zone

import (
	"alpha/adDelivery/ads"
	"alpha/adDelivery/ads_external"
	"alpha/adDelivery/structure"
	"crypto/md5"
	"io/ioutil"
	"strings"

	"github.com/elliotchance/phpserialize"

	config "alpha/configuration"
	"fmt"
)

func GetZoneDetails(outputData *structure.OutputData) bool {

	if outputData.Zone_id == 0 {
		return false
	}

	var zone_id int

	zone_id = outputData.Zone_id

	Zone_info := ZoneModel_ZoneInfo(zone_id)
	// fmt.Printf("Zone info %+v\n", Zone_info)
	outputData.Zone_details = Zone_info

	if Zone_info.Zoneid == 0 {
		return false
	}

	var AffAdditional map[interface{}]interface{}
	if Zone_info.Comments != "" {
		phpserialize.Unmarshal([]byte(Zone_info.Comments), &AffAdditional)
	}

	if AffAdditional["app_type"] == nil {
		return false
	}

	if Zone_info.Delivery != "6" && Zone_info.Delivery != "7" && fmt.Sprint(AffAdditional["app_type"]) != outputData.Affliate_type {
		return false
	}

	if outputData.Tag_type == "outstream" && Zone_info.Delivery != "10" {
		return false
	}

	if outputData.Tag_type == "video" && Zone_info.Delivery != "6" && Zone_info.Delivery != "7" {
		return false
	}

	if outputData.Tag_type == "audio" && Zone_info.Delivery != "6" {
		return false
	}

	if outputData.Tag_type == "sdk" && Zone_info.Delivery != "0" && Zone_info.Delivery != "3" && Zone_info.Delivery != "10" {
		return false
	}

	outputData.Zone_details = Zone_info
	return true
}

func GetBannerDetails(outputData *structure.OutputData) {

	Zone_info := outputData.Zone_details

	switch Zone_info.Inventory_type {
	case 1:

		ads.GetInternalAds(outputData)

	case 2:
		ads_external.GetExernalAds(outputData)

	case 3:
		ads_external.GetExernalAds(outputData)

		if outputData.External_ad != true {
			ads.GetInternalAds(outputData)
		}

	case 4:
		ads.GetInternalAds(outputData)

		if outputData.Internal_ad != true {
			ads_external.GetExernalAds(outputData)
		}
	default:
		ads.GetInternalAds(outputData)
	}

	if outputData.Internal_ad != true && outputData.External_ad != true {

		outputData.Html = outputData.House_ad.Html
		outputData.Internal_ad = true
		outputData.Ad_id = outputData.House_ad.Ad_id
		outputData.Placement_id = outputData.House_ad.Placement_id
		outputData.Imp_url = outputData.House_ad.Imp_url
		outputData.Click_url = outputData.House_ad.Click_url

		if outputData.House_ad.Ad_id != 0 && Zone_info.Delivery != "6" && Zone_info.Delivery != "7" && outputData.Tag_type != "sdk" {

			outputData.Html = outputData.Zone_details.Passbacktag
		} else if outputData.House_ad.Ad_id != 0 && Zone_info.Delivery != "6" && Zone_info.Delivery != "7" && outputData.Tag_type == "sdk" && Zone_info.Delivery != "10" {

			outputData.Html = outputData.Zone_details.Passbacktag
		} else {

			outputData.Html = outputData.Zone_details.Passbacktag
		}

	}

}

func ConvertJs(html string) string {

	var jsLines []string
	var search []string
	var replace []string

	search = append(search, "\\")
	search = append(search, "\r")
	search = append(search, "'")
	search = append(search, "<")

	replace = append(replace, "\\\\")
	replace = append(replace, "")
	replace = append(replace, "\\'")
	replace = append(replace, "<'+'")

	for i, element := range search {

		html = strings.ReplaceAll(html, element, replace[i])
	}

	lines := strings.Split(html, "\n")

	for _, e := range lines {

		if strings.Trim(e, "") != "" {

			jsLines = append(jsLines, "ox_name += '"+strings.Trim(e, "")+"';\n")
		}

	}

	buffer := "var ox_name = '';\n "
	buffer = buffer + strings.Join(jsLines, "\n")
	buffer = buffer + "\ndocument.write(ox_name);\n"

	return buffer

}

func LoadAsyncjs() string {

	data, _ := ioutil.ReadFile("js/async.js")
	jsContent := string(data)

	GO_ETAG := fmt.Sprintf("%x", md5.Sum([]byte(config.GetConfig("delivery", "webpath")+"*"+config.GetConfig("deliverySSL", "webpath"))))
	GO_PRODUCT := config.GetConfig("product", "var")
	GO_ASYNC_DELIVERY := config.GetConfig("commonpath", "file") + config.GetConfig("asyncspc", "file")

	jsContent = strings.ReplaceAll(jsContent, "GO_ETAG", GO_ETAG)
	jsContent = strings.ReplaceAll(jsContent, "GO_PRODUCT", GO_PRODUCT)
	jsContent = strings.ReplaceAll(jsContent, "GO_ASYNC_DELIVERY", GO_ASYNC_DELIVERY)

	return jsContent

}
