package structure

import (
	"database/sql"
	"net/http"
)

type OutputData struct {
	R                    *http.Request
	Zone_id              int
	Zone_details         ZoneDetails
	Html                 string
	HtmlInterface        map[string]interface{}
	Ad_id                int
	Placement_id         int
	Imp_url              string
	Click_url            string
	Internal_ad          bool
	External_ad          bool
	Tag_type             string
	Affliate_type        string // 1 - Android , 2 - iOS , 3 - Website
	Zone_type            string // image , inline_video, overlay_video, outstream
	Zone_type_additional string //  outstream - in_article , in_feed, native, intertitial,rewareded , in_banner
	Delivery_type        int    // 1 - Web , 2 - SDK
	Is_house_ad          bool
	House_ad             HouseAd
	VideoAdPod           int
	VideoAdPod_limit     int
	Userid               string
	Passkey              string
}

type HouseAd struct {
	Html          string
	HtmlInterface map[string]interface{}
	Ad_id         int
	Placement_id  int
	Imp_url       string
	Click_url     string
}

type ZoneDetails struct {
	Zoneid                  int
	Affiliateid             int
	Zonename                string
	Description             string
	Delivery                string
	Zonetype                int
	Category                string
	Width                   int
	Height                  int
	Ad_selection            string
	Chain                   string
	Prepend                 string
	Append                  string
	Appendtype              int
	Forceappend             string
	Inventory_forecast_type int
	Comments                string
	Cost                    float64
	Cost_type               int
	Cost_iable_id           string
	Technology_cost         float64
	Technology_cost_type    int
	Updated                 string
	Block                   int
	Capping                 int
	Session_capping         int
	What                    string
	Rate                    float64
	Pricing                 string
	Oac_category_id         int
	Ext_adselection         string
	Show_capped_no_cookie   int
	Inventory_type          int
	Inv_type                int
	Ssp_buyer               string
	Passbacktag             string
	Vidtype                 int
	Reward                  string
	Amount                  string
	Position                string
	Layout                  string
	Infeedads               string
	Infeedpos               string
	Adposition              string
	Adinterval              string
	Affiliate_name          string
	SeconBidBuffer          float64
}

type AdLinkedZone struct {
	Ad_id                 int
	Placement_id          int
	Status                int
	Width                 int
	Ext_bannertype        string
	Height                int
	Type                  string
	Weight                int
	Adserver              string
	Block_ad              int
	Cap_ad                int
	Session_cap_ad        int
	Compiledlimitation    string
	Acl_plugins           sql.NullString
	Alt_filename          string
	Priority              float64
	Priority_factor       int
	To_be_delivered       int
	Campaign_id           int
	Campaign_priority     int
	Campaign_weight       int
	Campaign_companion    int
	Block_campaign        int
	Cap_campaign          int
	Session_cap_campaign  int
	Show_capped_no_cookie int
	Client_id             int
	Expire_time           string
	Revenue_type          int
	Ecpm_enabled          int
	Ecpm                  float64
	Tracker_status        string
	PriorityFinal         float64
}

type GlobalVariables struct {
	R               *http.Request
	Ip_address      string
	Latitude        string
	Longitude       string
	Country_code    string
	Country_name    string
	Subdivision_one string
	Subdivision_two string
	Continent       string
	City            string
	Postal_code     string
	UsMetro         string
	Organisation    string
	ConnectionType  string
	Useragent       string
	DeviceName      string
	DeviceModel     string
	DeviceType      string
	Os              string
	Osv             string
	OsShort         string
	Language        string
	Domain          string
	Browser         string
	BrowserVersion  string
	BrowserShort    string
	Hostname        string
	PageURL         string
	RefURL          string
	DomainName      string
	Source          string
	Cookieid        string
}
