package globalvariables

import (
	"alpha/adDelivery/helper"
	"alpha/adDelivery/structure"
	"fmt"
	"net"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/oschwald/geoip2-golang"

	config "alpha/configuration"

	"github.com/avct/uasurfer"
)

func SetAllGrobalVariables(r *http.Request) structure.GlobalVariables {

	var alpha2ToAlpha3 = map[string]string{
		"AF": "AFG", "AX": "ALA", "AL": "ALB", "DZ": "DZA", "AS": "ASM", "AD": "AND",
		"AO": "AGO", "AI": "AIA", "AQ": "ATA", "AG": "ATG", "AR": "ARG", "AM": "ARM",
		"AW": "ABW", "AU": "AUS", "AT": "AUT", "AZ": "AZE", "BS": "BHS", "BH": "BHR",
		"BD": "BGD", "BB": "BRB", "BY": "BLR", "BE": "BEL", "BZ": "BLZ", "BJ": "BEN",
		"BM": "BMU", "BT": "BTN", "BO": "BOL", "BQ": "BES", "BA": "BIH", "BW": "BWA",
		"BV": "BVT", "BR": "BRA", "IO": "IOT", "BN": "BRN", "BG": "BGR", "BF": "BFA",
		"BI": "BDI", "CV": "CPV", "KH": "KHM", "CM": "CMR", "CA": "CAN", "KY": "CYM",
		"CF": "CAF", "TD": "TCD", "CL": "CHL", "CN": "CHN", "CX": "CXR", "CC": "CCK",
		"CO": "COL", "KM": "COM", "CD": "COD", "CG": "COG", "CK": "COK", "CR": "CRI",
		"HR": "HRV", "CU": "CUB", "CW": "CUW", "CY": "CYP", "CZ": "CZE", "DK": "DNK",
		"DJ": "DJI", "DM": "DMA", "DO": "DOM", "EC": "ECU", "EG": "EGY", "SV": "SLV",
		"GQ": "GNQ", "ER": "ERI", "EE": "EST", "SZ": "SWZ", "ET": "ETH", "FK": "FLK",
		"FO": "FRO", "FJ": "FJI", "FI": "FIN", "FR": "FRA", "GF": "GUF", "PF": "PYF",
		"TF": "ATF", "GA": "GAB", "GM": "GMB", "GE": "GEO", "DE": "DEU", "GH": "GHA",
		"GI": "GIB", "GR": "GRC", "GL": "GRL", "GD": "GRD", "GP": "GLP", "GU": "GUM",
		"GT": "GTM", "GG": "GGY", "GN": "GIN", "GW": "GNB", "GY": "GUY", "HT": "HTI",
		"HM": "HMD", "VA": "VAT", "HN": "HND", "HK": "HKG", "HU": "HUN", "IS": "ISL",
		"IN": "IND", "ID": "IDN", "IR": "IRN", "IQ": "IRQ", "IE": "IRL", "IM": "IMN",
		"IL": "ISR", "IT": "ITA", "JM": "JAM", "JP": "JPN", "JE": "JEY", "JO": "JOR",
		"KZ": "KAZ", "KE": "KEN", "KI": "KIR", "KP": "PRK", "KR": "KOR", "KW": "KWT",
		"KG": "KGZ", "LA": "LAO", "LV": "LVA", "LB": "LBN", "LS": "LSO", "LR": "LBR",
		"LY": "LBY", "LI": "LIE", "LT": "LTU", "LU": "LUX", "MO": "MAC", "MG": "MDG",
		"MW": "MWI", "MY": "MYS", "MV": "MDV", "ML": "MLI", "MT": "MLT", "MH": "MHL",
		"MQ": "MTQ", "MR": "MRT", "MU": "MUS", "YT": "MYT", "MX": "MEX", "FM": "FSM",
		"MD": "MDA", "MC": "MCO", "MN": "MNG", "ME": "MNE", "MS": "MSR", "MA": "MAR",
		"MZ": "MOZ", "MM": "MMR", "NA": "NAM", "NR": "NRU", "NP": "NPL", "NL": "NLD",
		"NC": "NCL", "NZ": "NZL", "NI": "NIC", "NE": "NER", "NG": "NGA", "NU": "NIU",
		"NF": "NFK", "MK": "MKD", "MP": "MNP", "NO": "NOR", "OM": "OMN", "PK": "PAK",
		"PW": "PLW", "PS": "PSE", "PA": "PAN", "PG": "PNG", "PY": "PRY", "PE": "PER",
		"PH": "PHL", "PN": "PCN", "PL": "POL", "PT": "PRT", "PR": "PRI", "QA": "QAT",
		"RE": "REU", "RO": "ROU", "RU": "RUS", "RW": "RWA", "BL": "BLM", "SH": "SHN",
		"KN": "KNA", "LC": "LCA", "MF": "MAF", "PM": "SPM", "VC": "VCT", "WS": "WSM",
		"SM": "SMR", "ST": "STP", "SA": "SAU", "SN": "SEN", "RS": "SRB", "SC": "SYC",
		"SL": "SLE", "SG": "SGP", "SX": "SXM", "SK": "SVK", "SI": "SVN", "SB": "SLB",
		"SO": "SOM", "ZA": "ZAF", "GS": "SGS", "SS": "SSD", "ES": "ESP", "LK": "LKA",
		"SD": "SDN", "SR": "SUR", "SJ": "SJM", "SE": "SWE", "CH": "CHE", "SY": "SYR",
		"TW": "TWN", "TJ": "TJK", "TZ": "TZA", "TH": "THA", "TL": "TLS", "TG": "TGO",
		"TK": "TKL", "TO": "TON", "TT": "TTO", "TN": "TUN", "TR": "TUR", "TM": "TKM",
		"TC": "TCA", "TV": "TUV", "UG": "UGA", "UA": "UKR", "AE": "ARE", "GB": "GBR",
		"UM": "UMI", "US": "USA", "UY": "URY", "UZ": "UZB", "VU": "VUT", "VE": "VEN",
		"VN": "VNM", "VG": "VGB", "VI": "VIR", "WF": "WLF", "EH": "ESH", "YE": "YEM",
		"ZM": "ZMB", "ZW": "ZWE",
	}
	globalValues := structure.GlobalVariables{}
	ip, _ := getIP(r)

	ip_records, _ := GetRecord(ip)

	globalValues.Ip_address = ip

	if ip_records != nil {
		globalValues.Latitude = strconv.FormatFloat(float64(ip_records.Location.Latitude), 'f', 2, 64)
		globalValues.Longitude = strconv.FormatFloat(float64(ip_records.Location.Longitude), 'f', 2, 64)
		globalValues.Country_code = ip_records.Country.IsoCode
		globalValues.Country_name = ip_records.Country.Names["en"]
		globalValues.Country_code, _ = alpha2ToAlpha3[globalValues.Country_code]

		// languages := ip_records.Country.Names
		// for code, name := range languages {
		// 	fmt.Printf("Language Code: %s, Language Name: %s\n", code, name)
		// }
		//~ globalValues.Subdivision_one = ip_records.Subdivisions[0].IsoCode
		globalValues.Continent = ip_records.Continent.Code
		globalValues.City = ip_records.City.Names["en"]

		if len(ip_records.Subdivisions) == 2 {
			globalValues.Subdivision_two = ip_records.Subdivisions[1].IsoCode

		}
		// globalValues.UsMetro = fmt.Sprint(ip_records.Location.MetroCode)
	}

	bnname := helper.GetUrlParam(r, "bnname")

	Device := strings.SplitN(bnname, ",", 2)

	if len(Device) == 2 {

		globalValues.DeviceName = Device[0]
		globalValues.DeviceModel = Device[1]
	}

	ua := r.UserAgent()

	globalValues.Useragent = ua
	uaDetails := uasurfer.Parse(ua)

	globalValues.Browser = strings.TrimPrefix(uaDetails.Browser.Name.String(), "Browser")

	globalValues.DeviceType = strings.TrimPrefix(uaDetails.DeviceType.String(), "Device")

	globalValues.BrowserVersion = strconv.Itoa(uaDetails.Browser.Version.Major) + "." + strconv.Itoa(uaDetails.Browser.Version.Minor) + "." + strconv.Itoa(uaDetails.Browser.Version.Patch)

	globalValues.Os = strings.TrimPrefix(uaDetails.OS.Name.String(), "OS")
	globalValues.Osv = strconv.Itoa(uaDetails.OS.Version.Major) + "." + strconv.Itoa(uaDetails.OS.Version.Minor) + "." + strconv.Itoa(uaDetails.OS.Version.Patch)

	links := config.GetConfig("protocol", "webpath") + r.Host + r.URL.String()
	us, _ := url.Parse(links)

	buyerid, buyerid_err := r.Cookie("DSP_COOK")
	if buyerid_err == nil {
		globalValues.Cookieid = buyerid.Value
	}

	globalValues.Hostname = parserURL(us, "Hostname")
	globalValues.DomainName = parserURL(us, "Hostname")
	globalValues.PageURL = links
	globalValues.RefURL = r.Header.Get("Referer")
	globalValues.Source = GetUrlParam(r, "loc")
	globalValues.R = r

	return globalValues
}

func parserURL(u *url.URL, name string) string {

	switch name {
	case "Hostname":
		if u.Host != "" {
			if host, _, err := net.SplitHostPort(u.Host); err == nil {
				return host
			} else {
				return u.Host
			}
		}

	}
	return ""
}

func getIP(r *http.Request) (string, error) {
	//Get IP from the X-REAL-IP header
	ip := r.Header.Get("X-REAL-IP")
	netIP := net.ParseIP(ip)
	if netIP != nil {
		return ip, nil
	}

	//Get IP from X-FORWARDED-FOR header
	ips := r.Header.Get("X-FORWARDED-FOR")
	splitIps := strings.Split(ips, ",")
	for _, ip := range splitIps {
		netIP := net.ParseIP(ip)
		if netIP != nil {
			return ip, nil
		}
	}

	//Get IP from RemoteAddr
	ip, _, err := net.SplitHostPort(r.RemoteAddr)
	if err != nil {
		return "", err
	}
	netIP = net.ParseIP(ip)
	if netIP != nil {
		return ip, nil
	}
	return "", fmt.Errorf("No valid ip found")
}

func GetRecord(ip string) (*geoip2.City, error) {

	filepath := config.GetConfig("filepath", "geommdb")
	//~ filename := "GeoLite2-City.mmdb"
	db, err := geoip2.Open(filepath)
	if err != nil {
		return nil, err
	}

	defer db.Close()
	// If you are using strings that may be invalid, check that ip is not nil
	ipv4 := net.ParseIP(ip)
	record, err := db.City(ipv4)
	if err != nil {
		return nil, err
	}
	return record, err
}

func GetUrlParam(r *http.Request, val string) string {

	value := r.URL.Query()[val]
	if len(value) != 0 {
		return value[0]
	} else {
		return ""
	}
}
