package timePack

import (
	"alpha/adDelivery/deliveryLimitation/validation"
	"regexp"
	"strconv"
	"time"
)

func Date(limitation string, op string) bool {

	layout := "2006-01-02"

	timsNow := time.Now().Format(layout)
	timerA, _ := time.Parse(layout, timsNow)
	current_date := timerA.UTC().UnixNano() / 1000000000

	reg, _ := regexp.Compile("[^0-9]+")
	str := reg.ReplaceAllString(limitation, "")
	runes := []rune(str)

	target_data := string(runes[0:4])
	target_data += "-" + string(runes[4:6])
	target_data += "-" + string(runes[6:8])

	t, _ := time.Parse(layout, target_data)
	target_date := t.UTC().UnixNano() / 1000000000

	switch op {
	case "==":
		return target_date == current_date
	case "!=":
		return !(target_date == current_date)
	case ">":
		return current_date > target_date
	case ">=":
		return current_date >= target_date
	case "<":
		return current_date < target_date
	case "<=":
		return current_date <= target_date

	}

	return false
}

func Day(limitation string, op string) bool {

	reg, _ := regexp.Compile("[^0-9,]+")
	str := reg.ReplaceAllString(limitation, "")

	val := strconv.Itoa(int(time.Now().Weekday()))

	result := validation.CheckArrayValueMatch(str, val)

	switch op {
	case "=~":
		return result
	case "!~":
		return !result
	}

	return false
}

func Hour(limitation string, op string) bool {

	reg, _ := regexp.Compile("[^0-9,]+")
	str := reg.ReplaceAllString(limitation, "")

	hours, _, _ := time.Now().Clock()

	val := strconv.Itoa(hours)

	result := validation.CheckArrayValueMatch(str, val)

	switch op {
	case "=~":
		return result
	case "!~":
		return !result
	}

	return false
}
