package ads_external

import (
	"alpha/adDelivery/globalvariables"
	"alpha/adDelivery/structure"
	"fmt"

	config "alpha/configuration"
	"bytes"
	"encoding/json"
	"io/ioutil"
	"net/http"
	"time"
)

func GetExernalAds(outputData *structure.OutputData) {

	zn := outputData.Zone_details
	zoneExtra := getZoneOpenRtbParams(outputData.Zone_id)
	pub_details := getZonePublisherDetails(outputData.Zone_id, zn.Affiliateid)
	matchedDeals := getZoneMatechedDeals(outputData.Zone_id, zn.Width, zn.Height)

	buyer_details := getZoneBuyerDetails(outputData.Zone_id, zn.Ssp_buyer)

	buffer_amount, rtb_responsetime := getAdminDetails()

	zn.SeconBidBuffer = buffer_amount

	GrobalVariables := globalvariables.SetAllGrobalVariables(outputData.R)

	var req interface{}
	var selection_type string

	if zn.Width == -12 && zn.Height == -12 {

		req = GenerateNativeImageObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "native_image"

	} else if zn.Width == -22 && zn.Height == -22 {

		req = GenerateNativeVideoObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "native_video"

	} else if zn.Width == -21 || zn.Width == -24 || zn.Width == -23 || zn.Width == -25 || zn.Width == -26 || zn.Width == -27 {

		req = GenerateVideoAudioObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "outstream"

	} else if outputData.Tag_type == "video" {

		req = GenerateVideoAudioObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "video"
	} else if outputData.Tag_type == "audio" {

		req = GenerateAudioObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "video"
	} else if outputData.Tag_type == "outstream" {

		req = GenerateVideoAudioObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "outstream"

	} else {

		req = GenerateImgObjects(outputData, zoneExtra, pub_details, matchedDeals, buyer_details, GrobalVariables)
		selection_type = "image"

	}

	request_json, _ := json.Marshal(req)

	fmt.Println()
	fmt.Println("Request", string(request_json))
	fmt.Println()

	request, err := http.NewRequest("POST", config.GetConfig("mainpath", "ssp"), bytes.NewBuffer(request_json))
	request.Header.Set("Content-Type", "application/json")
	client := &http.Client{Timeout: time.Duration(rtb_responsetime) * time.Millisecond}
	resp, err := client.Do(request)

	if err != nil {
		panic(err)
	}
	defer resp.Body.Close()

	if resp.Status == "200 OK" {

		body, _ := ioutil.ReadAll(resp.Body)

		fmt.Println()
		fmt.Println("Response", string(body))
		fmt.Println()

		responseS := ExternalResponse{}

		json.Unmarshal([]byte(body), &responseS)

		if responseS.Ads.Num1.Adm != "" {

			responseS.Ads.Num1.Adm = responseS.Ads.Num1.Adm

			if selection_type == "native_image" {

				outputData.Html = ExtenalAdRenderNativeImage(zoneExtra, responseS.Ads.Num1.Adm) + "<img width=0 height=0 src='" + responseS.Ads.Num1.Burl + "'>"
				outputData.External_ad = true
			} else if selection_type == "outstream" {

				if outputData.Tag_type == "sdk" {

					outputData.HtmlInterface = AdRenderOutstreamVideoAdSDK(responseS.Ads.Num1.Adm, zn, outputData.R)

				} else {

					respId := responseS.Ads.Num1.ID
					redisClients.SetKey("vidxml"+respId, responseS.Ads.Num1.Adm)

					var vast string
					redisClients.GetKey("vidxml"+respId, &vast)

					vastXml := config.GetConfig("protocol", "webpath") + config.GetConfig("host", "app") + config.GetConfig("port", "app") + "/vastxml" + "?xmlkey=vidxml" + respId

					outputData.Html = AdRenderOutstreamVideoAd_external(vastXml, zn.Vidtype)
				}

				outputData.External_ad = true

			} else if selection_type == "video" {

				outputData.Html = responseS.Ads.Num1.Adm
				outputData.External_ad = true

			} else {

				outputData.Html = responseS.Ads.Num1.Adm + "<img width=0 height=0 src='" + responseS.Ads.Num1.Burl + "'>"
				outputData.External_ad = true

			}

		} else if responseS.Ads.Num1.Adm == "" {

			if selection_type == "video" {
				if outputData.Zone_id == 6 {
					outputData.Html = `<VAST version="4.1">
					<Ad id="51:0.0-0">
					<Wrapper>
					<AdSystem>
					<![CDATA[ Golang SSP Server ]]>
					</AdSystem>
					<Impression>
					<![CDATA[ https://ssai.djaxbidder.com:8979/imp_url?bannerid=51&campaignid=24&zoneid=6&id=2535232471d13b44d89dd21eae_20241121545&requestid=7b353d3b-6bd5-405c-86f4-c7cfabfbf9f7&bidderid=3&banner_type=video&won_price=0.004 ]]>
					</Impression>
					<Impression>
					<![CDATA[ https://ssai.djaxbidder.com:8979/billing_notice?id=2535232471d13b44d89dd21eae_20241121545&bidderid=3&burl=aHR0cHM6Ly9yZXZwaHBlLmRqYXhiaWRkZXIuY29tOjY2MTYvYmlsbGluZ19ub3RpY2U/YXVjdGlvbklkPTI1MzUyMzI0NzFkMTNiNDRkODlkZDIxZWFlXzIwMjQxMTIxNTQ1JmJpZGlkPTI1MzUyMzI0NzFkMTNiNDRkODlkZDIxZWFlXzIwMjQxMTIxNTQ1JnByaWNlPTQuMDAmaW1waWQ9MSZzZWF0aWQ9VGVzdF9hZHZlcnRpc2VyXzEmYWRpZD01MSZjdXI9VVNE ]]>
					</Impression>
					<VASTAdTagURI>
					<![CDATA[ https://ssai.djaxbidder.com/video?zoneid=50 ]]>
					</VASTAdTagURI>
					<Creatives>
					<Creative>
					<Linear>
					<Duration/>
					<TrackingEvents>
					<Tracking event="start">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=start ]]>
					</Tracking>
					<Tracking event="firstQuartile">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=firstquartile ]]>
					</Tracking>
					<Tracking event="midpoint">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=midpoint ]]>
					</Tracking>
					<Tracking event="thirdQuartile">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=thirdquartile ]]>
					</Tracking>
					<Tracking event="complete">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=complete ]]>
					</Tracking>
					<Tracking event="pause">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=pause ]]>
					</Tracking>
					<Tracking event="mute">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=mute ]]>
					</Tracking>
					<Tracking event="fullscreen">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=fullscreen ]]>
					</Tracking>
					<Tracking event="unmute">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=unmute ]]>
					</Tracking>
					<Tracking event="creativeView">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=creativeView ]]>
					</Tracking>
					<Tracking event="acceptInvitation">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=acceptInvitation ]]>
					</Tracking>
					<Tracking event="rewind">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=rewind ]]>
					</Tracking>
					<Tracking event="resume">
					<![CDATA[ https://ssai.djaxbidder.com:8979/vast_tracking?zoneid=6&exchangeid=3&event=resume ]]>
					</Tracking>
					</TrackingEvents>
					</Linear>
					</Creative>
					</Creatives>
					</Wrapper>
					</Ad>
					</VAST>`
					outputData.External_ad = true

				}
			}
		}

	}

}
