package ads

import (
	"alpha/adDelivery/structure"
	"database/sql"
	"fmt"
	"strconv"
	"strings"

	"alpha/adDelivery/helper"
	config "alpha/configuration"

	"alpha/db"
	"crypto/md5"
	"encoding/hex"
	"path"
)

func VideoAdRenderAdPod(AlladDetails []AdDetails, zn structure.ZoneDetails, limit int, outputData *structure.OutputData) string {

	var clickurl string
	var Html string
	var VastVersion, audioType int
	if limit == 0 {

		return ""
	}

	for index, adDetails := range AlladDetails {

		if index == limit {
			break
		}

		impurl := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/lg.php?bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&campaignid=" + strconv.Itoa(adDetails.Placement_id) + "&zoneid=" + strconv.Itoa(zn.Zoneid) + "&passkey=" + outputData.Passkey + "&user_id=" + outputData.Userid
		table_prefix := config.GetConfig("prefix", "table")

		var sitCat_table = "djax_site_categories"
		var client_table = table_prefix + "clients"
		var campaign_table = table_prefix + "campaigns"
		var impression, pricingtype, skip, skip_progress_duration, adVerifications, Is_conditionalad, url_1, url_2, viewableImpression, trackingUrl, iabcategory, adservingid, advertiser, expiretime string

		fc_path := config.GetConfig("protocol", "webpath") + config.GetConfig("root", "webpath") + "/fc.php"

		vidad := VideoAd{}

		adid_str := strconv.Itoa(adDetails.Ad_id)

		redisClients.GetKey("advast"+adid_str, &vidad)

		if vidad.Banner_vast_element_id == 0 {

			DbQuery := "SELECT * from " + table_prefix + "djaxbanner_vast_element where banner_id = %d"
			DbQuery = fmt.Sprintf(DbQuery, adDetails.Ad_id)

			adVast := db.DbQueryRow(DbQuery)
			adVast.Scan(&vidad.Banner_vast_element_id, &vidad.Banner_id, &vidad.Vast_element_type, &vidad.Vast_video_id, &vidad.Vast_type, &vidad.Vast_video_duration, &vidad.Vast_video_delivery, &vidad.Get_third_internal_type, &vidad.Vast_video_type, &vidad.Vast_video_bitrate, &vidad.Vast_net_connection_url, &vidad.Vast_video_filename, &vidad.Vast_video_height, &vidad.Vast_video_width, &vidad.Vast_video_outgoing_filename, &vidad.Vast_companion_banner_id, &vidad.Vast_overlay_height, &vidad.Vast_overlay_width, &vidad.Vast_video_clickthrough_url, &vidad.Vast_overlay_action, &vidad.Vast_overlay_format, &vidad.Vast_overlay_text_title, &vidad.Vast_overlay_text_description, &vidad.Vast_overlay_text_call, &vidad.Vast_creative_type, &vidad.Vast_thirdparty_impression, &vidad.Vast_wrapper_url.String, &vidad.Vast_version, &vidad.Vast_overlay_wrapper, &vidad.Vast_overlay_version, &vidad.Vast_video_skip_duration, &vidad.Vast_video_skip_progress_duration, &vidad.Vast_thirdparty_clicktracking, &vidad.Vast_thirdparty_clickcustom, &vidad.Vast_overlay_expanded_width, &vidad.Vast_overlay_expanded_height, &vidad.Vast_thirdparty_companion_expandedwidth, &vidad.Vast_thirdparty_companion_expandedheight, &vidad.Vast_thirdparty_companion_clicktracking, &vidad.Vast_overlay_expandedminduration, &vidad.Vast_wrapper_followadditional, &vidad.Vast_wrapper_allowmultipleads, &vidad.Vast_wrapper_fallbacknoads, &vidad.Vast_thirdparty_companion_assetwidth, &vidad.Vast_thirdparty_companion_assetheight, &vidad.Vast_thirdparty_companion_pxratio, &vidad.Vast_thirdparty_companion_alttext, &vidad.Vast4_min_bitrate, &vidad.Vast4_max_bitrate, &vidad.Vast4_verificationurl2, &vidad.Vast4_verificationurl1, &vidad.Vast4_adverificationtype2, &vidad.Vast4_adverificationtype1, &vidad.Is_conditionalad, &vidad.Vast_icon_filename, &vidad.Vast_icon_width, &vidad.Vast_icon_height, &vidad.Vast_icon_xposition, &vidad.Vast_icon_yposition, &vidad.Vast_icon_duration, &vidad.Vast_icon_offset, &vidad.Icon_click_url, &vidad.Icon_track_url, &vidad.Iabcategory, &vidad.Vast_video_outgoing_filename1, &vidad.Vast_video_type_1, &vidad.Vast_video_bitrate_1, &vidad.Vast_video_outgoing_filename2, &vidad.Vast_video_type_2, &vidad.Vast_video_bitrate_2, &vidad.Ad_type, &vidad.Audio_type, &vidad.Interactive_mediafile, &vidad.Is_mezzininefile, &vidad.Mezzanine_en, &vidad.Internal_file, &vidad.Url_file, &vidad.Vast_4_1_url, &vidad.Vast_4_1_type_file, &vidad.Vast_4_1_language, &vidad.Vast_4_1_url_1, &vidad.Vast_4_1_type_file_1, &vidad.Vast_4_1_language_1, &vidad.Vast_4_1_url_2, &vidad.Vast_4_1_type_file_2, &vidad.Vast_4_1_language_2, &vidad.Blocked_category, &vidad.Vid_upload_type)

			redisClients.SetKey("advast"+adid_str, vidad)
		}
		if vidad.Vast_video_clickthrough_url.String != "" {
			clickurl = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/cl.php?oaparams=2&bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&zoneid=" + strconv.Itoa(zn.Zoneid) + "___oadest=" + vidad.Vast_video_clickthrough_url.String
		} else {
			clickurl = ""
		}

		trackingUrl = fc_path + "?script=rmvideoAds:rmvastEvent&bannerid=" + strconv.Itoa(vidad.Banner_id) + "&zoneid=" + strconv.Itoa(zn.Zoneid)
		adservingid = helper.RandToken(5) + strconv.Itoa(vidad.Banner_id)
		hasher := md5.New()
		hasher.Write([]byte(adservingid))
		adservingid = hex.EncodeToString(hasher.Sum(nil))

		/*Advertiser*/
		type Advertiser struct {
			Clientid   int
			Clientname string
			Clientexp  sql.NullString
			Revenue    sql.NullFloat64
		}
		adv := Advertiser{}

		Placement_id_str := strconv.Itoa(adDetails.Placement_id)
		redisClients.GetKey("client_"+Placement_id_str, &adv)

		if adv.Clientid == 0 {
			err := db.DbQueryRow("select cl.clientid as clientid,cl.clientname as name,c.expire_time as expire_time,c.revenue as revenue from "+client_table+" as cl,"+campaign_table+" as c where c.clientid=cl.clientid and c.campaignid=?", adDetails.Placement_id).Scan(&adv.Clientid, &adv.Clientname, &adv.Clientexp, &adv.Revenue)

			if err != nil {
				if err == sql.ErrNoRows {
					fmt.Println("No rows found.")
				} else {
					fmt.Println(err)
				}
			}

			redisClients.SetKey("client_"+Placement_id_str, &adv)
		}

		advertiser = `<Advertiser id="` + strconv.Itoa(adv.Clientid) + `">` + adv.Clientname + `</Advertiser>`
		/*Advertiser*/
		/*Expires*/
		if adv.Clientexp.String != "" {
			expiretime = `<Expires>` + adv.Clientexp.String + `</Expires>`
		}
		/*Expires*/

		/*Impression*/
		impression = `<Impression><![CDATA[` + impurl + `]]></Impression>`
		if vidad.Vast_thirdparty_impression != "" {
			impression += `<Impression><![CDATA[` + vidad.Vast_thirdparty_impression + `]]></Impression>`
		}
		/*Impression*/
		/*Adverification for Vast4*/
		if vidad.Vast4_verificationurl1.String != "" || vidad.Vast4_verificationurl2.String != "" {
			if vidad.Vast4_adverificationtype1.String == "1" {
				url_1 = `<Verification>
						<JavaScriptResource>
						<![CDATA[` + vidad.Vast4_verificationurl1.String + `]]>
						</JavaScriptResource>
					</Verification>`
			} else if vidad.Vast4_adverificationtype1.String == "2" {
				url_1 = `<Verification>
						<FlashResource>
						<![CDATA[` + vidad.Vast4_verificationurl1.String + `]]>
						</FlashResource>
					</Verification>`
			}
			if vidad.Vast4_adverificationtype2.String == "1" {
				url_2 = `<Verification>
							<JavaScriptResource>
							<![CDATA[` + vidad.Vast4_verificationurl2.String + `]]>
							</JavaScriptResource>
						</Verification>`
			} else if vidad.Vast4_adverificationtype2.String == "2" {
				url_2 = `<Verification>
							<FlashResource>
							<![CDATA[` + vidad.Vast4_verificationurl2.String + `]]>
							</FlashResource>
						</Verification>`
			}
			if url_1 != "" || url_2 != "" {
				adVerifications = `<AdVerifications>
								` + url_1 + `
								` + url_2 + `
							</AdVerifications>`
			}
		}
		/*Adverification for Vast4*/

		/*Viewable Impression*/
		viewableImpression = `<ViewableImpression id="` + strconv.Itoa(helper.RandNumber(10)) + `">
								<Viewable><![CDATA[` + trackingUrl + `&event=viewable]]></Viewable>
								<NotViewable><![CDATA[` + trackingUrl + `&event=notviewable]]></NotViewable>
								<ViewUndetermined><![CDATA[` + trackingUrl + `&event=viewundetermined]]></ViewUndetermined>
							</ViewableImpression>`
		/*Viewable Impression*/

		/*IAB Category in vast response*/
		if vidad.Iabcategory.String != "" {
			category := strings.Split(vidad.Iabcategory.String, ",")
			for _, v := range category {
				var cname string
				redisClients.GetKey("iabcategory"+v, &cname)

				if cname == "" {
					db.DbQueryRow("SELECT category_name FROM `" + sitCat_table + "` where value = '" + v + "'").Scan(&cname)
					redisClients.SetKey("iabcategory"+v, &cname)
					iabcategory += `<Category authority='http://www.iabtechlab.com/categoryauthority'><![CDATA[` + cname + `]]></Category>`
				}
			}
		}

		pricingtype = "CPM"
		/* Pricingtype */

		/*Is_conditionalad*/
		if vidad.Is_conditionalad.Int64 == 1 {
			Is_conditionalad = "true"
		} else {
			Is_conditionalad = "false"
		}
		/*Is_conditionalad*/
		/*Skip*/
		if vidad.Vast_video_skip_duration.String != "" {
			skip = `skipoffset="` + vidad.Vast_video_skip_duration.String + `"`
		}
		/*Skip*/
		/*Skip Progress*/
		if vidad.Vast_video_skip_progress_duration.String != "" {
			skip_progress_duration = `offset="` + vidad.Vast_video_skip_progress_duration.String + `"`
		} else {
			skip_progress_duration = ""
		}

		/*Skip Progress*/
		if adDetails.Width == -3 && adDetails.Height == -3 {

			var mediafile, mediafile1, mediafile2, maxbitrate, minbitrate, videoClickstrackVast, videocustomClicksVast, videoClicksVast, interactivemediafile, Mezzaninefile, icon, icontype1, resource, iprog, closedcaption, closedcaption2, closedcaption3, type1, type2, type3, lang, lang1, lang2, companions, companionclicks, companionassetheight, companionassetwidth, companionexpandedheight, companionexpandedwidth, companiontrack, companion_banner, companionclickthrough, pxRatio, companionads, companionid, UID, attr string

			/*<Clickthrough_url>*/
			if vidad.Vast_video_clickthrough_url.String != "" {
				if vidad.Vast_thirdparty_clicktracking.String != "" {
					videoClickstrackVast = `<ClickTracking><![CDATA[` + vidad.Vast_thirdparty_clicktracking.String + `]]></ClickTracking>`
				}
				if vidad.Vast_thirdparty_clickcustom.String != "" {
					videocustomClicksVast = `<CustomClick><![CDATA[` + vidad.Vast_thirdparty_clickcustom.String + `]]></CustomClick >`
				}
				videoClicksVast = `<VideoClicks>
									<ClickThrough><![CDATA[` + clickurl + `]]></ClickThrough> ` + videoClickstrackVast + videocustomClicksVast + `
								</VideoClicks>`
			}
			/*<Clickthrough_url>*/

			/*<InteractiveCreativeFile>*/
			if vidad.Interactive_mediafile.String != "" {
				interactivemediafile = `<InteractiveCreativeFile><![CDATA[` + vidad.Interactive_mediafile.String + `]]></InteractiveCreativeFile>`
			}
			/*<InteractiveCreativeFile>*/

			/*<Mezzanine>*/
			/*If upload the Mezzanine file there should be folder available in the path */
			if vidad.Is_mezzininefile.Int64 == 1 {
				if vidad.Mezzanine_en.Int64 == 1 && vidad.Internal_file.String != "" {
					Videofilepath := config.GetConfig("protocol", "webpath") + config.GetConfig("mezzanine", "webpath") + vidad.Internal_file.String
					Mezzaninefile = `<Mezzanine><![CDATA[` + Videofilepath + `]]></Mezzanine>`
				} else if vidad.Mezzanine_en.Int64 == 2 {
					Mezzaninefile = `<Mezzanine><![CDATA[` + vidad.Url_file.String + `]]></Mezzanine>`
				}
			}
			/*<Mezzanine>*/

			/*CLosed Captions*/

			if vidad.Vast_4_1_type_file.String == "1" {
				type1 = "text/srt"
			} else if vidad.Vast_4_1_type_file.String == "2" {
				type1 = "text/vtt"
			} else if vidad.Vast_4_1_type_file.String == "3" {
				type1 = "application/ttml+xml"
			}

			if vidad.Vast_4_1_type_file_1.String == "1" {
				type2 = "text/srt"
			} else if vidad.Vast_4_1_type_file_1.String == "2" {
				type2 = "text/vtt"
			} else if vidad.Vast_4_1_type_file_1.String == "3" {
				type2 = "application/ttml+xml"
			}

			if vidad.Vast_4_1_type_file_2.String == "1" {
				type3 = "text/srt"
			} else if vidad.Vast_4_1_type_file_2.String == "2" {
				type3 = "text/vtt"
			} else if vidad.Vast_4_1_type_file_2.String == "3" {
				type3 = "application/ttml+xml"
			}

			if vidad.Vast_4_1_language.String == "1" {
				lang = "en"
			} else if vidad.Vast_4_1_language.String == "2" {
				lang = "zh-TW"
			} else if vidad.Vast_4_1_language.String == "3" {
				lang = "zh-CH"
			}

			if vidad.Vast_4_1_language_1.String == "1" {
				lang1 = "en"
			} else if vidad.Vast_4_1_language_1.String == "2" {
				lang1 = "zh-TW"
			} else if vidad.Vast_4_1_language_1.String == "3" {
				lang1 = "zh-CH"
			}

			if vidad.Vast_4_1_language_2.String == "1" {
				lang2 = "en"
			} else if vidad.Vast_4_1_language_2.String == "2" {
				lang2 = "zh-TW"
			} else if vidad.Vast_4_1_language_2.String == "3" {
				lang2 = "zh-CH"
			}
			if vidad.Vast_4_1_url.String != "" {
				if vidad.Vast_4_1_url_1.String != "" {
					closedcaption2 = `<ClosedCaptionFile type='` + type2 + `' language='` + lang1 + `'><![CDATA[` + vidad.Vast_4_1_url_1.String + `]]></ClosedCaptionFile>`
				}
				if vidad.Vast_4_1_url_2.String != "" {
					closedcaption3 = `<ClosedCaptionFile type='` + type3 + `' language='` + lang2 + `'><![CDATA[` + vidad.Vast_4_1_url_2.String + `]]></ClosedCaptionFile>`
				}
				closedcaption = `<ClosedCaptionFiles>
										<ClosedCaptionFile type='` + type1 + `' language='` + lang + `'><![CDATA[` + vidad.Vast_4_1_url.String + `]]></ClosedCaptionFile>` + closedcaption2 + closedcaption3 + `
									</ClosedCaptionFiles>`
			}
			/*CLosed Captions*/

			/*Icontype*/
			k := strings.Split(path.Base(vidad.Vast_icon_filename.String), ".")
			icontype1 = string(k[1])
			if icontype1 == "jpg" || icontype1 == "jpeg" {
				icontype1 = "image/jpeg"
			} else if icontype1 == "png" {
				icontype1 = "image/png"
			} else if icontype1 == "gif" {
				icontype1 = "Image/gif"
			} else if icontype1 == "htm" {
				icontype1 = "Image/htm"
			} else {
				icontype1 = ""
			}
			/*Icontype*/
			/*Pricing*/
			pricing := `<Pricing model="` + pricingtype + `" currency="USD"><![CDATA[` + fmt.Sprintf("%.4f", adv.Revenue.Float64) + `]]></Pricing>`
			/*Pricing*/

			/*<Icon>*/
			iprog = ""
			if vidad.Vast_icon_filename.String != "" {
				if icontype1 == "image/jpeg" {
					resource = `<StaticResource creativeType="` + icontype1 + `"><![CDATA[` + vidad.Vast_icon_filename.String + `]]></StaticResource>`
				} else {
					resource = `<HTMLResource><![CDATA[` + vidad.Vast_icon_filename.String + `]]></HTMLResource>`
				}
				var IconClicks string
				if vidad.Icon_click_url.String != "" {
					IconClicks = `<IconClicks>
									<IconClickThrough><![CDATA[` + vidad.Icon_click_url.String + `]]> </IconClickThrough>
									<IconClickTracking><![CDATA[` + trackingUrl + `&event=icontrack]]></IconClickTracking>
								</IconClicks>`
				}
				icon = `<Icons>
							<Icon program="` + iprog + `" height= "` + strconv.Itoa(int(vidad.Vast_icon_height.Int64)) + `" width= "` + strconv.Itoa(int(vidad.Vast_icon_width.Int64)) + `" xPosition= "` + strconv.Itoa(int(vidad.Vast_icon_xposition.Int64)) + `" yPosition= "` + strconv.Itoa(int(vidad.Vast_icon_yposition.Int64)) + `" apiFramework="" offset= "` + vidad.Vast_icon_offset.String + `" duration= "` + vidad.Vast_icon_duration.String + `">
							` + resource + `
							` + IconClicks + `
								<IconViewTracking>
								<![CDATA[` + trackingUrl + `&event=iconimpression]]>
								</IconViewTracking>
							</Icon>
						</Icons>`
			}
			/*<Icon>*/
			/*Mediafile*/
			if vidad.Vid_upload_type.String == "Internal" {

				vidad.Vast_video_outgoing_filename.String = config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + "/" + vidad.Vast_video_outgoing_filename.String
			}
			mediafile = `<MediaFile delivery="` + vidad.Vast_video_delivery.String + `" bitrate="` + vidad.Vast_video_bitrate.String + `" width="640" height="480" ` + maxbitrate + ` ` + minbitrate + ` type="` + vidad.Vast_video_type.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[ ` + vidad.Vast_video_outgoing_filename.String + ` ]]></MediaFile>`
			if vidad.Vast_video_outgoing_filename1.String != "" {
				mediafile1 = `<MediaFile delivery="` + vidad.Vast_video_delivery.String + `" bitrate="` + vidad.Vast_video_bitrate_1.String + `" width="640" height="480" ` + maxbitrate + ` ` + minbitrate + ` type="` + vidad.Vast_video_type_1.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[ ` + vidad.Vast_video_outgoing_filename1.String + ` ]]></MediaFile>`
			}
			if vidad.Vast_video_outgoing_filename2.String != "" {
				mediafile2 = `<MediaFile delivery="` + vidad.Vast_video_delivery.String + `" bitrate="` + vidad.Vast_video_bitrate_2.String + `" width="640" height="480" ` + maxbitrate + ` ` + minbitrate + ` type="` + vidad.Vast_video_type_2.String + `" scalable="true" maintainAspectRatio="true"><![CDATA[ ` + vidad.Vast_video_outgoing_filename2.String + ` ]]></MediaFile>`
			}
			/*Mediafile*/
			/*Min Max Bitrate*/
			if vidad.Vast4_max_bitrate.Int64 != 0 {
				maxbitrate = `"maxBitrate="` + `"` + strconv.Itoa(int(vidad.Vast4_max_bitrate.Int64)) + `"`
			}
			if vidad.Vast4_min_bitrate.Int64 != 0 {
				minbitrate = `"minBitrate="` + `"` + strconv.Itoa(int(vidad.Vast4_min_bitrate.Int64)) + `"`
			}
			/*Min Max Bitrate*/

			/*Companion Ads Start*/
			if vidad.Vast_thirdparty_companion_assetwidth.Int64 != 0 {
				companionassetwidth = `assetWidth="` + strconv.Itoa(int(vidad.Vast_thirdparty_companion_assetwidth.Int64)) + `"`
			}
			if vidad.Vast_thirdparty_companion_assetheight.Int64 != 0 {
				companionassetheight = `assetHeight="` + strconv.Itoa(int(vidad.Vast_thirdparty_companion_assetheight.Int64)) + `"`
			}
			if vidad.Vast_thirdparty_companion_expandedheight != 0 {
				companionexpandedheight = `expandedHeight="` + strconv.Itoa(vidad.Vast_thirdparty_companion_expandedheight) + `"`
			}
			if vidad.Vast_thirdparty_companion_expandedwidth != 0 {
				companionexpandedwidth = `expandedWidth="` + strconv.Itoa(vidad.Vast_thirdparty_companion_expandedwidth) + `"`
			}
			if vidad.Vast_creative_type.String != "" {
				// companionresource = `<StaticResource creativeType="` + vidad.Vast_creative_type.String + `">`
			}

			if vidad.Vast_companion_banner_id != 0 {
				Details := AdDetails{}
				allAdDetails := GetAd(vidad.Vast_companion_banner_id, Details)

				width := ` width="` + strconv.Itoa(allAdDetails.Width) + `"`
				height := ` height="` + strconv.Itoa(allAdDetails.Height) + `"`
				rand1 := helper.RandToken(5)

				clickurl := ""
				clickTag_start := ""
				clickTag_end := ""

				if allAdDetails.Url != "" {
					clickurl = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/cl.php?oaparams=2&bannerid=" + strconv.Itoa(allAdDetails.Ad_id) + "&campaignid=" + strconv.Itoa(allAdDetails.Placement_id) + "&zoneid=0___oadest=" + allAdDetails.Url

					clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
					clickTag_end = `</a>`

				}

				impurl := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/lg.php?bannerid=" + strconv.Itoa(allAdDetails.Ad_id) + "&amp;campaignid=" + strconv.Itoa(allAdDetails.Placement_id) + "&amp;zoneid=0" + "&passkey=" + outputData.Passkey + "&user_id=" + outputData.Userid

				if allAdDetails.Type == "web" {
					companion_banner = `<HTMLResource>
		<![CDATA[ ` + clickTag_start + `<img src='` + config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + `/` + allAdDetails.Filename + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_c5a0d3e41e' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
		</HTMLResource>`
				} else if allAdDetails.Type == "sql" {
					companion_banner = `<HTMLResource>
			<![CDATA[` + clickTag_start + ` <img src='` + config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + `/ai.php?filename=` + allAdDetails.Filename + `&contenttype=` + allAdDetails.Contenttype + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
			</HTMLResource>`
				} else if allAdDetails.Type == "url" {
					companion_banner = `<HTMLResource>
			<![CDATA[` + clickTag_start + ` <img src='` + allAdDetails.Imageurl + `' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' alt='' title='' border='0' />` + clickTag_end + `<div id='beacon_c5a0d3e41e' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
			</HTMLResource>`
				} else if adDetails.Type == "txt" {
					companion_banner = `<HTMLResource>
			<![CDATA[ ` + clickTag_start + allAdDetails.Bannertext + `` + clickTag_end + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div> ]]>
			</HTMLResource>`
				} else if allAdDetails.Type == "html" {
					if allAdDetails.Filename != "" {
						companion_banner = `<HTMLResource>
				<![CDATA[ ` + clickTag_start + `<iframe id='rv-h5-` + rand1 + `' name='rv-h5-` + rand1 + `' src='` + config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + "/" + allAdDetails.Filename + `/index.html?CkT={CRL}'  "marginwidth='0' marginheight='0' scrolling='no'  frameborder='0' width='` + strconv.Itoa(allAdDetails.Width) + `' height='` + strconv.Itoa(allAdDetails.Height) + `' style='width: ` + strconv.Itoa(allAdDetails.Width) + `px; height: ` + strconv.Itoa(allAdDetails.Height) + `px; border: 0'></iframe>` + clickTag_end + ` ]]>
				</HTMLResource>`
					} else {
						companion_banner = `<HTMLResource>
				 <![CDATA[ <div>` + allAdDetails.Htmltemplate + `<div id='beacon_` + rand1 + `' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' /></div></div>  ]]>
				 </HTMLResource>`
					}
				}

				if vidad.Vast_type == 1 || vidad.Vast_type == 2 {

					companionads = "<CompanionAds>"
					companionid = "companion"
					if adDetails.Width == -2 && adDetails.Height == -2 {
						attr = ` scalable="true" maintainAspectRatio="true"`
					}

				} else if vidad.Vast_type == 3 || vidad.Vast_type == 4 {
					companionads = `<CompanionAds required="any">`
					companionid = strconv.Itoa(vidad.Vast_companion_banner_id)
					UID = `<UniversalAdId idRegistry="unknown">unknown</UniversalAdId>`
				}

				if vidad.Vast_thirdparty_companion_pxratio.String != "" {
					pxRatio = ` pxRatio="` + vidad.Vast_thirdparty_companion_pxratio.String + `"`
				}

				if vidad.Vast_thirdparty_companion_alttext.String != "" {
					companion_banner += `<AltText>
			<![CDATA[ ` + vidad.Vast_thirdparty_companion_alttext.String + ` ]]>
			</AltText>`
				}

				if vidad.Vast_thirdparty_companion_clicktracking != "" {
					companionclicks = `<CompanionClickTracking><![CDATA[` + vidad.Vast_thirdparty_companion_clicktracking + `]]></CompanionClickTracking>`
				}
				if allAdDetails.Url != "" {
					companionclickthrough = `<CompanionClickThrough><![CDATA[` + allAdDetails.Url + `]]></CompanionClickThrough>`
				}
				companiontrack = `<TrackingEvents>
		<Tracking event="creativeView">
		<![CDATA[` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(allAdDetails.Ad_id) + `&zoneid=0&event=creativeView]]>
		</Tracking></TrackingEvents>`

				companions = `<Creative sequence="1">
		` + companionads + `
		<Companion id="` + companionid + `"` + width + height + companionassetwidth + companionassetheight + companionexpandedwidth + companionexpandedheight + pxRatio + attr + `>
		` + companion_banner + companiontrack + `
		` + companionclicks + companionclickthrough + `
		</Companion>
		</CompanionAds>	
		` + UID + `		
		</Creative>`
			}
			/*Companion Ads End*/

			if vidad.Vast_type == 2 {

				if vidad.Get_third_internal_type.Int64 == 1 {
					Html = Html + `
						<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
							<InLine>
								<AdSystem>
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
								</AdSystem>
								<AdTitle>
								<![CDATA[ ` + adDetails.Name + ` ]]>
								</AdTitle>
								` + pricing + `
								` + impression + `
								<Creatives>
								` + companions + `
									<Creative>
										<Linear ` + skip + `>
											<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
											<TrackingEvents>
												<Tracking event="start">
												<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
													]]>
												</Tracking>
												<Tracking event="firstQuartile">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
													]]>
												</Tracking>
												<Tracking event="midpoint">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
													]]>
												</Tracking>
												<Tracking event="thirdQuartile">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
													]]>
												</Tracking>
												<Tracking event="complete">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
													]]>
												</Tracking>
												<Tracking event="pause">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
													]]>
												</Tracking>
												<Tracking event="mute">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
													]]>
												</Tracking>
												<Tracking event="fullscreen">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=fullscreen
													]]>
												</Tracking>
												<Tracking event="unmute">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
													]]>
												</Tracking>
												<Tracking event="closeLinear">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=closeLinear
													]]>
												</Tracking>
												<Tracking event="acceptInvitationLinear">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
													]]>
												</Tracking>
												<Tracking event="skip">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
													]]>
												</Tracking>
												<Tracking event="progress" ` + skip_progress_duration + `>
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
													]]>
												</Tracking>
												<Tracking event="exitFullscreen">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=exitfullscreen
													]]>
												</Tracking>
												<Tracking event="rewind">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
													]]>
												</Tracking>
												<Tracking event="resume">
												<![CDATA[
														` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
													]]>
												</Tracking>
											</TrackingEvents>
											` + videoClicksVast + `
											<MediaFiles>
												` + mediafile + `
											</MediaFiles>
										</Linear>
									</Creative>
								</Creatives>
							</InLine>
						</Ad>`
				} else {
					Html = Html + `
						<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
							<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
								<AdSystem version="3.0">
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
								</AdSystem>
								<AdTitle>
								<![CDATA[ ` + adDetails.Name + ` ]]>
								</AdTitle>
								` + pricing + `
								` + impression + `
								<VASTAdTagURI>
								<![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url.String, "&", "&", -1) + ` ]]>
								</VASTAdTagURI>
								<Creatives>
								` + companions + `
									<Creative>
										<Linear>
											<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
											<TrackingEvents>
												<Tracking event="start">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
												]]>
												</Tracking>
												<Tracking event="firstQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
												]]>
												</Tracking>
												<Tracking event="midpoint">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
												]]>
												</Tracking>
												<Tracking event="thirdQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
												]]>
												</Tracking>
												<Tracking event="complete">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
												]]>
												</Tracking>
												<Tracking event="pause">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
												]]>
												</Tracking>
												<Tracking event="mute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
												]]>
												</Tracking>
												<Tracking event="fullscreen">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=fullscreen
												]]>
												</Tracking>
												<Tracking event="unmute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
												]]>
												</Tracking>
												<Tracking event="acceptInvitationLinear">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
												]]>
												</Tracking>
												<Tracking event="closeLinear">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=closeLinear
												]]>
												</Tracking>
												<Tracking event="skip">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
												]]>
												</Tracking>
												<Tracking event="progress">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
												]]>
												</Tracking>
												<Tracking event="exitFullscreen">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=exitfullscreen
												]]>
												</Tracking>
												<Tracking event="rewind">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
												]]>
												</Tracking>
												<Tracking event="resume">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
												]]>
												</Tracking>
											</TrackingEvents>
											` + videoClicksVast + `
										</Linear>
									</Creative>
								</Creatives>
							</Wrapper>
						</Ad>`
				}
			} else if vidad.Vast_type == 3 {

				if vidad.Get_third_internal_type.Int64 == 1 {
					Html = Html + `
					<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
						<InLine>
							<AdSystem version="4.0">
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + adVerifications + `
							` + viewableImpression + `
							` + iabcategory + `
							` + pricing + `
							` + impression + `
							<Creatives>
							` + companions + `
								<Creative>
									<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
									<Linear ` + skip + `>
										<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
											]]>
											</Tracking>
											<Tracking event="progress" ` + skip_progress_duration + `>
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
											]]>
											</Tracking>
											<Tracking event="timeSpentViewing">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=timeSpentViewing
											]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
											]]>
											</Tracking>
											<Tracking event="playerExpand">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerExpand
											]]>
											</Tracking>
											<Tracking event="playerCollapse">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerCollapse
											]]>
											</Tracking>
										</TrackingEvents>
										` + videoClicksVast + `
										<MediaFiles>
											` + mediafile + `
											` + mediafile1 + `
											` + mediafile2 + `
											` + interactivemediafile + `
											` + Mezzaninefile + `
										</MediaFiles>
										` + icon + `
									</Linear>
								</Creative>
							</Creatives>
						</InLine>
					</Ad>`

				} else {
					Html = Html + `<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
						<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
							<AdSystem version="4.0">
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							` + viewableImpression + `
							` + pricing + `
							` + impression + `
							<VASTAdTagURI>
							<![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url.String, "&", "&", -1) + ` ]]>
							</VASTAdTagURI>
							<Creatives>
							` + companions + `
								<Creative>
									<Linear>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
											]]>
											</Tracking>
											<Tracking event="progress">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
											]]>
											</Tracking>
											<Tracking event="timeSpentViewing">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=timeSpentViewing
											]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
											]]>
											</Tracking>
											<Tracking event="playerExpand">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerExpand
											]]>
											</Tracking>
											<Tracking event="playerCollapse">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerCollapse
											]]>
											</Tracking>
										</TrackingEvents>
										` + videoClicksVast + `
										` + icon + `
									</Linear>
								</Creative>
							</Creatives>
						</Wrapper>
					</Ad>`
				}
			} else if vidad.Vast_type == 4 {

				if vidad.Ad_type.Int64 == 2 {

					if vidad.Get_third_internal_type.Int64 == 1 {

						Html = Html + `
						<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
							<InLine>
								<AdSystem version="4.1">
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
								</AdSystem>
								<AdServingId>` + adservingid + `</AdServingId>
								` + advertiser + `
								<Description>` + adDetails.Name + `</Description>
								` + expiretime + `
								<AdTitle>
								<![CDATA[ ` + adDetails.Name + ` ]]>
								</AdTitle>
								` + adVerifications + `
								` + viewableImpression + `
								` + iabcategory + `
								` + pricing + `
								` + impression + `
								<Creatives>
								` + companions + `
									<Creative>
										<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
										<Linear ` + skip + `>
											<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
											<TrackingEvents>
												<Tracking event="start">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
												]]>
												</Tracking>
												<Tracking event="firstQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
												]]>
												</Tracking>
												<Tracking event="midpoint">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
												]]>
												</Tracking>
												<Tracking event="thirdQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
												]]>
												</Tracking>
												<Tracking event="complete">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
												]]>
												</Tracking>
												<Tracking event="pause">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
												]]>
												</Tracking>
												<Tracking event="mute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
												]]>
												</Tracking>
												<Tracking event="unmute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
												]]>
												</Tracking>
												<Tracking event="acceptInvitationLinear">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
												]]>
												</Tracking>
												<Tracking event="skip">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
												]]>
												</Tracking>
												<Tracking event="progress" ` + skip_progress_duration + `>
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
												]]>
												</Tracking>
												<Tracking event="rewind">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
												]]>
												</Tracking>
												<Tracking event="resume">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
												]]>
												</Tracking>
												<Tracking event="timeSpentViewing">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=timeSpentViewing
												]]>
												</Tracking>
												<Tracking event="otherAdInteraction">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
												]]>
												</Tracking>
												<Tracking event="playerExpand">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerExpand
												]]>
												</Tracking>
												<Tracking event="playerCollapse">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerCollapse
												]]>
												</Tracking>
											</TrackingEvents>
											` + videoClicksVast + `
											<MediaFiles>
												` + closedcaption + `
												` + mediafile + `
												` + mediafile1 + `
												` + mediafile2 + `
												` + interactivemediafile + `
												` + Mezzaninefile + `
											</MediaFiles>
											` + icon + `
										</Linear>
									</Creative>
								</Creatives>
							</InLine>
						</Ad>`

					} else if vidad.Get_third_internal_type.Int64 == 2 {

						Html = Html + `<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
							<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
								<AdSystem version="4.1">
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
								</AdSystem>
								<AdServingId>` + adservingid + `</AdServingId>
								` + advertiser + `
								<Description>` + adDetails.Name + `</Description>
								` + expiretime + `
								` + viewableImpression + `
								` + pricing + `
								` + impression + `
								<VASTAdTagURI>
								<![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url.String, "&", "&", -1) + ` ]]>
								</VASTAdTagURI>
								<Creatives>
								` + companions + `
									<Creative>
										<Linear>
											<TrackingEvents>
												<Tracking event="start">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
												]]>
												</Tracking>
												<Tracking event="firstQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
												]]>
												</Tracking>
												<Tracking event="midpoint">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
												]]>
												</Tracking>
												<Tracking event="thirdQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
												]]>
												</Tracking>
												<Tracking event="complete">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
												]]>
												</Tracking>
												<Tracking event="pause">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
												]]>
												</Tracking>
												<Tracking event="mute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
												]]>
												</Tracking>
												<Tracking event="unmute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
												]]>
												</Tracking>
												<Tracking event="acceptInvitationLinear">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
												]]>
												</Tracking>
												<Tracking event="skip">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
												]]>
												</Tracking>
												<Tracking event="progress">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
												]]>
												</Tracking>
												<Tracking event="rewind">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
												]]>
												</Tracking>
												<Tracking event="resume">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
												]]>
												</Tracking>
												<Tracking event="timeSpentViewing">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=timeSpentViewing
												]]>
												</Tracking>
												<Tracking event="otherAdInteraction">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
												]]>
												</Tracking>
												<Tracking event="playerExpand">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerExpand
												]]>
												</Tracking>
												<Tracking event="playerCollapse">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerCollapse
												]]>
												</Tracking>
											</TrackingEvents>
											` + videoClicksVast + `
											` + icon + `
										</Linear>
									</Creative>
								</Creatives>
							</Wrapper>
						</Ad>`
					}
				} else if vidad.Get_third_internal_type.Int64 == 1 && vidad.Ad_type.Int64 == 1 {

					Html = Html + `<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
						<InLine>
							<AdSystem version="4.1">
							<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
							</AdSystem>
							<AdServingId>` + adservingid + `</AdServingId>
							` + advertiser + `
							<Description>` + adDetails.Name + `</Description>
							` + expiretime + `
							<AdTitle>
							<![CDATA[ ` + adDetails.Name + ` ]]>
							</AdTitle>
							` + adVerifications + `
							` + viewableImpression + `
							` + iabcategory + `
							` + pricing + `
							` + impression + `
							<Creatives>
							` + companions + `
								<Creative>
									<UniversalAdId idRegistry="unknown" idValue="unknown">unknown</UniversalAdId>
									<Linear ` + skip + `>
										<Duration>` + helper.SecondsToTime(int(vidad.Vast_video_duration.Int64)) + `</Duration>
										<TrackingEvents>
											<Tracking event="start">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
											]]>
											</Tracking>
											<Tracking event="firstQuartile">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
											]]>
											</Tracking>
											<Tracking event="midpoint">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
											]]>
											</Tracking>
											<Tracking event="thirdQuartile">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
											]]>
											</Tracking>
											<Tracking event="complete">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
											]]>
											</Tracking>
											<Tracking event="pause">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
											]]>
											</Tracking>
											<Tracking event="mute">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
											]]>
											</Tracking>
											<Tracking event="unmute">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
											]]>
											</Tracking>
											<Tracking event="acceptInvitationLinear">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
											]]>
											</Tracking>
											<Tracking event="skip">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
											]]>
											</Tracking>
											<Tracking event="progress" ` + skip_progress_duration + `>
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
											]]>
											</Tracking>
											<Tracking event="rewind">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
											]]>
											</Tracking>
											<Tracking event="resume">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
											]]>
											</Tracking>
											<Tracking event="timeSpentViewing">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=timeSpentViewing
											]]>
											</Tracking>
											<Tracking event="otherAdInteraction">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
											]]>
											</Tracking>
											<Tracking event="playerExpand">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerExpand
											]]>
											</Tracking>
											<Tracking event="playerCollapse">
											<![CDATA[
												` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerCollapse
											]]>
											</Tracking>
										</TrackingEvents>
										<VideoClicks>`
					if clickurl != "" {
						Html = Html + ` 
											<ClickThrough>
											<![CDATA[` + clickurl + `]]>
											</ClickThrough>`
					}
					Html = Html + videoClickstrackVast + videocustomClicksVast + `
										</VideoClicks>
										<MediaFiles>
											` + mediafile + `
											` + mediafile1 + `
											` + mediafile2 + `
											` + interactivemediafile + `
											` + Mezzaninefile + `
										</MediaFiles>
										` + icon + `
									</Linear>
								</Creative>
							</Creatives>
							<CompanionAds>
								` + companions + `			
							</CompanionAds>
						</InLine>
					</Ad>`
				} else if vidad.Get_third_internal_type.Int64 == 2 && vidad.Ad_type.Int64 == 0 {

					Html = Html + `<Ad id="` + strconv.Itoa(vidad.Banner_id) + `"  sequence="` + strconv.Itoa(index+1) + `"  conditionalAd="` + Is_conditionalad + `">
							<Wrapper fallbackOnNoAd="` + strconv.Itoa(vidad.Vast_wrapper_fallbacknoads) + `" allowMultipleAds="` + strconv.Itoa(vidad.Vast_wrapper_allowmultipleads) + `" followAdditionalWrappers="` + strconv.Itoa(vidad.Vast_wrapper_followadditional) + `">
								<AdSystem version="4.1">
								<![CDATA[ ` + config.GetConfig("name", "app") + ` ]]>
								</AdSystem>
								<AdServingId>` + adservingid + `</AdServingId>
								` + advertiser + `
								<Description>` + adDetails.Name + `</Description>
								` + expiretime + `
								` + viewableImpression + `
								` + pricing + `
								` + impression + `
								<VASTAdTagURI>
								<![CDATA[ ` + strings.Replace(vidad.Vast_wrapper_url.String, "&", "&", -1) + ` ]]>
								</VASTAdTagURI>
								<Creatives>
								` + companions + `
									<Creative>
										<Linear>
											<TrackingEvents>
												<Tracking event="start">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=start
												]]>
												</Tracking>
												<Tracking event="firstQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=firstquartile
												]]>
												</Tracking>
												<Tracking event="midpoint">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=midpoint
												]]>
												</Tracking>
												<Tracking event="thirdQuartile">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=thirdquartile
												]]>
												</Tracking>
												<Tracking event="complete">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=complete
												]]>
												</Tracking>
												<Tracking event="pause">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=pause
												]]>
												</Tracking>
												<Tracking event="mute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=mute
												]]>
												</Tracking>
												<Tracking event="unmute">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=unmute
												]]>
												</Tracking>
												<Tracking event="acceptInvitationLinear">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=acceptInvitationLinear
												]]>
												</Tracking>
												<Tracking event="skip">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=skip
												]]>
												</Tracking>
												<Tracking event="progress">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=progress
												]]>
												</Tracking>
												<Tracking event="rewind">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=rewind
												]]>
												</Tracking>
												<Tracking event="resume">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=resume
												]]>
												</Tracking>
												<Tracking event="timeSpentViewing">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=timeSpentViewing
												]]>
												</Tracking>
												<Tracking event="otherAdInteraction">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=otherAdInteraction
												]]>
												</Tracking>
												<Tracking event="playerExpand">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerExpand
												]]>
												</Tracking>
												<Tracking event="playerCollapse">
												<![CDATA[
													` + fc_path + `?script=rmvideoAds:rmvastEvent&bannerid=` + strconv.Itoa(vidad.Banner_id) + `&zoneid=` + strconv.Itoa(zn.Zoneid) + `&event=playerCollapse
												]]>
												</Tracking>
											</TrackingEvents>
											` + videoClicksVast + `
											` + icon + `
										</Linear>
									</Creative>
								</Creatives>
							</Wrapper>
						</Ad>`
				}
			}
		}

		VastVersion = vidad.Vast_type

		audioType = int(vidad.Ad_type.Int64)
	}

	if VastVersion == 2 {

		return `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="3.0" xsi:noNamespaceSchemaLocation="vast.xsd">` + Html + `</VAST>`

	} else if VastVersion == 3 {

		return `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.0" xsi:noNamespaceSchemaLocation="vast.xsd">` + Html + `</VAST>`
	} else if VastVersion == 4 && audioType != 1 {

		return `<VAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">` + Html + `</VAST>`
	} else if VastVersion == 4 && audioType == 1 {

		return `<DAAST xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="4.1" xsi:noNamespaceSchemaLocation="vast.xsd">` + Html + `</DAAST>`
	} else {

		return ""
	}
}
