package ads

import (
	"alpha/adDelivery/structure"
	"strconv"

	config "alpha/configuration"

	"github.com/elliotchance/phpserialize"

	"encoding/json"
)

func AdRenderNativeAd(adDetails *AdDetails, zn structure.ZoneDetails) {

	adDeliveryType := "web"

	var ImgTag, clickurl string
	var clickTag_start, clickTag_end string
	if adDetails.Url != "" {
		clickurl = config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/cl.php?oaparams=2&bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&campaignid=" + strconv.Itoa(adDetails.Placement_id) + "&zoneid=" + strconv.Itoa(zn.Zoneid) + "___oadest=" + adDetails.Url
		if adDeliveryType == "web" {

			clickTag_start = `<a href='` + clickurl + `' target='_blank'>`
			clickTag_end = `</a>`
		}

	}

	impurl := config.GetConfig("protocol", "webpath") + config.GetConfig("delivery", "webpath") + "/lg.php?bannerid=" + strconv.Itoa(adDetails.Ad_id) + "&amp;campaignid=" + strconv.Itoa(adDetails.Placement_id) + "&amp;zoneid=" + strconv.Itoa(zn.Zoneid)

	if adDeliveryType == "web" {
		ImgTag = `<img src='` + impurl + `' width='0' height='0' alt='' style='width: 0px; height: 0px;' />`
	}

	var native map[interface{}]interface{}
	phpserialize.Unmarshal([]byte(adDetails.Parameters), &native)

	var data_objects map[string]interface{}
	json.Unmarshal([]byte(native["data_objects"].(string)), &data_objects)

	var adTextStyle, adTextHeader, adTextBody, adTextFooter string
	var title, logo, image, image_width, image_height string
	var do_sponsored, do_description, do_ratting, do_likes, do_download, do_sales_price, do_original_price string
	var do_phone, do_description2, do_address, do_display_url, do_cta string

	if native["filename"] != nil {
		image = config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + `/` + native["filename"].(string)
	}

	if native["is_icon_image"] != nil && native["is_icon_image"].(string) == "1" && native["icon_image"] != nil {
		logo = config.GetConfig("protocol", "webpath") + config.GetConfig("images", "webpath") + `/` + native["icon_image"].(string)
	}

	if native["title"] != nil {
		title = native["title"].(string)
	}
	if native["native_height"] != nil {
		image_height = native["native_height"].(string)
	}
	if native["native_width"] != nil {
		image_width = native["native_width"].(string)
	}

	if data_objects["dj_data_address"] != nil {
		do_address = data_objects["dj_data_address"].(string)
	}
	if data_objects["dj_data_ctatext"] != nil {
		do_cta = data_objects["dj_data_ctatext"].(string)
	}
	if data_objects["dj_data_desc"] != nil {
		do_description = data_objects["dj_data_desc"].(string)
	}
	if data_objects["dj_data_desc2"] != nil {
		do_description2 = data_objects["dj_data_desc2"].(string)
	}
	if data_objects["dj_data_displayurl"] != nil {
		do_display_url = data_objects["dj_data_displayurl"].(string)
	}
	if data_objects["dj_data_downloads"] != nil {
		do_download = data_objects["dj_data_downloads"].(string)
	}
	if data_objects["dj_data_likes"] != nil {
		do_likes = data_objects["dj_data_likes"].(string)
	}
	if data_objects["dj_data_phoneno"] != nil {
		do_phone = data_objects["dj_data_phoneno"].(string)
	}
	if data_objects["dj_data_price"] != nil {
		do_original_price = data_objects["dj_data_price"].(string)
	}
	if data_objects["dj_data_salesprice"] != nil {
		do_sales_price = data_objects["dj_data_salesprice"].(string)
	}
	if data_objects["dj_data_sponsored"] != nil {
		do_sponsored = data_objects["dj_data_sponsored"].(string)
	}
	if data_objects["dj_data_rating"] != nil {
		do_ratting = data_objects["dj_data_rating"].(string)
	}

	adTextStyle = `<style>
		.nv-main-container {}

		.nv-header {
			display: table;
			width: 100%;
			padding: 5px 10px;
		}

		.nv-header-logo {
			width: 32px;
			display: table-cell;
			vertical-align: middle;
		}

		.nv-header-logo img {
			max-width: 32px;
			max-height: 32px;
		}

		.nv-header-title h3 {
			margin: auto;
		}

		.nv-header-title {
			padding: 0px 15px;
			max-width: 70%;
			display: table-cell;
			vertical-align: middle;
		}

		.nv-header-price strike {
			opacity: 0.7;
			color: #5c5959;
		}

		.nv-header-price {
			display: table-cell;
			width: 140px;
			max-width: 25%;
			text-align: right;
			vertical-align: middle;
			color: #ff5252;
			font-weight: 600;
		}

		.nv-body {
			padding: 5px 10px;
			text-align: justify;
			display: table;
			width: 100%;
		}

		.nv-body img {
			height: ` + image_height + `px;
			width: ` + image_width + `px;
			float: left;
			padding-right: 10px;
			padding-bottom: 10px;
		}

		.nv-footer {
			padding: 5px 10px;
			display: table;
			width: 100%;
		}

		.nv-footer .nv-footer-fr {
			display: table-cell;
			text-align: left;
		}

		.nv-footer .nv-footer-en {
			display: table-cell;
			text-align: left;
		}

		.nv-footer-phone,
		.nv-footer-str,
		.nv-footer-dow,
		.nv-footer-like,
		.nv-footer-cta {
			margin-bottom: 5px;
		}

		.nv-footer-cta button {
			width: 100%;
			text-align: center;
			max-width: 150px;
			padding: 8px 15px;
			background: #2f2ff6;
			color: white;
			border: none;
		}

		.nv-footer-address,
		.nv-footer-spons,
		.nv-footer-lk {
			margin-bottom: 5px;
		}
		</style>`

	adTextHeader = `<div class="nv-header">`
	if logo != "" {
		adTextHeader += `<div class="nv-header-logo"><img src="` + logo + `"></div>`
	}

	if title != "" {
		adTextHeader += `<div class="nv-header-title"><h3>` + title + `</h3></div>`
	}

	if do_original_price != "" && do_sales_price != "" {
		adTextHeader += `<div class="nv-header-price"><strike>` + do_original_price + `</strike> &nbsp;` + do_sales_price + `</div>`
	} else if do_original_price != "" {
		adTextHeader += `<div class="nv-header-price">` + do_original_price + `</div>`
	} else if do_sales_price != "" {
		adTextHeader += `<div class="nv-header-price">` + do_sales_price + `</div>`
	}
	adTextHeader += `</div>`

	adTextBody = `<div class="nv-body">`

	if image != "" {
		adTextBody += `<img class="nv-body-img" src="` + image + `">`
	}

	adTextBody += do_description

	if do_description2 != "" {

		adTextBody += `<div>` + do_description + `</div>`

	}

	adTextFooter = `<div class="nv-footer">
			
			<div class="nv-footer-fr">`
	if do_address != "" {
		adTextFooter += `<div class="nv-footer-address">` + do_address + `</div>`
	}
	if do_sponsored != "" {
		adTextFooter += `<div class="nv-footer-spons">` + do_sponsored + `</div>`
	}
	if do_display_url != "" {
		adTextFooter += `<div class="nv-footer-lk"><a href="` + do_display_url + `">` + do_display_url + `</a></div>`
	}
	adTextFooter += `</div>`

	adTextFooter += `<div class="nv-footer-en">`
	if do_phone != "" {
		adTextFooter += `<div class="nv-footer-phone">` + do_phone + `	</div>`
	}
	if do_ratting != "" {
		adTextFooter += `<div class="nv-footer-str"> ` + do_ratting + ` Star</div>`
	}
	if do_download != "" {
		adTextFooter += `<div class="nv-footer-dow">Downloads : ` + do_download + `</div>`
	}
	if do_likes != "" {
		adTextFooter += `<div class="nv-footer-like">Likes : ` + do_likes + `</div>`
	}
	if do_cta != "" {
		adTextFooter += `<div class="nv-footer-cta">` + clickTag_start + `<button type="button">` + do_cta + `</button>` + clickTag_end + `</div>`
	}

	adTextFooter += `</div>
			</div>` + ImgTag

	adDetails.Html = adTextStyle + `<div class="nv-main-container" >` + adTextHeader + adTextBody + adTextFooter + `</div>`

}
