package adDelivery

import (
	"alpha/adDelivery/helper"
	"alpha/adDelivery/structure"
	"alpha/adDelivery/zone"
	"net/http"

	"encoding/json"
	"strconv"
	"strings"
)

func Vastxml(w http.ResponseWriter, r *http.Request) string {

	keyname := helper.GetUrlParam(r, "xmlkey")
	Vastxml := zone.Vastxml(keyname)

	return Vastxml
}

func AsyncJs(w http.ResponseWriter, r *http.Request) string {

	jsContent := zone.LoadAsyncjs()
	// fmt.Printf("jsContent JS RETURN :%+s\n", jsContent)
	return jsContent
}

func AjsTag(w http.ResponseWriter, r *http.Request) string {

	outputData := structure.OutputData{}
	outputData.R = r
	outputData.Tag_type = "ajs"
	outputData.Affliate_type = "3"
	outputData.Zone_id = helper.StringToInt(helper.GetUrlParam(r, "zoneid"))

	zone.GetZoneDetails(&outputData)
	zone.GetBannerDetails(&outputData)
	return zone.ConvertJs(outputData.Html)

}

func AsyncTag(w http.ResponseWriter, r *http.Request) string {

	zones := strings.Split(helper.GetUrlParam(r, "zones"), "|")

	htmltext_all := make(map[string]AsyncTagOutput)

	for index, zoneid := range zones {

		outputData := structure.OutputData{}
		outputData.R = r
		outputData.Tag_type = "async"
		outputData.Affliate_type = "3"
		outputData.Zone_id = helper.StringToInt(zoneid)

		zone.GetZoneDetails(&outputData)
		zone.GetBannerDetails(&outputData)

		// fmt.Printf("ASYNC JSoutputData.Html RETURN :%+s\n", outputData.Html)

		htmltext_all[helper.GetUrlParam(r, "prefix")+strconv.Itoa(index)] = AsyncTagOutput{Html: outputData.Html}

	}

	data, _ := json.Marshal(htmltext_all)
	return string(data)

}

func IframeTag(w http.ResponseWriter, r *http.Request) string {

	outputData := structure.OutputData{}
	outputData.R = r
	outputData.Tag_type = "iframe"
	outputData.Affliate_type = "3"
	outputData.Zone_id = helper.StringToInt(helper.GetUrlParam(r, "zoneid"))

	zone.GetZoneDetails(&outputData)
	zone.GetBannerDetails(&outputData)

	if outputData.External_ad {
		return `<div>` + outputData.Html + `</div>`
	} else {
		return outputData.Html
	}
}

func VideoTag(w http.ResponseWriter, r *http.Request) string {

	passKey := helper.GetUrlParam(r, "passKey")
	user_id := helper.GetUrlParam(r, "user_id")

	outputData := structure.OutputData{}
	outputData.Userid = user_id
	outputData.Passkey = passKey
	outputData.R = r
	outputData.Tag_type = "video"
	outputData.Affliate_type = "3"
	outputData.Zone_id = helper.StringToInt(helper.GetUrlParam(r, "zoneid"))

	if helper.GetUrlParam(r, "format") == "vast_pod" {

		vast := helper.GetUrlParam(r, "vast")

		if vast == "vast3" || vast == "vast4" || vast == "vast4_1" || vast == "vast3_wrapper" || vast == "vast4_wrapper" || vast == "vast4_1_wrapper" {

			outputData.VideoAdPod = 1
			outputData.VideoAdPod_limit = helper.StringToInt(helper.GetUrlParam(r, "limit"))
		} else {
			return ""
		}
	}

	zone.GetZoneDetails(&outputData)
	zone.GetBannerDetails(&outputData)
	return outputData.Html
}

func AudioTag(w http.ResponseWriter, r *http.Request) string {

	outputData := structure.OutputData{}
	outputData.R = r
	outputData.Tag_type = "audio"
	outputData.Affliate_type = "3"
	outputData.Zone_id = helper.StringToInt(helper.GetUrlParam(r, "zoneid"))

	zone.GetZoneDetails(&outputData)
	zone.GetBannerDetails(&outputData)
	return outputData.Html

}

type AsyncTagOutput struct {
	Html           string `json:"html"`
	Width          int    `json:"width"`
	Height         int    `json:"height"`
	IframeFriendly bool   `json:"iframeFriendly"`
}

func Outstream(w http.ResponseWriter, r *http.Request) string {

	outputData := structure.OutputData{}
	outputData.R = r
	outputData.Tag_type = "outstream"
	outputData.Affliate_type = "3"
	outputData.Zone_id = helper.StringToInt(helper.GetUrlParam(r, "zoneid"))

	zone.GetZoneDetails(&outputData)
	zone.GetBannerDetails(&outputData)
	return zone.ConvertJs(outputData.Html)

}

func Request_sdk(w http.ResponseWriter, r *http.Request) string {

	outputData := structure.OutputData{}
	outputData.R = r
	outputData.Tag_type = "sdk"
	outputData.Affliate_type = "1"
	outputData.Zone_id = helper.StringToInt(helper.GetUrlParam(r, "zoneid"))
	is_zone := zone.GetZoneDetails(&outputData)

	sdk_error := Sdk_Error{}
	sdk := make(map[string]interface{})
	//~ sdk_ad_outs  := make( map[string]interface{} )

	if is_zone == false {
		sdk_error.Code = 102
		sdk_error.Description = "There is no zone exists for your current request"
		sdk["response"] = "Error"
		sdk["error"] = sdk_error
		data, _ := json.Marshal(sdk)
		return string(data)
	}

	zone.GetBannerDetails(&outputData)

	if outputData.Internal_ad != true && outputData.External_ad != true {

		sdk_error.Code = 102
		sdk_error.Description = "There is no banner exists for your current request"
		sdk["response"] = "Error"
		sdk["error"] = sdk_error
		data, _ := json.Marshal(sdk)
		return string(data)

	}

	if outputData.Zone_details.Delivery == "0" || outputData.Zone_details.Delivery == "3" {

		sdk_ad := Sdk_AdDelivery{}
		sdk_ad.Ad_tag = outputData.Html
		sdk_ad.Ad_type = "Floating HTML"
		sdk["response"] = "success"
		sdk["ads"] = sdk_ad
		data, _ := json.Marshal(sdk)
		return string(data)

	} else {

		sdk = outputData.HtmlInterface
		data, _ := json.Marshal(sdk)
		return string(data)

	}

}

type Sdk_AdDelivery struct {
	Imp_url   string `json:"imp_url,omitempty"`
	Ad_type   string `json:"ad_type,omitempty"`
	Ad_tag    string `json:"ad_tag,omitempty"`
	Click_url string `json:"click_url,omitempty"`
}

type Sdk_Error struct {
	Code        int    `json:"code,omitempty"`
	Description string `json:"description,omitempty"`
}
