<?php

/*
+---------------------------------------------------------------------------+
| Revive Adserver                                                           |
| http://www.revive-adserver.com                                            |
|                                                                           |
| Copyright: See the COPYRIGHT.txt file.                                    |
| License: GPLv2 or later, see the LICENSE.txt file.                        |
+---------------------------------------------------------------------------+
*/


ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

// Require the initialisation file
require_once '../../init-delivery.php';

$etag = md5("{$conf['webpath']['antiad_delivery']}*{$conf['webpath']['antiad_deliverySSL']}");
$product = $GLOBALS['_MAX']['CONF']['var']['tXxtPRtBkrTDR'];

if (!empty($_SERVER["HTTP_IF_NONE_MATCH"]) && $_SERVER["HTTP_IF_NONE_MATCH"] == $etag) {
    header("HTTP/1.x 304 Not modified");

    // Some temporary cookies might have been deleted, if so send permanent ones
    MAX_cookieFlush();

    exit;
}

header("Content-Type: text/javascript");
header("ETag: {$etag}");

// The browser is allowed to cache this
if (!empty($conf['delivery']['assetClientCacheExpire'])) {
    $expire = (int)$conf['delivery']['assetClientCacheExpire'];

    header("Expire: " . gmdate('D, d M Y H:i:s \G\M\T', MAX_commonGetTimeNow() + $expire));
    header("Cache-Control: private, max-age={$expire}");
}

// Try to set the OAID cookie, so that the following request already has it
MAX_cookieGetUniqueViewerId();
MAX_cookieFlush();

require __DIR__ . '/' . $GLOBALS['_MAX']['CONF']['file']['antiad_asyncjsjs'];
