<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['websites']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        input[type="button"]:hover {
            color: #fff !important;

        }

        .cancel-style:hover {
            color: #fff !important
        }

        .swal-footer {
            text-align: center;
        }

        .alert {
            display: none;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }
    </style>
</head>

<body onload="get_all_publisher();getWebsite()">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper <i class="menu-icon tf-icons bx bx-plus"></i> -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <form action="" method="POST" class=" mt-5">
                            <div class="nav-align-top mb-4">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" href="#"><span class="text-warning">
                                                <?php echo $GLOBALS['website_edit']; ?>
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link"
                                            href="website_invocation.php?pub_id=<?php echo $_GET['pub_id']; ?>&affiliate_id=<?php echo $_GET['affiliate_id']; ?>&website=<?php echo $_GET['website']; ?>"><span
                                                class="text-dark">
                                                <?php echo $GLOBALS['invocation_code']; ?>
                                            </span></a>
                                    </li>
                                    <!-- <li class="nav-item">
                                        <a class="nav-link" href="#agency_access.php?affiliate_id=<?php echo $_GET['affiliate_id']; ?>"><span class="text-dark">
                                                <?php echo $GLOBALS['user_access']; ?>
                                            </span></a>
                                    </li> -->
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="navs-top-zoneproperties" role="tabpanel">
                                        <div class="row mb-2">
                                            <div class="row mb-1">
                                                <div class="col-12">
                                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                                        <?php echo $GLOBALS['website_update']; ?>
                                                    </p>
                                                    <p class="alert bg-danger alert-dismissible fade show text-white"
                                                        id="alertfailed"><i class="fa fa-times-circle"></i>
                                                        <?php echo $GLOBALS['website_update_fail']; ?>
                                                    </p>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                    <label for="inputName" class="form-label">
                                                        <?php echo $GLOBALS['']; ?>Select Publisher <span
                                                            class="required text-danger"> *</span>
                                                    </label>
                                                    <select id="publist" name="publist" class="form-select text-dark">

                                                    </select>
                                                </div>
                                                <div
                                                    class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-1">
                                                    <label class="form-label" style="font-size: 1.4ch;">
                                                        <?php echo $GLOBALS['strName']; ?><span
                                                            style="color: red;">*</span>
                                                    </label>
                                                    <input type="text" id="website_name" class="form-control text-dark"
                                                        placeholder="<?php echo $GLOBALS['strName']; ?>"
                                                         oninput="changeName()"onchange="changeName()" onkeyup="changeName()" />
                                                    <p id="website_name_error" class="h6 mt-1 text-danger"></p>
                                                </div>
                                            </div>
                                            <div class="row ">
                                                <div
                                                    class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-1">
                                                    <label class="form-label" style="font-size: 1.4ch;">
                                                        <?php echo $GLOBALS['web_url']; ?><span
                                                            style="color: red;">*</span>&nbsp;<span class="form-label"
                                                            style="font-size: 1ch;">(with https://)</span>
                                                    </label>
                                                    <input type="url" name="website_url" id="website_url"
                                                        class="form-control text-dark"
                                                        placeholder="<?php echo $GLOBALS['web_url']; ?>"
                                                        onkeyup="changeWebsite()" onchange="changeWebsite()" oninput="changeWebsite()"/>
                                                    <p id="website_url_error" class="h6 mt-1 text-danger"></p>
                                                </div>
                                                <div
                                                    class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 mb-1">
                                                    <label class="form-label" style="font-size: 1.4ch;">
                                                        <?php echo $GLOBALS['Email']; ?><span
                                                            style="color: red;">*</span>
                                                    </label>
                                                    <input type="email" id="website_email"
                                                        class="form-control text-dark"
                                                        placeholder="<?php echo $GLOBALS['Email']; ?>"/>
														<!--onkeyup="changeEmail()" onchange="changeEmail()" oninput="changeEmail()"-->
                                                    <p id="website_email_error" class="h6 text-danger"></p>
                                                </div>
                                            </div>

                                            <div class="row ">
                                                <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                    <label class="form-label mb-2" style="font-size: 1.4ch;">
                                                        <?php echo $GLOBALS['contact']; ?><span
                                                            style="color: red;">*</span>
                                                    </label>
                                                    <input type="text" id="website_contact"
                                                        class="form-control text-dark"
                                                        placeholder="<?php echo $GLOBALS['contact']; ?>"
                                                        onkeyup="changeContact()" onchange="changeContact()" oninput="changeContact()"  />
                                                    <p id="website_contact_error" class="h6 text-danger"></p>
                                                </div>
                                            </div>

                                            <div class="row mt-3 mb-3">
                                                <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                                </div>
                                                <div
                                                    class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                                    <button class="btn btn-outline-danger cancel-style" type="button"
                                                        id="cancel" onclick="window.location.href='websites_list.php'">
                                                        <?php echo $GLOBALS['strCancel']; ?>
                                                    </button>&nbsp;
                                                    <button class="btn btn-warning" type="button" id="save_changes"
                                                        onclick="onSubmitWebsite()">
                                                        <?php echo $GLOBALS['strUpdate']; ?>
                                                    </button>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script>
        const live_URL = '<?php echo $apiinvenpath; ?>';
        const token = 'Bearer ' + document.getElementById('token').value;

        let agencyID = '<?php echo $_SESSION['agencyid'] ?>';
        let publisherid = '<?php echo $_GET['pub_id'] ?>';
        let affiliateid = '<?php echo $_GET['affiliate_id'] ?>';
        let editWebsite_api = live_URL + '/edit_website/';
        let getallWebsite = live_URL + '/get_all_website/' + agencyID
        let getWebsite_url = live_URL + '/get_website/' + affiliateid

        let pattern = new RegExp(
            '^(https?:\\/\\/)?' + // protocol
            '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' + // domain name
            '((\\d{1,3}\\.){3}\\d{1,3}))' + // OR ip (v4) address
            '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + // port and path
            '(\\?[;&a-z\\d%_.~+=-]*)?' + // query string
            '(\\#[-a-z\\d_]*)?$', // fragment locator
            'i'
        );
        //let emailPattern = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;

        // document.getElementById('select_publisher').value = publisherName;

        let validName, nameValidMsg, validWebsite, test1, test2;

        function get_all_publisher() {
            var agencyid = document.getElementById('agencyid').value;
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_publisher/' + agencyid,
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                var pub_name = [];
                data.data.map((data) => {
                    pub_name += `<option value=${data.id}>${data.name}</option>`;
                    document.getElementById('publist').innerHTML = pub_name;
                });
                if (publisherid != 0) {
                    $('#publist').val(publisherid);
                    $('#publist').prop('disabled', true);
                }
            });
        }

        getWebsite = () => {
            if (publisherid != "") {

                var pubid = publisherid;
            } else {
                var pubid = $("#publist option:selected").val();
            }
            $.ajax({
                url: getWebsite_url,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {
                document.getElementById('website_url').value = data.data.website;
                document.getElementById('website_name').value = data.data.name;
                document.getElementById('website_email').value = data.data.email;
                document.getElementById('website_contact').value = data.data.contact;
            });
        }

        changeWebsite = () => {
            let website_value = document.getElementById('website_url').value;
            let validURL = website_value.split('//');
            //console.log("validURL", validURL[0]);

            document.getElementById('website_url_error').innerHTML = website_value == "" ? (validWebsite = true, nameValidMsg = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`) :
                pattern.test(website_value) == false ? (validWebsite = true, `<?php echo $GLOBALS['enter_valid_url']; ?>`) :
                    (validURL[0] == 'http:' || validURL[0] == 'https:') ? (test1 = true, test2 = "") : (test1 = false, test2 = `<?php echo $GLOBALS['add_http']; ?>`);
        };

        changeName = () => {
            let name = document.getElementById('website_name').value;
            document.getElementById('website_name_error').innerHTML = name == "" ? (validName = true, `<?php echo $GLOBALS['enter_name']; ?>`) :
                (validName = false, "");
        };

        /*changeEmail = () => {
            let emailId = document.getElementById('website_email').value;
            document.getElementById('website_email_error').innerHTML = emailId == "" ? `<?php echo $GLOBALS['enter_emailid']; ?>` :
                emailId.match(emailPattern) ? "" : `<?php echo $GLOBALS['enter_right_emailid']; ?>`;
        };*/

        changeContact = () => {
            let contact = document.getElementById('website_contact').value;
            document.getElementById('website_contact_error').innerHTML = contact == "" ? `<?php echo $GLOBALS['enter_contact']; ?>` : "";
        };

        //on paste validation
        $("#website_url,#website_name,#website_email, #website_contact").bind("paste", function (e) {
            let attr_id = e.target.id;
            let pasted_data = e.originalEvent.clipboardData.getData('text');
            if (attr_id == 'website_url') {
                document.getElementById("website_url_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['strBanner_URL_validation']; ?>` : "";
            }
            if (attr_id == 'website_name') {
                document.getElementById("website_name_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['enter_name']; ?>` : "";
            }
            if (attr_id == 'website_email') {
                document.getElementById("website_email_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['website_email']; ?>` : "";
            }
            if (attr_id == 'website_contact') {
                document.getElementById("website_contact_error").innerHTML = pasted_data == "" ? `<?php echo $GLOBALS['contact']; ?>` : "";
            }
        });

        onSubmitWebsite = () => {
            var pubid = $("#publist option:selected").val();
            let website_value = document.getElementById('website_url').value;
            let validURL = website_value.split('//');
            let name = document.getElementById('website_name').value;
            let emailId = document.getElementById('website_email').value;
            let contact = document.getElementById('website_contact').value;

            changeWebsite();
            changeName();
            //changeEmail();
            changeContact();
			
			/* else if (emailId.match(emailPattern) == null) {
                document.getElementById('website_email_error').innerHTML = `<?php echo $GLOBALS['email_validation']; ?>`;
            }*/

            if (website_value == "") {
                document.getElementById('website_url_error').innerHTML = `<?php echo $GLOBALS['strBanner_URL_validation']; ?>`;
            } else if (test1 == false) {
                document.getElementById('website_url_error').innerHTML = `<?php echo $GLOBALS['add_http']; ?>`;
            } else if (pattern.test(website_value) == false) {
                document.getElementById('website_url_error').innerHTML = `<?php echo $GLOBALS['enter_valid_url']; ?>`;
            } else if (name == "") {
                document.getElementById('website_name_error').innerHTML = `<?php echo $GLOBALS['enter_name']; ?>`;
            } else if (emailId == "") {
                document.getElementById('website_email_error').innerHTML = `<?php echo $GLOBALS['website_email']; ?>`;
            } else if (contact == "") {
                document.getElementById('website_contact_error').innerHTML = `<?php echo $GLOBALS['contact']; ?>`;
            } else {
                document.getElementById('website_url_error').innerHTML = "";
                document.getElementById('website_name_error').innerHTML = "";
                document.getElementById('website_email_error').innerHTML = "";
                document.getElementById('website_contact_error').innerHTML = "";

                let payload = {
                    "pubid": pubid,
                    "website": website_value,
                    "name": name,
                    "contact": contact,
                    "email": emailId,
                    "mode": "edit"
                };

                $.ajax({
                    type: "POST",
                    url: editWebsite_api + affiliateid,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: payload,
                    dataType: "json",
                    encode: true,
                }).done(function (data) {
                    if (data.msg == 'Website details has been updated successfully!' && data.statuscode == 200) {
                        // window.location.href = "bannerlist.php";
                        $("#alertsuccess").show('medium');
                        setTimeout(function () {
                            $("#alertsuccess").hide('medium');
                        }, 2000);
                        setTimeout(function () {
                            window.location.href = "websites_edit.php?pub_id=" + pubid + "&affiliate_id=<?php echo $_GET['affiliate_id']; ?>&website=<?php echo $_GET['website']; ?>";
                        }, 1700);
                    } else if (data.msg == "Please check with input parameters" && data.response == "error") {
                        alert("Fill the all fileds in the form");
                    } else {
                        // location.reload();
                        $("#alertfailed").show('medium');
                        setTimeout(function () {
                            $("#alertfailed").hide('medium');
                        }, 2000);
                    }
                });
            }
        };
    </script>

</body>

</html>