<?php
include('session.php');
include('../config.php');
include('../common.php'); ?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
  data-template="vertical-menu-template-free">

<head>
  <meta charset="utf-8" />
  <meta name="viewport"
    content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <title>
    <?php echo $projecttitle; ?> - 
    <?php echo $GLOBALS['strChange Password']; ?>
  </title>

  <meta name="description" content="" />

  <?php include('head.php'); ?>
</head>

<body>
  <!-- Layout wrapper -->
  <div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
      <!-- Menu -->

      <?php include('sidebar.php'); ?>

      <!-- / Menu -->

      <!-- Layout container -->
      <div class="layout-page">
        <!-- Navbar -->
        <?php include('navbar.php'); ?>
        <!-- / Navbar -->

        <!-- Content wrapper -->
        <div class="content-wrapper">
          <!-- Content -->
          <div class="container">
            <div class="card mt-5 mb-5">
              <div class="card-header">
                <p class="h3">
                  <?php echo $GLOBALS['strChange Password']; ?>
                </p>
              </div>
              <div class="card-body">
                <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess" style="display:none"><i
                    class="fa fa-check-circle"></i>
                  <?php echo $GLOBALS['password_update_msg']; ?>
                </p>
                <form>
                  <div class="row mb-3">
                    <div class="col">
                      <label class="form-label mb-2" style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['strUsername']; ?>
                      </label>
                      <input type="text" class="form-control" value="<?php echo $_SESSION['username']; ?>" readonly />
                    </div>
                    <div class="col">
                      <label class="form-label mb-2" style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['full_name']; ?>
                      </label>
                      <input type="text" class="form-control" value="<?php echo $_SESSION['contact_name']; ?>"
                        readonly />
                    </div>
                  </div>
                  <div class="row mb-3">
                    <div class="col">
                      <label class="form-label mb-2" style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['email_address']; ?>
                      </label>
                      <input type="email" class="form-control" value="<?php echo $_SESSION['email_address']; ?>"
                        readonly />
                    </div>
                    <div class="col">
                      <label class="form-label mb-2" style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['CurrentPassword']; ?>
                      </label>
                      <input type="password" class="form-control" id="currentPassword" placeholder=<?php echo $GLOBALS['CurrentPassword']; ?> onchange="curr_password()" onkeyup="curr_password()" />
                      <p id="message1" style='color:red;'></p>
                    </div>
                  </div>
                  <div class="row mb-3">
                    <div class="col">
                      <label class="form-label mb-2" style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['newpassword']; ?>
                      </label>
                      <input type="password" class="form-control" id="newPassword" placeholder=<?php echo $GLOBALS['newpassword']; ?> onchange="new_pass()" onkeyup="new_pass()" />
                      <p id="message2" style='color:red;'></p>
                    </div>
                    <div class="col">
                      <label class="form-label mb-2" style="font-size: 1.4ch;">
                        <?php echo $GLOBALS['reenterpassword']; ?>
                      </label>
                      <input type="password" class="form-control" id="reEnter_newPassword" placeholder=<?php echo $GLOBALS['reenterpassword']; ?> onchange="confirm_pass()" onkeyup="confirm_pass()" />
                      <p id="error_confirmPassword" style='color:red;'></p>
                    </div>
                  </div>
                  <div class="text-end">
                    <a href="../agency/dashboard.php">
                      <button type="button" class="btn btn-outline-danger">
                        <?php echo $GLOBALS['strCancel']; ?>
                      </button>
                    </a>
                    <button class="btn btn-warning" onclick="changePassword()">
                      <?php echo $GLOBALS['strSubmit']; ?>
                    </button>
                  </div>
                  <br>
                </form>
              </div>
            </div>
          </div>
          <!-- / Content -->

          <!-- Footer -->
          <?php include('footer.php'); ?>
          <!-- / Footer -->

          <div class="content-backdrop fade"></div>
        </div>
        <!-- Content wrapper -->
      </div>
      <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>
  </div>
  <script>
    let live_URL = '<?php echo $apiinvenpath; ?>';
    const token = 'Bearer ' + document.getElementById('token').value;

    let user_id = <?php echo $_SESSION['user_id']; ?>;
    let validName, ValidUsername;

    curr_password = (data) => {
      let current_password = document.getElementById("currentPassword").value;
      document.getElementById('message1').innerHTML = current_password == "" ? (validName = true, `<?php echo $GLOBALS['enter_password']; ?>`) :
        (validName = false, "");
    };

    new_pass = (data) => {
      let new_password = document.getElementById("newPassword").value;
      document.getElementById('message2').innerHTML = new_password == "" ? (validName = true, `<?php echo $GLOBALS['enter_password']; ?>`) :
        (validName = false, "");
      document.getElementById('message2').innerHTML = new_password.length < 8 || new_password.length > 15 ? (validName = true, `<?php echo $GLOBALS['password_length']; ?>`) :
        (validName = false, "");
    };

    confirm_pass = (data) => {
      let confirm_password = document.getElementById("reEnter_newPassword").value;
      document.getElementById('error_confirmPassword').innerHTML = confirm_password == "" ? (validName = true, `<?php echo $GLOBALS['enter_password']; ?>`) :
        (validName = false, "");
    };

    changePassword = () => {
      let current_password = document.getElementById("currentPassword").value;
      let new_password = document.getElementById("newPassword").value;
      let confirm_password = document.getElementById("reEnter_newPassword").value;

      let formData = {
        "currentpassword": current_password,
        "password": new_password,
        "mode": "edit"
      };
      // curr_password();
      // new_pass();
      // confirm_pass();

      if (current_password !== "" && new_password !== "" && confirm_password !== "") {
        if (new_password == confirm_password) {
          document.getElementById("error_confirmPassword").innerHTML = "";
          //minimum password length validation
          if (new_password.length < 8 || new_password.length > 15) {
            document.getElementById("message2").innerHTML = `<?php echo $GLOBALS['password_length']; ?>`;
          } else {
            document.getElementById("message2").innerHTML = "";
            $.ajax({
              type: "POST",
              url: live_URL + '/user_change_password/' + user_id,
              beforeSend: function (xhr) {
                xhr.setRequestHeader('Authorization', token);
              },
              data: formData,
              dataType: "json",
              encode: true,
            }).done(function (data) {
              //alert((data.data.msg == "password updated successfully!" && data.data.statuscode == 200) ? data.data.msg : `<?php echo $GLOBALS['password_not_updated']; ?>`);
              if (data.data.msg == "password updated successfully!" && data.data.statuscode == 200) {
                $("#alertsuccess").show('medium');
                setTimeout(function () {
                  $("#alertsuccess").hide('medium');
                }, 1700);
                setTimeout(function () {
                  location.reload
                }, 1700);
              }
              if (data.data.msg == "Your current password not matched in old password" && data.data.statuscode == 200) {
                document.getElementById('message1').innerHTML = data.data.msg;
              } setTimeout(function () {
                location.reload();
              }, 2000);

            });
          }
        }
        else {
          document.getElementById("error_confirmPassword").innerHTML = `<?php echo $GLOBALS['confirm_password']; ?>`;
        }
      }
      else {
        curr_password();
        new_pass();
        confirm_pass();
      }
      event.preventDefault();
    };
  </script>

</body>

</html>