<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['strReport_Campaign_Report_Head']; ?>
    </title>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        /* .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        } */

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            /* word-break: break-all; */
        }

        .dtb {
            border-radius: 0;
        }

        .export {
            display: none;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 200%;
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }

        @media screen and (min-width:700px) {
            .daySelection {
                width: 30%;
                display: flex;
                justify-content: end;
            }
        }

        @media screen and (min-width:420px) and (max-width:699px) {
            .daySelection {
                width: 40%;
                display: flex;
                justify-content: center;
            }

            .main-chart {
                /* width: 200px;
                height: 400px; */
                width: auto;
                height: auto;
                margin: auto;
            }
        }

        @media screen and(min-width:220px) and (max-width:419px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

            .main-chart {
                /* width: 90%; */
                /* height: 2100px; */
                width: auto;
                height: auto;
                margin: auto;
            }

            /* #myChart4{
                width: 227px;
                height: 300px;
            } */

            /* .country-chart{
                width: 100%;
                height: 600px;
            } */
        }

        @media screen and (max-width: 219px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

        }

        .left-col {
            float: left;
            width: 45%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .center-col {
            float: left;
            width: 20%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .right-col {
            float: left;
            width: 35%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        @media only screen and (max-width: 767px) {
            .left-col {
                float: left;
                width: 45%;
                margin-top: 4rem;
                margin-bottom: 2rem;
            }

            .right-col {
                float: left;
                width: 35%;
                margin-top: 1rem;
                margin-bottom: 2rem;
                margin-right: 1px;
            }
        }
    </style>
</head>

<body onload="get_all_advertiser();">
    <div class="loader"></div>
    <input type="hidden" name="client_id" id="client_id" value="<?php echo $_GET['clientid']; ?>" />
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3 mb-5">
                            <div class="card-body">
                                <div>
                                    <div class="row mb-2 mt-2">
                                        <div class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                            <p class='h4'>
                                                <?php echo $GLOBALS['strReport_Campaign_Report_Head']; ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="row mb-2 mt-2">
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2">
                                            <select id="advlist" name="advlist" class="form-select text-dark " onchange="onChangeDetails('changed')">
                                            </select>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-1 col-lg-1 col-xl-1 col-xxl-1 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-warning" id="orderjobList_backButton" onclick="window.location.href='advertiserreport.php'">
                                                <i class="bx bx-arrow-back bg-label-white"></i>
                                                <?php echo $GLOBALS['strback']; ?>
                                            </button>&nbsp;&nbsp;
                                            <select id="getCampaign" class="form-select text-dark daySelection w-30" aria-label="Default select example" onchange="onChangeDetails()">
                                                <option value="Today">
                                                    <?php echo $GLOBALS['strToday']; ?>
                                                </option>
                                                <option value="Yesterday">
                                                    <?php echo $GLOBALS['strYesterday']; ?>
                                                </option>
                                                <option value="Last 7 days">
                                                    <?php echo $GLOBALS['strLast 7 days']; ?>
                                                </option>
                                                <option value="Last 30 days">
                                                    <?php echo $GLOBALS['strLast 30 days']; ?>
                                                </option>
                                                <option value="Last Month">
                                                    <?php echo $GLOBALS['strLast Month']; ?>
                                                </option>
                                                <option value="This Month">
                                                    <?php echo $GLOBALS['strThis Month']; ?>
                                                </option>
                                                <option value='all statistics' selected>
                                                    <?php echo $GLOBALS['strAll Statistics']; ?>
                                                </option>
                                                <option value="custom">
                                                    <?php echo $GLOBALS['strCustom']; ?>
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <input style="display: none;margin-left:3%;width:20%;" id="daterange" name="daterange" />
                                    </div>
                                    <hr class="solid">
                                    <div class="table-responsive text-nowrap">
                                        <table id="camapaignrep" class="table table-striped table-responsive">
                                            <thead>
                                                <tr class="text-dark">
                                                    <th class="text-dark">
                                                        <?php echo $GLOBALS['strName']; ?>
                                                    </th>
                                                    <th class="text-dark">
                                                        <?php echo $GLOBALS['view_imp']; ?>
                                                    </th>
                                                    <th class="text-dark text-center">
                                                        <?php echo $GLOBALS['booked'] . ' ' . $GLOBALS['strImpressions']; ?>
                                                    </th>
                                                    <th class="text-dark text-center">
                                                        <?php echo $GLOBALS['strImpressions']; ?>
                                                    </th>
                                                    <th class="text-dark text-center">
                                                        <?php echo $GLOBALS['strClicks']; ?>
                                                    </th>
                                                    <th class="text-dark text-center" style="text-align: center;">
                                                        <?php echo $GLOBALS['strConversion']; ?>
                                                    </th>
                                                    <th class="text-dark text-center" style="text-align: center;">
                                                        <?php echo $GLOBALS['view_imp_rate']; ?> %
                                                    </th>
                                                    <th class="text-dark text-center" style="text-align: center;">
                                                        <?php echo $GLOBALS['strCTR']; ?> %
                                                    </th>
                                                    <th class="text-dark text-start">
                                                        <?php echo $GLOBALS['strSpend']; ?>
                                                    </th>
                                                    <th class="text-dark text-start">
                                                        <?php echo $GLOBALS['strECPM']; ?>
                                                    </th>
                                                    <th class="text-dark text-start">
                                                        <?php echo $GLOBALS['action']; ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody id="camp_table"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <script>
                        const live_URL = '<?php echo $apistatpath; ?>';
                        var live_URL1 = '<?php echo $apiinvenpath; ?>';
                        const token = 'Bearer ' + document.getElementById('token').value;
                        let agency_id = document.getElementById('agencyid').value;
                        let getCampData = "",
                            getTodayDate;
                        let getSelectedDay = document.getElementById('getCampaign').value;
                        var cli_id = '<?php echo $_REQUEST['clientid']; ?>';
                        //document.getElementById('getCampaign').style.display = cli_id == "" ? "block" : "none";
                        document.getElementById('orderjobList_backButton').style.display = "none";
                        //API's
                        let campaign_url = live_URL + '/get_agency_campaign_report_statistics/';
                        let advertiserWise_campaign = live_URL + '/get_agency_clientwise_campaign_report_statistics/';
                        var agency_website_distribution = live_URL + '/get_agency_website_distribution/';

                        var advValue = localStorage.getItem('advValue');
                        let userid = '<?php echo $_SESSION['user_id']; ?>';
                        var permissions = [];
                        var report_data;

                        function get_all_advertiser() {
                            // var camplist_option = $('#camplist option:selected').val();
                            $.ajax({
                                type: "GET",
                                url: live_URL + '/get_all_advertiser/' + agency_id,
                                beforeSend: function(xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: {},
                                dataType: "json",
                                encode: true,
                            }).done(function(data) {
                                var client_name = [];
                                if (data.data) {
                                    defaultValue = `<option value="0" selected><?php echo $GLOBALS['all_orderjob']; ?></option>`;
                                    data.data.map((data) => {
                                        getclientLength = (data.clientname.length > 30) ? (data.clientname.slice(0, 30) + '...') : data.clientname;
                                        client_name += `<option value=${data.clientid} title="${data.clientname}">${getclientLength}</option>`;
                                        document.getElementById('advlist').innerHTML = defaultValue + client_name;
                                    });
                                }
                                if (cli_id != "") {
                                    document.getElementById('advlist').value = cli_id;
                                    $('#advlist').prop('disabled', true);
                                    document.getElementById('orderjobList_backButton').style.display = "block";
                                } else if (advValue != '' && advValue != null && advValue != 'undefined') {
                                    $('#advlist option').each(function() {
                                        if (this.value == advValue) {
                                            $("#advlist").val(advValue);
                                        }
                                    });
                                    // document.getElementById('advlist').value = advValue;
                                }
                                onChangeDetails();
                            });


                        }

                        function onChangeDetails(changed) {
                            $(".loader").show();
                            const date = new Date();
                            let getSelectedDay = document.getElementById('getCampaign').value;

                            document.getElementById('daterange').style.display = getSelectedDay == 'custom' ? "block" : "none";

                            if (getSelectedDay == 'Today') {
                                let v3 = JSON.stringify(date).slice(1, 11);
                                getTodayDate = v3;
                                // document.getElementById('getCampaign').value ='Today';
                                getCampaignDate(v3, v3);
                            } else if (getSelectedDay == 'Yesterday') {
                                let current_date = date.setDate(date.getDate() - 1);
                                const get_date = new Date(date);
                                let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                                getCampaignDate(yesterday_date, yesterday_date);
                            } else if (getSelectedDay == 'Last 7 days') {
                                let date_start = date.setDate(date.getDate() - 7);
                                let get_date = new Date(date_start);
                                let first_day = JSON.stringify(get_date).slice(1, 11);

                                let todayDate = new Date();
                                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                                const last_7Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_7Days).slice(1, 11);
                                getCampaignDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last 30 days') {
                                let date_start = date.setDate(date.getDate() - 30);
                                let get_date = new Date(date_start);
                                var first_day = JSON.stringify(get_date).slice(1, 11);

                                let todayDate = new Date();
                                let current_date = todayDate.setDate(todayDate.getDate() - 1);
                                const last_30Days = new Date(todayDate);
                                let date_end = JSON.stringify(last_30Days).slice(1, 11);
                                getCampaignDate(first_day, date_end);
                            } else if (getSelectedDay == 'This Month') {
                                let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                let cYear = firstDay.getFullYear(),
                                    cMonth = firstDay.getMonth() + 1,
                                    cDate = firstDay.getDate();
                                let first_day = cYear + "-" + cMonth + "-" + cDate;

                                let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                let year = lastDay.getFullYear(),
                                    month = lastDay.getMonth() + 1,
                                    day = lastDay.getDate();
                                let date_end = year + "-" + month + "-" + day;
                                getCampaignDate(first_day, date_end);
                            } else if (getSelectedDay == 'Last Month') {
                                var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                var formatDateComponent = function(dateComponent) {
                                    return (dateComponent < 10 ? '0' : '') + dateComponent;
                                }
                                var formatDate = function(date) {
                                    return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                };
                                var start_date = formatDate(prevMonthFirstDate),
                                    end_date = formatDate(prevMonthLastDate);
                                getCampaignDate(start_date, end_date);
                            } else if (getSelectedDay == 'all statistics') {
                                getCampaignDate(start_date = 0, end_date = 0);
                            } else if (getSelectedDay == 'custom') {
                                $(".loader").hide();
                                getCampaignDate(getTodayDate, getTodayDate);
                                $(function() {
                                    $('input[name="daterange"]').daterangepicker({
                                        opens: 'left',
                                        locale: {
                                            format: 'DD/MM/YYYY'
                                        },
                                    }, function(start, end, label) {
                                        var start_date = start.format('YYYY-MM-DD'),
                                            end_date = end.format('YYYY-MM-DD');
                                        getCampaignDate(start_date, end_date);
                                    })
                                })
                            }
                            localStorage.setItem('advValue', $("#advlist option:selected").val());
                        };

                        function getCampaignDate(start_date, end_date) {
                            if (cli_id != "") {

                                var getClient_id = cli_id;
                            } else {
                                var getClient_id = $("#advlist option:selected").val();
                            }
                            if (getClient_id == '0') {
                                getClient_id = '';
                            }
                            let payload = (start_date == 0 && end_date == 0) ? {
                                "action": 'all'
                            } : {
                                "action": '',
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,'
                            };

                            $.ajax({
                                url: getClient_id == "" ? campaign_url + agency_id : advertiserWise_campaign + getClient_id,
                                type: 'POST',
                                beforeSend: function(xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: payload,
                                success: function(data) {
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data: [],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                            }
                                        });
                                    } else if (data.msg == 'Please enter valid Advertiser Id') {
                                        $('#advlist').hide();
                                        $('#camapaignrep').DataTable({
                                            ordering: false,
                                            destroy: true,
                                            responsive: true,
                                            bPaginate: false,
                                            bInfo: false,
                                            data: [],
                                            searching: false,
                                            oLanguage: {
                                                sEmptyTable: "No Data Found"
                                            }
                                        });
                                    } else {
                                        console.log('campaign', data);
                                        $('#camapaignrep').DataTable({
                                            ordering: true,
                                            destroy: true,
                                            "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                            buttons: [{
                                                    extend: 'collection',
                                                    text: 'Export',
                                                    autoClose: true,
                                                    className: 'btn btn-warning btn-sm export dtb',
                                                    buttons: [{
                                                            text: 'Excel',
                                                            extend: 'excel',
                                                            "customize": function(xlsx) {
                                                                var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                                $('row c', sheet).attr('s', '51'); //for all rows
                                                                //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                                                //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                                            }
                                                        },
                                                        {
                                                            text: 'PDF',
                                                            extend: 'pdf',
                                                            orientation: 'landscape',
                                                            pageSize: 'LEGAL',
                                                            customize: function(doc) {
                                                                doc.styles.tableBodyEven.alignment = 'center';
                                                                doc.styles.tableBodyOdd.alignment = 'center';
                                                            },
                                                        }
                                                    ],
                                                    fade: true,
                                                },
                                                {
                                                    extend: 'spacer',
                                                    style: 'bar'
                                                },
                                                {
                                                    text: 'Campaign Report (PDF)',
                                                    autoClose: true,
                                                    className: 'btn btn-warning btn-sm export report_pdf dtb',
                                                    action: function() {
                                                        var dist = [];
                                                        if (report_data) {
                                                            var agency_head = {
                                                                "agency": report_data[0].agency_name,
                                                                "name": report_data[0].client_name,
                                                            };

                                                            if (report_data.length > 0) {
                                                                for (var i = 0; i < report_data.length; i++) {
                                                                    let remaining = report_data[i].booked_impression - report_data[i].impressions;
                                                                    let delivery_per = (report_data[i].booked_impression > 0) ? parseFloat((remaining * 100) / report_data[i].booked_impression).toFixed(2) : 0;
                                                                    let ctr = parseFloat(report_data[i].clicks / report_data[i].impressions * 100).toFixed(2);
                                                                    dist[i] = {
                                                                        "order": report_data[i].campaign_name,
                                                                        "publisher": report_data[i].publisher_name,
                                                                        "ctr": parseFloat(ctr),
                                                                        "delivery": parseFloat(delivery_per),
                                                                        "website": report_data[i].website,
                                                                        "booked_impressions": parseInt(report_data[i].booked_impression),
                                                                        "viewable_impressions": parseInt(report_data[i].views),
                                                                        "impressions": parseInt(report_data[i].impressions),
                                                                        "remaining_impressions": remaining,
                                                                        "clicks": parseInt(report_data[i].clicks),
                                                                        "deadline": report_data[i].expire_time
                                                                    }
                                                                }
                                                            }
                                                            let formData = {
                                                                "advertiser": agency_head,
                                                                "distribution": dist
                                                            }
                                                            console.log(JSON.stringify(formData));
                                                            window.location.href = "distribution.php?data=" + JSON.stringify(formData);
                                                        }
                                                    },
                                                },
                                                {
                                                    extend: 'spacer',
                                                    style: 'bar'
                                                },
                                                {
                                                    text: 'Campaign Report (Email)',
                                                    autoClose: true,
                                                    className: 'btn btn-warning btn-sm export report_email dtb',
                                                    action: function() {
                                                        var dist = [];
                                                        if (report_data) {
                                                            var agency_head = {
                                                                "notification_emails" : report_data[0].notification_emails,
                                                                "agency": report_data[0].agency_name,
                                                                "name": report_data[0].client_name,
                                                            };

                                                            if (report_data.length > 0) {
                                                                for (var i = 0; i < report_data.length; i++) {
                                                                    let remaining = report_data[i].booked_impression - report_data[i].impressions;
                                                                    let delivery_per = (report_data[i].booked_impression > 0) ? parseFloat((remaining * 100) / report_data[i].booked_impression).toFixed(2) : 0;
                                                                    let ctr = parseFloat(report_data[i].clicks / report_data[i].impressions * 100).toFixed(2);
                                                                    dist[i] = {
                                                                        "order": report_data[i].campaign_name,
                                                                        "publisher": report_data[i].publisher_name,
                                                                        "ctr": parseFloat(ctr),
                                                                        "delivery": parseFloat(delivery_per),
                                                                        "website": report_data[i].website,
                                                                        "booked_impressions": parseInt(report_data[i].booked_impression),
                                                                        "viewable_impressions": parseInt(report_data[i].views),
                                                                        "impressions": parseInt(report_data[i].impressions),
                                                                        "remaining_impressions": remaining,
                                                                        "clicks": parseInt(report_data[i].clicks),
                                                                        "deadline": report_data[i].expire_time,
                                                                        "email": report_data[i].publisher_email
                                                                    }
                                                                }
                                                            }
                                                            let formData = {
                                                                "advertiser": agency_head,
                                                                "distribution": dist
                                                            }
                                                            console.log(JSON.stringify(formData));
                                                            window.location.href = "distribution.php?data=" + JSON.stringify(formData);
                                                        }
                                                    },
                                                }
                                            ],
                                            // responsive: true,
                                            data: data,
                                            columns: [
                                                // { data: 'date_time', className: "text-center" },
                                                {
                                                    'data': null,
                                                    title: 'Name',
                                                    wrap: true,
                                                    className: 'tableName',
                                                    "render": function(campaign) {
                                                        if (cli_id) {
                                                            return '<a href="bannerreport.php?campaignid=' + campaign.campaignid + '&campaignname=' + campaign.campaignname + '&clientid=' + campaign.clientid + '">' + campaign.campaignname + '</a>'
                                                        } else {
                                                            return '<a href="bannerreport.php?campaignid=' + campaign.campaignid + '&campaignname=' + campaign.campaignname + '&clientid=' + campaign.clientid + '&params=1">' + campaign.campaignname + '</a>'
                                                        }
                                                    }
                                                },
                                                {
                                                    data: 'views',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'booked_imp',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'impressions',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'clicks',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'conversions',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'viewableimpressionrate',
                                                    className: "text-center"
                                                },
                                                {
                                                    data: 'ctr',
                                                    className: "text-start"
                                                },
                                                {
                                                    data: 'revenue',
                                                    className: "text-start",
                                                    render: function(data, type, row, meta) {
                                                        return row.revenue == null ? "0.0000" : row.revenue;
                                                    }
                                                },
                                                {
                                                    data: 'ecpm',
                                                    className: "text-start",
                                                    render: function(data, type, row, meta) {
                                                        return row.ecpm == null ? "0.0000" : row.ecpm;
                                                    }
                                                },
                                                {
                                                    'data': null,
                                                    wrap: true,
                                                    className: "text-center",
                                                    "render": function(campaign) {
                                                        if (cli_id) {
                                                            return '<a href="website_distribution_report.php?campaignid=' + campaign.campaignid + '&clientid=' + campaign.clientid + '"><i class="menu-icon tf-icons bx bx-globe" aria-hidden="true" style="text-align:center;"></i></a>'
                                                        } else {
                                                            return '<a href="website_distribution_report.php?campaignid=' + campaign.campaignid + '&clientid=' + campaign.clientid + '&params=1"><i class="menu-icon tf-icons bx bx-globe" aria-hidden="true" style="text-align:center;"></i></a>'
                                                        }

                                                    }
                                                },
                                            ],
                                            footerCallback: function(row, data, start, end, display) {
                                                var api = this.api(),
                                                    data;

                                                // converting to interger to find total
                                                var intVal = function(i) {
                                                    return typeof i === 'string' ?
                                                        i.replace(/[\$,]/g, '') * 1 :
                                                        typeof i === 'number' ?
                                                        i : 0;
                                                };

                                                // computing column Total of the complete result 
                                                var impressions = api
                                                    .column(1)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var clicks = api
                                                    .column(2)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var conversions = api
                                                    .column(3)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var ctr = api
                                                    .column(4)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                var revenue = api
                                                    .column(5)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);
                                                var ecpm = api
                                                    .column(6)
                                                    .data()
                                                    .reduce(function(a, b) {
                                                        return intVal(a) + intVal(b);
                                                    }, 0);

                                                // Update footer by showing the total with the reference of the column index 
                                                $(api.column(0).footer()).html('Total');
                                                $(api.column(1).footer()).html(impressions);
                                                $(api.column(2).footer()).html(clicks);
                                                $(api.column(3).footer()).html(conversions);
                                                $(api.column(4).footer()).html(ctr.toFixed(2));
                                                $(api.column(5).footer()).html(revenue.toFixed(2));
                                                $(api.column(6).footer()).html(ecpm.toFixed(2));
                                            },
                                            initComplete: function(settings) {
                                                //settings.nTable.id --> Get table ID
                                                $('#' + settings.nTable.id + '_filter input').wrap(`
                                                    <div class="d-inline-flex position-relative"></div>
                                              `).after(`
                                                    <button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                      <span aria-hidden="true">&times;</span>
                                                    </button>
                                               `).attr('required', 'required').attr('title', 'Search');

                                                // Click Event on Clear button
                                                $(document).on('click', '#' + settings.nTable.id + '_filter button', function() {
                                                    $('#' + settings.nTable.id).DataTable({
                                                        "retrieve": true,
                                                    }).search('').draw(); // reDraw table
                                                });
                                            }
                                        });
                                    }
                                    $.ajax({
                                        type: "GET",
                                        url: live_URL1 + '/get_permissions/' + userid,
                                        beforeSend: function(xhr) {
                                            xhr.setRequestHeader('Authorization', token);
                                        },
                                        dataType: "json",
                                        encode: true,
                                    }).done(function(data) {
                                        console.log(data);
                                        let get_data = data.data;
                                        if (get_data) {
                                            for (var i = 0; i < get_data.length; i++) {
                                                permissions[i] = get_data[i];
                                            }
                                        } else {
                                            permissions = '';
                                        }
                                        if (!permissions.includes('44')) {
                                            $('.export').hide();
                                        } else {
                                            $('.export').show();
                                        }
                                        if (!permissions.includes('44') || !permissions.includes('45')) {
                                            $('.report_email').hide();
                                        } else {
                                            $('.report_email').show();
                                        }
                                    });
                                    console.log(agency_website_distribution + getClient_id);
                                    $.ajax({
                                        url: agency_website_distribution + getClient_id,
                                        type: 'POST',
                                        beforeSend: function(xhr) {
                                            xhr.setRequestHeader('Authorization', token);
                                        },
                                        data: payload,
                                        success: function(data) {
                                            report_data = data.data;
                                        }
                                    });
                                },
                                error: function() {},
                            });

                        }

                        // $(".report_pdf").click(function() {
                        //     alert("The paragraph was clicked.");
                        // });
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>