<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['strInventory_AddCampaign']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        #clientname,
        #contact,
        #email {
            width: 50%;
            display: inline;
        }

        #check {
            margin-left: 4rem;
        }

        .alert {
            display: none;
        }
    </style>
</head>

<body onload=>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top mb-4">
                            <div class="card mt-5">
                                <div class="card-header">
                                    <div class="row">
                                        <p
                                            class="h3 text-center text-sm-center text-md-start text-lg-start text-xl-start text-xxl-start">
                                            <?php echo $GLOBALS['']; ?>Advertiser:<span id="len"
                                                class="text-secondary"></span>
                                        </p>
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['']; ?>Advertiser updated successfully
                                        </p>
                                        <p class="alert bg-danger alert-dismissible fade show text-white"
                                            id="alertfailed">
                                            <i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['']; ?>Advertiser updated failed
                                        </p>
                                    </div>
                                </div>
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link"
                                            href="advertiser_edit.php?clientid=<?php echo $_GET['clientid']; ?>"><span
                                                class="text-dark">
                                                <?php echo $GLOBALS['']; ?>Advertiser Properties
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link"
                                            href="advertiser_trackers.php?clientid=<?php echo $_GET['clientid']; ?>"><span
                                                class="text-dark">
                                                <?php echo $GLOBALS['']; ?>Trackers
                                            </span></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link active" href="#"><span class="text-primary">
                                                <?php echo $GLOBALS['']; ?>User Access
                                            </span></a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane fade show active" id="" role="tabpanel">
                                        <div class="row">
                                            <p>To add an <b>existing user</b>, type the username and click Add user<br>
                                                To add a <b>new user</b>, type the desired username and click Add user
                                            </p>
                                            <hr class="solid">
                                            <div class="mb-3 col-md-4">
                                                <label for="inputName" class="col-form-label"
                                                    style="margin-left: 3rem;">
                                                    <?php echo $GLOBALS['']; ?>Username of user to add
                                                </label>
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <input type="text" class="form-control" id="username" name="username" onkeyup="manageButton()" onchange="manageButton()">
                                            </div>
                                            <hr class="solid">
                                        </div>
                                        <div class="row mb-3 mt-3">
                                            <div class="col">
                                                <button type="button" id="submitbtn" class="btn btn-primary submitbtn"
                                                    onclick="add_user()">
                                                    <?php echo $GLOBALS['']; ?>Add user
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';

        $("#submitbtn").prop("disabled", true);

        manageButton();

        $('input[name=username]').change(function () {
            manageButton();
        });

        function manageButton() {
            if ($("#username").val() != "") {
                $("#submitbtn").prop("disabled", false);
            } else{
                $("#submitbtn").prop("disabled", true);   
            }
        }

        function add_user(){
            var username=$("#username").val();
            window.location.href='advertiser_user.php?login='+username+'&clientid=<?php echo $_GET['clientid']; ?>&link=1';
        }
    </script>


</body>

</html>