<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='assets/'
	data-template="vertical-menu-template-free">

<head>
	<meta charset="utf-8" />
	<meta name="viewport"
		content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
	<title>
		<?php echo $projecttitle; ?> -
		<?php echo $GLOBALS['strZone']; ?>
	</title>
	<meta name="description" content="" />
	<?php include ('head.php'); ?>
	<style>
		.swal-button--danger {
			background-color: #2523b3;
			width: 100px;
		}

		.swal-button--cancel {
			color: white;
			width: 100px;
			background-color: #ff3e1d;
		}

		.swal-button--cancel:not([disabled]):hover {
			background-color: red;
		}

		.swal-button--danger:not([disabled]):hover {
			background-color: #2523b3;
		}

		.swal-footer {
			text-align: center;
		}

		.alert {
			display: none;
		}

		td {
			max-width: 200px;
			overflow: hidden;
			text-overflow: ellipsis;
			white-space: nowrap;
		}

		td:hover {
			text-overflow: clip;
			white-space: normal;
			word-break: break-all;
		}

		/* #website {
			width: 60%;
		} */

		@media only screen and (max-width: 600px) {
			#website {
				width: 100%;
			}
		}

		.loader {
			display: none;
			position: fixed;
			width: 100%;
			height: 100%;
			top: 0;
			left: 0;
			z-index: 999;
			background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
		}
	</style>

</head>

<body onload="get_all_publisher();">
	<div class="loader"></div>
	<!-- Layout wrapper -->
	<div class="layout-wrapper layout-content-navbar">
		<div class="layout-container">
			<!-- Menu -->
			<?php include ('sidebar.php'); ?>
			<!-- / Menu -->

			<!-- Layout container -->
			<div class="layout-page">
				<!-- Navbar -->
				<?php include ('navbar.php'); ?>
				<!-- / Navbar -->

				<!-- Content wrapper -->
				<div class="content-wrapper">
					<!-- Content -->

					<div class="container">
						<div class="card my-4">
							<div class="card-body">
								<div class="row">
									<div
										class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
										<p class="h3">
											<?php echo $GLOBALS['strZone']; ?>
										</p>
									</div>
								</div>
								<div class="row">
									<div
										class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
										<select id="pub_list" name="pub_list" class="form-select text-dark"
											onchange="get_websites('change');">

										</select>
									</div>
									<div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
										<select id="website" class="form-select text-dark"
											onchange="Zonelist('change')"></select>
									</div>
									<div
										class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
										<button type="button" id="back_button" class="btn btn-warning"
											onclick="back_btn()" style="display:none;">
											<i class="bx bx-arrow-back bg-label-white"></i>
											<?php echo $GLOBALS['strback']; ?>
										</button>&nbsp;
										<button type="button" class="btn btn-warning" id="checkDelete"
											style="display:none;">
											<i class="bx bx-trash bg-label-white" aria-hidden="true" title="Delete"></i>
											<?php echo $GLOBALS['strInventory_DeleteCampaign']; ?>
										</button>&nbsp;
										<button type="button" id="zone_add" class="btn btn-warning" onclick="zone_add()"
											style="display:none;">
											<i class="menu-icon tf-icons bx bx-plus"></i>
											<?php echo $GLOBALS['strInventory_AddZone']; ?>
										</button>
									</div>
								</div>
								<hr />

								<div class="row">
									<div class="mt-2 mb-4 container">
										<p id="warning" class="h6 alert text-black"
											style="background: #ffffb3; display:none;">
											<strong>
												<?php echo $GLOBALS['warning']; ?>
											</strong>&nbsp;<span id="warning_msg"></span>
										</p>
										<p class="alert bg-success alert-dismissible fade show text-white"
											id="alertsuccess"><i class="fa fa-check-circle"></i>
											<?php echo $GLOBALS['zone_deleted_successfully']; ?>
										</p>
										<div class="table-responsive text-nowrap">
											<table id="Zonelist"
												class="table table-striped table-responsive table-hover">
												<thead>
													<tr class="text-nowrap">
														<th class="th-color text-center">
															<input type="checkbox" class="form-check-input check-zone"
																name="select_all" id="select_all">
														</th>
														<!-- thauth-login-basic.html-color -->
														<th class="th-color text-start" style="">
															<?php echo $GLOBALS['strName']; ?>
														</th>
														<th class="th-color text-center" style="">
															<?php echo $GLOBALS['strSize']; ?>
														</th>
														<th class="th-color text-center" style="">
															<?php echo $GLOBALS['updated']; ?>
														</th>
														<th class="th-color text-center" style="">
															<?php echo $GLOBALS['strInventory_Campaign_List_Action']; ?>
														</th>
													</tr>
												</thead>
												<tbody>
												</tbody>
											</table>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<!-- / Content -->

					<!-- Footer -->

					<?php include ('footer.php'); ?>

					<!-- / Footer -->

					<div class="content-backdrop fade"></div>
				</div>
				<!-- Content wrapper -->
			</div>
			<!-- / Layout page -->
		</div>

		<!-- Overlay -->
		<div class="layout-overlay layout-menu-toggle"></div>
	</div>
	<!-- / Layout wrapper -->


	<script>
		const token = 'Bearer ' + document.getElementById('token').value;
		let affiliateId = '<?php echo $_GET['affiliateid'] ?>';
		let affiliate_Id = '<?php echo $_GET['affiliate_id'] ?>';
		let agencyid = '<?php echo $_SESSION['agencyid'] ?>';
		let userid = '<?php echo $_SESSION['user_id'] ?>';
		let live_URL = '<?php echo $apiinvenpath; ?>';
		let domain_url = live_URL + '/get_all_zone/';
		let getallwebsite = live_URL + '/get_all_website/';
		let publisherwebsite_url = live_URL + '/get_publisherwise_website/';
		let deleteZone = live_URL + '/delete_zone/';
		var permissions = [];
		var pubname = '<?php echo $_REQUEST['pub_id']; ?>';
		let getpubId = '<?php echo $_REQUEST['pubid']; ?>';
		document.getElementById('checkDelete').disabled = true;
		document.getElementById('back_button').style.display = affiliate_Id == "" ? "none" : "block";

		var pubValue = localStorage.getItem('pubValue');
		var webValue = localStorage.getItem("webValue");

		function get_all_publisher() {
			// var camplist_option = $('#camplist option:selected').val();
			$.ajax({
				type: "GET",
				url: live_URL + '/get_all_publisher/' + agencyid,
				beforeSend: function (xhr) {
					xhr.setRequestHeader('Authorization', token);
				},
				data: {},
				dataType: "json",
				encode: true,
			}).done(function (data) {
				var pub_name = [];
				if (!data.data) {
					$('#pub_list').hide();
					$('#website').hide();
					defaultValue = `<option value="0" selected><?php echo $GLOBALS['all_publishers']; ?></option>`;
					document.getElementById('pub_list').innerHTML = defaultValue;
					$('#zone_add').attr("disabled", true);
					$('#warning').show();
					$('#warning_msg').html("<?php echo $GLOBALS['zone_warning']; ?>");
					get_websites();
				} else {
					$('#pub_list').show();
					$('#warning').hide();
					data.data.map((data) => {
						defaultValue = `<option value="0" selected><?php echo $GLOBALS['all_publishers']; ?></option>`;
						getpubLength = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
						pub_name += `<option value=${data.id} title="${data.name}">${getpubLength}</option>`;
						document.getElementById('pub_list').innerHTML = defaultValue + pub_name;


					});
					if (getpubId != '') {
						$('#pub_list').val(getpubId);
						$('#pub_list').attr("disabled", true);
					} else if (pubname != '') {
						$('#pub_list').val(pubname);
						$('#pub_list').attr("disabled", true);
					} else if (pubValue != '' && pubValue != null && pubValue != 'undefined') {
						$('#pub_list option').each(function () {
							if (this.value == pubValue) {
								$("#pub_list").val(pubValue);
							}
						});
						// document.getElementById('advlist').value = advValue;
					}
					get_websites();
				}
			});
		}

		get_websites = (changed) => {
			if (pubname != "") {

				var pubid = pubname;
			} else {
				var pubid = $("#pub_list option:selected").val();
			}
			$.ajax({
				type: "GET",
				url: pubid == "0" ? getallwebsite + agencyid : publisherwebsite_url + pubid,
				beforeSend: function (xhr) {
					xhr.setRequestHeader('Authorization', token);
				},
				data: {},
				dataType: "json",
				encode: true,
			}).done(function (data) {
				if (data.msg == "Enter valid publisher Id!" || data.msg == "Enter valid agency Id!") {
					$('#website').hide();
					$('#zone_add').attr("disabled", true);
					$('#warning').show();
					$('#warning_msg').html("<?php echo $GLOBALS['zone1_warning']; ?>");
					//document.getElementById('website').innerHTML = "";
					Zonelist();
				} else {
					$('#website').show();
					$('#zone_add').attr("disabled", false);
					$('#warning').hide();
					if (data.data) {
						var websites = [];
						data.data.map((data) => {
							getwebLength = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
							websites += `<option value=${data.affiliateid} title="${data.name}">${getwebLength}</option>`;
						});
						$('#website').html(websites);
						if (changed) {
							webValue = '';
							localStorage.removeItem('webValue');
							location.reload();
						}
						if (affiliateId != '') {
							$('#website').val(affiliateId);
						} else if (affiliate_Id != '') {
							$('#website').val(affiliate_Id);
							$('#website').attr("disabled", true);
						} else if (webValue != '' && webValue != null && webValue != 'undefined') {
							$('#website option').each(function () {
								if (this.value == webValue) {
									$("#website").val(webValue);
								}
							});
						}
					}
					Zonelist();
				}
				// else{
				// 	$('#website').hide();
				// 	$('#zone_add').attr('disabled', true);
				// }

			});
		};

		zone_add = () => {
			let pub_id = $("#pub_list option:selected").val();
			let affiliate_id = $("#website option:selected").val();
			if (pub_id == 0) {
				window.location.href = 'zone_add.php?publisherid=' + pub_id + '&affiliateid=' + affiliate_id;
			} else {
				window.location.href = (affiliate_Id == '') ? 'zone_add.php?pubid=' + pub_id + '&affiliateid=' + affiliate_id : (affiliate_Id != '' && getpubId != "") ? 'zone_add.php?pubid=' + getpubId + '&affiliate_id=' + affiliate_id :
					'zone_add.php?pub_id=' + pub_id + '&affiliate_id=' + affiliate_Id;
			}
		};

		back_btn = () => {
			window.location.href = getpubId == '' ? 'websites_list.php?pub_id=' + pubname + '' :
				'websites_list.php?pubid=' + getpubId + '';
		}

		function Deleteallbtn() {
			swal({
				title: `<?php echo $GLOBALS['zone_deleted_allMsg']; ?>`,
				// text: "Once deleted, you will not be able to recover this imaginary file!",
				// icon: "warning",
				buttons: true,
				dangerMode: true,
			})
		};

		function Zonelist(changed) {
			$(".loader").hide();
			let affiliate_id = $('#website').val();
			let Zone_url = domain_url + affiliate_id;
			$.ajax({
				url: Zone_url,
				type: 'GET',
				beforeSend: function (xhr) {
					xhr.setRequestHeader('Authorization', token);
				},
				data: {},
				success: function (data) {
					$(".loader").hide();
					if (data.msg == 'No Data' || data.msg == "Invalid Publisher Id!") {
						$('#Zonelist').DataTable({
							ordering: false,
							destroy: true,
							responsive: true,
							bPaginate: false,
							bInfo: false,
							data: [],
							searching: false,
							oLanguage: {
								sEmptyTable: "No Data Found"
							}
						});
					} else {
						var rows_selected = [];
						let getValue, getValue2;
						var zoneDataTable = $('#Zonelist').DataTable({
							targets: 0,
							ordering: true,
							stateSave: true,
							destroy: true,
							data: data.data,
							columns: [{
								data: 'affiliateid',
								className: "text-center",
								orderable: false,
								render: function (data, type, row, meta) {
									return '<input type="checkbox" class="data-checked form-check-input select-checkbox" value="' + row.zoneid + '" data-zone-id="' + row.zoneid + '" name="checkrow" id="checkrow" >';
								}
							},
							{
								'data': null,
								title: 'Name',
								className: "text-start",
								wrap: false,
								"render": function (zone) {
									if (affiliate_Id != "" && pubname != "") {

										getValue = '<a class="test " style="width: 14rem;" href="zone_edit.php?pub_id=' + pubname + '&zoneid=' + zone.zoneid + '&affiliate_id=' + affiliate_Id + '">' + zone.zonename + '</a>';
									}
									else if (affiliate_Id != "" && getpubId != "") {
										getValue = '<a class="test " style="width: 14rem;" href="zone_edit.php?pubid=' + getpubId + '&zoneid=' + zone.zoneid + '&affiliate_id=' + affiliate_Id + '">' + zone.zonename + '</a>';
									}
									else {
										getValue = '<a class="test " style="width: 14rem;" href="zone_edit.php?zoneid=' + zone.zoneid + '">' + zone.zonename + '</a>';
									}
									return getValue;

								}
							},
							{
								data: 'width',
								className: "text-center",
								render: function (data, type, row, meta) {
									if (row.width > 0 || row.height > 0) {
										if (row.width == 468 && row.height == 60) {
											var iabformat = 'IAB Full Banner (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 120 && row.height == 600) {
											var iabformat = 'IAB Sky Scraper (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 728 && row.height == 90) {
											var iabformat = 'IAB Leaderboard (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 120 && row.height == 90) {
											var iabformat = 'IAB Button 1 (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 120 && row.height == 60) {
											var iabformat = 'IAB Button 2 (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 234 && row.height == 60) {
											var iabformat = 'IAB Half Banner (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 88 && row.height == 31) {
											var iabformat = 'IAB Micro Bar (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 125 && row.height == 125) {
											var iabformat = 'IAB Square Button (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 120 && row.height == 240) {
											var iabformat = 'IAB Vertical Banner (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 180 && row.height == 150) {
											var iabformat = 'IAB Rectangle (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 300 && row.height == 250) {
											var iabformat = 'IAB Medium Rectangle (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 336 && row.height == 280) {
											var iabformat = 'IAB Large Rectangle (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 240 && row.height == 400) {
											var iabformat = 'IAB Vertical Rectangle (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 250 && row.height == 250) {
											var iabformat = 'IAB Square Popup (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 160 && row.height == 600) {
											var iabformat = 'IAB Wide Skyscraper (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 720 && row.height == 300) {
											var iabformat = 'IAB Pop- Under (' + row.width + ' x ' + row.height + ')';
										} else if (row.width == 300 && row.height == 100) {
											var iabformat = 'IAB 3:1 Rectangle (' + row.width + ' x ' + row.height + ')';
										} else {
											var iabformat = 'Custom (' + row.width + ' x ' + row.height + ')';
										}
										return iabformat;
									} else if (row.width == -1 && row.height == -1) {
										return 'Custom (* x *)';
									} else {
										return '-';
									}
								}
							},
							{
								data: 'updated',
								className: "text-center",
								render: function (data, type, row, meta) {
									return row.updated;
								}
							},
							{
								data: 'affiliateid',
								className: "text-center",
								render: function (data, type, row, meta) {
									if (affiliate_Id != ''&& pubname != "") {
										getValue2 = '<a class="btn btn-icon btn-xs btn-warning" href="zone_edit.php?pub_id=' + pubname + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"><i class="bx bx-edit label-warning" style="font-size:14px" title="<?php echo $GLOBALS['edit']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="linked_banners.php?pub_id=' + pubname + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"><i class="fa fa-link" aria-hidden="true" style="font-size:14px" title="<?php echo $GLOBALS['linked_banners']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="probability.php?pub_id=' + pubname + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"><i class="fa fa-dice-d20" aria-hidden="true" style="font-size:14px" title="<?php echo $GLOBALS['probability']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="invocation.php?pub_id=' + pubname + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"> <i class="fa fa-code fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['strInvocation']; ?>"></i></a>';
									} else if (affiliate_Id != "" && getpubId != "") {
										getValue2 = '<a class="btn btn-icon btn-xs btn-warning" href="zone_edit.php?pubid=' + getpubId + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"><i class="bx bx-edit label-warning" style="font-size:14px" title="<?php echo $GLOBALS['edit']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="linked_banners.php?pubid=' + getpubId + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"><i class="fa fa-link" aria-hidden="true" style="font-size:14px" title="<?php echo $GLOBALS['linked_banners']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="probability.php?pubid=' + getpubId + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"><i class="fa fa-dice-d20" aria-hidden="true" style="font-size:14px" title="<?php echo $GLOBALS['probability']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="invocation.php?pubid=' + getpubId + '&zoneid=' + row.zoneid + '&affiliate_id=' + affiliate_Id + '"> <i class="fa fa-code fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['strInvocation']; ?>"></i></a>';
									}else {
										getValue2 = '<a class="btn btn-icon btn-xs btn-warning" href="zone_edit.php?zoneid=' + row.zoneid + '"><i class="bx bx-edit label-warning" style="font-size:14px" title="<?php echo $GLOBALS['edit']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="linked_banners.php?zoneid=' + row.zoneid + '"><i class="fa fa-link" aria-hidden="true" style="font-size:14px" title="<?php echo $GLOBALS['linked_banners']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="probability.php?zoneid=' + row.zoneid + '"><i class="fa fa-dice-d20" aria-hidden="true" style="font-size:14px" title="<?php echo $GLOBALS['probability']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="invocation.php?zoneid=' + row.zoneid + '"> <i class="fa fa-code fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['strInvocation']; ?>"></i></a>&nbsp;';
									}
									return getValue2;
								}
							},
							],
						});

						// Handle click on checkbox
						$('#Zonelist tbody').on('click', 'input[type="checkbox"]', function (e) {
							var $row = $(this).closest('tr');
							var data = zoneDataTable.row($row).data();
							var rowId = zoneDataTable.row(this).data[0];
							var index = $.inArray(rowId, rows_selected);

							if (this.checked && index === -1) {
								rows_selected.push(rowId);
							} else if (!this.checked && index !== -1) {
								rows_selected.splice(index, 1);
							}

							if (this.checked) {
								$row.addClass('selected');
								document.getElementById('checkDelete').disabled = $('.data-checked:checked').length > 0 ? false : true;
							} else {
								$row.removeClass('selected');
								document.getElementById('checkDelete').disabled = $('.data-checked:checked').length > 0 ? false : true;
							}

							updateDataTableSelectAllCtrl(zoneDataTable);
							e.stopPropagation();
						});

						// Handle click on "Select all" control
						$('thead input[name="select_all"]', zoneDataTable.table().container()).on('click', function (e) {
							if (this.checked) {
								$('#Zonelist tbody input[type="checkbox"]:not(:checked)').trigger('click');
								document.getElementById('checkDelete').disabled = $('.data-checked:checked').length > 0 ? false : true;
							} else {
								$('#Zonelist tbody input[type="checkbox"]:checked').trigger('click');
								document.getElementById('checkDelete').disabled = $('.data-checked:checked').length > 0 ? false : true;
							}
							e.stopPropagation();
						});
						// Handle table draw event
						zoneDataTable.on('draw', function () {
							updateDataTableSelectAllCtrl(zoneDataTable);
						});
					}

				},
				error: function () { },
			});
			$.ajax({
				type: "GET",
				url: live_URL + '/get_permissions/' + userid,
				beforeSend: function (xhr) {
					xhr.setRequestHeader('Authorization', token);
				},
				dataType: "json",
				encode: true,
			}).done(function (data) {
				let get_data = data.data;
				if (get_data) {
					for (var i = 0; i < get_data.length; i++) {
						permissions[i] = get_data[i];
					}
				} else {
					permissions = '';
				}
				if (!permissions.includes('40')) {
					$('#zone_add').hide();
				} else {
					$('#zone_add').show();
				}
				if (!permissions.includes('41')) {
					$('#Zonelist').DataTable().column(0).visible(false);
					$('#checkDelete').hide();
				} else {
					$('#Zonelist').DataTable().column(0).visible(true);
					$('#checkDelete').show();
				}
			});
			if (changed) {
				localStorage.setItem("webValue", $("#website option:selected").val());
				location.reload();
			}
			localStorage.setItem('pubValue', $("#pub_list option:selected").val());
			//zoneDataTable.ajax.reload();
			// 
		}

		//Zone Delete API
		function Deletebtn(zoneid) {
			let getZone_id = document.getElementById('checkrow').value;
			swal({
				title: `<?php echo $GLOBALS['zone_deleted_alertMsg']; ?>`,
				buttons: {
					cancel: "Cancel",
					danger: "Confirm",
				},
			}).then(function (isConfirm) {
				if (isConfirm) {
					$.ajax({
						type: "DELETE",
						url: deleteZone + zoneid,
						beforeSend: function (xhr) {
							xhr.setRequestHeader('Authorization', token);
						},
						dataType: "json",
						encode: true,
					}).done(function (data) {
						//Zonelist(); 
						$("#alertsuccess").show('medium');
						setTimeout(function () {
							$("#alertsuccess").hide('medium');
						}, 2000);
						setTimeout(function () {
							location.reload();
						}, 2000);
					});
				}
			});
			// webValue = $('#website').val();
			// localStorage.setItem("webValue", webValue);
		};

		// $(document).on('click', '#select-all', function() {
		// 	$(".data-checked").prop("checked", this.checked);
		// 	document.getElementById('checkDelete').disabled = $('.data-checked:checked').length >0?false:true;
		// });

		// $(document).on('click', '.data-checked', function() {
		// 	if($('.data-checked:checked').length == $('.data-checked').length) {
		// 		$('#select-all').prop('checked', true);
		// 	}
		// 	else {
		// 		$('#select-all').prop('checked', false);
		// 	}
		// 	document.getElementById('checkDelete').disabled = $('.data-checked:checked').length >0?false:true;
		// });

		$('#checkDelete').on('click', function (e) {
			var zoneData = [];
			let test23 = $(".data-checked:checked");
			test23.each(function () {
				zoneData.push($(this).attr('data-zone-id'));
			});
			if (zoneData.length <= 0) {
				alert("Please select records.");
			} else {
				swal({
					title: `<?php echo $GLOBALS['zone_deleted_alertMsg']; ?>`,
					buttons: {
						cancel: "Cancel",
						danger: "Ok",
					},
				}).then(function (isConfirm) {
					if (isConfirm) {
						let selected_values = zoneData.join(",");
						$.ajax({
							type: "DELETE",
							url: deleteZone + zoneData,
							beforeSend: function (xhr) {
								xhr.setRequestHeader('Authorization', token);
							},
							dataType: "json",
							encode: true,
						}).done(function (data) {
							if (data.msg = "Zone has been deleted successfully!" && data.statuscode == 200) {
								//swal("Zone Deleted Successfully");
								$("#alertsuccess").show('medium');
								setTimeout(function () {
									$("#alertsuccess").hide('medium');
								}, 2000);
								setTimeout(function () {
									location.reload();
								}, 2000);
							} else {
								//swal("Zone Not Deleted Successfully");
							}
						});
					}
				});
			}
			webValue = $('#website').val();
			localStorage.setItem("webValue", webValue);
		});

		function updateDataTableSelectAllCtrl(zoneDataTable) {
			var $table = zoneDataTable.table().node();
			var $chkbox_all = $('tbody input[type="checkbox"]', $table);
			var $chkbox_checked = $('tbody input[type="checkbox"]:checked', $table);
			var chkbox_select_all = $('thead input[name="select_all"]', $table).get(0);


			// If none of the checkboxes are checked
			if ($chkbox_checked.length === 0) {
				chkbox_select_all.checked = false;
				if (chkbox_select_all) {
					chkbox_select_all = false;
				}

				// If all of the checkboxes are checked
			} else if ($chkbox_checked.length === $chkbox_all.length) {
				chkbox_select_all.checked = true;
				if (chkbox_select_all) {
					chkbox_select_all = false;
				}

				// If some of the checkboxes are checked
			} else {
				chkbox_select_all.checked = false;
			}
		}
	</script>
</body>

</html>