<?php
include ('session.php');
include ('../config.php');
include ('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['tracker']; ?>
    </title>
    <meta name="description" content="" />
    <?php include ('head.php'); ?>
    <style>
        #trackername,
        #description,
        #type,
        #status {
            width: 50%;
            display: inline;
        }

        #check {
            margin-left: 4rem;
        }

        .alert {
            display: none;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }
    </style>
</head>

<body onload=campaignlist();>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include ('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include ('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top mt-5 mb-4">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="adv_tracker_edit.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['tracker_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href=""><span class="text-warning">
                                            <?php echo $GLOBALS['link_campaigns']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_variables.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['variables']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_append.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['append_tracker_code']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_invocation.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['invocation_code']; ?>
                                        </span></a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="" role="tabpanel">
                                    <!-- <div class="card-body"> -->
                                    <div>
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['campaign_track_success_msg']; ?>
                                        </p>
                                        <p class="alert bg-danger alert-dismissible fade show text-white"
                                            id="alertfailed">
                                            <i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['campaign_track_failed_msg']; ?>
                                        </p>
                                    </div>
                                    <div class="row">
                                        <div class="table-responsive text-nowrap mt-2">
                                            <table id="adv_table" class="table table-striped table-hover mt-3">
                                                <thead>
                                                    <tr class="text-nowrap">
                                                        <th class="th-color">
                                                            <input type="checkbox" class="form-check-input check-zone"
                                                                id="select_all">&nbsp;&nbsp;
                                                            <?php echo $GLOBALS['strName']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['link_banner_id']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['strInventory_Campaign_List_Status']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['conversion_window']; ?>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody id="fbody" class="fbody">
                                                    <td colspan="5" id="linkempty" class="text-center">
                                                        <?php echo $GLOBALS['strNo_Data_Meassages']; ?>
                                                    </td>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="row mb-3 mt-3">
                                        <div class="col">
                                            <button type="button" id="submitbtn" style="float:right;"
                                                class="btn btn-warning submitbtn" onclick="trackeredit()">
                                                <?php echo $GLOBALS['save_changes']; ?>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- </div> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php include ('footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var trackerid = '<?php echo $_REQUEST['trackerid']; ?>';
        $("#linkempty").hide();
        function campaignlist() {
            $.ajax({
                url: live_URL + '/get_tracker_campaigns/' + clientid + ',' + trackerid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    if (data.data) {
                        for (var i = 0; i < data.data.length; i++) {
                            var row = data.data;
                            var campaignid = row[i].campaignid;
                            var status = row[i].track_status;
                            var row = $('<tr><td style="color:blue" class="tableName"><input type="checkbox" class="data-checked form-check-input select-checkbox" name="checkrow" id="checkrow' + row[i].campaignid + '" value="' + row[i].campaignid + '" data-tracker-id="' + row[i].campaignid + '" onclick="enable_dropdown(' + campaignid + ')">&nbsp;&nbsp;<a href="campaign_trackers.php?clientid=' + clientid + '&campaignid=' + campaignid + '"><i class="fa-solid fa-flag" aria-hidden="true" style="padding-left:10px;"></i>&nbsp;' + data.data[i].campaignname + '</a></td><td style="text-align:center;" class="tableName">&nbsp;' + data.data[i].campaignid + '</td><td><select name="min_select" id="status_check' + row[i].campaignid + '" class="form-select text-dark status_check1" disabled><option value="4"><?php echo $GLOBALS['approved']; ?></option><option value="2"><?php echo $GLOBALS['pending']; ?></option><option value="1"><?php echo $GLOBALS['ignore']; ?></option></select></td><td style="text-align:center;" class="tableName"><?php echo $GLOBALS['']; ?>View &nbsp; <span id="days' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>Days &nbsp; <span id="hours' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>hours &nbsp; <span id="minutes' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>minutes &nbsp; <span id="seconds' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>seconds<br><?php echo $GLOBALS['']; ?>Click &nbsp; <span id="days2' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>Days &nbsp; <span id="hours2' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>hours &nbsp; <span id="minutes2' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>minutes &nbsp; <span id="seconds2' + row[i].campaignid + '" value="' + row[i].campaignid + '"></span>seconds</td></tr>');
                            $('#adv_table').append(row);
                            $('.status_check1').val(status);
                            get_trackerid(campaignid,trackerid);
                            view_click(campaignid);
                        }
                    }
                    if (data.msg == "No campaigns available for this trackerid!") {
                        $("#linkempty").show();
                    }

                },

                error: function () { },
            });
        }

        function enable_dropdown(campaignid) {

            if ($('#checkrow' + campaignid).prop("checked")) {
                $('#status_check' + campaignid).prop('disabled', false);
            } else {
                $('#status_check' + campaignid).prop('disabled', true);
            }
        }

        function get_trackerid(campaignid,trackerid) {
            $('#days' + campaignid).html(0);
            $('#hours' + campaignid).html(0);
            $('#minutes' + campaignid).html(0);
            $('#seconds' + campaignid).html(0);
            $('#days2' + campaignid).html(0);
            $('#hours2' + campaignid).html(0);
            $('#minutes2' + campaignid).html(0);
            $('#seconds2' + campaignid).html(0);
            var val;
            $.ajax({
                url: live_URL + '/get_trackerid_campaign/' + trackerid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    $.each(data.data, function (index, value) {
                        val = value['campaignid'];
                        var status = value['status'];
                        $('#checkrow' + val).prop('checked', true);
                        $('#status_check' + val).prop('disabled', false);
                        $('#status_check' + val).val(status);

                        // var reset_time = value.viewwindow;

                        // var d = Math.round(reset_time / 86400);
                        // var h = Math.round(reset_time % 86400 / 3600);
                        // var m = Math.floor(reset_time % 3600 / 60);
                        // var s = Math.floor(reset_time % 3600 % 60);
                        // //$('#days'+ val).val(d);
                        // $('#days' + val).html(d);
                        // $('#hours' + val).html(h);
                        // $('#minutes' + val).html(m);
                        // $('#seconds' + val).html(s);

                        // var reset_time2 = value.clickwindow;

                        // var d2 = Math.round(reset_time2 / 86400);
                        // var h2 = Math.round(reset_time2 % 86400 / 3600);
                        // var m2 = Math.floor(reset_time2 % 3600 / 60);
                        // var s2 = Math.floor(reset_time2 % 3600 % 60);
                        // $('#days2' + val).html(d2);
                        // $('#hours2' + val).html(h2);
                        // $('#minutes2' + val).html(m2);
                        // $('#seconds2' + val).html(s2);
                        val = '';
                        status = '';
                    });
                    if ($('.data-checked:checked').length == $('.data-checked').length) {
                        $('#select_all').prop('checked', true);
                    } else {
                        $('#select_all').prop('checked', false);
                    }

                },
                //error: function () { },
            });
        }

        function view_click(campaignid) {
            $('#days' + campaignid).html(0);
            $('#hours' + campaignid).html(0);
            $('#minutes' + campaignid).html(0);
            $('#seconds' + campaignid).html(0);
            $('#days2' + campaignid).html(0);
            $('#hours2' + campaignid).html(0);
            $('#minutes2' + campaignid).html(0);
            $('#seconds2' + campaignid).html(0);
            // console.log(clientid);
            $.ajax({
                url: live_URL + '/get_view_clicks/' + campaignid,
                type: 'GET',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: 'json',
                encode: true,
                success: function (data) {
                    console.log("test", data);

                        var reset_time = data.data.viewwindow;

                        var d = Math.round(reset_time / 86400);
                        var h = Math.round(reset_time % 86400 / 3600);
                        var m = Math.floor(reset_time % 3600 / 60);
                        var s = Math.floor(reset_time % 3600 % 60);
                        $('#days'+campaignid).html(d);
                        $('#hours'+campaignid).html(h);
                        $('#minutes'+campaignid).html(m);
                        $('#seconds'+campaignid).html(s);
                        var reset_time2 = data.data.clickwindow;

                        var d2 = Math.round(reset_time2 / 86400);
                        var h2 = Math.round(reset_time2 % 86400 / 3600);
                        var m2 = Math.floor(reset_time2 % 3600 / 60);
                        var s2 = Math.floor(reset_time2 % 3600 % 60);
                        $('#days2'+campaignid).html(d2);
                        $('#hours2'+campaignid).html(h2);
                        $('#minutes2'+campaignid).html(m2);
                        $('#seconds2'+campaignid).html(s2);
                },
                //error: function () { },
            });
        }
        document.getElementById('select_all').onclick = function () {
            var checkboxes = document.querySelectorAll('input[type="checkbox"]');
            for (var checkbox of checkboxes) {
                if (checkbox.checked = this.checked) {
                    $('.status_check1').prop('disabled', false);
                } else {
                    $('.status_check1').prop('disabled', true);
                }
            }
        }

        $(document).on('click', '.data-checked', function () {
            if ($('.data-checked:checked').length == $('.data-checked').length) {
                $('#select_all').prop('checked', true);
            } else {
                $('#select_all').prop('checked', false);
            }
        });

        function trackeredit(campaignid) {
            var campaignid1 = [];

            $('.data-checked:checked').each(function () {
                campaignid1 += this.value + ',';
            });
            //var tracklength=trackerid1.length;
            var trackval = Array.isArray(campaignid1);

            if (trackval == false) {
                var campaignid = campaignid1.replace(/(^,)|(,$)/g, "");
            } else {
                campaignid = '';
            }

            var status = [];
            var selected = campaignid.split(',');
            $.each(selected, function (id, val) {
                if (val != '') {
                    status.push($('#status_check' + val + ' option:selected').val());
                }
            });
            var formData = {
                "campaignid": "" + campaignid + "",
                "trackerid": "" + trackerid + "",
                "status": "" + status + "",
                // "view": "" + view + "",
                // "click": "" + click + "",
            };
            //if (campaignid != '' && trackerid != '') {
                $.ajax({
                    url: live_URL + '/linked_campaigns_trackers/' + trackerid,
                    type: 'POST',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: formData,
                    dataType: 'json',
                    encode: true,
                    success: function (data) {
                        if (data.msg == "linked campaign tracker has been updated successfully!") {
                            window.scrollTo(0, 0);
                            $("#alertsuccess").show('medium');
                            setTimeout(function () {
                                $("#alertsuccess").hide('medium');
                            }, 2000);
                            setTimeout(function () {
                                window.location = window.location;
                            }, 1200);
                        }
                    },
                    //error: function () { },
                });
            //}
        }
    </script>


</body>

</html>