<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['device_targeting']; ?>
    </title>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <script src="https://code.highcharts.com/highcharts.js"></script>
    <script src="https://code.highcharts.com/modules/exporting.js"></script>
    <script src="https://code.highcharts.com/modules/export-data.js"></script>
    <script src="https://code.highcharts.com/modules/accessibility.js"></script>
    <script src="https://code.highcharts.com/modules/no-data-to-display.js"></script>
    <style>
        .text-hide {
            display: block;
            width: 125px;
            overflow: hidden;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .text-hide:hover {
            overflow: inherit;
            width: auto;
        }

        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }

        h5 {
            position: relative;
            left: 200%;
        }

        /* Close Button */
        .dataTables_wrapper .dataTables_filter input:not(:valid):not(:focus) {
            box-shadow: 0 0 5px #fff !important;
        }

        .dataTables_wrapper .dataTables_filter input::-webkit-search-cancel-button {
            -webkit-appearance: none !important;
        }

        .dataTables_wrapper .dataTables_filter button {
            visibility: hidden;
            outline: none;
        }

        .dataTables_wrapper .dataTables_filter input:valid~button {
            visibility: visible;
        }

        button.close {
            padding: 0;
            background-color: transparent;
            border: 0;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
        }

        .close {
            float: right;
            font-size: 1.5rem;
            font-weight: 700;
            line-height: 1;
            color: #000;
            text-shadow: 0 1px 0 #fff;
            opacity: .5;
        }

        #getCampaign {
            width: 40%;
        }

        @media screen and (max-width:547px) {
            #getCampaign {
                width: 50%;
                margin: auto;
            }
        }

        @media screen and (min-width:700px) {
            .daySelection {
                width: 30%;
                display: flex;
                justify-content: end;
            }
        }

        @media screen and (min-width:420px) and (max-width:699px) {
            .daySelection {
                width: 40%;
                display: flex;
                justify-content: center;
            }

            .main-chart {
                /* width: 200px;
                height: 400px; */
                width: auto;
                height: auto;
                margin: auto;
            }
        }

        @media screen and(min-width:220px) and (max-width:419px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

            .main-chart {
                /* width: 90%; */
                /* height: 2100px; */
                width: auto;
                height: auto;
                margin: auto;
            }

            /* #myChart4{
                width: 227px;
                height: 300px;
            } */

            /* .country-chart{
                width: 100%;
                height: 600px;
            } */
        }

        @media screen and (max-width: 219px) {
            .daySelection {
                width: 75%;
                margin: auto;
            }

        }

        .left-col {
            float: left;
            width: 45%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .center-col {
            float: left;
            width: 20%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        .right-col {
            float: left;
            width: 35%;
            margin-top: 1rem;
            margin-bottom: 2rem;
        }

        @media only screen and (max-width: 767px) {
            .left-col {
                float: left;
                width: 45%;
                margin-top: 4rem;
                margin-bottom: 2rem;
            }

            .right-col {
                float: left;
                width: 35%;
                margin-top: 1rem;
                margin-bottom: 2rem;
                margin-right: 1px;
            }
        }

        #table_camp #alltotal_camp tr th {
            padding-right: 20px;
        }

        #table_ban #alltotal_ban tr th {
            padding-right: 20px;
        }

        .table tfoot #total,
        #totalall_camp,
        #totalall_ban th {
            padding-right: 20px;
            text-align: center;
        }
    </style>
</head>

<body onload="onChangeDetails()">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->

                    <div class="container">
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class="row mt-2 mb-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class='h4'>
                                            <?php echo $GLOBALS['device_targeting']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row mb-2 mt-2">
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                        <select id="camp_banner" name="camp_banner" class="form-select text-dark"
                                            onchange="onChangeDetails('changed')">
                                            <option value="campaign">
                                                <?php echo $GLOBALS['all_campaigns']; ?>
                                            </option>
                                            <option value="banner">
                                                <?php echo $GLOBALS['all_banners']; ?>
                                            </option>
                                        </select>
                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3">
                                        <select id="device_type" name="device_type" class="form-select text-dark"
                                            onchange="onChangeDetails('changed')">
                                            <option value="all">
                                                <?php echo $GLOBALS['']; ?>All Environment
                                            </option>
                                            <option value="Desktop">
                                                <?php echo $GLOBALS['']; ?>Desktop
                                            </option>
                                            <option value="Mobile">
                                                <?php echo $GLOBALS['']; ?>Mobile
                                            </option>
                                        </select>
                                    </div>
                                    <div
                                        class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <select id="getCampaign" class="form-select text-dark daySelection w-30"
                                            aria-label="Default select example" onchange="onChangeDetails()">
                                            <option value="Today" selected>
                                                <?php echo $GLOBALS['strToday']; ?>
                                            </option>
                                            <option value="Yesterday">
                                                <?php echo $GLOBALS['strYesterday']; ?>
                                            </option>
                                            <option value="Last 7 days">
                                                <?php echo $GLOBALS['strLast 7 days']; ?>
                                            </option>
                                            <option value="Last 30 days">
                                                <?php echo $GLOBALS['strLast 30 days']; ?>
                                            </option>
                                            <option value="Last Month">
                                                <?php echo $GLOBALS['strLast Month']; ?>
                                            </option>
                                            <option value="This Month">
                                                <?php echo $GLOBALS['strThis Month']; ?>
                                            </option>
                                            <option value='All Statistics'>
                                                <?php echo $GLOBALS['strAll Statistics']; ?>
                                            </option>
                                            <option value="custom">
                                                <?php echo $GLOBALS['strCustom']; ?>
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <!--<div class="row mb-2">
                                    <div
                                        class="col col-12 col-sm-12 col-md-4 col-lg-4 col-xl-4 col-xxl-4 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    </div>
                                    
                                </div>-->

                                <div
                                    class="d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                    <input style="display: none; margin-left:3%;width:20%" id="daterange"
                                        name="daterange" />
                                </div>

                                <hr class="solid">

                                <div class="row mb-2">
                                    <div class="col col-6 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div id="impressions_chart"
                                            style="display:none; min-width: 310px; height: 300px; max-width: 300px; margin: 0 auto">
                                        </div>
                                    </div>
                                    <div class="col col-6 col-sm-6 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <div id="clicks_chart"
                                            style="display:none; min-width: 310px; height: 300px; max-width: 300px; margin: 0 auto">
                                        </div>
                                    </div>
                                </div>

                                <div class="table-responsive text-nowrap" id="table_camp" style='display:none'>
                                    <!-- id="example2" -->
                                    <table id="camapaignrep" class="table table-striped table-responsive">
                                        <thead>
                                            <tr class="text-dark">
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['campaign_name']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strImpressions']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strClicks']; ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <thead id="alltotal_camp" style='display:none'>
                                            <tr>
                                                <th class="text-dark text-start">Overall Total:</th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="camp_table"></tbody>
                                        <tfoot id="foot_camp" style="display:none">
                                            <tr id="totalall_camp" style="display:none">
                                                <th class="text-dark text-start">Overall Total:</th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                            <tr id="total">
                                                <th class="text-dark text-start">Total:</th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <div class="table-responsive text-nowrap" id="table_ban" style='display:none'>
                                    <table id="banrep" class="table table-striped table-responsive">
                                        <thead>
                                            <tr class="text-dark">
                                                <th class="text-dark">
                                                    <?php echo $GLOBALS['banner_name']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strImpressions']; ?>
                                                </th>
                                                <th class="text-dark text-center">
                                                    <?php echo $GLOBALS['strClicks']; ?>
                                                </th>
                                            </tr>
                                        </thead>
                                        <thead id="alltotal_ban" style='display:none'>
                                            <tr>
                                                <th class="text-dark text-start">Overall Total:</th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                        </thead>
                                        <tbody id="ban_table"></tbody>
                                        <tfoot id="foot_ban" style="display:none">
                                            <tr id="totalall_ban" style="display:none">
                                                <th class="text-dark text-start">Overall Total:</th>
                                                <th class="text-dark text-center"></th>
                                                <th class="text-dark text-center"></th>
                                            </tr>
                                            <tr id="total">
                                                <th class="text-dark text-start">Total:</th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- / Content -->

                    <!-- Footer -->
                    <?php include('footer.php'); ?>
                    <!-- / Footer -->
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
                    <script type="text/javascript"
                        src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

                    <script>
                        const live_URL = '<?php echo $apistatpath; ?>';
                        var live_URL1 = '<?php echo $apiinvenpath; ?>';
                        const token = 'Bearer ' + document.getElementById('token').value;
                        let agency_id = document.getElementById('agencyid').value;
                        let getTodayDate;
                        let userid = '<?php echo $_SESSION['user_id']; ?>';
                        var permissions = [];
                        var impr = [];
                        var click = [];
                        var device = {};
                        var clicks = {};
                        var clicksum = 0;
                        var clicksum1 = 0;

                        function onChangeDetails() {
                            impr = [];
                            click = [];
                            clicksum = 0;
                            clicksum1 = 0;
                            $(".loader").show();
                            let date = new Date();
                            var getSelectedDay = document.getElementById('getCampaign').value;

                            document.getElementById('daterange').style.display = getSelectedDay == 'custom' ? "block" : "none";

                            switch (getSelectedDay) {
                                case 'Today':
                                    let v3 = JSON.stringify(date).slice(1, 11);
                                    getTodayDate = v3;
                                    getCampaignDate(v3, v3);
                                    break;
                                case 'Yesterday':
                                    let current_date = date.setDate(date.getDate() - 1);
                                    const get_date = new Date(date);
                                    let yesterday_date = JSON.stringify(get_date).slice(1, 11);
                                    getCampaignDate(yesterday_date, yesterday_date);
                                    break;
                                case 'Last 7 days':
                                    let calculate_7dyas = date.setDate(date.getDate() - 7);
                                    let start_7Days = new Date(calculate_7dyas);
                                    let first_day = JSON.stringify(start_7Days).slice(1, 11);

                                    let todayDate = new Date();
                                    let current_7Dyas = todayDate.setDate(todayDate.getDate() - 1);
                                    let last_7Days = new Date(todayDate);
                                    let date_end = JSON.stringify(last_7Days).slice(1, 11);
                                    getCampaignDate(first_day, date_end);
                                    break;
                                case 'Last 30 days':
                                    let calculate_30dyas = date.setDate(date.getDate() - 30);
                                    let start_30Days = new Date(calculate_30dyas);
                                    var first_30Days = JSON.stringify(start_30Days).slice(1, 11);
                                    first_30Days = first_30Days

                                    let today_Date = new Date();
                                    let current_30Dyas = today_Date.setDate(today_Date.getDate() - 1);
                                    let last_30Days = new Date(today_Date);
                                    let final_30Days = JSON.stringify(last_30Days).slice(1, 11);
                                    getCampaignDate(first_30Days, final_30Days);
                                    break;
                                case 'Last Month':
                                    var prevMonthLastDate = new Date(date.getFullYear(), date.getMonth(), 0);
                                    var prevMonthFirstDate = new Date(date.getFullYear() - (date.getMonth() > 0 ? 0 : 1), (date.getMonth() - 1 + 12) % 12, 1);
                                    var formatDateComponent = function (dateComponent) {
                                        return (dateComponent < 10 ? '0' : '') + dateComponent;
                                    }
                                    var formatDate = function (date) {
                                        return date.getFullYear() + "-" + formatDateComponent(date.getMonth() + 1) + "-" + formatDateComponent(date.getDate())
                                    };
                                    getCampaignDate(formatDate(prevMonthFirstDate), formatDate(prevMonthLastDate));
                                    break;
                                case 'This Month':
                                    let firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
                                    let cYear = firstDay.getFullYear(),
                                        cMonth = firstDay.getMonth() + 1,
                                        cDate = firstDay.getDate();
                                    let start_thisMonth = cYear + "-" + cMonth + "-" + cDate;

                                    let lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                                    let year = lastDay.getFullYear(),
                                        month = lastDay.getMonth() + 1,
                                        day = lastDay.getDate();
                                    let end_thisMonth = year + "-" + month + "-" + day;
                                    getCampaignDate(start_thisMonth, end_thisMonth);
                                    break;
                                case 'All Statistics':
                                    var value = 0;
                                    getCampaignDate(value, value);
                                    break;
                                case 'custom':
                                    $(".loader").hide();
                                    let getCurrentDate = JSON.stringify(date).slice(1, 11);
                                    getCampaignDate(getCurrentDate, getCurrentDate);
                                    $(function () {
                                        $('input[name="daterange"]').daterangepicker({
                                            opens: 'left',
                                            locale: {
                                                format: 'DD/MM/YYYY'
                                            },
                                        }, function (start, end, label) {
                                            // console.log("A new date selection was made: " + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD'));
                                            getCampaignDate(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
                                        })
                                    })
                                    break;
                            };
                        };

                        getCampaignDate = (start_date, end_date) => {
                            let payload = (start_date == 0 & end_date == 0) ? {
                                "action": 'all'
                            } : {
                                "action": '',
                                "start_date": start_date + ' 00:00:00,',
                                "end_date": end_date + ' 23:59:59,'
                            };

                            var type = $("#camp_banner option:selected").val();
                            var device_type = $("#device_type option:selected").val();

                            if (type == 'campaign') {
                                var domain_url = live_URL + '/get_device_agency_campaignwise_statistics/';

                            } else {
                                var domain_url = live_URL + '/get_device_agency_bannerwise_statistics/';
                            }

                            // if(start_date){
                            // var StartdateAr = start_date.split('-');
                            // console.log("test", StartdateAr);
                            // var StartnewDate = StartdateAr[2] + '-' + StartdateAr[1] + '-' + StartdateAr[0];
                            // }

                            // let website_url = domain_url + start_date + ' 00:00:00,' + end_date + ' 23:59:59,' + affiliate_id;
                            $.ajax({
                                url: domain_url + agency_id + ',' + device_type,
                                type: 'POST',
                                beforeSend: function (xhr) {
                                    xhr.setRequestHeader('Authorization', token);
                                },
                                data: payload,
                                success: function (data) {
                                    $(".loader").hide();
                                    if (data.msg == 'No Stats Available') {
                                        $("#foot").hide();
                                        $('#impressions_chart').hide();
                                        $('#clicks_chart').hide();

                                        if (type == "campaign") {
                                            $('#table_camp').show();
                                            $('#camapaignrep').show();
                                            $('#camp_table').show();
                                            $('#table_ban').hide();
                                            $('#banrep').hide();
                                            $('#ban_table').hide();
                                            $('#alltotal_camp').hide();
                                            $('#foot_camp').hide();
                                            $('#alltotal_ban').hide();
                                            $('#foot_ban').hide();
                                            $('#camapaignrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                                }
                                            });
                                        } else {
                                            $('#table_ban').show();
                                            $('#banrep').show();
                                            $('#ban_table').show();
                                            $('#table_camp').hide();
                                            $('#camapaignrep').hide();
                                            $('#camp_table').hide();
                                            $('#alltotal_camp').hide();
                                            $('#foot_camp').hide();
                                            $('#alltotal_ban').hide();
                                            $('#foot_ban').hide();
                                            $('#banrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                                }
                                            });
                                        }

                                    } else if (data.msg == 'Please enter valid Advertiser Id') {
                                        $('#impressions_chart').hide();
                                        $('#clicks_chart').hide();

                                        if (type == "campaign") {
                                            $('#table_camp').show();
                                            $('#camapaignrep').show();
                                            $('#camp_table').show();
                                            $('#banrep').hide();
                                            $('#ban_table').hide();
                                            $('#alltotal_camp').hide();
                                            $('#foot_camp').hide();
                                            $('#alltotal_ban').hide();
                                            $('#foot_ban').hide();
                                            $('#camapaignrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: "No Data Found"
                                                }
                                            });
                                        } else {
                                            $('#table_ban').show();
                                            $('#banrep').show();
                                            $('#ban_table').show();
                                            $('#table_camp').hide();
                                            $('#camapaignrep').hide();
                                            $('#camp_table').hide();
                                            $('#alltotal_camp').hide();
                                            $('#foot_camp').hide();
                                            $('#alltotal_ban').hide();
                                            $('#foot_ban').hide();
                                            $('#banrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                responsive: true,
                                                bPaginate: false,
                                                bInfo: false,
                                                data: [],
                                                searching: false,
                                                oLanguage: {
                                                    sEmptyTable: "No Data Found"
                                                }
                                            });
                                        }
                                    } else {
                                        if (type == "campaign") {
                                            $('#table_camp').show();
                                            $('#camapaignrep').show();
                                            $('#camp_table').show();
                                            $('#banrep').hide();
                                            $('#ban_table').hide();
                                            $('#alltotal_camp').show();
                                            $('#foot_camp').show();
                                            $('#alltotal_ban').hide();
                                            $('#foot_ban').hide();
                                            $('#camapaignrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                                buttons: [
                                                    {
                                                        extend: 'collection',
                                                        text: 'Export',
                                                        autoClose: true,
                                                        className: 'btn btn-warning btn-sm export',
                                                        buttons: [
                                                            {
                                                                text: 'Excel',
                                                                extend: 'excel',
                                                                header: true,
                                                                footer: true,
                                                                visible: false,
                                                                "customize": function (xlsx) {
                                                                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                                    $('row c', sheet).attr('s', '51'); //for all rows
                                                                    //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                                                    //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                                                }
                                                            },
                                                            {
                                                                text: 'PDF',
                                                                extend: 'pdf',
                                                                header: true,
                                                                footer: true,
                                                                visible: false,
                                                                orientation: 'landscape',
                                                                pageSize: 'LEGAL',
                                                                customize: function (doc) {
                                                                    doc.styles.tableBodyEven.alignment = 'center';
                                                                    doc.styles.tableBodyOdd.alignment = 'center';
                                                                    doc.styles.tableFooter.alignment = 'center';
                                                                },
                                                            }
                                                        ],
                                                        fade: true,
                                                    }
                                                ],
                                                data: data,
                                                language: {
                                                    decimal: ',',
                                                    thousands: '.',
                                                },
                                                columns: [
                                                    {
                                                        data: 'campaignname',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: "text-center"
                                                    },
                                                ],
                                                footerCallback: function (row, data, start, end, display) {
                                                    let api = this.api();

                                                    // Remove the formatting to get integer data for summation
                                                    let intVal = function (i) {
                                                        return typeof i === 'string'
                                                            ? i.replace(/[\$,]/g, '') * 1
                                                            : typeof i === 'number'
                                                                ? i
                                                                : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var impressions = api
                                                        .column(1, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var clicks = api
                                                        .column(2, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);


                                                    var foot_impressions = api
                                                        .column(1, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);
                                                    var foot_clicks = api
                                                        .column(2, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    // Update footer by showing the total with the reference of the column index 
                                                    // $('#adv_table tfoot tr:nth-child(2) th:nth-child(2)').html('Total');
                                                    $('#camapaignrep tfoot tr:nth-child(2) th:nth-child(2)').html(impressions);
                                                    $('#camapaignrep tfoot tr:nth-child(2) th:nth-child(3)').html(clicks);

                                                    $('#camapaignrep #alltotal_camp th:nth-child(2)').html(foot_impressions);
                                                    $('#camapaignrep #alltotal_camp th:nth-child(3)').html(foot_clicks);

                                                    $('#camapaignrep tfoot tr:nth-child(1) th:nth-child(2)').html(foot_impressions);
                                                    $('#camapaignrep tfoot tr:nth-child(1) th:nth-child(3)').html(foot_clicks);

                                                },

                                                initComplete: function (settings) {
                                                    //settings.nTable.id --> Get table ID
                                                    $('#' + settings.nTable.id + '_filter input')
                                                        .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                        .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                          <span aria-hidden="true">&times;</span>
                                                        </button>`)
                                                        .attr('required', 'required').attr('title', 'Search');

                                                    // Click Event on Clear button
                                                    $(document).on('click', '#' + settings.nTable.id + '_filter button', function () {
                                                        $('#' + settings.nTable.id).DataTable({
                                                            "retrieve": true
                                                        }).search('').draw(); // reDraw table
                                                    });
                                                }
                                            });
                                            for (var i = 0; i < data.length; i++) {
                                                device['name'] = data[i]['campaignname'];
                                                device['y'] = parseInt(data[i]['impressions']);
                                                impr.push(device);
                                                device = {};

                                                clicks['name'] = data[i]['campaignname'];
                                                clicks['y'] = parseInt(data[i]['clicks']);
                                                click.push(clicks);
                                                clicks = {};

                                                clicksum += parseInt(data[i]['clicks']);
                                            }
                                            piechart(impr, click);

                                        } else {
                                            $('#table_ban').show();
                                            $('#banrep').show();
                                            $('#ban_table').show();
                                            $('#table_camp').hide();
                                            $('#camapaignrep').hide();
                                            $('#camp_table').hide();
                                            $('#alltotal_camp').hide();
                                            $('#foot_camp').hide();
                                            $('#alltotal_ban').show();
                                            $('#foot_ban').show();
                                            $('#banrep').DataTable({
                                                ordering: false,
                                                destroy: true,
                                                "dom": '<"top"<"center-col"l><"left-col"B><"right-col"f>>rtip',
                                                buttons: [
                                                    {
                                                        extend: 'collection',
                                                        text: 'Export',
                                                        autoClose: true,
                                                        className: 'btn btn-warning btn-sm export',
                                                        buttons: [
                                                            {
                                                                text: 'Excel',
                                                                extend: 'excel',
                                                                header: true,
                                                                footer: true,
                                                                visible: false,
                                                                "customize": function (xlsx) {
                                                                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                                                                    $('row c', sheet).attr('s', '51'); //for all rows
                                                                    //$('row:eq(0) c', sheet).attr('s','2');                                                                                                             
                                                                    //$('row:eq(1) c', sheet).attr('s', '2');                                                              
                                                                }
                                                            },
                                                            {
                                                                text: 'PDF',
                                                                extend: 'pdf',
                                                                header: true,
                                                                footer: true,
                                                                visible: false,
                                                                orientation: 'landscape',
                                                                pageSize: 'LEGAL',
                                                                customize: function (doc) {
                                                                    doc.styles.tableBodyEven.alignment = 'center';
                                                                    doc.styles.tableBodyOdd.alignment = 'center';
                                                                    doc.styles.tableFooter.alignment = 'center';
                                                                },
                                                            }
                                                        ],
                                                        fade: true,
                                                    }
                                                ],
                                                data: data,
                                                language: {
                                                    decimal: ',',
                                                    thousands: '.',
                                                },
                                                columns: [
                                                    {
                                                        data: 'bannername',
                                                        className: "text-start"
                                                    },
                                                    {
                                                        data: 'impressions',
                                                        className: "text-center"
                                                    },
                                                    {
                                                        data: 'clicks',
                                                        className: "text-center"
                                                    },
                                                ],
                                                footerCallback: function (row, data, start, end, display) {
                                                    let api = this.api();

                                                    // Remove the formatting to get integer data for summation
                                                    let intVal = function (i) {
                                                        return typeof i === 'string'
                                                            ? i.replace(/[\$,]/g, '') * 1
                                                            : typeof i === 'number'
                                                                ? i
                                                                : 0;
                                                    };

                                                    // computing column Total of the complete result 
                                                    var impressions = api
                                                        .column(1, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    var clicks = api
                                                        .column(2, { page: 'current' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);


                                                    var foot_impressions = api
                                                        .column(1, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);
                                                    var foot_clicks = api
                                                        .column(2, { page: 'footer' })
                                                        .data()
                                                        .reduce(function (a, b) {
                                                            return intVal(a) + intVal(b);
                                                        }, 0);

                                                    // Update footer by showing the total with the reference of the column index 
                                                    // $('#adv_table tfoot tr:nth-child(2) th:nth-child(2)').html('Total');
                                                    $('#banrep tfoot tr:nth-child(2) th:nth-child(2)').html(impressions);
                                                    $('#banrep tfoot tr:nth-child(2) th:nth-child(3)').html(clicks);

                                                    $('#banrep #alltotal_ban th:nth-child(2)').html(foot_impressions);
                                                    $('#banrep #alltotal_ban th:nth-child(3)').html(foot_clicks);

                                                    $('#banrep tfoot tr:nth-child(1) th:nth-child(2)').html(foot_impressions);
                                                    $('#banrep tfoot tr:nth-child(1) th:nth-child(3)').html(foot_clicks);
                                                },

                                                initComplete: function (settings) {
                                                    //settings.nTable.id --> Get table ID
                                                    $('#' + settings.nTable.id + '_filter input')
                                                        .wrap(`<div class="d-inline-flex position-relative"></div>`)
                                                        .after(`<button type="button" class="close position-absolute" aria-label="Close" style="right:5px">
                                                          <span aria-hidden="true">&times;</span>
                                                        </button>`)
                                                        .attr('required', 'required').attr('title', 'Search');

                                                    // Click Event on Clear button
                                                    $(document).on('click', '#' + settings.nTable.id + '_filter button', function () {
                                                        $('#' + settings.nTable.id).DataTable({
                                                            "retrieve": true
                                                        }).search('').draw(); // reDraw table
                                                    });
                                                }
                                            });
                                            for (var i = 0; i < data.length; i++) {
                                                device['name'] = data[i]['bannername'];
                                                device['y'] = parseInt(data[i]['impressions']);
                                                impr.push(device);
                                                device = {};

                                                clicks['name'] = data[i]['bannername'];
                                                clicks['y'] = parseInt(data[i]['clicks']);
                                                click.push(clicks);
                                                clicks = {};

                                                clicksum1 += parseInt(data[i]['clicks']);
                                            }
                                            piechart(impr, click);
                                        }
                                    }


                                    $.ajax({
                                        type: "GET",
                                        url: live_URL1 + '/get_permissions/' + userid,
                                        beforeSend: function (xhr) {
                                            xhr.setRequestHeader('Authorization', token);
                                        },
                                        dataType: "json",
                                        encode: true,
                                    }).done(function (data) {
                                        let get_data = data.data;
                                        if (get_data) {
                                            for (var i = 0; i < get_data.length; i++) {
                                                permissions[i] = get_data[i];
                                            }
                                        } else {
                                            permissions = '';
                                        }
                                        if (!permissions.includes('44')) {
                                            $('.export').hide();
                                        } else {
                                            $('.export').show();
                                        }
                                    });
                                },
                                error: function () { },
                            });
                        };

                        function piechart(impr, click) {
                            $('#impressions_chart').show();
                            Highcharts.chart('impressions_chart', {
                                chart: {
                                    plotBackgroundColor: null,
                                    plotBorderWidth: null,
                                    plotShadow: false,
                                    type: 'pie'
                                },
                                title: {
                                    text: 'Shares of Impressions'
                                },
                                credits: {
                                    enabled: false
                                },
                                tooltip: {
                                    pointFormat: '{series.name}: <b>{point.y}</b>'
                                },
                                plotOptions: {
                                    pie: {
                                        allowPointSelect: true,
                                        cursor: 'pointer',
                                        dataLabels: {
                                            enabled: false
                                        }
                                    }
                                },
                                series: [{
                                    name: 'Impressions',
                                    colorByPoint: true,
                                    data: impr,
                                }]
                            });

                            if (clicksum > 0 || clicksum1 > 0) {
                                $('#clicks_chart').show();
                                Highcharts.chart('clicks_chart', {
                                    chart: {
                                        plotBackgroundColor: null,
                                        plotBorderWidth: null,
                                        plotShadow: false,
                                        type: 'pie'
                                    },
                                    title: {
                                        text: 'Shares of Clicks'
                                    },
                                    credits: {
                                        enabled: false
                                    },
                                    tooltip: {
                                        pointFormat: '{series.name}: <b>{point.y}</b>'
                                    },
                                    plotOptions: {
                                        pie: {
                                            allowPointSelect: true,
                                            cursor: 'pointer',
                                            dataLabels: {
                                                enabled: false
                                            }
                                        }
                                    },
                                    series: [{
                                        name: 'Clicks',
                                        colorByPoint: true,
                                        data: click,
                                    }]
                                });
                            } else {
                                $('#clicks_chart').hide();
                            }
                        }
                    </script>

                    <div class="content-backdrop fade"></div>
                </div>
                <!-- Content wrapper -->
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
</body>

</html>