<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['orderjob']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        .alert {
            display: none;
        }

        #addtracker,
        #deletetracker {
            float: right;
        }

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .tableName {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .tableName:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .dataTables_scrollBody {
            height: auto !important;
        }
    </style>
</head>

<body onload=gettracker();>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top my-4 mx-3">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="advertiser_edit.php?clientid=<?php echo $_GET['clientid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['adv_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><span class="text-warning">
                                            <?php echo $GLOBALS['trackers']; ?>
                                        </span></a>
                                </li>
                                <!-- <li class="nav-item">
                                        <a class="nav-link"
                                            href="advertiser_access.php?clientid=<?php echo $_GET['clientid']; ?>"><span
                                                class="text-dark">
                                                <?php echo $GLOBALS['user_access']; ?>
                                            </span></a>
                                    </li> -->
                            </ul>
                            <div class="tab-content">
                                <div>
                                    <p class="alert bg-success alert-dismissible fade show text-white"
                                        id="alertsuccess"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['tracker_delete_success_msg']; ?>
                                    </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['tracker_delete_failed_msg']; ?>
                                    </p>
                                </div>
                                <div class="tab-pane fade show active" id="" role="tabpanel">
                                    <div class="row mb-3">
                                        <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2">

                                        </div>
                                        <div
                                            class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">

                                        </div>
                                        <div
                                            class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button type="button" class="btn btn-warning" id="deletetracker" style=""
                                                onclick="delete_tracker()">
                                                <i class="bx bx-trash bg-label-white" aria-hidden="true"
                                                    title="Delete"></i>
                                                <?php echo $GLOBALS['delete']; ?>
                                            </button>&nbsp;
                                            <button id="addtracker" class="btn btn-warning"
                                                onclick="window.location.href='adv_tracker_add.php?clientid=<?php echo $_GET['clientid']; ?>'"
                                                style="">
                                                <i class="menu-icon tf-icons bx bx-plus"></i>
                                                <?php echo $GLOBALS['add_tracker']; ?>
                                            </button>
                                        </div>
                                    </div>
                                    <hr class="solid">
                                    <div class="row">
                                        <div class="table-responsive text-nowrap">
                                            <table id="tracker_table"
                                                class="table table-striped table-responsive table-hover mt-3">
                                                <thead class="">
                                                    <tr class="text-nowrap">
                                                        <th class="th-color"><input name="select_all"
                                                                class="form-check-input" type="checkbox"
                                                                id="select_all"></th>
                                                        <th class="th-color">
                                                            <?php echo $GLOBALS['strName']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['conversion_type']; ?>
                                                        </th>
                                                        <th class="th-color text-center">
                                                            <?php echo $GLOBALS['']; ?>
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody id="fbody" class="fbody">
                                                    <!-- <td colspan="5" id="linkempty" class="text-center">
                                                                <?php echo $GLOBALS['no_tracker']; ?>
                                                            </td> -->
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php include('footer.php'); ?>
                </div>
            </div>
        </div>
        <script src="../js/sweetalert.min.js"></script>
        <script>
            var live_URL = '<?php echo $apiinvenpath; ?>';
            var token = 'Bearer ' + document.getElementById('token').value;
            var clientid = '<?php echo $_REQUEST['clientid']; ?>';
            $("#deletetracker").attr("disabled", true);
            $("#linkempty").hide();

            function gettracker() {
                $.ajax({
                    url: live_URL + '/get_advertiser_tracker/' + clientid,
                    type: 'GET',
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    dataType: 'json',
                    encode: true,
                    success: function (data) {
                        $(".loader").show();

                        if (data.msg == 'No Data') {
                            $(".loader").hide();
                            $('#tracker_table').DataTable({
                                ordering: false,
                                destroy: true,
                                responsive: true,
                                bPaginate: false,
                                bAutoWidth: false,
                                bInfo: false,
                                data: [],
                                searching: false,
                                oLanguage: {
                                    sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                                }
                            });
                        } else {
                            $(".loader").hide();
                            $(document).ready(function () {
                                var rows_selected = [];
                                var table = $('#tracker_table').DataTable({
                                    destroy: true,
                                    targets: 0,
                                    searchable: false,
                                    orderable: false,
                                    stateSave: false,
                                    fixedColumns: true,
                                    //className: 'dt-body-center',
                                    responsive: false,
                                    data: data.data,
                                    columns: [{
                                        data: 'trackerid',
                                        render: function (data, type, row, meta) {
                                            return '<input type="checkbox" name="checkrow" class="form-check-input data-checked" id="checkrow" value="' + row.trackerid + '" data-trackerid="' + row.trackerid + '">';
                                        }
                                    },
                                    {
                                        'data': null,
                                        wrap: true,
                                        className: "text-left tableName",
                                        "render": function (tracker) {
                                            return '<a href="adv_tracker_edit.php?clientid=' + clientid + '&trackerid=' + tracker.trackerid + '">' + tracker.trackername + '</a>'
                                        }
                                    },
                                    {
                                        'data': 'trackerid',
                                        wrap: true,
                                        className: "text-center tableName",
                                        "render": function (data, type, row, meta) {
                                            var type = row.type;
                                            if (type == 1) {
                                                type = "Sale";
                                            } else if (type == 2) {
                                                type = "Lead";
                                            } else if (type == 3) {
                                                type = "Signup";
                                            }
                                            return '<span>' + type + '</span>'
                                        }
                                    },
                                    {
                                        data: 'trackerid',
                                        className: "text-center",
                                        render: function (data, type, row, meta) {
                                            var linkcampaign = '<a href="tracker_campaigns.php?clientid=' + clientid + '&trackerid=' + row.trackerid + '"><i class="fas fa-link" aria-hidden="true" style="text-align:center;"></i>&nbsp;&nbsp;<?php echo $GLOBALS['link_campaigns']; ?></a>';

                                            return linkcampaign;
                                        }
                                    },

                                    ]
                                })
                            })
                        }
                    },
                    error: function () { },
                });
            }

            document.getElementById('select_all').onclick = function () {
                var checkboxes = document.querySelectorAll('input[type="checkbox"]');
                for (var checkbox of checkboxes) {
                    checkbox.checked = this.checked;
                }
                document.getElementById('deletetracker').disabled = $('.data-checked:checked').length > 0 ? false : true;
            }

            $(document).on('click', '.data-checked', function () {
                if ($('.data-checked:checked').length == $('.data-checked').length) {
                    $('#select_all').prop('checked', true);
                } else {
                    $('#select_all').prop('checked', false);
                }
                document.getElementById('deletetracker').disabled = $('.data-checked:checked').length > 0 ? false : true;
            });

            function delete_tracker() {
                var trackerData = [];
                var selected = $('#checkrow:checked');
                selected.each(function () {
                    trackerData.push($(this).attr('data-trackerid'));
                });
                if (trackerData.length <= 0) {
                    alert("Please select tracker.");
                }
                
                swal({
                    title: `<?php echo $GLOBALS['want_delete_tracker']; ?>`,
                    buttons: true,
                    dangerMode: true,
                    type: "success"
                }).then(function (isConfirm) {

                    if (isConfirm) {
                        $.ajax({
                            type: "DELETE",
                            url: live_URL + '/delete_tracker/' + trackerData,
                            beforeSend: function (xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            dataType: "json",
                            encode: true,
                        }).done(function (data) {
                            if (data.msg = "Tracker has been deleted successfully!") {
                                window.scrollTo(0, 0);
                                $("#alertsuccess").show('medium');
                                setTimeout(function () {
                                    $("#alertsuccess").hide('medium');
                                }, 2000);
                                setTimeout(function () {
                                    location.reload();
                                }, 1200);
                            } else {
                                window.scrollTo(0, 0);
                                $("#alertfailed").show('medium');
                                setTimeout(function () {
                                    $("#alertfailed").hide('medium');
                                }, 2000);
                            }

                        });
                    }
                });
            }

        </script>
</body>

</html>