<?php

/*----------------  Advertiser -------------*/

/*
 * Advertiser ADD
 * 
 * Input Parameters:
 * --------------- 
 * contact
 * email
 * username
 * password 
 * clientname
 * report - Email Campaign Delivery reports enable (true or false)
 * reportinterval - No of days between campaign delivery reports 
 * reportdeactivate - Email when a campaign is automatically activated/deactivated (true or false)
 * comments - comments for advertiser
 * advertiser_limitation -  Display only one banner from this advertiser on a web page ( 0 or 1)
 * 
 * Arguments:
 * ---------
 * Agency ID
 */


$app->post('/advertiser_add/[{agency_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array ('response' => 'error', 'msg' => 'Please check with input mandatory parameters and format of input');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$contactname = $input['contact'];
		$contact = $contactname;
		$email = $input['email'];
		$username = $input['username'];
		$realpassword = $input['password'];
		$clientname = $input['clientname'];

		// $clientname   = $input['name'];
		$report = $input['report'];
		$reportinterval = $input['reportinterval'];
		$reportdeactivate = $input['reportdeactivate'];
		$comments = $input['comments'];
		$limitation = $input['advertiser_limitation'];
		$password = md5($realpassword);
		$datetime = date('Y-m-d H:i:s');
		$agencyid = $args['agency_id'];

		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetchAll();
		if (count($check) > 0) {
			$stc = "select * from " . $table_prefix . "users where username=:username";
			$std = $this->db->prepare($stc);
			$std->bindParam("username", $username);
			$std->execute();
			$users = $std->fetchAll();
			if (!$users) {
				$addacc = "INSERT INTO " . $table_prefix . "accounts (`account_type`, `account_name`) VALUES ('ADVERTISER',:contactname);";
				$acc = $this->db->prepare($addacc);
				$acc->bindParam(":contactname", $contactname);
				$acc->execute();

				$account_id = $this->db->lastInsertId();
				// $addcl = "INSERT INTO ".$table_prefix."clients (`agencyid`, `clientname`, `contact`, 
				// `email`,`report`,`reportinterval`,`reportdeactivate`,`comments`,`updated`,`account_id`,`advertiser_limitation`) VALUES (:agencyid,:name,:contact,
				// :email,:report,:reportinterval,:reportdeactivate,:comments,:updated,:acccountid,:adv_limitation);";


				$addcl = "INSERT INTO " . $table_prefix . "clients (`agencyid`, `clientname`, `contact`, 
					`email`,`report`,`reportinterval`,`reportdeactivate`,`comments`,`updated`,`account_id`,`advertiser_limitation`) VALUES (:agencyid,:clientname,:contact,
					:email,:report,:reportinterval,:reportdeactivate,:comments,:updated,:acccountid,:adv_limitation);";

				$adv = $this->db->prepare($addcl);
				$adv->bindParam(":agencyid", $agencyid);
				$adv->bindParam(":contact", $contact);
				// $adv->bindParam(":name",$clientname);

				$adv->bindParam(":clientname", $clientname);
				$adv->bindParam(":email", $email);
				$adv->bindParam(":report", $report);
				$adv->bindParam(":reportinterval", $reportinterval);
				$adv->bindParam(":reportdeactivate", $reportdeactivate);
				$adv->bindParam(":comments", $comments);
				$adv->bindParam(":adv_limitation", $limitation);
				$adv->bindParam(":updated", $datetime);
				$adv->bindParam(":acccountid", $account_id);


				$adv->execute();

				$client_id = $this->db->lastInsertId();

				$addusr = "INSERT INTO " . $table_prefix . "users (`contact_name`, `email_address`,
					`username`, `password`,`language`,`default_account_id`,`comments`,`active`,`date_created`,`sso_user_id`,`date_last_login`,`email_updated`) 
					VALUES (:contactname,:email,:username,:password,'en',:accountid,:comments,1,:datetime,NULL,NULL,NULL);";
				$usr = $this->db->prepare($addusr);
				$usr->bindParam(":contactname", $contactname);
				$usr->bindParam(":email", $email);
				$usr->bindParam(":username", $username);
				$usr->bindParam(":comments", $comments);
				$usr->bindParam(":password", $password);
				$usr->bindParam(":accountid", $account_id);
				$usr->bindParam(":datetime", $datetime);
				$usr->execute();

				$user_id = $this->db->lastInsertId();

				$usrper = "INSERT INTO " . $table_prefix . "account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:acccountid,:userid,:datetime);";

				$acc_usrp = $this->db->prepare($usrper);
				$acc_usrp->bindParam(":acccountid", $account_id);
				$acc_usrp->bindParam(":userid", $user_id);
				$acc_usrp->bindParam(":datetime", $datetime);
				$acc_usrp->execute();

				$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(`account_id`, `user_id`, `permission_id`, `is_allowed`) VALUES
					(:acccountid,:userid,10,1),
					(:acccountid,:userid,4,1),
					(:acccountid,:userid,2,1),
					(:acccountid,:userid,1,1),
					(:acccountid,:userid,11,1);";

				$assoc = $this->db->prepare($userper_assc);
				$assoc->bindParam(":acccountid", $account_id);
				$assoc->bindParam(":userid", $user_id);
				$assoc->execute();

				if ($client_id) {

					$response = array ('response' => 'ok', 'msg' => 'Advertiser has been added successfully with clientid: ' . $client_id);
					return $this->response->withJson($response);
				}
			} else {
				$response = array ('response' => 'error', 'msg' => 'Username already exists!');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Invalid Agency id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('advertiser_validate'));



/*
 * Advertiser EDIT
 * 
 * Input Parameters:
 * --------------- 
 * contact
 * email
 * username
 * password 
 * clientname
 * report - Email Campaign Delivery reports enable (true or false)
 * reportinterval - No of days between campaign delivery reports 
 * reportdeactivate - Email when a campaign is automatically activated/deactivated (true or false)
 * comments - comments for advertiser
 * advertiser_limitation -  Display only one banner from this advertiser on a web page ( 0 or 1)
 * mode
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */

$app->post('/advertiser_edit/[{advertiser_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();

		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$contactname = (isset ($input['contact'])) ? $input['contact'] : '';
		$contact = $contactname;
		$email = (isset ($input['email'])) ? $input['email'] : '';
		$username = (isset ($input['username'])) ? $input['username'] : '';
		$realpassword = (isset ($input['password'])) ? $input['password'] : '';
		// $clientname   = (isset($input['clientname']))?$input['clientname']:'';
		$clientname = (isset ($input['name'])) ? $input['name'] : '';

		$reportinterval = (isset ($input['reportinterval'])) ? $input['reportinterval'] : '';
		$reportdeactivate = (isset ($input['reportdeactivate'])) ? $input['reportdeactivate'] : '';
		$comments = (isset ($input['comments'])) ? $input['comments'] : '';
		$limitation = (isset ($input['advertiser_limitation'])) ? $input['advertiser_limitation'] : '';
		$password = md5($realpassword);
		$datetime = date('Y-m-d H:i:s');
		$clientid = $args['advertiser_id'];

		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}


		$stc = "SELECT * FROM " . $table_prefix . "clients where clientid ='" . $clientid . "'";
		$std = $this->db->prepare($stc);
		$std->execute();
		$users = $std->fetchAll();


		$stc1 = "SELECT * FROM " . $table_prefix . "users where default_account_id ='" . $users[0]['account_id'] . "'";
		$std1 = $this->db->prepare($stc1);
		$std1->execute();
		$users1 = $std1->fetchAll();



		if ($users) {

			if (isset ($username) && !empty ($input['username'])) {

				$sql_username = $username;
			} else {
				$sql_username = $users1[0]['username'];
			}

			if (isset ($email) && !empty ($input['email'])) {
				$sql_email = $email;
			} else {
				$sql_email = $users[0]['email'];
			}

			//   if(isset($contactname) && !empty($input['contact'])) 
			//   {
			// 	  $sql_contactname = $contactname;
			//   }
			//   else
			//   {
			// 	  $sql_contactname = $users[0]['contact'];
			//   } 

			if (isset ($contact) && !empty ($input['contact'])) {
				$sql_contact = $contact;
			} else {
				$sql_contact = $users[0]['contact'];
			}

			if (isset ($password) && !empty ($input['password'])) {
				$sql_password = $password;
			} else {
				$sql_password = $users1[0]['password'];
			}

			if (isset ($clientname) && !empty ($input['password'])) {
				$sql_clientname = $clientname;
			} else {
				$sql_clientname = $users[0]['clientname'];
			}
			// print_r($sql_clientname);		
			// exit;

			// $acc_upd="update ".$table_prefix."accounts set  `account_name`=:clientname where  account_id=:account_id";
			$acc_upd = "update " . $table_prefix . "accounts set  `account_name`=:name where  account_id=:account_id";

			$acc_edit = $this->db->prepare($acc_upd);
			$acc_edit->bindParam(":name", $sql_clientname);

			// $acc_edit->bindParam(":clientname",$sql_clientname);
			$acc_edit->bindParam(":account_id", $users[0]['account_id']);
			$acc_edit->execute();

			// $cl_upd="update ".$table_prefix."clients set  `clientname`=:clientname,`contact`=:contact,`email`=:email,updated=:updated where clientid=:clientid";
			$cl_upd = "update " . $table_prefix . "clients set  `clientname`=:name,`contact`=:contact,`email`=:email,updated=:updated where clientid=:clientid";

			$client_edit = $this->db->prepare($cl_upd);
			// $client_edit->bindParam(":clientname",$sql_clientname);
			$client_edit->bindParam(":name", $sql_clientname);

			$client_edit->bindParam(":contact", $sql_contact);
			$client_edit->bindParam(":email", $sql_email);
			$client_edit->bindParam(":updated", $datetime);
			$client_edit->bindParam(":clientid", $clientid);
			$client_edit->execute();

			$user_upd = "update " . $table_prefix . "users set `contact_name`=:contact_name ,  `username`=:username,`password`=:password,`email_address`=:email_address,date_created=:updated where default_account_id=:default_account_id";
			$user_edit = $this->db->prepare($user_upd);

			$user_edit->bindParam(":contact_name", $sql_contact);
			$user_edit->bindParam(":username", $sql_username);
			$user_edit->bindParam(":password", $sql_password);
			$user_edit->bindParam(":email_address", $sql_email);
			$user_edit->bindParam(":updated", $datetime);
			$user_edit->bindParam(":default_account_id", $users[0]['account_id']);
			$update_adv = $user_edit->execute();

			if ($update_adv) {
				$response = array ('response' => 'ok', 'msg' => 'Advertiser has been updated successfully!');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter the valid advertiserid');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('advertiser_edit'));



/*
 * Advertiser DELETE
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */
$app->delete('/advertiser_delete1/[{clientid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$clientid = $args['clientid'];
		//print_r($clientid);exit("ok");
		$stc = "select * from " . $table_prefix . "clients where clientid in ($clientid)";
		$std = $this->db->prepare($stc);
		//$std->bindParam("clientid", $clientid);
		$std->execute();
		$users = $std->fetchAll();
		//$account_id = $users[0]['account_id'];

		if ($users) {
			foreach ($users as $key => $user) {
				$account_id1 .= $user['account_id'] . ',';
			}
			$account_id = rtrim($account_id1, ',');
			//print_r($account_id);exit("ok");
			$del_acc = "DELETE FROM " . $table_prefix . "accounts WHERE account_id in ($account_id)";
			$account_del = $this->db->prepare($del_acc);
			//$account_del->bindParam(":account_id", $account_id);
			$acc_del = $account_del->execute();

			$del_pub = "DELETE FROM " . $table_prefix . "clients WHERE account_id in ($account_id)";
			$pub_del = $this->db->prepare($del_pub);
			//$pub_del->bindParam(":account_id", $account_id);
			$pub_del->execute();

			$del_usr = "DELETE FROM " . $table_prefix . "users WHERE default_account_id in ($account_id)";
			$usr_del = $this->db->prepare($del_usr);
			//$usr_del->bindParam(":default_account_id", $account_id);
			$usr_del->execute();

			$acc_assoc = "DELETE FROM " . $table_prefix . "account_user_assoc WHERE account_id in ($account_id)";
			$del_acc_asc = $this->db->prepare($acc_assoc);
			//$del_acc_asc->bindParam(":account_id", $account_id);
			$del_acc_asc->execute();

			$acc_usr_prm = "DELETE FROM " . $table_prefix . "account_user_permission_assoc WHERE account_id in ($account_id)";
			$acc_usr_permission = $this->db->prepare($acc_usr_prm);
			//$acc_usr_permission->bindParam(":account_id", $account_id);
			$acc_usr_permission->execute();

			if ($acc_del) {
				$response = array ('response' => 'ok', 'msg' => 'Advertiser has been deleted successfully!');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid account id!');
			return $this->response->withJson($response);
		}
	}
});


/*
 * Get Advertiser details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */
$app->get('/get_advertiser/[{advertiserid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$advertiserid = $args['advertiserid'];

		$stc = "SELECT * FROM " . $table_prefix . "clients AS t1 JOIN " . $table_prefix . "users AS t2 ON  t1.account_id = t2.default_account_id where t1.clientid =:clientid";
		//$stc = "SELECT * FROM ".$table_prefix."clients AS t1  where t1.clientid =:clientid";		                 


		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $advertiserid);
		$std->execute();
		$users = $std->fetchAll();
		if ($users) {

			$adv_det[$users[0]['clientid']] =
				array (
					'clientid' => $users[0]['clientid'],
					'clientname' => $users[0]['clientname'],
					'contact' => $users[0]['contact'],
					'email' => $users[0]['email'],
					'username' => $users[0]['username'],
					'password' => $users[0]['password']
				);
			return $this->response->withJson($adv_det);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('advertiser_val'));


/*
 * Get Advertiser details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Agency ID
 */

$app->get('/get_all_advertiser/[{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$agency_id = $args['agencyid'];

		$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
            " . $table_prefix . "agency as ag
			where
			ag.account_id = a.account_id
			AND a.preference_id = 16
			AND ag.agencyid =$agency_id";
	$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
	$TimeZonestd->execute();

	$TimeZoneRow = $TimeZonestd->fetchAll();


	if ($TimeZoneRow) {

		$timezone = $TimeZoneRow[0]['timezone'];
	} else {

		$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
		$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
		$TimeZonestd->execute();
		$TimeZoneRow = $TimeZonestd->fetchAll();
		if($TimeZoneRow){
			$timezone = $TimeZoneRow[0]['timezone'];
			}
			else{
				$timezone = 'UTC';

			}
	}
	if($timezone=='0'){
		$timezone = 'UTC';

	}
	else{
		$timezone = $timezone;

	}

	date_default_timezone_set($timezone);


	// $date1 = date("d-m-Y H:i:s");
	// date_default_timezone_set('UTC');
	// $date2 = date("d-m-Y H:i:s");
	// $time_diff = strtotime($date1) - strtotime($date2);
	// $date3 = date('H:i', $time_diff);

	// $date4 = '+'.$date3;


	$tz = new DateTimeZone($timezone);
	$offset = $tz->getOffset(new DateTime());

	// Convert offset to hours and minutes
	$offsetHours = floor($offset / 3600);
	$offsetMinutes = floor(($offset % 3600) / 60);

	// Determine the GMT offset string
	$gmtOffset = sprintf('%+03d:%02d', $offsetHours, $offsetMinutes);

		$stc = "SELECT clientid,agencyid,clientname,contact,email,DATE_FORMAT(CONVERT_TZ(updated,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as updated FROM " . $table_prefix . "clients where agencyid =:agencyid Order by updated Desc";

		$std = $this->db->prepare($stc);
		$std->bindParam("agencyid", $agency_id);
		$std->execute();
		$users = $std->fetchAll();

		if ($users) {
			foreach ($users as $adv) { //$adv['clientid']
				$adv_list[] = $adv;
			}
			$response = array ('data' => $adv_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('agencyid_val'));

/*
 * Get Campaignwise Advertiser details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Agency ID
 */

$app->get('/get_campaignsizewise_advertiser/[{agencyid},{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$agency_id = $args['agencyid'];
		$zoneid = $args['zoneid'];

		$stc = "SELECT * FROM " . $table_prefix . "zones where zoneid =" . $zoneid;
		$std = $this->db->prepare($stc);
		$std->execute();
		$zone_det = $std->fetchAll();

		if (count($zone_det) <= 0) {
			$response = array ('response' => 'error', 'msg' => 'Enter valid zoneid!');
			return $this->response->withJson($response);
		} else {

			$zonewidth = $zone_det[0]['width'];
			$zoneheight = $zone_det[0]['height'];
			$zonetype = $zone_det[0]['delivery'];
			if ($zonewidth == '0' && $zoneheight == '0' && $zonetype != '3') {
				$response = array ('response' => 'error', 'msg' => 'Invalid zone size!');
				return $this->response->withJson($response);
			}
			if ($zonewidth == '-1' && $zoneheight == '-1') {

				$stc = "SELECT cle.clientid,cle.agencyid,cle.clientname,cle.contact,cle.email FROM " . $table_prefix . "clients cle," . $table_prefix . "campaigns cam," . $table_prefix . "banners ban where cle.clientid=cam.clientid and cam.campaignid=ban.campaignid and agencyid =:agencyid group by cle.clientid";

				$std = $this->db->prepare($stc);
				$std->bindParam("agencyid", $agency_id);
				$std->execute();
				$users = $std->fetchAll();

				if ($users) {
					foreach ($users as $adv) {
						$adv_list[] = $adv;
					}
					$response = array ('data' => $adv_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency id!');
					return $this->response->withJson($response);
				}
			} else {
				$stc = "SELECT cle.clientid,cle.agencyid,cle.clientname,cle.contact,cle.email FROM " . $table_prefix . "clients cle," . $table_prefix . "campaigns cam," . $table_prefix . "banners ban where cle.clientid=cam.clientid and cam.campaignid=ban.campaignid and ban.width=" . $zonewidth . " and ban.height=" . $zoneheight . " and agencyid =:agencyid group by cle.clientid";

				$std = $this->db->prepare($stc);
				$std->bindParam("agencyid", $agency_id);
				$std->execute();
				$users = $std->fetchAll();

				if ($users) {
					foreach ($users as $adv) { //$adv['clientid']
						$adv_list[] = $adv;
					}
					$response = array ('data' => $adv_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency id!');
					return $this->response->withJson($response);
				}
			}
		}
	}
})->add($container->get('agencyid_val'));


/*----------------  Advertiser -------------*/

/*----------------  Campaign -------------*/

/*
 * Campaign ADD
 * 
 * Input Parameters:
 * --------------- 
 * campaignname [mandatory]
 * clientid [mandatory]
 * views
 * clicks
 * conversions
 * weight
 * anonymous
 * companion 
 * revenue
 * revenue_type [mandatory]
 * priority [mandatory]
 * status
 * start_date [mandatory]
 * end_date  [mandatory]
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */

$app->post('/campaign_add/[{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$clientid = $args['client_id'];

		$stc = "select * from " . $table_prefix . "clients where clientid=:clientid";
		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $clientid);
		$std->execute();
		$clients = $std->fetchAll();
		$datetime = date('Y-m-d H:i:s');
		$currentdate = date('Y-m-d');


		if ($clients) {
			$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
			" . $table_prefix . "clients as cl,
            " . $table_prefix . "agency as ag
			where
			cl.agencyid = ag.agencyid
            AND ag.account_id = a.account_id
			AND a.preference_id = 16
			AND cl.clientid =" . $clientid;
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			if ($TimeZoneRow) {
				$timezone = $TimeZoneRow[0]['timezone'];
			} else {
				$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
				$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
				$TimeZonestd->execute();
				$TimeZoneRow = $TimeZonestd->fetchAll();
				$timezone = $TimeZoneRow[0]['timezone'];
			}
			date_default_timezone_set($timezone);
			$date1 = date("d-m-Y H:i:s");
			date_default_timezone_set('UTC');
			$date2 = date("d-m-Y H:i:s");
			$time_diff = strtotime($date1) - strtotime($date2);

			$campaignname = $input['campaignname'];
			$category = $input['category'];
			// $category = implode(",", $category1);
			$booked_impression = $input['booked_impression'];
			$views = (isset ($input['views'])) ? $input['views'] : '-1';
			$clicks = (isset ($input['clicks'])) ? $input['clicks'] : '-1';
			$conversions = (isset ($input['conversions'])) ? $input['conversions'] : '-1';
			$priority = (isset ($input['priority'])) ? $input['priority'] : '0';
			$weight = (isset ($input['weight'])) ? $input['weight'] : '0';
			if ($weight > 127) {
				$weight = "127";
			}
			$targetimp = (isset ($input['target_impression'])) ? $input['target_impression'] : '0';
			$targetclk = (isset ($input['target_click'])) ? $input['target_click'] : '0';
			$targetconv = (isset ($input['target_conversion'])) ? $input['target_conversion'] : '0';
			$companion = (isset ($input['companion'])) ? $input['companion'] : '0';
			$comments = $input['comments'];

			$revenue = $input['revenue'];
			$revenuetype = (isset ($input['revenue_type'])) ? $input['revenue_type'] : '1';

			$block = (isset ($input['block'])) ? $input['block'] : '0';
			$capping = (isset ($input['capping'])) ? $input['capping'] : '0';
			$session_capping = (isset ($input['session_capping'])) ? $input['session_capping'] : '0';
			$show_capped_no_cookie = (isset ($input['show_capped_no_cookie'])) ? $input['show_capped_no_cookie'] : '0';

			$anonymous = (isset ($input['anonymous'])) ? $input['anonymous'] : 'f';
			$start_date = (isset ($input['start_date'])) ? $input['start_date'] : $datetime;
			$end_date = (isset ($input['end_date'])) ? $input['end_date'] : 'NULL';
			$end_date1 = $end_date;

			$start_date = date('Y-m-d H:i:s', strtotime($start_date));
			$end_date = date('Y-m-d H:i:s', strtotime($end_date));

			$startdate = date('Y-m-d', strtotime($start_date));
			$enddate = date('Y-m-d', strtotime($end_date));
			$enddatenull = $input['end_date'];

			$start_date = strtotime($start_date) - $time_diff;
			$start_date = date("Y-m-d H:i:s", $start_date);

			if ($end_date1 != 'NULL' && $end_date1 != '') {
				$end_date = strtotime($end_date) - $time_diff;
				$end_date = date("Y-m-d H:i:s", $end_date);
			}

			if ($startdate && $enddatenull == '') {
				//Start Date And Dont' Expire Scenarios
				if ($currentdate == $startdate && $weight == 0) {
					//Inactive
					$status = 4;
				} else if ($currentdate == $startdate && $weight > 0) {
					//active
					$status = 0;
				} else if ($currentdate < $startdate && $weight > 0) {
					//Awaiting
					$status = 2;
				} else if ($currentdate < $startdate && $weight == 0) {
					//InActive
					$status = 2;
				} else if ($currentdate > $startdate && $weight == 0) {
					//InActive
					$status = 4;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate > $enddate) {
				//Completed
				$status = 3;
			} else if ($currentdate < $startdate && $currentdate < $enddate) {
				if ($weight == 0) {
					//Inactive
					$status = 2;
				} else if ($weight > 0) {
					//Awaiting 
					$status = 2;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate == $startdate || $currentdate == $enddate) {
				if ($weight == 0) {
					//inactive
					$status = 4;
				} else if ($weight > 0) {
					//active 
					$status = 0;
				}
			} else {
				$status = (isset ($input['status'])) ? $input['status'] : $clients['0']['status'];
			}

			//contract
			if ($startdate && $enddatenull == '') {
				if ($priority > 0 && $views == -1 && $targetimp == 1) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						//active 
						$status = 0;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 0;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				}
			} else {
				if ($priority > 0 && $views == -1 && $targetimp == 0) {
					//Inactive
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed

						$status = 3;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					//active
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					//Inactive
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 1) {
					//active
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 1) {
					//Inactive
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				}
			}
			//validate for reqiured information  || empty($booked_impression)

			if (empty ($campaignname) || empty ($revenuetype) || empty ($revenue)) {
				$results = array ('response' => 'error', 'msg' => 'Please enter all data');
				return $this->response->withJson($response);
			}

			if ($startdate && $enddatenull != '') {
				if ($enddate < $startdate) {
					$response = array ('response' => 'error', 'msg' => 'The selected dates for this campaign are invalid(Campaign ends before it starts)');
					return $this->response->withJson($response);
				}
			}

			//contract campaign must have targetimpression/click/conversion
			if ($priority != -1 && $priority != 0) {
				if ($targetclk == '' && $targetimp == '' && $targetconv == '') {
					$results = array ('response' => 'error', 'msg' => 'Requested campaign need targetimpression or click or conversion value');
					return $this->response->withJson($response);
				}
			}

			if ($priority == -1 || $priority == 0) {

				$addcampaign = "INSERT INTO " . $table_prefix . "campaigns(
					`campaignname`,
					`views`,		
					`clicks`,		
					`conversions`,	
					`clientid`,		
					`priority`,
					`weight`,
					`target_impression`,
					`target_click`,
					`target_conversion`,
					`anonymous`,
					`companion`,
					`comments`,
					`revenue`,
					`revenue_type`,	
					`updated`,
					`block`,
					`capping`,
					`session_capping`,
					`show_capped_no_cookie`,
					`status`,
					`activate_time`,
					`expire_time`
					) 
					VALUES(
					'" . $campaignname . "',
					" . $views . ",		
					" . $clicks . " ,		
					" . $conversions . ",
					" . $clientid . ",
					" . $priority . ",		
					" . $weight . ",
					0,
					0,
					0,
					'" . $anonymous . "',
					" . $companion . ",
					'" . $comments . "',
					" . $revenue . ",
					" . $revenuetype . ",
					now(),
					" . $block . ",
					" . $capping . ",
					" . $session_capping . ",
					" . $show_capped_no_cookie . ",
					" . $status . ",
					'" . $start_date . "',
					'" . $end_date . "')";

				$djax_query_campaigns = $this->db->prepare($addcampaign);

				//print_r($djax_query_campaigns);

				$djax_query_campaigns->execute();

				$campaignid = $this->db->lastInsertId();
			} else {

				$addcampaign = "INSERT INTO " . $table_prefix . "campaigns(
					`campaignname`,
					`views`,		
					`clicks`,		
					`conversions`,	
					`clientid`,		
					`priority`,
					`weight`,
					`target_impression`,
					`target_click`,
					`target_conversion`,
					`anonymous`,
					`companion`,
					`comments`,
					`revenue`,
					`revenue_type`,	
					`updated`,
					`block`,
					`capping`,
					`session_capping`,
					`show_capped_no_cookie`,
					`status`,
					`activate_time`,
					`expire_time`
					) 
					VALUES(
					'" . $campaignname . "',
					" . $views . ",		
					" . $clicks . " ,		
					" . $conversions . ",
					" . $clientid . ",
					" . $priority . ",		
					1,
					" . $targetimp . ",
					" . $targetclk . ",
					" . $targetconv . ",	
					'" . $anonymous . "',
					" . $companion . ",
					'" . $comments . "',
					" . $revenue . ",
					" . $revenuetype . ",
					now(),
					" . $block . ",
					" . $capping . ",
					" . $session_capping . ",
					" . $show_capped_no_cookie . ",
					" . $status . ",
					'" . $start_date . "',
					'" . $end_date . "')";

				$djax_query_campaigns = $this->db->prepare($addcampaign);

				$djax_query_campaigns->execute();

				$campaignid = $this->db->lastInsertId();
			}
			if ($campaignid) {
				$linkcamp = "select * from " . $table_prefix . "trackers where clientid=:clientid and linkcampaigns='t'";
				$std = $this->db->prepare($linkcamp);
				$std->bindParam("clientid", $clientid);
				$std->execute();
				$camp = $std->fetchAll();
				foreach ($camp as $trackers) {
					$trackerid = $trackers['trackerid'];
					$status = $trackers['status'];

					$addcampaignstrackers = "INSERT INTO " . $table_prefix . "campaigns_trackers (`campaignid`, `trackerid`, `status`) VALUES (:campaignid,:trackerid,:status);";

					$campaigntrackers = $this->db->prepare($addcampaignstrackers);
					$campaigntrackers->bindParam(":campaignid", $campaignid);
					$campaigntrackers->bindParam(":trackerid", $trackerid);
					$campaigntrackers->bindParam(":status", $status);
					$campaigntrackers->execute();
				}
			}
			if ($campaignid) {
				if ((strpos($end_date, '1970') !== false) || ($end_date == 'NULL') || ($end_date == '-')) {
					$expdate = "Update " . $table_prefix . "campaigns set expire_time=NULL where campaignid='" . $campaignid . "'";
					$expdate = $this->db->prepare($expdate);
					$expdate->execute();
				}
				
				//audit log maintain
				$create_user_id = $_SESSION['user_id'];
				$module = 'campaigns_'.$campaignname.'_'.$campaignid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":create_user_id", $create_user_id);
				$audit->bindParam(":created_date", $datetime);
				$audit->execute();

				$response = array ('campaign_id' => $campaignid, 'response' => 'success', 'statuscode' => '200', 'msg' => 'campaign has been added successfully!');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Clientid doesnt exists, Please enter valid clientid!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('campaign_validate'));


/*
 * Campaign EDIT
 * 
 * Input Parameters:
 * --------------- 
 * campaignname [mandatory]
 * clientid [mandatory]
 * views
 * clicks
 * conversions
 * weight
 * anonymous
 * companion 
 * revenue
 * revenue_type [mandatory]
 * priority [mandatory]
 * status
 * start_date [mandatory]
 * end_date  [mandatory]
 * mode
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */
$app->post('/campaign_edit/[{campaign_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$campaignid = $args['campaign_id'];

		$stc = "SELECT * FROM " . $table_prefix . "campaigns where campaignid=:campaignid";
		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid", $campaignid);
		$std->execute();
		$campaign_det = $std->fetchAll();
		$datetime = date('Y-m-d H:i:s');
		$currentdate = date('Y-m-d');
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}
		if (isset ($input['campaignname'])) {
			$campaignname = $input['campaignname'];
			if (empty ($campaignname)) {
				$results = json_encode(array ('ERROR' => 'Please Enter Campaignname'));
				return $results;
			}
		} else {
			$campaignname = $campaign_det['0']['campaignname'];
		}

		/* if (isset($input['booked_impression'])) {
									$booked_impression = $input['booked_impression'];
									if (empty($booked_impression)) {
										$results = json_encode(array('ERROR' => 'Please Enter Booked Impression'));
										return $results;
									}
								} else {
									$booked_impression = $campaign_det['0']['booked_impression'];
								} */

		if (isset ($input['revenue'])) {
			$revenue = $input['revenue'];
			if (empty ($revenue)) {
				$results = json_encode(array ('ERROR' => 'Please Enter rate'));
				return $results;
			}
		} else {
			$revenue = $campaign_det['0']['revenue'];
		}
		if (isset ($input['start_date'])) {
			$start_date = $input['start_date'];
			if (empty ($start_date)) {
				$results = json_encode(array ('ERROR' => 'Please Choose Start Date'));
				return $results;
			}
		} else {
			$start_date = $campaign_det['0']['activate_time'];
			;
		}
		// echo "<pre>";print_r($campaign_det);exit;
		if ($campaign_det) {

			$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "campaigns as c,
            " . $table_prefix . "agency as ag
			where
			c.clientid = cl.clientid
			AND cl.agencyid = ag.agencyid
            AND ag.account_id = a.account_id
			AND a.preference_id = 16
			AND c.campaignid =" . $campaignid;
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			if ($TimeZoneRow) {
				$timezone = $TimeZoneRow[0]['timezone'];
			} else {
				$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
				$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
				$TimeZonestd->execute();
				$TimeZoneRow = $TimeZonestd->fetchAll();
				$timezone = $TimeZoneRow[0]['timezone'];
			}
			date_default_timezone_set($timezone);
			$date1 = date("d-m-Y H:i:s");
			date_default_timezone_set('UTC');
			$date2 = date("d-m-Y H:i:s");
			$time_diff = strtotime($date1) - strtotime($date2);

			$campaignname = (isset ($input['campaignname'])) ? $input['campaignname'] : $campaign_det['0']['campaignname'];
			$views = (isset ($input['views'])) ? $input['views'] : $campaign_det['0']['views'];
			$clicks = (isset ($input['clicks'])) ? $input['clicks'] : $campaign_det['0']['clicks'];
			$conversions = (isset ($input['conversions'])) ? $input['conversions'] : $campaign_det['0']['conversions'];
			$priority = (isset ($input['priority'])) ? $input['priority'] : $campaign_det['0']['priority'];
			$weight = (isset ($input['weight'])) ? $input['weight'] : $campaign_det['0']['weight'];
			if ($weight > 127) {
				$weight = "127";
			}
			$companion = (isset ($input['companion'])) ? $input['companion'] : $campaign_det['0']['companion'];
			$targetimp = (isset ($input['target_impression'])) ? $input['target_impression'] : '0';
			$targetclk = (isset ($input['target_click'])) ? $input['target_click'] : '0';
			$targetconv = (isset ($input['target_conversion'])) ? $input['target_conversion'] : '0';
			$comments = (isset ($input['comments'])) ? $input['comments'] : $campaign_det['0']['comments'];
			$revenue = (isset ($input['revenue'])) ? $input['revenue'] : $campaign_det['0']['revenue'];
			$revenuetype = (isset ($input['revenue_type'])) ? $input['revenue_type'] : $campaign_det['0']['revenue_type'];
			$block = (isset ($input['block'])) ? $input['block'] : $campaign_det['0']['block'];
			$capping = (isset ($input['capping'])) ? $input['capping'] : $campaign_det['0']['capping'];
			$session_capping = (isset ($input['session_capping'])) ? $input['session_capping'] : $campaign_det['0']['session_capping'];
			$show_capped_no_cookie = (isset ($input['show_capped_no_cookie'])) ? $input['show_capped_no_cookie'] : $campaign_det['0']['show_capped_no_cookie'];
			$anonymous = (isset ($input['anonymous'])) ? $input['anonymous'] : $campaign_det['0']['anonymous'];
			$start_date = (isset ($input['start_date'])) ? $input['start_date'] : $campaign_det['0']['activate_time'];
			$end_date = (isset ($input['end_date'])) ? $input['end_date'] : $campaign_det['0']['expire_time'];
			$end_date1 = $end_date;
			$start_date = date('Y-m-d H:i:s', strtotime($start_date));
			$end_date = date('Y-m-d H:i:s', strtotime($end_date));

			$startdate = date('Y-m-d', strtotime($start_date));
			$enddate = date('Y-m-d', strtotime($end_date));
			$enddatenull = $input['end_date'];

			$start_date = strtotime($start_date) - $time_diff;
			$start_date = date("Y-m-d H:i:s", $start_date);

			if ($end_date1 != 'NULL' && $end_date1 != '') {
				$end_date = strtotime($end_date) - $time_diff;
				$end_date = date("Y-m-d H:i:s", $end_date);
			}

			$booked_impression = $input['booked_impression'];
			$category = $input['category'];
			//  $category = implode(",", $category1);

			if ($startdate && $enddatenull != '') {
				if ($enddate < $startdate) {
					$response = array ('response' => 'error', 'msg' => 'The selected dates for this campaign are invalid(Campaign ends before it starts)');
					return $this->response->withJson($response);
				}
			}

			//Status Add All Scenarios 
			if ($startdate && $enddatenull == '') {
				//Start Date And Dont' Expire Scenarios
				if ($currentdate == $startdate && $weight == 0) {
					//Inactive
					$status = 4;
				} else if ($currentdate == $startdate && $weight > 0) {
					//active
					$status = 0;
				} else if ($currentdate < $startdate && $weight > 0) {
					//Awaiting
					$status = 2;
				} else if ($currentdate < $startdate && $weight == 0) {
					//InActive
					$status = 2;
				} else if ($currentdate > $startdate && $weight == 0) {
					//awaiting
					$status = 4;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate > $enddate) {
				//Completed
				$status = 3;
			} else if ($currentdate < $startdate && $currentdate < $enddate) {
				if ($weight == 0) {
					//awaiting
					$status = 2;
				} else if ($weight > 0) {
					//Awaiting 
					$status = 2;
				} else {
					//Active
					$status = 0;
				}
			} else if ($currentdate == $startdate || $currentdate == $enddate) {
				if ($weight == 0) {
					//inactive
					$status = 4;
				} else if ($weight > 0) {
					//active 
					$status = 0;
				}
			} else {
				$status = (isset ($input['status'])) ? $input['status'] : $campaign_det['0']['status'];
			}

			//contract
			if ($startdate && $enddatenull == '') {
				if ($priority > 0 && $views == -1 && $targetimp == 1) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						//active 
						$status = 0;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 0;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else {
						$status = 4;
					}
				}
			} else {
				if ($priority > 0 && $views == -1 && $targetimp == 0) {
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 1 && $targetimp == 0) {
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 0) {
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == -1 && $targetimp == 1) {
					$status = 0;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				} else if ($priority > 0 && $views == 0 && $targetimp == 1) {
					$status = 4;
					if ($currentdate < $startdate) {
						//Awaiting 
						$status = 2;
					} else if ($currentdate > $enddate) {
						//Completed
						$status = 3;
					}
				}
			}

			if ($priority == -1 || $priority == 0) {
				$edit_cmp = "UPDATE  " . $table_prefix . "campaigns set 
					`campaignname`='" . $campaignname . "',
					`views`=" . $views . ",		
					`clicks`=" . $clicks . ",		
					`conversions`=" . $conversions . ",		
					`priority`=" . $priority . ",
					`weight`=" . $weight . ",
					`target_impression`=0,
					`target_click`=0,
					`target_conversion`=0,
					`anonymous`='" . $anonymous . "',
					`companion`=" . $companion . ",
					`comments`='" . $comments . "',
					`revenue`='" . $revenue . "',
					`revenue_type`=" . $revenuetype . ",	
					`updated`='" . $datetime . "',
					`block`=" . $block . ",
					`capping`=" . $capping . ",
					`session_capping`=" . $session_capping . ",
					`show_capped_no_cookie`=" . $show_capped_no_cookie . ",
					`status`=" . $status . ",
					`activate_time`='" . $start_date . "',
					`expire_time`='" . $end_date . "'
					where campaignid=" . $campaignid;
			} else {
				$edit_cmp = "UPDATE  " . $table_prefix . "campaigns set 
					`campaignname`='" . $campaignname . "',
					`views`=" . $views . ",		
					`clicks`=" . $clicks . ",		
					`conversions`=" . $conversions . ",		
					`priority`=" . $priority . ",
					`weight`=1,
					`target_impression`=" . $targetimp . ",
					`target_click`=" . $targetclk . ",
					`target_conversion`=" . $targetconv . ",
					`anonymous`='" . $anonymous . "',
					`companion`=" . $companion . ",
					`comments`='" . $comments . "',
					`revenue`='" . $revenue . "',
					`revenue_type`=" . $revenuetype . ",	
					`updated`='" . $datetime . "',
					`block`=" . $block . ",
					`capping`=" . $capping . ",
					`session_capping`=" . $session_capping . ",
					`show_capped_no_cookie`=" . $show_capped_no_cookie . ",
					`status`=" . $status . ",
					`activate_time`='" . $start_date . "',
					`expire_time`='" . $end_date . "'
					where campaignid=" . $campaignid;
			}
			// echo "<pre>";print_r($edit_cmp);exit;
			$cmp = $this->db->prepare($edit_cmp);
			$campaignid = $cmp->execute();

			if ($campaignid) {

				if ((strpos($end_date, '1970') !== false) || ($end_date == 'NULL') || ($end_date == '-')) {

					$expdate = "Update " . $table_prefix . "campaigns set expire_time=NULL where campaignid='" . $args['campaign_id'] . "'";
					$expdate = $this->db->prepare($expdate);
					$expdate->execute();
				}
				
				//audit log maintain
				$update_user_id = $_SESSION['user_id'];
				$module = 'campaigns_'.$campaignname.'_'.$args['campaign_id'];
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `update_user_id`,  `updated_date`) VALUES (:module,:update_user_id,:updated_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":update_user_id", $update_user_id);
				$audit->bindParam(":updated_date", $datetime);
				$audit->execute();

				$response = array ('response' => 'success', 'statuscode' => '200', 'msg' => 'campaign has been edited successfully!');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Campaignid doesnt exists, Please enter valid Campaignid!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('campaignid_val1'));

/*
 * Campaign Activate And Deactivate 
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->post('/campaign_status_update/[{campaignid}]', function ($request, $response, $args) {

	$results = array ();

	$input = $request->getParsedBody();
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$campaignid = $args['campaignid'];
	$refercampaign = "select * from " . $table_prefix . "campaigns where campaignid=:campaignid";
	$djax_query_refercampaign = $this->db->prepare($refercampaign);
	$djax_query_refercampaign->bindParam(":campaignid", $campaignid);
	$djax_query_refercampaign->execute();

	$stmtcampaign = $djax_query_refercampaign->fetchAll();

	if (count($stmtcampaign) > 0) {
		$campaign_status = $stmtcampaign[0]['status'];

		if ($campaign_status == 4) {
			$update_status = "update {$table_prefix}campaigns set  `status`= 0 WHERE campaignid=:campaignid";
			$djax_query_update_status = $this->db->prepare($update_status);
			$djax_query_update_status->bindParam(":campaignid", $campaignid);
			$update_campaignstatus = $djax_query_update_status->execute();

			if ($update_campaignstatus) {
				$response = array (
					'response' => 'success',
					'statuscode' => '200',
					'msg' => 'Campaign Activated successfully!'
				);

				return $this->response->withJson($response);
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'Campaign not Activated!'
				);

				return $this->response->withJson($response);
			}
		} else if ($campaign_status == 0) {
			$update_status = "update {$table_prefix}campaigns set  `status`= 4 WHERE campaignid=:campaignid";
			$djax_query_update_status = $this->db->prepare($update_status);
			$djax_query_update_status->bindParam(":campaignid", $campaignid);
			$update_campaignstatus = $djax_query_update_status->execute();

			if ($update_campaignstatus) {
				$response = array (
					'response' => 'success',
					'statuscode' => '200',
					'msg' => 'Campaign Deactivated successfully!'
				);

				return $this->response->withJson($response);
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'Campaign not Deactivated!'
				);

				return $this->response->withJson($response);
			}
		}
	} else {
		$response = array (
			'response' => 'error',
			'msg' => 'Campaignid provided is invalid'
		);

		return $this->response->withJson($response);
	}
})->add($container->get('campaignlimitValidation'));


/*
 * Campaign DELETE
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->delete('/campaign_delete/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$campaignid = $args['campaign_id'];

		$stc = "SELECT * FROM " . $table_prefix . "campaigns where campaignid in (:campaignid)";

		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid", $campaignid);
		$std->execute();
		$campaign_det = $std->fetchAll();
		$datetime = date('Y-m-d H:i:s');


		if ($campaign_det) {
			foreach ($campaign_det as $key => $campaign) {
				if ($key > 0) {
					$campaignid .= $campaign['campaignid'];
				}
			}

			$stc1 = "SELECT * FROM " . $table_prefix . "banners where campaignid in ($campaignid)";

			$std1 = $this->db->prepare($stc1);
			$std1->execute();
			$banner_det = $std1->fetchAll();

			if ($banner_det) {

				foreach ($banner_det as $banner) {

					$bannerid1 .= $banner['bannerid'] . ',';
				}
				$bannerid = rtrim($bannerid1, ',');

				$del_ad = "DELETE FROM " . $table_prefix . "ad_zone_assoc   WHERE ad_id in ($bannerid)";
				$ad = $this->db->prepare($del_ad);
				$ad_assoc = $ad->execute();

				$del_adhourly = "DELETE FROM " . $table_prefix . "data_summary_ad_hourly WHERE ad_id in($bannerid)";
				$del_ad_hourly = $this->db->prepare($del_adhourly);
				$del_ad_hourly->execute();

			}


			$del_place = "DELETE FROM " . $table_prefix . "placement_zone_assoc  WHERE placement_id in ($campaignid)";
			$place1 = $this->db->prepare($del_place);
			$placement = $place1->execute();

			$del_ban = "DELETE FROM " . $table_prefix . "banners WHERE campaignid in ($campaignid)";
			$ban = $this->db->prepare($del_ban);
			//$cmp->bindParam("campaignid",$campaignid);	
			$banner = $ban->execute();

			$del_camp = "DELETE FROM " . $table_prefix . "campaigns WHERE campaignid in ($campaignid)";
			$cmp = $this->db->prepare($del_camp);
			//$cmp->bindParam("campaignid",$campaignid);	
			$success = $cmp->execute();

			if ($success) {
			
			    $campaignname = $campaign_det[0]['campaignname'];
				$datetime = date('Y-m-d H:i:s');
				//audit log maintain
				$delete_user_id = $_SESSION['user_id'];
				$module = 'campaigns_'.$campaignname.'_'.$campaignid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `delete_user_id`,  `deleted_date`) VALUES (:module,:delete_user_id,:deleted_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":delete_user_id", $delete_user_id);
				$audit->bindParam(":deleted_date", $datetime);
				$audit->execute();
			
				$response = array ('response' => 'success', 'statuscode' => '200', 'msg' => 'Campaign has been deleted successfully!');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Campaign doesnt exists, Please enter valid campaignid!');
			return $this->response->withJson($response);
		}
	}
});


/*
 * Campaign Details
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->get('/get_campaign/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$campaignid = $args['campaign_id'];

		//$stc = "SELECT * FROM " . $table_prefix . "campaigns where campaignid=:campaignid"; GROUP BY campaignid
		$stc="SELECT c.*,b.bannerid as bannerid,sum(h.impressions) as imp_remaining,sum(h.clicks) as clicks_remaining,sum(h.conversions) as con_remaining 
		FROM 
		" . $table_prefix . "data_summary_ad_hourly as h,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "banners as b 
		WHERE h.ad_id=b.bannerid AND b.campaignid=c.campaignid AND c.campaignid=:campaignid";

		$std = $this->db->prepare($stc);
		$std->bindParam("campaignid", $campaignid);
		$std->execute();
		$campaign_det = $std->fetchAll();
		$datetime = date('Y-m-d H:i:s');
		$campaigndetail = array ();

		if (count($campaign_det) > 0) {
			$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "campaigns as c,
            " . $table_prefix . "agency as ag
			where
			c.clientid = cl.clientid
			AND cl.agencyid = ag.agencyid
            AND ag.account_id = a.account_id
			AND a.preference_id = 16
			AND c.campaignid =" . $campaignid;
			$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
			$TimeZonestd->execute();
			$TimeZoneRow = $TimeZonestd->fetchAll();
			if ($TimeZoneRow) {
				$timezone = $TimeZoneRow[0]['timezone'];
			} else {
				$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
				$TimeZonestd = $this->db->prepare($TimeZone) or die ("error TimeZone");
				$TimeZonestd->execute();
				$TimeZoneRow = $TimeZonestd->fetchAll();
				$timezone = $TimeZoneRow[0]['timezone'];
			}
			date_default_timezone_set($timezone);
			$date1 = date("d-m-Y H:i:s");
			date_default_timezone_set('UTC');
			$date2 = date("d-m-Y H:i:s");
			$time_diff = strtotime($date1) - strtotime($date2);
			$start_date = $campaign_det[0]['activate_time'];
			$end_date = $campaign_det[0]['expire_time'];

			$start_date = strtotime($start_date) + $time_diff;
			$start_date = date("Y-m-d H:i:s", $start_date);
			if ($end_date != '') {
				$end_date = strtotime($end_date) + $time_diff;
				$end_date = date("Y-m-d H:i:s", $end_date);
			}


			$campaigndetail = array (
				'campaignid' => $campaignid,
				'campaignid' => $campaign_det[0]['campaignid'],
				'campaignname' => $campaign_det[0]['campaignname'],
				'clientid' => $campaign_det[0]['clientid'],
				'views' => $campaign_det[0]['views'],
				'clicks' => $campaign_det[0]['clicks'],
				'conversions' => $campaign_det[0]['conversions'],
				'priority' => $campaign_det[0]['priority'],
				'weight' => $campaign_det[0]['weight'],
				'target_impression' => $campaign_det[0]['target_impression'],
				'target_click' => $campaign_det[0]['target_click'],
				'target_conversion' => $campaign_det[0]['target_conversion'],
				'anonymous' => $campaign_det[0]['anonymous'],
				'companion' => $campaign_det[0]['companion'],
				'comments' => $campaign_det[0]['comments'],
				'revenue' => $campaign_det[0]['revenue'],
				'revenue_type' => $campaign_det[0]['revenue_type'],
				'block' => $campaign_det[0]['block'],
				'capping' => $campaign_det[0]['capping'],
				'session_capping' => $campaign_det[0]['session_capping'],
				'show_capped_no_cookie' => $campaign_det[0]['show_capped_no_cookie'],
				'updated' => $campaign_det[0]['updated'],
				'status' => $campaign_det[0]['status'],
				'start_date' => $start_date,
				'end_date' => $end_date,
				'category' => $campaign_det[0]['category'],
				'remaining_impression' => $campaign_det[0]['imp_remaining'],
				'remaining_clicks' => $campaign_det[0]['clicks_remaining'],
				'remaining_conversion' => $campaign_det[0]['con_remaining']
			);

			if ($campaigndetail) {
				$response = array ('data' => $campaigndetail, 'response' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}


			return $this->response->withJson($campaigndetail);
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Campaign Id!'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('campaignid_val'));


/*
 * GET ALL CAMPAIGNS
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Advertiser ID
 */
$app->get('/get_all_active_campaigns/[{client_id},{camplist_option}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$clientid = $args['client_id'];
		$camplistoption = $args['camplist_option'];
		//print_r($camplistoption);exit("ok");

		$clients = "SELECT * FROM " . $table_prefix . "clients where clientid =:clientid";
		$stc = $this->db->prepare($clients);
		$stc->bindParam("clientid", $clientid);
		$stc->execute();
		$client_det = $stc->fetchAll();
		if ($client_det) {

			
			$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
			" . $table_prefix . "clients as cl,
			" . $table_prefix . "campaigns as c,
            " . $table_prefix . "agency as ag
			where
			c.clientid = cl.clientid
			AND cl.agencyid = ag.agencyid
            AND ag.account_id = a.account_id
			AND a.preference_id = 16
			AND cl.clientid =" . $clientid;
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();

			$TimeZoneRow = $TimeZonestd->fetchAll();

			if ($TimeZoneRow) {

				$timezone = $TimeZoneRow[0]['timezone'];
			} else {

				$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
				$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
				$TimeZonestd->execute();
				$TimeZoneRow = $TimeZonestd->fetchAll();
				if($TimeZoneRow){
					$timezone = $TimeZoneRow[0]['timezone'];
					}
					else{
						$timezone = 'UTC';
	
					}
			}
			if($timezone=='0'){
				$timezone = 'UTC';

			}
			else{
				$timezone = $timezone;

			}
			//print_r($timezone); exit;
			date_default_timezone_set($timezone);

			// $date1 = date("d-m-Y H:i:s");
			// date_default_timezone_set('UTC');
			// $date2 = date("d-m-Y H:i:s");
			// $time_diff = strtotime($date1) - strtotime($date2);
			// $date3 = date('H:i', $time_diff);

			// $date4 = '+'.$date3;


			$tz = new DateTimeZone($timezone);
			$offset = $tz->getOffset(new DateTime());

			// Convert offset to hours and minutes
			$offsetHours = floor($offset / 3600);
			$offsetMinutes = floor(($offset % 3600) / 60);

			// Determine the GMT offset string
			$gmtOffset = sprintf('%+03d:%02d', $offsetHours, $offsetMinutes);
			if ($camplistoption == 0) {
				$stc = "SELECT cam.campaignid,cam.campaignname,cam.clientid,cli.clientname,cam.views,cam.clicks,cam.conversions,cam.priority,cam.weight,cam.anonymous,cam.companion,cam.revenue,cam.revenue_type,DATE_FORMAT(CONVERT_TZ(cam.updated,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as updated,cam.status,cam.activate_time,cam.expire_time FROM " . $table_prefix . "campaigns as cam INNER JOIN " . $table_prefix . "clients as cli ON cam.clientid=cli.clientid WHERE cam.clientid=:clientid and status=0 and priority=0 Order by cam.updated Desc";
			} else {
				$stc = "SELECT cam.campaignid,cam.campaignname,cam.clientid,cli.clientname,cam.views,cam.clicks,cam.conversions,cam.priority,cam.weight,cam.anonymous,cam.companion,cam.revenue,cam.revenue_type,DATE_FORMAT(CONVERT_TZ(cam.updated,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as updated,cam.status,cam.activate_time,cam.expire_time FROM " . $table_prefix . "campaigns as cam INNER JOIN " . $table_prefix . "clients as cli ON cam.clientid=cli.clientid WHERE cam.clientid=:clientid and priority=0 Order by cam.updated Desc";
			}
			$std = $this->db->prepare($stc);
			$std->bindParam("clientid", $clientid);
			$std->execute();
			$campaign_det = $std->fetchAll();
			$datetime = date('Y-m-d H:i:s');

			if (count($campaign_det) > 0) {
				if ($campaign_det) {
					$response = array ('data' => $campaign_det, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Data', 'statuscode' => '200');
					return $this->response->withJson($response);
				}
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'No campaigns available for this clientid!',
					'statuscode' => '200'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Client Id!'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('clientid_val'));

$app->get('/get_all_campaigns/[{client_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$clientid = $args['client_id'];

		$clients = "SELECT * FROM " . $table_prefix . "clients where clientid =:clientid";
		$stc = $this->db->prepare($clients);
		$stc->bindParam("clientid", $clientid);
		$stc->execute();
		$client_det = $stc->fetchAll();
		if ($client_det) {
			$stc = "SELECT campaignid,campaignname,clientid,views,clicks,conversions,priority,weight,anonymous,companion,revenue,revenue_type,DATE_FORMAT(updated,'%d-%m-%Y %h:%i:%s') as updated,status,activate_time,expire_time FROM " . $table_prefix . "campaigns where clientid=:clientid";
			$std = $this->db->prepare($stc);
			$std->bindParam("clientid", $clientid);
			$std->execute();
			$campaign_det = $std->fetchAll();
			$datetime = date('Y-m-d H:i:s');

			if (count($campaign_det) > 0) {
				if ($campaign_det) {
					$response = array ('data' => $campaign_det, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Data');
					return $this->response->withJson($response);
				}
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'No campaigns available for this clientid!'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Client Id!',
				'statuscode' => '200'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('clientid_val'));


//get zone not linked by campaign

$app->get('/get_zonenotlinkedby_campaign/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$treezone = array ();

		$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
		$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
		$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
		$djax_query_campaignvalue->execute();
		$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();
		$num = count($stmtcampaignvalue);

		$clientid = $stmtcampaignvalue[0]['clientid'];
		$publishervalue = "select afl.name,afl.affiliateid from {$table_prefix}affiliates afl ,{$table_prefix}clients cle where afl.agencyid=cle.agencyid  and cle.clientid=$clientid";
		$djax_query_publishervalue = $this->db->prepare($publishervalue);
		$djax_query_publishervalue->execute();
		$stmtpublishervalue = $djax_query_publishervalue->fetchAll();
		$countpubval = count($stmtpublishervalue);

		foreach ($stmtpublishervalue as $pubval) {
			$publishername = $pubval['name'];
			$publisherid = $pubval['affiliateid'];
			$zonevalue = "select * from {$table_prefix}zones zon where zon.affiliateid=$publisherid";
			$djax_query_zonevalue = $this->db->prepare($zonevalue);
			$djax_query_zonevalue->execute();
			$stmtzonevalue = $djax_query_zonevalue->fetchAll();
			$countzonval = count($stmtzonevalue);

			if ($countzonval > 0) {

				foreach ($stmtzonevalue as $zones) {
					$zoneid = $zones['zoneid'];
					$zonename = $zones['zonename'];
					$placementValue1 = "select * from {$table_prefix}placement_zone_assoc where zone_id=:zoneid and placement_id=:placement_id";
					$djax_query_placevalue1 = $this->db->prepare($placementValue1);
					$djax_query_placevalue1->bindParam(":zoneid", $zoneid);
					$djax_query_placevalue1->bindParam(":placement_id", $campaignid);
					$djax_query_placevalue1->execute();
					$stmtplacevalue1 = $djax_query_placevalue1->fetchAll();
					//print_r($stmtplacevalue);
					$placementcount1 = count($stmtplacevalue1);
					if ($placementcount1 == 0) {
						$treezone[] = array (
							'zoneid' => $zoneid,
							'zonename' => $zonename,
							'zonecount' => $placementcount1
						);
					}
				}
				//print_r($treezone);exit("oj");
				if ($treezone != []) {
					$todos[] = [
						'publishername' => $publishername,
						'publisherid' => $publisherid,
						'zones' => $treezone
					];
				}
				$treezone1 = [];
				$treezone = [];
			}
		}
		$response = array ('data' => $todos, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
	}
	return $this->response->withJson($response);
});


//get zone linked by campaign

$app->get('/get_zonelinkedby_campaign/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$treezone = array ();

		$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
		$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
		$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
		$djax_query_campaignvalue->execute();
		$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();
		$num = count($stmtcampaignvalue);

		$clientid = $stmtcampaignvalue[0]['clientid'];
		$publishervalue = "select afl.name,afl.affiliateid from {$table_prefix}affiliates afl ,{$table_prefix}clients cle where afl.agencyid=cle.agencyid  and cle.clientid=$clientid";
		$djax_query_publishervalue = $this->db->prepare($publishervalue);
		$djax_query_publishervalue->execute();
		$stmtpublishervalue = $djax_query_publishervalue->fetchAll();
		$countpubval = count($stmtpublishervalue);


		foreach ($stmtpublishervalue as $pubval) {
			$publishername = $pubval['name'];
			$publisherid = $pubval['affiliateid'];
			$zonevalue = "select * from {$table_prefix}zones zon where zon.affiliateid=$publisherid";
			$djax_query_zonevalue = $this->db->prepare($zonevalue);
			$djax_query_zonevalue->execute();
			$stmtzonevalue = $djax_query_zonevalue->fetchAll();
			$countzonval = count($stmtzonevalue);

			if ($countzonval > 0) {

				foreach ($stmtzonevalue as $zones) {
					$zoneid = $zones['zoneid'];
					$zonename = $zones['zonename'];
					$ban_id = $zones['banid'];
					$placementValue = "select * from {$table_prefix}placement_zone_assoc where zone_id=:zoneid and placement_id=:placement_id";
					$djax_query_placevalue = $this->db->prepare($placementValue);
					$djax_query_placevalue->bindParam(":zoneid", $zoneid);
					$djax_query_placevalue->bindParam(":placement_id", $campaignid);
					$djax_query_placevalue->execute();
					$stmtplacevalue = $djax_query_placevalue->fetchAll();
					$placementcount = count($stmtplacevalue);
					if ($placementcount > 0) {
						$treezone[] = array (
							'zoneid' => $zoneid,
							'zonename' => $zonename,
							'zonecount' => $placementcount
						);
					}
				}
				if ($treezone != []) {
					$todos[] = [
						'publishername' => $publishername,
						'publisherid' => $publisherid,
						'zones' => $treezone
					];
				}
				$treezone1 = [];
				$treezone = [];
			}
		}
		$response = array ('data' => $todos, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
	}
	return $this->response->withJson($response);
});

//Campaign Tracker Update

$app->post('/tracker_update/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {


		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['trackerid'];
		$getid = explode(',', $id);
		$status = $input['status'];
		$getstatus = explode(',', $status);
		$view = $input['view'];
		$click = $input['click'];

		$getzone = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
		$zonedata = $this->db->prepare($getzone);
		$zonedata->bindParam(":campaignid", $campaignid);
		$zonedata->execute();
		$stmt = $zonedata->fetchAll();

		if (count($stmt) > 0) {
			$executionid = "Delete from " . $table_prefix . "campaigns_trackers where campaignid=$campaignid";
			$bnr = $this->db->prepare($executionid);
			$bnr->execute();

			if ($id) {
				$i = 0;
				foreach ($getid as $trackerid) {
					$status = $getstatus[$i];

					$addcampaignstrackers = "INSERT INTO " . $table_prefix . "campaigns_trackers (`campaignid`, `trackerid`, `status`) VALUES (:campaignid,:trackerid,:status);";

					$campaigntrackers = $this->db->prepare($addcampaignstrackers);
					$campaigntrackers->bindParam(":campaignid", $campaignid);
					$campaigntrackers->bindParam(":trackerid", $trackerid);
					$campaigntrackers->bindParam(":status", $status);
					$campaigntrackers->execute();

					$i++;
				}



			}
			$updatebanners = "update  {$table_prefix}campaigns set viewwindow=:view,clickwindow=:click where campaignid=:campaignid";

			$banner_data = $this->db->prepare($updatebanners);
			$banner_data->bindParam(":campaignid", $campaignid);
			$banner_data->bindParam(":view", $view);
			$banner_data->bindParam(":click", $click);
			$banner_data->execute();
			$response = array ('response' => 'ok', 'msg' => 'Tracker has been updated successfully!');

			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'ok', 'msg' => 'Invalid Campaign id');
			return $this->response->withJson($response);
		}

	}
});

//Campaign view and click Update

$app->get('/get_view_clicks/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();


		$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
		$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
		$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
		$djax_query_campaignvalue->execute();

		$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

		if (count($stmtcampaignvalue) > 0) {
			$campaignvalue = array (
				'viewwindow' => $stmtcampaignvalue[0]['viewwindow'],
				'clickwindow' => $stmtcampaignvalue[0]['clickwindow']

			);
		}

		$response = array ('data' => $campaignvalue, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
	}





	return $this->response->withJson($response);
});

//Campaign trackerid Update

$app->get('/get_trackerid/[{campaignid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		//get banners
		$campaign = "select * from {$table_prefix}campaigns_trackers where campaignid=:campaignid";
		$campaign_track = $this->db->prepare($campaign);
		$campaign_track->bindParam(":campaignid", $campaignid);
		$campaign_track->execute();
		$stmtcampaign_track = $campaign_track->fetchAll();

		if (count($stmtcampaign_track) > 0) {
			$campaignvalue = "select camp.viewwindow,camp.clickwindow,trackcamp.* from {$table_prefix}campaigns as camp JOIN {$table_prefix}campaigns_trackers as trackcamp ON camp.campaignid=trackcamp.campaignid where trackcamp.campaignid=:campaignid";
			$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
			$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
			$djax_query_campaignvalue->execute();
			$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();
			if (count($stmtcampaignvalue) > 0) {
				$response = array ('data' => $stmtcampaignvalue, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			} else {
				$response = array ('response' => 'error', 'msg' => 'No data');
			}
		} else {
			$campaignvalue = "select camp.viewwindow,camp.clickwindow from {$table_prefix}campaigns as camp where camp.campaignid=:campaignid";
			$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
			$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
			$djax_query_campaignvalue->execute();
			$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();
			if (count($stmtcampaignvalue) > 0) {
				$response = array ('data' => $stmtcampaignvalue, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			} else {
				$response = array ('response' => 'error', 'msg' => 'No data');
			}
		}
	}
	return $this->response->withJson($response);
});
/*----------------  Campaign -------------*/

/*---------------- BANNER ---------------*/

$app->get('/get_trackerid_campaign/[{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		//get banners
		$campaign = "select * from {$table_prefix}campaigns_trackers where trackerid=:trackerid";
		$campaign_track = $this->db->prepare($campaign);
		$campaign_track->bindParam(":trackerid", $trackerid);
		$campaign_track->execute();
		$stmtcampaign_track = $campaign_track->fetchAll();

		if (count($stmtcampaign_track) > 0) {		
				$response = array ('data' => $stmtcampaign_track, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');		
		} else{
			$response = array ('response' => 'error', 'msg' => 'No data');
		}
	}
	return $this->response->withJson($response);
});
/*
 * BANNER ADD
 * 
 * Input Parameters:
 * ----------------
 * description [mandatory]
 * contenttype
 * storagetype [mandatory]
 * imageurl
 * width
 * height
 * weight
 * url
 * target
 * alt
 * statustext
 * bannertext
 * comments
 * updated
 * keyword
 * append
 * prepend
 * 
 * Arguments:
 * ---------
 * Campaignid
 */
$app->post('/add_banner/[{campaign_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$campaignid = $args['campaign_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		//Delivery path
		$full_url = $this->get('settings')['path']['delivery'];

		//Database connection
		$db_host = $this->get('settings')['db']['host'];
		$db_user = $this->get('settings')['db']['user'];
		$db_pass = $this->get('settings')['db']['pass'];
		$db_dbname = $this->get('settings')['db']['dbname'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https://';
		} else {
			$https = 'http://';
		}
		$imagefull_path = $https . $this->get('settings')['path']['image_path'];

		$full_url = substr($full_url, 0, -9);
		//$image_path = '../../../revivemohan/www/images/';

		include_once ('../../config.php');

		$image_path = $reviveapiPath;

		//$image_path = $imagefull_path;
		define('DIRECTORY', $image_path);
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$get_banner_id1 = "CREATE TABLE IF NOT EXISTS banner_vast_element_seq (ID int(11) NOT NULL AUTO_INCREMENT, PRIMARY KEY (ID))";
		$query_banner_vast_id1 = $this->db->prepare($get_banner_id1);
		$query_banner_vast_id1->execute();

		if ($campaignid) {

			$table_prefix = $this->get('settings')['path']['table_prefix'];
			$tot_num_impression = isset ($input['total_impressions']) ? $input['total_impressions'] : 0;
			if ($input['unlimited_impression'] == 'true') {
				$unlimit_impression = 't';
			} else {
				$unlimit_impression = 'f';
			}
			$limit_y_num_impressions = isset ($input['y_num_impression']) ? $input['y_num_impression'] : 0;
			$impr_time = isset ($input['impressions_time']) ? $input['impressions_time'] : 0;

			if (
				$input['storagetype'] == 'web' || $input['storagetype'] == 'txt' || $input['storagetype'] == 'sql' ||
				$input['storagetype'] == 'url'
			) {

				$description = $input['description'];
				$contenttype = $input['contenttype'];
				$storagetype = $input['storagetype'];
				$imageurl = isset ($input['imageurl']) ? $input['imageurl'] : '';


				if ($input['storagetype'] == 'web') {
					$img_size = get_headers($imageurl, 1);

					if ($img_size["Content-Length"] <= 4294967295) {
						if ($imageurl) {
							$valid_exts = array ("jpg", "jpeg", "gif", "png"); // default image only extensions
							$ext = explode(".", strtolower(basename($imageurl)));

							$ext = end($ext);

							$filename = basename($imageurl);
							$new = explode(".", $filename);
							$encryptfilename = md5($new[0]);
							$ac = $encryptfilename . "." . $new[1];
							$c[] = '';
							array_push($c, $ac);

							if (in_array($ext, $valid_exts)) {
								$rand = rand(10000, 99999);
								$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
								$content = file_get_contents($imageurl);
								file_put_contents(DIRECTORY . $c[1], $content);
							}
						}
					} else {
						$results = array ('response' => 'error', 'msg' => 'Image size is higher');
						return $this->response->withJson($results);
					}
				} else if ($input['storagetype'] == 'sql') {
					if ($imageurl) {
						$valid_exts = array ("jpg", "jpeg", "gif", "png"); // default image only extensions
						$ext = explode(".", strtolower(basename($imageurl)));
						$ext = end($ext);
						$filename = basename($imageurl);
						$new = explode(".", $filename);
						$encryptfilename = md5($new[0]);
						$ac = $encryptfilename . "." . $new[1];
						$c[] = '';
						//checking for existing name
						$exp_time_sql = "SELECT filename FROM " . $table_prefix . "banners WHERE storagetype='sql'";
						$exp_time_sql1 = $this->db->prepare($exp_time_sql);
						$exp_time_sql1->execute();
						$exp_time_sql1 = $exp_time_sql1->fetchAll();


						if (in_array($ext, $valid_exts)) {

							function in_array_r($filename, $exp_time_sql1)
							{
								$found = false;
								foreach ($exp_time_sql1 as $item) {
									if ($item === $filename) {
										$found = true;
										break;
									} elseif (is_array($item)) {
										$found = in_array_r($filename, $item);
										if ($found) {
											break;
										}
									}
								}
								return $found;
							}
							$con = new mysqli($db_host, $db_user, $db_pass, $db_dbname);

							// Check connection
							if ($con->connect_errno) {
								echo "Failed to connect to MySQL: " . $con->connect_error;
								exit ();
							}

							if (in_array_r($filename, $exp_time_sql1)) {

								array_push($c, $ac);
								$rand = rand(10000, 99999);
								$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
								$filename = $newfile;
								$content = file_get_contents($imageurl);
								$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
								$target_Path = DIRECTORY . $filename;
								$target_data = file_get_contents($target_Path);
								$target_data1 = mysqli_real_escape_string($con, $target_data);
							} else {
								array_push($c, $ac);
								$rand = rand(10000, 99999);
								$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
								$filename = $newfile;
								$content = file_get_contents($imageurl);
								$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
								$target_Path = DIRECTORY . $filename;
								$target_data = file_get_contents($target_Path);
								$target_data1 = mysqli_real_escape_string($con, $target_data);
							}
						}
					}


					$sql = "INSERT INTO " . $table_prefix . "images(`filename`,`contents`,t_stamp) values('" . $filename . "','" . $target_data1 . "',now())";
					$djax_query_ban = $this->db->prepare($sql);
					$djax_query_ban->execute();
				}


				$url_banner_imageurl = isset ($input['url_banner_imageurl']) ? $input['url_banner_imageurl'] : '';
				$width = isset ($input['width']) ? $input['width'] : '';
				$height = isset ($input['height']) ? $input['height'] : '';
				$weight = isset ($input['weight']) ? $input['weight'] : '1';
				$url = isset ($input['url']) ? $input['url'] : '';
				$target = isset ($input['target']) ? $input['target'] : 0;
				$keyword = isset ($input['keyword']) ? $input['keyword'] : '';
				$append = isset ($input['append']) ? $input['append'] : '';
				$prepend = isset ($input['prepend']) ? $input['prepend'] : '';
				$comments = isset ($input['comments']) ? $input['comments'] : '';
				$alt = isset ($input['alt']) ? $input['alt'] : '';
				$statustext = isset ($input['statustext']) ? $input['statustext'] : '';
				$txtimgbelow = isset ($input['txtimgbelow']) ? $input['txtimgbelow'] : '';
				$bannertext = isset ($input['bannertext']) ? $input['bannertext'] : '';
				$ext_bannertype = isset ($input['ext_bannertype']) ? $input['ext_bannertype'] : '';
				if (isset ($input['imageurl'])) {
					$imageurl = $input['imageurl'];
				} else {
					$imageurl = $stmt[0]['imageurl'];
				}

				$ext_bannertype = isset ($input['ext_bannertype']) ? $input['ext_bannertype'] : null;

				//validation	
				if ($storagetype == 'web') {

					if (empty ($width) || empty ($height) || empty ($description) || empty ($contenttype) || empty ($imageurl)) {

						$results = array ('response' => 'error', 'msg' => 'Please enter all data for web');
						return $this->response->withJson($results);
					}
				} else if ($storagetype == 'txt') {
					if (empty ($contenttype) || empty ($bannertext) || empty ($description)) {

						$results = array ('response' => 'error', 'msg' => 'Please enter all data for txt');
						return $this->response->withJson($results);
					}
				} else if ($storagetype == 'url') {
					if (empty ($contenttype) || empty ($url_banner_imageurl) || empty ($description) || empty ($width) || empty ($height)) {

						$results = array ('response' => 'error', 'msg' => 'Please enter all data for url');
						return $this->response->withJson($results);
					}
				} else if ($storagetype == 'sql') {
					if (empty ($contenttype) || empty ($imageurl) || empty ($description) || empty ($width) || empty ($height)) {
						$results = array ('response' => 'error', 'msg' => 'Please enter all data for sql');
						return $this->response->withJson($results);
					}
				}

				if ($weight > 127) {
					$weight = "127";
				}

				if ($storagetype == 'web') {

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						`campaignid`,
						`contenttype`,
						`storagetype`,
						`filename`,
						`width`,
						`height`,
						`weight`,
						`url`,
						`description`,
						`alt`,
						`statustext`,
						`bannertext`,
						`updated`
						
						) VALUES(
						:campaignid,
						:contenttype,
						:storagetype,
						:filename,
						:width,
						:height,
						$weight,
						:url,
						:description,
						:alt,
						:statustext,
						:bannertext,
						now()
						)";
				} else if ($storagetype == 'txt') {

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						`campaignid`,
						`contenttype`,
						`storagetype`,
						`weight`,
						`url`,
						`statustext`,
						`bannertext`,
						`description`,
						`ext_bannertype`,
						`updated`					
						) VALUES(
						:campaignid,
						:contenttype,
						:storagetype,
						$weight,
						:url,
						:statustext,
						:bannertext,
						:description,
						'bannerTypeText:oxText:genericText',
						now()
						)";
				} else if ($storagetype == 'url') {
					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						`campaignid`,
						`contenttype`,
						`storagetype`,
						`imageurl`,
						`width`,
						`height`,
						`weight`,
						`url`,
						`description`,
						`alt`,
						`statustext`,
						`bannertext`,
						`updated`
						) VALUES(
						:campaignid,
						:contenttype,
						:storagetype,
						:imageurl,
						:width,
						:height,
						$weight,
						:url,
						:description,
						:alt,
						:statustext,
						:bannertext,
						now()
						)";
				} else if ($storagetype == 'sql') {
					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						`campaignid`,
						`contenttype`,
						`storagetype`,
						`filename`,
						`width`,
						`height`,
						`weight`,
						`url`,
						`description`,
						`alt`,
						`statustext`,
						`bannertext`,
						`updated`		
						) VALUES(
						:campaignid,
						:contenttype,
						:storagetype,
						:filename,
						:width,
						:height,
						$weight,
						:url,
						:description,
						:alt,
						:statustext,
						:bannertext,
						now()
						)";
				}

				$djax_query_banners = $this->db->prepare($addbanner);

				//contract campaign must have target value
				if ($storagetype == 'web') {
					$djax_query_banners->bindParam(":filename", $c[1]);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":alt", $alt);
					$djax_query_banners->bindParam(":statustext", $statustext);
					$djax_query_banners->bindParam(":bannertext", $txtimgbelow);
				}

				if ($storagetype == 'sql') {

					$djax_query_banners->bindParam(":filename", $filename);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":alt", $alt);
					$djax_query_banners->bindParam(":statustext", $statustext);
					$djax_query_banners->bindParam(":bannertext", $txtimgbelow);
				}

				if ($storagetype == 'url') {
					$djax_query_banners->bindParam(":imageurl", $url_banner_imageurl);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":alt", $alt);
					$djax_query_banners->bindParam(":statustext", $statustext);
					$djax_query_banners->bindParam(":bannertext", $txtimgbelow);
				}

				if ($storagetype == 'txt') {
					$djax_query_banners->bindParam(":statustext", $statustext);
					$djax_query_banners->bindParam(":bannertext", $bannertext);
				}

				$djax_query_banners->bindParam(":campaignid", $campaignid);
				$djax_query_banners->bindParam(":description", $description);
				$djax_query_banners->bindParam(":storagetype", $storagetype);
				$djax_query_banners->bindParam(":contenttype", $contenttype);
				$djax_query_banners->bindParam(":url", $url);


				if ($storagetype == 'sql') {

					$exp_time_img = "SELECT * FROM " . $table_prefix . "images WHERE t_stamp IN (SELECT max(t_stamp) FROM " . $table_prefix . "images)";
					$exp_time_img1 = $this->db->prepare($exp_time_img);
					$exp_time_img1->execute();
					$exp_time_img1 = $exp_time_img1->fetchAll();
					$date_t = $exp_time_img1[0]['t_stamp'];
				} else {
					//$djax_query_banners->bindParam(":updated",$datetime);
				}

				$djax_query_banners->execute();
				$bannerid = $this->db->lastInsertId();
				if ($bannerid) {
					$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
					$get_zone_det = $this->db->prepare($zoneval);
					$get_zone_det->bindParam(":campaignid", $campaignid);
					$get_zone_det->execute();
					$stmtzonevalue = $get_zone_det->fetchAll();
				}

				$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
				$get_banner_det = $this->db->prepare($bannerval);
				$get_banner_det->bindParam(":bannerid", $bannerid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();


				$bannerwidth = $stmtbannervalue[0]['width'];
				$bannerheight = $stmtbannervalue[0]['height'];
				$storagetype = $stmtbannervalue[0]['storagetype'];
				foreach ($stmtzonevalue as $zone_id) {

					$zoneid = $zone_id['zone_id'];
					if ($zoneid) {
						if ($storagetype == 'txt') {

							$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=3";
							$get_zone_det1 = $this->db->prepare($zoneval1);

							$get_zone_det1->execute();
							$stmtzonevalue1 = $get_zone_det1->fetchAll();
						} else if ($storagetype == 'web' || $storagetype == 'url' || $storagetype == 'sql') {
							$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and width=:bannerwidth and height=:bannerheight";
							$get_zone_det1 = $this->db->prepare($zoneval1);
							$get_zone_det1->bindParam(":bannerwidth", $bannerwidth);
							$get_zone_det1->bindParam(":bannerheight", $bannerheight);
							$get_zone_det1->execute();
							$stmtzonevalue1 = $get_zone_det1->fetchAll();
						}
					}


					foreach ($stmtzonevalue1 as $zoneid) {
						$id = $zoneid['zoneid'];
						$zoneids = explode(',', $id);

						foreach ($zoneids as $zoneid) {
							$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
								`priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

							$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
							$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
							$djax_query_adzoneassoc->execute();
						}
					}
				}

                //audit log maintain
				$create_user_id = $_SESSION['user_id'];
				$module = 'banners_'.$description.'_'.$bannerid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":create_user_id", $create_user_id);
				$audit->bindParam(":created_date", $datetime);
				$audit->execute();

				$response = array ('banner' => $bannerid, 'response' => 'success', 'statuscode' => '200', 'msg' => 'Banner added successfully!');
				return $this->response->withJson($response);
			} else if (($input['storagetype'] == 'html') && !(isset ($input['vast_overlay_format']))) {
				$width = $input['width'];
				$height = $input['height'];
				$weight = isset ($input['weight']) ? $input['weight'] : '1';
				$filename = isset ($input['filename']) ? $input['filename'] : '';
				$ext_bannertype = isset ($input['ext_bannertype']) ? $input['ext_bannertype'] : '';
				$append = isset ($input['append']) ? $input['append'] : '';
				$prepend = isset ($input['prepend']) ? $input['prepend'] : '';
				$htmltemplate = isset ($input['htmltemplate']) ? $input['htmltemplate'] : '';
				if ($input['unlimited_impression'] == 'true') {
					$unlimit_impression = 't';
				} else {
					$unlimit_impression = 'f';
				}
				$tot_num_impression = isset ($input['total_impressions']) ? $input['total_impressions'] : 0;
				$limit_y_num_impressions = isset ($input['y_num_impression']) ? $input['y_num_impression'] : 0;
				$impr_time = isset ($input['impressions_time']) ? $input['impressions_time'] : 0;
				//adding html5 banner type

				if ($ext_bannertype == 'bannerTypeHtml:oxHtml:html5') {

					if ($filename) {

						/* Source File URL */
						$remote_file_url = $filename;

						include_once ('../../config.php');

						$image_revivepath = $reviveapiPath;

						/* New file name and path for this file */
						$local_file = $image_revivepath . 'test_html5.zip';

						/* Copy the file from source url to server */
						$copy = copy($remote_file_url, $local_file);

						$file = $local_file;
						// echo "<pre>";print_r($file);

						// echo "<pre>";print_r(realpath( $file ));exit;

						$path = pathinfo(realpath($file), PATHINFO_DIRNAME);

						// echo "<pre>";print_r($path);exit;

						$baseurl = explode('/', $file);
						array_pop($baseurl);
						array_pop($baseurl);
						$randfolder = uniqid(); //rand(10000,99999);
						/* $get_auto_banner="select MAX(bannerid) bannerid from ".$table_prefix."banners";
																																																																																																																																																																																																																																																																																																																																																 $query_banner=$this->db->prepare($get_auto_banner);
																																																																																																																																																																																																																																																																																																																																																 $query_banner->execute();
																																																																																																																																																																																																																																																																																																																																																 $banner_query=$query_banner->fetchAll();
																																																																																																																																																																																																																																																																																																																																															 $randfolder = 'banner_'.$banner_query[0]['bannerid']+1; */
						$furl = implode('/', $baseurl) . "/images/" . $randfolder;

						$zip = new ZipArchive;

						$res = $zip->open($file);


						for ($i = 0; $i < $zip->numFiles; $i++) {
							$kowsi = $zip->getNameIndex($i);


							$fileinfo = pathinfo($kowsi);

							if ($fileinfo['filename'] == 'index') {
								$indexfolder = $fileinfo['dirname'];
							}

							$kowsi = substr_replace($kowsi, "", -1);
						}

						$kowsi = substr($kowsi, 0, strpos($kowsi, "/"));

						chmod($furl . "/" . $kowsi, 0777);


						if ($res === TRUE) {
							$tt = $zip->extractTo($furl);

							chmod($furl . "/" . $kowsi, 0777);
							//mkdir('path/to/directory', 0777, true);

							$zip->close();
							unlink($local_file);
						} else {
							echo "try again with crct zip file";
						}
					}

					$img_size = get_headers($remote_file_url, 1);
					$img_siz = $img_size["Content-Length"];

					//zip serialize
					$var = array ();
					$var1 = array (
						"html5_name" => $randfolder . '.zip',
						"html5_size" => $img_siz
					);

					$parameter1 = serialize($var1);

					if ($kowsi) {

						$html5filename = $randfolder . '/' . $indexfolder;
					} else {

						$html5filename = $randfolder;
					}

					$filepathname = $image_path . $html5filename . "/index.html";
					$target = "<head>";
					$target1 = 'var clickTag = "";';

					$newline = "<script>
window.REVIVE = {
getParameter: function (name, defautVal) {
var match = (new RegExp('[?&]' + name + '=([^&]*)')).exec(window.location.search);
return match ? decodeURIComponent(match[1].replace(/\+/g, ' ')) : defautVal;
}
};
</script>";
					$clicktag = 'clickTag = REVIVE.getParameter("clickTag", "");';

					$stats = file($filepathname, FILE_IGNORE_NEW_LINES);
					$offset = array_search($target, $stats) + 1;
					array_splice($stats, $offset, 0, $newline);
					file_put_contents($filepathname, join("\n", $stats));

					$stats1 = file($filepathname, FILE_IGNORE_NEW_LINES);
					$offset1 = array_search($target1, $stats1) + 1;
					if ($offset1 > 1) {
						array_splice($stats1, $offset1, 0, $clicktag);
						file_put_contents($filepathname, join("\n", $stats1));
					}

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						`campaignid`,
						`contenttype`,
						`filename`,
						`storagetype`,
						`htmltemplate`,
						`htmlcache`,
						`width`,
						`height`,
						`weight`,
						`url`,
						`description`,
						`parameters`,
						`ext_bannertype`,
						`updated`
						) VALUES(
						:campaignid,
						'',
						'" . $html5filename . "',
						:storagetype,
						:htmltemplate,
						:htmlcache,
						:width,
						:height,
						$weight,
						:url,
						:description,
						'" . $parameter1 . "',
						'bannerTypeHtml:oxHtml:html5',
						now()
						);";
				} else {


					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						`campaignid`,
						`contenttype`,
						`storagetype`,
						`htmltemplate`,
						`htmlcache`,
						`width`,
						`height`,
						`weight`,
						`url`,
						`description`,
						`parameters`,
						`ext_bannertype`,
						`updated`				
						) VALUES(
						:campaignid,
						'',
						:storagetype,
						:htmltemplate,
						:htmlcache,
						:width,
						:height,
						$weight,
						:url,
						:description,
						'N;',
						'bannerTypeHtml:oxHtml:genericHtml',
						now()
						);";
				}


				if (($width > -2) && ($height > -2)) {

					$description = isset ($input['description']) ? $input['description'] : '';
					$storagetype = isset ($input['storagetype']) ? $input['storagetype'] : '';

					$contenttype = $input['contenttype'];
					$filename = $input['filename'];
					$width = $input['width'];
					$height = $input['height'];
					$url = $input['url'];
					$htmltemplate = isset ($input['htmltemplate']) ? $input['htmltemplate'] : '';
					$htmlcache = '<a href="{clickurl}" target="{target}">' . $htmltemplate . '</a>';
					$djax_query_banners = $this->db->prepare($addbanner);
					$djax_query_banners->bindParam(":campaignid", $campaignid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":storagetype", $storagetype);
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
					$djax_query_banners->bindParam(":htmlcache", $htmlcache);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);

					$banner = $djax_query_banners->execute();
					$bannerid = $this->db->lastInsertId();
					if ($bannerid) {
						$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
						$get_zone_det = $this->db->prepare($zoneval);
						$get_zone_det->bindParam(":campaignid", $campaignid);
						$get_zone_det->execute();
						$stmtzonevalue = $get_zone_det->fetchAll();
					}

					$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":bannerid", $bannerid);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();


					$bannerwidth = $stmtbannervalue[0]['width'];
					$bannerheight = $stmtbannervalue[0]['height'];
					$ext_bannertype = $stmtbannervalue[0]['ext_bannertype'];
					foreach ($stmtzonevalue as $zone_id) {

						$zoneid = $zone_id['zone_id'];
						if ($zoneid) {
							if ($ext_bannertype == 'bannerTypeHtml:oxHtml:genericHtml' || $ext_bannertype == 'bannerTypeHtml:oxHtml:html5') {

								$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=1 and width=:bannerwidth and height=:bannerheight";
								$get_zone_det1 = $this->db->prepare($zoneval1);
								$get_zone_det1->bindParam(":bannerwidth", $bannerwidth);
								$get_zone_det1->bindParam(":bannerheight", $bannerheight);
								$get_zone_det1->execute();
								$stmtzonevalue1 = $get_zone_det1->fetchAll();
							}
						}


						foreach ($stmtzonevalue1 as $zoneid) {
							$id = $zoneid['zoneid'];
							$zoneids = explode(',', $id);

							foreach ($zoneids as $zoneid) {
								$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
								`priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

								$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
								$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
								$djax_query_adzoneassoc->execute();
							}
						}
					}
					if ($banner) {
					    //audit log maintain
						$create_user_id = $_SESSION['user_id'];
						$module = 'banners_'.$description.'_'.$bannerid;
						$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
						$audit = $this->db->prepare($addaudit);
						$audit->bindParam(":module", $module);
						$audit->bindParam(":create_user_id", $create_user_id);
						$audit->bindParam(":created_date", $datetime);
						$audit->execute();
						$response = array ('banner' => $bannerid, 'response' => 'success', 'statuscode' => '200', 'msg' => 'Banner added successfully!');
						return $this->response->withJson($response);
					}
				} else {

					/////////////////////////////////////inline html/////////////////////////////////////////////

					$description = isset ($input['description']) ? $input['description'] : '';
					$storagetype = isset ($input['storagetype']) ? $input['storagetype'] : '';
					$vast_video_outgoing_filename = $input['vast_video_outgoing_filename'];
					$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
					$vast_video_duration = $input['vast_video_duration'];
					$vast_video_delivery = $input['vast_video_delivery'];
					$vast_video_type = $input['vast_video_type'];
					$imageurl = isset ($input['imageurl']) ? $input['imageurl'] : '';
					$vast_video_id = isset ($input['vast_video_id']) ? $input['vast_video_id'] : null;

					$vast_companion_banner_id = $input['vast_companion_banner_id'];
					$tot_num_impression = isset ($input['total_impressions']) ? $input['total_impressions'] : 0;
					$limit_y_num_impressions = isset ($input['y_num_impression']) ? $input['y_num_impression'] : 0;
					$impr_time = isset ($input['impressions_time']) ? $input['impressions_time'] : 0;
					if ($input['unlimited_impression'] == 'true') {
						$unlimit_impression = 't';
					} else {
						$unlimit_impression = 'f';
					}
					//new add


					$vast_net_connection_url = isset ($input['vast_net_connection_url']) ? $input['vast_net_connection_url'] : null;
					$vast_video_filename = isset ($input['vast_video_filename']) ? $input['vast_video_filename'] : '';
					$videotype = isset ($input['videotype']) ? $input['videotype'] : '';

					//new add

					//new

					$vast_thirdparty_clicktracking = isset ($input['vast_thirdparty_clicktracking']) ? $input['vast_thirdparty_clicktracking'] : '';
					$vast_thirdparty_clickcustom = isset ($input['vast_thirdparty_clickcustom']) ? $input['vast_thirdparty_clickcustom'] : '';
					$vast_thirdparty_companion_expandedwidth = isset ($input['vast_thirdparty_companion_expandedwidth']) ? $input['vast_thirdparty_companion_expandedwidth'] : '';
					$vast_thirdparty_companion_expandedheight = isset ($input['vast_thirdparty_companion_expandedheight']) ? $input['vast_thirdparty_companion_expandedheight'] : '';
					$vast_thirdparty_companion_clicktracking = isset ($input['vast_thirdparty_companion_clicktracking']) ? $input['vast_thirdparty_companion_clicktracking'] : '';
					$vast_wrapper_url = isset ($input['vast_wrapper_url']) ? $input['vast_wrapper_url'] : '';
					$vast_version = isset ($input['vast_version']) ? $input['vast_version'] : '';
					$vast_video_skip_duration = isset ($input['vast_video_skip_duration']) ? $input['vast_video_skip_duration'] : '';
					$vast_video_skip_progress_duration = isset ($input['vast_video_skip_progress_duration']) ? $input['vast_video_skip_progress_duration'] : '';

					//end

					$vast_overlay_height = isset ($input['vast_overlay_height']) ? $input['vast_overlay_height'] : null;
					$vast_overlay_width = isset ($input['vast_overlay_width']) ? $input['vast_overlay_width'] : null;
					$vast_overlay_text_title = isset ($input['vast_overlay_text_title']) ? $input['vast_overlay_text_title'] : null;
					$vast_overlay_text_description = isset ($input['vast_overlay_text_description']) ? $input['vast_overlay_text_description'] : null;
					$vast_overlay_text_call = isset ($input['vast_overlay_text_call']) ? $input['vast_overlay_text_call'] : null;

					if ($vast_video_delivery == "streaming") {
						//$saving_file = $vast_net_connection_url.$videotype.':'.$vast_video_filename;
						$saving_file = $vast_video_outgoing_filename;
						//$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
					} else {
						$saving_file = $vast_net_connection_url . $videotype . ':' . $vast_video_filename;
					}

					$var = array ();
					$var = array (
						"banner_vast_element_id" => 'banner_vast_element_id',
						"vast_element_type" => 'singlerow',
						"vast_video_id" => 'N',
						"vast_video_duration" => $vast_video_duration,
						"vast_video_delivery" => $vast_video_delivery,
						"vast_video_type" => $vast_video_type,
						"vast_video_bitrate" => 400,
						"vast_video_height" => 480,
						"vast_video_width" => 640,
						"vast_video_outgoing_filename" => $saving_file,
						"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
						"vast_overlay_height" => 'N',
						"vast_overlay_width" => 'N',
						"vast_overlay_text_title" => 'N',
						"vast_overlay_text_description" => 'N',
						"vast_overlay_text_call" => 'N',
						"vast_overlay_format" => 'N',
						"vast_overlay_action" => 'N',
						"vast_companion_banner_id" => $vast_companion_banner_id,
						"vast_creative_type" => 'N'
					);

					$addbanner = "INSERT INTO " . $table_prefix . "banners(
						`campaignid`,
						`storagetype`,
						`width`,
						`height`,
						`weight`,
						`description`,
						`parameters`,
						`updated`,
						`ext_bannertype`)  VALUES (
						:campaignid,
						:storagetype,
						-3,
						-3,
						$weight,
						:description,
						:parameters,
						now(),
						'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml')";

					$parameter = serialize($var);

					if (empty ($parameter)) {
						$parameter = 'N;';
					}

					$djax_query_banners = $this->db->prepare($addbanner);

					$djax_query_banners->bindParam(":campaignid", $campaignid);
					$djax_query_banners->bindParam(":storagetype", $storagetype);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":parameters", $parameter);

					$djax_query_banners->execute();
					$bannerid = $this->db->lastInsertId();

					$get_banner_id = "select * from banner_vast_element_seq";
					$query_banner_vast_id = $this->db->prepare($get_banner_id);
					$query_banner_vast_id->execute();
					$banner_vast_id = $query_banner_vast_id->fetchAll();

					if (count($banner_vast_id) > 0) {
						$a = $banner_vast_id[0]['id'];
						$banner_vast_element_id = $a + 1;
					} else {
						$banner_vast_element_id = 1;
					}

					$vast_element_type = 'singlerow';
					$vast_video_bitrate = 400;
					$vast_video_height = 480;
					$vast_video_width = 640;

					if ($vast_video_delivery == "streaming") {

						$qot = ':';
						//$vast_video_outgoing_filename = $vast_net_connection_url.$videotype.$qot.$vast_video_filename;
						$vast_video_outgoing_filename = $input['vast_video_outgoing_filename'];
						$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
						$addparameters = "insert into " . $table_prefix . "banner_vast_element(
							`banner_vast_element_id`,
							`banner_id`,
							`vast_element_type`,
							`vast_video_id`,
							`vast_video_duration`,
							`vast_video_delivery`,
							`vast_video_type`,
							`vast_video_bitrate`,
							`vast_video_height`,
							`vast_video_width`,
							`vast_video_outgoing_filename`,
							`vast_companion_banner_id`,
							`vast_overlay_height`,
							`vast_overlay_width`,
							`vast_video_clickthrough_url`,
							`vast_overlay_text_title`,
							`vast_overlay_text_description`,
							`vast_overlay_text_call`,
							`vast_creative_type`)
							values(
							:banner_vast_element_id,
							:banner_id,
							:vast_element_type,
							:vast_video_id,
							:vast_video_duration,
							:vast_video_delivery,
							:vast_video_type,
							:vast_video_bitrate,
							:vast_video_height,
							:vast_video_width,
							:vast_video_outgoing_filename,
							:vast_companion_banner_id,
							:vast_overlay_height,
							:vast_overlay_width,
							:vast_video_clickthrough_url,
							:vast_overlay_text_title,
							:vast_overlay_text_description,
							:vast_overlay_text_call,
							:vast_creative_type)";
					} else {
						$addparameters = "insert into " . $table_prefix . "banner_vast_element(
							`banner_vast_element_id`,
							`banner_id`,
							`vast_element_type`,
							`vast_video_id`,
							`vast_video_duration`,
							`vast_video_delivery`,
							`vast_video_type`,
							`vast_video_bitrate`,
							`vast_video_height`,
							`vast_video_width`,
							`vast_video_outgoing_filename`,
							`vast_companion_banner_id`,
							`vast_overlay_height`,
							`vast_overlay_width`,
							`vast_video_clickthrough_url`,
							`vast_overlay_text_title`,
							`vast_overlay_text_description`,
							`vast_overlay_text_call`,
							`vast_creative_type`)
							values(
							:banner_vast_element_id,
							:banner_id,
							:vast_element_type,
							:vast_video_id,
							:vast_video_duration,
							:vast_video_delivery,
							:vast_video_type,
							:vast_video_bitrate,
							:vast_video_height,
							:vast_video_width,
							:vast_video_outgoing_filename,
							:vast_companion_banner_id,
							:vast_overlay_height,
							:vast_overlay_width,
							:vast_video_clickthrough_url,
							:vast_overlay_text_title,
							:vast_overlay_text_description,
							:vast_overlay_text_call,
							:vast_creative_type
							)";
					}
					$djax_query_banners_parameters = $this->db->prepare($addparameters);

					$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
					$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);

					$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
					$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
					$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
					$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);

					$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
					$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
					$djax_query_banners_parameters->bindParam(":vast_video_height", $vast_video_height);
					$djax_query_banners_parameters->bindParam(":vast_video_width", $vast_video_width);
					$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
					$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
					$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
					$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
					$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);

					$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
					$djax_query_banners_parameters->execute();
					$addelement_id = "update banner_vast_element_seq set `id`=:banner_vast_element_id;";
					$djax_query_banners_elements = $this->db->prepare($addelement_id);
					$djax_query_banners_elements->bindParam(":banner_vast_element_id", $banner_vast_element_id);
					$djax_query_banners_elements->execute();


					if ($bannerid) {
						$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
						$get_zone_det = $this->db->prepare($zoneval);
						$get_zone_det->bindParam(":campaignid", $campaignid);
						$get_zone_det->execute();
						$stmtzonevalue = $get_zone_det->fetchAll();
					}

					$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":bannerid", $bannerid);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();


					$bannerwidth = $stmtbannervalue[0]['width'];
					$bannerheight = $stmtbannervalue[0]['height'];
					$ext_bannertype = $stmtbannervalue[0]['ext_bannertype'];
					foreach ($stmtzonevalue as $zone_id) {

						$zoneid = $zone_id['zone_id'];
						if ($zoneid) {
							if ($ext_bannertype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') {

								$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=6";
								$get_zone_det1 = $this->db->prepare($zoneval1);

								$get_zone_det1->execute();
								$stmtzonevalue1 = $get_zone_det1->fetchAll();
							}
						}


						foreach ($stmtzonevalue1 as $zoneid) {
							$id = $zoneid['zoneid'];
							$zoneids = explode(',', $id);

							foreach ($zoneids as $zoneid) {
								$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
								`priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

								$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
								$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
								$djax_query_adzoneassoc->execute();
							}
						}
					}
					$response = array ('banner' => $bannerid, 'response' => 'success', 'statuscode' => '200', 'msg' => 'Banner added successfully!');
					return $this->response->withJson($response);
				}
			}

			///////////////////////////////////// include Overlay///////////////////////////////////////////////////////////
			else if (
				($input['storagetype'] == 'html') && ($input['vast_overlay_format'] == 'text_overlay' ||
					$input['vast_overlay_format'] == 'html_overlay' || $input['vast_overlay_format'] == 'image_overlay' || $input['vast_overlay_format'] == 'swf_overlay')
			) {

				$description = isset ($input['description']) ? $input['description'] : '';
				$storagetype = isset ($input['storagetype']) ? $input['storagetype'] : '';
				$weight = isset ($input['weight']) ? $input['weight'] : '1';
				$imageurl = isset ($input['imageurl']) ? $input['imageurl'] : '';
				$tot_num_impression = isset ($input['total_impressions']) ? $input['total_impressions'] : 0;
				if ($input['unlimited_impression'] == 'true') {
					$unlimit_impression = 't';
				} else {
					$unlimit_impression = 'f';
				}
				$limit_y_num_impressions = isset ($input['y_num_impression']) ? $input['y_num_impression'] : 0;
				$impr_time = isset ($input['impressions_time']) ? $input['impressions_time'] : 0;


				if ($input['vast_overlay_format'] == 'text_overlay') {
					$vast_overlay_text_title = $input['vast_overlay_text_title'];
					$vast_overlay_text_description = $input['vast_overlay_text_description'];
					$vast_overlay_text_call = $input['vast_overlay_text_call'];
					$vast_overlay_format = $input['vast_overlay_format'];
					$vast_overlay_height = 'N';
					$vast_overlay_width = 'N';
				} else {
					$vast_overlay_text_title = '';
					$vast_overlay_text_description = '';
					$vast_overlay_text_call = '';
					$vast_overlay_height = $input['vast_overlay_height'];
					$vast_overlay_width = $input['vast_overlay_width'];
				}

				//////////////////////text overlay-//////////////////////html overlay/////////////////////////////////

				if ($input['vast_overlay_format'] == 'html_overlay') {

					$htmltemplate = $input['htmltemplate'];
					$htmlcache = '<a href="{clickurl}" target="{target}">' . $htmltemplate . '</a>';
				} else {
					$htmltemplate = '';
					$htmlcache = '<a href="{clickurl}" target="{target}"></a>';
				}

				////////////////////////////imageoverlay////////////////////////////////////////////////////////////
				if ($input['vast_overlay_format'] == 'image_overlay' || $input['vast_overlay_format'] == 'swf_overlay') {

					if ($imageurl) {
						$valid_exts = array ("jpg", "jpeg", "gif", "png", "swf"); // default image only extensions
						$ext = explode(".", strtolower(basename($imageurl)));
						$ext = end($ext);
						$filename = basename($imageurl);
						$new = explode(".", $filename);
						$encryptfilename = md5($new[0]);
						$ac = $encryptfilename . "." . $new[1];
						$c[] = '';
						array_push($c, $ac);
						if (in_array($ext, $valid_exts)) {

							$rand = rand(10000, 99999);
							$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
							$content = file_get_contents($imageurl);
							file_put_contents(DIRECTORY . $c[1], $content);
						}
					}
				} else {
					$ac = '';
				}

				if ($input['vast_overlay_action'] == 'click_to_page') {
					$url = isset ($input['url']) ? $input['url'] : '';
					$vast_video_duration = '';
					$vast_video_delivery = 'N';
					$vast_video_type = '';
					$vast_video_outgoing_filename = 'N';
					$vast_video_clickthrough_url = '';
					$vast_overlay_action = $input['vast_overlay_action'];
				}

				if ($input['vast_overlay_action'] == 'click_to_video') {
					$htmlcache = $htmltemplate;
					$url = '';

					$vast_video_duration = $input['vast_video_duration'];
					$vast_video_delivery = $input['vast_video_delivery'];
					$vast_video_type = $input['vast_video_type'];
					$vast_video_outgoing_filename = $input['vast_video_outgoing_filename'];
					$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
					$vast_overlay_action = $input['vast_overlay_action'];
				}

				//reqired fields
				$vast_element_type = 'singlerow';
				$vast_overlay_height = $input['vast_overlay_height'];
				$vast_overlay_width = $input['vast_overlay_width'];
				$vast_overlay_format = $input['vast_overlay_format'];
				$vast_creative_type = $input['vast_creative_type'];
				$vast_thirdparty_impression = $input['vast_thirdparty_impression'];

				if ($input['vast_companion_banner_id']) {
					$vast_companion_banner_id = $input['vast_companion_banner_id'];
				} else {
					$vast_companion_banner_id = '';
				}



				$vast_net_connection_url = isset ($input['vast_net_connection_url']) ? $input['vast_net_connection_url'] : null;
				$vast_video_filename = isset ($input['vast_video_filename']) ? $input['vast_video_filename'] : '';
				$videotype = isset ($input['videotype']) ? $input['videotype'] : '';

				if ($vast_video_delivery == "streaming") {

					//$saving_file = $vast_net_connection_url.$videotype.':'.$vast_video_filename;
					$saving_file = $vast_video_outgoing_filename;
				} else {
					$saving_file = $vast_video_outgoing_filename;
				}


				$var = array ();
				$var = array (
					"banner_vast_element_id" => 'banner_vast_element_id',
					"vast_element_type" => $vast_element_type,
					"vast_video_id" => 'N',
					"vast_video_duration" => $vast_video_duration,
					"vast_video_delivery" => $vast_video_delivery,
					"vast_video_type" => $vast_video_type,
					"vast_video_bitrate" => 400,
					"vast_video_height" => 480,
					"vast_video_width" => 640,
					"vast_video_outgoing_filename" => $saving_file,
					"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
					"vast_overlay_height" => $vast_overlay_height,
					"vast_overlay_width" => $vast_overlay_width,
					"vast_overlay_text_title" => $vast_overlay_text_title,
					"vast_overlay_text_description" => $vast_overlay_text_description,
					"vast_overlay_text_call" => $vast_overlay_text_call,
					"vast_overlay_format" => $vast_overlay_format,
					"vast_overlay_action" => $vast_overlay_action,
					"vast_companion_banner_id" => $vast_companion_banner_id,
					"vast_creative_type" => $vast_creative_type,
					"vast_thirdparty_impression" => $vast_thirdparty_impression
				);

				$parameter = serialize($var);
				$addbanner = "INSERT INTO " . $table_prefix . "banners(
					`campaignid` , 
					`storagetype` ,
					`filename` ,
					`htmlcache` ,
					`htmltemplate`,
					`url` ,
					`width` ,
					`height` ,
					`weight` ,
					`description` ,
					`parameters` ,
					`updated`,
					`ext_bannertype`)
					VALUES 
					(:campaignid,
					:storagetype,
					:filename,
					:htmlcache,
					:htmltemplate,
					:url,
					-2,
					-2,
					$weight,
					:description,
					:parameters,
					now(),
					'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml')";

				$djax_query_banners = $this->db->prepare($addbanner);
				$djax_query_banners->bindParam(":campaignid", $campaignid);
				$djax_query_banners->bindParam(":storagetype", $storagetype);
				$djax_query_banners->bindParam(":filename", $ac);
				$djax_query_banners->bindParam(":htmlcache", $htmlcache);
				$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
				$djax_query_banners->bindParam(":url", $url);
				$djax_query_banners->bindParam(":description", $description);
				$djax_query_banners->bindParam(":parameters", $parameter);

				$djax_query_banners->execute();
				$bannerid = $this->db->lastInsertId();

				///////////////////////////////////////////////////////NEWLYADDED////////////////////////////////////////////////////////////////////////////////////////////////////////////NEWLYADDED/////////////////////////////////////////////////////

				$overlay_banner_id = "select * from banner_vast_element_seq";
				$overlay_banner_vast_id = $this->db->prepare($overlay_banner_id);
				$overlay_banner_vast_id->execute();
				$overlay_vast_id = $overlay_banner_vast_id->fetchAll();

				if (count($overlay_vast_id) > 0) {
					$b = $overlay_vast_id[0]['id'];
					$banner_vast_element_id = $b + 1;
				} else {

					$banner_vast_element_id = 1;
				}
				$vast_element_type = 'singlerow';
				$vast_video_bitrate = 400;
				$vast_video_height = 480;
				$vast_video_width = 640;

				$addparameters = "insert into " . $table_prefix . "banner_vast_element(
					`banner_vast_element_id`,
					`banner_id`,
					`vast_element_type`,
					`vast_video_id`,
					`vast_video_duration`,
					`vast_video_delivery`,
					`vast_video_type`,
					`vast_video_bitrate`,
					`vast_video_height`,
					`vast_video_width`,
					`vast_video_outgoing_filename`,
					`vast_companion_banner_id`,
					`vast_overlay_height`,
					`vast_overlay_width`,
					`vast_video_clickthrough_url`,
					`vast_overlay_action`,
					`vast_overlay_format`,
					`vast_overlay_text_title`,
					`vast_overlay_text_description`,
					`vast_overlay_text_call`,
					`vast_creative_type`,
					`vast_thirdparty_impression`		
					)
					values(
					:banner_vast_element_id,
					:banner_id,
					:vast_element_type,
					:vast_video_id,
					:vast_video_duration,
					:vast_video_delivery,
					:vast_video_type,
					:vast_video_bitrate,
					:vast_video_height,
					:vast_video_width,
					:vast_video_outgoing_filename,
					:vast_companion_banner_id,
					:vast_overlay_height,
					:vast_overlay_width,
					:vast_video_clickthrough_url,
					:vast_overlay_action,
					:vast_overlay_format,
					:vast_overlay_text_title,
					:vast_overlay_text_description,
					:vast_overlay_text_call,
					:vast_creative_type,
					:vast_thirdparty_impression
					)";

				$djax_query_banners_parameters = $this->db->prepare($addparameters);

				$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
				$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
				$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
				$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
				$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
				$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);
				$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
				$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
				$djax_query_banners_parameters->bindParam(":vast_video_height", $vast_video_height);
				$djax_query_banners_parameters->bindParam(":vast_video_width", $vast_video_width);
				if ($vast_video_delivery == "streaming") {
					/* $qot =':';
																																																																																																																																																																																																																																																																																							  $vast_video_outgoing_filename = $vast_net_connection_url.$videotype.$qot.$vast_video_filename; */
					$vast_video_outgoing_filename = $vast_video_outgoing_filename;
				} else {
					$vast_video_outgoing_filename = $vast_video_outgoing_filename;
				}
				$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
				$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
				$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
				$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
				$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
				$djax_query_banners_parameters->bindParam(":vast_overlay_format", $vast_overlay_format);
				$djax_query_banners_parameters->bindParam(":vast_overlay_action", $vast_overlay_action);
				$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
				$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
				$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);
				$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
				$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);

				$djax_query_banners_parameters->execute();


				$overlay_addelement_id = "update banner_vast_element_seq set `id`=:banner_vast_element_id;";
				$overlay_elements = $this->db->prepare($overlay_addelement_id);
				$overlay_elements->bindParam(":banner_vast_element_id", $banner_vast_element_id);
				$overlay_elements->execute();

				///////////////////////////////////////////////////////NEWLY ADDED /////////////////////////////////////////////////////////////////////////////////

				if ($bannerid) {
					$zoneval = "select zone_id from {$table_prefix}placement_zone_assoc where placement_id=:campaignid";
					$get_zone_det = $this->db->prepare($zoneval);
					$get_zone_det->bindParam(":campaignid", $campaignid);
					$get_zone_det->execute();
					$stmtzonevalue = $get_zone_det->fetchAll();
				}

				$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
				$get_banner_det = $this->db->prepare($bannerval);
				$get_banner_det->bindParam(":bannerid", $bannerid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();


				$bannerwidth = $stmtbannervalue[0]['width'];
				$bannerheight = $stmtbannervalue[0]['height'];
				$ext_bannertype = $stmtbannervalue[0]['ext_bannertype'];
				foreach ($stmtzonevalue as $zone_id) {

					$zoneid = $zone_id['zone_id'];
					if ($zoneid) {
						if ($ext_bannertype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') {

							$zoneval1 = "select * from {$table_prefix}zones where zoneid=$zoneid and delivery=7";
							$get_zone_det1 = $this->db->prepare($zoneval1);

							$get_zone_det1->execute();
							$stmtzonevalue1 = $get_zone_det1->fetchAll();
						}
					}


					foreach ($stmtzonevalue1 as $zoneid) {
						$id = $zoneid['zoneid'];
						$zoneids = explode(',', $id);

						foreach ($zoneids as $zoneid) {
							$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
								`priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
									VALUES (:zoneid, $bannerid,0,1,1,1);";

							$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
							$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
							$djax_query_adzoneassoc->execute();
						}
					}
				}
				$response = array ('banner' => $bannerid, 'response' => 'success', 'statuscode' => '200', 'msg' => 'Banner added successfully!');
				return $this->response->withJson($response);
			} else {

				$response = array ('response' => 'error', 'msg' => 'Please check with parameters provided and spellings or quotes');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid Campaignid');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('banneradd_val'));

//File Image Upload 

$app->post('/file_upload/', function ($request, $response, $args) {
	$data = json_decode(file_get_contents("php://input"), true); // collect input parameters and convert into readable format

	$fileName = $_FILES['sendimage']['name'];
	$tempPath = $_FILES['sendimage']['tmp_name'];
	$fileSize = $_FILES['sendimage']['size'];

	if (empty ($fileName)) {
		$errorMSG = json_encode(array ("message" => "please select image", "status" => false));
		echo $errorMSG;
	} else {
		$upload_path = '/home/ubuntu/html/adservermodui/assets/images/'; // set upload folder path 
		//$upload_path = 'https://revphpe.djaxbidder.com/adservermodui/assets/images'; // set project upload folder path 
		//$upload_path = 'https://revphpe.djaxbidder.com/revivemohan/www/images/'; // set revive path upload folder path 

		$fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION)); // get image extension

		// valid image extensions
		$valid_extensions = array ('jpeg', 'jpg', 'png', 'gif');

		// allow valid image file formats
		if (in_array($fileExt, $valid_extensions)) {
			//check file not exist our upload folder path
			if (!file_exists($upload_path . $fileName)) {
				// check file size '5MB'
				if ($fileSize < 5000000) {

					move_uploaded_file($tempPath, $upload_path . $fileName); // move file from system temporary path to our upload folder path 
				} else {
					$errorMSG = json_encode(array ("message" => "Sorry, your file is too large, please upload 5 MB size", "status" => false));
					echo $errorMSG;
				}
			} else {
				$errorMSG = json_encode(array ("message" => "Sorry, file already exists check upload folder", "status" => false));
				echo $errorMSG;
			}
		} else {
			$errorMSG = json_encode(array ("message" => "Sorry, only JPG, JPEG, PNG & GIF files are allowed", "status" => false));
			echo $errorMSG;
		}
	}
	if (!isset ($errorMSG)) {
		echo json_encode(array ("message" => "Image Uploaded Successfully", "status" => true));
	}
});

//Image Upload API

$app->post('/image_upload', function ($request, $response) {

	$input = $request->getParsedBody();

	if (!empty ($input['filetype'])) {
		if ($_FILES["internal_file"]["size"] != 0) {
			if ($_FILES["internal_file"]["error"] > 0) {
				$response = array ('status' => '0', 'response' => 'error', 'msg' => "Error: " . $_FILES["internal_file"]["error"]);
			}
			$ext = pathinfo($_FILES["internal_file"]["name"], PATHINFO_EXTENSION);
			$Newfile = round(microtime(true)) . "." . $ext;

			$filetype = $input['filetype'];

			include_once ('../../config.php');

			$dest_path = $reviveapiPath . $Newfile;
			$original_path = $_FILES["internal_file"]["tmp_name"];
			$imagefolderoriginalsize = getimagesize($original_path);
			$originalwidth = $imagefolderoriginalsize[0];
			$originalheight = $imagefolderoriginalsize[1];
			move_uploaded_file($_FILES["internal_file"]["tmp_name"], $dest_path);

			$response = array ('status' => '1', 'response' => 'success', 'msg' => 'Upload Successfully..', 'filetype' => $filetype, 'fileformat' => $ext, 'fileoriginalwidth' => $originalwidth, 'fileoriginalheight' => $originalheight, 'filename' => $Newfile, 'fileurl' => $revivePath . $Newfile, 'filepath' => $reviveapiPath, 'dest_path' => $dest_path);
		} else {
			$response = array ('status' => '0', 'response' => 'error', 'msg' => 'Please select an image to upload first.');
		}
	} else {
		$response = array ('status' => '0', 'response' => 'error', 'msg' => 'Please select an image type.');
	}

	return $this->response->withJson($response);
});


/*
 * BANNER EDIT
 * 
 * Input Parameters:
 * ----------------
 * description [mandatory]
 * contenttype
 * storagetype 
 * imageurl
 * width
 * height
 * weight
 * url
 * target
 * alt
 * statustext
 * bannertext
 * comments
 * updated
 * keyword
 * append
 * prepend
 * mode
 * 
 * Arguments:
 * ---------
 * Bannerid
 */

$app->post('/edit_banner/[{banner_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$bannerid = $args['banner_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		//Database connection
		$db_host = $this->get('settings')['db']['host'];
		$db_user = $this->get('settings')['db']['user'];
		$db_pass = $this->get('settings')['db']['pass'];
		$db_dbname = $this->get('settings')['db']['dbname'];

		if ($_SERVER["HTTPS"] == "on") {
			$https = 'https://';
		} else {
			$https = 'http://';
		}

		$imagefull_path = $this->get('settings')['path']['image_path'];

		$imagenew_path = $https . $this->get('settings')['path']['image_path'] . '/';

		include_once ('../../config.php');

		//$image_path = '../../../revivemohan/www/images/';

		$image_path = $reviveapiPath;

		define('DIRECTORY', $image_path);
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$results = array ();

		$getbanners = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
		$djax_query_banner = $this->db->prepare($getbanners);
		$djax_query_banner->bindParam(":bannerid", $bannerid);
		$djax_query_banner->execute();
		$stmtbanner = $djax_query_banner->fetchAll();
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		if (count($stmtbanner) > 0) {
			if (isset ($input['storagetype'])) {
				$storagetype = $input['storagetype'];
			} else {
				$storagetype = $stmtbanner[0]['storagetype'];
			}

			if (isset ($input['contenttype'])) {
				$contenttype = $input['contenttype'];
			} else {
				$contenttype = $stmtbanner[0]['contenttype'];
			}

			if (isset ($input['description'])) {
				$description = $input['description'];
			} else {
				$description = $stmtbanner[0]['description'];
			}

			if (isset ($input['keyword'])) {
				$keyword = $input['keyword'];
			} else {
				$keyword = $stmtbanner[0]['keyword'];
			}

			if (isset ($input['append'])) {
				$append = $input['append'];
			} else {
				$append = $stmtbanner[0]['append'];
			}


			if (isset ($input['prepend'])) {
				$prepend = $input['prepend'];
			} else {
				$prepend = $stmtbanner[0]['prepend'];
			}

			if (isset ($input['comments'])) {
				$comments = $input['comments'];
			}
			if (isset ($input['filename'])) {
				$filename = $input['filename'];
			} else {
				$filename = $stmtbanner[0]['filename'];
			}

			if (isset ($input['total_impressions'])) {
				$tot_num_impression = $input['total_impressions'];
			} else {
				$tot_num_impression = $stmtbanner[0]['impressions_total'];
			}

			if (isset ($input['unlimited_impression'])) {
				if ($input['unlimited_impression'] == 'true') {
					$unlimit_impression = 't';
				} else {
					$unlimit_impression = 'f';
				}
			} else {
				if ($stmtbanner[0]['impr_unlimited'] == 't') {
					$unlimit_impression = 't';
				} else {
					$unlimit_impression = 'f';
				}
				//~ $unlimit_impression = isset($stmtbanner[0]['impr_unlimited'])?'t':'f';
			}

			if (isset ($input['y_num_impression'])) {
				$limit_y_num_impressions = $input['y_num_impression'];
			} else {
				$limit_y_num_impressions = $stmtbanner[0]['impressions_number'];
			}

			if (isset ($input['impressions_time'])) {
				$impr_time = $input['impressions_time'];
			} else {
				$impr_time = $stmtbanner[0]['impressions_time'];
			}
			///////////////////////////////////////text,web,sql,url////////////////////////////////////

			$dbfilename = $stmtbanner[0]['filename'];

			if ($storagetype == 'web' || $storagetype == 'txt' || $storagetype == 'sql' || $storagetype == 'url') {
				if (isset ($input['imageurl'])) {
					$imageurl = $input['imageurl'];

					if ($storagetype == 'web') {
						//web banner upload in edit

						if ($imageurl) {
							$file = fopen($imageurl, "rb");

							if ($file) {

								$valid_exts = array ("jpg", "jpeg", "gif", "png"); // default image only extensions
								$ext = explode(".", strtolower(basename($imageurl)));
								$ext = end($ext);

								$file_name = basename($imageurl);
								$new = explode(".", $file_name);
								$encryptfilename = md5($new[0]);
								$ac = $encryptfilename . "." . $new[1];
								$c[] = '';
								array_push($c, $ac);
								if (in_array($ext, $valid_exts)) {
									$newfile = fopen("" . $image_path . "" . $c[1], "wb"); // replace "downloads" with whatever directory you wish.

									if ($newfile) {
										//~ while(!feof($file))
										//~ {
										$rand = rand(10000, 99999);
										$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
										$content = file_get_contents($imageurl);
										file_put_contents(DIRECTORY . $c[1], $content);

										//~ }
									}
								}
							}
						} else {
							$filename = $stmtbanner[0]['filename'];
						}
					}

					if ($storagetype == 'sql') {
						if ($imageurl) {
							$con = mysqli_connect($db_host, $db_user, $db_pass, $db_dbname);
							$valid_exts = array ("jpg", "jpeg", "gif", "png"); // default image only extensions
							$ext = explode(".", strtolower(basename($imageurl)));
							$ext = end($ext);
							$filename = basename($imageurl);
							$new = explode(".", $filename);
							$encryptfilename = md5($new[0]);
							$ac = $encryptfilename . "." . $new[1];
							$c[] = '';
							//checking for existing name
							$exp_time_sql = "SELECT filename FROM " . $table_prefix . "banners WHERE storagetype='sql'";
							$exp_time_sql1 = $this->db->prepare($exp_time_sql);
							$exp_time_sql1->execute();
							$exp_time_sql1 = $exp_time_sql1->fetchAll();

							if (in_array($ext, $valid_exts)) {

								function in_array_r($filename, $exp_time_sql1)
								{
									$found = false;
									foreach ($exp_time_sql1 as $item) {
										if ($item === $filename) {
											$found = true;
											break;
										} elseif (is_array($item)) {
											$found = in_array_r($filename, $item);
											if ($found) {
												break;
											}
										}
									}
									return $found;
								}

								if (in_array_r($filename, $exp_time_sql1)) {
									array_push($c, $ac);
									$rand = rand(10000, 99999);
									//$newfile = $rand.$c[1]; // replace "downloads" with whatever directory you wish.
									$newfile = $imagefull_path . '/' . $stmtbanner[0]['filename'];
									$filename = $stmtbanner[0]['filename'];
									$content = file_get_contents($imageurl);
									$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
									$target_Path = DIRECTORY . $filename;
									$target_data = file_get_contents($target_Path);
									$target_data1 = mysqli_real_escape_string($con, $target_data);
									//echo 'Already file upload';
								} else {
									array_push($c, $ac);
									$rand = rand(10000, 99999);
									$newfile = $rand . $c[1]; // replace "downloads" with whatever directory you wish.
									$filename = $newfile;
									$content = file_get_contents($imageurl);
									$target_data2 = file_put_contents(DIRECTORY . $newfile, $content);
									$target_Path = DIRECTORY . $filename;
									$target_data = file_get_contents($target_Path);
									$target_data1 = mysqli_real_escape_string($con, $target_data);
									//echo 'file upload';

								}
							} else {
								$filename = $stmtbanner[0]['filename'];
							}
						}

						//inserting image path
						/* $sql = "INSERT INTO ".$table_prefix."images(`filename`,`contents`,t_stamp) values('".$filename."','".$target_data1."',now())";
																																																																																																																																																																																																																																																																																																																																																 
																																																																																																																																																																																																																																																																																																																																																 $djax_query_ban=$this->db->prepare($sql); 
																																																																																																																																																																																																																																																																																																																																															 $djax_query_ban->execute(); */
					}
				} else {
					$filename = $stmtbanner[0]['filename'];
				}

				//image url for url banner
				if (isset ($input['url_banner_imageurl'])) {
					$url_banner_imageurl = $input['url_banner_imageurl'];
				} else {
					$url_banner_imageurl = $stmtbanner[0]['imageurl'];
				}

				if (isset ($input['width'])) {
					$width = $input['width'];
				} else {
					$width = $stmtbanner[0]['width'];
				}

				if (isset ($input['height'])) {
					$height = $input['height'];
				} else {
					$height = $stmtbanner[0]['height'];
				}

				if (isset ($input['weight'])) {
					$weight = $input['weight'];
				} else {
					$weight = $stmtbanner[0]['weight'];
				}

				if (isset ($input['url'])) {
					$url = $input['url'];
				} else {
					$url = $stmtbanner[0]['url'];
				}

				if (isset ($input['updated'])) {
					$updated = $input['updated'];
				} else {
					$updated = $stmtbanner[0]['updated'];
				}

				if (isset ($input['alt'])) {
					$alt = $input['alt'];
				} else {
					$alt = $stmtbanner[0]['alt'];
				}

				if (isset ($input['statustext'])) {
					$statustext = $input['statustext'];
				} else {
					$statustext = $stmtbanner[0]['statustext'];
				}

				if (isset ($input['txtimgbelow'])) {
					$txtimgbelow = $input['txtimgbelow'];
				} else {
					$txtimgbelow = $stmtbanner[0]['txtimgbelow'];
				}

				if (isset ($input['bannertext'])) {
					$bannertext = $input['bannertext'];
				} else {
					$bannertext = $stmtbanner[0]['bannertext'];
				}

				if (isset ($input['target'])) {
					$target = $input['target'];
				} else {
					$target = $stmtbanner[0]['target'];
				}

				if ($weight > 127) {
					$weight = "127";
				}

				if ($storagetype == 'web') {
					$editbanner = "update " . $table_prefix . "banners set
						`contenttype`=:contenttype,
						`storagetype`='web',
						`filename`=:filename,
						`width`=:width,
						`height`=:height,
						`weight`=$weight,
						`url`=:url,
						`alt`=:alt,
						`statustext`=:statustext,
						`bannertext`=:bannertext,
						`description`=:description,
						`updated`=now()
						where bannerid=:bannerid";
				} else if ($storagetype == 'url') {
					$editbanner = "update " . $table_prefix . "banners set
						`contenttype`=:contenttype,
						`storagetype`='url',
						`imageurl`=:imageurl,
						`width`=:width,
						`height`=:height,
						`weight`=$weight,
						`url`=:url,
						`alt`=:alt,
						`statustext`=:statustext,
						`bannertext`=:bannertext,
						`description`=:description,
						`updated`=now()
						where  bannerid=:bannerid";
				} else if ($storagetype == 'sql') {
					$editbanner = "update " . $table_prefix . "banners set
						`contenttype`=:contenttype,
						`storagetype`='sql',
						`filename`=:filename,
						`width`=:width,
						`height`=:height,
						`weight`=$weight,
						`url`=:url,
						`alt`=:alt,
						`statustext`=:statustext,
						`bannertext`=:bannertext,
						`description`=:description,
						`updated`=now()
						where bannerid=:bannerid";
				} else if ($storagetype == 'txt') {
					$editbanner = "update " . $table_prefix . "banners set
						`storagetype`='txt',
						`url`=:url,
						`weight`=$weight,
						`description`=:description,
						`statustext`=:statustext,
						`bannertext`=:bannertext,
						`updated`=now()
						where bannerid=:bannerid";
				}
				$djax_query_banners = $this->db->prepare($editbanner);

				//contract campaign must have target value
				if ($storagetype == 'web') {

					//edit upload if they pass imageurl else take it from db
					if (isset ($input['imageurl'])) {
						if ($c[1]) {
							$djax_query_banners->bindParam(":filename", $c[1]);
						} else {
							//print_r($c[1]);
							//echo $filename;
							$djax_query_banners->bindParam(":filename", $filename);
						}
					} else {
						//echo $filename;
						$djax_query_banners->bindParam(":filename", $filename);
						//print_r($filename);
					}

					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":contenttype", $contenttype);
					$djax_query_banners->bindParam(":alt", $alt);
					$djax_query_banners->bindParam(":statustext", $statustext);
					$djax_query_banners->bindParam(":bannertext", $txtimgbelow);
				}

				if ($storagetype == 'sql') {
					$djax_query_banners->bindParam(":filename", $filename);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":contenttype", $contenttype);
					$djax_query_banners->bindParam(":alt", $alt);
					$djax_query_banners->bindParam(":statustext", $statustext);
					$djax_query_banners->bindParam(":bannertext", $txtimgbelow);
				}

				if ($storagetype == 'url') {

					$djax_query_banners->bindParam(":imageurl", $url_banner_imageurl);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);
					$djax_query_banners->bindParam(":contenttype", $contenttype);
					$djax_query_banners->bindParam(":alt", $alt);
					$djax_query_banners->bindParam(":statustext", $statustext);
					$djax_query_banners->bindParam(":bannertext", $txtimgbelow);
				}

				if ($storagetype == 'txt') {
					$djax_query_banners->bindParam(":bannertext", $bannertext);
					$djax_query_banners->bindParam(":statustext", $statustext);
				}

				$djax_query_banners->bindParam(":bannerid", $bannerid);
				$djax_query_banners->bindParam(":description", $description);

				$djax_query_banners->bindParam(":url", $url);

				$djax_query_banners->execute();
			} else {

				///////////////////////////////////////////HTMLBANNER////////////////////////////////////////// 
				//echo "this is html banner";

				if (isset ($input['width'])) {
					$width = $input['width'];
				} else {
					$width = $stmtbanner[0]['width'];
				}

				if (isset ($input['height'])) {
					$height = $input['height'];
				} else {
					$height = $stmtbanner[0]['height'];
				}

				if (isset ($input['weight'])) {
					$weight = $input['weight'];
				} else {
					$weight = $stmtbanner[0]['weight'];
				}

				if (isset ($input['contenttype'])) {
					$contenttype = $input['contenttype'];
				} else {
					$contenttype = $stmtbanner[0]['contenttype'];
				}

				if (isset ($input['url'])) {
					$url = $input['url'];
				} else {
					$url = $stmtbanner[0]['url'];
				}

				if (isset ($input['htmltemplate'])) {
					$htmltemplate = $input['htmltemplate'];
					$htmlcache = '<a href="{clickurl}" target="{target}">' . $htmltemplate . '</a>';
				} else {
					$htmltemplate = $stmtbanner[0]['htmltemplate'];
					$htmlcache = $stmtbanner[0]['htmlcache'];
				}

				if (isset ($input['target'])) {
					$target = $input['target'];
				} else {
					$target = $stmtbanner[0]['target'];
				}

				$ext_bannertype = $stmtbanner[0]['ext_bannertype'];

				if (isset ($input['total_impressions'])) {
					$tot_num_impression = $input['total_impressions'];
				} else {
					$tot_num_impression = $stmtbanner[0]['impressions_total'];
				}

				if (isset ($input['unlimited_impression'])) {
					//~ $unlimit_impression = isset($input['unlimited_impression'])?'t':'f';
					if ($input['unlimited_impression'] == 'true') {
						$unlimit_impression = 't';
					} else {
						$unlimit_impression = 'f';
					}
				} else {
					//~ $unlimit_impression = isset($stmtbanner[0]['impr_unlimited'])?'t':'f';
					if ($stmtbanner[0]['impr_unlimited'] == 't') {
						$unlimit_impression = 't';
					} else {
						$unlimit_impression = 'f';
					}
				}

				if (isset ($input['y_num_impression'])) {
					$limit_y_num_impressions = $input['y_num_impression'];
				} else {
					$limit_y_num_impressions = $stmtbanner[0]['impressions_number'];
				}

				if (isset ($input['impressions_time'])) {
					$impr_time = $input['impressions_time'];
				} else {
					$impr_time = $stmtbanner[0]['impressions_time'];
				}


				if ($storagetype == 'html' && $ext_bannertype == 'bannerTypeHtml:oxHtml:genericHtml') {
					//echo "this is general html banner";

					$editbanner = "update " . $table_prefix . "banners set
						`storagetype`='html',
						`htmltemplate`=:htmltemplate,
						`htmlcache`=:htmlcache,
						`width`=:width,
						`height`=:height,
						`weight`=$weight,
						`url`=:url,
						`description`=:description,
						`updated`=now()
						where bannerid=:bannerid;";

					$djax_query_banners = $this->db->prepare($editbanner);
					$djax_query_banners->bindParam(":bannerid", $bannerid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
					$djax_query_banners->bindParam(":htmlcache", $htmlcache);
					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);

					$djax_query_banners->execute();
				}

				//HTML5 BANNER

				if ($storagetype == 'html' && $ext_bannertype == 'bannerTypeHtml:oxHtml:html5') {
					$file_edit = $input['file_edit'];
					if ($file_edit == 'edited') {

						if (isset ($input['filename'])) {

							/* Source File URL */
							$remote_file_url = $filename;

							include_once ('../../config.php');

							$image_revivepath = $reviveapiPath;

							/* New file name and path for this file */
							$local_file = $image_revivepath . 'test_html5.zip';

							/* Copy the file from source url to server */
							$copy = copy($remote_file_url, $local_file);

							$file = $local_file;

							$path = pathinfo(realpath($file), PATHINFO_DIRNAME);


							$baseurl = explode('/', $path);
							//print_r($baseurl);
							array_pop($baseurl);
							array_pop($baseurl);
							$randfolder = uniqid(); //rand(10000,99999); 
							//$randfolder = 'banner_'.$stmtbanner[0]['bannerid'];
							$furl = implode('/', $baseurl) . "/www/images/" . $randfolder;
							//print_r($furl);

							$zip = new ZipArchive;

							$res = $zip->open($file);

							for ($i = 0; $i < $zip->numFiles; $i++) {
								$kowsi = $zip->getNameIndex($i);
								$fileinfo = pathinfo($kowsi);
								$kowsi = substr_replace($kowsi, "", -1);

								if ($fileinfo['filename'] == 'index') {
									$indexfolder = $fileinfo['dirname'];
								}
							}

							$kowsi = substr($kowsi, 0, strpos($kowsi, "/"));

							if ($kowsi) {

								$html5filename = $randfolder . '/' . $indexfolder;
							} else {

								$html5filename = $randfolder;
							}

							chmod($furl . "/" . $kowsi, 0777);

							if ($res === TRUE) {
								$tt = $zip->extractTo($furl);

								chmod($furl . "/" . $kowsi, 0777);

								$zip->close();
								$local_file = $image_revivepath . $randfolder;
								unlink($local_file);
							} else if ($input['filename']) {
								$randfolder = $input['filename'];
							} else {
								echo "try again with crct zip file";
							}
						}

						$filepathname = $image_revivepath . $html5filename . "/index.html";
						$target = "<head>";
						$target1 = 'var clickTag = "";';

						$newline = "<script>
window.REVIVE = {
getParameter: function (name, defautVal) {
var match = (new RegExp('[?&]' + name + '=([^&]*)')).exec(window.location.search);
return match ? decodeURIComponent(match[1].replace(/\+/g, ' ')) : defautVal;
}
};
</script>";
						$clicktag = 'clickTag = REVIVE.getParameter("clickTag", "");';

						$stats = file($filepathname, FILE_IGNORE_NEW_LINES);
						$offset = array_search($target, $stats) + 1;
						array_splice($stats, $offset, 0, $newline);
						file_put_contents($filepathname, join("\n", $stats));

						$stats1 = file($filepathname, FILE_IGNORE_NEW_LINES);
						$offset1 = array_search($target1, $stats1) + 1;
						if ($offset1 > 1) {
							array_splice($stats1, $offset1, 0, $clicktag);
							file_put_contents($filepathname, join("\n", $stats1));
						}
					} else {
						$html5filename = $input['filename'];
					}


					$editbanner = "update " . $table_prefix . "banners set
						`storagetype`='html',
						`filename`='" . $html5filename . "',
						`width`=:width,
						`height`=:height,
						`weight`=$weight,
						`url`=:url,
						`description`=:description,
						`updated`=now()
						where bannerid=:bannerid";

					$djax_query_banners = $this->db->prepare($editbanner);
					$djax_query_banners->bindParam(":bannerid", $bannerid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":url", $url);

					$djax_query_banners->bindParam(":width", $width);
					$djax_query_banners->bindParam(":height", $height);

					$djax_query_banners->execute();
				} else if ($storagetype == 'html' && $width == -3 && $height == -3 && $ext_bannertype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') {

					$dbparameters = $stmtbanner[0]['parameters'];
					$unparameters = unserialize($dbparameters);
					//print_r($unparameters);

					if (isset ($input['vast_video_clickthrough_url'])) {
						$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
					} else {
						$vast_video_clickthrough_url = $unparameters['vast_video_clickthrough_url'];
					}

					if (isset ($input['vast_video_duration'])) {
						$vast_video_duration = $input['vast_video_duration'];
					} else {
						$vast_video_duration = $unparameters['vast_video_duration'];
					}

					if (isset ($input['vast_video_delivery'])) {
						$vast_video_delivery = $input['vast_video_delivery'];
					} else {
						$vast_video_delivery = $unparameters['vast_video_delivery'];
					}

					if (isset ($input['vast_video_type'])) {
						$vast_video_type = $input['vast_video_type'];
					} else {
						$vast_video_type = $unparameters['vast_video_type'];
					}

					if (isset ($input['vast_companion_banner_id'])) {
						$vast_companion_banner_id = $input['vast_companion_banner_id'];
					} else {
						$vast_companion_banner_id = $unparameters['vast_companion_banner_id'];
					}


					if ($vast_video_delivery == "progressive") {
						if (isset ($input['vast_video_outgoing_filename'])) {
							$vast_video_outgoing_filename = $input['vast_video_outgoing_filename'];
						} else {
							$vast_video_outgoing_filename = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $vast_video_outgoing_filename;
							//$saving_file = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $input['vast_video_outgoing_filename'];
						}
					}

					if ($vast_video_delivery == "streaming") {
						if (isset ($input['vast_net_connection_url'])) {
							$vast_net_connection_url = $input['vast_net_connection_url'];
							$videotype = $input['videotype'];
							$vast_video_filename = $input['vast_video_filename'];
							$qot = ':';
							$vast_video_outgoing_filename = $vast_net_connection_url . $videotype . $qot . $vast_video_filename;
							$saving_file = $vast_net_connection_url . $videotype . ':' . $vast_video_filename;
						} else {
							$vast_video_outgoing_filename = $unparameters['vast_video_outgoing_filename'];
							//$saving_file = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $input['vast_video_outgoing_filename'];
						}
					}

					$var = array ();
					$var = array (
						"banner_vast_element_id" => 'banner_vast_element_id',
						"vast_element_type" => 'singlerow',
						"vast_video_id" => 'N',
						"vast_video_duration" => $vast_video_duration,
						"vast_video_delivery" => $vast_video_delivery,
						"vast_video_type" => $vast_video_type,
						"vast_video_bitrate" => 400,
						"vast_video_height" => 480,
						"vast_video_width" => 640,
						"vast_video_outgoing_filename" => $saving_file,
						"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
						"vast_overlay_height" => 'N',
						"vast_overlay_width" => 'N',
						"vast_overlay_text_title" => 'N',
						"vast_overlay_text_description" => 'N',
						"vast_overlay_text_call" => 'N',
						"vast_overlay_format" => 'N',
						"vast_overlay_action" => 'N',
						"vast_companion_banner_id" => $vast_companion_banner_id,
						"vast_creative_type" => 'N'
					);

					$parameters = serialize($var);

					$editbanner = "update " . $table_prefix . "banners set
						`description`=:description,
						`weight`=$weight,
						`url`=:url,
						`updated`=now(),
						`parameters`=:parameters
						where `bannerid`=:bannerid";

					$djax_query_banners = $this->db->prepare($editbanner);
					$djax_query_banners->bindParam(":bannerid", $bannerid);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":parameters", $parameters);

					$djax_query_banners->execute();

					$editparameters = "update " . $table_prefix . "banner_vast_element set
						`vast_video_duration`=:vast_video_duration,
						`vast_video_delivery`=:vast_video_delivery,
						`vast_video_type`=:vast_video_type,
						`vast_video_outgoing_filename`=:vast_video_outgoing_filename,
						`vast_companion_banner_id`=:vast_companion_banner_id,
						`vast_video_clickthrough_url`=:vast_video_clickthrough_url where `banner_id`=:banner_id ";

					$djax_query_banners_parameters = $this->db->prepare($editparameters);

					$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
					$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);
					$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
					$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
					$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
					$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
					$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
					$djax_query_banners_parameters->execute();

					//$parameterid=$this->db->lastInsertId('banner_vast_element_id');
				} elseif ($storagetype == 'html' && $width == -2 && $height == -2) {
					$dbparameters = $stmtbanner[0]['parameters'];
					$unparameters = unserialize($dbparameters);
					//print_r($dbparameters);
					if (isset ($input['vast_overlay_format'])) {
						$vast_overlay_format = $input['vast_overlay_format'];
					} else {
						$vast_overlay_format = $unparameters['vast_overlay_format'];
					}

					if (isset ($input['vast_video_delivery'])) {
						$vast_video_delivery = $input['vast_video_delivery'];
					} else {
						$vast_video_delivery = $unparameters['vast_video_delivery'];
					}

					if (isset ($input['vast_video_duration'])) {
						$vast_video_duration = $input['vast_video_duration'];
					} else {
						$vast_video_duration = $unparameters['vast_video_duration'];
					}

					if (isset ($input['vast_video_type'])) {
						$vast_video_type = $input['vast_video_type'];
					} else {
						$vast_video_type = $unparameters['vast_video_type'];
					}

					if (isset ($input['vast_thirdparty_impression'])) {
						$vast_thirdparty_impression = $input['vast_thirdparty_impression'];
					} else {
						$vast_thirdparty_impression = $unparameters['vast_thirdparty_impression'];
					}


					if (isset ($input['vast_video_clickthrough_url'])) {
						$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
					} else {
						$vast_video_clickthrough_url = $unparameters['vast_video_clickthrough_url'];
					}

					if (isset ($input['vast_overlay_action'])) {
						$vast_overlay_action = $input['vast_overlay_action'];
					} else {
						$vast_overlay_action = $unparameters['vast_overlay_action'];
					}

					if (isset ($input['vast_companion_banner_id'])) {
						$vast_companion_banner_id = $input['vast_companion_banner_id'];
					} else {
						$vast_companion_banner_id = $unparameters['vast_companion_banner_id'];
					}

					if (isset ($input['vast_overlay_height'])) {
						$vast_overlay_height = $input['vast_overlay_height'];
					} else {
						$vast_overlay_height = $unparameters['vast_overlay_height'];
					}

					if (isset ($input['vast_overlay_width'])) {
						$vast_overlay_width = $input['vast_overlay_width'];
					} else {
						$vast_overlay_width = $unparameters['vast_overlay_width'];
					}

					if (isset ($input['vast_overlay_text_title'])) {
						$vast_overlay_text_title = $input['vast_overlay_text_title'];
					} else {
						$vast_overlay_text_title = $unparameters['vast_overlay_text_title'];
					}

					if (isset ($input['vast_overlay_text_call'])) {
						$vast_overlay_text_description = $input['vast_overlay_text_description'];
					} else {
						$vast_overlay_text_description = $unparameters['vast_overlay_text_description'];
					}

					if (isset ($input['vast_overlay_text_call'])) {
						$vast_overlay_text_call = $input['vast_overlay_text_call'];
					} else {
						$vast_overlay_text_call = $unparameters['vast_overlay_text_call'];
					}

					if (isset ($input['imageurl'])) {
						$imageurl = $input['imageurl'];
						if ($imageurl) {
							$file = fopen($imageurl, "rb");
							if ($file) {

								$valid_exts = array ("jpg", "jpeg", "gif", "png"); // default image only extensions
								$ext = explode(".", strtolower(basename($imageurl)));
								$ext = end($ext);

								$filename = basename($imageurl);
								$new = explode(".", $filename);
								$encryptfilename = md5($new[0]);

								$ac = $encryptfilename . "." . $new[1];
								$c[] = '';

								array_push($c, $ac);
								if (in_array($ext, $valid_exts)) {
									$rand = rand(10000, 99999);
									$newfile = fopen("" . $image_path . "" . $c[1], "wb"); // replace "downloads" with whatever directory you wish.

									if ($newfile) {
										while (!feof($file)) {
											// Write the url file to the directory.
											fwrite($newfile, fread($file, 1024 * 8), 1024 * 8); // write the file to the new directory at a rate of 8kb/sec. until we reach the end.
										}
									}
								}
							}
						}
					} else {
						$ac = '';
					}


					if ($vast_video_delivery == "progressive") {
						if (isset ($input['vast_video_outgoing_filename'])) {
							$vast_video_outgoing_filename = $input['vast_video_outgoing_filename'];
						} else {
							$vast_video_outgoing_filename = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $vast_video_outgoing_filename;
							//$saving_file = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $input['vast_video_outgoing_filename'];
						}
					}

					if ($vast_video_delivery == "streaming") {
						if (isset ($input['vast_net_connection_url'])) {
							$vast_net_connection_url = $input['vast_net_connection_url'];
							$videotype = $input['videotype'];
							$vast_video_filename = $input['vast_video_filename'];
							$qot = ':';
							$vast_video_outgoing_filename = $vast_net_connection_url . $videotype . $qot . $vast_video_filename;
							$saving_file = $vast_net_connection_url . $videotype . ':' . $vast_video_filename;
						} else {
							$vast_video_outgoing_filename = $unparameters['vast_video_outgoing_filename'];
							//$saving_file = $unparameters['vast_video_outgoing_filename'];
							$saving_file = $input['vast_video_outgoing_filename'];
						}
					}
					//print_r($saving_file);
					$var = array ();
					$var = array (
						"banner_vast_element_id" => 'banner_vast_element_id',
						"vast_element_type" => 'singlerow',
						"vast_video_id" => 'N',
						"vast_video_duration" => $vast_video_duration,
						"vast_video_delivery" => $vast_video_delivery,
						"vast_video_type" => $vast_video_type,
						"vast_video_bitrate" => 400,
						"vast_video_height" => 480,
						"vast_video_width" => 640,
						"vast_video_outgoing_filename" => $saving_file,
						"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
						"vast_overlay_height" => $vast_overlay_height,
						"vast_overlay_width" => $vast_overlay_width,
						"vast_overlay_text_title" => $vast_overlay_text_title,
						"vast_overlay_text_description" => $vast_overlay_text_description,
						"vast_overlay_text_call" => $vast_overlay_text_call,

						"vast_overlay_format" => $vast_overlay_format,
						"vast_overlay_action" => $vast_overlay_action,
						"vast_companion_banner_id" => $vast_companion_banner_id,
						"vast_creative_type" => '',
						"vast_thirdparty_impression" => $vast_thirdparty_impression
					);

					$parameter = serialize($var);

					$editbanner = "update " . $table_prefix . "banners set
						`filename`=:filename,
						`htmlcache` =:htmlcache,
						`htmltemplate`=:htmltemplate,
						`weight`=$weight,
						`url`=:url,
						`description`=:description,
						`parameters`=:parameters
						where bannerid=:bannerid";

					$djax_query_banners = $this->db->prepare($editbanner);

					if ($ac) {
						$djax_query_banners->bindParam(":filename", $ac);
					} else {
						$djax_query_banners->bindParam(":filename", $imageurl);
					}
					$djax_query_banners->bindParam(":url", $url);
					$djax_query_banners->bindParam(":htmlcache", $htmlcache);
					$djax_query_banners->bindParam(":htmltemplate", $htmltemplate);
					$djax_query_banners->bindParam(":description", $description);
					$djax_query_banners->bindParam(":parameters", $parameter);
					$djax_query_banners->bindParam(":bannerid", $bannerid);

					$djax_query_banners->execute();

					$banner_vast_element_id = 40;

					$editparameters = "update " . $table_prefix . "banner_vast_element set
						`vast_video_duration`=:vast_video_duration,
						`vast_video_delivery`=:vast_video_delivery,
						`vast_video_type`=:vast_video_type,
						`vast_video_outgoing_filename`=:vast_video_outgoing_filename,
						`vast_companion_banner_id`=:vast_companion_banner_id,
						`vast_overlay_height`=:vast_overlay_height,
						`vast_overlay_width`=:vast_overlay_width,
						`vast_video_clickthrough_url`=:vast_video_clickthrough_url,
						`vast_overlay_action`=:vast_overlay_action,
						`vast_overlay_format`=:vast_overlay_format,
						`vast_overlay_text_title`=:vast_overlay_text_title,
						`vast_overlay_text_description`=:vast_overlay_text_description,
						`vast_overlay_text_call`=:vast_overlay_text_call,
						`vast_creative_type`=:vast_creative_type,
						`vast_thirdparty_impression`=:vast_thirdparty_impression		
						where banner_id=:banner_id";

					$djax_query_banners_parameters = $this->db->prepare($editparameters);

					$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
					$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
					$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);

					$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);

					$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $saving_file);
					$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
					$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
					$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
					$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);

					$djax_query_banners_parameters->bindParam(":vast_overlay_format", $vast_overlay_format);
					$djax_query_banners_parameters->bindParam(":vast_overlay_action", $vast_overlay_action);

					$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
					$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);

					$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
					$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);

					$djax_query_banners_parameters->execute();
				}
			}
			
            //audit log maintain
			$update_user_id = $_SESSION['user_id'];
			$module = 'banners_'.$description.'_'.$bannerid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `update_user_id`,  `updated_date`) VALUES (:module,:update_user_id,:updated_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":update_user_id", $update_user_id);
			$audit->bindParam(":updated_date", $datetime);
			$audit->execute();
			
			$response = array ('response' => 'success', 'statuscode' => '200', 'msg' => 'Banner Updated Successfully');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid bannerid');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('banneradd_edit'));


$app->post('/set_limitation/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;

		//~ return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$req = "select *  from " . $table_prefix . "banners WHERE bannerid=:bannerid";

		// print_r($req);die("ddf");
		$cam = $this->db->prepare($req);
		$cam->bindParam("bannerid", $args['bannerid']);
		$cam->execute();
		$campaign = $cam->fetchAll();

		if (!$campaign) {
			$res = array (
				'response' => 'error',
				'msg' => 'Bannerid is not valid.'
			);
			return $this->response->withJson($res);
		}


		$bannerid = "select bannerid  from " . $table_prefix . "banners WHERE bannerid=:bannerid";
		$bnr = $this->db->prepare($bannerid);
		$bnr->bindParam("bannerid", $args['bannerid']);
		$bnr->execute();
		$banner = $bnr->fetchAll();
		$data['compiledlimitation'] = '';
		$data['acl_plugins'] = '';

		if (!$banner) {
			$res = array (
				'response' => 'error',
				'msg' => 'No banner under this campaignid!Atleast one banner required for campaign targetting!'
			);
			return $this->response->withJson($res);
		}
		$comparison = array ('==', '!=', '=~', '!~', '=x', '!x', 'gt', 'lt', 'le', 'ge', '>', '<', '>=', '<=', 'nn');

		foreach ($input['data'] as $inp) {
			//print_r($inp['type']);
			if (($inp['type'])) {

				if (!in_array($inp['comparison'], $comparison)) {

					$response = array (
						'response' => 'error',
						'msg' => 'Comparision operator passed in array is not supported!'
					);

					return $this->response->withJson($response);
				}
			}
		}


		foreach ($banner as $dat) {
			$executionid = "Delete from " . $table_prefix . "acls WHERE bannerid=:bannerid";
			$bnr = $this->db->prepare($executionid);
			$bnr->bindParam("bannerid", $dat['bannerid']);
			$bnr->execute();
		}


		foreach ($banner as $dat) {

			if ($input['data']) {
				foreach ($input['data'] as $inp) {

					//set function name using delivery limitations


					switch ($inp['type']) {

						case 'deliveryLimitations:Client:Browser':
							$function_name = 'MAX_checkClient_Browser';
							$string_compare = 'Client:Browser';
							break;
						case 'deliveryLimitations:Client:BrowserVersion':
							$function_name = 'MAX_checkClient_BrowserVersion';
							$string_compare = 'Client:BrowserVersion';
							break;
						case 'deliveryLimitations:Client:Domain':
							$function_name = 'MAX_checkClient_Domain';
							$string_compare = 'Client:Domain';
							break;
						case 'deliveryLimitations:Client:Ip':
							$function_name = 'MAX_checkClient_Ip';
							$string_compare = 'Client:Ip';
							break;
						case 'deliveryLimitations:Client:Language':
							$function_name = 'MAX_checkClient_Language';
							$string_compare = 'Client:Language';
							break;
						case 'deliveryLimitations:Client:Os':
							$function_name = 'MAX_checkClient_Os';
							$string_compare = 'Client:Os';
							break;
						case 'deliveryLimitations:Client:OsVersion':
							$function_name = 'MAX_checkClient_OsVersion';
							$string_compare = 'Client:OsVersion';
							break;
						case 'deliveryLimitations:Client:Useragent':
							$function_name = 'MAX_checkClient_Useragent';
							$string_compare = 'Client:Useragent';
							break;
						case 'deliveryLimitations:Site:Channel':
							$function_name = 'MAX_checkSite_Channel';
							$string_compare = 'Site:Channel';
							break;
						case 'deliveryLimitations:Site:Pageurl':
							$function_name = 'MAX_checkSite_Pageurl';
							$string_compare = 'Site:Pageurl';
							break;

						case 'deliveryLimitations:Site:Referingpage':
							$function_name = 'MAX_checkSite_Referingpage';
							$string_compare = 'Site:Referingpage';
							break;
						case 'deliveryLimitations:Site:Registerabledomainlist':
							$function_name = 'MAX_checkSite_Registerabledomainlist';
							$string_compare = 'Site:Registerabledomainlist';
							break;
						case 'deliveryLimitations:Site:Hostnamelist':
							$function_name = 'MAX_checkSite_Hostnamelist';
							$string_compare = 'Site:Hostnamelist';
							break;
						case 'deliveryLimitations:Site:Source':
							$function_name = 'MAX_checkSite_Source';
							$string_compare = 'Site:Source';
							break;
						case 'deliveryLimitations:Site:Variable':
							$function_name = 'MAX_checkSite_Variable';
							$string_compare = 'Site:Variable';
							break;
						case 'deliveryLimitations:Time:Date':
							$function_name = 'MAX_checkTime_Date';
							$string_compare = 'Time:Date';
							break;
						case 'deliveryLimitations:Time:Day':
							$function_name = 'MAX_checkTime_Day';
							$string_compare = 'Time:Day';
							break;
						case 'deliveryLimitations:Time:Hour':
							$function_name = 'MAX_checkTime_Hour';
							$string_compare = 'Time:Hour';
							break;
						case 'deliveryLimitations:Geo:Areacode':
							$function_name = 'MAX_checkGeo_Areacode';
							$string_compare = 'Geo:Areacode';
							break;
						case 'deliveryLimitations:Geo:City':
							$function_name = 'MAX_checkGeo_City';
							$string_compare = 'Geo:City';
							break;
						case 'deliveryLimitations:Geo:Country':
							$function_name = 'MAX_checkGeo_Country';
							$string_compare = 'Geo:Country';
							break;
						case 'deliveryLimitations:Geo:Dma':
							$function_name = 'MAX_checkGeo_Dma';
							$string_compare = 'Geo:Dma';
							break;
						case 'deliveryLimitations:Geo:Latlong':
							$function_name = 'MAX_checkGeo_Latlong';
							$string_compare = 'Geo:Latlong';
							break;
						case 'deliveryLimitations:Geo:Netspeed':
							$function_name = 'MAX_checkGeo_Netspeed';
							$string_compare = 'Geo:Netspeed';
							break;
						case 'deliveryLimitations:Geo:Organisation':
							$function_name = 'MAX_checkGeo_Organisation';
							$string_compare = 'Geo:Organisation';
							break;
						case 'deliveryLimitations:Geo:Postalcode':
							$function_name = 'MAX_checkGeo_Postalcode';
							$string_compare = 'Geo:Postalcode';
							break;
						case 'deliveryLimitations:Geo:Region':
							$function_name = 'MAX_checkGeo_Region';
							$string_compare = 'Geo:Region';
							break;
						case 'deliveryLimitations:Geo:Continent':
							$function_name = 'MAX_checkGeo_Continent';
							$string_compare = 'Geo:Continent';
							break;
						case 'deliveryLimitations:Geo:ConnectionType':
							$function_name = 'MAX_checkGeo_ConnectionType';
							$string_compare = 'Geo:ConnectionType';
							break;
						case 'deliveryLimitations:Geo:Subdivision1':
							$function_name = 'MAX_checkGeo_Subdivision1';
							$string_compare = 'Geo:Subdivision1';
							break;
						case 'deliveryLimitations:Geo:Subdivision2':
							$function_name = 'MAX_checkGeo_Subdivision2';
							$string_compare = 'Geo:Subdivision2';
							break;
						case 'deliveryLimitations:Geo:UsMetro':
							$function_name = 'MAX_checkGeo_UsMetro';
							$string_compare = 'Geo:UsMetro';
							break;
						case 'deliveryLimitations:Parameter:Brandsafety':
							$function_name = 'MAX_checkParameter_Brandsafety';
							$string_compare = 'Parameter:Brandsafety';
							break;
						default:
							$function_name = 'Empty';
							$string_compare = 'Empty';
							break;
					}


					//Insert values into ".$table_prefix."acls table
					//select maximum values from the table
					$executionid = "select MAX(executionorder) as execid,data  from " . $table_prefix . "acls WHERE bannerid=:bannerid";
					$bnr = $this->db->prepare($executionid);
					$bnr->bindParam("bannerid", $dat['bannerid']);
					$bnr->execute();
					$bnr_exec = $bnr->fetchAll();
					if ($bnr_exec['0']['data']) {
						$bnr_exec['0']['execid'] += 1;
					} else {
						$bnr_exec['0']['execid'] = 0;
					}

					if ($inp["type"]) {

						if ($inp["type"] == 'deliveryLimitations:Time:Date') {
							$application_variable_sql = "SELECT value FROM " . $table_prefix . "application_variable WHERE name = 'admin_account_id'";
							$sth1 = $this->db->prepare($application_variable_sql);
							$sth1->execute();
							$application = $sth1->fetchAll();
							$adminAccountId = $application['0']['value'];
							$preference_id = "SELECT preference_id FROM " . $table_prefix . "preferences WHERE preference_name = 'timezone'";
							$sth2 = $this->db->prepare($preference_id);
							$sth2->execute();
							$preference = $sth2->fetchAll();
							$tzId = $preference['0']['preference_id'];
							$value = "SELECT value FROM " . $table_prefix . "account_preference_assoc WHERE preference_id = {$tzId} AND account_id = {$adminAccountId}";
							$sth3 = $this->db->prepare($value);
							$sth3->execute();
							$account_preference = $sth3->fetchAll();
							$tzPart = $account_preference['0']['value'];

							$res = str_replace(array ('-'), '', $inp['data']);

							$inp["data"] = $res . '@' . $tzPart;
						}
						if ($inp["type"] == 'deliveryLimitations:Parameter:Brandsafety') {
							$sql = "INSERT INTO " . $table_prefix . "acls (bannerid,type,comparison,data,executionorder) VALUES (:bannerid,:type,:comparison,:data,:executionorder)";
							$sth = $this->db->prepare($sql);
							$sth->bindParam("bannerid", $dat['bannerid']);
							//$sth->bindParam("logic", $inp['logical']); ,:logic
							$sth->bindParam("type", $inp['type']);
							$sth->bindParam("comparison", $inp['comparison']);
							$sth->bindParam("data", $inp['data']);
							$sth->bindParam("executionorder", $bnr_exec['0']['execid']);
							$sth->execute();
						} else {
							//Insert values into ".$table_prefix."acls table
							$sql = "INSERT INTO " . $table_prefix . "acls (bannerid,logical,type,comparison,data,executionorder) VALUES (:bannerid,:logic,:type,:comparison,:data,:executionorder)";
							$sth = $this->db->prepare($sql);
							$sth->bindParam("bannerid", $dat['bannerid']);
							$sth->bindParam("logic", $inp['logical']);
							$sth->bindParam("type", $inp['type']);
							$sth->bindParam("comparison", $inp['comparison']);
							$sth->bindParam("data", $inp['data']);
							$sth->bindParam("executionorder", $bnr_exec['0']['execid']);
							$sth->execute();
						}



						if ($inp["type"]) {

							//continent-geo


							if ($inp["type"] == 'deliveryLimitations:Geo:Continent') {
								$inp["data"] = explode(",", $inp["data"]);

								$continent_array = array ();
								foreach ($inp["data"] as $kk => $test_limit) {
									if ($test_limit == "AF") {
										$con_val = 'ao,bf,bi,bj,bw,cd,cf,cg,ci,cm,cv,dj,dz,eg,eh,er,et,ga,gh,gm,gn,gq,gw,ke,km,lr,ls,ly,ma,mg,ml,mr,mu,mw,mz,na,ne,ng,re,rw,sc,sd,sh,sl,sn,so,st,sz,td,tg,tn,tz,ug,yt,za,zm,zw,ss';
									}
									if ($test_limit == "IN") {
										$con_val = 'kowsi';
									}
									if ($test_limit == "AQ") {
										$con_val = '';
									}
									if ($test_limit == "CA") {
										$con_val = '';
									}
									if ($test_limit == "AS") {
										$con_val = 'ap,ae,af,am,az,bd,bh,bn,bt,cc,cn,cx,cy,ge,hk,id,il,in,io,iq,ir,jo,jp,kg,kh,kp,kr,kw,kz,la,lb,lk,mm,mn,mo,mv,my,np,om,ph,pk,ps,qa,sa,sg,sy,th,tj,tm,tl,tw,uz,vn,ye';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "NA") {
										$con_val = 'ag,ai,cw,aw,bb,bm,bs,bz,ca,cr,cu,dm,do,sx,gd,gl,gp,gt,hn,ht,jm,kn,ky,lc,mq,ms,mx,ni,pa,pm,pr,sv,tc,tt,us,vc,vg,vi,bl,mf,bq';
									}
									if ($test_limit == "OC") {
										$con_val = 'as,au,ck,fj,fm,gu,ki,mh,mp,nc,nf,nr,nu,nz,pf,pg,pn,pw,sb,tk,to,tv,um,vu,wf,ws';
									}
									if ($test_limit == "SA") {
										$con_val = 'ar,bo,br,cl,co,ec,fk,gf,gy,pe,py,sr,uy,ve';
									}
									if ($test_limit == "AN") {
										$con_val = 'bv,gs,hm,tf';
									}

									$continent_array[] = $con_val;
								}
								$inp["data"] = implode(",", array_filter($continent_array));
							}

							//end

							if ($inp["type"] == 'deliveryLimitations:Geo:City') {
								$inp["data"] = strtolower($inp["data"]);
							}
							if ($inp["type"] == 'deliveryLimitations:Geo:Region') {
								$inp["data"] = strtolower($inp["data"]);
							}

							if ($data['compiledlimitation'] && $data['acl_plugins']) {
								$data['compiledlimitation'] .= ' ' . $inp["logical"] . " " . $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$chk = '"' . $inp["type"] . '"';
								if (strpos(strtolower($data["acl_plugins"]), strtolower($string_compare)) == false) {

									$data["acl_plugins"] .= ',' . $inp["type"];
								}
							} else {
								$data["compiledlimitation"] .= $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$data["acl_plugins"] .= $inp["type"];
							}
						} else {
							$data['compiledlimitation'] = '';
							$data['acl_plugins'] = '';
						}
					} else {
						$data['compiledlimitation'] = '';
						$data['acl_plugins'] = '';
					}

					$sqlupdate = "UPDATE " . $table_prefix . "banners SET compiledlimitation=:check,acl_plugins=:type WHERE bannerid=:bannerid";
					$stc = $this->db->prepare($sqlupdate);
					$stc->bindParam("type", $data['acl_plugins']);
					$stc->bindParam("check", $data['compiledlimitation']);
					$stc->bindParam("bannerid", $dat['bannerid']);
					$stc->execute();
				}
			} else if (empty ($input['data'])) {

				$sqlupdate = "UPDATE " . $table_prefix . "banners SET compiledlimitation=:check,acl_plugins=:type WHERE bannerid=:bannerid";
				$stc = $this->db->prepare($sqlupdate);
				$stc->bindParam("type", $data['acl_plugins']);
				$stc->bindParam("check", $data['compiledlimitation']);
				$stc->bindParam("bannerid", $dat['bannerid']);
				$stc->execute();

				$res = array (
					'response' => 'ok',
					'msg' => 'Banner delivery limitations has been updated successfully'
				);
			} else {

				$res = array (
					'response' => 'error',
					'msg' => 'Please check with input parameters'
				);
				return $this->response->withJson($res);
			}
		}

		$res = array (
			'response' => 'ok',
			'msg' => 'Banner delivery limitations has been updated successfully'
		);
		return $this->response->withJson($res);
		return $response;
	}
})->add($container->get('limitValidation'));

//Delivery Option Get Limitation

$app->get('/get_limitation/[{bannerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid = $args['bannerid'];
	$getlimitation = "SELECT * from " . $table_prefix . "acls where bannerid=:bannerid";
	$djax_query_getlimitation = $this->db->prepare($getlimitation);
	$djax_query_getlimitation->bindParam(":bannerid", $bannerid);
	$djax_query_getlimitation->execute();
	$stmtlimitations = $djax_query_getlimitation->fetchAll();
	$num = count($stmtlimitations);
	$banner_limitationdetail = array ();
	if (count($stmtlimitations) > 0) {
		foreach ($stmtlimitations as $limitations) {
			$banner_limitationdetail[] = array (
				'bannerid' => $limitations['bannerid'],
				'data' => $limitations['data'],
				'type' => $limitations['type'],
				'comparison' => $limitations['comparison'],
				'executionorder' => $limitations['executionorder'],
				'logical' => $limitations['logical']
			);
		}
		$response = array (
			'data' => $banner_limitationdetail,
			'response' => 'success',
			'successcode' => '200'
		);

		return $this->response->withJson($response);
	} else {
		$results = array ('response' => 'Error', 'ERROR' => 'No limitations available for the bannerid provided!');
		return $this->response->withJson($results);
	}
});

//Channel Delivery Option Get Limitation

$app->get('/get_taget_limitation/[{channelid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$channelid = $args['channelid'];
	$getlimitation = "SELECT * from " . $table_prefix . "acls_channel where channelid=:channelid";
	$djax_query_getlimitation = $this->db->prepare($getlimitation);
	$djax_query_getlimitation->bindParam(":channelid", $channelid);
	$djax_query_getlimitation->execute();
	$stmtlimitations = $djax_query_getlimitation->fetchAll();
	$num = count($stmtlimitations);
	$banner_limitationdetail = array ();
	if (count($stmtlimitations) > 0) {
		foreach ($stmtlimitations as $limitations) {
			$banner_limitationdetail[] = array (
				'channelid' => $limitations['channelid'],
				'data' => $limitations['data'],
				'type' => $limitations['type'],
				'comparison' => $limitations['comparison'],
				'executionorder' => $limitations['executionorder'],
				'logical' => $limitations['logical']
			);
		}
		$response = array (
			'data' => $banner_limitationdetail,
			'response' => 'success',
			'successcode' => '200'
		);

		return $this->response->withJson($response);
	} else {
		$results = array ('response' => 'Error', 'ERROR' => 'No limitations available for the channelid provided!');
		return $this->response->withJson($results);
	}
});

$app->post('/set_capping/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$getzone = "select * from {$table_prefix}banners where bannerid=:bannerid";
		$zonedata = $this->db->prepare($getzone);
		$zonedata->bindParam(":bannerid", $bannerid);
		$zonedata->execute();
		$stmt = $zonedata->fetchAll();

		$block = $input['block'];
		$capping = $input['capping'];
		$session_capping = $input['session_capping'];


		if (count($stmt) > 0) {
			$updatebanners = "update  {$table_prefix}banners set `block`=$block,`capping`=$capping,`session_capping`=$session_capping,`updated`=now() where `bannerid`=:bannerid;";

			$banner_data = $this->db->prepare($updatebanners);
			$banner_data->bindParam(":bannerid", $bannerid);

			$banner_data->execute();

			$response = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'Banner Capping updated successfully'
			);
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Requested banner id doesnot found!'
			);
		}
		return $this->response->withJson($response);
	}
});

$app->get('/get_capping/[{bannerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid = $args['bannerid'];
	$getlimitation = "SELECT * from " . $table_prefix . "banners where bannerid=:bannerid";
	$djax_query_getlimitation = $this->db->prepare($getlimitation);
	$djax_query_getlimitation->bindParam(":bannerid", $bannerid);
	$djax_query_getlimitation->execute();
	$stmtlimitations = $djax_query_getlimitation->fetchAll();
	$num = count($stmtlimitations);
	$banner_limitationdetail = array ();
	if (count($stmtlimitations) > 0) {
		foreach ($stmtlimitations as $limitations) {
			$banner_limitationdetail = array (
				'bannerid' => $limitations['bannerid'],
				'block' => $limitations['block'],
				'capping' => $limitations['capping'],
				'session_capping' => $limitations['session_capping']
			);
		}
		$response = array (
			'data' => $banner_limitationdetail,
			'response' => 'success',
			'successcode' => '200'
		);

		return $this->response->withJson($response);
	} else {
		$results = array ('response' => 'Error', 'ERROR' => 'No limitations available for the bannerid provided!');
		return $this->response->withJson($results);
	}
});



$app->delete('/deletebanner_all_limitation/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$bannerid = $args['bannerid'];
		$referchannel = "select * from  {$table_prefix}acls where bannerid=:bannerid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":bannerid", $bannerid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();


		if (count($stmtchannel) > 0) {

			$deletechannel = "update {$table_prefix}banners set compiledlimitation='true' , acl_plugins='' where bannerid=:bannerid";
			$djax_query_deletechannel = $this->db->prepare($deletechannel);
			$djax_query_deletechannel->bindParam(":bannerid", $bannerid);
			$djax_query_deletechannel->execute();


			$deleteacls = "DELETE FROM  {$table_prefix}acls WHERE bannerid=:bannerid";
			$djax_query_deleteacls = $this->db->prepare($deleteacls);
			$djax_query_deleteacls->bindParam(":bannerid", $bannerid);
			$djax_query_deleteacls->execute();


			$response = array ('response' => 'ok', 'msg' => 'all limitation  under banner Successfully deleted');
		} else {

			$response = array ('response' => 'error', 'msg' => 'Requested bannerid not found');
		}
	}



	return $this->response->withJson($response);
});




/*
 * Get Camapaignwise Banner details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->get('/get_campaignwise_banner/[{campaignid},{bannerlist_option}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$campaignid = $args['campaignid'];
	$bannerlistoption = $args['bannerlist_option'];

	$TimeZone = "select a.value as timezone from
		" . $table_prefix . "account_preference_assoc as a,
		" . $table_prefix . "clients as cl,
		" . $table_prefix . "campaigns as c,
		" . $table_prefix . "agency as ag
		where
		c.clientid = cl.clientid
		AND cl.agencyid = ag.agencyid
		AND ag.account_id = a.account_id
		AND a.preference_id = 16
		AND c.campaignid =" . $campaignid;
	$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
	$TimeZonestd->execute();

	$TimeZoneRow = $TimeZonestd->fetchAll();


	if ($TimeZoneRow) {

		$timezone = $TimeZoneRow[0]['timezone'];
	} else {

		$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
		$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
		$TimeZonestd->execute();
		$TimeZoneRow = $TimeZonestd->fetchAll();
		if($TimeZoneRow){
			$timezone = $TimeZoneRow[0]['timezone'];
			}
			else{
				$timezone = 'UTC';

			}
	}
	if($timezone=='0'){
		$timezone = 'UTC';

	}
	else{
		$timezone = $timezone;

	}
	date_default_timezone_set($timezone);


	// $date1 = date("d-m-Y H:i:s");
	// date_default_timezone_set('UTC');
	// $date2 = date("d-m-Y H:i:s");
	// $time_diff = strtotime($date1) - strtotime($date2);
	// $date3 = date('H:i', $time_diff);

	// $date4 = '+'.$date3;


	$tz = new DateTimeZone($timezone);
	$offset = $tz->getOffset(new DateTime());

	// Convert offset to hours and minutes
	$offsetHours = floor($offset / 3600);
	$offsetMinutes = floor(($offset % 3600) / 60);

	// Determine the GMT offset string
	$gmtOffset = sprintf('%+03d:%02d', $offsetHours, $offsetMinutes);
	if ($bannerlistoption == 0) {
		$banner_list = "select campaignid,bannerid,description,storagetype,width,height,IF(url='','-',url) url,ext_bannertype,filename,DATE_FORMAT(CONVERT_TZ(updated,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as updated,status from " . $table_prefix . "banners where campaignid=:campaignid and status = 0 Order by updated Desc";
	} else {
		$banner_list = "select campaignid,bannerid,description,storagetype,width,height,IF(url='','-',url) url,ext_bannertype,filename,DATE_FORMAT(CONVERT_TZ(updated,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as updated,status from " . $table_prefix . "banners where campaignid=:campaignid Order by updated Desc";
	}
	$allbanners_det = $this->db->prepare($banner_list);
	$allbanners_det->bindParam(":campaignid", $campaignid);
	$allbanners_det->execute();
	$bannerdetails = $allbanners_det->fetchAll();
	$num = count($bannerdetails);

	if ($num > 0) {

		foreach ($bannerdetails as $banner) {
			if ($banner['storagetype'] == 'web') {
				$ext_bannertype = $banner['storagetype'];
			} else if ($banner['storagetype'] == 'sql') {
				$ext_bannertype = $banner['storagetype'];
			} else if ($banner['storagetype'] == 'url') {
				$ext_bannertype = $banner['storagetype'];
			} else {
				$ext_bannertype = $banner['ext_bannertype'];
			}
			$bannerdetailsarray[] = array (
				'campaignid' => $banner['campaignid'],
				'bannerid' => $banner['bannerid'],
				'description' => $banner['description'],
				'filename' => $banner['filename'],
				'storagetype' => $banner['storagetype'],
				'width' => $banner['width'],
				'height' => $banner['height'],
				'url' => $banner['url'],
				'ext_bannertype' => $ext_bannertype,
				'updated' => $banner['updated'],
				'status' => $banner['status'],
			);
		}

		if ($bannerdetails) {
			$response = array ('data' => $bannerdetailsarray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
			return $this->response->withJson($response);
		}
	} else {
		$results = array ('response' => 'error', 'msg' => 'Requested banner not available', 'statuscode' => '200');
		return $this->response->withJson($results);
	}
});

//Companion Banner

$app->get('/get_campaignwise_companion_banner/[{campaignid}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$campaignid = $args['campaignid'];
	$banner_list = "select campaignid,bannerid,description,storagetype,width,height,IF(url='','-',url) url,ext_bannertype,updated,status from " . $table_prefix . "banners where campaignid=:campaignid and width not in ('-3','-2')";
	$allbanners_det = $this->db->prepare($banner_list);
	$allbanners_det->bindParam(":campaignid", $campaignid);
	$allbanners_det->execute();
	$bannerdetails = $allbanners_det->fetchAll();
	$num = count($bannerdetails);

	if ($num > 0) {

		foreach ($bannerdetails as $banner) {
			$bannername = $banner['description'] . ' (' . $banner['width'] . 'X' . $banner['height'] . ')';
			$bannerdetailsarray[] = array (
				'bannerid' => $banner['bannerid'],
				'bannername' => $bannername,
			);
		}

		if ($bannerdetails) {
			$response = array ('data' => $bannerdetailsarray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
			return $this->response->withJson($response);
		}
	} else {
		$results = array ('response' => 'error', 'msg' => 'Requested campaign not available');
		return $this->response->withJson($results);
	}
});

$app->get('/get_campaignsizewise_banner/[{campaignid},{zoneid}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$campaignid = $args['campaignid'];
	$zoneid = $args['zoneid'];

	$stc = "SELECT * FROM " . $table_prefix . "zones where zoneid =" . $zoneid;
	$std = $this->db->prepare($stc);
	$std->execute();
	$zone_det = $std->fetchAll();


	if (count($zone_det) <= 0) {
		$response = array ('response' => 'error', 'msg' => 'Enter valid zoneid!');
		return $this->response->withJson($response);
	} else {
		$zonewidth = $zone_det[0]['width'];
		$zoneheight = $zone_det[0]['height'];
		if ($zonewidth == '-1' && $zoneheight == '-1') {
			$banner_list = "select campaignid,bannerid,description,storagetype,width,height,IF(url='','-',url) url,updated,status from " . $table_prefix . "banners where campaignid=:campaignid and storagetype NOT IN ('txt')";

			$allbanners_det = $this->db->prepare($banner_list);
			$allbanners_det->bindParam(":campaignid", $campaignid);
			$allbanners_det->execute();
			$bannerdetails = $allbanners_det->fetchAll();
			$num = count($bannerdetails);

			if ($num > 0) {
				if ($bannerdetails) {
					$response = array ('data' => $bannerdetails, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
					return $this->response->withJson($response);
				}
			} else {
				$results = array ('response' => 'error', 'msg' => 'Requested campaign not available');
				return $this->response->withJson($results);
			}
		} else {
			$banner_list = "select campaignid,bannerid,description,storagetype,width,height,IF(url='','-',url) url,updated,status from " . $table_prefix . "banners where campaignid=:campaignid and width=:zonewidth and height=:zoneheight";

			$allbanners_det = $this->db->prepare($banner_list);
			$allbanners_det->bindParam(":campaignid", $campaignid);
			$allbanners_det->bindParam(":zonewidth", $zonewidth);
			$allbanners_det->bindParam(":zoneheight", $zoneheight);
			$allbanners_det->execute();
			$bannerdetails = $allbanners_det->fetchAll();
			$num = count($bannerdetails);

			if ($num > 0) {
				if ($bannerdetails) {
					$response = array ('data' => $bannerdetails, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
					return $this->response->withJson($response);
				}
			} else {
				$results = array ('response' => 'error', 'msg' => 'Requested campaign not available');
				return $this->response->withJson($results);
			}
		}
	}
});
/*
 * Get Client Banner details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */

$app->get('/get_all_banner/[{clientid},{bannerlist_option}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$clientid = $args['clientid'];
	$bannerlistoption = $args['bannerlist_option'];
	if ($bannerlistoption == 0) {
		$banner_list = "select ban.campaignid,ban.bannerid,ban.description,ban.filename,ban.storagetype,ban.width,ban.height,IF(ban.url='','-',ban.url) url,ban.ext_bannertype,DATE_FORMAT(ban.updated,'%d-%m-%Y %h:%i:%s') as updated,ban.status 
		from " . $table_prefix . "banners ban," . $table_prefix . "campaigns as cam where cam.campaignid = ban.campaignid and cam.clientid=:clientid and ban.status= 0 group by ban.bannerid Order by ban.updated Desc";
	} else {
		$banner_list = "select ban.campaignid,ban.bannerid,ban.description,ban.filename,ban.storagetype,ban.width,ban.height,IF(ban.url='','-',ban.url) url,ban.ext_bannertype,DATE_FORMAT(ban.updated,'%d-%m-%Y %h:%i:%s') as updated,ban.status 
		from " . $table_prefix . "banners ban," . $table_prefix . "campaigns as cam where cam.campaignid = ban.campaignid and cam.clientid=:clientid  group by ban.bannerid Order by ban.updated Desc";
	}
	$allbanners_det = $this->db->prepare($banner_list);
	$allbanners_det->bindParam(":clientid", $clientid);
	$allbanners_det->execute();
	$bannerdetails = $allbanners_det->fetchAll();
	$num = count($bannerdetails);
	//,CONCAT(ban.width,' * ',ban.height) as size	
	if ($num > 0) {
		foreach ($bannerdetails as $banner) {
			if ($banner['storagetype'] == 'web') {
				$ext_bannertype = $banner['storagetype'];
			} else if ($banner['storagetype'] == 'sql') {
				$ext_bannertype = $banner['storagetype'];
			} else if ($banner['storagetype'] == 'url') {
				$ext_bannertype = $banner['storagetype'];
			} else {
				$ext_bannertype = $banner['ext_bannertype'];
			}
			if ($_SERVER["HTTPS"] == "on") {
				$https = 'https';
			} else {
				$https = 'http';
			}
			$image_path = $https . '://' . $this->get('settings')['path']['image_path'];
			if ($banner['filename'] || $banner['storagetype'] == 'web' || $banner['storagetype'] == 'sql' || $banner['ext_bannertype'] == 'bannerTypeHtml:oxHtml:html5') {
				$imageurl = $image_path . '/' . $banner['filename'];
			} else {
				if ($banner['storagetype'] == 'url') {
					if ($banner['imageurl']) {
						echo $imageurl = $banner['imageurl'];
					} else {
						$imageurl = '';
					}
				} else {
				}
			}
			$bannerdetailsarray[] = array (
				'campaignid' => $banner['campaignid'],
				'bannerid' => $banner['bannerid'],
				'description' => $banner['description'],
				'filename' => $banner['filename'],
				'imageurl' => $imageurl,
				'storagetype' => $banner['storagetype'],
				'width' => $banner['width'],
				'height' => $banner['height'],
				'url' => $banner['url'],
				'ext_bannertype' => $ext_bannertype,
				'updated' => $banner['updated'],
				'status' => $banner['status'],
			);
		}
		if ($bannerdetails) {
			$response = array ('data' => $bannerdetailsarray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
			return $this->response->withJson($response);
		}
	} else {
		$results = array ('response' => 'error', 'msg' => 'Requested banner not available', 'statuscode' => '200');
		return $this->response->withJson($results);
	}
});

/*
 * Get Banner details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Banner ID 
 */

$app->get('/get_banner/[{bannerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	if ($_SERVER["HTTPS"] == "on") {
		$https = 'https';
	} else {
		$https = 'http';
	}
	$image_path = $https . '://' . $this->get('settings')['path']['image_path'];
	$bannerid = $args['bannerid'];
	$datetime = date('Y-m-d H:i:s');
	$results = array ();
	$bannerdetail = "SELECT ban.bannerid,ban.campaignid,cam.campaignname,cam.clientid,ban.contenttype,ban.description,ban.storagetype,ban.filename,ban.imageurl,ban.htmltemplate,ban.width,ban.height,ban.weight,ban.url,ban.alt,ban.statustext,ban.bannertext,ban.ext_bannertype,ban.append,ban.prepend,bva.vast_video_delivery,bva.vast_video_duration,bva.vast_video_type,bva.vast_overlay_format,bva.vast_overlay_action,bva.vast_overlay_text_title,bva.vast_overlay_text_description,bva.vast_overlay_text_call,bva.vast_video_outgoing_filename,bva.vast_video_clickthrough_url,bva.vast_companion_banner_id,bva.vast_thirdparty_impression, cl.clientname from " . $table_prefix . "banners ban LEFT JOIN " . $table_prefix . "banner_vast_element bva on ban.bannerid = bva.banner_id LEFT JOIN " . $table_prefix . "campaigns cam on cam.campaignid = ban.campaignid LEFT JOIN " . $table_prefix . "clients cl on cam.clientid = cl.clientid where ban.bannerid=:bannerid";
	$getbanner = $this->db->prepare($bannerdetail);
	$getbanner->bindParam(":bannerid", $bannerid);
	$getbanner->execute();
	$bannerdet = $getbanner->fetchAll();
	$bannerdetail = array ();

	if (count($bannerdet) > 0) {
		if ($bannerdet['0']['storagetype'] == 'web') {
			$ext_bannertype = $bannerdet['0']['storagetype'];
		} else if ($bannerdet['0']['storagetype'] == 'sql') {
			$ext_bannertype = $bannerdet['0']['storagetype'];
		} else if ($bannerdet['0']['storagetype'] == 'url') {
			$ext_bannertype = $bannerdet['0']['storagetype'];
		} else {
			$ext_bannertype = $bannerdet['0']['ext_bannertype'];
		}
		if ($bannerdet['0']['imageurl']) {
			$imageurl = $bannerdet['0']['imageurl'];
		} else {
			if ($bannerdet['0']['storagetype'] == 'url') {
				if ($bannerdet['0']['imageurl']) {
					$imageurl = $bannerdet['0']['imageurl'];
				} else {
					$imageurl = '';
				}
			} else {
				$imageurl = $image_path . '/' . $bannerdet['0']['filename'];
			}
		}
		if ($imageurl) {
			$imagefolderoriginalsize = getimagesize($imageurl);
			$originalwidth = $imagefolderoriginalsize[0];
			$originalheight = $imagefolderoriginalsize[1];
		} else {
			$originalwidth = '';
			$originalheight = '';
		}
		//[$bannerid] 
		$bannerdetail = array (
			'bannerid' => $bannerid,
			'campaignid' => $bannerdet['0']['campaignid'],
			'campaignname' => $bannerdet['0']['campaignname'],
			'clientname' => $bannerdet['0']['clientname'],
			'contenttype' => $bannerdet['0']['contenttype'],
			'description' => $bannerdet['0']['description'],
			'storagetype' => $bannerdet['0']['storagetype'],
			'filename' => $bannerdet['0']['filename'],
			'imageurl' => $imageurl,
			'imagepath' => $image_path,
			'htmltemplate' => $bannerdet['0']['htmltemplate'],
			'width' => $bannerdet['0']['width'],
			'height' => $bannerdet['0']['height'],
			'fileWidth' => $bannerdet['0']['width'],
			'fileheight' => $bannerdet['0']['height'],
			'fileoriginalwidth' => $originalwidth,
			'fileoriginalheight' => $originalheight,
			'weight' => $bannerdet['0']['weight'],
			'url' => $bannerdet['0']['url'],
			'alt' => $bannerdet['0']['alt'],
			'statustext' => $bannerdet['0']['statustext'],
			'bannertext' => $bannerdet['0']['bannertext'],
			'ext_bannertype' => $ext_bannertype,
			'append' => $bannerdet['0']['append'],
			'prepend' => $bannerdet['0']['prepend'],
			'vast_video_delivery' => $bannerdet['0']['vast_video_delivery'],
			'vast_video_duration' => $bannerdet['0']['vast_video_duration'],
			'vast_video_type' => $bannerdet['0']['vast_video_type'],
			'vast_overlay_format' => $bannerdet['0']['vast_overlay_format'],
			'vast_overlay_action' => $bannerdet['0']['vast_overlay_action'],
			'vast_overlay_text_title' => $bannerdet['0']['vast_overlay_text_title'],
			'vast_overlay_text_description' => $bannerdet['0']['vast_overlay_text_description'],
			'vast_overlay_text_call' => $bannerdet['0']['vast_overlay_text_call'],
			'vast_video_outgoing_filename' => $bannerdet['0']['vast_video_outgoing_filename'],
			'vast_video_clickthrough_url' => $bannerdet['0']['vast_video_clickthrough_url'],
			'vast_companion_banner_id' => $bannerdet['0']['vast_companion_banner_id'],
			//'vast_thirdparty_impression'=>$bannerdet['0']['vast_thirdparty_impression'],
		);

		if ($bannerdet) {
			$response = array ('data' => $bannerdetail, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
			return $this->response->withJson($response);
		}
	} else {
		$response = array (
			'response' => 'error',
			'msg' => 'Requested Banner Doesnot available'
		);

		return $this->response->withJson($response);
	}
});

/*
 * Banner DELETE
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->delete('/delete_banner/[{bannerid}]', function ($request, $response, $args) {

	$results = array ();

	$input = $request->getParsedBody();
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid = $args['bannerid'];
	$referbanner = "select * from " . $table_prefix . "banners where bannerid in (:bannerid)";
	$djax_query_referbanner = $this->db->prepare($referbanner);
	$djax_query_referbanner->bindParam(":bannerid", $bannerid);
	$djax_query_referbanner->execute();

	$stmtbanner = $djax_query_referbanner->fetchAll();


	if (count($stmtbanner) > 0) {
		foreach ($stmtbanner as $key => $banner) {
			if ($key > 0) {
				$bannerid .= $banner['bannerid'];
			}
		}

		$deleteaccounts = "DELETE FROM " . $table_prefix . "banners WHERE bannerid in ($bannerid)";
		$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
		//$djax_query_deleteaccount->bindParam(":bannerid",$bannerid);
		$djax_query_deleteaccount->execute();

		$del_ad = "DELETE FROM " . $table_prefix . "ad_zone_assoc   WHERE ad_id in ($bannerid)";
		$ad = $this->db->prepare($del_ad);
		$ad_assoc = $ad->execute();

		$del_adhourly = "DELETE FROM " . $table_prefix . "data_summary_ad_hourly WHERE ad_id in($bannerid)";
		$del_ad_hourly = $this->db->prepare($del_adhourly);
		$del_ad_hourly->execute();

		$delete_acls = "DELETE FROM " . $table_prefix . "acls WHERE bannerid in ($bannerid)";
		$djax_query_delete_acls = $this->db->prepare($delete_acls);
		//$djax_query_delete_element->bindParam(":bannerid", $bannerid);
		$djax_query_delete_acls->execute();

		$delete_element = "DELETE FROM " . $table_prefix . "banner_vast_element WHERE banner_id in ($bannerid)";
		$djax_query_delete_element = $this->db->prepare($delete_element);
		//$djax_query_delete_element->bindParam(":bannerid",$bannerid);
		$banner_del = $djax_query_delete_element->execute();


		if ($banner_del) {
		
		    $description = $stmtbanner[0]['description'];
			$datetime = date('Y-m-d H:i:s');
			//audit log maintain
			$delete_user_id = $_SESSION['user_id'];
			$module = 'banners_'.$description.'_'.$bannerid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `delete_user_id`,  `deleted_date`) VALUES (:module,:delete_user_id,:deleted_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":delete_user_id", $delete_user_id);
			$audit->bindParam(":deleted_date", $datetime);
			$audit->execute();
		
			$response = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'Banner deleted successfully!'
			);

			return $this->response->withJson($response);
		}
	} else {

		$response = array (
			'response' => 'error',
			'msg' => 'Bannerid provided is invalid'
		);

		return $this->response->withJson($response);
	}
});

/*
 * Banner Activate And Deactivate
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->post('/banner_status_update/[{bannerid}]', function ($request, $response, $args) {

	$results = array ();

	$input = $request->getParsedBody();
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$bannerid = $args['bannerid'];
	$referbanner = "select * from " . $table_prefix . "banners where bannerid=:bannerid";
	$djax_query_referbanner = $this->db->prepare($referbanner);
	$djax_query_referbanner->bindParam(":bannerid", $bannerid);
	$djax_query_referbanner->execute();

	$stmtbanner = $djax_query_referbanner->fetchAll();


	if (count($stmtbanner) > 0) {
		$banner_status = $stmtbanner[0]['status'];

		if ($banner_status == 0) {
			$update_status = "update {$table_prefix}banners set  `status`= 1 WHERE bannerid=:bannerid";
			$djax_query_update_status = $this->db->prepare($update_status);
			$djax_query_update_status->bindParam(":bannerid", $bannerid);
			$update_bannerstatus = $djax_query_update_status->execute();

			if ($update_bannerstatus) {
				$response = array (
					'response' => 'ok',
					'msg' => 'Banner Activated successfully!'
				);

				return $this->response->withJson($response);
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'Banner not Activated!'
				);

				return $this->response->withJson($response);
			}
		} else if ($banner_status == 1) {
			$update_status = "update {$table_prefix}banners set  `status`= 0 WHERE bannerid=:bannerid";
			$djax_query_update_status = $this->db->prepare($update_status);
			$djax_query_update_status->bindParam(":bannerid", $bannerid);
			$update_bannerstatus = $djax_query_update_status->execute();

			if ($update_bannerstatus) {
				$response = array (
					'response' => 'ok',
					'msg' => 'Banner Deactivated successfully!'
				);

				return $this->response->withJson($response);
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'Banner not Deactivated!'
				);

				return $this->response->withJson($response);
			}
		}
	} else {

		$response = array (
			'response' => 'error',
			'msg' => 'Bannerid provided is invalid'
		);

		return $this->response->withJson($response);
	}
})->add($container->get('limitValidation'));

// Edit Advance Banner 

$app->post('/edit_advanced_banner/[{bannerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		$user_details = "SELECT * from {$table_prefix}banners where bannerid=:bannerid";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":bannerid", $bannerid);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetchAll();
		if (count($stmtuser)) {
			if (isset ($input['append'])) {
				$append = $input['append'];
			} else {
				$append = $stmtuser[0]['append'];
			}

			if (isset ($input['prepend'])) {
				$prepend = $input['prepend'];
			} else {
				$prepend = $stmtuser[0]['prepend'];
			}

			$updateuser = "update {$table_prefix}banners set `append`=:append,`prepend`=:prepend ,updated=:updated where `bannerid`=:bannerid";

			$upd_userdet = $this->db->prepare($updateuser);

			$upd_userdet->bindParam(":append", $append);
			$upd_userdet->bindParam(":prepend", $prepend);
			$upd_userdet->bindParam(":updated", $datetime);
			$upd_userdet->bindParam(":bannerid", $bannerid);
			$upd_userdet->execute();

			$responses = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'Advance settings banner updated successfully!'
			);
			$response = array (
				'data' => $responses
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid banner Id!'
			);
		}
		return $this->response->withJson($response);
	}
});


/*---------------- BANNER ---------------*/
/*---------------- PUBLISHER ---------------*/
/*
 * PUBLISHER ADD
 * 
 * Input Parameters:
 * ----------------
 * contactname
 * email
 * website
 * username
 * password
 * name
 * 
 * Arguments:
 * ---------
 * Agency ID
 */


$app->post('/add_publisher/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$agencyid = $args['agencyid'];
		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetchAll();

		if (count($check) > 0) {
			$email = $input['email'];
			if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
				$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
				return $this->response->withJson($results);
			}
			$website = $input['website'];
			if (!filter_var($website, FILTER_VALIDATE_URL)) {
				$results = array ('response' => 'error', 'ERROR' => 'Please enter a valid Website name(website name should start with the prefix of http:// or https://)');
				return $this->response->withJson($results);
			}

			$contactname = $input['contact'];
			$username = $input['username'];
			$realpassword = $input['password'];
			$password = md5($realpassword);
			$name = $input['name'];

			$check_user = "Select username from {$table_prefix}users where username = :username ;";
			$user_det = $this->db->prepare($check_user);
			$user_det->bindParam(":username", $username);
			$user_det->execute();
			$user_data = $user_det->fetchAll();

			if ($user_data) {

				$response = array ('ERROR' => 'Username already exists');
				return $this->response->withJson($response);
			}

			if (empty ($contactname) || empty ($email) || empty ($name) || empty ($password) || empty ($username) || empty ($website)) {
				$response = array ('ERROR' => 'Please enter all required data');
				return $this->response->withJson($response);
			} else {

				if (isset ($input['username']) && !empty ($input['username'])) {
					$stc = "select * from " . $table_prefix . "users where username=:username";
					$std = $this->db->prepare($stc);
					$std->bindParam("username", $input['username']);
					$std->execute();
					$users = $std->fetchAll();

					if ($users) {
						$response = array ('response' => 'error', 'msg' => 'Username already exists');
						return $this->response->withJson($response);
					} else {

						$username = $input['username'];
					}
				}

				$addacc = "INSERT INTO {$table_prefix}accounts(`account_type`, `account_name`) VALUES ('TRAFFICKER',:contactname);";
				$acc_dat = $this->db->prepare($addacc);
				$acc_dat->bindParam(":contactname", $contactname);
				$acc_dat->execute();
				$acccountid = $this->db->lastInsertId();
				$addpub = "INSERT INTO {$table_prefix}affiliates(`agencyid`,`name`,`contact`,`email`,`website`,`updated`,`account_id`) VALUES (:agencyid,:name,:contact,:email,:website,:updated,:acccountid);";
				$pub_det = $this->db->prepare($addpub);
				$pub_det->bindParam(":agencyid", $agencyid);
				$pub_det->bindParam(":name", $name);
				$pub_det->bindParam(":contact", $contactname);
				$pub_det->bindParam(":email", $email);
				$pub_det->bindParam(":website", $website);
				$pub_det->bindParam(":updated", $datetime);
				$pub_det->bindParam(":acccountid", $acccountid);
				$pub_det->execute();


				$publisherid = $this->db->lastInsertId();
				$addusers = "INSERT INTO {$table_prefix}users(`contact_name`, `email_address`, `username`, `password`,`default_account_id`,`active`,`date_created`) VALUES (:contactname, :email,:username,:password,:acccountid,1,:datetime);";
				$users = $this->db->prepare($addusers);
				$users->bindParam(":contactname", $contactname);
				$users->bindParam(":email", $email);
				$users->bindParam(":username", $username);
				$users->bindParam(":password", $password);
				$users->bindParam(":acccountid", $acccountid);
				$users->bindParam(":datetime", $datetime);
				$users->execute();
				$userid = $this->db->lastInsertId();


				$userpermission = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:acccountid,:userid,:datetime);";
				$add_permission = $this->db->prepare($userpermission);
				$add_permission->bindParam(":acccountid", $acccountid);
				$add_permission->bindParam(":userid", $userid);
				$add_permission->bindParam(":datetime", $datetime);
				$add_permission->execute();

				$userassoc = "INSERT INTO {$table_prefix}account_user_permission_assoc(`account_id`, `user_id`, `permission_id`, `is_allowed`) VALUES
					(:acccountid,:userid,10,1),
					(:acccountid,:userid,4,1),
					(:acccountid,:userid,2,1),
					(:acccountid,:userid,1,1),
					(:acccountid,:userid,11,1);";

				$assoc = $this->db->prepare($userassoc);
				$assoc->bindParam(":acccountid", $acccountid);
				$assoc->bindParam(":userid", $userid);
				$assoc->execute();
				$results = json_encode(array ('Publisher added successfully with: affiliateid' => $publisherid));
			}
			return $results;
		} else {
			$response = array ('response' => 'error', 'msg' => 'Invalid Agency id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('publisheradd_val'));

/*
	   * PUBLISHER EDIT
	   * 
	   * Input Parameters:
	   * ----------------
	   * contactname
	   * email
	   * website
	   * username
	   * password
	   * name
	   * mode
	   
	   * Arguments:
	   * ---------
	   * Publisher ID
   */


$app->post('/edit_publisher/[{publisherid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$name = (isset ($input['name'])) ? $input['name'] : '';
		$contactname = (isset ($input['contact'])) ? $input['contact'] : '';
		$email = (isset ($input['email'])) ? $input['email'] : '';
		$website = (isset ($input['website'])) ? $input['website'] : '';
		$username = (isset ($input['username'])) ? $input['username'] : '';
		$realpassword = (isset ($input['password'])) ? $input['password'] : '';
		$password = (isset ($input['password'])) ? md5($realpassword) : '';
		$datetime = date('Y-m-d H:i:s');
		$publisherid = $args['publisherid'];
		$results = array ();

		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}
		$getpublisher = "	SELECT * FROM {$table_prefix}affiliates where affiliateid =:affiliateid";

		$pub_edit = $this->db->prepare($getpublisher);
		$pub_edit->bindParam(":affiliateid", $publisherid);
		$pub_edit->execute();
		$stmt = $pub_edit->fetchAll();

		$stc1 = "SELECT * FROM " . $table_prefix . "users where default_account_id ='" . $stmt[0]['account_id'] . "'";
		$std1 = $this->db->prepare($stc1);
		$std1->execute();
		$users1 = $std1->fetchAll();

		if (count($stmt) > 0) {
			if (isset ($input['username']) && !empty ($input['username'])) {

				$username = $input['username'];
			} else {
				$username = $users1[0]['username'];
			}

			if (isset ($input['email'])) {
				$email = $input['email'];
				if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
					$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
					return $this->response->withJson($results);
				}
			} else {
				$email = $stmt[0]['email'];
			}

			if (isset ($input['website'])) {
				$website = $input['website'];
				if (!filter_var($website, FILTER_VALIDATE_URL)) {
					$results = array ('response' => 'error', 'ERROR' => 'Please enter a valid Website name(website name should start with the prefix of http:// or https://)');
					return $this->response->withJson($results);
				}
			} else {
				$website = $stmt[0]['website'];
			}


			if (isset ($input['contact'])) {
				$contactname = $input['contact'];
			} else {
				$contactname = $stmt[0]['contact'];
			}

			if (isset ($input['password'])) {
				$password = $input['password'];
			} else {
				$password = $stmt[0]['password'];
			}

			if (isset ($input['name'])) {
				$name = $input['name'];
			} else {
				$name = $stmt[0]['name'];
			}

			$accounts = "update {$table_prefix}accounts set  `account_name`=:account_name where  account_id=:account_id";
			$acc_dat = $this->db->prepare($accounts);
			$acc_dat->bindParam(":account_name", $name);
			$acc_dat->bindParam(":account_id", $stmt[0]['account_id']);
			$acc_dat->execute();

			$update_pub = "update {$table_prefix}affiliates set  `name`=:name,`contact`=:contact,`website`=:website,`email`=:email,updated=:updated where account_id=:account_id";
			$pub_query = $this->db->prepare($update_pub);
			$pub_query->bindParam(":name", $name);
			$pub_query->bindParam(":contact", $contactname);
			$pub_query->bindParam(":website", $website);
			$pub_query->bindParam(":email", $email);
			$pub_query->bindParam(":updated", $datetime);
			$pub_query->bindParam(":account_id", $stmt[0]['account_id']);
			$pub_query->execute();

			$updateuser = "update {$table_prefix}users set `contact_name`=:contact_name ,  `username`=:username,`password`=:password,`email_address`=:email_address,date_created=:updated where default_account_id=:default_account_id";

			$update_publisher = $this->db->prepare($updateuser);

			$update_publisher->bindParam(":contact_name", $contactname);
			$update_publisher->bindParam(":username", $username);
			$update_publisher->bindParam(":password", $password);
			$update_publisher->bindParam(":email_address", $email);
			$update_publisher->bindParam(":updated", $datetime);
			$update_publisher->bindParam(":default_account_id", $stmt[0]['account_id']);

			$update_publisher->execute();

			$results = array ('response' => 'ok', 'msg' => 'Publisher details has been updated successfully!');
			return $this->response->withJson($results);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('pubid_edit'));

/*
 * Publisher Delete
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * Account ID
 */

$app->delete('/delete_publisher/[{accountid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$accountid = $args['accountid'];
		$publisher = "select * from {$table_prefix}affiliates where affiliateid=:account_id";
		$pub_data = $this->db->prepare($publisher);
		$pub_data->bindParam(":account_id", $accountid);
		$pub_data->execute();
		$stmtpub = $pub_data->fetchAll();

		if (count($stmtpub) > 0) {
			$deleteacc = "DELETE FROM {$table_prefix}accounts WHERE account_id=:account_id";
			$del_acc = $this->db->prepare($deleteacc);
			$del_acc->bindParam(":account_id", $accountid);
			$del_acc->execute();


			$deletepub = "DELETE FROM {$table_prefix}affiliates WHERE affiliateid=:account_id";
			$del_data = $this->db->prepare($deletepub);
			$del_data->bindParam(":account_id", $accountid);
			$del_data->execute();


			$deleteusers = "DELETE FROM {$table_prefix}users WHERE default_account_id=:default_account_id";
			$djax_query_deleteuser = $this->db->prepare($deleteusers);
			$djax_query_deleteuser->bindParam(":default_account_id", $accountid);
			$djax_query_deleteuser->execute();


			$deleteuserassoc = "DELETE FROM {$table_prefix}account_user_assoc WHERE account_id=:account_id";
			$del_assoc = $this->db->prepare($deleteuserassoc);
			$del_assoc->bindParam(":account_id", $accountid);
			$del_assoc->execute();


			$deletepermission = "DELETE FROM {$table_prefix}account_user_permission_assoc WHERE account_id=:account_id";
			$del_user_permission = $this->db->prepare($deletepermission);
			$del_user_permission->bindParam(":account_id", $accountid);
			$del_user_permission->execute();

			$response = array ('response' => 'ok', 'msg' => 'Publisher has been deleted successfully');
			return $this->response->withJson($response);
		} else {

			$response = array ('response' => 'ok', 'msg' => 'Please eneter valid publisherid');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('accountid_val'));


/*
 * Get Publisher details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Affiliate ID
 */

$app->get('/getpublisherdetails/[{affiliateid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$affiliateid = $args['affiliateid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$publisherdetails = "SELECT * FROM " . $table_prefix . "affiliates AS t1 JOIN " . $table_prefix . "users AS t2 ON  t1.account_id = t2.default_account_id where t1.affiliateid =:affiliateid";
		//$publisherdetails="SELECT * FROM {$table_prefix}affiliates where affiliateid = :affiliateid";

		$get_details = $this->db->prepare($publisherdetails);
		$get_details->bindParam(":affiliateid", $affiliateid);
		$get_details->execute();
		$publisher = $get_details->fetchAll();
		$publisherdetail = array ();

		if (count($publisher) > 0) {
			$publisherdetail[$affiliateid] = array (
				'affiliateid' => $affiliateid,
				'name' => $publisher[0]['name'],
				'contact' => $publisher[0]['contact'],
				'email' => $publisher[0]['email'],
				'website' => $publisher[0]['website'],
				'username' => $publisher[0]['username'],
				'password' => $publisher[0]['password']
			);

			return $this->response->withJson($publisherdetail);
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Publisher Id!'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('affid_val'));

/*
 * Get All Publisher details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Agency ID
 */

$app->get('/getallpublisher/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetchAll();
		if (count($check) > 0) {

			$allpublisher = "SELECT * FROM {$table_prefix}affiliates AS t1 JOIN {$table_prefix}users AS t2 ON t1.agencyid =:agencyid AND t1.account_id = t2.default_account_id";
			//$allpublisher="SELECT * FROM {$table_prefix}affiliates AS t1 where t1.agencyid =:agencyid";

			$get_all_pub = $this->db->prepare($allpublisher);
			$get_all_pub->bindParam(":agencyid", $agencyid);
			$get_all_pub->execute();
			$stmtpublisher = $get_all_pub->fetchAll();
			$num = count($stmtpublisher);
			$publisherdetails = array ();

			if ($num > 0) {
				foreach ($stmtpublisher as $publisher) {
					$publisherdetails[$publisher['account_id']] = array (
						'agencyid' => $agencyid,
						'account_id' => $publisher['account_id'],
						'affiliateid' => $publisher['affiliateid'],
						'name' => $publisher['name'],
						'contact' => $publisher['contact'],
						'email' => $publisher['email'],
						'website' => $publisher['website'],
						'username' => $publisher['username'],
						'password' => $publisher['password']
					);
				}

				return $this->response->withJson($publisherdetails);
			} else {
				$response = array (
					'response' => 'error',
					'msg' => 'No publisher availabe under the provided Agency!'
				);
			}

			return $response;
		} else {
			$response = array ('response' => 'error', 'msg' => 'Invalid Agency id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('agencyid_val'));



/********************************Publisher End*******************************/


/********************************Zone Add***********************************/
/*
 * ZONE ADD
 * 
 * Input Parameters:
 * ----------------
 * zonename
 * description
 * delivery
 * width
 * height
 * 
 * Arguments:
 * ---------
 * Publisher ID
 */

$app->post('/add_zone/[{publisherid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them || empty($description)
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$publisherid = $args['publisherid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$zonename = $input['zonename'];
		$description = $input['description'];
		$delivery = $input['delivery'];
		$comments = $input['comments'];

		if ($delivery == 0 || $delivery == 1 || $delivery == 4) {
			$width = $input['width'];
			$height = $input['height'];
			if ($width == '*' && $height == '*') {
				$width = -1;
				$height = -1;
			}
			if (empty ($width) || empty ($height)) {
				$response = array ('response' => 'error', 'msg' => 'Please enter width and height');
				return $this->response->withJson($response);
				return $response;
			}
		} else if ($delivery == 6) {
			$width = -3;
			$height = -3;
		} else if ($delivery == 7) {
			$width = -2;
			$height = -2;
		} else if ($delivery == 8) {
			$width = -5;
			$height = -5;
		} else if ($delivery == 3) {
			$width = 0;
			$height = 0;
		}

		if ($delivery < 0) {
			$results = json_encode(array ('ERROR' => 'Please enter delivery'));
			return $results;
		}


		if (empty ($zonename)) {
			$results = json_encode(array ('ERROR' => 'Please enter all required data'));
		} else {

			$allpublisher = "SELECT * FROM {$table_prefix}affiliates where 
				affiliateid = :affiliateid";

			$get_all_pub = $this->db->prepare($allpublisher);
			$get_all_pub->bindParam(":affiliateid", $publisherid);
			$get_all_pub->execute();
			$stmtpublisher = $get_all_pub->fetchAll();
			$num = count($stmtpublisher);
			$publisherdetails = array ();

			if ($num > 0) {
				$addzones = "INSERT INTO {$table_prefix}zones(`zonename`,`zonetype`,`description`,`delivery`,`width`,`height`,`affiliateid`,`comments`,`updated`) VALUES (:zonename,3,:description,:delivery,:width,:height,:affiliateid,:comments,now());";

				$djax_query_zone = $this->db->prepare($addzones);
				$djax_query_zone->bindParam(":zonename", $zonename);
				$djax_query_zone->bindParam(":description", $description);
				$djax_query_zone->bindParam(":delivery", $delivery);
				$djax_query_zone->bindParam(":width", $width);
				$djax_query_zone->bindParam(":height", $height);
				$djax_query_zone->bindParam(":comments", $comments);
				$djax_query_zone->bindParam(":affiliateid", $publisherid);
				$djax_query_zone->execute();
				$zoneid = $this->db->lastInsertId();
				if ($zoneid) {
				
				//audit log maintain
				$create_user_id = $_SESSION['user_id'];
				$module = 'zones_'.$zonename.'_'.$zoneid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":create_user_id", $create_user_id);
				$audit->bindParam(":created_date", $datetime);
				$audit->execute();
	
					$response = array (
						'response' => 'success',
						'statuscode' => '200',
						'msg' => 'Zone added successfully!',
						'zone' => $zoneid
					);
				}
			} else {
				$response = array (
					'response' => 'error',
					'msg' => 'No publisher availabe under the 
					agencyid!'
				);
			}
			return $this->response->withJson($response);
		}
	}
})->add($container->get('zone_val'));

/*
 * ZONE EDIT
 * 
 * Input Parameters:
 * ----------------
 * zonename
 * description
 * delivery
 * category
 * width
 * height
 * mode
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->post('/edit_zone/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		// $pubid = (isset ($input['pid'])) ? $input['pid'] : '';
		$website = (isset ($input['website'])) ? $input['website'] : '';
		$zonename = (isset ($input['zonename'])) ? $input['zonename'] : '';
		$description = (isset ($input['description'])) ? $input['description'] : '';
		$width = (isset ($input['width'])) ? $input['width'] : '';
		$height = (isset ($input['height'])) ? $input['height'] : '';
		$comments = (isset ($input['comments'])) ? $input['comments'] : '';
		$mode = $input['mode'];
		$datetime = date('Y-m-d H:i:s');
		$zoneid = $args['zoneid'];
		$results = array ();
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		// $website_det = "update {$table_prefix}affiliates set  `publisher_id`=:publisher_id where  affiliateid=:affiliateid";
		// $acc_dat = $this->db->prepare($website_det);
		// $acc_dat->bindParam(":publisher_id", $pubid);
		// $acc_dat->bindParam(":affiliateid", $website);
		// $acc_dat->execute();

		$getzone = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$zonedata = $this->db->prepare($getzone);
		$zonedata->bindParam(":zoneid", $zoneid);
		$zonedata->execute();
		$stmt = $zonedata->fetchAll();
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}
		if (isset ($input['zonename'])) {
			$zonename = $input['zonename'];
			if (empty ($zonename)) {
				$results = json_encode(array ('ERROR' => 'Please enter zone name'));
				return $results;
			}
		} else {
			$zonename = $stmt[0]['zonename'];
		}
		if (isset ($input['description'])) {
			$description = $input['description'];
		} else {
			$description = $stmt[0]['description'];
		}

		if (isset ($input['delivery'])) {

			$delivery = $input['delivery'];

			if ($delivery == 0 || $delivery == 1 || $delivery == 4) {
				$width = $input['width'];
				$height = $input['height'];
				if ($width == '*' && $height == '*') {
					$width = -1;
					$height = -1;
				}
				if (empty ($width) || empty ($height)) {
					$results = json_encode(array ('ERROR' => 'Please enter width and height'));
					return $results;
				}
			} else if ($delivery == 6) {
				$width = -3;
				$height = -3;
			} else if ($delivery == 7) {
				$width = -2;
				$height = -2;
			} else if ($delivery == 8) {
				$width = -5;
				$height = -5;
			} else {
				$width = 0;
				$height = 0;
			}

			if ($delivery < 0) {
				$results = json_encode(array ('ERROR' => 'Please enter delivery'));
				return $results;
			}
		} else {

			$delivery = $stmt[0]['delivery'];

			if ($input['width']) {
				$width = $input['width'];
			} else {
				$width = $stmt[0]['width'];
			}

			if ($input['height']) {
				$height = $input['height'];
			} else {
				$height = $stmt[0]['height'];
			}
		}

		if (isset ($input['comments'])) {
			$comments = $input['comments'];
		} else {
			$comments = $stmt[0]['comments'];
		}


		if (count($stmt) > 0) {
			$addzones = "update  {$table_prefix}zones set`zonename`=:zonename,`description`=:description,`delivery`=:delivery,`width`=:width,`height`=:height,`comments`=:comments,`updated`=now() where `zoneid`=:zoneid;";

			$zone_data = $this->db->prepare($addzones);
			$zone_data->bindParam(":zonename", $zonename);
			$zone_data->bindParam(":description", $description);
			$zone_data->bindParam(":delivery", $delivery);
			$zone_data->bindParam(":width", $width);
			$zone_data->bindParam(":height", $height);
			$zone_data->bindParam(":comments", $comments);
			$zone_data->bindParam(":zoneid", $zoneid);

			$zone_data->execute();
			
			//audit log maintain
			$update_user_id = $_SESSION['user_id'];
			$module = 'zones_'.$zonename.'_'.$zoneid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `update_user_id`,  `updated_date`) VALUES (:module,:update_user_id,:updated_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":update_user_id", $update_user_id);
			$audit->bindParam(":updated_date", $datetime);
			$audit->execute();

			$response = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'zone updated successfully'
			);
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Requested zone id doesnot found!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('zoneid_edit'));

//Zone Auto Link API 

$app->get('/auto_link_banners/[{zoneid}]', function ($request, $response, $args) {


	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		//get_zone_details
		$zonesizedetails = "SELECT width,height,delivery from {$table_prefix}zones where zoneid=$zoneid";
		$djax_query_zonesizedetail = $this->db->prepare($zonesizedetails);
		$djax_query_zonesizedetail->execute();
		$stmtzonesize = $djax_query_zonesizedetail->fetchAll();
		$zonewidth = $stmtzonesize[0]['width'];
		$zoneheight = $stmtzonesize[0]['height'];
		$zonetype = $stmtzonesize[0]['delivery'];

		//get_linked_campaigns
		$stc = "SELECT placement_id FROM " . $table_prefix . "placement_zone_assoc where zone_id=$zoneid";
		$std = $this->db->prepare($stc);
		$std->execute();
		$campaign_det = $std->fetchAll();

		$campaignid = '';
		foreach ($campaign_det as $key => $campaign) {
			$campaignid .= $campaign['placement_id'] . ',';
		}
		$campaignids = trim($campaignid, ',');
		//get_banners & link
		$bannervalue = "select * from {$table_prefix}banners where campaignid in ($campaignids)";
		$djax_query_bannervalue = $this->db->prepare($bannervalue);
		$djax_query_bannervalue->execute();
		$stmtbannervalue = $djax_query_bannervalue->fetchAll();

		foreach ($stmtbannervalue as $banner) {
			$bannerid = $banner['bannerid'];
			$width = $banner['width'];
			$height = $banner['height'];
			$bannertype = $banner['storagetype'];
			$exttype = $banner['ext_bannertype'];
			if ($zonewidth == -1 && $zoneheight == -1) {
				if ($bannertype != 'txt') {
					$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
						`priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
						VALUES (:zoneid, :bannerid,0,1,1,1);";

					$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
					$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
					$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
					$djax_query_adzoneassoc->execute();

					$response = array (
						'response' => 'ok',
						'msg' => 'Banners linked successfully to the zoneid!'
					);
				}
			} else {
				if (
					(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
					(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
					($bannertype == 'txt' && $zonetype == 3) ||
					(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||
					(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:html5')) ||
					(($bannertype == 'html' &&
						$exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype == 6) ||
					(($bannertype == 'html' &&
						$exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') && $zonetype == 7) ||
					(($bannertype == 'html' &&
						$exttype == 'bannerTypeHtml:oxHtml:genericHtml')
						&& ($zonetype == 7 || $zonetype == 0 || $zonetype == 1 || $zonetype == 4))
				) {

					if (($width == $zonewidth && $height == $zoneheight) || ($zonewidth == -1 && $zoneheight == -1)) {

						$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
						`priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
						VALUES (:zoneid, :bannerid,0,1,1,1);";

						$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
						$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
						$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
						$djax_query_adzoneassoc->execute();

						$response = array (
							'response' => 'ok',
							'msg' => 'Banners linked successfully to the zoneid!'
						);
					}
				}
			}
		}
		return $this->response->withJson($response);
	}
});

//Zone Auto UnLink API

$app->post('/auto_unlink_banners/[{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$linkval = "select * from {$table_prefix}ad_zone_assoc WHERE zone_id=:zoneid";
		$linkdet = $this->db->prepare($linkval);
		$linkdet->bindParam(":zoneid", $zoneid);
		$linkdet->execute();
		$stmtlinkvalue = $linkdet->fetchAll();

		if ($stmtlinkvalue) {
			$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE zone_id=:zoneid";
			$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
			$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);
			$banner_del = $djax_query_deleteaccount->execute();
			$response = array (
				'response' => 'ok',
				'msg' => 'Banners Unlinked successfully!'
			);
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Banners not linked !'
			);
		}
		return $this->response->withJson($response);
	}
});

//Advanced Zone Edit

$app->post('/edit_advanced_zone/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$getzone = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$zonedata = $this->db->prepare($getzone);
		$zonedata->bindParam(":zoneid", $zoneid);
		$zonedata->execute();
		$stmt = $zonedata->fetchAll();
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}
		if (isset ($input['chain'])) {
			$chain = $input['chain'];
		} else {
			$chain = '';
		}
		if (isset ($input['capping'])) {
			$capping = $input['capping'];
		} else {
			$capping = '';
		}

		if (isset ($input['session_capping'])) {
			$session_capping = $input['session_capping'];
		} else {
			$session_capping = '';
		}

		if (isset ($input['block'])) {
			$block = $input['block'];
		} else {
			$block = '';
		}

		if (isset ($input['append'])) {
			$append = $input['append'];
		} else {
			$append = '';
		}
		if (isset ($input['prepend'])) {
			$prepend = $input['prepend'];
		} else {
			$prepend = '';
		}

		if (isset ($input['forceappend'])) {
			$forceappend = $input['forceappend'];
		} else {
			$forceappend = '';
		}

		if (isset ($input['show_capped_no_cookie'])) {
			$show_capped_no_cookie = $input['show_capped_no_cookie'];
		} else {
			$show_capped_no_cookie = '';
		}


		if (count($stmt) > 0) {
			$addzones = "update  {$table_prefix}zones set`chain`=:chain,`capping`=:capping,`session_capping`=:session_capping,`block`=:block,`append`=:append,`prepend`=:prepend,`forceappend`=:forceappend,`show_capped_no_cookie`=:show_capped_no_cookie,`updated`=now() where `zoneid`=:zoneid;";

			$zone_data = $this->db->prepare($addzones);
			$zone_data->bindParam(":chain", $chain);
			$zone_data->bindParam(":capping", $capping);
			$zone_data->bindParam(":session_capping", $session_capping);
			$zone_data->bindParam(":block", $block);
			$zone_data->bindParam(":append", $append);
			$zone_data->bindParam(":prepend", $prepend);
			$zone_data->bindParam(":forceappend", $forceappend);
			$zone_data->bindParam(":show_capped_no_cookie", $show_capped_no_cookie);
			$zone_data->bindParam(":zoneid", $zoneid);

			$zone_data->execute();

			$response = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'Advanced settings zone updated successfully'
			);
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Requested zone id doesnot found!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('zoneid_edit'));

/*
 * Zone Delete
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->delete('/delete_zone/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$referzone = "select * from {$table_prefix}zones where zoneid in (:zoneid)";
		$djax_query_referzones = $this->db->prepare($referzone);
		$djax_query_referzones->bindParam(":zoneid", $zoneid);
		$djax_query_referzones->execute();
		$stmtzone = $djax_query_referzones->fetchAll();


		if (count($stmtzone) > 0) {
			foreach ($stmtzone as $key => $zone) {
				if ($key > 0) {
					$zoneid .= $zone['zoneid'];
				}
			}

			$deleteaccounts = "DELETE FROM {$table_prefix}zones WHERE zoneid in ($zoneid)";
			$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
			//$djax_query_deleteaccount->bindParam(":zoneid",$zoneid);
			$djax_query_deleteaccount->execute();

			$del_adassoc = "DELETE FROM {$table_prefix}ad_zone_assoc WHERE zone_id in($zoneid)";
			$del_ad = $this->db->prepare($del_adassoc);
			$del_ad->execute();

			$del_placeassoc = "DELETE FROM {$table_prefix}placement_zone_assoc WHERE zone_id in($zoneid)";
			$del_place_ad = $this->db->prepare($del_placeassoc);
			$del_place_ad->execute();

			$del_adhourly = "DELETE FROM {$table_prefix}data_summary_ad_hourly WHERE zone_id in($zoneid)";
			$del_ad_hourly = $this->db->prepare($del_adhourly);
			$del_ad_hourly->execute();
			
			$zonename = $stmtzone[0]['zonename'];
			$datetime = date('Y-m-d H:i:s');
			//audit log maintain
			$delete_user_id = $_SESSION['user_id'];
			$module = 'zones_'.$zonename.'_'.$zoneid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `delete_user_id`,  `deleted_date`) VALUES (:module,:delete_user_id,:deleted_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":delete_user_id", $delete_user_id);
			$audit->bindParam(":deleted_date", $datetime);
			$audit->execute();

			$response = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'Zone has been deleted successfully!'
			);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Zone Id!'
			);
		}
		return $this->response->withJson($response);
	}
});

/*
 * Get Zone details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->get('/get_zone/[{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$zonedetails = "SELECT * from  {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_zonedetail = $this->db->prepare($zonedetails);
		$djax_query_zonedetail->bindParam(":zoneid", $zoneid);
		$djax_query_zonedetail->execute();
		$stmtzone = $djax_query_zonedetail->fetchAll();

		$zonedetail = array ();

		if (count($stmtzone) > 0) {
			//[$stmtzone[0]['zoneid']]
			$zonedetail = array (
				'affiliateid' => $stmtzone[0]['affiliateid'],
				'zoneid' => $stmtzone[0]['zoneid'],
				'zonename' => $stmtzone[0]['zonename'],
				'description' => $stmtzone[0]['description'],
				'delivery' => $stmtzone[0]['delivery'],
				'width' => $stmtzone[0]['width'],
				'height' => $stmtzone[0]['height'],
				'comments' => $stmtzone[0]['comments'],
				'chain' => $stmtzone[0]['chain'],
				'capping' => $stmtzone[0]['capping'],
				'session_capping' => $stmtzone[0]['session_capping'],
				'block' => $stmtzone[0]['block'],
				'append' => $stmtzone[0]['append'],
				'prepend' => $stmtzone[0]['prepend'],
				'forceappend' => $stmtzone[0]['forceappend'],
				'show_capped_no_cookie' => $stmtzone[0]['show_capped_no_cookie']
			);
			if ($zonedetail) {
				$response = array ('data' => $zonedetail, 'response' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Stats Available');
				return $this->response->withJson($response);
			}
		} else {

			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Zone Id!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('get_zone_val'));

//Get Sizewise zone

$app->get('/get_sizewise_zone/[{agencyid},{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$agencyid = $args['agencyid'];
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$affiliatedetails = "SELECT affiliateid from {$table_prefix}affiliates where agencyid=:agencyid";
		$djax_query_affiliatedetails = $this->db->prepare($affiliatedetails);
		$djax_query_affiliatedetails->bindParam(":agencyid", $agencyid);
		$djax_query_affiliatedetails->execute();
		$stmtaffiliate = $djax_query_affiliatedetails->fetchAll();

		$affiliateid = '';
		foreach ($stmtaffiliate as $key => $affiliate) {
			$affiliateid .= $affiliate['affiliateid'] . ',';
		}

		$affiliateids = trim($affiliateid, ',');

		$zonesizedetails = "SELECT width,height from {$table_prefix}zones where zoneid=$zoneid";
		$djax_query_zonesizedetail = $this->db->prepare($zonesizedetails);
		$djax_query_zonesizedetail->execute();
		$stmtzonesize = $djax_query_zonesizedetail->fetchAll();

		$width = $stmtzonesize[0]['width'];
		$height = $stmtzonesize[0]['height'];

		$zonedetails = "SELECT zoneid,zonename from {$table_prefix}zones where width=$width and height=$height and affiliateid in ($affiliateids) and zoneid not in ($zoneid)";
		$djax_query_zonedetail = $this->db->prepare($zonedetails);

		$djax_query_zonedetail->execute();
		$stmtzone = $djax_query_zonedetail->fetchAll();

		if (count($stmtzone) > 0) {

			if ($stmtzone) {
				$response = array ('data' => $stmtzone, 'response' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {

			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Zone Id!'
			);
		}
		return $this->response->withJson($response);
	}
});

//Get Zone Probability 

$app->get('/get_zone_probability/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$zonelinkedetails = "SELECT ad_id from {$table_prefix}ad_zone_assoc where zone_id=$zoneid";
		$djax_query_zonelinkeddetail = $this->db->prepare($zonelinkedetails);
		$djax_query_zonelinkeddetail->execute();
		$stmtzonelinked = $djax_query_zonelinkeddetail->fetchAll();

		$bannerid = '';
		foreach ($stmtzonelinked as $zoneassoc) {
			$bannerid .= $zoneassoc['ad_id'] . ',';
		}

		$bannerids = trim($bannerid, ',');
		if ($bannerids) {
			$bannervalue = "select ban.description bannername,ban.bannerid,ban.compiledlimitation,ban.capping,ban.session_capping,ban.weight bannerweight,ban.append,ban.prepend,cam.campaignid,cam.campaignname,cam.weight campaignweight,cam.priority from {$table_prefix}banners ban LEFT JOIN " . $table_prefix . "campaigns cam on cam.campaignid = ban.campaignid where bannerid in ($bannerids)";
			$djax_query_bannervalue = $this->db->prepare($bannervalue);
			$djax_query_bannervalue->execute();
			$stmtbannervalue = $djax_query_bannervalue->fetchAll();
		}
		$campaigncount = "select placement_id from {$table_prefix}placement_zone_assoc pla LEFT JOIN " . $table_prefix . "campaigns cam on cam.campaignid = pla.placement_id where  zone_id=$zoneid and cam.priority=0";
		$djax_query_campaigncount = $this->db->prepare($campaigncount);
		$djax_query_campaigncount->execute();
		$stmtcampaigncount = $djax_query_campaigncount->fetchAll();
		$remnantcampaigncount = $stmtcampaigncount[0]['placement_id'];

		if ($bannerids) {
			$bannercount = "select ban.description bannername,ban.bannerid,ban.compiledlimitation,ban.capping,ban.session_capping,ban.weight bannerweight,ban.append,ban.prepend,cam.campaignid,cam.campaignname,cam.weight campaignweight,cam.priority from {$table_prefix}banners ban LEFT JOIN " . $table_prefix . "campaigns cam on cam.campaignid = ban.campaignid where bannerid in ($bannerids) and cam.priority=0";
			$djax_query_bannercount = $this->db->prepare($bannercount);
			$djax_query_bannercount->execute();
			$stmtbannercount = $djax_query_bannercount->fetchAll();
		}

		foreach ($stmtbannercount as $remnantvalue) {

			$remzone[] = $remnantvalue['campaignid'];
		}
		if ($remzone) {
			$duplicate = array_unique($remzone);
		}
		foreach ($duplicate as $duplicatermval) {
			$sumofbanweight = 0;
			foreach ($stmtbannercount as $remnantvalue) {
				if ($duplicatermval == $remnantvalue['campaignid']) {
					$sumofbanweight += $remnantvalue['bannerweight'];
				}
			}
			$campaignweightarr[] = array ('campaignid' => $duplicatermval, 'sumofbanweight' => $sumofbanweight);
		}
		if ($duplicate) {
			$countofduplicate = count($duplicate);
			$campaignper = 100 / $countofduplicate;
		}

		foreach ($campaignweightarr as $campweightarr) {

			$banweight = $campaignper / $campweightarr['sumofbanweight'];

			$campaignweightper[] = array ('campaignid' => $campweightarr['campaignid'], 'banweight' => $banweight);
		}

		foreach ($stmtbannervalue as $probability) {
			$priority = $probability['priority'];
			$bannerweight = $probability['bannerweight'];
			$campaignid = $probability['campaignid'];
			$bannerid = $probability['bannerid'];
			$campaignweight = $probability['campaignweight'];
			$usedHighProbability += $probability['priority'];

			//Remnant
			if ($priority == 0) {
				foreach ($campaignweightper as $campweightper) {
					$remcampaignid = $campweightper['campaignid'];

					if ($probability['campaignid'] == $remcampaignid) {

						$probabilityper = number_format($probability['bannerweight'] * $campweightper['banweight'], 2) . ' %';

						$remnantzone[] = array (
							'campaigntype' => 'Remnant',
							'bannername' => $probability['bannername'],
							'bannerid' => $probability['bannerid'],
							'bannerweight' => $probability['bannerweight'],
							'campaignid' => $probability['campaignid'],
							'campaignname' => $probability['campaignname'],
							'campaignweight' => $probability['campaignweight'],
							'priority' => $probability['priority'],
							'probability' => $probabilityper,
							'compiledlimitation' => $probability['compiledlimitation'],
							'capping' => $probability['capping'],
							'session_capping' => $probability['session_capping'],
							'append' => $probability['append'],
							'prepend' => $probability['prepend'],
						);
					}
				}
			}

			//Override
			if ($priority == -1) {

				$overridezone[] = array (
					'campaigntype' => 'Override',
					'bannername' => $probability['bannername'],
					'bannerid' => $probability['bannerid'],
					'bannerweight' => $probability['bannerweight'],
					'campaignname' => $probability['campaignname'],
					'campaignweight' => $probability['campaignweight'],
					'compiledlimitation' => $probability['compiledlimitation'],
					'capping' => $probability['capping'],
					'session_capping' => $probability['session_capping'],
					'append' => $probability['append'],
					'prepend' => $probability['prepend'],
				);
			}

			//Contract
			if ($priority > 0) {
				$probabilitycalc = '0.00 %';
				$contractzone[] = array (
					'campaigntype' => 'Contract',
					'bannername' => $probability['bannername'],
					'bannerid' => $probability['bannerid'],
					'bannerweight' => $probability['bannerweight'],
					'campaignname' => $probability['campaignname'],
					'campaignweight' => $probability['campaignweight'],
					'priority' => $probability['priority'],
					'probability' => $probabilitycalc,
					'compiledlimitation' => $probability['compiledlimitation'],
					'capping' => $probability['capping'],
					'session_capping' => $probability['session_capping'],
					'append' => $probability['append'],
					'prepend' => $probability['prepend'],
				);
			}
		}

		$probabilityarray = array (
			'Override' => $overridezone,
			'Remnant' => $remnantzone,
			'Contract' => $contractzone
		);

		if ($stmtbannervalue) {
			$banner_count = count($stmtbannervalue);
			if ($banner_count > 0) {
				if ($stmtbannervalue) {
					$response = array ('data' => $probabilityarray, 'response' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Data');
					return $this->response->withJson($response);
				}
			} else {

				$response = array (
					'response' => 'Error',
					'msg' => 'Invalid Zone Id!'
				);
			}
		} else {
			$response = array (
				'response' => 'ok',
				'msg' => 'No active banners'
			);
		}
		return $this->response->withJson($response);
	}
});

/*
 * Get All Zone details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Publisher ID
 */

$app->get('/get_all_zone/[{affiliate_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$affiliate_id = $args['affiliate_id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		
		$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
			" . $table_prefix . "affiliates as af,
			" . $table_prefix . "zones as z,
            " . $table_prefix . "agency as ag
			where
			z.affiliateid = af.affiliateid
			AND af.agencyid = ag.agencyid
            AND ag.account_id = a.account_id
			AND a.preference_id = 16
			AND af.affiliateid =" . $affiliate_id;
			$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
			$TimeZonestd->execute();

			$TimeZoneRow = $TimeZonestd->fetchAll();
			
			
			if ($TimeZoneRow) {
				
				$timezone = $TimeZoneRow[0]['timezone'];
			
			} else {
				

				$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
				$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
				$TimeZonestd->execute();
				$TimeZoneRow = $TimeZonestd->fetchAll();
				if($TimeZoneRow){
					$timezone = $TimeZoneRow[0]['timezone'];
					}
					else{
						$timezone = 'UTC';
	
					}
			}
		
			if($timezone=='0'){
			
				$timezone = 'UTC';

			}
			else{
				
				$timezone = $timezone;

			}
			
		       
			date_default_timezone_set($timezone);

			// $date1 = date("d-m-Y H:i:s");
			// date_default_timezone_set('UTC');
			// $date2 = date("d-m-Y H:i:s");
			// $time_diff = strtotime($date1) - strtotime($date2);
			// $date3 = date('H:i', $time_diff);

			// $date4 = '+'.$date3;


			$tz = new DateTimeZone($timezone);
			$offset = $tz->getOffset(new DateTime());

			// Convert offset to hours and minutes
			$offsetHours = floor($offset / 3600);
			$offsetMinutes = floor(($offset % 3600) / 60);

			// Determine the GMT offset string
			$gmtOffset = sprintf('%+03d:%02d', $offsetHours, $offsetMinutes);
		$allzone = "SELECT z.affiliateid,z.zoneid,z.zonename,z.description,z.delivery,z.width,z.height,z.zonetype,z.comments,DATE_FORMAT(CONVERT_TZ(z.updated,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as updated FROM {$table_prefix}affiliates as af LEFT JOIN {$table_prefix}zones as z ON af.affiliateid=z.affiliateid  where z.affiliateid=:affiliateid Order by updated Desc";
		$djax_query_allzones = $this->db->prepare($allzone);
		$djax_query_allzones->bindParam(":affiliateid", $affiliate_id);
		$djax_query_allzones->execute();
		$stmtzone = $djax_query_allzones->fetchAll();
		$num = count($stmtzone);

		if ($num > 0) {
			if ($stmtzone) {
				$response = array ('data' => $stmtzone, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Publisher Id!'
			);
		}
		return $this->response->withJson($response);
	}
});


//~ /************************Zone *******************/

//~ /************************User *******************/
/*
 *  USER ADD
 * 
 * Input Parameters:
 * --------------- 
 * contactname
 * email
 * username
 * password
 * 
 * Arguments:
 * ---------
 * Account ID
 */
$app->post('/add_user/[{accountid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$accountid = $args['accountid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$email = $input['email'];
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}

		$contactname = $input['contactname'];
		$username = $input['username'];
		$realpassword = $input['password'];
		//password encrypt
		$password = md5($realpassword);


		if (empty ($contactname) && empty ($email) && empty ($password) && empty ($username)) {
			$response = array ('ok' => 'Please enter all required data');

			return $this->response->withJson($response);
		}

		$check_user = "Select username from {$table_prefix}users where username = :username ;";
		$user_det = $this->db->prepare($check_user);
		$user_det->bindParam(":username", $username);
		$user_det->execute();
		$user_data = $user_det->fetchAll();

		if ($user_data) {
			$response = array ('response' => 'error', 'msg' => 'Username already exists');

			return $this->response->withJson($response);
		}




		$account_data = "SELECT * from {$table_prefix}accounts where account_id=:accountid";
		$account_details = $this->db->prepare($account_data);
		$account_details->bindParam(":accountid", $accountid);
		$account_details->execute();
		$accounts = $account_details->fetchAll();


		if ($accounts) {

			$adduser = "INSERT INTO {$table_prefix}users(`contact_name`, `email_address`, `username`, `password`,`default_account_id`,`active`,`date_created`,`email_updated`) 
				VALUES (:contactname,:email,:username,:password,:accountid,1,:datetime,:email_updated);";
			$users = $this->db->prepare($adduser);
			$users->bindParam(":contactname", $contactname);
			$users->bindParam(":email", $email);
			$users->bindParam(":username", $username);
			$users->bindParam(":password", $password);
			$users->bindParam(":accountid", $accountid);
			$users->bindParam(":datetime", $datetime);
			$users->bindParam(":email_updated", $datetime);
			$users->execute();

			$userid = $this->db->lastInsertId();


			$user_perm = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:accountid,:userid,:datetime);";

			$user_dat_perm = $this->db->prepare($user_perm);
			$user_dat_perm->bindParam(":accountid", $accountid);
			$user_dat_perm->bindParam(":userid", $userid);
			$user_dat_perm->bindParam(":datetime", $datetime);
			$user_dat_perm->execute();

			$user_assoc = "INSERT INTO {$table_prefix}account_user_permission_assoc(`account_id`, `user_id`, `permission_id`, `is_allowed`) VALUES
				(:accountid,:userid,10,1),
				(:accountid,:userid,4,1),
				(:accountid,:userid,2,1),
				(:accountid,:userid,1,1),
				(:accountid,:userid,11,1);";

			$user_assoc_details = $this->db->prepare($user_assoc);
			$user_assoc_details->bindParam(":accountid", $accountid);
			$user_assoc_details->bindParam(":userid", $userid);
			$user_assoc_details->execute();
			$response = array (
				'response' => 'ok',
				'msg' => 'userid : ' . $userid . ' Created sucessfully'
			);

			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Account Id!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('user_val'));

/*
 *  USER ADD
 * 
 * Input Parameters:
 * --------------- 
 * contactname
 * email
 * username
 * password
 * mode
 * 
 * Arguments:
 * ---------
 * User ID
 */

$app->post('/edit_user/[{userid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();


		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		$user_details = "SELECT * from {$table_prefix}users where user_id=:userid";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":userid", $userid);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetchAll();
		if (count($stmtuser)) {
			if (isset ($input['username'])) {
				$username = $input['username'];
				$check_user = "Select username from {$table_prefix}users where username = :username ;";
				$user_det = $this->db->prepare($check_user);
				$user_det->bindParam(":username", $username);
				$user_det->execute();
				$user_data = $user_det->fetchAll();

				if ($user_data) {
					$response = array ('response' => 'error', 'msg' => 'Username already exists');

					return $this->response->withJson($response);
				}
			} else {
				$username = $stmtuser[0]['username'];
			}


			if (isset ($input['email'])) {
				$email = $input['email'];
			} else {
				$email = $stmtuser[0]['email_address'];
			}

			if (isset ($input['contactname'])) {
				$contactname = $input['contactname'];
			} else {
				$contactname = $stmtuser[0]['contact_name'];
			}

			if (isset ($input['password'])) {
				$realpassword = $input['password'];
				//password encrypt
				$password = md5($realpassword);
			} else {
				$password = $stmtuser[0]['password'];
			}

			if (isset ($input['username'])) {
				$username = $input['username'];
			} else {
				$username = $stmtuser[0]['username'];
			}


			$updateuser = "update {$table_prefix}users set `contact_name`=:contact_name ,  `username`=:username,`password`=:password,`email_address`=:email_address,date_created=:updated where `user_id`=:user_id";

			$upd_userdet = $this->db->prepare($updateuser);

			$upd_userdet->bindParam(":contact_name", $contactname);
			$upd_userdet->bindParam(":username", $username);
			$upd_userdet->bindParam(":password", $password);
			$upd_userdet->bindParam(":email_address", $email);
			$upd_userdet->bindParam(":updated", $datetime);
			$upd_userdet->bindParam(":user_id", $userid);
			$upd_userdet->execute();

			$response = array (
				'response' => 'OK',
				'msg' => 'userid:' . $userid . ' edited successfully!'
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid user Id!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('userid_edit'));

// Edit User language 

$app->post('/edit_user_language/[{userid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		$user_details = "SELECT * from {$table_prefix}users where user_id=:userid";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":userid", $userid);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetchAll();
		if (count($stmtuser)) {
			if (isset ($input['language'])) {
				$language = $input['language'];
			} else {
				$language = $stmtuser[0]['language'];
			}

			if (isset ($input['contact_name'])) {
				$contact_name = $input['contact_name'];
			} else {
				$contact_name = $stmtuser[0]['contact_name'];
			}

			$updateuser = "update {$table_prefix}users set `language`=:language,`contact_name`=:contact_name ,date_created=:updated where `user_id`=:user_id";

			$upd_userdet = $this->db->prepare($updateuser);

			$upd_userdet->bindParam(":language", $language);
			$upd_userdet->bindParam(":contact_name", $contact_name);
			$upd_userdet->bindParam(":updated", $datetime);
			$upd_userdet->bindParam(":user_id", $userid);
			$upd_userdet->execute();

			$_SESSION['language'] = $language;

			$responses = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'language updated successfully!'
			);
			$response = array (
				'data' => $responses
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid user Id!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('userid_edit'));

// Edit User Change Password 

$app->post('/user_change_password/[{userid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		$user_details = "SELECT * from {$table_prefix}users where user_id=:userid";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":userid", $userid);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetchAll();
		if (count($stmtuser)) {
			$currentpassword1 = $input['currentpassword'];
			//$currentpassword = md5($currentpassword1);
			$currentpassword=password_hash($currentpassword1, PASSWORD_BCRYPT);
			//print_r($currentpassword);exit("ok");
			if (isset ($input['password'])) {
				$realpassword = $input['password'];
				$password = password_hash($realpassword,PASSWORD_BCRYPT);
			} else {
				$password = $stmtuser[0]['password'];
			}
			$oldpwd = $stmtuser[0]['password'];
			if ($currentpassword == $oldpwd) {
				$updateuser = "update {$table_prefix}users set `password`=:password ,date_created=:updated where `user_id`=:user_id";

				$upd_userdet = $this->db->prepare($updateuser);

				$upd_userdet->bindParam(":password", $password);
				$upd_userdet->bindParam(":updated", $datetime);
				$upd_userdet->bindParam(":user_id", $userid);
				$upd_userdet->execute();
			} else {
				$responses = array (
					'msg' => 'Your current password not matched in old password',
					'response' => 'success',
					'statuscode' => '200'
				);
				$response = array (
					'data' => $responses
				);
				return $this->response->withJson($response);
			}

			$responses = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'password updated successfully!'
			);
			$response = array (
				'data' => $responses
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid user Id!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('userid_edit'));

/*
 * User Delete
 * 
 * Input Parameters:
 * --------------- 
 * Nil
 * 
 * Arguments:
 * ---------
 * User ID
 */

$app->delete('/delete_user/[{userid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$user_details = "SELECT * from {$table_prefix}users where user_id=:userid";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":userid", $userid);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetchAll();
		if (count($stmtuser)) {


			$delete_user = "DELETE FROM {$table_prefix}users WHERE user_id=:userid";
			$del_user = $this->db->prepare($delete_user);
			$del_user->bindParam(":userid", $userid);
			$del_user->execute();


			$user_assoc = "DELETE FROM {$table_prefix}account_user_assoc WHERE user_id=:userid";
			$delete_assoc = $this->db->prepare($user_assoc);
			$delete_assoc->bindParam(":userid", $userid);
			$delete_assoc->execute();


			$rem_permission = "DELETE FROM {$table_prefix}account_user_permission_assoc WHERE user_id=:userid";
			$user_permission = $this->db->prepare($rem_permission);
			$user_permission->bindParam(":userid", $userid);
			$user_permission->execute();
			$response = array (
				'response' => 'ok',
				'msg' => 'User has been deleted successfully!'
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid user Id!'
			);
		}
		return $this->response->withJson($response);
	}
})->add($container->get('userid_val'));

/*
 * Get User details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * User ID
 */

$app->get('/get_user/[{userid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$currentdate = date('Y-m-d');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$userdet = "select * from {$table_prefix}users where user_id=:userid";
		$userdetail = $this->db->prepare($userdet);
		$userdetail->bindParam(":userid", $userid);
		$userdetail->execute();
		$stmtuser = $userdetail->fetchAll();

		$usrdetail = array ();

		if ($currentdate > $stmtuser[0]['date_created']) {
			$response = array ('response' => 'error', 'msg' => 'url link is expired');
			return $this->response->withJson($response);
		} else {

			if (count($stmtuser) > 0) {
				//[$userid]		
				$usrdetail = array (
					'userid' => $userid,
					'username' => $stmtuser[0]['username'],
					'language' => $stmtuser[0]['language'],
					'contact_name' => $stmtuser[0]['contact_name'],
					'email_address' => $stmtuser[0]['email_address'],
					'password' => $stmtuser[0]['password'],
					'date_created' => $stmtuser[0]['date_created']
				);

				return $this->response->withJson($usrdetail);
			}
		}
	}
})->add($container->get('userid_val'));

$app->get('/get_user_language/[{userid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$userdet = "select * from {$table_prefix}users where user_id=:userid";
		$userdetail = $this->db->prepare($userdet);
		$userdetail->bindParam(":userid", $userid);
		$userdetail->execute();
		$stmtuser = $userdetail->fetchAll();

		$usrdetail = array ();

		if (count($stmtuser) > 0) {
			//[$userid]		
			$usrdetail = array (
				'userid' => $userid,
				'username' => $stmtuser[0]['username'],
				'language' => $stmtuser[0]['language'],
				'contact_name' => $stmtuser[0]['contact_name'],
				'email_address' => $stmtuser[0]['email_address']
			);

			$response = array ('data' => $usrdetail, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');

			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'There is No user under this Requested id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('userid_val'));

/*
 * Get All User details
 * 
 * Input Parameters:
 * --------------- 
 * NIL
 * 
 * Arguments:
 * ---------
 * Account ID
 */


$app->get('/get_all_user/[{accountid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$accountid = $args['accountid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$alluserdet = "select * from {$table_prefix}users where default_account_id=:accountid";
		$userdetail = $this->db->prepare($alluserdet);
		$userdetail->bindParam(":accountid", $accountid);
		$userdetail->execute();
		$stmtusers = $userdetail->fetchAll();
		$userdetails = array ();


		if (count($stmtusers) > 0) {

			foreach ($stmtusers as $alluser) {

				$userdetails[$alluser['user_id']] = array (
					'accountid' => $accountid,
					'userid' => $alluser['user_id'],
					'username' => $alluser['username'],
					'username' => $alluser['username'],
					'contact_name' => $alluser['contact_name'],
					'email_address' => $alluser['email_address'],
					'password' => $alluser['password']
				);
			}
			return $this->response->withJson($userdetails);
		} else {
			$response = array ('response' => 'error', 'msg' => 'There is No user under this Requested id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('accountid_val'));

//All US Metro API

$app->get('/get_all_usmetro/', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		include_once ('data/res-us-metro.inc.php');
		$num = count($RV_Geo_US_Metro);
		$countryarray = array ();
		$keyl = '';
		$countryl = '';
		$i = 0;

		foreach ($RV_Geo_US_Metro as $key => $country) {

			$keyl = $key;
			$countryl = $country;
			$countryarray[$i] = array ('usmetro_code' => $keyl, 'usmetro_name' => $countryl);
			$i++;
		}

		if ($num > 0) {
			if ($countryarray) {
				$response = array ('data' => $countryarray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//All Country API


$app->get('/get_all_country/', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		include_once ('data/res-iso3166-1.inc.php');
		$num = count($RV_Geo_ISO3166_1);
		$countryarray = array ();
		$keyl = '';
		$countryl = '';
		$i = 0;

		foreach ($RV_Geo_ISO3166_1 as $key => $country) {

			$keyl = $key;
			$countryl = $country;
			$countryarray[$i] = array ('country_code' => $keyl, 'country_name' => $countryl);
			$i++;
		}

		if ($num > 0) {
			if ($countryarray) {
				$response = array ('data' => $countryarray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//All Subdivision1 Country API

$app->get('/get_subdiv1_country/', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		include_once ('data/res-iso3166-1.inc.php');
		$num = count($RV_Geo_ISO3166_2);
		$countryarray = array ();
		$keyl = '';
		$countryl = '';
		$i = 0;

		foreach ($RV_Geo_ISO3166_2 as $key => $country) {
			$keyl = $key;
			$countryl = $country;
			$countryarray[$i] = array ('country_code' => $keyl, 'country_name' => $countryl);
			$i++;
		}

		if ($num > 0) {
			if ($countryarray) {
				$response = array ('data' => $countryarray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//All Subdivision2 Country API

$app->get('/get_subdiv2_country/', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		include_once ('data/res-iso3166-1.inc.php');
		$num = count($RV_Geo_ISO3166_3);
		$countryarray = array ();
		$keyl = '';
		$countryl = '';
		$i = 0;

		foreach ($RV_Geo_ISO3166_3 as $key => $country) {
			$keyl = $key;
			$countryl = $country;
			$countryarray[$i] = array ('country_code' => $keyl, 'country_name' => $countryl);
			$i++;
		}

		if ($num > 0) {
			if ($countryarray) {
				$response = array ('data' => $countryarray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//All Subdivition 1 API

$app->get('/get_all_subdivition1/[{countrycode}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		include_once ('data/res-iso3166-2-S1.inc.php');
		$num = count($RV_Geo_ISO3166_2_S1);
		$countrycode = $args['countrycode'];
		$countryarray = array ();
		$statearray = array ();
		$keyl = '';
		$countryl = '';
		$i = 0;
		//print_r($RV_Geo_ISO3166_2_S1);

		foreach ($RV_Geo_ISO3166_2_S1 as $key => $country) {
			$keyl = $key;
			if ($keyl == $countrycode) {
				foreach ($country as $keystate => $state) {
					$statearray[$i] = array ('state_code' => $keystate, 'state_name' => $state);
					$i++;
				}
			}
		}


		if ($num > 0) {
			if ($statearray) {
				$response = array ('data' => $statearray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//All Subdivition 2 API

$app->get('/get_all_subdivition2/[{countrycode}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		include_once ('data/res-iso3166-2-S2.inc.php');
		$num = count($RV_Geo_ISO3166_2_S2);
		//print_r($RV_Geo_ISO3166_2_S2);
		$countrycode = $args['countrycode'];
		$countryarray = array ();
		$statearray = array ();
		$keyl = '';
		$countryl = '';
		$i = 0;
		//print_r($RV_Geo_ISO3166_2_S2);

		foreach ($RV_Geo_ISO3166_2_S2 as $key => $country) {
			$keyl = $key;
			if ($keyl == $countrycode) {
				foreach ($country as $keystate => $state) {
					foreach ($state as $keystate => $states) {
						$statearray[$i] = array ('state_code' => $keystate, 'state_name' => $states);
						$i++;
					}
				}
			}
		}
		//print_r($countrystatearray);
		if ($num > 0) {
			if ($statearray) {
				$response = array ('data' => $statearray, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//All State API

$app->get('/get_all_state/[{countrycode}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$countrycode = $args['countrycode'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$allstatscountry = "SELECT `country`,`region`,`city` FROM `{$table_prefix}stats_country` where country='" . $countrycode . "' and region!='' Group by region Order By region ASC";
		$djax_query_allstatscountrys = $this->db->prepare($allstatscountry);
		$djax_query_allstatscountrys->execute();
		$stmtstatscountry = $djax_query_allstatscountrys->fetchAll();
		//$djax_query_allzones->bindParam(":country",$countrycode);

		$num = count($stmtstatscountry);

		if ($num > 0) {
			if ($stmtstatscountry) {
				$response = array ('data' => $stmtstatscountry, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//All City API

$app->get('/get_all_city/[{countrycode}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$countrycode = $args['countrycode'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$allstatscountry = "SELECT `country`,`region`,`city` FROM `{$table_prefix}stats_country` where country='" . $countrycode . "' and city!='' Group by city Order By city ASC";
		$djax_query_allstatscountrys = $this->db->prepare($allstatscountry);
		$djax_query_allstatscountrys->execute();
		$stmtstatscountry = $djax_query_allstatscountrys->fetchAll();
		//$djax_query_allzones->bindParam(":country",$countrycode);

		$num = count($stmtstatscountry);

		if ($num > 0) {
			if ($stmtstatscountry) {
				$response = array ('data' => $stmtstatscountry, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Data');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid API!'
			);
		}
		return $this->response->withJson($response);
	}
});

//Bannersizewise Zone

/* $app->get('/get_bannersizewise_zone/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();


		$bannervalue = "select * from {$table_prefix}banners where bannerid=:bannerid";
		$djax_query_bannervalue = $this->db->prepare($bannervalue);
		$djax_query_bannervalue->bindParam(":bannerid", $bannerid);
		$djax_query_bannervalue->execute();

		$stmtbannervalue = $djax_query_bannervalue->fetchAll();

		$zonenum = count($stmtbannervalue);

		$id = $stmtbannervalue[0]['campaignid'];

		$getid = explode(',', $id);
		$treezone = array();
		// print_r($stmtbannervalue);exit("okok");
		if ($stmtbannervalue) {
			foreach ($getid as $campaignid) {
				//get banners
				$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);
			}

			$clientid = $stmtcampaignvalue[0]['clientid'];
			$banwidth = $stmtbannervalue[0]['width'];
			$banheight = $stmtbannervalue[0]['height'];

			echo $publishervalue = "select p.id as publisher_id, p.name as publisher_name,afl.name,afl.affiliateid from {$table_prefix}publishers p,{$table_prefix}affiliates afl,{$table_prefix}clients cle where afl.agencyid=cle.agencyid and p.id=afl.publisher_id and cle.clientid=$clientid";
			
			exit;
			$djax_query_publishervalue->execute();

			$stmtpublishervalue = $djax_query_publishervalue->fetchAll();

			$countpubval = count($stmtpublishervalue);

			foreach ($stmtpublishervalue as $pubval) {
				$publisher_id = $pubval['publisher_id'];
				$publisher_name = $pubval['publisher_name'];
				$websitename = $pubval['name'];
				$websiteid = $pubval['affiliateid'];

				$zonevalue = "select zon.zoneid,zon.zonename,zon.width,zon.height,zon.delivery,zon.description from {$table_prefix}zones zon where zon.affiliateid=$websiteid";
				$djax_query_zonevalue = $this->db->prepare($zonevalue);

				$djax_query_zonevalue->execute();

				$stmtzonevalue = $djax_query_zonevalue->fetchAll();

				$countzonval = count($stmtzonevalue);

				if ($countzonval > 0) {
					foreach ($stmtbannervalue as $banval) {
						$banwidth = $banval['width'];
						$banheight = $banval['height'];
						$bantype = $banval['storagetype'];
						foreach ($stmtzonevalue as $zoneval) {
							$width = $zoneval['width'];
							$height = $zoneval['height'];
							if ($bantype == 'txt') {
								if ($width == $banwidth && $height == $banheight) {
									$treezone1[] = array(
										'zoneid' => $zoneval['zoneid'],
										'zonename' => $zoneval['zonename'],
										'zonewidth' => $zoneval['width'],
										'zoneheight' => $zoneval['height'],
										'zonedescription' => $zoneval['description']
									);
								}
							} else {

								if (($width == $banwidth && $height == $banheight) || ($width == -1 && $height == -1)) {
									$treezone1[] = array(
										'zoneid' => $zoneval['zoneid'],
										'zonename' => $zoneval['zonename'],
										'zonewidth' => $zoneval['width'],
										'zoneheight' => $zoneval['height'],
										'zonedescription' => $zoneval['description']
									);
								}
							}
						}
					}
					foreach ($treezone1 as $zones) {
						$zoneid = $zones['zoneid'];
						$zonename = $zones['zonename'];
						$zonedescription = $zones['zonedescription'];

						$placementValue = "select * from {$table_prefix}ad_zone_assoc where zone_id=:zoneid and ad_id=:ad_id";
						$djax_query_placevalue = $this->db->prepare($placementValue);
						$djax_query_placevalue->bindParam(":zoneid", $zoneid);
						$djax_query_placevalue->bindParam(":ad_id", $bannerid);
						$djax_query_placevalue->execute();
						$stmtplacevalue = $djax_query_placevalue->fetchAll();
						$placementcount = count($stmtplacevalue);

						$treezone[] = array(
							'zoneid' => $zones['zoneid'],
							'zonename' => $zones['zonename'],
							'zonedescription' => $zones['zonedescription'],
							'zonecount' => $placementcount
						);
					}
				}
				if ($treezone != []) {
					$todos[] = [
						'publishername' => $publisher_name,
						'publisherid' => $publisher_id,
						'websitename' => $websitename,
						'websiteid' => $websiteid,
						'zones' => $treezone
					];
				}
				$treezone1 = [];
				$treezone = [];
			}
			$response = array('data' => $todos, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');

			return $this->response->withJson($response);
		} else {
			$response = array(
				'response' => 'Error',
				'msg' => 'There is no zone exists under this requested id!'
			);
			return $this->response->withJson($response);
		}
	}
}); */

//Bannersizewise Zone

$app->get('/get_bannersizewise_zone/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array();


		$bannervalue = "select * from {$table_prefix}banners where bannerid=:bannerid";
		$djax_query_bannervalue = $this->db->prepare($bannervalue);
		$djax_query_bannervalue->bindParam(":bannerid", $bannerid);
		$djax_query_bannervalue->execute();

		$stmtbannervalue = $djax_query_bannervalue->fetchAll();

		$zonenum = count($stmtbannervalue);

		$id = $stmtbannervalue[0]['campaignid'];

		$getid = explode(',', $id);
		$treezone = array();
		// print_r($stmtbannervalue);exit("okok");
		if ($stmtbannervalue) {
			foreach ($getid as $campaignid) {
				//get banners
				$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);
			}

			$clientid = $stmtcampaignvalue[0]['clientid'];
			$banwidth = $stmtbannervalue[0]['width'];
			$banheight = $stmtbannervalue[0]['height'];

			$publishervalue = "select afl.name,afl.affiliateid from {$table_prefix}affiliates afl ,{$table_prefix}clients cle where afl.agencyid=cle.agencyid  and cle.clientid=$clientid";
			$djax_query_publishervalue = $this->db->prepare($publishervalue);

			$djax_query_publishervalue->execute();

			$stmtpublishervalue = $djax_query_publishervalue->fetchAll();

			$countpubval = count($stmtpublishervalue);

			foreach ($stmtpublishervalue as $pubval) {
				$publishername = $pubval['name'];
				$publisherid = $pubval['affiliateid'];

				$zonevalue = "select zon.zoneid,zon.zonename,zon.width,zon.height,zon.delivery,zon.description from {$table_prefix}zones zon where zon.affiliateid=$publisherid";
				$djax_query_zonevalue = $this->db->prepare($zonevalue);

				$djax_query_zonevalue->execute();

				$stmtzonevalue = $djax_query_zonevalue->fetchAll();

				$countzonval = count($stmtzonevalue);

				if ($countzonval > 0) {
					foreach ($stmtbannervalue as $banval) {
						$banwidth = $banval['width'];
						$banheight = $banval['height'];
						$bantype = $banval['storagetype'];
						foreach ($stmtzonevalue as $zoneval) {
							$width = $zoneval['width'];
							$height = $zoneval['height'];
							if ($bantype == 'txt') {
								if ($width == $banwidth && $height == $banheight) {
									$treezone1[] = array(
										'zoneid' => $zoneval['zoneid'],
										'zonename' => $zoneval['zonename'],
										'zonewidth' => $zoneval['width'],
										'zoneheight' => $zoneval['height'],
										'zonedescription' => $zoneval['description']
									);
								}
							} else {

								if (($width == $banwidth && $height == $banheight) || ($width == -1 && $height == -1)) {
									$treezone1[] = array(
										'zoneid' => $zoneval['zoneid'],
										'zonename' => $zoneval['zonename'],
										'zonewidth' => $zoneval['width'],
										'zoneheight' => $zoneval['height'],
										'zonedescription' => $zoneval['description']
									);
								}
							}
						}
					}
					foreach ($treezone1 as $zones) {
						$zoneid = $zones['zoneid'];
						$zonename = $zones['zonename'];
						$zonedescription = $zones['zonedescription'];

						$placementValue = "select * from {$table_prefix}ad_zone_assoc where zone_id=:zoneid and ad_id=:ad_id";
						$djax_query_placevalue = $this->db->prepare($placementValue);
						$djax_query_placevalue->bindParam(":zoneid", $zoneid);
						$djax_query_placevalue->bindParam(":ad_id", $bannerid);
						$djax_query_placevalue->execute();
						$stmtplacevalue = $djax_query_placevalue->fetchAll();
						$placementcount = count($stmtplacevalue);

						$treezone[] = array(
							'zoneid' => $zones['zoneid'],
							'zonename' => $zones['zonename'],
							'zonedescription' => $zones['zonedescription'],
							'zonecount' => $placementcount
						);
					}

				}
				if ($treezone != []) {
					$todos[] = [
						'publishername' => $publishername,
						'publisherid' => $publisherid,
						'zones' => $treezone
					];
				}
				$treezone1 = [];
				$treezone = [];
			}
			$response = array('data' => $todos, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');

			return $this->response->withJson($response);
		} else {
			$response = array(
				'response' => 'Error',
				'msg' => 'There is no zone exists under this requested id!'
			);
			return $this->response->withJson($response);
		}
	}
});


$app->post('/getBannerListing/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['campaignid'];
		$getid = explode(',', $id);

		$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_zonevalue = $this->db->prepare($zonevalue);
		$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
		$djax_query_zonevalue->execute();

		$stmtzonevalue = $djax_query_zonevalue->fetchAll();

		$zonenum = count($stmtzonevalue);

		if ($stmtzonevalue) {
			foreach ($getid as $campaignid) {
				//get banners
				$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);

				$bannerval = "select * from {$table_prefix}banners where campaignid=:campaignid";
				$get_banner_det = $this->db->prepare($bannerval);
				$get_banner_det->bindParam(":campaignid", $campaignid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();
				$bannernum = count($stmtbannervalue);

				$zonewidth = $stmtzonevalue[0]['width'];
				$zoneheight = $stmtzonevalue[0]['height'];
				$zonetype = $stmtzonevalue[0]['delivery'];
				//banner validation
				if (empty ($num)) {

					$response = array (
						'response' => 'Error',
						'msg' => 'There is no campaign or banner exists under this requested id!'
					);
					return $this->response->withJson($response);
				}

				foreach ($stmtbannervalue as $campaignvalue) {

					$bannerid = $campaignvalue['bannerid'];
					$width = $campaignvalue['width'];
					$height = $campaignvalue['height'];
					$bannertype = $campaignvalue['storagetype'];
					$exttype = $campaignvalue['ext_bannertype'];


					if (
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
						($bannertype == 'txt' && $zonetype == 3) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||

						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml')
							&& $zonetype == 6) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml')
							&& $zonetype == 7) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:genericHtml') && ($zonetype == 7
							|| $zonetype == 0 || $zonetype == 0 || $zonetype == 4))
					) {

						if (($width == $zonewidth && $height == $zoneheight) || ($zonewidth == -1 && $zoneheight == -1)) {
							$bannerid = $campaignvalue['bannerid'];
							$bannerdescription = $campaignvalue['description'];
							$response = array ('bannerid' => $bannerid, 'bannername' => $bannerdescription, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
						} else {
							$response = array (
								'response' => 'ok',
								'msg' => 'Width and height doesnot match for banner and zone'
							);
						}
					} else {
						$response = array (
							'response' => 'ok',
							'msg' => 'Type doesnot match for banner and zone'
						);
					}
				}
			}
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'There is no zone exists under this requested id!'
			);
			return $this->response->withJson($response);
		}
	}
})->add($container->get('cz_link'));



/*************************** Linking campaign by zone id********************************************/


$app->post('/getCampaignListing/[{zoneid}]', function ($request, $response, $args) {

	$datetime = date('Y-m-d H:i:s');
	$results = array ();
	$zoneid = $args['zoneid'];
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$input = $request->getParsedBody();
	$datetime = date('Y-m-d H:i:s');
	$results = array ();

	$clientid = $input['clientid'];
	$stc = "SELECT * FROM " . $table_prefix . "zones where zoneid =" . $zoneid;
	$std = $this->db->prepare($stc);
	$std->execute();
	$zone_det = $std->fetchAll();


	if (count($zone_det) <= 0) {
		$response = array ('response' => 'error', 'msg' => 'Enter valid zoneid!');
		return $this->response->withJson($response);
	} else {
		$zonewidth = $zone_det[0]['width'];
		$zoneheight = $zone_det[0]['height'];

		if ($zonewidth == '-1' && $zoneheight == '-1') {

			$bannerval = "select * from {$table_prefix}banners where storagetype NOT IN ('txt')";
			$get_banner_det = $this->db->prepare($bannerval);

			$get_banner_det->execute();
			$stmtbannervalue = $get_banner_det->fetchAll();
			$bannernum = count($stmtbannervalue);



			$camp_unique = array ();
			foreach ($stmtbannervalue as $banner_details) {
				if (!in_array($banner_details['campaignid'], $camp_unique)) {
					$camp_unique[] = $banner_details['campaignid'];
				}
			}

			$placementlist = array ();
			$campaign_details = array ();
			for ($i = 0; $i < count($camp_unique); $i++) {

				$bannerval = "select * from {$table_prefix}campaigns where campaignid=:campaignid and clientid=:clientid";
				$get_banner_det = $this->db->prepare($bannerval);

				$get_banner_det->bindParam(":campaignid", $camp_unique[$i]);
				$get_banner_det->bindParam(":clientid", $clientid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();

				$placementlist[] = $stmtbannervalue;
				if (!empty ($stmtbannervalue)) {


					$placementlist[] = $camp_unique[$i];

					$bannerval = "select campaignid,campaignname from {$table_prefix}campaigns where campaignid=:campaignid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":campaignid", $camp_unique[$i]);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();
					$campaign_details[] = $stmtbannervalue;
				}
			}



			$campaign_list = array ();
			foreach ($campaign_details as $campaign) {
				foreach ($campaign as $values) {
					$campaign_list[] = $values;
				}
			}

			if (!empty ($campaign_list)) {

				$response = $campaign_list;
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Campaigns available for the zone');
				return $this->response->withJson($response);
			}
		} else {
			$bannerval = "select * from {$table_prefix}banners where width=:zonewidth and height=:zoneheight";
			$get_banner_det = $this->db->prepare($bannerval);
			$get_banner_det->bindParam(":zonewidth", $zonewidth);
			$get_banner_det->bindParam(":zoneheight", $zoneheight);
			$get_banner_det->execute();
			$stmtbannervalue = $get_banner_det->fetchAll();
			$bannernum = count($stmtbannervalue);



			$camp_unique = array ();
			foreach ($stmtbannervalue as $banner_details) {
				if (!in_array($banner_details['campaignid'], $camp_unique)) {
					$camp_unique[] = $banner_details['campaignid'];
				}
			}

			$placementlist = array ();
			$campaign_details = array ();
			for ($i = 0; $i < count($camp_unique); $i++) {

				$bannerval = "select * from {$table_prefix}campaigns where campaignid=:campaignid and clientid=:clientid";
				$get_banner_det = $this->db->prepare($bannerval);

				$get_banner_det->bindParam(":campaignid", $camp_unique[$i]);
				$get_banner_det->bindParam(":clientid", $clientid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();

				$placementlist[] = $stmtbannervalue;
				if (!empty ($stmtbannervalue)) {

					// $bannerval="select * from {$table_prefix}placement_zone_assoc where placement_id=:campaignid and zone_id=:zoneid";
					// $get_banner_det=$this->db->prepare($bannerval);
					// $get_banner_det->bindParam(":campaignid",$camp_unique[$i]);
					// $get_banner_det->bindParam(":zoneid",$zoneid);
					// $get_banner_det->execute();
					// $stmtbannervalue=$get_banner_det->fetchAll();	

					// if(count($stmtbannervalue)==0){

					$placementlist[] = $camp_unique[$i];

					$bannerval = "select campaignid,campaignname from {$table_prefix}campaigns where campaignid=:campaignid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":campaignid", $camp_unique[$i]);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();
					$campaign_details[] = $stmtbannervalue;

					// }
				}
			}



			$campaign_list = array ();
			foreach ($campaign_details as $campaign) {
				foreach ($campaign as $values) {
					$campaign_list[] = $values;
				}
			}

			if (!empty ($campaign_list)) {

				$response = $campaign_list;
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'ok', 'msg' => 'No Campaigns available for the zone');
				return $this->response->withJson($response);
			}
		}
	}
});

/***********************************************************************/

/*************************** Linked Ad by zone ********************************************/
/*
 * Linked Ad by zone
 * 
 * Input Parameters:
 * --------------- 
 * Banner ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

/* $app->post('/adbyzone_link/[{zoneid}]', function($request, $response, $args)
	   { 
	   
	   if ($request->getAttribute('has_errors')) {
	   //There are errors, read them
	   $response = array('response'=>'error','msg'=>'Please check with input parameters');
	   return $this->response->withJson($response);     
	   return $response;
	   exit;
	   } else {
	   
	   $datetime = date('Y-m-d H:i:s');	
	   $results = array();
	   $zoneid = $args['zoneid'];
	   $table_prefix = $this->get('settings')['path']['table_prefix'];		
	   $input    = $request->getParsedBody();
	   $datetime = date('Y-m-d H:i:s');	
	   $results = array();
	   $id = $input['bannerid'];
	   $getbannerid = explode(',',$id);
	   
	   
	   $zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
	   $zonedet = $this->db->prepare($zoneval);
	   $zonedet->bindParam(":zoneid",$zoneid);
	   $zonedet->execute();
	   $stmtzonevalue=$zonedet->fetchAll();
	   // echo "<pre>";print_r($stmtzonevalue);exit;
	   if(!$stmtzonevalue)
	   {
	   $response = array('response' => 'error','msg' => 'Please provide valid zoneid!');
	   return $this->response->withJson($response);
	   }
	   
	   
	   $bannerval = "select * from {$table_prefix}banners where bannerid=:banner_id";
	   $bannerdet = $this->db->prepare($bannerval);
	   $bannerdet->bindParam(":banner_id",$id);
	   $bannerdet->execute();
	   $stmtbannervalue=$bannerdet->fetchAll();
	   if(!$stmtbannervalue)
	   {
	   $response = array('response' => 'error','msg' => 'Please provide valid Bannerid!');
	   return $this->response->withJson($response);
	   }
	   
	   
	   $zonenum=count($stmtzonevalue);
	   
	   foreach($getbannerid as $bannerid)
	   {
	   $bannerval="select * from {$table_prefix}banners where bannerid=:bannerid";
	   $get_banner_det=$this->db->prepare($bannerval);
	   $get_banner_det->bindParam(":bannerid",$bannerid);
	   $get_banner_det->execute();
	   $stmtbannervalue=$get_banner_det->fetchAll();	
	   $bannernum=count($stmtbannervalue);
	   // echo "<pre>";print_r($stmtbannervalue);exit;
	   
	   //validation for zone and banner
	   if(!$stmtbannervalue)
	   {
	   $response = array('response' => 'error','msg' => 'Please provide valid Bannerid!');
	   return $this->response->withJson($response);
	   }
	   
	   
	   foreach($stmtbannervalue as $bannervalue)
	   {
	   
	   $width=$bannervalue['width'];
	   $height=$bannervalue['height'];
	   $bannertype=$bannervalue['storagetype'];
	   $exttype=$bannervalue['ext_bannertype'];
	   
	   }
	   
	   $zonewidth=$stmtzonevalue[0]['width'];
	   $zoneheight=$stmtzonevalue[0]['height'];
	   $zonetype=$stmtzonevalue[0]['delivery'];
	   
	   //type validation
	   if( 
	   (($bannertype=='web'||$bannertype=='sql'||$bannertype=='url') && $zonetype==0 ) || 
	   (($bannertype=='web'||$bannertype=='sql'||$bannertype=='url') && $zonetype==1 )||
	   ($bannertype=='txt' && $zonetype==3 )||
	   (($bannertype=='web'||$bannertype=='sql'||$bannertype=='url') && $zonetype==4 )||
	   
	   (($bannertype=='html' && 
	   $exttype=='bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype==6 ) ||
	   (($bannertype=='html' && 
	   $exttype=='bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') &&  $zonetype==7 ) ||
	   (($bannertype=='html' && 
	   $exttype=='bannerTypeHtml:oxHtml:genericHtml')
	   &&  ($zonetype==7 || $zonetype==0 || $zonetype==0 || $zonetype==4)) )
	   
	   {
	   // echo "<pre>";print_r($width);echo "****";
	   // print_r($zonewidth);exit;
	   //validation for width and height
	   if(($width==$zonewidth && $height==$zoneheight) || ($zonewidth == -1 && $zoneheight == -1))
	   {
	   
	   $adzoneassoc="INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
	   `priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
	   VALUES (:zoneid, :bannerid,0,1,1,1);";
	   
	   $djax_query_adzoneassoc=$this->db->prepare($adzoneassoc);
	   $djax_query_adzoneassoc->bindParam(":zoneid",$zoneid);
	   $djax_query_adzoneassoc->bindParam(":bannerid",$bannerid);
	   $djax_query_adzoneassoc->execute();
	   
	   $response = array(
	   'response' => 'ok',
	   'msg' => 'Banners linked successfully to the zoneid!'
	   );
	   
	   }
	   else
	   {
	   
	   $response=array('ERROR'=>'Width and height doesnot match for banner and zone');
	   //return $this->response->withJson($response);	
	   }
	   }
	   else
	   {
	   
	   $response=array('ERROR'=>'Type doesnot match for banner and zone');
	   //return $this->response->withJson($response);	
	   }
	   }
	   return $this->response->withJson($response);
	   
	   }
	   
   })->add($container->get('az_link')); */

$app->post('/bannerbyzone_link/[{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['bannerid'];
		$getbannerid = explode(',', $id);

		//print_r($getbannerid);
		$selban = "select * from {$table_prefix}ad_zone_assoc where zone_id=:zoneid and ad_id=:ad_id";
		$zonedetail = $this->db->prepare($selban);
		$zonedetail->bindParam(":zoneid", $zoneid);
		$zonedetail->bindParam(":ad_id", $id);
		$zonedetail->execute();
		$valrow = $zonedetail->fetchAll();
		$valcount = count($valrow);
		//print_r($valrow);
		if ($valcount < 1) {
			$zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
			$zonedet = $this->db->prepare($zoneval);
			$zonedet->bindParam(":zoneid", $zoneid);
			$zonedet->execute();
			$stmtzonevalue = $zonedet->fetchAll();
			// echo "<pre>";print_r($stmtzonevalue);exit;
			if (!$stmtzonevalue) {
				$response = array ('response' => 'error', 'msg' => 'Please provide valid zoneid!');
				return $this->response->withJson($response);
			}


			$bannerval = "select * from {$table_prefix}banners where bannerid=:banner_id";
			$bannerdet = $this->db->prepare($bannerval);
			$bannerdet->bindParam(":banner_id", $id);
			$bannerdet->execute();
			$stmtbannervalue = $bannerdet->fetchAll();
			if (!$stmtbannervalue) {
				$response = array ('response' => 'error', 'msg' => 'Please provide valid Bannerid!');
				return $this->response->withJson($response);
			}


			$zonenum = count($stmtzonevalue);

			foreach ($getbannerid as $bannerid) {
				$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
				$get_banner_det = $this->db->prepare($bannerval);
				$get_banner_det->bindParam(":bannerid", $bannerid);
				$get_banner_det->execute();
				$stmtbannervalue = $get_banner_det->fetchAll();
				$bannernum = count($stmtbannervalue);
				// echo "<pre>";print_r($stmtbannervalue);exit;

				//validation for zone and banner
				if (!$stmtbannervalue) {
					$response = array ('response' => 'error', 'msg' => 'Please provide valid Bannerid!');
					return $this->response->withJson($response);
				}


				foreach ($stmtbannervalue as $bannervalue) {

					$width = $bannervalue['width'];
					$height = $bannervalue['height'];
					$bannertype = $bannervalue['storagetype'];
					$exttype = $bannervalue['ext_bannertype'];
				}

				$zonewidth = $stmtzonevalue[0]['width'];
				$zoneheight = $stmtzonevalue[0]['height'];
				$zonetype = $stmtzonevalue[0]['delivery'];

				//type validation 
				if (
					(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
					(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
					($bannertype == 'txt' && $zonetype == 3) ||
					(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||
					(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:html5')) ||
					(($bannertype == 'html' &&
						$exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype == 6) ||
					(($bannertype == 'html' &&
						$exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') && $zonetype == 7) ||
					(($bannertype == 'html' &&
						$exttype == 'bannerTypeHtml:oxHtml:genericHtml')
						&& ($zonetype == 7 || $zonetype == 0 || $zonetype == 1 || $zonetype == 4))
				) {
					// echo "<pre>";print_r($width);echo "****";
					// print_r($zonewidth);exit;
					//validation for width and height
					if (($width == $zonewidth && $height == $zoneheight) || ($zonewidth == -1 && $zoneheight == -1)) {

						$adzoneassoc = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,
							`priority`, `link_type`,`priority_factor`,`to_be_delivered`) 
							VALUES (:zoneid, :bannerid,0,1,1,1);";

						$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
						$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
						$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
						$djax_query_adzoneassoc->execute();

						$response = array (
							'response' => 'ok',
							'msg' => 'Banners linked successfully to the zoneid!'
						);
					} else {

						$response = array ('ERROR' => 'Width and height doesnot match for banner and zone');
						//return $this->response->withJson($response);	
					}
				} else {

					$response = array ('ERROR' => 'Type doesnot match for banner and zone');
					//return $this->response->withJson($response);	
				}
			}
			return $this->response->withJson($response);
		} else {
			$response = array ('ERROR' => 'Banner already linked with zone', 'msg' => 'Banner already linked with zone');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('az_link'));


$app->post('/zonebybanner_link/[{bannerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		// $id= $input['zoneid'];
		$id = file_get_contents("php://input");

		$jsonid = json_decode($id);
		// $getzoneid = explode(",",$id);


		//print_r($jsonid);
		foreach ($jsonid as $key => $val) {
			foreach ($val as $_key => $zoneid) {


				$placementValue = "select * from {$table_prefix}ad_zone_assoc where 
					zone_id=:zoneid and ad_id=:ad_id";
				$djax_query_placevalue = $this->db->prepare($placementValue);
				$djax_query_placevalue->bindParam(":zoneid", $zoneid);
				$djax_query_placevalue->bindParam(":ad_id", $bannerid);
				$djax_query_placevalue->execute();

				$stmtplacevalue = $djax_query_placevalue->fetchAll();

				$placenum .= count($stmtplacevalue) . ',';

				$zoneids .= $zoneid . ',';

				// print_r($placenum); exit();
				if ($placenum == 0) {

					$zonelinkmsg = 'zone have not linked with banner';

					$response = array (

						'msg' => 'zone have not linked with banner'
					);
					//return $this->response->withJson($response);     
					//return $response;
				} else {
					$zonelinkmsg = 'zone have already linked with banner!';
					$response = array (
						'msg' => 'zone have already linked with banner!'
					);
					//return $this->response->withJson($response);     
					//return $response;
				}
				//return $this->response->withJson($placenum);

			}
			$responses = array (
				'response' => 'success',
				'statuscode' => '200',
				'zoneid' => $zoneids,
				'count' => $placenum,
				'msg' => $response
			);
			return $this->response->withJson($responses);
			//echo $placenum;
		}
	}
})->add($container->get('az_link'));

/***************************Linked Ad campaign by zone ********************************************/


/*****************************************************************************************/
/*
 * Linked Ad campaign by zone 
 * 
 * Input Parameters:
 * --------------- 
 * Campaign ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->post('/campaignbyzone_link/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['campaignid'];
		$getid = explode(',', $id);

		$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_zonevalue = $this->db->prepare($zonevalue);
		$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
		$djax_query_zonevalue->execute();

		$stmtzonevalue = $djax_query_zonevalue->fetchAll();
		$zonenum = count($stmtzonevalue);

		if ($stmtzonevalue) {
			// print_r($getid);exit;
			foreach ($getid as $campaignid) {
				// echo "12";echo "---";
				//get banners
				$campaignvalue = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);
				$zonewidth = $stmtzonevalue[0]['width'];
				$zoneheight = $stmtzonevalue[0]['height'];
				$zonetype = $stmtzonevalue[0]['delivery'];

				if ($zonewidth == '-1' && $zoneheight == '-1') {
					$bannerval = "select * from {$table_prefix}banners where campaignid=:campaignid";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":campaignid", $campaignid);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();
					$bannernum = count($stmtbannervalue);
				} else {
					$bannerval = "select * from {$table_prefix}banners where campaignid=:campaignid and width=:zonewidth and height=:zoneheight";
					$get_banner_det = $this->db->prepare($bannerval);
					$get_banner_det->bindParam(":campaignid", $campaignid);
					$get_banner_det->bindParam(":zonewidth", $zonewidth);
					$get_banner_det->bindParam(":zoneheight", $zoneheight);
					$get_banner_det->execute();
					$stmtbannervalue = $get_banner_det->fetchAll();
					$bannernum = count($stmtbannervalue);
				}
				$placementValue = "select * from {$table_prefix}placement_zone_assoc where 
					zone_id=:zoneid and placement_id=:placement_id";
				$djax_query_placevalue = $this->db->prepare($placementValue);
				$djax_query_placevalue->bindParam(":zoneid", $zoneid);
				$djax_query_placevalue->bindParam(":placement_id", $campaignid);
				$djax_query_placevalue->execute();

				$stmtplacevalue = $djax_query_placevalue->fetchAll();

				$placenum = count($stmtplacevalue);

				if ($placenum == 0) {
					$placementcampaign = "insert 
						into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
						values(:zoneid,:placement_id) ";
					$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
					$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
					$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
					$djax_query_placementcampaign->execute();
				} else {
					$response = array (
						'response' => 'ok',
						'msg' => 'Campaigns already linked with zone!'
					);
				}
				//banner validation
				if (empty ($num)) {

					$response = array (
						'response' => 'Error',
						'msg' => 'There is no campaign or banner exists under this requested id!'
					);
					return $this->response->withJson($response);
				}

				// print_r($stmtbannervalue);exit;

				foreach ($stmtbannervalue as $campaignvalue) {

					$bannerid = $campaignvalue['bannerid'];
					$width = $campaignvalue['width'];
					$height = $campaignvalue['height'];
					$bannertype = $campaignvalue['storagetype'];
					$exttype = $campaignvalue['ext_bannertype'];

					if (
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
						($bannertype == 'txt' && $zonetype == 3) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:html5')) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml')
							&& $zonetype == 6) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml')
							&& $zonetype == 7) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:genericHtml') && ($zonetype == 7
							|| $zonetype == 0 || $zonetype == 1 || $zonetype == 4))
					) {

						if (($width == $zonewidth && $height == $zoneheight) || ($zonewidth == -1 && $zoneheight == -1)) {
							$placementValue = "select * from {$table_prefix}ad_zone_assoc where 
								zone_id=:zoneid and ad_id=:ad_id";
							$djax_query_placevalue = $this->db->prepare($placementValue);
							$djax_query_placevalue->bindParam(":zoneid", $zoneid);
							$djax_query_placevalue->bindParam(":ad_id", $bannerid);
							$djax_query_placevalue->execute();

							$stmtplacevalue = $djax_query_placevalue->fetchAll();

							$placenum = count($stmtplacevalue);


							if ($placenum == 0) {


								$adzoneassoc = "insert into {$table_prefix}ad_zone_assoc
									(`zone_id`,`ad_id`,`priority`, `link_type`,`priority_factor`,`to_be_delivered`)
									VALUES (:zoneid, :bannerid,0,1,1,1)";
								$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
								$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
								$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
								$djax_query_adzoneassoc->execute();

								$response = array (
									'response' => 'ok',
									'msg' => 'Campaigns linked successfully!'
								);
							}
						} else {
							$response = array (
								'response' => 'ok',
								'msg' => 'Width and height doesnot match for banner and zone'
							);
						}
					} else {
						$response = array (
							'response' => 'ok',
							'msg' => 'Type doesnot match for banner and zone'
						);
					}
				}
			}
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'There is no zone exists under this requested id!'
			);
			return $this->response->withJson($response);
		}
	}
})->add($container->get('cz_link'));

/************************** Get campaign details by zone *******************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Zone ID
 */
$app->get('/get_tree_campaign/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetchAll();

		if ($stmtzonevalue) {
			$sql = "SELECT ca.campaignid, ca.campaignname, ca.clientid
				FROM " . $table_prefix . "placement_zone_assoc AS pz  
				JOIN " . $table_prefix . "zones AS z ON (z.zoneid = pz.zone_id)  
				JOIN " . $table_prefix . "campaigns AS ca ON (ca.campaignid = pz.placement_id)
				WHERE pz.zone_id = :zoneid ";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":zoneid", $zoneid);

			$sth->execute();

			$campaignvalue = $sth->fetchAll();

			$todos = array ();
			$i = 0;
			foreach ($campaignvalue as $cValue) {
				$i = $i + 1;
				$campname = $cValue['campaignname'];
				$campid = $cValue['campaignid'];
				//echo $campid = $i.'-'.$cValue['campaignid'].'-';

				$bsql = "SELECT b.bannerid,b.description,b.campaignid,c.campaignname
					FROM " . $table_prefix . "ad_zone_assoc AS az  
					JOIN " . $table_prefix . "zones AS z ON (z.zoneid = az.zone_id)  
					join " . $table_prefix . "banners as b on b.bannerid = az.ad_id
					join " . $table_prefix . "campaigns as c on c.campaignid = b.campaignid
					WHERE az.zone_id = :zoneid and c.campaignid = :campaignid";
				$bquery = $this->db->prepare($bsql);
				$bquery->bindParam(":zoneid", $zoneid);
				$bquery->bindParam(":campaignid", $cValue['campaignid']);

				$bquery->execute();

				$bannervalue = $bquery->fetchAll();

				$countbanval = count($bannervalue);

				//print_r($bannervalue);exit("ok");
				// if($countbanval>0){
				$treeBanner = array ();

				foreach ($bannervalue as $banners) {
					$treeBanner[] = [
						'banner_id' => $banners['bannerid'],
						'banner_name' => $banners['description']
					];
				}

				$todos[] = [
					'campaign_name' => $campname,
					'campaign_id' => $campid,
					'banners' => $treeBanner
				];

				// }

			}


			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'error', 'ok' => 'There is no linked Banners');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'ok' => 'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('zoneid_val'));

/***************************Linked Ad zone by banner ********************************************/

$app->post('/campaign_list/[{zoneid}]', function ($request, $response, $args) {

	//  if ($request->getAttribute('has_errors')) {
	// 	 //There are errors, read them
	// 	 $response = array('response'=>'error','msg'=>'Please check with input parameters');
	// 	 return $this->response->withJson($response);     
	// 	 return $response;
	// 	 exit;
	//  } else {


	$datetime = date('Y-m-d H:i:s');
	$results = array ();
	$zoneid = $args['zoneid'];
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$input = $request->getParsedBody();
	$datetime = date('Y-m-d H:i:s');
	$results = array ();

	$clientid = $input['clientid'];
	$stc = "SELECT * FROM " . $table_prefix . "zones where zoneid =" . $zoneid;
	$std = $this->db->prepare($stc);
	$std->execute();
	$zone_det = $std->fetchAll();


	if (count($zone_det) <= 0) {
		$response = array ('response' => 'error', 'msg' => 'Enter valid zoneid!');
		return $this->response->withJson($response);
	}

	$zonewidth = $zone_det[0]['width'];
	$zoneheight = $zone_det[0]['height'];

	$bannerval = "select * from {$table_prefix}banners where width=:zonewidth and height=:zoneheight";
	$get_banner_det = $this->db->prepare($bannerval);
	$get_banner_det->bindParam(":zonewidth", $zonewidth);
	$get_banner_det->bindParam(":zoneheight", $zoneheight);
	$get_banner_det->execute();
	$stmtbannervalue = $get_banner_det->fetchAll();
	$bannernum = count($stmtbannervalue);

	$camp_unique = array ();
	foreach ($stmtbannervalue as $banner_details) {
		if (!in_array($banner_details['campaignid'], $camp_unique)) {
			$camp_unique[] = $banner_details['campaignid'];
		}
	}

	$placementlist = array ();
	for ($i = 0; $i < count($camp_unique); $i++) {

		$bannerval = "select * from {$table_prefix}campaigns where campaignid=:campaignid and clientid=:clientid";
		$get_banner_det = $this->db->prepare($bannerval);

		$get_banner_det->bindParam(":campaignid", $camp_unique[$i]);
		$get_banner_det->bindParam(":clientid", $clientid);
		$get_banner_det->execute();
		$stmtbannervalue = $get_banner_det->fetchAll();

		if (!empty ($stmtbannervalue)) {

			$bannerval = "select * from {$table_prefix}placement_zone_assoc where placement_id=:campaignid and zone_id=:zoneid";
			$get_banner_det = $this->db->prepare($bannerval);
			$get_banner_det->bindParam(":campaignid", $camp_unique[$i]);
			$get_banner_det->bindParam(":zoneid", $zoneid);
			$get_banner_det->execute();
			$stmtbannervalue = $get_banner_det->fetchAll();

			if (count($stmtbannervalue) == 0) {

				$placementlist[] = $camp_unique[$i];
			}
		}
	}

	//print_r($placementlist);

	if (!empty ($placementlist)) {
		$response = array ('response' => 'ok', 'Campaigns unlinked with zones' => $placementlist);
		return $this->response->withJson($response);
	} else {
		$response = array ('response' => 'ok', 'msg' => 'No Campaigns available for the zone');
		return $this->response->withJson($response);
	}
});

/*****************************************************************************************/
/*
 * Linked Ad zone by banner
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->post('/zonebyad_link/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['zoneid'];
		$getid = explode(',', $id);

		$banner_data = "select * from {$table_prefix}banners where bannerid=:bannerid";
		$banner_data = $this->db->prepare($banner_data);
		$banner_data->bindParam(":bannerid", $bannerid);
		$banner_data->execute();

		$stmtbannervalue = $banner_data->fetchAll();

		$bannercount = count($stmtbannervalue);

		if ($stmtbannervalue) {
			$width = $stmtbannervalue[0]['width'];
			$height = $stmtbannervalue[0]['height'];
			$bannertype = $stmtbannervalue[0]['storagetype'];
			$exttype = $stmtbannervalue[0]['ext_bannertype'];

			foreach ($getid as $zoneid) {
				$zonevalue = "SELECT * FROM {$table_prefix}zones WHERE zoneid=:zoneid";
				$zone_data = $this->db->prepare($zonevalue);
				$zone_data->bindParam(":zoneid", $zoneid);
				$zone_data->execute();
				$stmtzonevalue = $zone_data->fetchAll();
				$zonecount = count($stmtzonevalue);

				if ($stmtzonevalue) {

					$zonewidth = $stmtzonevalue[0]['width'];
					$zoneheight = $stmtzonevalue[0]['height'];
					$zonetype = $stmtzonevalue[0]['delivery'];

					if (
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
						($bannertype == 'txt' && $zonetype == 3) ||
						(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:html5')) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype == 6) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') && $zonetype == 7) ||
						(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:genericHtml') && ($zonetype == 7 || $zonetype == 1 || $zonetype == 0 || $zonetype == 4))
					) {

						if (($width == $zonewidth && $height == $zoneheight) || ($zonewidth == -1 && $zoneheight == -1)) {
							$placementValue = "select * from {$table_prefix}ad_zone_assoc where 
								zone_id=:zoneid and ad_id=:ad_id";
							$djax_query_placevalue = $this->db->prepare($placementValue);
							$djax_query_placevalue->bindParam(":zoneid", $zoneid);
							$djax_query_placevalue->bindParam(":ad_id", $bannerid);
							$djax_query_placevalue->execute();

							$stmtplacevalue = $djax_query_placevalue->fetchAll();
							$placenum = count($stmtplacevalue);

							if ($placenum == 0) {
								$linkzone = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,`priority`,`link_type`,`priority_factor`,`to_be_delivered`) VALUES (:zoneid, :bannerid,0,1,1,1)";

								$linkzonebyad = $this->db->prepare($linkzone);
								$linkzonebyad->bindParam(":zoneid", $zoneid);
								$linkzonebyad->bindParam(":bannerid", $bannerid);
								$linkzonebyad->execute();

								$response = array ('Message' => "Zones linked successfully to the Banner");
							}
							//return $this->response->withJson($response);	
						} else {
							$response = array ('ERROR' => 'Width and height doesnot match for banner and zone');
						}
					} else {
						$response = array ('ERROR' => 'Type doesnot match for banner and zone');
					}
				} else {
					$response = array ('response' => 'Error', 'msg' => 'There is no zone available for Requested id!');
					//return $this->response->withJson($response);	
				}
			}
			return $this->response->withJson($response);
		} else {

			$response = array ('Response' => 'Error', 'ERROR' => 'Enter a valid banner id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('az_link'));

/***************************Linked Ad zone by campaign ********************************************/


/*****************************************************************************************/
/*
 * Linked Ad zone by campaign
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */
$app->post('/zonebycampaign_link/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['zoneid'];
		$getid = explode(',', $id);

		//for validation purpose
		$validation = "SELECT * FROM {$table_prefix}campaigns
			WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetchAll();
		$valid = count($stmtvalidation);

		if ($stmtvalidation) {

			foreach ($getid as $zoneid) {
				$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
				$djax_query_zonevalue = $this->db->prepare($zonevalue);
				$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
				$djax_query_zonevalue->execute();

				$stmtzonevalue = $djax_query_zonevalue->fetchAll();
				$zonenum = count($stmtzonevalue);

				if (empty ($zonenum)) {

					$response = array ('ERROR' => 'Zone not exist for requested id');
					return $this->response->withJson($response);
				}

				//to get banners under given campaign
				$campaignvalue = "select * from {$table_prefix}banners where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);

				//to get zonewidth and height

				if ($stmtcampaignvalue) {

					foreach ($stmtzonevalue as $zonevalue) {

						$zonewidth = $zonevalue['width'];
						$zoneheight = $zonevalue['height'];
						$zonetype = $zonevalue['delivery'];
					}

					// print_r($stmtcampaignvalue);exit;

					foreach ($stmtcampaignvalue as $campaignvalue) {

						$bannerid = $campaignvalue['bannerid'];

						$bannerwidth = $campaignvalue['width'];
						$bannerheight = $campaignvalue['height'];
						$bannertype = $campaignvalue['storagetype'];
						$exttype = $campaignvalue['ext_bannertype'];

						if (
							(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 0) ||
							(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 1) ||
							($bannertype == 'txt' && $zonetype == 3) ||
							(($bannertype == 'web' || $bannertype == 'sql' || $bannertype == 'url') && $zonetype == 4) ||
							(($bannertype == 'html' && $exttype == 'bannerTypeHtml:oxHtml:html5')) ||
							(($bannertype == 'html' &&
								$exttype == 'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml') && $zonetype == 6) ||
							(($bannertype == 'html' &&
								$exttype == 'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml') && $zonetype == 7) ||
							(($bannertype == 'html' &&
								$exttype == 'bannerTypeHtml:oxHtml:genericHtml') &&
								($zonetype == 7 || $zonetype == 1 || $zonetype == 0 || $zonetype == 4))
						) {
							if (($zonewidth == $bannerwidth && $zoneheight == $bannerheight) || ($zonewidth == -1 && $zoneheight == -1)) {

								$placementValue = "select * from {$table_prefix}placement_zone_assoc where 
									zone_id=:zoneid and placement_id=:placement_id";
								$djax_query_placevalue = $this->db->prepare($placementValue);
								$djax_query_placevalue->bindParam(":zoneid", $zoneid);
								$djax_query_placevalue->bindParam(":placement_id", $campaignid);
								$djax_query_placevalue->execute();

								$stmtplacevalue = $djax_query_placevalue->fetchAll();

								$placenum = count($stmtplacevalue);

								if ($placenum == 0) {
									//echo "if";
									$placementcampaign = "
										insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
										values(:zoneid,:placement_id) ";
									$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
									$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
									$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
									$djax_query_placementcampaign->execute();
								}

								$zonval = "select * from {$table_prefix}ad_zone_assoc where 
									zone_id=:zoneid and ad_id=:ad_id";
								$djax_query_zonvalue = $this->db->prepare($zonval);
								$djax_query_zonvalue->bindParam(":zoneid", $zoneid);
								$djax_query_zonvalue->bindParam(":ad_id", $bannerid);
								$djax_query_zonvalue->execute();

								$stmtzonvalue = $djax_query_zonvalue->fetchAll();

								$zonnum = count($stmtzonvalue);

								if ($zonnum == 0) {
									$adzoneassoc = "insert into {$table_prefix}ad_zone_assoc
									(`zone_id`,`ad_id`,`priority`,`link_type`,`priority_factor`,`to_be_delivered`)
									VALUES (:zoneid, :bannerid,0,1,1,1)";
									$djax_query_adzoneassoc = $this->db->prepare($adzoneassoc);
									$djax_query_adzoneassoc->bindParam(":zoneid", $zoneid);
									$djax_query_adzoneassoc->bindParam(":bannerid", $bannerid);
									$djax_query_adzoneassoc->execute();
								}

								$response = array ('response' => 'ok', 'msg' => 'Zones linked sucessfully');
							} else {
								$placementValue = "select * from {$table_prefix}placement_zone_assoc where 
									zone_id=:zoneid and placement_id=:placement_id";
								$djax_query_placevalue = $this->db->prepare($placementValue);
								$djax_query_placevalue->bindParam(":zoneid", $zoneid);
								$djax_query_placevalue->bindParam(":placement_id", $campaignid);
								$djax_query_placevalue->execute();

								$stmtplacevalue = $djax_query_placevalue->fetchAll();

								$placenum = count($stmtplacevalue);

								if ($placenum == 0) {
									$placementcampaign = "
										insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
										values(:zoneid,:placement_id) ";
									$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
									$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
									$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
									$djax_query_placementcampaign->execute();
								}

								$response = array ('response' => 'ok', 'msg' => 'Zones linked sucessfully');
							}
						} else {
							$placementValue = "select * from {$table_prefix}placement_zone_assoc where 
								zone_id=:zoneid and placement_id=:placement_id";
							$djax_query_placevalue = $this->db->prepare($placementValue);
							$djax_query_placevalue->bindParam(":zoneid", $zoneid);
							$djax_query_placevalue->bindParam(":placement_id", $campaignid);
							$djax_query_placevalue->execute();

							$stmtplacevalue = $djax_query_placevalue->fetchAll();

							$placenum = count($stmtplacevalue);

							if ($placenum == 0) {
								$placementcampaign = "
									insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
									values(:zoneid,:placement_id) ";
								$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
								$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
								$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
								$djax_query_placementcampaign->execute();
							}

							$response = array ('response' => 'ok', 'msg' => 'Zones linked sucessfully');
						}
					}
				} else {
					$placementcampaign = "
						insert into {$table_prefix}placement_zone_assoc(zone_id,placement_id)
						values(:zoneid,:placement_id) ";
					$djax_query_placementcampaign = $this->db->prepare($placementcampaign);
					$djax_query_placementcampaign->bindParam(":zoneid", $zoneid);
					$djax_query_placementcampaign->bindParam(":placement_id", $campaignid);
					$djax_query_placementcampaign->execute();

					$response = array ('response' => 'ok', 'msg' => 'Zones linked sucessfully');
				}
			}
			return $this->response->withJson($response);
		} else {

			$response = array ('response' => 'error', 'msg' => 'Please enter valid campaignid');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('cz_link'));



/***********************************************************************/

/*************************** Unlinked Ad by zone ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Banner ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */

$app->post('/adbyzone_unlink/[{zoneid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['bannerid'];
		$getbannerid = explode(',', $id);


		$zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetchAll();
		if (!$stmtzonevalue) {
			$response = array ('response' => 'error', 'msg' => 'Please provide valid zoneid!');
			return $this->response->withJson($response);
		}
		foreach ($getbannerid as $bannerid) {
			$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
			$get_banner_det = $this->db->prepare($bannerval);
			$get_banner_det->bindParam(":bannerid", $bannerid);
			$get_banner_det->execute();
			$stmtbannervalue = $get_banner_det->fetchAll();
			$bannernum = count($stmtbannervalue);
			if (!$stmtbannervalue) {
				$response = array ('response' => 'error', 'msg' => 'Please provide valid Bannerid!');
				return $this->response->withJson($response);
			}

			$linkval = "select * from {$table_prefix}ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
			$linkdet = $this->db->prepare($linkval);
			$linkdet->bindParam(":zoneid", $zoneid);
			$linkdet->bindParam(":bannerid", $bannerid);
			$linkdet->execute();
			$stmtlinkvalue = $linkdet->fetchAll();

			if ($stmtlinkvalue) {


				$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
				$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
				$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
				$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

				$banner_del = $djax_query_deleteaccount->execute();

				$response = array (
					'response' => 'ok',
					'msg' => 'Banners Unlinked successfully!'
				);
			} else {
				$response = array (
					'response' => 'error',
					'msg' => 'Banners not linked !'
				);
			}
		}
		return $this->response->withJson($response);
	}
})->add($container->get('az_link'));

/***********************************************************************/

/*************************** Unlinked Zone by Ad ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Banner ID
 */
$app->post('/zonebyad_unlink/[{bannerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];
		$getzoneid = explode(',', $id);

		$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
		$get_banner_det = $this->db->prepare($bannerval);
		$get_banner_det->bindParam(":bannerid", $bannerid);
		$get_banner_det->execute();
		$stmtbannervalue = $get_banner_det->fetchAll();

		if (!$stmtbannervalue) {
			$response = array ('response' => 'error', 'msg' => 'Please provide valid Bannerid!');
			return $this->response->withJson($response);
		}


		foreach ($getzoneid as $zoneid) {

			$zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
			$zonedet = $this->db->prepare($zoneval);
			$zonedet->bindParam(":zoneid", $zoneid);
			$zonedet->execute();
			$stmtzonevalue = $zonedet->fetchAll();

			if (!$stmtzonevalue) {
				$response = array ('response' => 'error', 'msg' => 'Please provide valid zoneid!');
				return $this->response->withJson($response);
			}

			$linkval = "select * from {$table_prefix}ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
			$linkdet = $this->db->prepare($linkval);
			$linkdet->bindParam(":zoneid", $zoneid);
			$linkdet->bindParam(":bannerid", $bannerid);
			$linkdet->execute();
			$stmtlinkvalue = $linkdet->fetchAll();

			if ($stmtlinkvalue) {


				$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
				$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
				$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
				$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

				$banner_del = $djax_query_deleteaccount->execute();

				$response = array (
					'response' => 'ok',
					'msg' => 'Zones Unlinked successfully!'
				);
			} else {
				$response = array (
					'response' => 'error',
					'msg' => 'Zones not linked !'
				);
			}
		}
		return $this->response->withJson($response);
	}
})->add($container->get('az_link'));




/***********************************************************************/

/*************************** Unlinked Campaign by zone ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Campaign ID
 * 
 * Arguments:
 * ---------
 * Zone ID
 */


$app->post('/campaignbyzone_unlink/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['campaignid'];
		$getid = explode(',', $id);

		$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$djax_query_zonevalue = $this->db->prepare($zonevalue);
		$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
		$djax_query_zonevalue->execute();

		$stmtzonevalue = $djax_query_zonevalue->fetchAll();
		$zonenum = count($stmtzonevalue);

		if (empty ($zonenum)) {
			$response = array (
				'response' => 'Error',
				'msg' => 'There is no zone exists under this requested id!'
			);
			return $this->response->withJson($response);
		}

		foreach ($getid as $campaignid) {
			$campaignvalue1 = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
			$djax_query_campaignvalue1 = $this->db->prepare($campaignvalue1);
			$djax_query_campaignvalue1->bindParam(":campaignid", $campaignid);
			$djax_query_campaignvalue1->execute();

			$stmtcampaignvalue1 = $djax_query_campaignvalue1->fetchAll();
			$stmtcampaignvalue1num = count($stmtcampaignvalue1);
			if (empty ($stmtcampaignvalue1num)) {
				$response = array (
					'response' => 'Error',
					'msg' => 'There is no Campaign exists under this requested id!'
				);
				return $this->response->withJson($response);
			}


			$linkval = "select * from {$table_prefix}placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
			$linkdet = $this->db->prepare($linkval);
			$linkdet->bindParam(":zoneid", $zoneid);
			$linkdet->bindParam(":campaignid", $campaignid);
			$linkdet->execute();
			$stmtlinkvalue = $linkdet->fetchAll();

			if ($stmtlinkvalue) {
				$deleteplaceaccounts = "DELETE FROM " . $table_prefix . "placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
				$djax_query_deleteplaceaccount = $this->db->prepare($deleteplaceaccounts);
				$djax_query_deleteplaceaccount->bindParam(":campaignid", $campaignid);
				$djax_query_deleteplaceaccount->bindParam(":zoneid", $zoneid);

				$campaign_del = $djax_query_deleteplaceaccount->execute();

				//get banners
				$campaignvalue = "select * from {$table_prefix}banners where campaignid=:campaignid";
				$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
				$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
				$djax_query_campaignvalue->execute();

				$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

				$num = count($stmtcampaignvalue);


				if ($stmtcampaignvalue) {

					foreach ($stmtcampaignvalue as $campaignvalue) {

						$bannerid = $campaignvalue['bannerid'];

						$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
						$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
						$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
						$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

						$banner_del = $djax_query_deleteaccount->execute();
					}

					$response = array (
						'response' => 'ok',
						'msg' => 'Campaigns unlinked successfully!'
					);
				} else {
					$response = array (
						'response' => 'ok',
						'msg' => 'Banners not linked!'
					);
				}
			} else {
				$response = array (
					'response' => 'ok',
					'msg' => 'Campaigns not linked!'
				);
			}
		}
		return $this->response->withJson($response);
	}
})->add($container->get('cz_link'));



/***********************************************************************/

/*************************** Unlinked Zone by Campaign ********************************************/
/*
 * 
 * Input Parameters:
 * --------------- 
 * Zone ID
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */



$app->post('/zonebycampaign_unlink/[{campaignid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaignid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$id = $input['zoneid'];
		$getid = explode(',', $id);

		//for validation purpose
		$validation = "SELECT * FROM {$table_prefix}campaigns 
			WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetchAll();
		$valid = count($stmtvalidation);

		if ($stmtvalidation) {

			$bannerval = "SELECT * FROM {$table_prefix}zones WHERE zoneid=:zone_id";

			$banner_ck = $this->db->prepare($bannerval);
			$banner_ck->bindParam(":zone_id", $id);
			$banner_ck->execute();
			$bnn = $banner_ck->fetchAll();
			$banner_count = count($bnn);

			if (!$banner_count) {

				$response = array ('response' => 'error', 'msg' => 'Please enter valid Zoneid');
				return $this->response->withJson($response);
			}


			foreach ($getid as $zoneid) {

				//to get banners under given campaign


				//to get zonewidth and height
				$zonevalue = "select * from {$table_prefix}zones where zoneid=:zoneid";
				$djax_query_zonevalue = $this->db->prepare($zonevalue);
				$djax_query_zonevalue->bindParam(":zoneid", $zoneid);
				$djax_query_zonevalue->execute();

				$stmtzonevalue = $djax_query_zonevalue->fetchAll();
				$zonenum = count($stmtzonevalue);

				if (empty ($zonenum)) {

					$response = array ('ERROR' => 'Zone not exist for requested id');
					return $this->response->withJson($response);
				}
				$linkval = "select * from {$table_prefix}placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
				$linkdet = $this->db->prepare($linkval);
				$linkdet->bindParam(":zoneid", $zoneid);
				$linkdet->bindParam(":campaignid", $campaignid);
				$linkdet->execute();
				$stmtlinkvalue = $linkdet->fetchAll();

				if ($stmtlinkvalue) {

					$deleteplaceaccounts = "DELETE FROM " . $table_prefix . "placement_zone_assoc WHERE placement_id=:campaignid AND zone_id=:zoneid";
					$djax_query_deleteplaceaccount = $this->db->prepare($deleteplaceaccounts);
					$djax_query_deleteplaceaccount->bindParam(":campaignid", $campaignid);
					$djax_query_deleteplaceaccount->bindParam(":zoneid", $zoneid);

					$zone_del = $djax_query_deleteplaceaccount->execute();

					$campaignvalue = "select * from {$table_prefix}banners where campaignid=:campaignid";
					$djax_query_campaignvalue = $this->db->prepare($campaignvalue);
					$djax_query_campaignvalue->bindParam(":campaignid", $campaignid);
					$djax_query_campaignvalue->execute();

					$stmtcampaignvalue = $djax_query_campaignvalue->fetchAll();

					$num = count($stmtcampaignvalue);

					foreach ($stmtcampaignvalue as $campaignvalue) {

						$bannerid = $campaignvalue['bannerid'];

						$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
						$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
						$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
						$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

						$banner_del = $djax_query_deleteaccount->execute();
						$response = array (
							'response' => 'ok',
							'msg' => 'Zones Unlinked successfully!'
						);
					}
				}

				$bannervalue = "select * from {$table_prefix}banners where campaignid=:campaignid";
				$djax_query_bannervalue = $this->db->prepare($bannervalue);
				$djax_query_bannervalue->bindParam(":campaignid", $campaignid);
				$djax_query_bannervalue->execute();
				$stmtbannervalue = $djax_query_bannervalue->fetchAll();

				foreach ($stmtbannervalue as $bannervalue) {
					$bannerid = $bannervalue['bannerid'];
					$linkval1 = "select * from {$table_prefix}ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
					$linkdet1 = $this->db->prepare($linkval1);
					$linkdet1->bindParam(":zoneid", $zoneid);
					$linkdet1->bindParam(":bannerid", $bannerid);
					$linkdet1->execute();
					$stmtlinkbanvalue = $linkdet1->fetchAll();
					if ($stmtlinkbanvalue) {
						$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid AND zone_id=:zoneid";
						$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
						$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);
						$djax_query_deleteaccount->bindParam(":zoneid", $zoneid);

						$banner_del = $djax_query_deleteaccount->execute();
						$response = array (
							'response' => 'ok',
							'msg' => 'Zones Unlinked successfully!'
						);
					}
				}
			}

			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'ok' => 'Please enter valid campaign Id ');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('cz_link'));


/*************************** Linked banner details by zone ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Zone ID
 */
$app->get('/get_linked_banners/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetchAll();
		if ($stmtzonevalue) {
			$sql = "SELECT b.description, b.bannerid,c.campaignid,c.campaignname,c.priority, b.contenttype, b.storagetype, b.filename, b.imageurl, b.htmltemplate, b.width, b.height, b.weight,
				b.htmltemplate, b.url, b.bannertext,b.prepend,b.append, b.status
				FROM " . $table_prefix . "ad_zone_assoc AS az  
				JOIN " . $table_prefix . "zones AS z ON (z.zoneid = az.zone_id)  
				JOIN " . $table_prefix . "banners AS b ON (b.bannerid = az.ad_id)
				JOIN " . $table_prefix . "campaigns AS c ON (c.campaignid = b.campaignid)
				WHERE az.zone_id = :zoneid GROUP BY az.ad_id;";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":zoneid", $zoneid);

			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				$response = array ('data' => $todos, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'error', 'ok' => 'There is no linked Banners');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'ok' => 'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('zoneid_val'));




/***********************************************************************/

/*************************** Linked zone details by banner ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Banner ID
 */

$app->get('/get_linked_zones/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
		$bannerdet = $this->db->prepare($bannerval);
		$bannerdet->bindParam(":bannerid", $bannerid);
		$bannerdet->execute();
		$stmtbannervalue = $bannerdet->fetchAll();

		if ($stmtbannervalue) {
			$sql = "SELECT z.zoneid, z.zonename, z.description, z.delivery, z.height, z.width
				FROM " . $table_prefix . "ad_zone_assoc AS az  
				JOIN " . $table_prefix . "zones AS z ON (z.zoneid = az.zone_id)  
				JOIN " . $table_prefix . "banners AS b ON (b.bannerid = az.ad_id)
				WHERE az.ad_id = :bannerid GROUP BY az.zone_id;";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":bannerid", $bannerid);

			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'error', 'ok' => 'There is no linked Zones', 'msg' => 'There is no linked Zones');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'ok' => 'Please enter valid Banner Id', 'msg' => 'Please enter valid Banner Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('limitValidation'));


/***********************************************************************/

/*************************** Linked campaign details by zone ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Zone ID
 */
$app->get('/get_linked_campaigns/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneid = $args['zoneid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$zoneval = "select * from {$table_prefix}zones where zoneid=:zoneid";
		$zonedet = $this->db->prepare($zoneval);
		$zonedet->bindParam(":zoneid", $zoneid);
		$zonedet->execute();
		$stmtzonevalue = $zonedet->fetchAll();

		if ($stmtzonevalue) {
			$sql = "SELECT b.bannerid, b.description, ca.campaignid, ca.campaignname, ca.clientid, ca.views, ca.clicks, ca.conversions, ca.priority, ca.weight, ca.target_impression, ca.target_click, ca.target_conversion, ca.anonymous, ca.companion, ca.comments, ca.revenue, ca.revenue_type, ca.updated, ca.block, ca.capping, ca.session_capping, ca.status, ca.min_impressions, ca.activate_time, ca.expire_time, ca.show_capped_no_cookie
				FROM " . $table_prefix . "placement_zone_assoc AS pz  
				JOIN " . $table_prefix . "zones AS z ON (z.zoneid = pz.zone_id)  
				JOIN " . $table_prefix . "campaigns AS ca ON (ca.campaignid = pz.placement_id)
				Join " . $table_prefix . "banners AS b ON (ca.campaignid = b.campaignid)
				WHERE pz.zone_id = :zoneid ";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":zoneid", $zoneid);

			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'error', 'ok' => 'There is no linked Banners');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'ok' => 'Please enter valid Zone Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('zoneid_val'));

/***********************************************************************/


/*************************** Linked zone details by campaign ********************************************/
/*
 * Input Parameters:
 * --------------- 
 * NULL
 * 
 * Arguments:
 * ---------
 * Campaign ID
 */
$app->get('/get_campaign_linked_zones/[{campaign_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignid = $args['campaign_id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campaignval = "select * from {$table_prefix}campaigns where campaignid=:campaignid";
		$campaigndet = $this->db->prepare($campaignval);
		$campaigndet->bindParam(":campaignid", $campaignid);
		$campaigndet->execute();
		$stmtcampaignvalue = $campaigndet->fetchAll();
		if ($stmtcampaignvalue) {
			$sql = "SELECT z.zoneid, z.zonename, z.description, z.delivery, z.height, z.width
				FROM " . $table_prefix . "placement_zone_assoc AS pz  
				JOIN " . $table_prefix . "zones AS z ON (z.zoneid = pz.zone_id)  
				JOIN " . $table_prefix . "campaigns AS ca ON (ca.campaignid = pz.placement_id)
				WHERE pz.placement_id = :campaignid GROUP BY pz.zone_id;";
			$sth = $this->db->prepare($sql);
			$sth->bindParam(":campaignid", $campaignid);

			$sth->execute();

			$todos = $sth->fetchAll();

			if ($todos) {
				return $this->response->withJson($todos);
			} else {
				$response = array ('response' => 'error', 'ok' => 'There is no linked Zones');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'ok' => 'Please enter valid Campaign Id');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('campaignid_val'));

/*----------------  Tracker -------------*/

/*
 * Tracker ADD
 * 
 * Input Parameters:
 * --------------- 
 * trackername
 * description
 * status
 * type
 * appendcode
 * 
 * Arguments:
 * ---------
 * Client ID
 */
$app->post('/add_tracker/[{clientid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {


		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();


		$trackername = $input['trackername'];
		$description = $input['description'];
		$status = $input['status'];
		$type = $input['type'];
		$appendcode = $input['appendcode'];

		$stc = "SELECT * FROM " . $table_prefix . "clients where clientid =" . $clientid;
		$std = $this->db->prepare($stc);
		$std->execute();
		$clients = $std->fetchAll();

		if (count($clients) <= 0) {
			$response = array ('response' => 'error', 'msg' => 'Enter valid clientid!');
			return $this->response->withJson($response);
		}
		//variable table
		if (isset ($input['variable_name'])) {
			$varname = $input['variable_name'];
		} else {
			$varname = '';
		}
		if (isset ($input['variable_description'])) {
			$vardescription = $input['variable_description'];
		} else {
			$vardescription = '';
		}
		if (isset ($input['variable_datatype'])) {
			$vardatatype = $input['variable_datatype'];
		} else {
			$vardatatype = '';
		}

		if (isset ($input['linkcampaigns'])) {
			$linkcampaigns = $input['linkcampaigns'];
		} else {
			$linkcampaigns = '';
		}

		//validation
		if (empty ($trackername) || empty ($description) || empty ($status) || empty ($type)) {

			$response = array ('response' => 'error', 'msg' => 'Please enter all data required!');

			return $this->response->withJson($response);
		}


		$addtracker = "insert into {$table_prefix}trackers(`trackername`,`description`,`clientid`,`status`,`type`,`appendcode`,`updated`,`linkcampaigns`) values(:trackername,:description,:clientid,:status,:type,:appendcode,:updated,:linkcampaigns)";
		$tracker_add = $this->db->prepare($addtracker);
		$tracker_add->bindParam(":clientid", $clientid);
		$tracker_add->bindParam(":trackername", $trackername);
		$tracker_add->bindParam(":description", $description);
		$tracker_add->bindParam(":status", $status);
		$tracker_add->bindParam(":type", $type);
		$tracker_add->bindParam(":appendcode", $appendcode);
		$tracker_add->bindParam(":updated", $datetime);
		$tracker_add->bindParam(":linkcampaigns", $linkcampaigns);

		$tracker_add->execute();


		$trackerid = $this->db->lastInsertId();

		$addtrackerappend = "insert into {$table_prefix}tracker_append(`tracker_id`,`rank`,`tagcode`,`paused`,`autotrack`)values(:tracker_id,1,:tagcode,'f','f')";


		$trackerappend = $this->db->prepare($addtrackerappend);
		$trackerappend->bindParam(":tracker_id", $trackerid);
		$trackerappend->bindParam(":tagcode", $appendcode);
		$trackerappend->execute();

		$variabletrackers = "insert into {$table_prefix}variables(
			`trackerid`,
			`name`,
			`description`,
			`datatype`,
			`purpose`,
			`reject_if_empty`,
			`is_unique`,
			`unique_window`,
			`hidden`,
			`updated`)values(
			:trackerid,
			:name,
			:description,
			:datatype,
			'basket_value',
			1,
			0,
			0,
			'f',
			:updated)";


		$var_trackers = $this->db->prepare($variabletrackers);
		$var_trackers->bindParam(":trackerid", $trackerid);
		$var_trackers->bindParam(":name", $varname);
		$var_trackers->bindParam(":description", $vardescription);
		$var_trackers->bindParam(":datatype", $vardatatype);
		$var_trackers->bindParam(":updated", $datetime);

		$var_trackers->execute();

		$response = array ('response' => 'ok', 'msg' => 'Tracker has been added successfully!', 'with tracker id' => $trackerid);

		return $this->response->withJson($response);
	}
})->add($container->get('tracker_validate'));

/*
 * Tracker EDIT
 * 
 * Input Parameters:
 * --------------- 
 * trackername
 * description
 * status
 * type
 * appendcode
 * mode
 * 
 * Arguments:
 * ---------
 * Tracker ID
 */

$app->post('/edit_tracker/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$value = "select * from {$table_prefix}trackers where trackerid=:trackerid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":trackerid", $trackerid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();
		$mode = $input['mode'];
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		if (count($stmt)) {
			if (isset ($input['trackername'])) {
				$trackername = $input['trackername'];
			} else {
				$trackername = $stmt[0]['trackername'];
			}
			if (isset ($input['description'])) {
				$description = $input['description'];
			} else {
				$description = $stmt[0]['description'];
			}
			if (isset ($input['status'])) {
				$status = $input['status'];
			} else {
				$status = $stmt[0]['status'];
			}
			if (isset ($input['type'])) {
				$type = $input['type'];
			} else {
				$type = $stmt[0]['type'];
			}
			if (isset ($input['linkcampaigns'])) {
				$linkcampaigns = $input['linkcampaigns'];
			} else {
				$linkcampaigns = $stmt[0]['linkcampaigns'];
			}
			if (isset ($input['appendcode'])) {
				$appendcode = $input['appendcode'];
			} else {
				$appendcode = $stmt[0]['appendcode'];
			}

			$edittracker = "update  {$table_prefix}trackers set 
				`trackername`=:trackername,
				`description`=:description,
				`status`=:status,
				`type`=:type,
				`linkcampaigns`=:linkcampaigns,
				`appendcode`=:appendcode where trackerid=:trackerid";

			$edit_tracker = $this->db->prepare($edittracker);
			$edit_tracker->bindParam(":trackerid", $trackerid);
			$edit_tracker->bindParam(":trackername", $trackername);
			$edit_tracker->bindParam(":description", $description);
			$edit_tracker->bindParam(":status", $status);
			$edit_tracker->bindParam(":type", $type);
			$edit_tracker->bindParam(":appendcode", $appendcode);
			$edit_tracker->bindParam(":linkcampaigns", $linkcampaigns);
			$edit_tracker->execute();


			$trackerappend = "update  {$table_prefix}tracker_append set `tagcode`=:tagcode where `tracker_id`=:tracker_id";


			$edittrackerappend = $this->db->prepare($trackerappend);
			$edittrackerappend->bindParam(":tracker_id", $trackerid);
			$edittrackerappend->bindParam(":tagcode", $appendcode);
			$edittrackerappend->execute();


			$editcampaignstrackers = "update {$table_prefix}campaigns_trackers set campaignid=:campaignid where trackerid=:trackerid";


			$campaigntrackers = $this->db->prepare($editcampaignstrackers);
			$campaigntrackers->bindParam(":trackerid", $trackerid);
			//$campaigntrackers->bindParam(":campaignid", $campaignid);
			$campaigntrackers->execute();

			$variabletrackers = "update {$table_prefix}variables set `name`=:name,`description`=:description where `trackerid`=:trackerid";
			$variable_trackers = $this->db->prepare($variabletrackers);
			$variable_trackers->bindParam(":trackerid", $trackerid);
			//$variable_trackers->bindParam(":name", $name);
			$variable_trackers->bindParam(":description", $description);
			$variable_trackers->execute();
			//id: ' .$trackerid.'
			$response = array ('response' => 'ok', 'msg' => 'Tracker has been updated successfully!');

			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'ok', 'msg' => 'No Tracker exist with provided tracker id!');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('tracker_editmode'));

/*
 * Tracker DELETE
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Tracker ID
 */

$app->delete('/delete_tracker/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$trackerid = $args['trackerid'];

		$tracker = "select * from " . $table_prefix . "trackers where trackerid in ($trackerid)";
		$dat_tracker = $this->db->prepare($tracker);
		//$dat_tracker->bindParam(":trackerid", $trackerid);
		$dat_tracker->execute();

		$stmttracker = $dat_tracker->fetchAll();

		if (count($stmttracker) > 0) {

			$deltracker = "DELETE FROM " . $table_prefix . "trackers where trackerid in ($trackerid)";
			$deletetracker = $this->db->prepare($deltracker);
			//$deletetracker->bindParam(":trackerid", $trackerid);
			$deletetracker->execute();


			$deleteappend = "DELETE FROM " . $table_prefix . "tracker_append WHERE tracker_id in ($trackerid)";
			$del_append = $this->db->prepare($deleteappend);
			//$del_append->bindParam(":trackerid", $trackerid);
			$del_append->execute();


			$campaigntracker = "DELETE FROM " . $table_prefix . "campaigns_trackers WHERE trackerid in ($trackerid)";
			$del_campaign = $this->db->prepare($campaigntracker);
			//$del_campaign->bindParam(":trackerid", $trackerid);
			$del_campaign->execute();


			$deletevariable = "DELETE FROM " . $table_prefix . "variables WHERE trackerid in ($trackerid)";
			$del_variable = $this->db->prepare($deletevariable);
			//$del_variable->bindParam(":trackerid", $trackerid);
			$del_variable->execute();

			if ($deletetracker) {
				$response = array ('response' => 'ok', 'msg' => 'Tracker has been deleted successfully!');
				return $this->response->withJson($response);
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'Tracker id is invalid');

			return $this->response->withJson($response);
		}
	}
});
/*
 * Get Tracker Details
 * 
 * Input Parameters:
 * ----------------
 * NULL
 * 
 * Arguments:
 * ---------
 * Tracker ID
 */
$app->get('/get_tracker/[{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');

		$results = array ();
		$refertracker = "SELECT *	FROM {$table_prefix}trackers AS t1 JOIN {$table_prefix}variables AS t2 ON t1.trackerid = t2.trackerid AND t1.trackerid =:trackerid";
		$dat_tracker = $this->db->prepare($refertracker);
		$dat_tracker->bindParam(":trackerid", $trackerid);
		$dat_tracker->execute();

		$stmttracker = $dat_tracker->fetchAll();

		$count = count($stmttracker);

		$trackerdetail = array ();

		if ($count) {
			//[$trackerid]
			$trackerdetail = array (
				'trackerid' => $trackerid,
				'trackername' => $stmttracker[0]['trackername'],
				'description' => $stmttracker[0]['description'],
				'clientid' => $stmttracker[0]['clientid'],
				'status' => $stmttracker[0]['status'],
				'type' => $stmttracker[0]['type'],
				'linkcampaigns' => $stmttracker[0]['linkcampaigns'],
				'variablemethod' => $stmttracker[0]['variablemethod'],
				'appendcode' => $stmttracker[0]['appendcode'],
				'variableid' => $stmttracker[0]['variableid'],
				'name' => $stmttracker[0]['name'],
				'description' => $stmttracker[0]['description'],
				'datatype' => $stmttracker[0]['datatype'],
				'purpose' => $stmttracker[0]['purpose'],
				'variablecode' => $stmttracker[0]['variablecode']

			);

			$response = array ($trackerid => $trackerdetail);
			return $this->response->withJson($response);
		} else {
			$refertrackers = "SELECT * FROM {$table_prefix}trackers where trackerid =:trackerid";
			$tracker_det = $this->db->prepare($refertrackers);
			$tracker_det->bindParam(":trackerid", $trackerid);
			$tracker_det->execute();
			$stmttracker = $tracker_det->fetchAll();
			$counts = count($stmttracker);
			$trackerdetails = array ();
			if ($counts) {
				//[$trackerid]
				$trackerdetails = array (
					'trackerid' => $trackerid,
					'trackername' => $stmttracker[0]['trackername'],
					'description' => $stmttracker[0]['description'],
					'clientid' => $stmttracker[0]['clientid'],
					'status' => $stmttracker[0]['status'],
					'type' => $stmttracker[0]['type'],
					'linkcampaigns' => $stmttracker[0]['linkcampaigns'],
					'variablemethod' => $stmttracker[0]['variablemethod'],
					'appendcode' => $stmttracker[0]['appendcode']
				);

				$response = array (

					'data' => $trackerdetails,
					'response' => 'success',
					'statuscode' => '200',
					'msg' => 'success'
				);

				return $this->response->withJson($response);
			} else {

				$response = array ('response' => 'error', 'msg' => 'Invalid Trackerid!');

				return $this->response->withJson($response);
			}
		}
	}
})->add($container->get('tracker_edit'));



$app->get('/get_tracker_by_advertiser/[{clientid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();


		$tracker_data = "select * from {$table_prefix}trackers where clientid=:clientid";
		$std_tracker = $this->db->prepare($tracker_data);
		$std_tracker->bindParam(":clientid", $clientid);
		$std_tracker->execute();
		$stmttracker = $std_tracker->fetchAll();
		$a = count($stmttracker);
		if ($stmttracker) {
			foreach ($stmttracker as $trackerinfo) {
				$trackerid = $trackerinfo['trackerid'];
				$camptracker = "select * from {$table_prefix}campaigns_trackers where trackerid=:trackerid";
				$cmp_camptracker = $this->db->prepare($camptracker);
				$cmp_camptracker->bindParam(":trackerid", $trackerid);
				$cmp_camptracker->execute();

				$stmtcamptracker = $cmp_camptracker->fetchAll();

				$variablestracker = "select * from {$table_prefix}variables where trackerid=:trackerid";
				$vb_tracker = $this->db->prepare($variablestracker);
				$vb_tracker->bindParam(":trackerid", $trackerid);
				$vb_tracker->execute();

				$stmtvariablestracker = $vb_tracker->fetchAll();

				$appendtracker = "select * from  {$table_prefix}tracker_append where tracker_id=:trackerid";
				$gd_tracker = $this->db->prepare($appendtracker);
				$gd_tracker->bindParam(":trackerid", $trackerid);
				$gd_tracker->execute();


				$stmtappendtracker = $gd_tracker->fetchAll();


				$trackerdetail = array ();
				$campaigntrackerdetail = array ();
				$appendtrackerdetail = array ();
				$variabletrackerdetail = array ();

				if (count($stmttracker) > 0) {
					foreach ($stmttracker as $tracker) {

						$trackerdetail[$tracker['trackerid']] = array (
							'trackerid' => $tracker['trackerid'],
							'trackername' => $tracker['trackername'],
							'description' => $tracker['description'],
							'clientid' => $clientid,
							'status' => $tracker['status'],
							'type' => $tracker['type'],
							'linkcampaigns' => $tracker['linkcampaigns'],
							'variablemethod' => $tracker['variablemethod'],
							'appendcode' => $tracker['appendcode'],
							'updated' => $tracker['updated']
						);

						$results = json_encode(array ('Tracker details' => $trackerdetail));
					}

					if (count($stmtcamptracker)) {

						foreach ($stmtcamptracker as $camptracker) {

							$campaigntrackerdetail[$camptracker['campaign_trackerid']] = array (
								'campaign_trackerid' => $camptracker['campaign_trackerid'],
								'campaignid' => $camptracker['campaignid'],
								'status' => $camptracker['status']
							);

							$results = json_encode(array ('Campaign Tracker details' => $campaigntrackerdetail));
						}
					}
					if (count($stmtvariablestracker)) {

						foreach ($stmtvariablestracker as $variablestracker) {

							$variabletrackerdetail[$variablestracker['variableid']] = array (
								'variableid' => $variablestracker['variableid'],
								'name' => $variablestracker['name'],
								'description' => $variablestracker['description'],
								'datatype' => $variablestracker['datatype'],
								'purpose' => $variablestracker['purpose'],
								'reject_if_empty' => $variablestracker['reject_if_empty'],
								'is_unique' => $variablestracker['is_unique'],
								'unique_window' => $variablestracker['unique_window'],
								'variablecode' => $variablestracker['variablecode']
							);

							$results = json_encode(array ('Variable Tracker details' => $campaigntrackerdetail));
						}
					}
					if (count($stmtappendtracker)) {

						foreach ($stmtappendtracker as $appendtracker) {


							$appendtrackerdetail[$appendtracker['tracker_append_id']] = array (
								'tracker_append_id' => $appendtracker['tracker_append_id'],
								'rank' => $appendtracker['rank'],
								'tagcode' => $appendtracker['tagcode'],
								'paused' => $appendtracker['paused'],
								'autotrack' => $appendtracker['autotrack']
							);
						}
					}
					$response = array (

						'data' => $stmttracker,
						'response' => 'success',
						'statuscode' => '200',
						'msg' => 'success'
					);

					return $this->response->withJson($response);
				} else {

					$response = array ('response' => 'error', 'msg' => 'Requested tracker not available');

					return $this->response->withJson($response);
				}
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Tracker does not available for this client id');

			return $this->response->withJson($response);
		}
	}
})->add($container->get('client_val'));


/*****************************************************************************************/




/*********************************Targetting channel********************************************************/

/*
 * Targetting channel ADD
 * 
 * Input Parameters:
 * --------------- 
 * affiliateid
 * name
 * description
 * comments
 * logical
 * comparison
 * type
 * data
 * 
 * Arguments:
 * ---------
 * Agency ID
 */
$app->post('/add_targeting_channel/[{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		$affiliateid = $input['affiliateid'];
		$name = $input['name'];
		$description = $input['description'];
		$comments = $input['comments'];

		//".$table_prefix."acls_channel
		$value = "select * from {$table_prefix}affiliates where affiliateid=:affiliateid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":affiliateid", $affiliateid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();

		if (count($stmt)) {
			$value1 = "select * from {$table_prefix}affiliates where affiliateid=:affiliateid and agencyid=:agencyid";
			$tracker_data1 = $this->db->prepare($value1);
			$tracker_data1->bindParam(":affiliateid", $affiliateid);
			$tracker_data1->bindParam(":agencyid", $agencyid);
			$tracker_data1->execute();
			$stmt1 = $tracker_data1->fetchAll();

			if (count($stmt1)) {
				$multiplelogical = $input['logical'];
				$samlogical = explode(',', $multiplelogical);

				$multiplecomparison = $input['comparison'];
				$comparison = explode(',', $multiplecomparison);

				$multipletype = $input['type'];
				$type = explode(',', $multipletype);

				$multipledata = $input['data'];
				$data = explode('||', $multipledata);

				//Complile LImitation filed in banner
				$c[] = '';

				$j = 0;
				foreach ($type as $value) {
					$newvalue = explode(':', $value);
					$getvalues = $newvalue[1] . "_" . $newvalue[2];

					$compiledlimitation = "Max_check" . $getvalues . "('" . $data[$j] . "','" . $comparison[$j] . "')" . $samlogical[$j] . " ";

					array_push($c, $compiledlimitation);
					$j++;
				}
				if ($input['type']) {
					$compilevalue = implode('', $c);
					$acl_plugins = $input['type'];
				} else {
					$compilevalue = 'true';
					$acl_plugins = 'true';
				}

				$addchannel = "insert into  {$table_prefix}channel
					(`agencyid`,
					`affiliateid`,
					`name`,
					`description`,
					`compiledlimitation`,
					`acl_plugins`,
					`updated`,
					`active`,
					`comments` )
					values(
					:agencyid,
					:affiliateid,
					:name,
					'$description',
					:compiledlimitation,
					:acl_plugins,
					:updated,
					1,
					'$comments')";

				$djax_query_addchannel = $this->db->prepare($addchannel);
				$djax_query_addchannel->bindParam(":agencyid", $agencyid);
				$djax_query_addchannel->bindParam(":affiliateid", $affiliateid);
				$djax_query_addchannel->bindParam(":name", $name);
				//$djax_query_addchannel->bindParam(":description",$description);
				$djax_query_addchannel->bindParam(":compiledlimitation", $compilevalue);
				$djax_query_addchannel->bindParam(":acl_plugins", $acl_plugins);
				$djax_query_addchannel->bindParam(":updated", $datetime);
				//$djax_query_addchannel->bindParam(":comments",$comments);

				$djax_query_addchannel->execute();

				$logical = $input['logical'];
				$type = $input['type'];
				$comparison = $input['comparison'];
				$data = $input['data'];

				$channelid = $this->db->lastInsertId();

				if ($input['type']) {

					$multiplelogical = $input['logical'];
					$samlogical = explode(',', $multiplelogical);


					$multiplecomparison = $input['comparison'];
					$comparison = explode(',', $multiplecomparison);

					$multipletype = $input['type'];
					$type = explode(',', $multipletype);

					$multipledata = $input['data'];
					$data = explode('||', $multipledata);

					//need to check 
					$executionorder = 0;
					$i = 0;


					foreach ($samlogical as $logical) {

						$addacls = "insert into 
							{$table_prefix}acls_channel(`channelid`,`logical`,`type`,`comparison`,`data`,`executionorder`) 
							values(:channelid,:logical,:type,:comparison,:data,:executionorder)";

						$djax_query_addacls = $this->db->prepare($addacls);
						$djax_query_addacls->bindParam(":channelid", $channelid);
						$djax_query_addacls->bindParam(":logical", $logical);
						$djax_query_addacls->bindParam(":type", $type[$i]);
						$djax_query_addacls->bindParam(":comparison", $comparison[$i]);
						$djax_query_addacls->bindParam(":data", $data[$i]);
						$djax_query_addacls->bindParam(":executionorder", $executionorder);
						$djax_query_addacls->execute();


						$executionorder++;
						$i++;
					}
				}
				
				//audit log maintain
				$create_user_id = $_SESSION['user_id'];
				$module = 'channel_'.$name.'_'.$channelid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":create_user_id", $create_user_id);
				$audit->bindParam(":created_date", $datetime);
				$audit->execute();

				$results = array ('response' => 'success', 'statuscode' => '200', 'msg' => 'Delivery rule set added successfully');

				return $this->response->withJson($results);
			} else {
				$response = array (
					'response' => 'error',
					'msg' => 'entered affiliate id not available under the entered agencyid'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'entered affiliate id not available'
			);

			return $this->response->withJson($response);
		}
	}
})->add($container->get('target_val'));
//~ ///////////////////////////////

//targeting channel limitation method
$app->post('/add_targeting_limitation(test)/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$req = "select *  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$cam = $this->db->prepare($req);
		$cam->bindParam("channelid", $args['channelid']);
		$cam->execute();
		$campaign = $cam->fetchAll();



		if (!$campaign) {
			$res = array (
				'response' => 'error',
				'msg' => 'channelid is not valid.'
			);
			return $this->response->withJson($res);
		}


		$channelid = "select channelid  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$bnr = $this->db->prepare($channelid);
		$bnr->bindParam("channelid", $args['channelid']);
		$bnr->execute();
		$banner = $bnr->fetchAll();
		$data['compiledlimitation'] = '';
		$data['acl_plugins'] = '';

		if (!$banner) {
			$res = array (
				'response' => 'error',
				'msg' => 'No channel for given channelid!Please check the channelid!'
			);
			return $this->response->withJson($res);
		}

		$comparison = array ('==', '!=', '=~', '!~', '=x', '!x', 'gt', 'lt', 'le', 'ge', '>', '<', '>=', '<=', 'nn');
		foreach ($input as $inp) {
			if (($inp['type'])) {
				if (!in_array($inp['comparison'], $comparison)) {
					$response = array (
						'response' => 'error',
						'msg' => 'Parameters must be inside [ ] & comparision operators must be valid format'
					);

					return $this->response->withJson($response);
				}
			}
		}


		foreach ($banner as $dat) {
			$executionid = "Delete from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
			$bnr = $this->db->prepare($executionid);
			$bnr->bindParam("channelid", $dat['channelid']);
			$bnr->execute();
		}


		foreach ($banner as $dat) {
			if ($input) {
				foreach ($input as $inp) {

					//set function name using delivery limitations

					switch ($inp['type']) {
						case 'deliveryLimitations:Client:Browser':
							$function_name = 'MAX_checkClient_Browser';
							$string_compare = 'Client:Browser';
							break;
						case 'deliveryLimitations:Client:BrowserVersion':
							$function_name = 'MAX_checkClient_BrowserVersion';
							$string_compare = 'Client:BrowserVersion';
							break;
						case 'deliveryLimitations:Client:Domain':
							$function_name = 'MAX_checkClient_Domain';
							$string_compare = 'Client:Domain';
							break;
						case 'deliveryLimitations:Client:Ip':
							$function_name = 'MAX_checkClient_Ip';
							$string_compare = 'Client:Ip';
							break;
						case 'deliveryLimitations:Client:Language':
							$function_name = 'MAX_checkClient_Language';
							$string_compare = 'Client:Language';
							break;
						case 'deliveryLimitations:Client:Os':
							$function_name = 'MAX_checkClient_Os';
							$string_compare = 'Client:Os';
							break;
						case 'deliveryLimitations:Client:OsVersion':
							$function_name = 'MAX_checkClient_OsVersion';
							$string_compare = 'Client:OsVersion';
							break;
						case 'deliveryLimitations:Client:Useragent':
							$function_name = 'MAX_checkClient_Useragent';
							$string_compare = 'Client:Useragent';
							break;
						case 'deliveryLimitations:Site:Pageurl':
							$function_name = 'MAX_checkSite_Pageurl';
							$string_compare = 'Site:Pageurl';
							break;

						case 'deliveryLimitations:Site:Referingpage':
							$function_name = 'MAX_checkSite_Referingpage';
							$string_compare = 'Site:Referingpage';
							break;
						case 'deliveryLimitations:Site:Registerabledomainlist':
							$function_name = 'MAX_checkSite_Registerabledomainlist';
							$string_compare = 'Site:Registerabledomainlist';
							break;
						case 'deliveryLimitations:Site:Hostnamelist':
							$function_name = 'MAX_checkSite_Hostnamelist';
							$string_compare = 'Site:Hostnamelist';
							break;
						case 'deliveryLimitations:Site:Source':
							$function_name = 'MAX_checkSite_Source';
							$string_compare = 'Site:Source';
							break;
						case 'deliveryLimitations:Site:Variable':
							$function_name = 'MAX_checkSite_Variable';
							$string_compare = 'Site:Variable';
							break;
						case 'deliveryLimitations:Time:Date':
							$function_name = 'MAX_checkTime_Date';
							$string_compare = 'Time:Date';
							break;
						case 'deliveryLimitations:Time:Day':
							$function_name = 'MAX_checkTime_Day';
							$string_compare = 'Time:Day';
							break;
						case 'deliveryLimitations:Time:Hour':
							$function_name = 'MAX_checkTime_Hour';
							$string_compare = 'Time:Hour';
							break;
						default:
							$function_name = 'Empty';
							$string_compare = 'Empty';
							break;
					}


					//Insert values into ".$table_prefix."acls table
					//select maximum values from the table
					$executionid = "select MAX(executionorder) as execid,data  from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
					$bnr = $this->db->prepare($executionid);
					$bnr->bindParam("channelid", $dat['channelid']);
					$bnr->execute();
					$bnr_exec = $bnr->fetchAll();
					if ($bnr_exec['0']['data']) {
						$bnr_exec['0']['execid'] += 1;
					} else {
						$bnr_exec['0']['execid'] = 0;
					}

					if ($inp["type"]) {
						//Insert values into ".$table_prefix."acls table
						$sql = "INSERT INTO " . $table_prefix . "acls_channel (channelid,logical,type,comparison,data,executionorder) VALUES (:channelid,:logic,:type,:comparison,:data,:executionorder)";
						$sth = $this->db->prepare($sql);
						$sth->bindParam("channelid", $dat['channelid']);
						$sth->bindParam("logic", $inp['logical']);
						$sth->bindParam("type", $inp['type']);
						$sth->bindParam("comparison", $inp['comparison']);
						$sth->bindParam("data", $inp['data']);
						$sth->bindParam("executionorder", $bnr_exec['0']['execid']);
						$sth->execute();
						if ($inp["type"]) {
							if ($data['compiledlimitation'] && $data['acl_plugins']) {
								$data['compiledlimitation'] .= ' ' . $inp["logical"] . " " . $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$chk = '"' . $inp["type"] . '"';
								if (strpos(strtolower($data["acl_plugins"]), strtolower($string_compare)) == false) {

									$data["acl_plugins"] .= ',' . $inp["type"];
								}
							} else {
								$data["compiledlimitation"] .= $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$data["acl_plugins"] .= $inp["type"];
							}
						} else {
							$data['compiledlimitation'] = '';
							$data['acl_plugins'] = '';
						}
					} else {
						$data['compiledlimitation'] = '';
						$data['acl_plugins'] = '';
					}


					$sqlupdate = "UPDATE " . $table_prefix . "channel SET compiledlimitation=:check,acl_plugins=:type WHERE channelid=:channelid";
					$stc = $this->db->prepare($sqlupdate);
					$stc->bindParam("type", $data['acl_plugins']);
					$stc->bindParam("check", $data['compiledlimitation']);
					$stc->bindParam("channelid", $dat['channelid']);
					$stc->execute();
				}
			} else {

				$res = array (
					'response' => 'error',
					'msg' => 'Request Is Empty'
				);
				return $this->response->withJson($res);
			}
		}

		$res = array (
			'response' => 'ok',
			'msg' => 'channel successfully updated with delivery limitation'
		);
		return $this->response->withJson($res);
		return $response;
	}
});





$app->post('/add_targeting_limitation/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$req = "select *  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$cam = $this->db->prepare($req);
		$cam->bindParam("channelid", $args['channelid']);
		$cam->execute();
		$campaign = $cam->fetchAll();

		if (!$campaign) {
			$res = array (
				'response' => 'error',
				'msg' => 'No channel for given channelid!Please check the channelid!'
			);
			return $this->response->withJson($res);
		}


		$channelid = "select channelid  from " . $table_prefix . "channel WHERE channelid=:channelid";
		$bnr = $this->db->prepare($channelid);
		$bnr->bindParam("channelid", $args['channelid']);
		$bnr->execute();
		$banner = $bnr->fetchAll();
		$data['compiledlimitation'] = '';
		$data['acl_plugins'] = '';

		if (!$banner) {
			$res = array (
				'response' => 'error',
				'msg' => ' channelid Not available!'
			);
			return $this->response->withJson($res);
		}

		$comparison = array ('==', '!=', '=~', '!~', '=x', '!x', 'gt', 'lt', 'le', 'ge', '>', '<', '>=', '<=', 'nn');
		foreach ($input['data'] as $inp) {
			if (($inp['type'])) {
				if (!in_array($inp['comparison'], $comparison)) {
					$response = array (
						'response' => 'error',
						'msg' => 'Comparision operator passed in array is not supported!'
					);

					return $this->response->withJson($response);
				}
			}
		}


		foreach ($banner as $dat) {
			$executionid = "Delete from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
			$bnr = $this->db->prepare($executionid);
			$bnr->bindParam("channelid", $dat['channelid']);
			$bnr->execute();
		}


		foreach ($banner as $dat) {
			if ($input['data']) {
				foreach ($input['data'] as $inp) {

					//set function name using delivery limitations

					switch ($inp['type']) {
						case 'deliveryLimitations:Client:Browser':
							$function_name = 'MAX_checkClient_Browser';
							$string_compare = 'Client:Browser';
							break;
						case 'deliveryLimitations:Client:BrowserVersion':
							$function_name = 'MAX_checkClient_BrowserVersion';
							$string_compare = 'Client:BrowserVersion';
							break;
						case 'deliveryLimitations:Client:Domain':
							$function_name = 'MAX_checkClient_Domain';
							$string_compare = 'Client:Domain';
							break;
						case 'deliveryLimitations:Client:Ip':
							$function_name = 'MAX_checkClient_Ip';
							$string_compare = 'Client:Ip';
							break;
						case 'deliveryLimitations:Client:Language':
							$function_name = 'MAX_checkClient_Language';
							$string_compare = 'Client:Language';
							break;
						case 'deliveryLimitations:Client:Os':
							$function_name = 'MAX_checkClient_Os';
							$string_compare = 'Client:Os';
							break;
						case 'deliveryLimitations:Client:OsVersion':
							$function_name = 'MAX_checkClient_OsVersion';
							$string_compare = 'Client:OsVersion';
							break;
						case 'deliveryLimitations:Client:Useragent':
							$function_name = 'MAX_checkClient_Useragent';
							$string_compare = 'Client:Useragent';
							break;
						case 'deliveryLimitations:Site:Pageurl':
							$function_name = 'MAX_checkSite_Pageurl';
							$string_compare = 'Site:Pageurl';
							break;

						case 'deliveryLimitations:Site:Referingpage':
							$function_name = 'MAX_checkSite_Referingpage';
							$string_compare = 'Site:Referingpage';
							break;
						case 'deliveryLimitations:Site:Registerabledomainlist':
							$function_name = 'MAX_checkSite_Registerabledomainlist';
							$string_compare = 'Site:Registerabledomainlist';
							break;
						case 'deliveryLimitations:Site:Hostnamelist':
							$function_name = 'MAX_checkSite_Hostnamelist';
							$string_compare = 'Site:Hostnamelist';
							break;
						case 'deliveryLimitations:Site:Source':
							$function_name = 'MAX_checkSite_Source';
							$string_compare = 'Site:Source';
							break;
						case 'deliveryLimitations:Site:Variable':
							$function_name = 'MAX_checkSite_Variable';
							$string_compare = 'Site:Variable';
							break;
						case 'deliveryLimitations:Time:Date':
							$function_name = 'MAX_checkTime_Date';
							$string_compare = 'Time:Date';
							break;
						case 'deliveryLimitations:Time:Day':
							$function_name = 'MAX_checkTime_Day';
							$string_compare = 'Time:Day';
							break;
						case 'deliveryLimitations:Time:Hour':
							$function_name = 'MAX_checkTime_Hour';
							$string_compare = 'Time:Hour';
							break;
						case 'deliveryLimitations:Geo:Areacode':
							$function_name = 'MAX_checkGeo_Areacode';
							$string_compare = 'Geo:Areacode';
							break;
						case 'deliveryLimitations:Geo:City':
							$function_name = 'MAX_checkGeo_City';
							$string_compare = 'Geo:City';
							break;
						case 'deliveryLimitations:Geo:Country':
							$function_name = 'MAX_checkGeo_Country';
							$string_compare = 'Geo:Country';
							break;
						case 'deliveryLimitations:Geo:Dma':
							$function_name = 'MAX_checkGeo_Dma';
							$string_compare = 'Geo:Dma';
							break;
						case 'deliveryLimitations:Geo:Latlong':
							$function_name = 'MAX_checkGeo_Latlong';
							$string_compare = 'Geo:Latlong';
							break;
						case 'deliveryLimitations:Geo:Netspeed':
							$function_name = 'MAX_checkGeo_Netspeed';
							$string_compare = 'Geo:Netspeed';
							break;
						case 'deliveryLimitations:Geo:Organisation':
							$function_name = 'MAX_checkGeo_Organisation';
							$string_compare = 'Geo:Organisation';
							break;
						case 'deliveryLimitations:Geo:Postalcode':
							$function_name = 'MAX_checkGeo_Postalcode';
							$string_compare = 'Geo:Postalcode';
							break;
						case 'deliveryLimitations:Geo:Region':
							$function_name = 'MAX_checkGeo_Region';
							$string_compare = 'Geo:Region';
							break;
						case 'deliveryLimitations:Geo:Continent':
							$function_name = 'MAX_checkGeo_Continent';
							$string_compare = 'Geo:Continent';
							break;
						default:
							$function_name = 'Empty';
							$string_compare = 'Empty';
							break;
					}


					//Insert values into ".$table_prefix."acls_channel table

					//select maximum values from the table
					$executionid = "select MAX(executionorder) as execid,data  from " . $table_prefix . "acls_channel WHERE channelid=:channelid";
					$bnr = $this->db->prepare($executionid);
					$bnr->bindParam("channelid", $dat['channelid']);
					$bnr->execute();
					$bnr_exec = $bnr->fetchAll();
					if ($bnr_exec['0']['data']) {
						$bnr_exec['0']['execid'] += 1;
					} else {
						$bnr_exec['0']['execid'] = 0;
					}

					if ($inp["type"]) {
						//Insert values into ".$table_prefix."acls_channel table
						$sql = "INSERT INTO " . $table_prefix . "acls_channel (channelid,logical,type,comparison,data,executionorder) VALUES (:channelid,:logic,:type,:comparison,:data,:executionorder)";
						$sth = $this->db->prepare($sql);
						$sth->bindParam("channelid", $dat['channelid']);
						$sth->bindParam("logic", $inp['logical']);
						$sth->bindParam("type", $inp['type']);
						$sth->bindParam("comparison", $inp['comparison']);
						$sth->bindParam("data", $inp['data']);
						$sth->bindParam("executionorder", $bnr_exec['0']['execid']);
						$sth->execute();



						if ($inp["type"]) {

							//continent-geo


							if ($inp["type"] == 'deliveryLimitations:Geo:Continent') {
								$inp["data"] = explode(",", $inp["data"]);

								$continent_array = array ();
								foreach ($inp["data"] as $kk => $test_limit) {
									if ($test_limit == "AF") {
										$con_val = 'ao,bf,bi,bj,bw,cd,cf,cg,ci,cm,cv,dj,dz,eg,eh,er,et,ga,gh,gm,gn,gq,gw,ke,km,lr,ls,ly,ma,mg,ml,mr,mu,mw,mz,na,ne,ng,re,rw,sc,sd,sh,sl,sn,so,st,sz,td,tg,tn,tz,ug,yt,za,zm,zw,ss';
									}
									if ($test_limit == "IN") {
										$con_val = 'kowsi';
									}
									if ($test_limit == "AQ") {
										$con_val = '';
									}
									if ($test_limit == "CA") {
										$con_val = '';
									}
									if ($test_limit == "AS") {
										$con_val = 'ap,ae,af,am,az,bd,bh,bn,bt,cc,cn,cx,cy,ge,hk,id,il,in,io,iq,ir,jo,jp,kg,kh,kp,kr,kw,kz,la,lb,lk,mm,mn,mo,mv,my,np,om,ph,pk,ps,qa,sa,sg,sy,th,tj,tm,tl,tw,uz,vn,ye';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "EU") {
										$con_val = 'eu,ad,al,at,ba,be,bg,by,ch,cz,de,dk,ee,es,fi,fo,fr,gb,gi,gr,hr,hu,ie,is,it,li,lt,lu,lv,mc,md,mk,mt,nl,no,pl,pt,ro,ru,se,si,sj,sk,sm,tr,ua,va,rs,me,ax,gg,im,je';
									}
									if ($test_limit == "NA") {
										$con_val = 'ag,ai,cw,aw,bb,bm,bs,bz,ca,cr,cu,dm,do,sx,gd,gl,gp,gt,hn,ht,jm,kn,ky,lc,mq,ms,mx,ni,pa,pm,pr,sv,tc,tt,us,vc,vg,vi,bl,mf,bq';
									}
									if ($test_limit == "OC") {
										$con_val = 'as,au,ck,fj,fm,gu,ki,mh,mp,nc,nf,nr,nu,nz,pf,pg,pn,pw,sb,tk,to,tv,um,vu,wf,ws';
									}
									if ($test_limit == "SA") {
										$con_val = 'ar,bo,br,cl,co,ec,fk,gf,gy,pe,py,sr,uy,ve';
									}
									if ($test_limit == "AN") {
										$con_val = 'bv,gs,hm,tf';
									}

									$continent_array[] = $con_val;
								}
								$inp["data"] = implode(",", array_filter($continent_array));
							}

							//end

							if ($inp["type"] == 'deliveryLimitations:Geo:City') {
								$inp["data"] = strtolower($inp["data"]);
							}
							if ($inp["type"] == 'deliveryLimitations:Geo:Region') {
								$inp["data"] = strtolower($inp["data"]);
							}

							if ($data['compiledlimitation'] && $data['acl_plugins']) {
								$data['compiledlimitation'] .= ' ' . $inp["logical"] . " " . $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$chk = '"' . $inp["type"] . '"';
								if (strpos(strtolower($data["acl_plugins"]), strtolower($string_compare)) == false) {

									$data["acl_plugins"] .= ',' . $inp["type"];
								}
							} else {
								$data["compiledlimitation"] .= $function_name . "('" . $inp["data"] . "', '" . $inp["comparison"] . "')";
								$data["acl_plugins"] .= $inp["type"];
							}
						} else {
							$data['compiledlimitation'] = '';
							$data['acl_plugins'] = '';
						}
					} else {
						$data['compiledlimitation'] = '';
						$data['acl_plugins'] = '';
					}



					$sqlupdate = "UPDATE " . $table_prefix . "channel SET compiledlimitation=:check,acl_plugins=:type,acls_updated=now() WHERE channelid=:channelid";
					$stc = $this->db->prepare($sqlupdate);
					$stc->bindParam("type", $data['acl_plugins']);
					$stc->bindParam("check", $data['compiledlimitation']);
					$stc->bindParam("channelid", $dat['channelid']);
					$stc->execute();
				}
			} else if (empty ($input['data'])) {

				$sqlupdate = "UPDATE " . $table_prefix . "channel SET compiledlimitation=:check,acl_plugins=:type WHERE channelid=:channelid";
				$stc = $this->db->prepare($sqlupdate);
				$stc->bindParam("type", $data['acl_plugins']);
				$stc->bindParam("check", $data['compiledlimitation']);
				$stc->bindParam("channelid", $dat['channelid']);
				$stc->execute();

				$res = array (
					'response' => 'ok',
					'msg' => 'Delivery limitations has been updated successfully'
				);
			} else {

				$res = array (
					'response' => 'error',
					'msg' => 'Request Is Empty'
				);
				return $this->response->withJson($res);
			}
		}

		$res = array (
			'response' => 'ok',
			'msg' => 'Delivery limitations has been updated successfully'
		);
		return $this->response->withJson($res);
		return $response;
	}
});
/*
 * Targetting channel EDIT
 * 
 * Input Parameters:
 * --------------- 
 * affiliateid
 * name
 * description
 * comments
 * logical
 * comparison
 * type
 * data
 * 
 * Arguments:
 * ---------
 * Channel ID
 */
$app->post('/edit_targeting_channel/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		//~ $results = array();

		$affiliateid = (isset ($input['affiliateid'])) ? $input['affiliateid'] : '';
		$name = (isset ($input['name'])) ? $input['name'] : '';
		$description = (isset ($input['description'])) ? $input['description'] : '';
		$comments = (isset ($input['comments'])) ? $input['comments'] : '';
		$logical = (isset ($input['logical'])) ? $input['logical'] : '';
		$comparison = (isset ($input['comparison'])) ? $input['comparison'] : '';
		$type = (isset ($input['type'])) ? $input['type'] : '';
		$data = (isset ($input['data'])) ? $input['data'] : '';

		$datetime = date('Y-m-d H:i:s');
		$channelid = $args['channelid'];
		$getchannel = "SELECT * FROM " . $table_prefix . "channel AS t1";
		$std = $this->db->prepare($getchannel);
		$std->execute();
		$targets = $std->fetchAll();
		//JOIN ".$table_prefix."acls_channel AS t2 ON t1.channelid =".$channelid." AND t1.channelid = t2.channelid
		if ($targets) {
			if (isset ($affiliateid) && !empty ($affiliateid)) {
				$sql_affiliateid = $affiliateid;
			} else {
				$sql_affiliateid = $targets[0]['affiliateid'];
			}
			if (isset ($name) && !empty ($name)) {
				$sql_name = $name;
			} else {
				$sql_name = $targets[0]['name'];
			}
			if (isset ($description) && !empty ($description)) {
				$sql_description = $description;
			} else {
				$sql_description = '';
			}
			if (isset ($comments) && !empty ($comments)) {
				$sql_comments = $comments;
			} else {
				$sql_comments = '';
			}
			if (isset ($logical) && !empty ($logical)) {
				$sql_logical = $logical;
			} else {
				$sql_logical = $targets[0]['logical'];
			}
			if (isset ($comparison) && !empty ($comparison)) {
				$sql_comparison = $comparison;
			} else {
				$sql_comparison = $targets[0]['comparison'];
			}
			if (isset ($type) && !empty ($type)) {
				$sql_type = $type;
			} else {
				$sql_type = $targets[0]['acl_plugins'];
			}
			if (isset ($data) && !empty ($data)) {
				$sql_data = $data;
			} else {
				$sql_data = $targets[0]['data'];
			}


			//".$table_prefix."acls_channel

			$multiplelogical = $input['logical'];
			$samlogical = explode(',', $multiplelogical);

			$multiplecomparison = $input['comparison'];
			$comparison = explode(',', $multiplecomparison);

			$multipletype = $input['type'];
			$type = explode(',', $multipletype);

			$multipledata = $input['data'];
			$data = explode('||', $multipledata);

			//Complile LImitation filed in banner
			//$c[]='';

			$j = 0;
			/* foreach($type as  $value)
																																																																																																																																																																									{
																																																																																																																																																																									$newvalue=explode(':',$value);
																																																																																																																																																																									$getvalues=$newvalue[1]."_".$newvalue[2];
																																																																																																																																																																									
																																																																																																																																																																									$compiledlimitation="Max_check".$getvalues."('".$data[$j]."','".$comparison[$j]."')".$samlogical[$j]." ";
																																																																																																																																																																									
																																																																																																																																																																									array_push($c,$compiledlimitation);
																																																																																																																																																																									$j++;
																																																																																																																																																																									
																																																																																																																																																																									} 
																																																																																																																																																																									if($input['type']){
																																																																																																																																																																									$compilevalue=implode('',$c);
																																																																																																																																																																									$acl_plugins=$input['type'];
																																																																																																																																																																									}else{
																																																																																																																																																																									$compilevalue='true';
																																																																																																																																																																									$acl_plugins='true';
																																																																																																																																																																								}*/

			$cha_upd = "update {$table_prefix}channel set  `affiliateid`=:affiliateid,`name`=:name,`description`=:description,`comments`=:comments,`updated`=now() where channelid=:channelid";

			$channel_edit = $this->db->prepare($cha_upd);
			$channel_edit->bindParam(":affiliateid", $sql_affiliateid);
			$channel_edit->bindParam(":name", $sql_name);
			$channel_edit->bindParam(":description", $sql_description);
			/* $channel_edit->bindParam(":compiledlimitation",$compilevalue);
																																																																																																																																																																								$channel_edit->bindParam(":acl_plugins",$sql_type); */
			$channel_edit->bindParam(":comments", $sql_comments);
			$channel_edit->bindParam(":channelid", $channelid);
			$abc = $channel_edit->execute();

			if ($input['type']) {
				$acls_cha_upd = "update {$table_prefix}acls_channel set  `logical`=:logical,`type`=:type,`comparison`=:comparison,`data`=:data where channelid=:channelid";


				$acls_edit = $this->db->prepare($acls_cha_upd);
				$acls_edit->bindParam(":logical", $sql_logical);
				$acls_edit->bindParam(":type", $sql_type);
				$acls_edit->bindParam(":comparison", $sql_comparison);
				$acls_edit->bindParam(":data", $sql_data);
				$acls_edit->bindParam(":channelid", $channelid);
				$update_cha = $acls_edit->execute();
			}
			if ($abc) {
			
			    //audit log maintain
				$update_user_id = $_SESSION['user_id'];
				$module = 'channel_'.$sql_name.'_'.$channelid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `update_user_id`,  `updated_date`) VALUES (:module,:update_user_id,:updated_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":update_user_id", $update_user_id);
				$audit->bindParam(":updated_date", $datetime);
				$audit->execute();
			
				$response = array ('response' => 'success', 'statuscode' => '200', 'msg' => 'Delivery rule set updated successfully');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter the valid channelid');
			return $this->response->withJson($response);
		}
	}
});



$app->post('/deletechannel_single_limitation/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$channelid = $args['channelid'];
		$del_type = $input['type'];
		$referchannel = "select * from  {$table_prefix}channel where channelid=:channelid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":channelid", $channelid);
		$djax_query_referchannel->execute();
		$stmtchannel = $djax_query_referchannel->fetchAll();

		$referchannelacl = "select * from  {$table_prefix}acls_channel where type=:type AND channelid=:channelid";
		$djax_query_referchannelacl = $this->db->prepare($referchannelacl);
		$djax_query_referchannelacl->bindParam(":channelid", $channelid);
		$djax_query_referchannelacl->bindParam(":type", $del_type);
		$djax_query_referchannelacl->execute();
		$stmtchannelacl = $djax_query_referchannelacl->fetchAll();


		if (!empty ($stmtchannelacl)) {

			if (count($stmtchannel) > 0) {

				$exp_data = explode(",", $stmtchannel[0]['acl_plugins']);
				$user_values = array ();
				foreach ($exp_data as $key => $value) {
					if ($value == $input['type']) {
						unset ($value);
					} else {
						$user_values[] = $value;
					}
				}

				$limit_count = count($user_values);
				if ($limit_count > 1) {
					$final_set = implode(',', array_filter($user_values));
				} else if ($limit_count == 1) {
					$final_set = implode('', array_filter($user_values));
				} else {
					$final_set = 'true';
				}

				$test_data = explode(",", $final_set);

				$i = 0;
				$test_values = array ();
				foreach ($test_data as $m => $log) {
					if ($log != 'true') {
						switch ($log) {
							case 'deliveryLimitations:Client:Browser':
								$function_name = 'MAX_checkClient_Browser';
								$string_compare = 'Client:Browser';
								break;
							case 'deliveryLimitations:Client:BrowserVersion':
								$function_name = 'MAX_checkClient_BrowserVersion';
								$string_compare = 'Client:BrowserVersion';
								break;
							case 'deliveryLimitations:Client:Domain':
								$function_name = 'MAX_checkClient_Domain';
								$string_compare = 'Client:Domain';
								break;
							case 'deliveryLimitations:Client:Ip':
								$function_name = 'MAX_checkClient_Ip';
								$string_compare = 'Client:Ip';
								break;
							case 'deliveryLimitations:Client:Language':
								$function_name = 'MAX_checkClient_Language';
								$string_compare = 'Client:Language';
								break;
							case 'deliveryLimitations:Client:Os':
								$function_name = 'MAX_checkClient_Os';
								$string_compare = 'Client:Os';
								break;
							case 'deliveryLimitations:Client:OsVersion':
								$function_name = 'MAX_checkClient_OsVersion';
								$string_compare = 'Client:OsVersion';
								break;
							case 'deliveryLimitations:Client:Useragent':
								$function_name = 'MAX_checkClient_Useragent';
								$string_compare = 'Client:Useragent';
								break;
							case 'deliveryLimitations:Site:Pageurl':
								$function_name = 'MAX_checkSite_Pageurl';
								$string_compare = 'Site:Pageurl';
								break;

							case 'deliveryLimitations:Site:Referingpage':
								$function_name = 'MAX_checkSite_Referingpage';
								$string_compare = 'Site:Referingpage';
								break;
							case 'deliveryLimitations:Site:Registerabledomainlist':
								$function_name = 'MAX_checkSite_Registerabledomainlist';
								$string_compare = 'Site:Registerabledomainlist';
								break;
							case 'deliveryLimitations:Site:Hostnamelist':
								$function_name = 'MAX_checkSite_Hostnamelist';
								$string_compare = 'Site:Hostnamelist';
								break;
							case 'deliveryLimitations:Site:Source':
								$function_name = 'MAX_checkSite_Source';
								$string_compare = 'Site:Source';
								break;
							case 'deliveryLimitations:Site:Variable':
								$function_name = 'MAX_checkSite_Variable';
								$string_compare = 'Site:Variable';
								break;
							case 'deliveryLimitations:Time:Date':
								$function_name = 'MAX_checkTime_Date';
								$string_compare = 'Time:Date';
								break;
							case 'deliveryLimitations:Time:Day':
								$function_name = 'MAX_checkTime_Day';
								$string_compare = 'Time:Day';
								break;
							case 'deliveryLimitations:Time:Hour':
								$function_name = 'MAX_checkTime_Hour';
								$string_compare = 'Time:Hour';
								break;
						}
						$refer_channelacl = "select * from  {$table_prefix}acls_channel where type=:type AND channelid=:channelid";
						$djaxquery_referchannelacl = $this->db->prepare($refer_channelacl);
						$djaxquery_referchannelacl->bindParam(":channelid", $channelid);
						$djaxquery_referchannelacl->bindParam(":type", $log);
						$djaxquery_referchannelacl->execute();
						$stmtchannel_acl = $djaxquery_referchannelacl->fetchAll();

						$acl_entry = $stmtchannel_acl[0]['data'];
						$acl_comp = $stmtchannel_acl[0]['comparison'];
						$acl_log = $stmtchannel_acl[0]['logical'];
						$len_string = strlen($acl_entry);

						if ($function_name == 'MAX_checkSite_Hostnamelist') {

							$build_func = "MAX_checkSite_Hostnamelist('a:1:{s:" . $len_string . ":" . '"' . $acl_entry . '";b:1;}' . "', '" . $acl_comp . "')" . " " . $acl_log;
						} else {
							$build_func = $function_name . "('" . $acl_entry . "', '" . $acl_comp . "')" . " " . $acl_log;
						}

						$test_values[] = $build_func;
					}


					$end_set = implode(' ', array_filter($test_values));

					$end_val = substr($end_set, -1);
					if ($end_val == 'd') {
						$end_set = substr($end_set, 0, -4);
					} else if ($end_val == 'r') {
						$end_set = substr($end_set, 0, -3);
					} else {
						$end_set = $end_set;
					}


					$deletechannel = "update {$table_prefix}channel set compiledlimitation=:end_set,acl_plugins=:final_set where channelid=:channelid";
					$djax_query_deletechannel = $this->db->prepare($deletechannel);
					$djax_query_deletechannel->bindParam(":channelid", $channelid);
					$djax_query_deletechannel->bindParam(":final_set", $final_set);
					$djax_query_deletechannel->bindParam(":end_set", $end_set);
					$djax_query_deletechannel->execute();


					$deleteacls = "DELETE FROM  {$table_prefix}acls_channel WHERE type=:type AND channelid=:channelid";
					$djax_query_deleteacls = $this->db->prepare($deleteacls);
					$djax_query_deleteacls->bindParam(":channelid", $channelid);
					$djax_query_deleteacls->bindParam(":type", $del_type);
					$djax_query_deleteacls->execute();




					$response = array ('response' => 'ok', 'msg' => 'all limitation  under Channel Successfully deleted');
				}
			}
		} else {

			$response = array ('response' => 'error', 'msg' => 'No limitation available');
		}
	}



	return $this->response->withJson($response);
});

$app->delete('/deletechannel_all_limitation/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$channelid = $args['channelid'];
		$referchannel = "select * from  {$table_prefix}channel where channelid=:channelid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":channelid", $channelid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();


		if (count($stmtchannel) > 0) {

			$deletechannel = "update {$table_prefix}channel set compiledlimitation='true' , acl_plugins='true' where channelid=:channelid";
			$djax_query_deletechannel = $this->db->prepare($deletechannel);
			$djax_query_deletechannel->bindParam(":channelid", $channelid);
			$djax_query_deletechannel->execute();


			$deleteacls = "DELETE FROM  {$table_prefix}acls_channel WHERE channelid=:channelid";
			$djax_query_deleteacls = $this->db->prepare($deleteacls);
			$djax_query_deleteacls->bindParam(":channelid", $channelid);
			$djax_query_deleteacls->execute();


			$response = array ('response' => 'ok', 'msg' => 'all limitation  under Channel Successfully deleted');
		} else {

			$response = array ('response' => 'error', 'msg' => 'Requested channelid doesnot found');
		}
	}



	return $this->response->withJson($response);
});

$app->delete('/deletechannel/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$channelid = $args['channelid'];
		$referchannel = "select * from  {$table_prefix}channel where channelid in (:channelid)";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":channelid", $channelid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();


		if (count($stmtchannel) > 0) {

			foreach ($stmtchannel as $key => $channel) {
				if ($key > 0) {
					$channelid .= $channel['channelid'];
				}
			}

			$deletechannel = "DELETE FROM  {$table_prefix}channel where channelid in ($channelid)";
			$djax_query_deletechannel = $this->db->prepare($deletechannel);
			//$djax_query_deletechannel->bindParam(":channelid",$channelid);
			$djax_query_deletechannel->execute();


			$deleteacls = "DELETE FROM  {$table_prefix}acls_channel WHERE channelid in ($channelid)";
			$djax_query_deleteacls = $this->db->prepare($deleteacls);
			//$djax_query_deleteacls->bindParam(":channelid",$channelid);
			$djax_query_deleteacls->execute();
			
			$channelname = $stmtchannel[0]['name'];
			$datetime = date('Y-m-d H:i:s');
			//audit log maintain
			$delete_user_id = $_SESSION['user_id'];
			$module = 'channel_'.$channelname.'_'.$channelid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `delete_user_id`,  `deleted_date`) VALUES (:module,:delete_user_id,:deleted_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":delete_user_id", $delete_user_id);
			$audit->bindParam(":deleted_date", $datetime);
			$audit->execute();


			$response = array ('response' => 'success', 'statuscode' => '200', 'msg' => 'Channel Successfully deleted');
		} else {

			$response = array ('response' => 'error', 'msg' => 'Requested channelid doesnot found');
		}
	}



	return $this->response->withJson($response);
});


$app->get('/gettargetingchannel/[{channelid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$channelid = $args['channelid'];
		$referchannel = "select * from {$table_prefix}channel where channelid=:channelid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":channelid", $channelid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();

		$bannerchannel = array ();

		if (count($stmtchannel) > 0) {
			//[$channelid]
			$bannerchannel =
				array (
					'agencyid' => $stmtchannel[0]['agencyid'],
					'affiliateid' => $stmtchannel[0]['affiliateid'],
					'name' => $stmtchannel[0]['name'],
					'description' => $stmtchannel[0]['description'],
					'compiledlimitation' => $stmtchannel[0]['compiledlimitation'],
					'acl_plugins' => $stmtchannel[0]['acl_plugins'],
					'comments' => $stmtchannel[0]['comments']
				);

			$response = array ('data' => $bannerchannel, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
		} else {

			$response = array ('response' => 'error', 'msg' => 'Requested channelid doesnot found');
		}
		return $this->response->withJson($response);
	}
});

$app->get('/get_all_targeting_channel/[{publisherid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$publisherid = $args['publisherid'];
		$referchannel = "select * from {$table_prefix}channel where affiliateid=:affiliateid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":affiliateid", $publisherid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();

		$bannerchannel = array ();

		if (count($stmtchannel) > 0) {
			foreach ($stmtchannel as $channel) {
				//[$channelid]
				$bannerchannel[] =
					array (
						'agencyid' => $channel['agencyid'],
						'channelid' => $channel['channelid'],
						'affiliateid' => $channel['affiliateid'],
						'name' => $channel['name'],
						'description' => $channel['description'],
						'compiledlimitation' => $channel['compiledlimitation'],
						'acl_plugins' => $channel['acl_plugins'],
						'comments' => $channel['comments']
					);
			}

			$response = array ('data' => $bannerchannel, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
		} else {

			$response = array ('response' => 'error', 'msg' => 'No data found');
		}
		return $this->response->withJson($response);
	}
});

//Publisher Delivery Rule Set

$app->get('/get_publisher_delivery_rule_set/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$bannerid = $args['bannerid'];
		$placementValue = "select * from {$table_prefix}ad_zone_assoc where ad_id=:ad_id";
		$djax_query_placevalue = $this->db->prepare($placementValue);
		$djax_query_placevalue->bindParam(":ad_id", $bannerid);
		$djax_query_placevalue->execute();

		$stmtplacevalue = $djax_query_placevalue->fetchAll();

		foreach ($stmtplacevalue as $zoneids) {
			$zoneid .= $zoneids['zone_id'] . ',';
		}

		$zoneid = trim($zoneid, ',');

		$zoneValue = "select * from {$table_prefix}zones where zoneid in ($zoneid) group by affiliateid";
		$djax_query_zonevalue = $this->db->prepare($zoneValue);
		$djax_query_zonevalue->execute();

		$stmtzonevalue = $djax_query_zonevalue->fetchAll();

		foreach ($stmtzonevalue as $affiliateids) {
			$affiliateid .= $affiliateids['affiliateid'] . ',';
		}

		$affiliateid = trim($affiliateid, ',');

		$referchannel = "select * from {$table_prefix}channel where affiliateid=:affiliateid";
		$djax_query_referchannel = $this->db->prepare($referchannel);
		$djax_query_referchannel->bindParam(":affiliateid", $affiliateid);
		$djax_query_referchannel->execute();

		$stmtchannel = $djax_query_referchannel->fetchAll();

		$bannerchannel = array ();

		if (count($stmtchannel) > 0) {
			foreach ($stmtchannel as $channel) {
				//[$channelid]
				$bannerchannel[] =
					array (
						'channelid' => $channel['channelid'],
						'name' => $channel['name']
					);
			}

			$response = array ('data' => $bannerchannel, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
		} else {

			$response = array ('response' => 'error', 'msg' => 'Requested channelid doesnot found');
		}
		return $this->response->withJson($response);
	}
});

//User Audit API

$app->get('/get_all_user_audit/[{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$agencyid = $args['agencyid'];
		$user_audit = "select au.module,au.create_user_id,au.created_date,au.update_user_id,au.updated_date,au.delete_user_id,au.deleted_date,usr.username from ".$table_prefix."audit_ui au LEFT JOIN ".$table_prefix."users usr ON usr.user_id=au.create_user_id or usr.user_id=au.update_user_id or usr.user_id=au.delete_user_id LEFT JOIN ".$table_prefix."accounts acc ON usr.default_account_id=acc.account_id LEFT JOIN ".$table_prefix."agency ag ON usr.default_account_id=ag.account_id where ag.agencyid=:agencyid";
		$djax_query_user_audit = $this->db->prepare($user_audit);
		$djax_query_user_audit->bindParam(":agencyid", $agencyid);
		$djax_query_user_audit->execute();

		$stmtuseraudit = $djax_query_user_audit->fetchAll();
		//print_r($stmtuseraudit);exit('ok');

		$bannerchannel = array ();

		if (count($stmtuseraudit) > 0) {
			foreach ($stmtuseraudit as $useraudit) {
				//[$channelid]
				$bannerchannel[] =
					array (
						'module' => $useraudit['module'],
						'create_user' => $useraudit['username'],
						'created_date' => $useraudit['created_date'],
						'update_user' => $useraudit['username'],
						'updated_date' => $useraudit['updated_date'],
						'delete_user' => $useraudit['username'],
						'deleted_date' => $useraudit['deleted_date']
					);
			}

			$response = array ('data' => $bannerchannel, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
		} else {

			$response = array ('response' => 'error', 'msg' => 'No data found');
		}
		return $this->response->withJson($response);
	}
});

/*******************************Invocation Tag generation**********************************************************/



// Invocation Tag generation

//Asynchronous tag generation


/*
 * Asynchronous tag
 * 
 * Input Parameters:
 * --------------- 
 * thirdparty 
 * showpage
 * show
 * source
 * target 
 */

$app->post('/invoke_asy/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$zoneid = $args['zoneid'];
		$sqlzoneassoc = "select ad_id from rv_ad_zone_assoc where zone_id=$zoneid";
		$sthzoneassoc = $this->db->prepare($sqlzoneassoc);
		//$sthzoneassoc->bindParam("zone_id", $args['zoneid']);
		$sthzoneassoc->execute();
		$zoneassoc = $sthzoneassoc->fetchAll();

		$bannerid = '';
		foreach ($zoneassoc as $zoneassocs) {
			$bannerid .= $zoneassocs['ad_id'] . ',';
		}
		$bannerids = trim($bannerid, ',');

		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid LEFT JOIN " . $table_prefix . "banners ba ON ca.campaignid=ba.campaignid WHERE zo.zoneid=:zoneid And ba.bannerid in ($bannerids)  Group by ca.campaignid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$showbanner = (isset ($input['showbanner'])) ? $input['showbanner'] : '';
		$showcampaign = (isset ($input['showcampaign'])) ? $input['showcampaign'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		//target validation

		if ($target == 1) {
			$b = "_blank";
		} else if ($target == 0) {
			$b = "_top";
		} else if ($target != 0 || $target != 1) {
			$b = "";
		}

		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
		} else {
			$tparty = "";
		}

		$source_val = ($source != '') ? ' data-revive-source="' . $source . '"' : '';
		$target_val = ($target != '') ? ' data-revive-target="' . $b . '"' : '';
		$banner_val = ($showbanner == 1) ? ' data-revive-block="1"' : '';
		$campaign_val = ($showcampaign == 1) ? ' data-revive-blockcampaign="1"' : '';


		//source validation
		if ($source == $source) {

			$source = $source;
		} else {
			$source = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		$headertitle = "";
		$i = 1;
		foreach ($zoneav as $zones1) {
			$headertitle .= $i . ' : ' . $zones1['clientname'] . ' - ' . $zones1['campaignname'] . ',';
			$i++;
		}

		//~ $full_url=substr($full_url, 0, -9).'delivery'; <!--/* CED.cy - Adserver Asynchronous Js Tag - Generated with CED.cy Adserver v5.2.0*/-->
		$d_c = '"';

		$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}");

		$asytag = '<!--' . $headertitle . ' - ' . $zoneav[0]['publisher'] . ' - ' . $zoneav[0]['name'] . ' - ' . $zoneav[0]['width'] . ' x ' . $zoneav[0]['height'] . '-->

<ins data-revive-zoneid="' . $args['zoneid'] . '"' . $source_val . $target_val . $banner_val . $campaign_val . ' data-revive-id="' . $mi . '"></ins><script async src="//' . $full_url . '/asyncjs.php"></script>';

		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'async' => $asytag

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});


//Iframe tag generation


/*
 * Iframe tag
 * 
 * Input Parameters:
 * --------------- 
 * target 
 * thirdparty
 * source
 * refresh
 * transparency 
 * gtrack 
 * netscape 
 * cache 
 * comments 
 */


$app->post('/invoke_iframe/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$zoneid = $args['zoneid'];
		$sqlzoneassoc = "select ad_id from rv_ad_zone_assoc where zone_id=$zoneid";
		$sthzoneassoc = $this->db->prepare($sqlzoneassoc);
		//$sthzoneassoc->bindParam("zone_id", $args['zoneid']);
		$sthzoneassoc->execute();
		$zoneassoc = $sthzoneassoc->fetchAll();

		$bannerid = '';
		foreach ($zoneassoc as $zoneassocs) {
			$bannerid .= $zoneassocs['ad_id'] . ',';
		}
		$bannerids = trim($bannerid, ',');

		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid LEFT JOIN " . $table_prefix . "banners ba ON ca.campaignid=ba.campaignid WHERE zo.zoneid=:zoneid And ba.bannerid in ($bannerids)  Group by ca.campaignid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$refresh = (isset ($input['refresh'])) ? $input['refresh'] : '';
		$trans = (isset ($input['transparency'])) ? $input['transparency'] : '';
		$netscape = (isset ($input['netscape'])) ? $input['netscape'] : '';
		$gtrack = (isset ($input['gtrack'])) ? $input['gtrack'] : '';
		$cache = (isset ($input['cache'])) ? $input['cache'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$https_protocol = (isset ($input['https_protocol'])) ? $input['https_protocol'] : '';
		// $ff = rand();
		$ff = 'a' . substr(md5(uniqid('', 1)), 0, 7);
		$fb = 'a' . substr(md5(uniqid('', 1)), 0, 7);
		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		//target validtaion
		if ($target == 1) {
			$target = "_blank";
		} elseif ($target == 0) {
			$target = "_top";
		} else {
			$target = "";
		}
		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
			$cb = "%n";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
			$cb = "%%RAND%%";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
			$cb = "(random)";
		} else {
			$tparty = "";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		}

		//source validation
		if ($source == $source) {

			$source = $source;
		} else {
			$source = "";
		}
		//refresh validation

		if ($refresh == $refresh) {

			$refresh = $refresh;
		} else {
			$refresh = "";
		}
		if ($trans == 1) {
			$trans = "true";
		} else {
			$trans = "false";
		}

		if ($https_protocol) {
			$protocal = 'https';
		} else {
			$protocal = 'http';
		}

		// comments validation
		if ($cmnd == 1) {
			$cmnd = "<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
		  * a generated random number (or timestamp).
		  *
		  * If iFrames are not supported by the viewer's browser, then this
		  * tag only shows image banners. There is no width or height in these
		  * banners, so if you want these tags to allocate space for the ad
		  * before it shows, you will need to add this information to the <img>
		  * tag.
		  */-->";
		} else {
			$cmnd = "";
		}

		$headertitle = "";
		$i = 1;
		foreach ($zoneav as $zones1) {
			$headertitle .= $i . ' : ' . $zones1['clientname'] . ' - ' . $zones1['campaignname'] . ',';
			$i++;
		}


		$full_url = $this->get('settings')['path']['delivery'];
		//~ $full_url=substr($full_url, 0, -5).'delivery'; "&amp;n=" . $ff . <!-- CED.cy Adserver iFrame Tag - Generated with CED.cy Adserver v5.2.0 -->
		$d_c = '"';

		$iFrametag = "<!--" . $headertitle . " - " . $zoneav[0]['publisher'] . ' - ' . $zoneav[0]['name'] . " - " . $zoneav[0]['width'] . " x " . $zoneav[0]['height'] . "-->
		 " . $cmnd . "
			<iframe id='" . $ff . "' name='" . $ff . "' src='" . $protocal . "://" . $full_url . "/afr.php?zoneid=" . $args['zoneid'] . "&amp;source=" . $source . "&amp;target=" . $target . "&amp;cb=" . $cb . "' frameborder='0' scrolling='no' width='" . $zoneav[0]['width'] . "' height='" . $zoneav[0]['height'] . "' allowtransparency='" . $trans . "'>
			<a href='" . $protocal . "://" . $full_url . "/ck.php?n=" . $fb . "' target='" . $target . "'></a>
			<img src='" . $protocal . "://" . $full_url . "/avw.php?n=" . $fb . "&amp;zoneid=" . $args['zoneid'] . "&amp;source=" . $source . "&refresh=" . $refresh . "&amp;cb=" . $cb . "' border='0' alt='' /></a>
			</iframe>";
		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'iframe' => $iFrametag

		);
		//return stripcslashes($this->response->withJson($res));
		return $this->response->withJson($res);

		return $response;
	}
});



//javascript Invocation tag

/*
 * javascript tag
 * 
 * Input Parameters:
 * --------------- 
 * thirdparty 
 * samepage
 * show
 * target
 * source 
 * showtext 
 * setchar 
 * comments 
 */

$app->post('/invoke_javascript/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$zoneid = $args['zoneid'];
		$sqlzoneassoc = "select ad_id from rv_ad_zone_assoc where zone_id=$zoneid";
		$sthzoneassoc = $this->db->prepare($sqlzoneassoc);
		//$sthzoneassoc->bindParam("zone_id", $args['zoneid']);
		$sthzoneassoc->execute();
		$zoneassoc = $sthzoneassoc->fetchAll();

		$bannerid = '';
		foreach ($zoneassoc as $zoneassocs) {
			$bannerid .= $zoneassocs['ad_id'] . ',';
		}
		$bannerids = trim($bannerid, ',');

		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid LEFT JOIN " . $table_prefix . "banners ba ON ca.campaignid=ba.campaignid WHERE zo.zoneid=:zoneid And ba.bannerid in ($bannerids)  Group by ca.campaignid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$samepage = (isset ($input['samepage'])) ? $input['samepage'] : '';
		$show = (isset ($input['show'])) ? $input['show'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$showtext = (isset ($input['showtext'])) ? $input['showtext'] : '';
		$setchar = (isset ($input['setchar'])) ? $input['setchar'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$https_protocol = (isset ($input['https_protocol'])) ? $input['https_protocol'] : '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		// target validation
		if ($target == "") {
			$target = '';
			$target1 = '&amp;target="_blank"';
		} else if ($target == 0) {
			$target = '&amp;target="_top"';
			$target1 = '&amp;target="_top"';
		} else if ($target == 1) {
			$target = '&amp;target="_blank"';
			$target1 = '&amp;target="_blank"';
		}
		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {
			$tparty = "%c";
			$cb = "%n";
		} else if ($tparty == 2) {
			$tparty = "%%c%%?";
			$cb = "%%RAND%%";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
			$cb = "(random)";
		} else {
			$tparty = "";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		//~ $full_url=substr($full_url, 0, -5).'delivery';
		$d_c = '"';

		if ($source) {
			$source = '&amp;source="' . $source . '"';
		} else {
			$source = '';
		}

		if ($showtext) {
			$showtext = '&amp;withtext=1';
		} else {
			$showtext = '';
		}

		if ($samepage) {
			$samepage = '&amp;block=1';
		} else {
			$samepage = '';
		}

		if ($show) {
			$show = '&amp;blockcampaign=1';
		} else {
			$show = '';
		}

		//Character set validation <!--/* CED.cy - Adserver Javascript Tag - Generated with CED.cy Adserver v5.2.0*/-->

		/* if ($setchar == 0) {
																																																				  $setchar = "";
																																																			  } else if ($setchar == 1) {
																																																				  $setchar = "ISO-8859-6";
																																																			  } else if ($setchar == 2) {
																																																				  $setchar = "Windows-1256";
																																																			  } else if ($setchar == 3) {
																																																				  $setchar = "ISO-8859-4";
																																																			  } else if ($setchar == 4) {
																																																				  $setchar = "Windows-1257";
																																																			  } else if ($setchar == 5) {
																																																				  $setchar = "ISO-8859-2";
																																																			  } else if ($setchar == 6) {
																																																				  $setchar = "Windows-1250";
																																																			  } else if ($setchar == 7) {
																																																				  $setchar = "GB18030";
																																																			  } else if ($setchar == 8) {
																																																				  $setchar = "GB2312";
																																																			  } else if ($setchar == 9) {
																																																				  $setchar = "HZ";
																																																			  } else if ($setchar == 10) {
																																																				  $setchar = "Big5";
																																																			  } else if ($setchar == 11) {
																																																				  $setchar = "ISO-8859-5";
																																																			  } else if ($setchar == 12) {
																																																				  $setchar = "KOI8-R";
																																																			  } else if ($setchar == 13) {
																																																				  $setchar = "Windows-1251";
																																																			  } else if ($setchar == 14) {
																																																				  $setchar = "ISO-8859-13";
																																																			  } else if ($setchar == 15) {
																																																				  $setchar = "ISO-8859-7";
																																																			  } else if ($setchar == 16) {
																																																				  $setchar = "Windows-1253";
																																																			  } else if ($setchar == 17) {
																																																				  $setchar = "ISO-8859-8-l";
																																																			  } else if ($setchar == 18) {
																																																				  $setchar = "ISO-8859-8";
																																																			  } else if ($setchar == 19) {
																																																				  $setchar = "Windows-1255";
																																																			  } else if ($setchar == 20) {
																																																				  $setchar = "EUC-JP";
																																																			  } else if ($setchar == 21) {
																																																				  $setchar = "Shift-JIS";
																																																			  } else if ($setchar == 22) {
																																																				  $setchar = "EUC-KR";
																																																			  } else if ($setchar == 23) {
																																																				  $setchar = "ISO-8859-15";
																																																			  } else if ($setchar == 24) {
																																																				  $setchar = "TIS-620";
																																																			  } else if ($setchar == 25) {
																																																				  $setchar = "ISO-8859-9";
																																																			  } else if ($setchar == 26) {
																																																				  $setchar = "Windows-1254";
																																																			  } else if ($setchar == 27) {
																																																				  $setchar = "UTF-8";
																																																			  } else if ($setchar == 28) {
																																																				  $setchar = "Windows-1258";
																																																			  } else if ($setchar == 29) {
																																																				  $setchar = "ISO-8859-1";
																																																			  } else if ($setchar == 30) {
																																																				  $setchar = "Windows-1252";
																																																			  } */
		if ($cmnd == 1) {
			$cmnd = "<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
			  * a generated random number (or timestamp).
			  *
			  * This noscript section of this tag only shows image banners. There
			  * is no width or height in these banners, so if you want these tags to
			  * allocate space for the ad before it shows, you will need to add this
			  * information to the <img> tag.
			  *
			  * If you do not want to deal with the intricities of the noscript
			  * section, delete the tag (from <noscript>... to </noscript>). On
			  * average, the noscript tag is called from less than 1% of internet
			  * users.
			  */-->";
		} else {
			$cmnd = "";
		}

		if ($https_protocol == 1) {
			$protocal = 'https';
		} else {
			$protocal = 'http';
		}

		if ($setchar) {
			$setchar = '&amp;charset=' . $setchar;
		} else {
			$setchar = '';
		}

		$a = '"text/javascript"';
		$x = '"' . $setchar . '"';
		$y = '"&amp;loc="';
		$z = '"';
		$ff = rand();

		$headertitle = "";
		$i = 1;
		foreach ($zoneav as $zones1) {
			$headertitle .= $i . ' : ' . $zones1['clientname'] . ' - ' . $zones1['campaignname'] . ',';
			$i++;
		}

		$javascripttag = " <!--" . $headertitle . " - " . $zoneav[0]['publisher'] . ' - ' . $zoneav[0]['name'] . " - " . $zoneav[0]['width'] . " x " . $zoneav[0]['height'] . "-->
			" . $cmnd . "
			<script type='text/javascript'>
			var m3_u = (location.protocol=='https:'?'https://" . $full_url . "/ajs.php':'http://" . $full_url . "/ajs.php');
			var m3_r = Math.floor(Math.random()*99999999999);
			if (!document.MAX_used) document.MAX_used = ',';
			document.write ('<scr'+'ipt type=" . $a . " src=" . $z . "'+m3_u);
			document.write ('?zoneid=" . $args['zoneid'] . "" . $source . "" . $target . "" . $setchar . "" . $showtext . "" . $samepage . "" . $show . "');
			document.write ('&amp;cb=' + m3_r);
			if (document.MAX_used != ',') document.write ('&amp;exclude=' + document.MAX_used);
			document.write (" . $x . ");
			document.write (" . $y . " + escape(window.location));
			if (document.referrer) document.write ('&amp;referer=' + escape(document.referrer));
			if (document.context) document.write ('&context=' + escape(document.context));
			document.write ('" . $z . "><\/scr'+'ipt>');
			</script><noscript><a href='" . $protocal . "://" . $full_url . "/ck.php?n=" . $ff . "&amp;cb=" . $cb . "' '" . $target1 . "'>
			<img src=" . $z . "" . $protocal . "://" . $full_url . "/avw.php?zoneid=" . $args['zoneid'] . "" . $source . "" . $setchar . "&amp;cb=" . $cb . "&amp;n=" . $ff . "&amp;ct0=" . $tparty . "" . $z . " border=" . $z . "0" . $z . " alt=" . $z . "" . $z . " /></a></noscript>
			";
		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'javascript' =>
				$javascripttag

		);
		//return stripcslashes($this->response->withJson($res));
		return $this->response->withJson($res);

		return $response;
	}
});

$app->post('/invoke_async_custom/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$zoneid = $args['zoneid'];
		$sqlzoneassoc = "select ad_id from rv_ad_zone_assoc where zone_id=$zoneid";
		$sthzoneassoc = $this->db->prepare($sqlzoneassoc);
		//$sthzoneassoc->bindParam("zone_id", $args['zoneid']);
		$sthzoneassoc->execute();
		$zoneassoc = $sthzoneassoc->fetchAll();

		$bannerid = '';
		foreach ($zoneassoc as $zoneassocs) {
			$bannerid .= $zoneassocs['ad_id'] . ',';
		}
		$bannerids = trim($bannerid, ',');

		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid LEFT JOIN " . $table_prefix . "banners ba ON ca.campaignid=ba.campaignid WHERE zo.zoneid=:zoneid And ba.bannerid in ($bannerids)  Group by ca.campaignid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		//target validation

		if ($target == 1) {
			$b = "_blank";
		} else if ($target == 0) {
			$b = "_top";
		} else if ($target != 0 || $target != 1) {
			$b = "";
		}
		$target_val = ($target != '') ? ' competitiveedge-target="' . $b . '" ' : '';

		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
		} else {
			$tparty = "";
		}

		//source validation
		if ($source == $source) {
			$source = $source;
		} else {
			$source = "";
			$source_val = '';
		}
		$source_val = ($source != '') ? ' competitiveedge-source="' . $source . '"' : '';

		$full_url = $this->get('settings')['path']['package_path'];

		//~ $full_url=substr($full_url, 0, -9).'delivery'; <!--/* CED.cy - Adserver Asynchronous Custom Tag - Generated with CED.cy Adserver v5.2.0*/-->
		$d_c = '"';

		$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}");

		$headertitle = "";
		$i = 1;
		foreach ($zoneav as $zones1) {
			$headertitle .= $i . ' : ' . $zones1['clientname'] . ' - ' . $zones1['campaignname'] . ',';
			$i++;
		}

		$async_custom = '<!--' . $headertitle . ' - ' . $zoneav[0]['publisher'] . ' - ' . $zoneav[0]['name'] . ' - ' . $zoneav[0]['width'] . ' x ' . $zoneav[0]['height'] . '-->
		<ins competitiveedge-z="' . $args['zoneid'] . '"' . $source_val . $target_val . ' competitiveedge-id="' . $mi . '"></ins>
<script async src="https://' . $full_url . '/asjs.php"></script>';

		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'async_custom' => $async_custom

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});

$app->post('/invoke_jstag/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$zoneid = $args['zoneid'];
		$sqlzoneassoc = "select ad_id from rv_ad_zone_assoc where zone_id=$zoneid";
		$sthzoneassoc = $this->db->prepare($sqlzoneassoc);
		//$sthzoneassoc->bindParam("zone_id", $args['zoneid']);
		$sthzoneassoc->execute();
		$zoneassoc = $sthzoneassoc->fetchAll();

		$bannerid = '';
		foreach ($zoneassoc as $zoneassocs) {
			$bannerid .= $zoneassocs['ad_id'] . ',';
		}
		$bannerids = trim($bannerid, ',');

		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid LEFT JOIN " . $table_prefix . "banners ba ON ca.campaignid=ba.campaignid WHERE zo.zoneid=:zoneid And ba.bannerid in ($bannerids)  Group by ca.campaignid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}


		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
		} else {
			$tparty = "";
		}

		//source validation <!--/* CED.cy - Adserver Js Tag - Generated with CED.cy Adserver v5.2.0*/-->
		if ($source == $source) {
			$source = $source;
		} else {
			$source = "";
		}

		$full_url = $this->get('settings')['path']['package_path'];

		$ff = rand();
		$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}");

		$headertitle = "";
		$i = 1;
		foreach ($zoneav as $zones1) {
			$headertitle .= $i . ' : ' . $zones1['clientname'] . ' - ' . $zones1['campaignname'] . ',';
			$i++;
		}

		$jstag = "<!--" . $headertitle . " - " . $zoneav[0]['publisher'] . ' - ' . $zoneav[0]['name'] . " - " . $zoneav[0]['width'] . " x " . $zoneav[0]['height'] . "-->
		<div id='js099234'>
<script type='text/javascript'><!--//<![CDATA[
var scrsrc=document.createElement('script');
scrsrc.setAttribute('src'," . '"https://' . $full_url . '/js.php?z=' . $args['zoneid'] . '&amp;source=' . $source . '&cb=' . $ff . '");' . "
document.getElementsByTagName('head')[0].appendChild(scrsrc);
scrsrc.setAttribute('type', 'text/javascript');
//]]>--></script></div>";


		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'jstag' => $jstag

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});

$app->post('/invoke_local_mode_tag/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$zoneid = $args['zoneid'];
		$sqlzoneassoc = "select ad_id from rv_ad_zone_assoc where zone_id=$zoneid";
		$sthzoneassoc = $this->db->prepare($sqlzoneassoc);
		//$sthzoneassoc->bindParam("zone_id", $args['zoneid']);
		$sthzoneassoc->execute();
		$zoneassoc = $sthzoneassoc->fetchAll();

		$bannerid = '';
		foreach ($zoneassoc as $zoneassocs) {
			$bannerid .= $zoneassocs['ad_id'] . ',';
		}
		$bannerids = trim($bannerid, ',');

		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid LEFT JOIN " . $table_prefix . "banners ba ON ca.campaignid=ba.campaignid WHERE zo.zoneid=:zoneid And ba.bannerid in ($bannerids)  Group by ca.campaignid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$setchar = (isset ($input['setchar'])) ? $input['setchar'] : '';
		$showtext = (isset ($input['showtext'])) ? $input['showtext'] : '';
		$showbanner = (isset ($input['showbanner'])) ? $input['showbanner'] : '';
		$showcampaign = (isset ($input['showcampaign'])) ? $input['showcampaign'] : '';
		$template = (isset ($input['template'])) ? $input['template'] : '';
		$cache = (isset ($input['cache'])) ? $input['cache'] : '';
		$comments = (isset ($input['comments'])) ? $input['comments'] : '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}


		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
		} else {
			$tparty = "";
		}

		//target
		if ($target == 1) {
			$b = "_blank";
		} else if ($target == 0) {
			$b = "_top";
		} else if ($target != 0 || $target != 1) {
			$b = "";
		}
		$target_val = ($target != '') ? $b : '';
		//source validation CED.cy - Adserver Local Mode Tag - Generated with CED.cy Adserver v5.2.0
		if ($source == $source) {
			$source = $source;
		} else {
			$source = "";
		}
		$banner_val = ($showbanner == 1) ? '$phpAds_context[] = array(' . "'!=' => 'bannerid:'." . '$phpAds_raw[' . "'bannerid']);" : '';
		$campaign_val = ($showcampaign == 1) ? '$phpAds_context[] = array(' . "'!=' => 'campaignid:'." . '$phpAds_raw[' . "'campaignid']);" : '';
		$template_val = ($template == 1) ? '// Assign the $phpAds_raw[' . "'html'] variable to your template
// echo." . ' $phpAds_raw[' . "'html'];'" : "echo " . '$phpAds_raw[' . "'html'];";
		$comment_val = ($comments == 1) ? '// The MAX_PATH below should point to the base of your Revive Adserver installation' : '';
		$comment_val1 = ($comments == 1) ? '// function view_local($what, $zoneid=0, $campaignid=0, $bannerid=0, $target="", $source="", $withtext="", $context="", $charset="")' : '';

		$full_url = $this->get('settings')['path']['domain_path'];

		$ff = rand();
		$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}");

		$headertitle = "";
		$i = 1;
		foreach ($zoneav as $zones1) {
			$headertitle .= $i . ' : ' . $zones1['clientname'] . ' - ' . $zones1['campaignname'] . ',';
			$i++;
		}

		$local = "<?php
" . '//' . $headertitle . " - " . $zoneav[0]['publisher'] . ' - ' . $zoneav[0]['name'] . " - " . $zoneav[0]['width'] . " x " . $zoneav[0]['height'] . "
" . $comment_val . "
define('MAX_PATH', '/var/www/html/competitive_rev');
if (@include_once(MAX_PATH . '/www/delivery/alocal.php')) {
if (!isset(" . '$phpAds_context' . ")) {
" . '$phpAds_context = array();
}
' . $comment_val1 . '
$phpAds_raw = view_local' . "('', " . $args['zoneid'] . ", 0, 0, '" . $target_val . "', '" . $source . "', '" . $showtext . "', " . '$phpAds_context' . ", '" . $setchar . "');
" . $banner_val . $campaign_val . "
}
" . $template_val . "
?>";
		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'local' => $local

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});

//Website Iframe Tag Generation


/*
 * Website Iframe tag
 * 
 * Input Parameters:
 * --------------- 
 * target 
 * thirdparty
 * source
 * refresh
 * transparency 
 * gtrack 
 * netscape 
 * cache 
 * comments 
 */


$app->post('/website_invoke_iframe/[{affiliateid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,pu.name publisher,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "publishers pu ON pu.id=af.publisher_id LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid WHERE af.affiliateid=:affiliateid Group by zo.zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("affiliateid", $args['affiliateid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$refresh = (isset ($input['refresh'])) ? $input['refresh'] : '';
		$trans = (isset ($input['transparency'])) ? $input['transparency'] : '';
		$netscape = (isset ($input['netscape'])) ? $input['netscape'] : '';
		$gtrack = (isset ($input['gtrack'])) ? $input['gtrack'] : '';
		$cache = (isset ($input['cache'])) ? $input['cache'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$https_protocol = (isset ($input['https_protocol'])) ? $input['https_protocol'] : '';
		// $ff = rand();

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		//target validtaion
		if ($target == 1) {
			$target = "_blank";
		} elseif ($target == 0) {
			$target = "_top";
		} else {
			$target = "";
		}
		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
			$cb = "%n";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
			$cb = "%%RAND%%";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
			$cb = "(random)";
		} else {
			$tparty = "";
			$cb = "INSERT_ENCODED_CLICKURL_HERE";
		}

		//source validation
		if ($source == $source) {

			$source = $source;
		} else {
			$source = "";
		}
		//refresh validation

		if ($refresh == $refresh) {

			$refresh = $refresh;
		} else {
			$refresh = "";
		}
		if ($trans == 1) {
			$trans = "true";
		} else {
			$trans = "false";
		}

		if ($https_protocol) {
			$protocal = 'https';
		} else {
			$protocal = 'http';
		}

		// comments validation
		if ($cmnd == 1) {
			$cmnd = "<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
		  * a generated random number (or timestamp).
		  *
		  * If iFrames are not supported by the viewer's browser, then this
		  * tag only shows image banners. There is no width or height in these
		  * banners, so if you want these tags to allocate space for the ad
		  * before it shows, you will need to add this information to the <img>
		  * tag.
		  */-->";
		} else {
			$cmnd = "";
		}



		$full_url = $this->get('settings')['path']['delivery'];
		//~ $full_url=substr($full_url, 0, -5).'delivery'; "&amp;n=" . $ff . <!-- CED.cy Adserver iFrame Tag - Generated with Revive Adserver v5.2.0 -->
		$d_c = '"';
		$i = 1;
		foreach ($zoneav as $zonedetail) {

			$ff = 'a' . $i . substr(md5(uniqid('', 1)), 0, 7);
			$fb = 'a' . $i . substr(md5(uniqid('', 1)), 0, 7);

			$iFrametag[] = "<!--" . $zonedetail['clientname'] . " - " . $zonedetail['campaignname'] . " - " . $zoneav[0]['publisher'] . ' - ' . $zonedetail['name'] . " - " . $zonedetail['width'] . " x " . $zonedetail['height'] . "-->
		    " . $cmnd . "
			<iframe id='" . $ff . "' name='" . $ff . "' src='" . $protocal . "://" . $full_url . "/afr.php?zoneid=" . $zonedetail['zoneid'] . "&amp;source=" . $source . "&amp;target=" . $target . "&amp;cb=" . $cb . "' frameborder='0' scrolling='no' width='" . $zonedetail['width'] . "' height='" . $zonedetail['height'] . "' allowtransparency='" . $trans . "'>
			<a href='" . $protocal . "://" . $full_url . "/ck.php?n=" . $fb . "' target='" . $target . "'></a>
			<img src='" . $protocal . "://" . $full_url . "/avw.php?n=" . $fb . "&amp;zoneid=" . $zonedetail['zoneid'] . "&amp;source=" . $source . "&refresh=" . $refresh . "&amp;cb=" . $cb . "' border='0' alt='' /></a>
			</iframe>\n";
			$i++;
		}
		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'iframe' => $iFrametag

		);
		//return stripcslashes($this->response->withJson($res));
		return $this->response->withJson($res);

		return $response;
	}
});

$app->post('/website_invoke_async_custom/[{affiliateid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$sql = "select zo.zoneid,af.affiliateid,cl.clientid,af.name,pu.name publisher,cl.clientname,ca.campaignname,zo.width,zo.height from " . $table_prefix . "zones zo LEFT JOIN " . $table_prefix . "affiliates af ON af.affiliateid=zo.affiliateid LEFT JOIN " . $table_prefix . "publishers pu ON pu.id=af.publisher_id LEFT JOIN " . $table_prefix . "agency ag ON af.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "clients cl ON cl.agencyid=ag.agencyid LEFT JOIN " . $table_prefix . "campaigns ca ON ca.clientid=cl.clientid WHERE af.affiliateid=:affiliateid Group by zo.zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("affiliateid", $args['affiliateid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		//target validation

		if ($target == 1) {
			$b = "_blank";
		} else if ($target == 0) {
			$b = "_top";
		} else if ($target != 0 || $target != 1) {
			$b = "";
		}
		$target_val = ($target != '') ? ' competitiveedge-target="' . $b . '" ' : '';

		//third party validation
		if ($tparty == 0) {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
		} else if ($tparty == 1) {

			$tparty = "%c";
		} else if ($tparty == 2) {

			$tparty = "%%c%%?";
		} else if ($tparty == 3) {

			$tparty = "{clickurl_enc}";
		} else {
			$tparty = "";
		}

		//source validation
		if ($source == $source) {
			$source = $source;
		} else {
			$source = "";
			$source_val = '';
		}
		$i = 1;
		foreach ($zoneav as $zonedetail) {

			$source_val = ($source != '') ? ' competitiveedge-source="' . $source . '"' : '';

			$full_url = $this->get('settings')['path']['package_path'];

			//~ $full_url=substr($full_url, 0, -9).'delivery';
			$d_c = '"';

			$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}" . $i);

			$async_custom[] = '<!--' . $zonedetail['clientname'] . ' - ' . $zonedetail['campaignname'] . ' - ' . $zoneav[0]['publisher'] . ' - ' . $zonedetail['name'] . ' - ' . $zonedetail['width'] . ' x ' . $zonedetail['height'] . '-->
		<ins competitiveedge-z="' . $zonedetail['zoneid'] . '"' . $source_val . $target_val . ' competitiveedge-id="' . $mi . '"></ins>
        <script async src="https://' . $full_url . '/asjs.php"></script>
		';
			$i++;
		}

		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'async_custom' => $async_custom

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});


/*
 * Website Invocation tag
 * 
 * Input Parameters:
 * --------------- 
 * source
 * blockcampaign
 * showtext
 * target
 * comments 
 */

$app->post('/website_invoke/[{affiliateid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$sql = "select zoneid,zonename,width,height from " . $table_prefix . "zones WHERE affiliateid=:affiliateid";
		$sth = $this->db->prepare($sql);
		$affiliateid = $args['affiliateid'];
		$sth->bindParam("affiliateid", $args['affiliateid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$input = $request->getParsedBody();
		$block = (isset ($input['block'])) ? $input['block'] : '';
		$blockcampaign = (isset ($input['blockcampaign'])) ? $input['blockcampaign'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$withtext = (isset ($input['withtext'])) ? $input['withtext'] : '';
		$charset = (isset ($input['charset'])) ? $input['charset'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$noscript = (isset ($input['noscript'])) ? $input['noscript'] : '';
		$https_protocol = (isset ($input['https_protocol'])) ? $input['https_protocol'] : '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		$source1 = "<script type='text/javascript'><!--// <![CDATA[ var OA_source = '" . $source . "'; // ]]> --></script>";

		if ($block) {
			$block = "&amp;block=1";
		} else {
			$block = "";
		}

		if ($blockcampaign) {
			$blockcampaign = "&amp;blockcampaign=1";
		} else {
			$blockcampaign = "";
		}
		//source validation
		if ($source) {

			$source = $source1;
		} else {
			$source = "";
		}

		if ($withtext) {

			$withtext = "&amp;withtext=1";
		} else {
			$withtext = "";
		}

		if ($charset) {

			$charset = "&amp;charset=" . $charset;
		} else {
			$charset = "";
		}

		if ($https_protocol) {
			$protocal = 'https';
		} else {
			$protocal = 'http';
		}

		if ($target) {

			$target = "&amp;target=" . $target;
		} else {
			$target = "";
		}

		/*&amp;block=1&amp;blockcampaign=1&amp;withtext=1*/

		$full_url = $this->get('settings')['path']['delivery'] . '/';

		$headerscript = "<!-- Generated by Revive Adserver v5.2.0 -->
		/* Header Script */" . $source . "<script type='text/javascript' src='" . $protocal . "://" . $full_url . "spcjs.php?id=" . $affiliateid . $block . $blockcampaign . $target . $withtext . $charset . "'></script>";

		$i = 1;

		foreach ($zoneav as $zonedetail) {

			$ff . $i = 'a' . substr(md5(uniqid('', 1)), 0, 7);

			$zoneid = $zonedetail['zoneid'];
			$zonename = $zonedetail['zonename'];

			// comments validation
			if ($cmnd == 1) {
				$cmnd = "/* Ad Script [id" . $zonedetail['zoneid'] . "] " . $zonedetail['zonename'] . " [" . $zonedetail['width'] . " x " . $zonedetail['height'] . "] */";
			} else {
				$cmnd = "";
			}

			// noscript validation
			if ($noscript == 1) {
				$noscripttag = "<noscript><a target='_blank' href='" . $protocal . "://" . $full_url . "ck.php?n=" . $ff . $i . "'><img border='0' alt='' src='" . $protocal . "://" . $full_url . "avw.php?zoneid=" . $zonedetail['zoneid'] . "&amp;n=" . $ff . $i . "' /></a></noscript>";
			} else {
				$noscripttag = "";
			}


			//~ $full_url=substr($full_url, 0, -5).'delivery'; "&amp;n=" . $ff .
			$d_c = '"';

			$website_invocation_tags[] = "
			
		/* Ad Script [id" . $zonedetail['zoneid'] . "] " . $zonedetail['zonename'] . " [" . $zonedetail['width'] . " x " . $zonedetail['height'] . "]*/
		<script type='text/javascript'><!--// <![CDATA[
        OA_show(" . $zonedetail['zoneid'] . ");
        // ]]> --></script>" . $noscripttag . "\n";
			$i++;
		}

		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'headerscript' => $headerscript,
			'website_invocation' => $website_invocation_tags

		);
		//return stripcslashes($this->response->withJson($res));
		return $this->response->withJson($res);

		return $response;
	}
});



//Interstitial Floating DHTML tag generation


/*
 * Interstitial Floating DHTML tag
 * 
 * Input Parameters:
 * --------------- 
 * thirdparty 
 * showpage
 * show
 * source
 * layerstyle 
 * align 
 * padding 
 * closetext 
 * charset 
 * collapsetime 
 */

$app->post('/invoke_interstitial/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$samepage = (isset ($input['showpage'])) ? $input['showpage'] : '';
		$show = (isset ($input['show'])) ? $input['show'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$layerstyle = (isset ($input['layerstyle'])) ? $input['layerstyle'] : '';
		$align = (isset ($input['align'])) ? $input['align'] : '';
		$padding = (isset ($input['padding'])) ? $input['padding'] : '';
		$closetext = (isset ($input['closetext'])) ? $input['closetext'] : '';
		$charset = (isset ($input['charset'])) ? $input['charset'] : '';
		$collapsetime = (isset ($input['collapsetime'])) ? $input['collapsetime'] : '';
		$hide = (isset ($input['hide'])) ? $input['hide'] : '';
		$trail = (isset ($input['trail'])) ? $input['trail'] : '';
		$offsetx = (isset ($input['offsetx'])) ? $input['offsetx'] : '';
		$offsety = (isset ($input['offsety'])) ? $input['offsety'] : '';
		$stickyness = (isset ($input['stickyness'])) ? $input['stickyness'] : '';
		$transparancy = (isset ($input['transparancy'])) ? $input['transparancy'] : '';
		$delay = (isset ($input['delay'])) ? $input['delay'] : '';
		$ltr = (isset ($input['ltr'])) ? $input['ltr'] : '';
		$loop = (isset ($input['loop'])) ? $input['loop'] : '';
		$speed = (isset ($input['speed'])) ? $input['speed'] : '';
		$pause = (isset ($input['pause'])) ? $input['pause'] : '';
		$shiftv = (isset ($input['shiftv'])) ? $input['shiftv'] : '';
		$transparent = (isset ($input['transparent'])) ? $input['transparent'] : '';
		$backcolor = (isset ($input['backcolor'])) ? $input['backcolor'] : '';
		$limited = (isset ($input['limited'])) ? $input['limited'] : '';
		$lmargin = (isset ($input['lmargin'])) ? $input['lmargin'] : '';
		$rmargin = (isset ($input['rmargin'])) ? $input['rmargin'] : '';
		$valign = (isset ($input['valign'])) ? $input['valign'] : '';
		$shifth = (isset ($input['shifth'])) ? $input['shifth'] : '';
		$closebutton = (isset ($input['closebutton'])) ? $input['closebutton'] : '';
		$backcolor = (isset ($input['backcolor'])) ? $input['backcolor'] : '';
		$bordercolor = (isset ($input['bordercolor'])) ? $input['bordercolor'] : '';
		$include_comments = (isset ($input['include_comments'])) ? $input['include_comments'] : '';
		$https_protocol = (isset ($input['https_protocol'])) ? $input['https_protocol'] : '';

		if ($https_protocol == 1) {
			$protocal = 'https://';
		} else {
			$protocal = 'http://';
		}

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}
		//target validation

		if ($target == 1) {
			$b = "_blank";
		} else if ($target == 0) {
			$b = "_top";
		} else if ($target != 0 || $target != 1) {
			$b = "";
		}

		//source validation
		if ($source == $source) {

			$source = $source;
		} else {
			$source = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];

		//~ $full_url=substr($full_url, 0, -9).'delivery';
		$d_c = '"';

		$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}");

		if ($layerstyle == 'geocities') {
			$params = '&source=' . $source . '&align=' . $align . '&padding=' . $padding . '&closetext=' . $closetext . '&charset=' . $charset . '&collapsetime=' . $collapsetime;
			if ($include_comments == 1) {
				$comments = '<!--/*
		  *------------------------------------------------------------*
		  * This interstitial invocation code requires the images from:
		  * /www/images/layerstyles/geocities/...
		  * To be accessible via: http(s)://revphpe.djaxbidder.com/revivemohan/www/images/layerstyles/geocities/...
		  *------------------------------------------------------------*
		  */-->';
			}
		} else if ($layerstyle == 'cursor') {
			$params = '&cb=INSERT_RANDOM_NUMBER_HERE&source=' . $source . '&hide=' . $hide . '&trail=' . $trail . '&offsetx=' . $offsetx . '&offsety=' . $offsety . '&charset=' . $charset . '&stickyness=' . $stickyness . '&transparancy=' . $transparancy . '&delay=' . $delay;
		} else if ($layerstyle == 'floater') {
			$params = '&source=' . $source . '&ltr=' . $ltr . '&loop=' . $loop . '&speed=' . $speed . '&pause=' . $pause . '&shiftv=' . $shiftv . '&transparent=' . $transparent . '&backcolor=' . $backcolor . '&limited=' . $limited;
			//. '&backcolor=' . $backcolor. '&lmargin=' . $lmargin . '&rmargin=' . $rmargin
		} else if ($layerstyle == 'simple') {
			$params = '&source=' . $source . '&align=' . $align . '&valign=' . $valign . '&padding=' . $padding . '&shifth=' . $shifth . '&shiftv=' . $shiftv . '&closebutton=' . $closebutton . '&backcolor=' . $backcolor . '&bordercolor=' . $bordercolor;
			if ($include_comments == 1) {
				$comments = '<!--/*
		  *------------------------------------------------------------*
		  * This interstitial invocation code requires the images from:
		  * /www/images/layerstyles/simple/...
		  * To be accessible via: http(s)://revphpe.djaxbidder.com/revivemohan/www/images/layerstyles/simple/...
		  *------------------------------------------------------------*
		  */-->';
			}
		}

		$interstitialtag = '<!-- Revive Adserver Interstitial or Floating DHTML Tag - Generated with Revive Adserver v5.4.1 --> 
		' . $comments . "
		<script type='text/javascript'><!--//<![CDATA[
		var ox_u ='" . $protocal . $full_url . "/al.php?zoneid=" . $args['zoneid'] . "&target=" . $target . "&layerstyle=" . $layerstyle . $params . "';
		if (document.context) ox_u +='&context='+ escape(document.context);
		document.write(" . '"<scr"+"ipt ' . "type='text/javascript' src='" . '"+ox_u+"' . "'" . '></scr"+"ipt>");//]]>--></script>';

		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'interstitial' => $interstitialtag

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});

$app->post('/invoke_emailnewsletter/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();
		$samepage = (isset ($input['showpage'])) ? $input['showpage'] : '';
		$show = (isset ($input['show'])) ? $input['show'] : '';
		$target = (isset ($input['target'])) ? $input['target'] : '';
		$source = (isset ($input['source'])) ? $input['source'] : '';
		$include_comments = (isset ($input['include_comments'])) ? $input['include_comments'] : '';
		$https_protocol = (isset ($input['https_protocol'])) ? $input['https_protocol'] : '';

		if ($https_protocol == 1) {
			$protocal = 'https://';
		} else {
			$protocal = 'http://';
		}

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		if ($include_comments == 1) {
			$comments = '<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
		  * a generated random number (or timestamp).
		  *
		  */-->';
		}


		$full_url = $this->get('settings')['path']['delivery'];

		//~ $full_url=substr($full_url, 0, -9).'delivery';
		$d_c = '"';

		$mi = md5("{$this->get('settings')['path']['delivery']}*{$this->get('settings')['path']['deliverySSL']}");

		$emailnewslettertag = "<!-- Revive Adserver No Cookie Image Tag - Generated with Revive Adserver v5.4.1 -->" . $comments . "<a href='" . $protocal . $full_url . "/cl.php?zoneid=" . $args['zoneid'] . "' target='" . $target . "'><img src='" . $protocal . $full_url . "/avw.php?zoneid=" . $args['zoneid'] . "&source=" . $source . "&amp;cb=INSERT_RANDOM_NUMBER_HERE' border='0' alt=''></a>";

		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'emailnewsletter' => $emailnewslettertag

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});

//VAST 2 Zone tag generation


/*
 * VAST 2 Zone tag
 *  
 */

$app->post('/invoke_vast2/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);

		return $response;
	} else {
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$sql = "select zoneid,width,height from " . $table_prefix . "zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();

		$input = $request->getParsedBody();

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}


		$full_url = $this->get('settings')['path']['delivery'];

		$vast2tag = 'https://' . $full_url . '/fc.php?script=apVideo:vast2&zoneid=' . $args['zoneid'] . '';

		$res = array (
			'response' => 'success',
			'statuscode' => '200',
			'vast2' => $vast2tag

		);

		//return stripcslashes($this->response->withJson($res));       
		return $this->response->withJson($res);

		return $response;
	}
});


//tracker image tag


$app->post('/track_imagetag/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$value = "select * from {$table_prefix}trackers where trackerid=:trackerid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":trackerid", $trackerid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();
		$full_url = $this->get('settings')['path']['delivery'];
		if (!$stmt) {
			$response = array ('response' => 'ok', 'msg' => 'No Tracker exist with provided tracker id!');
			return $this->response->withJson($response);
		} else {
			$abb = "<!--/*
*
*  CED.cy - Adserver JavaScript Tracker Code
*  - Generated with Revive Adserver v5.2.0
*
*  If this tag is being served on a secure (SSL) page, you must replace
*  'http://" . $full_url . "...'
* with
*  'https://" . $full_url . "...'
*
*  To help prevent caching of this tracker beacon, if possible,
*  Replace %%RANDOM_NUMBER%% with a randomly generated number (or timestamp)
*
*
*  Place this code at the top of your thank-you page, just after the <body> tag.
*
*/-->

<div id='m3_tracker_" . $trackerid . "' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='http://" . $full_url . "/ti.php?trackerid=" . $trackerid . "&amp;cb=%%RANDOM_NUMBER%%' width='0' height='0' alt='' /></div>";
			
			$res = array (
				'response' => 'tag',
				'Trackerimagetag' => $abb


			);

			//return stripcslashes($this->response->withJson($res));
			return $this->response->withJson($res);

			return $response;
		}
	}
})->add($container->get('tracker_edit'));


//tracker javascript tag


$app->post('/track_javascript/[{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$append = (isset ($input['append'])) ? $input['append'] : '';
		$value = "select * from {$table_prefix}trackers where trackerid=:trackerid";
		$tracker_data = $this->db->prepare($value);
		$tracker_data->bindParam(":trackerid", $trackerid);
		$tracker_data->execute();
		$stmt = $tracker_data->fetchAll();
		$dc = '"';
		if ($append == 1) {
			$append = "1";
		} else {
			$append = "0";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		if (!$stmt) {
			$response = array ('response' => 'ok', 'msg' => 'No Tracker exist with provided tracker id!');
			return $this->response->withJson($response);
		} else {
			$abb = "<!--/*
*
*  CED.cy - Adserver JavaScript Tracker Code
*  - Generated with Revive Adserver v5.2.0
*
*  To help prevent caching of the <noscript> beacon, if possible,
*  Replace %%RANDOM_NUMBER%% with a randomly generated number (or timestamp)
*
*/-->

<!--/*
*
*  Place this code at the top of your thank-you page, just after the <body> tag,
*  below any definitions of Javascript variables that need to be tracked.
*
*/-->

<script type='text/javascript'>
var p = (location.protocol=='https:'?'https://" . $full_url . "/tjs.php':'http://" . $full_url . "/tjs.php');

var r=Math.floor(Math.random()*999999);
document.write (" . $dc . "<" . $dc . " + " . $dc . "script language='JavaScript' " . $dc . ");
document.write (" . $dc . "type='text/javascript' src='" . $dc . "+p);
document.write (" . $dc . "?trackerid=" . $trackerid . "&amp;append=" . $append . "&amp;r=" . $dc . "+r+" . $dc . "'><" . $dc . " + " . $dc . "\/script>" . $dc . ");
</script><noscript><div id='m3_tracker_" . $trackerid . "' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'><img src='http://" . $full_url . "/ti.php?trackerid=" . $trackerid . "&amp;cb=%%RANDOM_NUMBER%%' width='0' height='0' alt='' /></div></noscript>";
			$res = array (
				'response' => 'tag',
				'Trackerjavascripttag' => $abb


			);
			return $this->response->withJson($res);
			return $response;
			//return stripcslashes($this->response->withJson($res));
		}
	}
})->add($container->get('tracker_edit'));



//VAST 

//vast video ads features
//inline third party vast video ads

$app->post('/add_banner_vastinline/[{campaign_id}]', function ($request, $response, $args) {
	//~ print_r("test");

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		//~ print_r("test");
		//~ print_r("testing");
		//~ print_r("test-yes");
		$campaignid = $args['campaign_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		//~ $image_path = '../../www/images/';

		//~ print_r($image_path);
		//~ exit;
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		//~ define('DIRECTORY', $image_path);
		$validation = "SELECT * FROM {$table_prefix}campaigns WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetchAll();
		$valid = count($stmtvalidation);


		if ($valid && ($input['storagetype'] == 'html') && ($input['width'] == '-3') && ($input['height'] == '-3') && (($input['vast_video_delivery'] == '') || ($input['vast_video_delivery'] == 'progressive'))) {


			/////////////////////////////////////inline html/////////////////////////////////////////////
			//~ $storagetype = $input['storagetype'];
			$description = isset ($input['description']) ? $input['description'] : '';
			$storagetype = isset ($input['storagetype']) ? $input['storagetype'] : '';

			$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];

			$vast_video_delivery = $input['vast_video_delivery'];
			$vast_wrapper_url = $input['vast_wrapper_url'];


			$target = isset ($input['target']) ? $input['target'] : '';
			$keyword = isset ($input['keyword']) ? $input['keyword'] : '';
			$append = isset ($input['append']) ? $input['append'] : '';
			$prepend = isset ($input['prepend']) ? $input['prepend'] : '';
			$comments = isset ($input['comments']) ? $input['comments'] : '';
			$alt = isset ($input['alt']) ? $input['alt'] : '';
			$statustext = isset ($input['statustext']) ? $input['statustext'] : '';
			$bannertext = isset ($input['bannertext']) ? $input['bannertext'] : '';
			$vast_video_outgoing_filename = isset ($input['vast_video_outgoing_filename']) ? $input['vast_video_outgoing_filename'] : '';
			//~ $imageurl 		= isset($input['imageurl'])?$input['imageurl']:'';
			$vast_video_id = isset ($input['vast_video_id']) ? $input['vast_video_id'] : null;
			//new

			$vast_video_type = isset ($input['vast_video_type']) ? $input['vast_video_type'] : '';
			$vast_third_internal_type = isset ($input['vast_third_internal_type']) ? $input['vast_third_internal_type'] : '';
			$vast_thirdparty_clicktracking = isset ($input['vast_thirdparty_clicktracking']) ? $input['vast_thirdparty_clicktracking'] : '';
			$vast_thirdparty_clickcustom = isset ($input['vast_thirdparty_clickcustom']) ? $input['vast_thirdparty_clickcustom'] : '';
			$vast_thirdparty_companion_expandedwidth = isset ($input['vast_thirdparty_companion_expandedwidth']) ? $input['vast_thirdparty_companion_expandedwidth'] : '';
			$vast_thirdparty_companion_expandedheight = isset ($input['vast_thirdparty_companion_expandedheight']) ? $input['vast_thirdparty_companion_expandedheight'] : '';
			$vast_thirdparty_companion_clicktracking = isset ($input['vast_thirdparty_companion_clicktracking']) ? $input['vast_thirdparty_companion_clicktracking'] : '';
			$vast_wrapper_url = isset ($input['vast_wrapper_url']) ? $input['vast_wrapper_url'] : '';
			//url validation
			if (!empty ($vast_wrapper_url) && !filter_var($vast_wrapper_url, FILTER_VALIDATE_URL)) {

				echo ("Given third party url  is not a valid URL" . "<br>" . "please make sure your vast wrapper url(third party url) contains http:// or https://");
				exit;
			}

			$vast_version = isset ($input['vast_version']) ? $input['vast_version'] : '';
			$vast_video_skip_duration = isset ($input['vast_video_skip_duration']) ? $input['vast_video_skip_duration'] : '';
			$vast_video_skip_progress_duration = isset ($input['vast_video_skip_progress_duration']) ? $input['vast_video_skip_progress_duration'] : '';

			//end

			$vast_companion_banner_id = $input['vast_companion_banner_id'];
			$vast_thirdparty_impression = $input['vast_thirdparty_impression'];


			$vast_overlay_height = isset ($input['vast_overlay_height']) ? $input['vast_overlay_height'] : null;
			$vast_overlay_width = isset ($input['vast_overlay_width']) ? $input['vast_overlay_width'] : null;
			$vast_overlay_text_title = isset ($input['vast_overlay_text_title']) ? $input['vast_overlay_text_title'] : null;
			$vast_overlay_text_description = isset ($input['vast_overlay_text_description']) ? $input['vast_overlay_text_description'] : null;
			$vast_overlay_text_call = isset ($input['vast_overlay_text_call']) ? $input['vast_overlay_text_call'] : null;



			$var = array ();
			$var = array (
				"banner_vast_element_id" => 'banner_vast_element_id',
				"vast_element_type" => 'singlerow',
				"vast_video_id" => 'N',
				"vast_video_delivery" => $vast_video_delivery,
				"vast_video_type" => $vast_video_type,
				"vast_video_bitrate" => 400,
				"vast_video_height" => 480,
				"vast_video_width" => 640,
				"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_thirdparty_clicktracking" => $vast_thirdparty_clicktracking,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_wrapper_url" => $vast_wrapper_url,
				"vast_version" => $vast_version,
				"vast_third_internal_type" => $vast_third_internal_type,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_height" => 'N',
				"vast_overlay_width" => 'N',
				"vast_overlay_text_title" => 'N',
				"vast_overlay_text_description" => 'N',
				"vast_overlay_text_call" => 'N',
				"vast_overlay_format" => 'N',
				"vast_overlay_action" => 'N',
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_creative_type" => 'N',
				"vast_thirdparty_impression" => $vast_thirdparty_impression
			);

			$addbanner = "INSERT INTO " . $table_prefix . "banners(
				`campaignid`,
				`storagetype`,
				`width`,
				`height`,
				`weight`,
				`description`,
				`comments`,
				`updated`,
				`keyword`,
				`append`,
				`prepend`,
				`parameters`,
				`ext_bannertype`)  VALUES (
				:campaignid,
				:storagetype,
				-3,
				-3,
				1,
				:description,
				:comments,
				:updated,
				:keyword,
				'" . $append . "',
				'" . $prepend . "',
				:parameters,
				'bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml')";

			$parameter = serialize($var);

			if (empty ($parameter)) {
				$parameter = 'N;';
			}

			$djax_query_banners = $this->db->prepare($addbanner);

			$djax_query_banners->bindParam(":campaignid", $campaignid);
			$djax_query_banners->bindParam(":storagetype", $storagetype);

			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);

			$djax_query_banners->bindParam(":keyword", $keyword);
			//~ $djax_query_banners->bindParam(":append",$append);
			//~ $djax_query_banners->bindParam(":prepend",$prepend);
			$djax_query_banners->bindParam(":parameters", $parameter);

			$djax_query_banners->execute();
			$bannerid = $this->db->lastInsertId();

			//auto increment

			$get_banner_id = "select * from banner_vast_element_seq";
			$query_banner_vast_id = $this->db->prepare($get_banner_id);
			$query_banner_vast_id->execute();
			$banner_vast_id = $query_banner_vast_id->fetchAll();

			if (count($banner_vast_id) > 0) {
				$a = $banner_vast_id[0]['id'];
				$banner_vast_element_id = $a + 1;
			} else {
				$banner_vast_element_id = 1;
			}

			$vast_element_type = 'singlerow';
			$vast_video_bitrate = 400;
			$vast_video_height = 480;
			$vast_video_width = 640;

			$addparameters = "insert into " . $table_prefix . "banner_vast_element(
				`banner_vast_element_id`,
				`banner_id`,
				`vast_element_type`,
				`vast_video_id`,
				`vast_video_duration`,
				`vast_video_delivery`,
				`vast_video_type`,
				`vast_video_bitrate`,
				`vast_video_height`,
				`vast_video_width`,
				`vast_video_outgoing_filename`,
				`vast_companion_banner_id`,
				`vast_overlay_height`,
				`vast_overlay_width`,
				`vast_video_clickthrough_url`,
				`vast_overlay_text_title`,
				`vast_overlay_text_description`,
				`vast_overlay_text_call`,
				`vast_creative_type`,
				`vast_wrapper_url`,
				`vast_video_skip_duration`,
				`vast_video_skip_progress_duration`,
				`vast_type`,
				`get_third_internal_type`,
				`vast_thirdparty_clicktracking`,
				`vast_thirdparty_clickcustom`,
				`vast_thirdparty_companion_clicktracking`,
				`vast_thirdparty_companion_expandedwidth`,
				`vast_thirdparty_companion_expandedheight`,
				`vast_thirdparty_impression`)
				values(
				:banner_vast_element_id,
				:banner_id,
				:vast_element_type,
				:vast_video_id,
				:vast_video_duration,
				:vast_video_delivery,
				:vast_video_type,
				:vast_video_bitrate,
				:vast_video_height,
				:vast_video_width,
				:vast_video_outgoing_filename,
				:vast_companion_banner_id,
				:vast_overlay_height,
				:vast_overlay_width,
				:vast_video_clickthrough_url,
				:vast_overlay_text_title,
				:vast_overlay_text_description,
				:vast_overlay_text_call,
				:vast_creative_type,
				'" . $vast_wrapper_url . "',
				'" . $vast_video_skip_duration . "',
				'" . $vast_video_skip_progress_duration . "',
				" . $vast_version . ",
				'" . $vast_third_internal_type . "',
				'" . $vast_thirdparty_clicktracking . "',
				'" . $vast_thirdparty_clickcustom . "',
				'" . $vast_thirdparty_companion_clicktracking . "',
				'" . $vast_thirdparty_companion_expandedwidth . "',
				'" . $vast_thirdparty_companion_expandedheight . "',
				:vast_thirdparty_impression
				)";

			$djax_query_banners_parameters = $this->db->prepare($addparameters);

			$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);

			$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
			$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
			//$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
			$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);

			$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
			$djax_query_banners_parameters->bindParam(":vast_video_height", $vast_video_height);
			$djax_query_banners_parameters->bindParam(":vast_video_width", $vast_video_width);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
			$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
			$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
			$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
			$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);

			//$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);

			$djax_query_banners_parameters->execute();
			//	$parameterid=$this->db->lastInsertId('banner_vast_element_id');

			$addelement_id = "update banner_vast_element_seq set `id`=:banner_vast_element_id;";
			$djax_query_banners_elements = $this->db->prepare($addelement_id);
			$djax_query_banners_elements->bindParam(":banner_vast_element_id", $banner_vast_element_id);
			$djax_query_banners_elements->execute();

			$results = json_encode(array ('banner' => $bannerid));

			return $results;
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Campaignid');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('banneraddvastinline_val'));



//vast video ads features
//inline third party vast video ads



//

$app->post('/edit_banner_vastinline/[{banner_id}]', function ($request, $response, $args) {
	//~ print_r("test");

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$bannerid = $args['banner_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		$getbanners = "select * from rv_banners where bannerid=:bannerid";
		$djax_query_banner = $this->db->prepare($getbanners);
		$djax_query_banner->bindParam(":bannerid", $bannerid);
		$djax_query_banner->execute();
		$stmtbanner = $djax_query_banner->fetchAll();

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		//~ if($stmtbanner)
		//~ {
		//~ $description 		= isset($input['description'])?$input['description']:'';
		//~ $storagetype 		= isset($input['storagetype'])?$input['storagetype']:'';

		//testing team




		//new
		if (count($stmtbanner) > 0) {
			if (isset ($input['storagetype'])) {
				$storagetype = $input['storagetype'];
			} else {
				$storagetype = $stmtbanner[0]['storagetype'];
			}

			if (isset ($input['contenttype'])) {
				$contenttype = $input['contenttype'];
			} else {
				$contenttype = $stmtbanner[0]['contenttype'];
			}

			if (isset ($input['description'])) {
				$description = $input['description'];
			} else {
				$description = $stmtbanner[0]['description'];
			}


			if (isset ($input['keyword'])) {
				$keyword = $input['keyword'];
			} else {
				$keyword = $stmtbanner[0]['keyword'];
			}

			if (isset ($input['append'])) {
				$append = $input['append'];
			} else {
				$append = $stmtbanner[0]['append'];
			}
			if (isset ($input['prepend'])) {
				$prepend = $input['prepend'];
			} else {
				$prepend = $stmtbanner[0]['prepend'];
			}

			if (isset ($input['comments'])) {
				$comments = $input['comments'];
			} else {
				$comments = $stmtbanner[0]['comments'];
			}

			//end


			$dbparameters = $stmtbanner[0]['parameters'];
			$unparameters = unserialize($dbparameters);


			if (isset ($input['vast_video_clickthrough_url'])) {
				$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
			} else {
				$vast_video_clickthrough_url = $unparameters['vast_video_clickthrough_url'];
			}

			if (isset ($input['vast_thirdparty_clicktracking'])) {
				$vast_thirdparty_clicktracking = $input['vast_thirdparty_clicktracking'];
			} else {
				$vast_thirdparty_clicktracking = $unparameters['vast_thirdparty_clicktracking'];
			}

			if (isset ($input['vast_thirdparty_clickcustom'])) {
				$vast_thirdparty_clickcustom = $input['vast_thirdparty_clickcustom'];
			} else {
				$vast_thirdparty_clickcustom = $unparameters['vast_thirdparty_clickcustom'];
			}

			if (isset ($input['vast_thirdparty_companion_expandedwidth'])) {
				$vast_thirdparty_companion_expandedwidth = $input['vast_thirdparty_companion_expandedwidth'];
			} else {
				$vast_thirdparty_companion_expandedwidth = $unparameters['vast_thirdparty_companion_expandedwidth'];
			}

			if (isset ($input['vast_video_delivery'])) {
				$vast_video_delivery = $input['vast_video_delivery'];
			} else {
				$vast_video_delivery = $unparameters['vast_video_delivery'];
			}

			if (isset ($input['vast_thirdparty_companion_expandedheight'])) {
				$vast_thirdparty_companion_expandedheight = $input['vast_thirdparty_companion_expandedheight'];
			} else {
				$vast_thirdparty_companion_expandedheight = $unparameters['vast_thirdparty_companion_expandedheight'];
			}

			if (isset ($input['vast_companion_banner_id'])) {
				$vast_companion_banner_id = $input['vast_companion_banner_id'];
			} else {
				$vast_companion_banner_id = $unparameters['vast_companion_banner_id'];
			}

			if (isset ($input['vast_thirdparty_impression'])) {
				$vast_thirdparty_impression = $input['vast_thirdparty_impression'];
			} else {
				$vast_thirdparty_impression = $unparameters['vast_thirdparty_impression'];
			}

			if (isset ($input['vast_thirdparty_companion_clicktracking'])) {
				$vast_thirdparty_companion_clicktracking = $input['vast_thirdparty_companion_clicktracking'];
			} else {
				$vast_thirdparty_companion_clicktracking = $unparameters['vast_thirdparty_companion_clicktracking'];
			}

			if (isset ($input['vast_wrapper_url'])) {
				$vast_wrapper_url = $input['vast_wrapper_url'];
			} else {
				$vast_wrapper_url = $unparameters['vast_wrapper_url'];
			}

			if (isset ($input['vast_version'])) {
				$vast_version = $input['vast_version'];
			} else {
				$vast_version = $unparameters['vast_version'];
			}

			if (isset ($input['vast_video_skip_duration'])) {
				$vast_video_skip_duration = $input['vast_video_skip_duration'];
			} else {
				$vast_video_skip_duration = $unparameters['vast_video_skip_duration'];
			}
			if (isset ($input['vast_video_skip_progress_duration'])) {
				$vast_video_skip_progress_duration = $input['vast_video_skip_progress_duration'];
			} else {
				$vast_video_skip_progress_duration = $unparameters['vast_video_skip_progress_duration'];
			}

			if (isset ($input['vast_third_internal_type'])) {
				$vast_third_internal_type = $input['vast_third_internal_type'];
			} else {
				$vast_third_internal_type = $unparameters['vast_third_internal_type'];
			}

			//url validation
			if (!empty ($vast_wrapper_url) && !filter_var($vast_wrapper_url, FILTER_VALIDATE_URL)) {

				echo ("Given third party url  is not a valid URL" . "<br>" . "please make sure your vast wrapper url(third party url) contains http:// or https://");
				exit;
			}
			//kjkjk

			$var = array ();
			$var = array (
				"banner_vast_element_id" => 'banner_vast_element_id',
				"vast_element_type" => 'singlerow',
				"vast_video_id" => 'N',

				"vast_video_delivery" => $vast_video_delivery,
				"vast_thirdparty_clicktracking" => $vast_thirdparty_clicktracking,
				"vast_version" => $vast_version,
				"vast_third_internal_type" => $vast_third_internal_type,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_video_bitrate" => 400,
				"vast_video_height" => 480,
				"vast_video_width" => 640,
				"vast_wrapper_url" => $vast_wrapper_url,
				"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_height" => 'N',
				"vast_overlay_width" => 'N',
				"vast_overlay_text_title" => 'N',
				"vast_overlay_text_description" => 'N',
				"vast_overlay_text_call" => 'N',
				"vast_overlay_format" => 'N',
				"vast_overlay_action" => 'N',
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_creative_type" => 'N',
				"vast_thirdparty_impression" => $vast_thirdparty_impression
			);

			$parameters = serialize($var);

			$editbanner1 = "update rv_banners set
				`description`=:description,
				`comments`=:comments,
				`updated`=:updated,
				`keyword`=:keyword,
				`append`=:append,
				`prepend`=:prepend,
				`parameters`=:parameters
				where `bannerid`=:bannerid";

			$djax_query_banners = $this->db->prepare($editbanner1);
			$djax_query_banners->bindParam(":bannerid", $bannerid);
			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);
			$djax_query_banners->bindParam(":keyword", $keyword);
			$djax_query_banners->bindParam(":append", $append);
			$djax_query_banners->bindParam(":prepend", $prepend);
			$djax_query_banners->bindParam(":parameters", $parameters);
			$djax_query_banners->execute();


			$editvastparameters = "update " . $table_prefix . "banner_vast_element set
				`vast_video_delivery`=:vast_video_delivery,
				`vast_wrapper_url`='" . $vast_wrapper_url . "',
				`vast_video_skip_duration`='" . $vast_video_skip_duration . "',
				`vast_video_skip_progress_duration`='" . $vast_video_skip_progress_duration . "',
				`vast_version`='" . $vast_version . "',
				`get_third_internal_type`='" . $vast_third_internal_type . "',
				`vast_thirdparty_clicktracking`='" . $vast_thirdparty_clicktracking . "',
				`vast_thirdparty_clickcustom`='" . $vast_thirdparty_clickcustom . "',
				`vast_thirdparty_companion_clicktracking`='" . $vast_thirdparty_companion_clicktracking . "',
				`vast_thirdparty_companion_expandedwidth`='" . $vast_thirdparty_companion_expandedwidth . "',
				`vast_thirdparty_companion_expandedheight`='" . $vast_thirdparty_companion_expandedheight . "',
				`vast_companion_banner_id`=:vast_companion_banner_id,
				`vast_video_clickthrough_url`=:vast_video_clickthrough_url,
				`vast_thirdparty_impression`=:vast_thirdparty_impression where `banner_id`=:banner_id ";




			$djax_query_banners_parameters = $this->db->prepare($editvastparameters);
			$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);
			$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
			$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);
			//new
			$djax_query_banners->bindParam(":vast_thirdparty_companion_expandedheight", $vast_thirdparty_companion_expandedheight);
			$djax_query_banners->bindParam(":vast_thirdparty_companion_expandedwidth", $vast_thirdparty_companion_expandedwidth);
			$djax_query_banners->bindParam(":vast_thirdparty_clickcustom", $vast_thirdparty_clickcustom);
			$djax_query_banners->bindParam(":vast_thirdparty_clicktracking", $vast_thirdparty_clicktracking);
			$djax_query_banners->bindParam(":vast_version", $vast_version);
			$djax_query_banners->bindParam(":vast_video_skip_progress_duration", $vast_video_skip_progress_duration);
			$djax_query_banners->bindParam(":vast_video_skip_duration", $vast_video_skip_duration);
			$djax_query_banners->bindParam(":vast_wrapper_url", $vast_wrapper_url);
			//end
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
			$djax_query_banners_parameters->execute();

			if (isset ($input['description']) && $input['description'] == '') {
				$response2 = array ('response' => 'error', 'msg' => 'description must not be empty');
				return $this->response->withJson($response2);
			}

			/*if(isset($input['vast_wrapper_url']) && $input['vast_wrapper_url'] == '')
																																																																																																																																																																									{
																																																																																																																																																																									
																																																																																																																																																																									$response1 = array('response'=> 'error','msg'=>'vast_wrapper_url must not be empty');		 
																																																																																																																																																																									return $this->response->withJson($response1);
																																																																																																																																																																								}*/



			if (isset ($input['vast_version']) && $input['vast_version'] == '') {
				$response3 = array ('response' => 'error', 'msg' => 'vast_version must not be empty');
				return $this->response->withJson($response3);
			}

			//~ //if all empty
			//~ 
			//~ if((isset($input['vast_wrapper_url']) && $input['vast_wrapper_url'] == '') && (isset($input['description']) && $input['description'] == '') && (isset($input['vast_version']) && $input['vast_version'] == ''))
			//~ {
			//~ echo $response1;
			//~ echo $response2;
			//~ echo $response3;
			//~ exit;
			//~ 
			//~ }
			else {
				$response = array ('response' => 'ok', 'msg' => 'Banner Updated Successfully');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid bannerid');
			return $this->response->withJson($response);
		}
	}
});


$app->post('/add_banner_vastoverlay/[{campaign_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		//~ print_r("test");
		//~ print_r("testing");
		//~ print_r("test-yes");
		$campaignid = $args['campaign_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		//~ $image_path = '../../www/images/';

		//~ print_r($image_path);
		//~ exit;
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		//~ define('DIRECTORY', $image_path);
		$validation = "SELECT * FROM {$table_prefix}campaigns WHERE campaignid =:campaignid";

		$djax_query_validation = $this->db->prepare($validation);
		$djax_query_validation->bindParam(":campaignid", $campaignid);
		$djax_query_validation->execute();
		$stmtvalidation = $djax_query_validation->fetchAll();
		$valid = count($stmtvalidation);

		if ($valid && ($input['storagetype'] == 'html') && ($input['width'] == '-2') && ($input['height'] == '-2') && ($input['vast_overlay_format'] == 'image_overlay' || $input['vast_overlay_format'] == 'VAST_OVERLAY_FORMAT_WRAPPER')) {

			/////////////////////////////////////inline html/////////////////////////////////////////////
			//~ $storagetype = $input['storagetype'];
			$description = isset ($input['description']) ? $input['description'] : '';
			$storagetype = isset ($input['storagetype']) ? $input['storagetype'] : '';

			$url = $input['url'];
			//url validation
			if (!empty ($url) && !filter_var($url, FILTER_VALIDATE_URL)) {
				echo ("Given  url  is not a valid URL" . "<br>" . "please make sure your url contains http:// or https://");
				exit;
			}
			$vast_overlay_format = $input['vast_overlay_format'];
			$vast_overlay_wrapper = $input['vast_overlay_wrapper'];


			$target = isset ($input['target']) ? $input['target'] : '';
			$vast_overlay_action = isset ($input['vast_overlay_action']) ? $input['vast_overlay_action'] : '';
			$keyword = isset ($input['keyword']) ? $input['keyword'] : '';
			$append = isset ($input['append']) ? $input['append'] : '';
			$prepend = isset ($input['prepend']) ? $input['prepend'] : '';
			$comments = isset ($input['comments']) ? $input['comments'] : '';
			$alt = isset ($input['alt']) ? $input['alt'] : '';
			$statustext = isset ($input['statustext']) ? $input['statustext'] : '';
			$bannertext = isset ($input['bannertext']) ? $input['bannertext'] : '';
			$imageurl = isset ($input['imageurl']) ? $input['imageurl'] : '';
			$vast_video_id = isset ($input['vast_video_id']) ? $input['vast_video_id'] : null;
			//new

			$vast_overlay_height = isset ($input['vast_overlay_height']) ? $input['vast_overlay_height'] : '';
			$vast_overlay_width = isset ($input['vast_overlay_width']) ? $input['vast_overlay_width'] : '';
			$vast_creative_type = isset ($input['vast_creative_type']) ? $input['vast_creative_type'] : '';
			$vast_thirdparty_clicktracking = isset ($input['vast_thirdparty_clicktracking']) ? $input['vast_thirdparty_clicktracking'] : '';
			$vast_thirdparty_clickcustom = isset ($input['vast_thirdparty_clickcustom']) ? $input['vast_thirdparty_clickcustom'] : '';
			$vast_thirdparty_companion_expandedwidth = isset ($input['vast_thirdparty_companion_expandedwidth']) ? $input['vast_thirdparty_companion_expandedwidth'] : '';
			$vast_thirdparty_companion_expandedheight = isset ($input['vast_thirdparty_companion_expandedheight']) ? $input['vast_thirdparty_companion_expandedheight'] : '';
			$vast_thirdparty_companion_clicktracking = isset ($input['vast_thirdparty_companion_clicktracking']) ? $input['vast_thirdparty_companion_clicktracking'] : '';
			$vast_wrapper_url = isset ($input['vast_wrapper_url']) ? $input['vast_wrapper_url'] : '';
			$vast_overlay_version = isset ($input['vast_overlay_version']) ? $input['vast_overlay_version'] : '';
			$vast_video_skip_duration = isset ($input['vast_video_skip_duration']) ? $input['vast_video_skip_duration'] : '';
			$vast_video_skip_progress_duration = isset ($input['vast_video_skip_progress_duration']) ? $input['vast_video_skip_progress_duration'] : '';
			$vast_overlay_expanded_width = isset ($input['vast_overlay_expanded_width']) ? $input['vast_overlay_expanded_width'] : '';
			$vast_overlay_expanded_height = isset ($input['vast_overlay_expanded_height']) ? $input['vast_overlay_expanded_height'] : '';
			$vast_overlay_expandedminduration = isset ($input['vast_overlay_expandedminduration']) ? $input['vast_overlay_expandedminduration'] : '';

			//end

			$vast_companion_banner_id = $input['vast_companion_banner_id'];
			$vast_thirdparty_impression = $input['vast_thirdparty_impression'];

			$vast_overlay_height = isset ($input['vast_overlay_height']) ? $input['vast_overlay_height'] : null;
			$vast_overlay_width = isset ($input['vast_overlay_width']) ? $input['vast_overlay_width'] : null;
			$vast_overlay_text_title = isset ($input['vast_overlay_text_title']) ? $input['vast_overlay_text_title'] : null;
			$vast_overlay_text_description = isset ($input['vast_overlay_text_description']) ? $input['vast_overlay_text_description'] : null;
			$vast_overlay_text_call = isset ($input['vast_overlay_text_call']) ? $input['vast_overlay_text_call'] : null;

			//url validation

			if (!empty ($vast_overlay_wrapper) && !filter_var($vast_overlay_wrapper, FILTER_VALIDATE_URL)) {
				echo ("Given third party url  is not a valid URL" . "<br>" . "please make sure your vast wrapper url(third party url) contains http:// or https://");
				exit;
			}

			$var = array ();
			$var = array (
				"banner_vast_element_id" => 'banner_vast_element_id',
				"vast_element_type" => 'singlerow',
				"vast_video_id" => 'N',
				"vast_overlay_format" => $vast_overlay_format,
				"vast_video_bitrate" => 400,
				"vast_video_height" => 480,
				"vast_video_width" => 640,
				"vast_video_clickthrough_url" => 'vast_video_clickthrough_url',
				"vast_overlay_action" => $vast_overlay_action,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_overlay_wrapper" => $vast_overlay_wrapper,
				"vast_overlay_version" => $vast_overlay_version,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_expandedminduration" => $vast_overlay_expandedminduration,
				"vast_overlay_expanded_height" => $vast_overlay_expanded_height,
				"vast_overlay_expanded_width" => $vast_overlay_expanded_width,
				"vast_overlay_height" => $vast_overlay_height,
				"vast_overlay_width" => $vast_overlay_width,
				"vast_overlay_text_title" => 'N',
				"vast_overlay_text_description" => 'N',
				"vast_overlay_text_call" => 'N',
				"vast_overlay_format" => 'N',
				"vast_overlay_action" => 'N',
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_creative_type" => $vast_creative_type,
				"vast_thirdparty_impression" => $vast_thirdparty_impression
			);

			$addbanner = "INSERT INTO " . $table_prefix . "banners(
				`campaignid`,
				`storagetype`,
				`width`,
				`height`,
				`weight`,
				`description`,
				`comments`,
				`updated`,
				`keyword`,
				`append`,
				`prepend`,
				`url`,
				`filename`,
				`parameters`,
				`ext_bannertype`)  VALUES (
				:campaignid,
				:storagetype,
				-2,
				-2,
				1,
				:description,
				:comments,
				:updated,
				:keyword,
				'" . $append . "',
				'" . $prepend . "',
				'" . $url . "',
				'" . $imageurl . "',
				:parameters,
				'bannerTypeHtml:vastOverlayBannerTypeHtml:vastOverlayHtml')";

			$parameter = serialize($var);

			if (empty ($parameter)) {
				$parameter = 'N;';
			}

			$djax_query_banners = $this->db->prepare($addbanner);

			$djax_query_banners->bindParam(":campaignid", $campaignid);
			$djax_query_banners->bindParam(":storagetype", $storagetype);

			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);

			$djax_query_banners->bindParam(":keyword", $keyword);
			//~ $djax_query_banners->bindParam(":append",$append);
			//~ $djax_query_banners->bindParam(":prepend",$prepend);
			$djax_query_banners->bindParam(":parameters", $parameter);

			$djax_query_banners->execute();
			$bannerid = $this->db->lastInsertId();

			//auto increment

			$get_banner_id = "select * from banner_vast_element_seq";
			$query_banner_vast_id = $this->db->prepare($get_banner_id);
			$query_banner_vast_id->execute();
			$banner_vast_id = $query_banner_vast_id->fetchAll();

			if (count($banner_vast_id) > 0) {
				$a = $banner_vast_id[0]['id'];
				$banner_vast_element_id = $a + 1;
			} else {
				$banner_vast_element_id = 1;
			}

			$vast_element_type = 'singlerow';
			$vast_video_bitrate = 400;
			//$vast_video_height = 480;
			//$vast_video_width = 640;

			$addparameters = "insert into " . $table_prefix . "banner_vast_element(
				`banner_vast_element_id`,
				`banner_id`,
				`vast_element_type`,
				`vast_video_id`,
				`vast_video_duration`,
				`vast_overlay_format`,
				`vast_video_type`,
				`vast_video_bitrate`,
				`vast_video_height`,
				`vast_video_width`,
				`vast_video_outgoing_filename`,
				`vast_companion_banner_id`,
				`vast_overlay_height`,
				`vast_overlay_width`,
				`vast_video_clickthrough_url`,
				`vast_overlay_text_title`,
				`vast_overlay_text_description`,
				`vast_overlay_text_call`,
				`vast_creative_type`,
				`vast_overlay_wrapper`,
				`vast_video_skip_duration`,
				`vast_video_skip_progress_duration`,
				`vast_type`,
				`vast_thirdparty_clicktracking`,
				`vast_thirdparty_clickcustom`,
				`vast_thirdparty_companion_clicktracking`,
				`vast_thirdparty_companion_expandedwidth`,
				`vast_thirdparty_companion_expandedheight`,
				`vast_overlay_action`,
				`vast_overlay_expanded_width`,
				`vast_overlay_expanded_height`,
				`vast_overlay_expandedminduration`,
				`vast_thirdparty_impression`)
				values(
				:banner_vast_element_id,
				:banner_id,
				:vast_element_type,
				:vast_video_id,
				:vast_video_duration,
				:vast_overlay_format,
				:vast_video_type,
				:vast_video_bitrate,
				:vast_video_height,
				:vast_video_width,
				:vast_video_outgoing_filename,
				:vast_companion_banner_id,
				:vast_overlay_height,
				:vast_overlay_width,
				:url,
				:vast_overlay_text_title,
				:vast_overlay_text_description,
				:vast_overlay_text_call,
				:vast_creative_type,
				'" . $vast_overlay_wrapper . "',
				'" . $vast_video_skip_duration . "',
				'" . $vast_video_skip_progress_duration . "',
				'" . $vast_overlay_version . "',
				'" . $vast_thirdparty_clicktracking . "',
				'" . $vast_thirdparty_clickcustom . "',
				'" . $vast_thirdparty_companion_clicktracking . "',
				'" . $vast_thirdparty_companion_expandedwidth . "',
				'" . $vast_thirdparty_companion_expandedheight . "',
				'" . $vast_overlay_action . "',
				'" . $vast_overlay_expanded_width . "',
				'" . $vast_overlay_expanded_height . "',
				'" . $vast_overlay_expandedminduration . "',
				:vast_thirdparty_impression
				)";

			$djax_query_banners_parameters = $this->db->prepare($addparameters);

			$djax_query_banners_parameters->bindParam(":banner_vast_element_id", $banner_vast_element_id);
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);

			$djax_query_banners_parameters->bindParam(":vast_element_type", $vast_element_type);
			$djax_query_banners_parameters->bindParam(":vast_video_id", $vast_video_id);
			$djax_query_banners_parameters->bindParam(":vast_video_duration", $vast_video_duration);
			$djax_query_banners_parameters->bindParam(":vast_overlay_format", $vast_overlay_format);

			$djax_query_banners_parameters->bindParam(":vast_video_type", $vast_video_type);
			$djax_query_banners_parameters->bindParam(":vast_video_bitrate", $vast_video_bitrate);
			$djax_query_banners_parameters->bindParam(":vast_video_height", $vast_video_height);
			$djax_query_banners_parameters->bindParam(":vast_video_width", $vast_video_width);
			$djax_query_banners_parameters->bindParam(":vast_video_outgoing_filename", $vast_video_outgoing_filename);
			$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
			$djax_query_banners_parameters->bindParam(":vast_overlay_height", $vast_overlay_height);
			$djax_query_banners_parameters->bindParam(":vast_overlay_width", $vast_overlay_width);
			$djax_query_banners_parameters->bindParam(":url", $url);
			//~ $djax_query_banners_parameters->bindParam(":vast_thirdparty_clicktracking",$vast_thirdparty_clicktracking);
			//~ $djax_query_banners_parameters->bindParam(":vast_video_delivery",$vast_video_delivery);
			//~ $djax_query_banners_parameters->bindParam(":vast_wrapper_url",$vast_wrapper_url);
			//~ $djax_query_banners_parameters->bindParam(":vast_version",$vast_version);
			//~ $djax_query_banners_parameters->bindParam(":vast_overlay_expandedminduration",$vast_overlay_expandedminduration);
			//~ $djax_query_banners_parameters->bindParam(":vast_overlay_expanded_width",$vast_overlay_expanded_width);
			//~ $djax_query_banners_parameters->bindParam(":vast_overlay_expanded_height",$vast_overlay_expanded_height);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_title", $vast_overlay_text_title);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_description", $vast_overlay_text_description);
			$djax_query_banners_parameters->bindParam(":vast_overlay_text_call", $vast_overlay_text_call);

			$djax_query_banners_parameters->bindParam(":vast_creative_type", $vast_creative_type);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);

			$djax_query_banners_parameters->execute();
			//$parameterid=$this->db->lastInsertId('banner_vast_element_id');

			$addelement_id = "update banner_vast_element_seq set `id`=:banner_vast_element_id;";
			$djax_query_banners_elements = $this->db->prepare($addelement_id);
			$djax_query_banners_elements->bindParam(":banner_vast_element_id", $banner_vast_element_id);
			$djax_query_banners_elements->execute();

			$results = json_encode(array ('banner' => $bannerid));

			return $results;
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Campaignid');
			return $this->response->withJson($response);
		}
	}
})->add($container->get('banneraddvastoverlay_val'));


//new vast edit


$app->post('/edit_banner_vastoverlay/[{banner_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$bannerid = $args['banner_id'];
		$datetime = date('Y-m-d H:i:s');
		$paths = dirname(__FILE__);
		$getbanners = "select * from rv_banners where bannerid=:bannerid";
		$djax_query_banner = $this->db->prepare($getbanners);
		$djax_query_banner->bindParam(":bannerid", $bannerid);
		$djax_query_banner->execute();
		$stmtbanner = $djax_query_banner->fetchAll();

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		if (count($stmtbanner) > 0) {
			if (isset ($input['storagetype'])) {
				$storagetype = $input['storagetype'];
			} else {
				$storagetype = $stmtbanner[0]['storagetype'];
			}

			if (isset ($input['width'])) {
				$width = $input['width'];
			} else {
				$width = $stmtbanner[0]['width'];
			}


			if (isset ($input['height'])) {
				$height = $input['height'];
			} else {
				$height = $stmtbanner[0]['height'];
			}

			if (isset ($input['contenttype'])) {
				$contenttype = $input['contenttype'];
			} else {
				$contenttype = $stmtbanner[0]['contenttype'];
			}

			if (isset ($input['description'])) {
				$description = $input['description'];
			} else {
				$description = $stmtbanner[0]['description'];
			}

			if (isset ($input['keyword'])) {
				$keyword = $input['keyword'];
			} else {
				$keyword = $stmtbanner[0]['keyword'];
			}

			if (isset ($input['append'])) {
				$append = $input['append'];
			} else {
				$append = $stmtbanner[0]['append'];
			}
			if (isset ($input['prepend'])) {
				$prepend = $input['prepend'];
			} else {
				$prepend = $stmtbanner[0]['prepend'];
			}

			if (isset ($input['comments'])) {
				$comments = $input['comments'];
			} else {
				$comments = $stmtbanner[0]['comments'];
			}
			if (isset ($input['url'])) {
				$url = $input['url'];
			} else {
				$url = $stmtbanner[0]['url'];
			}
			//url validation
			if (!empty (isset ($input['url']))) {
				if (!filter_var($url, FILTER_VALIDATE_URL)) {

					echo ("Given url  is not a valid URL" . "<br>" . "please make sure your url contains http:// or https://");
					exit;
				}
			}


			//end


			$dbparameters = $stmtbanner[0]['parameters'];
			$unparameters = unserialize($dbparameters);


			if (isset ($input['vast_video_clickthrough_url'])) {
				$vast_video_clickthrough_url = $input['vast_video_clickthrough_url'];
			} else {
				$vast_video_clickthrough_url = $unparameters['vast_video_clickthrough_url'];
			}

			if (isset ($input['vast_thirdparty_clicktracking'])) {
				$vast_thirdparty_clicktracking = $input['vast_thirdparty_clicktracking'];
			} else {
				$vast_thirdparty_clicktracking = $unparameters['vast_thirdparty_clicktracking'];
			}

			if (isset ($input['vast_thirdparty_clickcustom'])) {
				$vast_thirdparty_clickcustom = $input['vast_thirdparty_clickcustom'];
			} else {
				$vast_thirdparty_clickcustom = $unparameters['vast_thirdparty_clickcustom'];
			}

			if (isset ($input['vast_thirdparty_companion_expandedwidth'])) {
				$vast_thirdparty_companion_expandedwidth = $input['vast_thirdparty_companion_expandedwidth'];
			} else {
				$vast_thirdparty_companion_expandedwidth = $unparameters['vast_thirdparty_companion_expandedwidth'];
			}

			if (isset ($input['vast_video_delivery'])) {
				$vast_video_delivery = $input['vast_video_delivery'];
			} else {
				$vast_video_delivery = $unparameters['vast_video_delivery'];
			}

			if (isset ($input['vast_thirdparty_companion_expandedheight'])) {
				$vast_thirdparty_companion_expandedheight = $input['vast_thirdparty_companion_expandedheight'];
			} else {
				$vast_thirdparty_companion_expandedheight = $unparameters['vast_thirdparty_companion_expandedheight'];
			}

			if (isset ($input['vast_companion_banner_id'])) {
				$vast_companion_banner_id = $input['vast_companion_banner_id'];
			} else {
				$vast_companion_banner_id = $unparameters['vast_companion_banner_id'];
			}

			if (isset ($input['vast_thirdparty_impression'])) {
				$vast_thirdparty_impression = $input['vast_thirdparty_impression'];
			} else {
				$vast_thirdparty_impression = $unparameters['vast_thirdparty_impression'];
			}

			if (isset ($input['vast_thirdparty_companion_clicktracking'])) {
				$vast_thirdparty_companion_clicktracking = $input['vast_thirdparty_companion_clicktracking'];
			} else {
				$vast_thirdparty_companion_clicktracking = $unparameters['vast_thirdparty_companion_clicktracking'];
			}

			if (isset ($input['vast_wrapper_url'])) {
				$vast_wrapper_url = $input['vast_wrapper_url'];
			} else {
				$vast_wrapper_url = $unparameters['vast_wrapper_url'];
			}

			if (isset ($input['vast_overlay_version'])) {
				$vast_version = $input['vast_overlay_version'];
			} else {
				$vast_version = $unparameters['vast_overlay_version'];
			}

			if (isset ($input['vast_video_skip_duration'])) {
				$vast_video_skip_duration = $input['vast_video_skip_duration'];
			} else {
				$vast_video_skip_duration = $unparameters['vast_video_skip_duration'];
			}
			if (isset ($input['vast_video_skip_progress_duration'])) {
				$vast_video_skip_progress_duration = $input['vast_video_skip_progress_duration'];
			} else {
				$vast_video_skip_progress_duration = $unparameters['vast_video_skip_progress_duration'];
			}
			if (isset ($input['vast_overlay_expanded_width'])) {
				$vast_overlay_expanded_width = $input['vast_overlay_expanded_width'];
			} else {
				$vast_overlay_expanded_width = $unparameters['vast_overlay_expanded_width'];
			}
			if (isset ($input['vast_overlay_expanded_height'])) {
				$vast_overlay_expanded_height = $input['vast_overlay_expanded_height'];
			} else {
				$vast_overlay_expanded_height = $unparameters['vast_overlay_expanded_height'];
			}
			if (isset ($input['vast_overlay_expandedminduration'])) {
				$vast_overlay_expandedminduration = $input['vast_overlay_expandedminduration'];
			} else {
				$vast_overlay_expandedminduration = $unparameters['vast_overlay_expandedminduration'];
			}

			if (isset ($input['vast_overlay_height'])) {
				$vast_overlay_height = $input['vast_overlay_height'];
			} else {
				$vast_overlay_height = $unparameters['vast_overlay_height'];
			}

			if (isset ($input['vast_overlay_width'])) {
				$vast_overlay_width = $input['vast_overlay_width'];
			} else {
				$vast_overlay_width = $unparameters['vast_overlay_width'];
			}

			if (isset ($input['vast_creative_type'])) {
				$vast_creative_type = $input['vast_creative_type'];
			} else {
				$vast_creative_type = $unparameters['vast_creative_type'];
			}

			if (isset ($input['vast_overlay_wrapper'])) {
				$vast_overlay_wrapper = $input['vast_overlay_wrapper'];
			} else {
				$vast_overlay_wrapper = $unparameters['vast_overlay_wrapper'];
			}


			//url validation
			//~ if (!empty(isset($input['url'])))
			//~ {
			//~ if(!filter_var($url, FILTER_VALIDATE_URL)) {
			//~ 
			//~ echo("Given url  is not a valid URL"."<br>"."please make sure your vast wrapper url(  url) contains http:// or https://");
			//~ exit;
			//~ }
			//~ }
			//url validation

			//~ if (!filter_var($vast_overlay_wrapper, FILTER_VALIDATE_URL)) {
			//~ 
			//~ echo("Given third party url  is not a valid URL"."<br>"."please make sure your vast wrapper url(third party url) contains http:// or https://");
			//~ exit;
			//~ 
			//~ }
			//~ 
			$var = array ();
			$var = array (
				"banner_vast_element_id" => 'banner_vast_element_id',
				"vast_element_type" => 'singlerow',
				"vast_video_id" => 'N',
				"vast_video_delivery" => $vast_video_delivery,
				"vast_thirdparty_clicktracking" => $vast_thirdparty_clicktracking,
				"vast_version" => $vast_version,
				"vast_thirdparty_companion_clicktracking" => $vast_thirdparty_companion_clicktracking,
				"vast_video_skip_duration" => $vast_video_skip_duration,
				"vast_thirdparty_clickcustom" => $vast_thirdparty_clickcustom,
				"vast_video_bitrate" => 400,
				"vast_video_height" => 480,
				"vast_video_width" => 640,
				"vast_wrapper_url" => $vast_wrapper_url,
				"vast_overlay_wrapper" => $vast_overlay_wrapper,
				"vast_overlay_expanded_width" => $vast_overlay_expanded_width,
				"vast_overlay_expanded_height" => $vast_overlay_expanded_height,
				"vast_overlay_expandedminduration" => $vast_overlay_expandedminduration,
				"vast_video_clickthrough_url" => $vast_video_clickthrough_url,
				"vast_thirdparty_companion_expandedwidth" => $vast_thirdparty_companion_expandedwidth,
				"vast_thirdparty_companion_expandedheight" => $vast_thirdparty_companion_expandedheight,
				"vast_video_skip_progress_duration" => $vast_video_skip_progress_duration,
				"vast_overlay_height" => $vast_overlay_height,
				"vast_overlay_width" => $vast_overlay_width,
				"vast_overlay_text_title" => 'N',
				"vast_overlay_text_description" => 'N',
				"vast_overlay_text_call" => 'N',
				"vast_overlay_format" => 'N',
				"vast_overlay_action" => 'N',
				"vast_companion_banner_id" => $vast_companion_banner_id,
				"vast_creative_type" => $vast_creative_type,
				"vast_thirdparty_impression" => $vast_thirdparty_impression
			);

			$parameters = serialize($var);

			$editbanner1 = "update rv_banners set 
				`description`=:description,
				`width`='" . $width . "',
				`height`='" . $height . "',
				`url`='" . $url . "',
				`comments`=:comments,
				`updated`=:updated,
				`keyword`=:keyword,
				`append`=:append,
				`prepend`=:prepend,
				`url`=:url,
				`parameters`=:parameters
				where `bannerid`=:bannerid";

			$djax_query_banners = $this->db->prepare($editbanner1);
			$djax_query_banners->bindParam(":bannerid", $bannerid);
			$djax_query_banners->bindParam(":description", $description);
			$djax_query_banners->bindParam(":comments", $comments);
			$djax_query_banners->bindParam(":updated", $datetime);
			$djax_query_banners->bindParam(":keyword", $keyword);
			$djax_query_banners->bindParam(":append", $append);
			$djax_query_banners->bindParam(":prepend", $prepend);
			$djax_query_banners->bindParam(":url", $url);
			$djax_query_banners->bindParam(":parameters", $parameters);
			$djax_query_banners->execute();

			//~ print_r($vast_version);
			//~ exit;
			$editvastparameters = "update " . $table_prefix . "banner_vast_element set
				`vast_video_delivery`=:vast_video_delivery,
				`vast_wrapper_url`='" . $vast_wrapper_url . "',
				`vast_overlay_wrapper`='" . $vast_overlay_wrapper . "',
				`vast_video_skip_duration`='" . $vast_video_skip_duration . "',
				`vast_video_skip_progress_duration`='" . $vast_video_skip_progress_duration . "',
				`vast_version`='" . $vast_version . "',
				`vast_type`='" . $vast_version . "',
				`vast_overlay_version`='" . $vast_version . "',
				`vast_overlay_height`='" . $vast_overlay_height . "',
				`vast_overlay_width`='" . $vast_overlay_width . "',
				`vast_creative_type`='" . $vast_creative_type . "',
				`vast_thirdparty_clicktracking`='" . $vast_thirdparty_clicktracking . "',
				`vast_thirdparty_clickcustom`='" . $vast_thirdparty_clickcustom . "',
				`vast_thirdparty_companion_clicktracking`='" . $vast_thirdparty_companion_clicktracking . "',
				`vast_thirdparty_companion_expandedwidth`='" . $vast_thirdparty_companion_expandedwidth . "',
				`vast_thirdparty_companion_expandedheight`='" . $vast_thirdparty_companion_expandedheight . "',
				`vast_overlay_expanded_width`='" . $vast_overlay_expanded_width . "',
				`vast_overlay_expanded_height`='" . $vast_overlay_expanded_height . "',
				`vast_overlay_expandedminduration`='" . $vast_overlay_expandedminduration . "',
				`vast_companion_banner_id`=:vast_companion_banner_id,
				`vast_video_clickthrough_url`=:vast_video_clickthrough_url,
				`vast_thirdparty_impression`=:vast_thirdparty_impression where `banner_id`=:banner_id ";

			//~ echo $editvastparameters;
			//~ exit;


			$djax_query_banners_parameters = $this->db->prepare($editvastparameters);
			$djax_query_banners_parameters->bindParam(":vast_video_delivery", $vast_video_delivery);
			$djax_query_banners_parameters->bindParam(":vast_companion_banner_id", $vast_companion_banner_id);
			$djax_query_banners_parameters->bindParam(":vast_video_clickthrough_url", $vast_video_clickthrough_url);
			$djax_query_banners_parameters->bindParam(":vast_thirdparty_impression", $vast_thirdparty_impression);
			//new
			$djax_query_banners->bindParam(":vast_thirdparty_companion_expandedheight", $vast_thirdparty_companion_expandedheight);
			$djax_query_banners->bindParam(":vast_thirdparty_companion_expandedwidth", $vast_thirdparty_companion_expandedwidth);
			$djax_query_banners->bindParam(":vast_thirdparty_clickcustom", $vast_thirdparty_clickcustom);
			$djax_query_banners->bindParam(":vast_thirdparty_clicktracking", $vast_thirdparty_clicktracking);
			$djax_query_banners->bindParam(":vast_version", $vast_version);
			$djax_query_banners->bindParam(":vast_video_skip_progress_duration", $vast_video_skip_progress_duration);
			$djax_query_banners->bindParam(":vast_video_skip_duration", $vast_video_skip_duration);
			$djax_query_banners->bindParam(":vast_wrapper_url", $vast_wrapper_url);
			//end
			$djax_query_banners_parameters->bindParam(":banner_id", $bannerid);
			$djax_query_banners_parameters->execute();

			if (isset ($input['vast_wrapper_url']) && $input['vast_wrapper_url'] == '') {

				$response1 = array ('response' => 'error', 'msg' => 'vast_wrapper_url must not be empty');
				return $this->response->withJson($response1);
			}

			if (isset ($input['description']) && $input['description'] == '') {
				$response2 = array ('response' => 'error', 'msg' => 'description must not be empty');
				return $this->response->withJson($response2);
			}

			if (isset ($input['vast_version']) && $input['vast_version'] == '') {
				$response3 = array ('response' => 'error', 'msg' => 'vast_version must not be empty');
				return $this->response->withJson($response3);
			} else {

				$response = array ('response' => 'ok', 'msg' => 'Banner Updated Successfully');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid bannerid');
			return $this->response->withJson($response);
		}
	}
});


// Invocation Tag generation of VAST VIDEO FEATURES

/*
 * Vast Inline 2.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_inlinevast2/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {


		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		// $tparty 			= (isset($input['thirdparty']))?$input['thirdparty']:'';
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$midrolloffset = (isset ($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$vtype = (isset ($input['vtype'])) ? $input['vtype'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$full_url = $this->get('settings')['path']['delivery'];
		// $full_url=substr($full_url, 0, -5).'delivery';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//~ print_r($vtype);
		//~ exit;
		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//Video position
		if ($vtype == 1) {
			$vtype = "preroll";
		} else if ($vtype == 2) {
			$vtype = "postroll";
		} else {
			$vtype = "preroll";
		}

		//thirdparty validation	 
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Inline 2.0 AD tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];

		$full_url = substr($full_url, 0, -13) . '';
		// print_r($full_url);exit;
		// $vast_inline2=" $cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=$vtype:0.0-0%3D$zoneid&nz=1&source=&ct0=".$cto."&cb=".$cb."&midrolloffset=".$midrolloffset."&r=R0.05822725687175989&block=1&format=vast2&charset=UTF-8&loc=".$vast_validator."";

		//https://rvphp.djaxbidder.com/Overon_restapi/fc.php?script=rmVideo&zoneid=3&type=postroll&format=vast2
		$vast_inline2 = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=vast2&type=$vtype";
		$res = array (
			'response' => 'tag',
			'Vast_Inline2_Invocation_tag' => $vast_inline2

		);


		return $this->response->withJson($res);

		//return $res;
	}
});


/*
 * Vast Inline 3.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_inlinevast3/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {


		$input = $request->getParsedBody();
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$midrolloffset = (isset ($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$vtype = (isset ($input['vtype'])) ? $input['vtype'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';

		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//Video position
		if ($vtype == 1) {
			$vtype = "preroll";
		} else if ($vtype == 2) {
			$vtype = "postroll";
		} else {
			$vtype = "preroll";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Inline 3.0 AD tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}


		// $vast_inline3="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=$vtype:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&midrolloffset=".$midrolloffset."&r=R0.05822725687175989&block=1&format=vast3&charset=UTF-8&loc=".$vast_validator."";

		$vast_inline3 = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=vast3&type=$vtype";

		$res = array (
			'response' => 'tag',
			'Vast Inline 3.0 Invocation tag' => $vast_inline3

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});

/*
 * Vast Inline Wrapper 2.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_inlinevastwrapper2/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];


		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$midrolloffset = (isset ($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$vtype = (isset ($input['vtype'])) ? $input['vtype'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';
		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//Video position
		if ($vtype == 1) {
			$vtype = "preroll";
		} else if ($vtype == 2) {
			$vtype = "postroll";
		} else {
			$vtype = "preroll";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Inline Wrapper 2.0 AD tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		//https://rvphp.djaxbidder.com/Overon_restapi/fc.php?script=rmVideo&zoneid=3&format=vast2_wrapper

		// $vast_inlinewrapper2="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=$vtype:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&midrolloffset=".$midrolloffset."&r=R0.05822725687175989&block=1&format=vast2_wrapper&charset=UTF-8&loc=".$vast_validator."";

		$vast_inlinewrapper2 = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=vast2_wrapper";

		$res = array (
			'response' => 'tag',
			'Vast Inline Wrapper 2.0 Invocation tag' => $vast_inlinewrapper2

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});

/*
 * Vast Inline Wrapper 3.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_inlinevastwrapper3/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$midrolloffset = (isset ($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$vtype = (isset ($input['vtype'])) ? $input['vtype'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';
		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//Video position
		if ($vtype == 1) {
			$vtype = "preroll";
		} else if ($vtype == 2) {
			$vtype = "postroll";
		} else {
			$vtype = "preroll";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Inline Wrapper 3.0 AD tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		//~ $full_url = $this->get('settings')['path']['delivery'];

		// $vast_inlinewrapper3="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=$vtype:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&midrolloffset=".$midrolloffset."&r=R0.05822725687175989&block=1&format=vast3_wrapper&charset=UTF-8&loc=".$vast_validator."";

		$vast_inlinewrapper3 = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=vast3_wrapper&type=$vtype";

		$res = array (
			'response' => 'tag',
			'Vast Inline Wrapper 3.0 Invocation tag' => $vast_inlinewrapper3

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast INLINE AD POT tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_vastadpod/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$midrolloffset = (isset ($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$vtype = (isset ($input['vtype'])) ? $input['vtype'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$limit = (isset ($input['limit'])) ? $input['limit'] : '';
		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';
		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//limit validation

		if ($limit) {
			$limit = $limit;
		} else {
			$limit = '';
		}

		//ends
		//Video position
		if ($vtype == 1) {
			$vtype = "preroll";
		} else if ($vtype == 2) {
			$vtype = "postroll";
		} else {
			$vtype = "preroll";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Ad Pod tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		//~ $full_url = $this->get('settings')['path']['delivery'];

		// $vastadpod="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=$vtype:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&midrolloffset=".$midrolloffset."&r=R0.05822725687175989&block=1&limit=$limit&format=vast_pod&charset=UTF-8&loc=".$vast_validator."";

		// https://rvphp.djaxbidder.com/Overon_restapi/fc.php?script=rmVideo&type=postroll&zoneid=3&limit=&format=vast_pod
		$vastadpod = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&limit=$limit&format=vast_pod&type=$vtype";

		$res = array (
			'response' => 'tag',
			'Vast Ad Pod tag' => $vastadpod

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});



/*
 * Vast INLINE AD POT WRAPPER tag
 * 
 * Input Parameters:
 * --------------- 
 * vtype 
 * comments
 * midrolloffset
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_vastadpodwrapper/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$midrolloffset = (isset ($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$vtype = (isset ($input['vtype'])) ? $input['vtype'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$limit = (isset ($input['limit'])) ? $input['limit'] : '';
		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';
		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends
		//limit validation

		if ($limit) {
			$limit = $limit;
		} else {
			$limit = '';
		}

		//ends
		//Video position
		if ($vtype == 1) {
			$vtype = "preroll";
		} else if ($vtype == 2) {
			$vtype = "postroll";
		} else {
			$vtype = "preroll";
		}

		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Ad Pod Wrapper tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}
		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';

		// $vastadpodwrapper="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=$vtype:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&midrolloffset=".$midrolloffset."&r=R0.05822725687175989&block=1&limit=$limit&format=vast_pod_wrapper&charset=UTF-8&loc=".$vast_validator."";

		//https://rvphp.djaxbidder.com/Overon_restapi/fc.php?script=rmVideo&zoneid=3&limit=&type=postroll&format=vast_pod_wrapper

		$vastadpodwrapper = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&limit=$limit&format=vast_pod_wrapper&type=$vtype";

		$res = array (
			'response' => 'tag',
			'Vast Ad Pod Wrapper tag' => $vastadpodwrapper

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});


/*
 * INLINE JW PLAYER SETUP
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_inlinejwplayer/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vastadformat = (isset ($input['vastadformat'])) ? $input['vastadformat'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		$adposition = (isset ($input['adposition'])) ? $input['adposition'] : '';
		$midrolloffset = (isset ($input['midrolloffset'])) ? $input['midrolloffset'] : '';
		$videoimage = (isset ($input['videoimage'])) ? $input['videoimage'] : '';
		$videofile = (isset ($input['videofile'])) ? $input['videofile'] : '';
		$videowidth = (isset ($input['videowidth'])) ? $input['videowidth'] : '';
		$videoheight = (isset ($input['videoheight'])) ? $input['videoheight'] : '';
		$aspectratio = (isset ($input['aspectratio'])) ? $input['aspectratio'] : '';
		$autoplay = (isset ($input['autoplay'])) ? $input['autoplay'] : '';
		$companion = (isset ($input['companion'])) ? $input['companion'] : '';
		$companionwidth = (isset ($input['companionwidth'])) ? $input['companionwidth'] : '';
		$companionheight = (isset ($input['companionheight'])) ? $input['companionheight'] : '';
		$repeat = (isset ($input['repeat'])) ? $input['repeat'] : '';
		$skipoffset = (isset ($input['skipoffset'])) ? $input['skipoffset'] : '';
		$mute = (isset ($input['mute'])) ? $input['mute'] : '';
		//  $limit	= (isset($input['limit']))?$input['limit']:'';
		$comments = (isset ($input['comments'])) ? $input['comments'] : '';


		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}




		//third party validation
		if ($tparty == 1) {
			//Generic
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($tparty == 2) {
			//AOL

			$tparty = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($tparty == 3) {
			//Adform
			$tparty = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($tparty == 4) {
			//Appnexus

			$tparty = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($tparty == 5) {
			//DCM

			$tparty = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($tparty == 6) {
			//Double click

			$tparty = "%c";
			$cb = "%n";
		} else if ($tparty == 7) {
			//Open ad stream

			$tparty = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($tparty == 8) {
			//Revive adserver

			$tparty = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($tparty == 9) {
			//Sizmek

			$tparty = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($tparty == 10) {
			//Sizmek

			$tparty = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}


		//limit validation
		//~ if($limit)
		//~ {
		//~ $limit = $limit;
		//~ }
		//~ else
		//~ {
		//~ $limit='15';
		//~ }
		//mute validation
		if ($mute) {
			$mute = $mute;
		} else {
			$mute = '0';
		}

		//adposition validation



		//vastadformat validation
		if ($vastadformat) {
			$vastadformat = $vastadformat;
		} else {
			$vastadformat = 'vast2';
		}
		//companion validation
		if ($companion) {
			$companion = $companion;
		} else {
			$companion = '0';
		}

		//companionwidth validation
		if ($companionwidth) {
			$companionwidth = $companionwidth;
		} else {
			$companionwidth = '';
		}
		//companionheight validation
		if ($companionheight) {
			$companionheight = $companionheight;
		} else {
			$companionheight = '';
		}

		//repeat validation
		if ($repeat) {
			$repeat = $repeat;
		} else {
			$repeat = '0';
		}
		//skipoffset validation
		if ($skipoffset) {
			$skipoffset = $skipoffset;
		} else {
			$skipoffset = '';
		}

		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Inline JW Player tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		//invocation code setup
		$co = '"';
		//~ $a= '"<" + "script language='JavaScript' "';
		//~ $b= "type='text/javascript' src='";

		//setup ends




		$full_url = $this->get('settings')['path']['delivery'];
		//$full_url=substr($full_url, 0, -5).'delivery';

		$vastinlinejwplayer = "
			<script type='text/javascript'><!--//<![CDATA[
			var adurl = (location.protocol=='https:'?'https://$full_url/videoadsjs.php':'http://$full_url/videoadsjs.php');
			
			document.write (" . $co . "<" . $co . " + " . $co . "script language='JavaScript' " . $co . ");
			document.write (" . $co . "type='text/javascript' src='" . $co . "+adurl);document.write ('?zoneid=$zoneid&amp;cb=" . $cb . "&amp;ct0=" . $tparty . "&amp;videofile=$videofile&amp;videoimage=$videoimage&amp;videowidth=$videowidth&amp;videoheight=$videoheight&amp;aspectratio=$aspectratio&amp;autoplay=$autoplay&amp;companion=$companion&amp;companionwidth=$companionwidth&amp;companionheight=$companionheight&amp;repeat=$repeat&amp;skipoffset=$skipoffset&amp;mute=$mute&amp;primary=flash&amp;adposition=1&amp;vastadformat=$vastadformat&amp;midrolloffset=$midrolloffset');
			document.write ('&amp;loc=' + escape(window.location));
			if (document.referrer) document.write ('&amp;referer=' + escape(document.referrer));
			document.write (" . $co . "'><\/scr" . $co . "+" . $co . "ipt>" . $co . ");
			//]]>--></script>
			";

		$res = array (
			'response' => 'tag',
			'Vast Inline JW Player Ad tag' => $vastinlinejwplayer

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast OVERLAY 2.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_vastoverlay2/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		//~ $midrolloffset 			= (isset($input['midrolloffset']))?$input['midrolloffset']:'';
		//~ $vtype 			= (isset($input['vtype']))?$input['vtype']:'';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';


		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends


		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Overlay 2.0 tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';

		// $vastoverlay2="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=overlay:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&r=R0.05822725687175989&block=1&format=vast2&charset=UTF-8&loc=".$vast_validator."";

		// https://rvphp.djaxbidder.com/Overon_restapi/fc.php?script=rmVideo&type=&zoneid=4&format=vast2

		$vastoverlay2 = "https://$full_url/fc.php?script=rmVideo&type=&zoneid=$zoneid&format=vast2";

		$res = array (
			'response' => 'tag',
			'Vast Overlay 2.0' => $vastoverlay2

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast OVERLAY 3.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_vastoverlay3/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';


		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends


		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//~ 
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Overlay 3.0 tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';

		// $vastoverlay3="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=overlay:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&r=R0.05822725687175989&block=1&format=vast3&charset=UTF-8&loc=".$vast_validator."";

		$vastoverlay3 = "https://$full_url/fc.php?script=rmVideo&type=&zoneid=$zoneid&format=vast3";


		$res = array (
			'response' => 'tag',
			'Vast Overlay 3.0' => $vastoverlay3

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast OVERLAY Wrapper 3.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_vastoverlaywrapper3/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		//  $limit 			= (isset($input['limit']))?$input['limit']:'';


		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends


		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//limit validation
		//~ if($limit)
		//~ {
		//~ $limit = $limit;
		//~ }
		//~ else
		//~ {
		//~ $limit='15';
		//~ }
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Overlay wrapper 3.0 tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';

		// $vastoverlaywrapper3="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=overlay:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&r=R0.05822725687175989&block=1&format=vast3_wrapper&charset=UTF-8&loc=".$vast_validator."";

		//https://rvphp.djaxbidder.com/Overon_restapi/fc.php?script=rmVideo&zoneid=4&format=vast3_wrapper

		$vastoverlaywrapper3 = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&format=vast3_wrapper";

		$res = array (
			'response' => 'tag',
			'Vast Overlay Wrapper 3.0' => $vastoverlaywrapper3

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});


/*
 * Vast OVERLAY Wrapper 2.0 tag
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_vastoverlaywrapper2/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$cto = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		//  $limit 			= (isset($input['limit']))?$input['limit']:'';
		$vast_validator = (isset ($input['playerurl'])) ? $input['playerurl'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';


		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}

		//vast validation

		if ($vast_validator) {
			$vast_validator = $vast_validator;
		} else {
			$vast_validator = '"+window.location.hostname+"';
		}

		//ends


		//third party validation
		if ($cto == 1) {
			//Generic
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 2) {
			//AOL

			$cto = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($cto == 3) {
			//Adform
			$cto = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 4) {
			//Appnexus

			$cto = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($cto == 5) {
			//DCM

			$cto = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($cto == 6) {
			//Double click

			$cto = "%c";
			$cb = "%n";
		} else if ($cto == 7) {
			//Open ad stream

			$cto = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($cto == 8) {
			//Revive adserver

			$cto = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($cto == 9) {
			//Sizmek

			$cto = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($cto == 10) {
			//Sizmek

			$cto = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$cto = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}

		//limit validation
		//~ if($limit)
		//~ {
		//~ $limit = $limit;
		//~ }
		//~ else
		//~ {
		//~ $limit='15';
		//~ }
		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Overlay wrapper 2.0 tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}

		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -13) . '';

		// $vastoverlaywrapper2="$cmnd http://$full_url/fc.php?script=bannerTypeHtml:vastInlineBannerTypeHtml:vastInlineHtml&zones=overlay:0.0-0%3D$zoneid&nz=1&source=&ct0=$cto&cb=$cb&r=R0.05822725687175989&block=1&format=vast2_wrapper&charset=UTF-8&loc=".$vast_validator."";

		//https://rvphp.djaxbidder.com/Overon_restapi/fc.php?script=rmVideo&zoneid=4&type=&format=vast2_wrapper

		$vastoverlaywrapper2 = "https://$full_url/fc.php?script=rmVideo&zoneid=$zoneid&type=&format=vast2_wrapper";

		$res = array (
			'response' => 'tag',
			'Vast Overlay Wrapper 2.0' => $vastoverlaywrapper2

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});

/*
 * OVERLAY JW PLAYER SETUP
 * 
 * Input Parameters:
 * --------------- 
 * comments
 * playerurl
 * tparty 
 */

$app->post('/vast_invoke_overlayjwplayer/[{zoneid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');


		return $this->response->withJson($errors);

		return $response;
	} else {

		//  $input = $request->getParsedBody();     
		$sql = "select zoneid,width,height from rv_zones WHERE zoneid=:zoneid";
		$sth = $this->db->prepare($sql);
		$sth->bindParam("zoneid", $args['zoneid']);
		$sth->execute();
		$zoneav = $sth->fetchAll();
		$zoneid = $args['zoneid'];

		$input = $request->getParsedBody();
		$tparty = (isset ($input['thirdparty'])) ? $input['thirdparty'] : '';
		$overlayvastadformat = (isset ($input['overlayvastadformat'])) ? $input['overlayvastadformat'] : '';
		$cmnd = (isset ($input['comments'])) ? $input['comments'] : '';
		//  $adposition 			= (isset($input['adposition']))?$input['adposition']:'';
		//  $midrolloffset 			= (isset($input['midrolloffset']))?$input['midrolloffset']:'';
		$videoimage = (isset ($input['videoimage'])) ? $input['videoimage'] : '';
		$videofile = (isset ($input['videofile'])) ? $input['videofile'] : '';
		$videowidth = (isset ($input['videowidth'])) ? $input['videowidth'] : '';
		$videoheight = (isset ($input['videoheight'])) ? $input['videoheight'] : '';
		$aspectratio = (isset ($input['aspectratio'])) ? $input['aspectratio'] : '';
		$autoplay = (isset ($input['autoplay'])) ? $input['autoplay'] : '';
		$companion = (isset ($input['companion'])) ? $input['companion'] : '';
		$companionwidth = (isset ($input['companionwidth'])) ? $input['companionwidth'] : '';
		$companionheight = (isset ($input['companionheight'])) ? $input['companionheight'] : '';
		$repeat = (isset ($input['repeat'])) ? $input['repeat'] : '';
		$overlayoffset = (isset ($input['overlayoffset'])) ? $input['overlayoffset'] : '';
		// $mute	= (isset($input['mute']))?$input['mute']:'';
		//  $limit	= (isset($input['limit']))?$input['limit']:'';
		$comments = (isset ($input['comments'])) ? $input['comments'] : '';


		if (!$zoneav) {
			$res = array (
				'response' => 'Error',
				'msg' => 'Zone is Not Avaliable'

			);
			return $this->response->withJson($res);
		}




		//third party validation
		if ($tparty == 1) {
			//Generic
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($tparty == 2) {
			//AOL

			$tparty = "_ADCLICKESC_";
			$cb = "%na";
		} else if ($tparty == 3) {
			//Adform
			$tparty = "%%c1";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($tparty == 4) {
			//Appnexus

			$tparty = '${CLICK_URL_ENC}';
			$cb = '${CACHEBUSTER}';
		} else if ($tparty == 5) {
			//DCM

			$tparty = "%%CLICK_URL_UNESC%%";
			$cb = "%%CACHEBUSTER%%";
		} else if ($tparty == 6) {
			//Double click

			$tparty = "%c";
			$cb = "%n";
		} else if ($tparty == 7) {
			//Open ad stream

			$tparty = "%%C%%";
			$cb = "%%RAND%%";
		} else if ($tparty == 8) {
			//Revive adserver

			$tparty = "{clickurl_enc}";
			$cb = "{random}";
		} else if ($tparty == 9) {
			//Sizmek

			$tparty = "%%CLICKLINK%%";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		} else if ($tparty == 10) {
			//Sizmek

			$tparty = '${CLICK_URL}';
			$cb = '${CACHEBUSTER}';
		} else {
			$tparty = "INSERT_ENCODED_CLICKURL_HERE";
			$cb = "INSERT_RANDOM_NUMBER_HERE";
		}


		//limit validation
		//~ if($limit)
		//~ {
		//~ $limit = $limit;
		//~ }
		//~ else
		//~ {
		//~ $limit='15';
		//~ } 
		//vastadformat validation
		if ($overlayvastadformat) {
			$overlayvastadformat = $overlayvastadformat;
		} else {
			$overlayvastadformat = 'vast2';
		}
		//companion validation
		if ($companion) {
			$companion = $companion;
		} else {
			$companion = '0';
		}

		//companionwidth validation
		if ($companionwidth) {
			$companionwidth = $companionwidth;
		} else {
			$companionwidth = '';
		}
		//companionheight validation
		if ($companionheight) {
			$companionheight = $companionheight;
		} else {
			$companionheight = '';
		}

		//repeat validation
		if ($repeat) {
			$repeat = $repeat;
		} else {
			$repeat = '0';
		}
		//skipoffset validation
		if ($overlayoffset) {
			$overlayoffset = $overlayoffset;
		} else {
			$overlayoffset = '';
		}

		//source validation
		if ($cmnd == 1) {

			$cmnd = "<!--/*
				*
				* Revive Adserver Vast Overlay JW Player tag
				
				*
				*/-->
				
				<!--/*  * Replace all instances of INSERT_RANDOM_NUMBER_HERE with
				* a generated random number (or timestamp).
				*
				*/-->";
		} else {
			$cmnd = "";
		}


		//invocation code setup
		$co = '"';
		//setup ends



		$full_url = $this->get('settings')['path']['delivery'];
		$full_url = substr($full_url, 0, -5) . 'delivery';

		$vastoverlayjwplayer = "
			<script type='text/javascript'><!--//<![CDATA[
			var adurl = (location.protocol=='https:'?'https://$full_url/videoadsoverlayjs.php':'http://$full_url/videoadsoverlayjs.php');
			
			document.write (" . $co . "<" . $co . " + " . $co . "script language='JavaScript' " . $co . ");
			document.write (" . $co . "type='text/javascript' src='" . $co . "+adurl);document.write ('?zoneid=$zoneid&amp;cb=" . $cb . "&amp;ct0=" . $tparty . "?&amp;videofile=" . $videofile . "&amp;videoimage=" . $videoimage . "&amp;videowidth=" . $videowidth . "&amp;videoheight=" . $videoheight . "&amp;aspectratio=" . $aspectratio . "&amp;autoplay=" . $autoplay . "&amp;companion=" . $companion . "&amp;companionwidth=" . $companionwidth . "&amp;companionheight=" . $companionheight . "&amp;primary=flash&amp;adposition=1&amp;overlayvastadformat=" . $overlayvastadformat . "&amp;overlayoffset=" . $overlayoffset . "');
			document.write ('&amp;loc=' + escape(window.location));
			if (document.referrer) document.write ('&amp;referer=' + escape(document.referrer));
			document.write (" . $co . "'><\/scr" . $co . "+" . $co . "ipt>" . $co . ");
			//]]>--></script>
			";

		$res = array (
			'response' => 'tag',
			'Vast Overlay JW Player Ad tag' => $vastoverlayjwplayer

		);


		return stripcslashes($this->response->withJson($res));

		return $response;
	}
});
$app->post('/bannerunlink_sizechanged/[{bannerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];

		$deleteaccounts = "DELETE FROM " . $table_prefix . "ad_zone_assoc WHERE ad_id=:bannerid";
		$djax_query_deleteaccount = $this->db->prepare($deleteaccounts);
		$djax_query_deleteaccount->bindParam(":bannerid", $bannerid);

		$banner_del = $djax_query_deleteaccount->execute();

		$response = array (
			'response' => 'ok',
			'msg' => 'Zones Unlinked successfully!'
		);
	}
	return $this->response->withJson($response);
});

//user access
$app->get('/get_all_user_details/[{agencyid}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$agencyid = $args['agencyid'];

	$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
            " . $table_prefix . "agency as ag
			where
			ag.account_id = a.account_id
			AND a.preference_id = 16
			AND ag.agencyid =$agencyid";
	$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
	$TimeZonestd->execute();

	$TimeZoneRow = $TimeZonestd->fetchAll();


	if ($TimeZoneRow) {

		$timezone = $TimeZoneRow[0]['timezone'];
	} else {

		$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
		$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
		$TimeZonestd->execute();
		$TimeZoneRow = $TimeZonestd->fetchAll();
		if($TimeZoneRow){
			$timezone = $TimeZoneRow[0]['timezone'];
			}
			else{
				$timezone = 'UTC';

			}
	}
	if($timezone=='0'){
		$timezone = 'UTC';

	}
	else{
		$timezone = $timezone;

	}

	date_default_timezone_set($timezone);


	// $date1 = date("d-m-Y H:i:s");
	// date_default_timezone_set('UTC');
	// $date2 = date("d-m-Y H:i:s");
	// $time_diff = strtotime($date1) - strtotime($date2);
	// $date3 = date('H:i', $time_diff);

	// $date4 = '+'.$date3;


	$tz = new DateTimeZone($timezone);
	$offset = $tz->getOffset(new DateTime());

	// Convert offset to hours and minutes
	$offsetHours = floor($offset / 3600);
	$offsetMinutes = floor(($offset % 3600) / 60);

	// Determine the GMT offset string
	$gmtOffset = sprintf('%+03d:%02d', $offsetHours, $offsetMinutes);

	$stc = "select age.account_id,usr.user_id,usr.contact_name,usr.username,usr.email_address,usr.language,DATE_FORMAT(CONVERT_TZ(usr.date_created,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as date_created,usr.date_last_login from " . $table_prefix . "agency age LEFT JOIN " . $table_prefix . "users usr on age.account_id = usr.default_account_id where agencyid=:agencyid";
	$std = $this->db->prepare($stc);
	$std->bindParam("agencyid", $agencyid);
	$std->execute();
	$users = $std->fetchAll();
	if ($users) {

		foreach ($users as $userdetail) {

			$adv_det[] =
				array (
					'user_id' => $userdetail['user_id'],
					'contact_name' => $userdetail['contact_name'],
					'username' => $userdetail['username'],
					'email_address' => $userdetail['email_address'],
					'language' => $userdetail['language'],
					'date_created' => $userdetail['date_created'],
					'date_last_login' => $userdetail['date_last_login']
				);
		}
		$response = array ('data' => $adv_det, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
		return $this->response->withJson($response);
	} else {
		$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser id!');
		return $this->response->withJson($response);
	}
});

// User Access Details
$app->get('/get_user_details/[{user_id}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$user_id = $args['user_id'];
	$stc = "select age.account_id,usr.* from " . $table_prefix . "agency age LEFT JOIN " . $table_prefix . "users usr on age.account_id = usr.default_account_id where usr.user_id=:user_id";
	$std = $this->db->prepare($stc);
	$std->bindParam("user_id", $user_id);
	$std->execute();
	$users = $std->fetchAll();
	if ($users) {

		$adv_det =
			array (
				'contact_name' => $users[0]['contact_name'],
				'username' => $users[0]['username'],
				'email_address' => $users[0]['email_address'],
				'language' => $users[0]['language'],
				'date_created' => $users[0]['date_created'],
				'date_last_login' => $users[0]['date_last_login']
			);
		return $this->response->withJson($adv_det);
	} else {
		$response = array ('response' => 'error', 'msg' => 'Please enter valid Advertiser id!');
		return $this->response->withJson($response);
	}
});

$app->get('/get_adv_user_details/[{clientid}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$clientid = $args['clientid'];
	$stc = "select clt.account_id,usr.* from " . $table_prefix . "clients clt LEFT JOIN " . $table_prefix . "users usr on clt.account_id = usr.default_account_id where clientid=:clientid";
	$std = $this->db->prepare($stc);
	$std->bindParam("clientid", $clientid);
	$std->execute();
	$users = $std->fetchAll();

	if ($users) {

		$adv_det =
			array (
				'contact_name' => $users[0]['contact_name'],
				'username' => $users[0]['username'],
				'email_address' => $users[0]['email_address'],
				'language' => $users[0]['language'],
				'date_created' => $users[0]['date_created'],
				'date_last_login' => $users[0]['date_last_login']
			);
		return $this->response->withJson($adv_det);
	} else {
		$response = array ('response' => 'error', 'msg' => 'Please enter valid client id!');
		return $this->response->withJson($response);
	}
});

$app->get('/get_permissions_old/[{user_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$userid = $args['user_id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$uservalue = "SELECT account_id,user_id,permission_id,is_allowed FROM " . $table_prefix . "account_user_permission_assoc where user_id=:user_id";
		$djax_query_uservalue = $this->db->prepare($uservalue);
		$djax_query_uservalue->bindParam(":user_id", $userid);
		$djax_query_uservalue->execute();

		$users = $djax_query_uservalue->fetchAll();
		//print_r($users);
		if ($users) {

			foreach ($users as $adv) { //$adv['clientid']
				$adv_list[] = $adv;
			}
			$response = array ('data' => $adv_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'There is no permission exists under this requested id!'
			);
			return $this->response->withJson($response);
		}
	}
});

$app->get('/get_permissions/[{user_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$userid = $args['user_id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$uservalue = "SELECT permission_id FROM " . $table_prefix . "account_user_permission_assoc where user_id=:user_id";
		$djax_query_uservalue = $this->db->prepare($uservalue);
		$djax_query_uservalue->bindParam(":user_id", $userid);
		$djax_query_uservalue->execute();

		$users = $djax_query_uservalue->fetchAll();
		//print_r($users);
		if ($users) {

			foreach ($users as $adv) { //$adv['clientid']
				$perm_list[] = $adv['permission_id'];
			}
			$_SESSION['user_permission'] = implode(",", $perm_list);
			$response = array ('data' => $perm_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
		} else {
			$_SESSION['user_permission'] = '';
			$response = array (
				'response' => 'Error',
				'msg' => 'There is no permission exists under this requested id!'
			);
			return $this->response->withJson($response);
		}
	}
});

$app->post('/update_user/[{username},{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$results = array ();
		$username = $args['username'];
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$userid = $input['check_val'];
		$getid = explode(',', $userid);
		//print_r($getid);exit("ok");
		$stc = "select account_id from {$table_prefix}agency where agencyid=$agencyid";
		$userper = $this->db->prepare($stc);
		$userper->execute();
		$percount = $userper->fetchAll();
		$account_id = $percount[0]['account_id'];

		$stcuser = "select user_id from {$table_prefix}users where username=:username";
		$userper1 = $this->db->prepare($stcuser);
		$userper1->bindParam(":username", $username);
		$userper1->execute();
		$percount1 = $userper1->fetchAll();

		$user_id = $percount1[0]['user_id'];

		$executionid = "Delete from " . $table_prefix . "account_user_permission_assoc where user_id=$user_id";
		$bnr = $this->db->prepare($executionid);
		$bnr->execute();
		$value = "select * from {$table_prefix}account_user_permission_assoc where user_id=:user_id";
		$user_data = $this->db->prepare($value);
		$user_data->bindParam(":user_id", $user_id);
		$user_data->execute();
		$stmt = $user_data->fetchAll();

		foreach ($getid as $permission) {
			if ($permission) {
				$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(account_id, user_id, permission_id, is_allowed) VALUES
		(:account_id,:user_id,:permission_id,1);";
				$assoc = $this->db->prepare($userper_assc);
				$assoc->bindParam(":account_id", $account_id);
				$assoc->bindParam(":user_id", $user_id);
				$assoc->bindParam(":permission_id", $permission);
				$assoc->execute();
			}
		}
		$response = array ('response' => 'ok', 'msg' => 'user permission has been updated successfully!');
		return $this->response->withJson($response);
	}
});

$app->post('/banner_autolink/[{bannerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$bannerid = $args['bannerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		$bannerval = "select * from {$table_prefix}banners where bannerid=:bannerid";
		$djax_query_bannerval = $this->db->prepare($bannerval);
		$djax_query_bannerval->bindParam(":bannerid", $bannerid);
		$djax_query_bannerval->execute();
		$stmtbannervalue = $djax_query_bannerval->fetchAll();

		$id = $stmtbannervalue[0]['campaignid'];
		$banwidth = $stmtbannervalue[0]['width'];
		$banheight = $stmtbannervalue[0]['height'];

		$stc = "SELECT zone_id FROM " . $table_prefix . "placement_zone_assoc where placement_id=$id";
		$std = $this->db->prepare($stc);
		$std->execute();
		$campaign_det = $std->fetchAll();
		$placementcount = count($campaign_det);

		foreach ($campaign_det as $pubval) {
			$zone_id = $pubval['zone_id'];
			$zonevalue = "select zon.zoneid,zon.zonename,zon.width,zon.height,zon.delivery,zon.description from {$table_prefix}zones zon where zon.zoneid=$zone_id and zon.width=$banwidth and zon.height=$banheight";
			$djax_query_zonevalue = $this->db->prepare($zonevalue);
			$djax_query_zonevalue->execute();
			$stmtzonevalue = $djax_query_zonevalue->fetchAll();
			//print_r($stmtzonevalue);
			$zonwidth = $stmtzonevalue[0]['width'];
			$zonheight = $stmtzonevalue[0]['height'];

			if ($zonwidth == $banwidth && $zonheight == $banheight) {
				$zone_id = $pubval['zone_id'];
				$selban = "select * from {$table_prefix}ad_zone_assoc where zone_id=:zoneid and ad_id=:ad_id";
				$zonedetail = $this->db->prepare($selban);
				$zonedetail->bindParam(":zoneid", $zone_id);
				$zonedetail->bindParam(":ad_id", $bannerid);
				$zonedetail->execute();
				$valrow = $zonedetail->fetchAll();
				$valcount = count($valrow);
				if ($valcount == 0) {
					$linkzone = "INSERT INTO {$table_prefix}ad_zone_assoc(`zone_id`,`ad_id`,`priority`,`link_type`,`priority_factor`,`to_be_delivered`) VALUES (:zoneid,:bannerid,0,1,1,1)";
					$linkzonebyad = $this->db->prepare($linkzone);
					$linkzonebyad->bindParam(":zoneid", $zone_id);
					$linkzonebyad->bindParam(":bannerid", $bannerid);
					$linkzonebyad->execute();

					$response = array ('Message' => "Banner linked successfully to the Zone");
				} else {
					$response = array ('ERROR' => 'Banner already linked with zone');
				}
			}
		}
		return $this->response->withJson($response);
	}
});

//Campaign Delivery Capping in Banner

$app->get('/get_campaign_del_capping/[{banner_id}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$bannerid = $args['banner_id'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$capvalue = "SELECT ban.campaignid,cam.capping,cam.session_capping,cam.block,cam.clientid FROM " . $table_prefix . "banners ban LEFT JOIN " . $table_prefix . "campaigns cam on cam.campaignid = ban.campaignid where bannerid=:bannerid";
		$djax_query_capvalue = $this->db->prepare($capvalue);
		$djax_query_capvalue->bindParam(":bannerid", $bannerid);
		$djax_query_capvalue->execute();
		$delcapvalue = $djax_query_capvalue->fetchAll();

		if ($delcapvalue) {

			$del_capping =
				array (
					'campaignid' => $delcapvalue[0]['campaignid'],
					'capping' => $delcapvalue[0]['capping'],
					'session_capping' => $delcapvalue[0]['session_capping'],
					'block' => $delcapvalue[0]['block'],
					'clientid' => $delcapvalue[0]['clientid'],
				);
			return $this->response->withJson($del_capping);
		} else {
			$results = array ('response' => 'Error', 'ERROR' => 'Not found');
			return $this->response->withJson($results);
		}
	}
});

$app->post('/advertiser_add_new/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array ('response' => 'error', 'msg' => 'Please check with input mandatory parameters and format of input');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$contactname = $input['contact'];
		$contact = $contactname;
		$email = $input['email'];
		$clientname = $input['clientname'];

		// $clientname   = $input['name'];
		$report = $input['report'];
		$reportinterval = $input['reportinterval'];
		$reportdeactivate = $input['reportdeactivate'];

		$datetime = date('Y-m-d H:i:s');
		$date = date('Y-m-d');
		$agencyid = $args['agencyid'];

		//validate for reqiured information  

		if (empty ($clientname) || empty ($contact) || empty ($email)) {
			$results = array ('response' => 'error', 'msg' => 'Please enter all data');
			return $this->response->withJson($response);
		}

		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}

		if ($reportinterval < 0) {
			$results = array ('response' => 'error', 'msg' => 'Please enter positive numbers only');
			return $this->response->withJson($response);
		}

		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetchAll();
		//print_r($check);exit("ok");
		$checkcount = count($check);
		//print_r($checkcount);exit("ok"); 
		if ($checkcount > 0) {
			$addacc = "INSERT INTO " . $table_prefix . "accounts (`account_type`, `account_name`) VALUES ('ADVERTISER',:clientname);";
			$acc = $this->db->prepare($addacc);
			$acc->bindParam(":clientname", $clientname);
			$acc->execute();

			$account_id = $this->db->lastInsertId();
			//print_r($account_id);exit("ok");
			$addcl = "INSERT INTO " . $table_prefix . "clients (`agencyid`, `clientname`, `contact`, 
`email`,`report`,`reportinterval`,`reportlastdate`,`reportdeactivate`,`updated`,`account_id`) VALUES (:agencyid,:clientname,:contact,
:email,:report,:reportinterval,:reportlastdate,:reportdeactivate,:updated,:acccountid);";

			$adv = $this->db->prepare($addcl);
			$adv->bindParam(":agencyid", $agencyid);
			$adv->bindParam(":contact", $contact);
			// $adv->bindParam(":name",$clientname);

			$adv->bindParam(":clientname", $clientname);
			$adv->bindParam(":email", $email);
			$adv->bindParam(":report", $report);
			$adv->bindParam(":reportinterval", $reportinterval);
			$adv->bindParam(":reportlastdate", $date);
			$adv->bindParam(":reportdeactivate", $reportdeactivate);
			$adv->bindParam(":updated", $datetime);
			$adv->bindParam(":acccountid", $account_id);
			$adv->execute();

			$client_id = $this->db->lastInsertId();
			if ($client_id) {
			//audit log maintain
			$create_user_id = $_SESSION['user_id'];
			$module = 'clients_'.$clientname.'_'.$client_id;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":create_user_id", $create_user_id);
			$audit->bindParam(":created_date", $datetime);
			$audit->execute();
			
			$adduser = "INSERT INTO {$table_prefix}users(`contact_name`, `email_address`,`username`,`language`,`default_account_id`,`active`,`date_created`,`date_last_login`,`email_updated`) VALUES (:contactname,:email,:username,'en',:account_id,1,:datetime,:datetime,:email_updated);";
			$users = $this->db->prepare($adduser);
			$users->bindParam(":contactname", $contactname);
			$users->bindParam(":email", $email);
			$users->bindParam(":username", $clientname);
			// $users->bindParam(":password", $password);
			//$users->bindParam(":language", $language);
			$users->bindParam(":account_id", $account_id);
			$users->bindParam(":datetime", $datetime);
			$users->bindParam(":email_updated", $datetime);
			$users->execute();

			$userid = $this->db->lastInsertId();

			$user_perm = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:account_id,:user_id,:datetime);";

			$user_dat_perm = $this->db->prepare($user_perm);
			$user_dat_perm->bindParam(":account_id", $account_id);
			$user_dat_perm->bindParam(":user_id", $userid);
			$user_dat_perm->bindParam(":datetime", $datetime);
			$user_dat_perm->execute();
			
			$mail = "Select email_address from {$table_prefix}users where user_id = 1;";
			$mail_det = $this->db->prepare($mail);
			$mail_det->execute();
			$mail_data = $mail_det->fetchAll();

			$from = $mail_data[0]['email_address'];
			include_once('../../config.php');

			$recoveryId = strtoupper(bin2hex(random_bytes(12)));
			$recoveryId = substr(chunk_split($recoveryId, 8, "-"), 0, -1);

			$user_type = "user";
			$user_recovery = "INSERT INTO {$table_prefix}password_recovery(user_type, user_id, recovery_id, updated)
								VALUES ('" . $user_type . "','" . $userid . "','" . $recoveryId . "','" . $datetime . "')";
			$user_dat_recovery = $this->db->prepare($user_recovery);
			$user_dat_recovery->execute();

			$email_sent = mail($to, $subject, $message, $headers);
			$recoveryUrl = $agencypath . "password_recovery.php?id={$recoveryId}";
		
			$to = $email;

			$subject = 'Welcome to Revive Adservermod : set up your password';

			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
			$headers .= 'From: ' . $from . "\r\n";
			$message = '<html><style type="text/css">strong {background: #eee;font-size: 10px;}</style><body>';

			//$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';

			$message .= "<p>Dear " . $contactname . ",</p>";
			$message .= "<p>A username has been created for you, enabling you to log in on Unit DSP.</p>";
			$message .= "<p>Your username is  '" . $clientname . "'  </p>";
			$message .= "<p>For security reasons, the password for your username has not been defined yet.</p>";
			$message .= "<p>To enter your password, please click the following link: </p>";
			$message .= "<p><a href='$recoveryUrl' title='Advertiser Login'>$recoveryUrl</a></p>";
			$message .= "<p>Please make sure to enter a safe and unique password.</p>";
			$message .= '<p>Sincerely,</p>';
			$message .= "<p><a href='$from' title='adminmail'>$from</a></p>";
			$message .= "</body></html>";
			//$message .= "</table>";
			
			mail($to, $subject, $message, $headers);

				$response = array ('clientid' => $client_id, 'response' => 'ok', 'msg' => 'Advertiser has been added successfully with clientid');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Invalid Agency id!');
			return $this->response->withJson($response);
		}
	}
});

$app->get('/get_advertiser_new/[{clientid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$clientid = $args['clientid'];

		$stc = "SELECT clientid,agencyid,clientname,contact,email,report,reportinterval,reportlastdate,reportdeactivate FROM " . $table_prefix . "clients where clientid =:clientid";

		$std = $this->db->prepare($stc);
		$std->bindParam("clientid", $clientid);
		$std->execute();
		$users = $std->fetchAll();

		if ($users) {
			foreach ($users as $adv) { //$adv['clientid']
				$adv_list[] = $adv;
			}
			$response = array ('data' => $adv_list, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid client id!');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/advertiser_edit_new/[{clientid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();

		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$contactname = (isset ($input['contact'])) ? $input['contact'] : '';
		$contact = $contactname;
		$email = (isset ($input['email'])) ? $input['email'] : '';

		$clientname = (isset ($input['clientname'])) ? $input['clientname'] : '';
		$report = (isset ($input['report'])) ? $input['report'] : '';
		$reportinterval = (isset ($input['reportinterval'])) ? $input['reportinterval'] : '';
		$reportdeactivate = (isset ($input['reportdeactivate'])) ? $input['reportdeactivate'] : '';

		$datetime = date('Y-m-d H:i:s');
		$date = date('Y-m-d');
		$clientid = $args['clientid'];

		if (empty ($clientname) || empty ($contact) || empty ($email)) {
			$results = array ('response' => 'error', 'msg' => 'Please enter all data');
			return $this->response->withJson($response);
		}

		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}

		if ($reportinterval < 0) {
			$results = array ('response' => 'error', 'msg' => 'Please enter positive numbers only');
			return $this->response->withJson($response);
		}

		$stc = "SELECT * FROM " . $table_prefix . "clients where clientid ='" . $clientid . "'";
		$std = $this->db->prepare($stc);
		$std->execute();
		$users = $std->fetchAll();

		$accountid = $users[0]['account_id'];
		$acc = "SELECT * FROM " . $table_prefix . "accounts where account_id ='" . $accountid . "'";
		$accid = $this->db->prepare($acc);
		$accid->execute();
		$accup = $accid->fetchAll();
		//print_r($accup);exit("ok");



		if ($users) {

			$acc_upd = "update " . $table_prefix . "accounts set  `account_name`=:clientname where  account_id=:account_id";
			$acc_edit = $this->db->prepare($acc_upd);
			$acc_edit->bindParam(":clientname", $clientname);
			$acc_edit->bindParam(":account_id", $users[0]['account_id']);
			$acc_edit->execute();

			$cl_upd = "update " . $table_prefix . "clients set  `clientname`=:clientname,`contact`=:contact,`email`=:email,`report`=:report,`reportinterval`=:reportinterval,`reportlastdate`=:reportlastdate,`reportdeactivate`=:reportdeactivate,`updated`=:updated,`account_id`=:account_id where clientid=:clientid";


			$client_edit = $this->db->prepare($cl_upd);
			// $client_edit->bindParam(":clientname",$sql_clientname);
			$client_edit->bindParam(":clientname", $clientname);

			$client_edit->bindParam(":contact", $contact);
			$client_edit->bindParam(":email", $email);
			$client_edit->bindParam(":updated", $datetime);
			$client_edit->bindParam(":report", $report);
			$client_edit->bindParam(":reportinterval", $reportinterval);
			$client_edit->bindParam(":reportlastdate", $date);
			$client_edit->bindParam(":reportdeactivate", $reportdeactivate);
			$client_edit->bindParam(":account_id", $accountid);
			$client_edit->bindParam(":clientid", $clientid);

			$update_adv = $client_edit->execute();



			if ($update_adv) {
			
			//audit log maintain
			$update_user_id = $_SESSION['user_id'];
			$module = 'clients_'.$clientname.'_'.$clientid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `update_user_id`,  `updated_date`) VALUES (:module,:update_user_id,:updated_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":update_user_id", $update_user_id);
			$audit->bindParam(":updated_date", $datetime);
			$audit->execute();
			
				$response = array ('response' => 'ok', 'msg' => 'Advertiser has been updated successfully!');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter the valid advertiserid');
			return $this->response->withJson($response);
		}
	}
});

//advertiser trackers

$app->get('/get_advertiser_tracker/[{clientid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();



		//get banners
		$trackervalue = "select * from {$table_prefix}trackers where clientid=:clientid";
		//$trackervalue="select cli.clientname,track.* from {$table_prefix}clients as cli JOIN {$table_prefix}trackers as track ON cli.clientid=track.clientid where track.clientid=:clientid";
		$djax_query_trackervalue = $this->db->prepare($trackervalue);
		$djax_query_trackervalue->bindParam(":clientid", $clientid);
		$djax_query_trackervalue->execute();

		$stmttrackervalue = $djax_query_trackervalue->fetchAll();
		if ($stmttrackervalue) {
			$response = array ('data' => $stmttrackervalue, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
		} else {
			$response = array ('response' => 'error', 'msg' => 'No Data');
		}
	}
	return $this->response->withJson($response);
});

$app->post('/add_tracker_new/[{clientid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {


		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();


		$trackername = $input['trackername'];
		$description = $input['description'];
		$status = $input['status'];
		$type = $input['type'];
		$linkcampaigns = $input['linkcampaigns'];

		//validate for reqiured information  

		if (empty ($trackername)) {
			$results = array ('response' => 'error', 'msg' => 'Please enter all data');
			return $this->response->withJson($response);
		}

		$stc = "SELECT * FROM " . $table_prefix . "clients where clientid =" . $clientid;
		$std = $this->db->prepare($stc);
		$std->execute();
		$clients = $std->fetchAll();

		if (count($clients) <= 0) {
			$response = array ('response' => 'error', 'msg' => 'Enter valid clientid!');
			return $this->response->withJson($response);
		}

		$addtracker = "insert into {$table_prefix}trackers(`trackername`,`description`,`clientid`,`status`,`type`,`updated`,`linkcampaigns`) values(:trackername,:description,:clientid,:status,:type,:updated,:linkcampaigns)";
		$tracker_add = $this->db->prepare($addtracker);
		$tracker_add->bindParam(":clientid", $clientid);
		$tracker_add->bindParam(":trackername", $trackername);
		$tracker_add->bindParam(":description", $description);
		$tracker_add->bindParam(":status", $status);
		$tracker_add->bindParam(":type", $type);
		// $tracker_add->bindParam(":appendcode", $appendcode);
		$tracker_add->bindParam(":updated", $datetime);
		$tracker_add->bindParam(":linkcampaigns", $linkcampaigns);

		$tracker_add->execute();


		$trackerid = $this->db->lastInsertId();


		$response = array ('response' => 'ok', 'msg' => 'Tracker has been added successfully!');

		return $this->response->withJson($response);
	}
});

$app->get('/get_tracker_new/[{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');


		$trackerdetail = array ();

		$refertrackers = "SELECT * FROM {$table_prefix}trackers where trackerid =:trackerid";
		$tracker_det = $this->db->prepare($refertrackers);
		$tracker_det->bindParam(":trackerid", $trackerid);
		$tracker_det->execute();
		$stmttracker = $tracker_det->fetchAll();
		$counts = count($stmttracker);
		$trackerdetails = array ();
		if ($counts) {
			//[$trackerid]
			$trackerdetails = array (
				'trackerid' => $trackerid,
				'trackername' => $stmttracker[0]['trackername'],
				'description' => $stmttracker[0]['description'],
				'clientid' => $stmttracker[0]['clientid'],
				'status' => $stmttracker[0]['status'],
				'type' => $stmttracker[0]['type'],
				'linkcampaigns' => $stmttracker[0]['linkcampaigns'],
				'variablemethod' => $stmttracker[0]['variablemethod'],
				'appendcode' => $stmttracker[0]['appendcode']
			);

			$response = array (

				'data' => $trackerdetails,
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'success'
			);

			return $this->response->withJson($response);
		} else {

			$response = array ('response' => 'error', 'msg' => 'Invalid Trackerid!');

			return $this->response->withJson($response);
		}
	}
});

$app->post('/edit_tracker_new/[{clientid},{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$results = array ();
		$trackerid = $args['trackerid'];
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		$trackername = $input['trackername'];
		$description = $input['description'];
		$status = $input['status'];
		$type = $input['type'];
		$linkcampaigns = $input['linkcampaigns'];

		//validate for reqiured information  

		if (empty ($trackername)) {
			$results = array ('response' => 'error', 'msg' => 'Please enter all data');
			return $this->response->withJson($response);
		}

		$stc = "SELECT * FROM " . $table_prefix . "clients where clientid =" . $clientid;
		$std = $this->db->prepare($stc);
		$std->execute();
		$clients = $std->fetchAll();
		//print_r($clients);exit("ok");
		if (count($clients) <= 0) {
			$response = array ('response' => 'error', 'msg' => 'Enter valid clientid!');
			return $this->response->withJson($response);
		}

		$edittracker = "update  {$table_prefix}trackers set 
				`trackername`=:trackername,
				`description`=:description,
				`status`=:status,
				`type`=:type,
				`linkcampaigns`=:linkcampaigns where trackerid=:trackerid";

		$edit_tracker = $this->db->prepare($edittracker);
		$edit_tracker->bindParam(":trackerid", $trackerid);
		$edit_tracker->bindParam(":trackername", $trackername);
		$edit_tracker->bindParam(":description", $description);
		$edit_tracker->bindParam(":status", $status);
		$edit_tracker->bindParam(":type", $type);
		$edit_tracker->bindParam(":linkcampaigns", $linkcampaigns);
		$edit_tracker->execute();

		$response = array ('response' => 'ok', 'msg' => 'Tracker has been updated successfully!');

		return $this->response->withJson($response);
	}
});

$app->post('/linked_campaigns_trackers/[{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {


		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		// $campaignid = $args['campaignid'];
		// $trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$campid = $input['campaignid'];
		$getid = explode(',', $campid);
		$trackerid = $input['trackerid'];
		$id = explode(',', $trackerid);
		$status = $input['status'];
		$getstatus = explode(',', $status);

		$executionid = "Delete from " . $table_prefix . "campaigns_trackers where trackerid=$trackerid";
		$bnr = $this->db->prepare($executionid);
		$bnr->execute();

		if ($campid) {
			$i = 0;
			foreach ($getid as $campaignid1) {
				$status = $getstatus[$i];
				$campaignid = $getid[$i];

				$value = "select * from {$table_prefix}campaigns_trackers where trackerid=:trackerid";
				$tracker_data = $this->db->prepare($value);
				$tracker_data->bindParam(":trackerid", $trackerid);
				$tracker_data->execute();
				$stmt = $tracker_data->fetchAll();
				$stmtcount = count($stmt);


				$addcampaignstrackers = "INSERT INTO " . $table_prefix . "campaigns_trackers (`campaignid`, `trackerid`, `status`) VALUES (:campaignid,:trackerid,:status);";

				$campaigntrackers = $this->db->prepare($addcampaignstrackers);
				$campaigntrackers->bindParam(":campaignid", $campaignid);
				$campaigntrackers->bindParam(":trackerid", $trackerid);
				$campaigntrackers->bindParam(":status", $status);
				$campaigntrackers->execute();

				$i++;
			}

		}
		$response = array ('response' => 'ok', 'msg' => 'linked campaign tracker has been updated successfully!');

		return $this->response->withJson($response);
	}
});

$app->post('/add_variable/[{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		$variabledata = $input['data'];
		$executionid = "Delete from " . $table_prefix . "variables where trackerid=$trackerid";
		$bnr = $this->db->prepare($executionid);
		$bnr->execute();

		$variabletrackerdetail = array ();

		foreach ($variabledata as $inp) {
			$variableid = $inp['variableid'];
			$name = $inp['name'];
			$description = $inp['description'];
			$datatype = $inp['datatype'];
			$purpose = $inp['purpose'];
			$reject_if_empty = $inp['reject_if_empty'];
			$is_unique = $inp['is_unique'];
			$unique_window = $inp['unique_window'];
			$hidden = $inp['hidden'];
			$variablecode = $inp['variablecode'];

			$variabletrackers = "insert into {$table_prefix}variables(
			`trackerid`,
			`name`,
			`description`,
			`datatype`,
			`purpose`,
			`reject_if_empty`,
			`is_unique`,
			`unique_window`,
			`hidden`,
			`variablecode`,
			`updated`)values(
			:trackerid,
			:name,
			:description,
			:datatype,
			:purpose,
			:reject_if_empty,
			:is_unique,
			:unique_window,
			:hidden,
			:variablecode,
			:updated)";

			$var_trackers = $this->db->prepare($variabletrackers);
			$var_trackers->bindParam(":trackerid", $trackerid);
			$var_trackers->bindParam(":name", $name);
			$var_trackers->bindParam(":description", $description);
			$var_trackers->bindParam(":datatype", $datatype);
			$var_trackers->bindParam(":purpose", $purpose);
			$var_trackers->bindParam(":is_unique", $is_unique);
			$var_trackers->bindParam(":unique_window", $unique_window);
			$var_trackers->bindParam(":reject_if_empty", $reject_if_empty);
			$var_trackers->bindParam(":hidden", $hidden);
			$var_trackers->bindParam(":variablecode", $variablecode);
			$var_trackers->bindParam(":updated", $datetime);

			$var_trackers->execute();
			//print_r($var_trackers);exit("ok");
		}
		$response = array ('response' => 'ok', 'msg' => 'Variable has been added successfully!');
		return $this->response->withJson($response);
	}
});

$app->get('/get_tracker_variables/[{trackerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$trackerid = $args['trackerid'];

	$getvariables = "SELECT * from " . $table_prefix . "variables where trackerid=:trackerid";
	$djax_query_getvariables = $this->db->prepare($getvariables);
	$djax_query_getvariables->bindParam(":trackerid", $trackerid);
	$djax_query_getvariables->execute();
	$stmtvariables = $djax_query_getvariables->fetchAll();
	$num = count($stmtvariables);
	$tracker_variablesdetail = array ();
	if (count($stmtvariables) > 0) {
		foreach ($stmtvariables as $variables) {
			$tracker_variablesdetail[] = array (
				'trackerid' => $variables['trackerid'],
				'name' => $variables['name'],
				'description' => $variables['description'],
				'datatype' => $variables['datatype'],
				'purpose' => $variables['purpose'],
				'reject_if_empty' => $variables['reject_if_empty'],
				'is_unique' => $variables['is_unique'],
				'unique_window' => $variables['unique_window'],
				'variablecode' => $variables['variablecode'],
				'hidden' => $variables['hidden']
			);
		}
		$response = array (
			'data' => $tracker_variablesdetail,
			'response' => 'success',
			'successcode' => '200'
		);

		return $this->response->withJson($response);
	} else {
		$results = array ('response' => 'Error', 'ERROR' => 'No tracker available for the trackerid');
		return $this->response->withJson($results);
	}
});

$app->post('/add_append_tracker/[{trackerid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$results = array ();
		$trackerid = $args['trackerid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$datetime = date('Y-m-d H:i:s');
		$results = array ();

		$appentrackerdata = $input['data'];

		$executionid = "Delete from " . $table_prefix . "tracker_append where tracker_id=$trackerid";
		$bnr = $this->db->prepare($executionid);
		$bnr->execute();
		$appentrackerdetail = array ();

		foreach ($appentrackerdata as $inp) {
			$tagcode = $inp['tag'];
			$autotrack = $inp['autotrack'];

			$appentracker = "insert into {$table_prefix}tracker_append(
			`tracker_id`,
			`rank`,
			`tagcode`,
			`paused`,
			`autotrack`)values(
			:tracker_id,
			1,
			:tagcode,
			'f',
			:autotrack)";

			$append_trackers = $this->db->prepare($appentracker);
			$append_trackers->bindParam(":tracker_id", $trackerid);
			$append_trackers->bindParam(":tagcode", $tagcode);
			$append_trackers->bindParam(":autotrack", $autotrack);

			$append_trackers->execute();
			//print_r($append_trackers);exit("ok");
		}
		$response = array ('response' => 'ok', 'msg' => 'Append tracker code has been added successfully!');
		return $this->response->withJson($response);
	}
});

$app->get('/get_append_code/[{trackerid}]', function ($request, $response, $args) {
	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$trackerid = $args['trackerid'];

	$getlimitation = "SELECT * from " . $table_prefix . "tracker_append where tracker_id=:trackerid";
	$djax_query_getlimitation = $this->db->prepare($getlimitation);
	$djax_query_getlimitation->bindParam(":trackerid", $trackerid);
	$djax_query_getlimitation->execute();
	$stmtlimitations = $djax_query_getlimitation->fetchAll();
	$num = count($stmtlimitations);
	$banner_limitationdetail = array ();
	if (count($stmtlimitations) > 0) {
		foreach ($stmtlimitations as $limitations) {
			$banner_limitationdetail[] = array (
				'tracker_id' => $limitations['tracker_id'],
				'tagcode' => $limitations['tagcode'],
				'autotrack' => $limitations['autotrack']
			);
		}
		$response = array (
			'data' => $banner_limitationdetail,
			'response' => 'success',
			'successcode' => '200'
		);

		return $this->response->withJson($response);
	} else {
		$results = array ('response' => 'Error', 'ERROR' => 'No tracker available for the trackerid');
		return $this->response->withJson($results);
	}
});

$app->post('/add_user_new/[{clientid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$user_id = $args['user_id'];
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$userid = $input['check_val'];
		$getid = explode(',', $userid);

		$email = $input['email'];
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}

		$contactname = $input['contactname'];
		$username = $input['username'];
		$language = $input['language'];
		//$realpassword = $input['password'];
		//password encrypt
		//$password = md5($realpassword);

		if (empty ($contactname) && empty ($email) && empty ($username)) {
			$response = array ('ok' => 'Please enter all required data');

			return $this->response->withJson($response);
		}

		$check_user = "Select username from {$table_prefix}users where username = :username ;";
		$user_det = $this->db->prepare($check_user);
		$user_det->bindParam(":username", $username);
		$user_det->execute();
		$user_data = $user_det->fetchAll();

		if ($user_data) {
			$response = array ('response' => 'error', 'msg' => 'Username already exists');

			return $this->response->withJson($response);
		}


		$stc = "select account_id from {$table_prefix}clients where clientid=$clientid";
		$userper = $this->db->prepare($stc);
		$userper->execute();
		$percount = $userper->fetchAll();
		$account_id = $percount[0]['account_id'];

		// print_r($account_id);exit("okk");
		if ($account_id) {

			$adduser = "INSERT INTO {$table_prefix}users(`contact_name`, `email_address`,`username`,`language`,`default_account_id`,`active`,`date_created`,`date_last_login`,`email_updated`) 
				VALUES (:contactname,:email,:username,:language,:account_id,1,:datetime,:datetime,:email_updated);";
			$users = $this->db->prepare($adduser);
			$users->bindParam(":contactname", $contactname);
			$users->bindParam(":email", $email);
			$users->bindParam(":username", $username);
			// $users->bindParam(":password", $password);
			$users->bindParam(":language", $language);
			$users->bindParam(":account_id", $account_id);
			$users->bindParam(":datetime", $datetime);
			$users->bindParam(":email_updated", $datetime);
			$users->execute();

			$userid = $this->db->lastInsertId();

			$user_perm = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:account_id,:user_id,:datetime);";

			$user_dat_perm = $this->db->prepare($user_perm);
			$user_dat_perm->bindParam(":account_id", $account_id);
			$user_dat_perm->bindParam(":user_id", $userid);
			$user_dat_perm->bindParam(":datetime", $datetime);
			$user_dat_perm->execute();

			$executionid = "Delete from " . $table_prefix . "account_user_permission_assoc where user_id=$userid";
			$bnr = $this->db->prepare($executionid);
			$bnr->execute();

			foreach ($getid as $permission) {
				$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(account_id, user_id, permission_id, is_allowed) VALUES
			(:account_id,:user_id,:permission_id,1);";
				$assoc = $this->db->prepare($userper_assc);
				$assoc->bindParam(":account_id", $account_id);
				$assoc->bindParam(":user_id", $userid);
				$assoc->bindParam(":permission_id", $permission);
				$assoc->execute();
			}

			$mail = "Select email_address from {$table_prefix}users where user_id = 1;";
			$mail_det = $this->db->prepare($mail);
			$mail_det->execute();
			$mail_data = $mail_det->fetchAll();

			$from = $mail_data[0]['email_address'];
			include_once ('../../config.php');
			$email_sent = mail($to, $subject, $message, $headers);
			$recoveryUrl = $agencypath . "password_recovery.php?userid=$userid";
			//print_r($from);exit("ok");
			$to = $email;

			$subject = 'Welcome to Revive Adserver: set up your password';

			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
			$headers .= 'From: ' . $from . "\r\n";
			$message = '<html><style type="text/css">strong {background: #eee;font-size: 10px;}</style><body>';

			//$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';

			$message .= "<p>Dear " . $contactname . ",</p>";
			$message .= "<p>A username has been created for you, enabling you to log in on Revive Adserver.</p>";
			$message .= "<p>Your username is  '" . $username . "'  </p>";
			$message .= "<p>For security reasons, the password for your username has not been defined yet.</p>";
			$message .= "<p>To enter your password, please click the following link: </p>";
			$message .= "<p><a href='$recoveryUrl' title='Advertiser Login'>$recoveryUrl</a></p>";
			$message .= "<p>Please make sure to enter a safe and unique password.</p>";
			$message .= '<p>Sincerely,</p>';
			$message .= "<p><a href='$from' title='adminmail'>$from</a></p>";
			$message .= "</body></html>";
			//$message .= "</table>";

			mail($to, $subject, $message, $headers);

			$response = array (
				'response' => 'ok',
				'msg' => 'user has been created successfully!'
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Account Id!'
			);
		}
		return $this->response->withJson($response);
	}
});

$app->get('/get_user_new/[{username1}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$username1 = $args['username1'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		//print_r($account_id);exit("okk");

		$alluserdet = "SELECT cli.account_id,cli.clientid,user.user_id,user.username,user.contact_name,user.email_address,user.language FROM {$table_prefix}clients as cli RIGHT JOIN {$table_prefix}users as user ON cli.account_id = user.default_account_id WHERE user.username=:username1;";
		$userdetail = $this->db->prepare($alluserdet);
		$userdetail->bindParam(":username1", $username1);
		$userdetail->execute();
		$stmtusers = $userdetail->fetchAll();
		return $this->response->withJson($stmtusers);
	}
});

$app->get('/get_all_user_new/[{clientid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$clientid = $args['clientid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		//print_r($account_id);exit("okk");
		$stc = "select account_id from {$table_prefix}clients where clientid=$clientid";
		$userper = $this->db->prepare($stc);
		$userper->execute();
		$percount = $userper->fetchAll();
		$account_id = $percount[0]['account_id'];

		if ($account_id) {
			$alluserdet = "SELECT cli.user_id, user.username,user.contact_name,user.email_address,user.date_created,user.date_last_login
		FROM {$table_prefix}account_user_assoc as cli RIGHT JOIN {$table_prefix}users as user ON cli.user_id = user.user_id WHERE cli.account_id=:account_id;";
			$userdetail = $this->db->prepare($alluserdet);
			$userdetail->bindParam(":account_id", $account_id);
			$userdetail->execute();
			$stmtusers = $userdetail->fetchAll();
			return $this->response->withJson($stmtusers);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Account Id!'
			);
			return $this->response->withJson($response);
		}
	}
});

$app->post('/edit_permission/[{userid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$permid = $input['check_val'];
		$getid = explode(',', $permid);

		$stc = "select account_id from {$table_prefix}account_user_assoc where user_id=$userid";
		$userper = $this->db->prepare($stc);
		$userper->execute();
		$percount = $userper->fetchAll();
		$account_id = $percount[0]['account_id'];

		$executionid = "Delete from " . $table_prefix . "account_user_permission_assoc where user_id=$userid";
		$bnr = $this->db->prepare($executionid);
		$bnr->execute();

		foreach ($getid as $permission) {
			$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(account_id, user_id, permission_id, is_allowed) VALUES
		(:account_id,:user_id,:permission_id,1);";
			$assoc = $this->db->prepare($userper_assc);
			$assoc->bindParam(":account_id", $account_id);
			$assoc->bindParam(":user_id", $userid);
			$assoc->bindParam(":permission_id", $permission);
			$assoc->execute();
		}
		$response = array (
			'response' => 'ok',
			'msg' => 'user permission has been updated successfully!'
		);

		return $this->response->withJson($response);
	}
});

$app->post('/user_password/[{userid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$realpassword = $input['password'];
		//password encrypt md5($realpassword) 
		$password = password_hash($realpassword, PASSWORD_BCRYPT);


		$user_details = "SELECT * from {$table_prefix}users where user_id=:userid";
		$get_userdet = $this->db->prepare($user_details);
		$get_userdet->bindParam(":userid", $userid);
		$get_userdet->execute();
		$stmtuser = $get_userdet->fetchAll();
		if (count($stmtuser)) {

			$updateuser = "update {$table_prefix}users set `password`=:password ,date_created=:updated where `user_id`=:user_id";

			$upd_userdet = $this->db->prepare($updateuser);

			$upd_userdet->bindParam(":password", $password);
			$upd_userdet->bindParam(":updated", $datetime);
			$upd_userdet->bindParam(":user_id", $userid);
			$upd_userdet->execute();

			$responses = array (
				'response' => 'success',
				'statuscode' => '200',
				'msg' => 'password updated successfully!'
			);
			$response = array (
				'data' => $responses
			);
			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid user Id!'
			);
		}
		return $this->response->withJson($response);
	}
});

/********************************Website List Start*******************************/

$app->get('/get_all_website/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$TimeZone = "select a.value as timezone from
			" . $table_prefix . "account_preference_assoc as a,
            " . $table_prefix . "agency as ag
			where
			ag.account_id = a.account_id
			AND a.preference_id = 16
			AND ag.agencyid =$agencyid";
	$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
	$TimeZonestd->execute();

	$TimeZoneRow = $TimeZonestd->fetchAll();


	if ($TimeZoneRow) {

		$timezone = $TimeZoneRow[0]['timezone'];
	} else {

		$TimeZone = "SELECT apa.value AS timezone FROM " . $table_prefix . "accounts AS a JOIN " . $table_prefix . "account_preference_assoc AS apa ON (apa.account_id = a.account_id) JOIN " . $table_prefix . "preferences AS p ON (p.preference_id = apa.preference_id) WHERE a.account_type IN ('ADMIN') AND p.preference_name = 'timezone'";
		$TimeZonestd = $this->db->prepare($TimeZone) or die("error TimeZone");
		$TimeZonestd->execute();
		$TimeZoneRow = $TimeZonestd->fetchAll();
		if($TimeZoneRow){
			$timezone = $TimeZoneRow[0]['timezone'];
			}
			else{
				$timezone = 'UTC';

			}
	}
	if($timezone=='0'){
		$timezone = 'UTC';

	}
	else{
		$timezone = $timezone;

	}

	date_default_timezone_set($timezone);


	// $date1 = date("d-m-Y H:i:s");
	// date_default_timezone_set('UTC');
	// $date2 = date("d-m-Y H:i:s");
	// $time_diff = strtotime($date1) - strtotime($date2);
	// $date3 = date('H:i', $time_diff);

	// $date4 = '+'.$date3;


	$tz = new DateTimeZone($timezone);
	$offset = $tz->getOffset(new DateTime());

	// Convert offset to hours and minutes
	$offsetHours = floor($offset / 3600);
	$offsetMinutes = floor(($offset % 3600) / 60);

	// Determine the GMT offset string
	$gmtOffset = sprintf('%+03d:%02d', $offsetHours, $offsetMinutes);

		//$publisherdetails = "SELECT * FROM {$table_prefix}affiliates where agencyid = :agencyid Order by updated Desc";

			$publisherdetails = "SELECT affiliateid,agencyid,mnemonic,name,comments,contact,email,website,DATE_FORMAT(CONVERT_TZ(updated,'+00:00','$gmtOffset'), '%d-%m-%Y %h:%i:%s') as updated,oac_country_code,oac_category_id,account_id,publisher_id from {$table_prefix}affiliates where agencyid = :agencyid Order by updated Desc";

		$get_details = $this->db->prepare($publisherdetails);
		$get_details->bindParam(":agencyid", $agencyid);
		$get_details->execute();
		$publisher = $get_details->fetchAll();
		$websitedetail = array ();

		if (count($publisher) > 0) {
			if ($publisher) {
				$response = array ('data' => $publisher, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter valid agency Id!'
			);

			return $this->response->withJson($response);
		}
	}
});

$app->post('/add_website/[{agencyid},{user_id}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$agencyid = $args['agencyid'];
		$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetchAll();
		$user_id = $args['user_id'];

		if (count($check) > 0) {
			$email = $input['email'];
			if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
				$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
				return $this->response->withJson($results);
			}
			$website = $input['website'];
			if (!filter_var($website, FILTER_VALIDATE_URL)) {
				$results = array ('response' => 'error', 'ERROR' => 'Please enter a valid Website name(website name should start with the prefix of http:// or https://)');
				return $this->response->withJson($results);
			}
			$name = $input['name'];
			$contact = $input['contact'];

			if (empty ($website) || empty ($name) || empty ($contact) || empty ($email)) {
				$response = array ('ERROR' => 'Please enter all required data');
				return $this->response->withJson($response);
			} else {
				$addacc = "INSERT INTO {$table_prefix}accounts(`account_type`, `account_name`) VALUES ('TRAFFICKER',:websitename);";
				$acc_dat = $this->db->prepare($addacc);
				$acc_dat->bindParam(":websitename", $name);
				$acc_dat->execute();
				$acccountid = $this->db->lastInsertId();

				$addweb = "INSERT INTO {$table_prefix}affiliates(`agencyid`,`name`,`comments`,`contact`,`email`,`website`,`updated`,`account_id`) VALUES (:agencyid,:websitename,'',:contact,:email,:website,:updated,:acccountid);";
				$web_det = $this->db->prepare($addweb);
				$web_det->bindParam(":agencyid", $agencyid);
				$web_det->bindParam(":websitename", $name);
				$web_det->bindParam(":contact", $contact);
				$web_det->bindParam(":email", $email);
				$web_det->bindParam(":website", $website);
				$web_det->bindParam(":updated", $datetime);
				$web_det->bindParam(":acccountid", $acccountid);

				$web_det->execute();
				$websiteid = $this->db->lastInsertId();
				$userpermission = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:acccountid,:userid,:datetime);";
				$add_permission = $this->db->prepare($userpermission);
				$add_permission->bindParam(":acccountid", $acccountid);
				$add_permission->bindParam(":userid", $user_id);
				$add_permission->bindParam(":datetime", $datetime);
				$add_permission->execute();

				//audit log maintain
				$create_user_id = $_SESSION['user_id'];
				$module = 'affiliates_'.$name.'_'.$websiteid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":create_user_id", $create_user_id);
				$audit->bindParam(":created_date", $datetime);
				$audit->execute();
				
				$adduser = "INSERT INTO {$table_prefix}users(`contact_name`, `email_address`,`username`,`language`,`default_account_id`,`active`,`date_created`,`date_last_login`,`email_updated`) VALUES (:contactname,:email,:username,'en',:account_id,1,:datetime,:datetime,:email_updated);";
				$users = $this->db->prepare($adduser);
				$users->bindParam(":contactname", $contact);
				$users->bindParam(":email", $email);
				$users->bindParam(":username", $name);
				// $users->bindParam(":password", $password);
				//$users->bindParam(":language", $language);
				$users->bindParam(":account_id", $acccountid);
				$users->bindParam(":datetime", $datetime);
				$users->bindParam(":email_updated", $datetime);
				$users->execute();

			    $userid = $this->db->lastInsertId();

				$mail = "Select email_address from {$table_prefix}users where user_id = 1;";
				$mail_det = $this->db->prepare($mail);
				$mail_det->execute();
				$mail_data = $mail_det->fetchAll();

				$from = $mail_data[0]['email_address'];
				include_once('../../config.php');

				$recoveryId = strtoupper(bin2hex(random_bytes(12)));
				$recoveryId = substr(chunk_split($recoveryId, 8, "-"), 0, -1);

				$user_type = "user";
				$user_recovery = "INSERT INTO {$table_prefix}password_recovery(user_type, user_id, recovery_id, updated)
									VALUES ('" . $user_type . "','" . $userid . "','" . $recoveryId . "','" . $datetime . "')";
				$user_dat_recovery = $this->db->prepare($user_recovery);
				$user_dat_recovery->execute();

				$email_sent = mail($to, $subject, $message, $headers);
				$recoveryUrl = $agencypath . "website_password_recovery.php?id={$recoveryId}";
			
				$to = $email;

				$subject = 'Welcome to Revive Adservermod Website : set up your password';

				$headers .= "MIME-Version: 1.0\r\n";
				$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
				$headers .= 'From: ' . $from . "\r\n";
				$message = '<html><style type="text/css">strong {background: #eee;font-size: 10px;}</style><body>';

				//$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';

				$message .= "<p>Dear " . $contact . ",</p>";
				$message .= "<p>A username has been created for you, enabling you to log in on Revive Adservermod Website.</p>";
				$message .= "<p>Your username is  '" . $name . "'  </p>";
				$message .= "<p>For security reasons, the password for your username has not been defined yet.</p>";
				$message .= "<p>To enter your password, please click the following link: </p>";
				$message .= "<p><a href='$recoveryUrl' title='Advertiser Login'>$recoveryUrl</a></p>";
				$message .= "<p>Please make sure to enter a safe and unique password.</p>";
				$message .= '<p>Sincerely,</p>';
				$message .= "<p><a href='$from' title='adminmail'>$from</a></p>";
				$message .= "</body></html>";
				//$message .= "</table>";
				
				mail($to, $subject, $message, $headers);

				$response = array (
					'response' => 'success',
					'statuscode' => '200',
					'msg' => 'Website added successfully!',
					'affiliate_id' => $websiteid
				);
			}
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Invalid Agency id!');
			return $this->response->withJson($response);
		}
	}
});

//CSV Upload API

$app->post('/csv_upload', function ($request, $response) {

	$input = $request->getParsedBody();

	if ($_FILES["internal_file"]["size"] != 0) {
		if ($_FILES["internal_file"]["error"] > 0) {
			$response = array ('status' => '0', 'response' => 'error', 'msg' => "Error: " . $_FILES["internal_file"]["error"]);
		}
		$ext = pathinfo($_FILES["internal_file"]["name"], PATHINFO_EXTENSION);
		$Newfile = round(microtime(true)) . "." . $ext;

		$filetype = $input['filetype'];

		include_once ('../../config.php');

		$dest_path = $reviveapiPath . 'temp/' . $Newfile;

		move_uploaded_file($_FILES["internal_file"]["tmp_name"], $dest_path);

		$response = array ('status' => '1', 'response' => 'success', 'msg' => 'Upload Successfully..', 'fileformat' => $ext, 'filename' => $Newfile, 'fileurl' => $reviveapiPath . 'temp/' . $Newfile, 'filepath' => $reviveapiPath . 'temp/');
	} else {
		$response = array ('status' => '0', 'response' => 'error', 'msg' => 'Please select an csv to upload first.');
	}

	return $this->response->withJson($response);
});

//Publisher Import API

$app->post('/publisher_import/[{agencyid}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$input = $request->getParsedBody();
	$agencyid = $args['agencyid'];
	$datetime = date('Y-m-d H:i:s');
	$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
	$agencyid_tab = $this->db->prepare($agencyid_det);
	//var_dump($agencyid_det);
	//exit;
	$agencyid_tab->execute();
	$check = $agencyid_tab->fetchAll();

	$filename = $input['internal_file'];
	$flag = true;
	if ($filename) {

		$file = fopen($filename, "r");
		while (($publisherData = fgetcsv($file, 10000, ",")) !== FALSE) {
			if ($flag) {
				$flag = false;
				continue;
			}
			$addpublisher = "INSERT INTO {$table_prefix}publishers(`name`,`contact`,`email`,`agency_id`,`updated`) VALUES ('$publisherData[0]','$publisherData[1]','$publisherData[2]',$agencyid,'$datetime');";
			$publisher_det = $this->db->prepare($addpublisher);
			//var_dump($web_det);
			//exit;
			$publisher_det->execute();
			$publisherid = $this->db->lastInsertId();

			if (!$publisherid) {
				$response = array ('status' => '0', 'response' => 'error', 'msg' => 'Please upload csv file.');
			}
		}
		fclose($file);
		$response = array ('status' => '1', 'response' => 'success', 'msg' => 'Publishers imported successfully..');
	}




	return $this->response->withJson($response);
});

//Website Import API

$app->post('/website_import/[{agencyid},{user_id}]', function ($request, $response, $args) {

	$table_prefix = $this->get('settings')['path']['table_prefix'];
	$input = $request->getParsedBody();
	$agencyid = $args['agencyid'];
	$datetime = date('Y-m-d H:i:s');
	$user_id = $args['user_id'];
	$agencyid_det = "select agencyid from " . $table_prefix . "agency where agencyid=" . $agencyid;
	$agencyid_tab = $this->db->prepare($agencyid_det);
	$agencyid_tab->execute();
	$check = $agencyid_tab->fetchAll();


	$filename = $input["internal_file"];
	if ($filename) {

		$file = fopen($filename, "r");
		$flag = true;
		while (($affiliateData = fgetcsv($file, 10000, ",")) !== FALSE) {
			if ($flag) {
				$flag = false;
				continue;
			}
			$name = $affiliateData[1];
			$addacc = "INSERT INTO {$table_prefix}accounts(`account_type`, `account_name`) VALUES ('TRAFFICKER','$name');";
			$acc_dat = $this->db->prepare($addacc);
			$acc_dat->execute();
			$acccountid = $this->db->lastInsertId();

			$addweb = "INSERT INTO {$table_prefix}affiliates(`agencyid`,`name`,`contact`,`website`,`email`,`updated`,`account_id`) VALUES ($agencyid,'$affiliateData[1]','$affiliateData[2]','$affiliateData[3]','$affiliateData[4]','$datetime',$acccountid);";
			$web_det = $this->db->prepare($addweb);
			$web_det->execute();
			$websiteid = $this->db->lastInsertId();
			$userpermission = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES ($acccountid,$user_id,'$datetime')";

			$add_permission = $this->db->prepare($userpermission);
			$add_permission->execute();

			if (!$websiteid) {
				$response = array ('status' => '0', 'response' => 'error', 'msg' => 'Please upload csv file.');
			}
		}
		fclose($file);
	}

	$response = array ('status' => '1', 'response' => 'success', 'msg' => 'Websites imported successfully..');



	return $this->response->withJson($response);
});

$app->get('/get_website/[{affiliateid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$affiliateid = $args['affiliateid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$publisherdetails = "Select *FROM {$table_prefix}affiliates WHERE affiliateid = :affiliateid";
		$get_details = $this->db->prepare($publisherdetails);
		$get_details->bindParam(":affiliateid", $affiliateid);
		$get_details->execute();
		$publisher = $get_details->fetchAll();
		$websitedetail = array ();

		if (count($publisher) > 0) {
			$websitedetail = array (
				'affiliateid' => $affiliateid,
				'name' => $publisher[0]['name'],
				'contact' => $publisher[0]['contact'],
				'email' => $publisher[0]['email'],
				'website' => $publisher[0]['website'],
				'pubid' => $publisher[0]['publisher_id'],
				'publisher_name' => $publisher[0]['name'],
				'updated' => $publisher[0]['updated']
			);
			if ($websitedetail) {
				$response = array ('data' => $websitedetail, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Website Id!'
			);

			return $this->response->withJson($response);
		}
	}
});

$app->post('/edit_website/[{affiliateid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$website = (isset ($input['website'])) ? $input['website'] : '';
		$name = (isset ($input['name'])) ? $input['name'] : '';
		$contact = (isset ($input['contact'])) ? $input['contact'] : '';
		$email = (isset ($input['email'])) ? $input['email'] : '';
		$mode = $input['mode'];
		$datetime = date('Y-m-d H:i:s');
		$affiliateid = $args['affiliateid'];
		$results = array ();
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		$getpublisher = "SELECT * FROM {$table_prefix}affiliates where affiliateid =:affiliateid";
		$pub_edit = $this->db->prepare($getpublisher);
		$pub_edit->bindParam(":affiliateid", $affiliateid);
		$pub_edit->execute();
		$stmt = $pub_edit->fetchAll();

		if (count($stmt) > 0) {
			if (isset ($input['website'])) {
				$website = $input['website'];
				if (!filter_var($website, FILTER_VALIDATE_URL)) {
					$results = array ('response' => 'error', 'ERROR' => 'Please enter a valid Website name(website name should start with the prefix of http:// or https://)');
					return $this->response->withJson($results);
				}
			} else {
				$website = $stmt[0]['website'];
			}

			if (isset ($input['name'])) {
				$name = $input['name'];
				if (empty ($name)) {
					$results = json_encode(array ('ERROR' => 'Please enter website name'));
					return $results;
				}
			} else {
				$name = $stmt[0]['name'];
			}

			if (isset ($input['contact'])) {
				$contact = $input['contact'];
				if (empty ($contact)) {
					$results = json_encode(array ('ERROR' => 'Please enter contact'));
					return $results;
				}
			} else {
				$contact = $stmt[0]['contact'];
			}

			if (isset ($input['email'])) {
				$email = $input['email'];
				if (empty ($email)) {
					$results = array ('response' => 'error', 'ERROR' => 'Please enter email');
				}
				/* if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
																	$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
																	return $this->response->withJson($results);
																} */
			} else {
				$email = $stmt[0]['email'];
			}

			$accounts = "update {$table_prefix}accounts set  `account_name`=:account_name where  account_id=:account_id";
			$acc_dat = $this->db->prepare($accounts);
			$acc_dat->bindParam(":account_name", $name);
			$acc_dat->bindParam(":account_id", $stmt[0]['account_id']);
			$acc_dat->execute();

			$update_web = "update {$table_prefix}affiliates set  `name`=:name,`contact`=:contact,`website`=:website,`email`=:email,updated=:updated where affiliateid=:affiliate_id";
			$web_query = $this->db->prepare($update_web);
			$web_query->bindParam(":name", $name);
			$web_query->bindParam(":contact", $contact);
			$web_query->bindParam(":website", $website);
			$web_query->bindParam(":email", $email);
			$web_query->bindParam(":updated", $datetime);
			$web_query->bindParam(":affiliate_id", $affiliateid);
			$web_query->execute();
			
			//audit log maintain
			$update_user_id = $_SESSION['user_id'];
			$module = 'affiliates_'.$name.'_'.$affiliateid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `update_user_id`,  `updated_date`) VALUES (:module,:update_user_id,:updated_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":update_user_id", $update_user_id);
			$audit->bindParam(":updated_date", $datetime);
			$audit->execute();

			$results = array ('response' => 'ok', 'statuscode' => '200', 'msg' => 'Website details has been updated successfully!');
			return $this->response->withJson($results);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid website id!');
			return $this->response->withJson($response);
		}
	}
});

$app->delete('/delete_website/[{affiliateid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$affiliateid = $args['affiliateid'];
		$website = "select *  from {$table_prefix}affiliates where affiliateid in ($affiliateid)";
		$web_data = $this->db->prepare($website);
		//$pub_data->bindParam(":affiliateid", $affiliateid);
		$web_data->execute();
		$stmtweb = $web_data->fetchAll();
		//print_r($stmtpub);
		if (count($stmtweb) > 0) {
			foreach ($stmtweb as $key => $website) {
				$affiliateid1 .= $website['affiliateid'] . ',';
				$accountid1 .= $website['account_id'] . ',';
			}
			$affiliateids = trim($affiliateid1, ',');
			$accountid = trim($accountid1, ',');
			
			//print_r($affiliateids);exit('ok');

			$zones = "SELECT * FROM " . $table_prefix . "zones where affiliateid in ($affiliateids)";
			$zon = $this->db->prepare($zones);
			$zon->execute();
			$zone_det = $zon->fetchAll();
			
			//print_r($zone_det);exit('ok');

			if ($zone_det) {
				foreach ($zone_det as $key => $zone) {
					$zoneid1 .= $zone['zoneid'] . ',';
				}
				$zoneid = rtrim($zoneid1, ',');
				$del_adassoc = "DELETE FROM {$table_prefix}ad_zone_assoc WHERE zone_id in($zoneid)";
				$del_ad = $this->db->prepare($del_adassoc);
				$del_ad->execute();

				$del_placeassoc = "DELETE FROM {$table_prefix}placement_zone_assoc WHERE zone_id in($zoneid)";
				$del_place_ad = $this->db->prepare($del_placeassoc);
				$del_place_ad->execute();

				$del_adhourly = "DELETE FROM {$table_prefix}data_summary_ad_hourly WHERE zone_id in($zoneid)";
				$del_ad_hourly = $this->db->prepare($del_adhourly);
				$del_ad_hourly->execute();

			}

			$deletezoneassoc = "DELETE FROM {$table_prefix}zones WHERE affiliateid in($affiliateids)";
			$zon_assoc = $this->db->prepare($deletezoneassoc);
			$zon_assoc->execute();

			$deleteacc = "DELETE FROM {$table_prefix}accounts WHERE account_id in($accountid)";
			$del_acc = $this->db->prepare($deleteacc);
			//$del_acc->bindParam(":account_id", $accountid);
			$del_acc->execute();

			$deletepub = "DELETE FROM {$table_prefix}affiliates WHERE affiliateid in ($affiliateids)";
			$del_data = $this->db->prepare($deletepub);
			//$del_data->bindParam(":affiliate_id", $affiliateid);
			$del_data->execute();

			$deleteuserassoc = "DELETE FROM {$table_prefix}account_user_assoc WHERE account_id in ($accountid)";
			$del_assoc = $this->db->prepare($deleteuserassoc);
			//$del_assoc->bindParam(":account_id", $accountid);
			$del_assoc->execute();

			$deletepermission = "DELETE FROM {$table_prefix}account_user_permission_assoc WHERE account_id in ($accountid)";
			$del_user_permission = $this->db->prepare($deletepermission);
			//$del_user_permission->bindParam(":account_id", $accountid);
			$del_user_permission->execute();


			$websites = "SELECT * FROM {$table_prefix}affiliates WHERE affiliateid in ($affiliateids)";
			$web_datas = $this->db->prepare($websites);
			//$web_data->bindParam(":publisher_id", $publisherid);
			$web_datas->execute();
			$stmtwebs = $web_datas->fetchAll();
			$num = count($stmtwebs);
			//print_r($num);exit("ok");
			if ($num == 0) {
				$deleteusers = "DELETE FROM {$table_prefix}users WHERE default_account_id in ($accountid)";
				$djax_query_deleteuser = $this->db->prepare($deleteusers);
				//$djax_query_deleteuser->bindParam(":default_account_id", $accountid);
				$djax_query_deleteuser->execute();
			}
			
			$websitename = $stmtweb[0]['name'];
			$datetime = date('Y-m-d H:i:s');
			//audit log maintain
			$delete_user_id = $_SESSION['user_id'];
			$module = 'affiliates_'.$websitename.'_'.$affiliateid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `delete_user_id`,  `deleted_date`) VALUES (:module,:delete_user_id,:deleted_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":delete_user_id", $delete_user_id);
			$audit->bindParam(":deleted_date", $datetime);
			$audit->execute();
			
			$response = array ('response' => 'ok', 'statuscode' => '200', 'msg' => 'Website has been deleted successfully');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'ok', 'msg' => 'Please eneter valid wedsiteid');
			return $this->response->withJson($response);
		}
	}
});


/********************************Website End*******************************/

$app->post('/addusernew/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$email = $input['email'];
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}

		$contactname = $input['contactname'];
		$username = $input['username'];
		$realpassword = $input['password'];
		//password encrypt
		$password = md5($realpassword);
		$language = $input['language'];
		$userid = $input['check_val'];
		$getid = explode(',', $userid);

		if (empty ($contactname) && empty ($email) && empty ($password) && empty ($username)) {
			$response = array ('ok' => 'Please enter all required data');

			return $this->response->withJson($response);
		}

		$check_user = "Select username from {$table_prefix}users where username = :username ;";
		$user_det = $this->db->prepare($check_user);
		$user_det->bindParam(":username", $username);
		$user_det->execute();
		$user_data = $user_det->fetchAll();

		if ($user_data) {
			$response = array ('response' => 'error', 'msg' => 'Username already exists');

			return $this->response->withJson($response);
		}

		$stc = "select account_id from {$table_prefix}agency where agencyid=:agencyid";
		$userper = $this->db->prepare($stc);
		$userper->bindParam(":agencyid", $agencyid);
		$userper->execute();
		$percount = $userper->fetchAll();
		$accountid = $percount[0]['account_id'];

		//print_r($account_id);exit("ok");
		if ($accountid) {

			$adduser = "INSERT INTO {$table_prefix}users(`contact_name`, `email_address`,`language`, `username`, `password`,`default_account_id`,`active`,`date_created`,`email_updated`) 
				VALUES (:contactname,:email,:language,:username,:password,:accountid,1,:datetime,:email_updated);";
			$users = $this->db->prepare($adduser);
			$users->bindParam(":contactname", $contactname);
			$users->bindParam(":email", $email);
			$users->bindParam(":language", $language);
			$users->bindParam(":username", $username);
			$users->bindParam(":password", $password);
			$users->bindParam(":accountid", $accountid);
			$users->bindParam(":datetime", $datetime);
			$users->bindParam(":email_updated", $datetime);
			$users->execute();

			$userid = $this->db->lastInsertId();


			$user_perm = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:accountid,:userid,:datetime);";

			$user_dat_perm = $this->db->prepare($user_perm);
			$user_dat_perm->bindParam(":accountid", $accountid);
			$user_dat_perm->bindParam(":userid", $userid);
			$user_dat_perm->bindParam(":datetime", $datetime);
			$user_dat_perm->execute();

			foreach ($getid as $permission) {
				$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(account_id, user_id, permission_id, is_allowed) VALUES
			(:account_id,:user_id,:permission_id,1);";
				$assoc = $this->db->prepare($userper_assc);
				$assoc->bindParam(":account_id", $accountid);
				$assoc->bindParam(":user_id", $userid);
				$assoc->bindParam(":permission_id", $permission);
				$assoc->execute();
			}
			$response = array (
				'response' => 'ok',
				'msg' => 'User Created sucessfully'
			);

			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Account Id!'
			);
		}
		return $this->response->withJson($response);
	}
});

$app->get('/get_all_agengy_campaigns/[{agencyid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$agency_id = $args['agencyid'];

		$agency = "SELECT * FROM " . $table_prefix . "agency where agencyid =:agencyid";
		$stc = $this->db->prepare($agency);
		$stc->bindParam("agencyid", $agency_id);
		$stc->execute();
		$agency_det = $stc->fetchAll();
		if ($agency_det) {
			$stc = "SELECT c.campaignid,c.campaignname FROM " . $table_prefix . "campaigns as c," . $table_prefix . "clients as cl," . $table_prefix . "agency as ag where c.clientid=cl.clientid AND cl.agencyid = ag.agencyid AND ag.agencyid=:agencyid";
			$std = $this->db->prepare($stc);
			$std->bindParam("agencyid", $agency_id);
			$std->execute();
			$campaign_det = $std->fetchAll();

			if (count($campaign_det) > 0) {
				if ($campaign_det) {
					$response = array ('data' => $campaign_det, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Data');
					return $this->response->withJson($response);
				}
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'No campaigns available for this agencyid!'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Agency Id!',
				'statuscode' => '200'
			);

			return $this->response->withJson($response);
		}
	}
});


/********************************Publisher Add Start*******************************/

$app->post('/add_publisher_new/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them

		$response = array ('response' => 'error', 'msg' => 'Please check with input mandatory parameters and format of input');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$name = $input['name'];
		$contactname = $input['contact'];
		$username = $input['username'];
		$email = $input['email'];
		/* if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
									$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
									return $this->response->withJson($results);
								} */
		$realpassword = $input['password'];
		//password encrypt
		$password = md5($realpassword);
		$datetime = date('Y-m-d H:i:s');
		$agencyid = $args['agencyid'];

		// //validate for reqiured information  

		if (empty ($name) || empty ($contactname) || empty ($email) || empty ($username) || empty ($password)) {
			$results = array ('response' => 'error', 'msg' => 'Please enter all data');
			return $this->response->withJson($response);
		}

		/* if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
									$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
									return $this->response->withJson($results);
								} */


		$agency = "SELECT * FROM " . $table_prefix . "agency where agencyid =:agencyid";
		$stc = $this->db->prepare($agency);
		$stc->bindParam("agencyid", $agencyid);
		$stc->execute();
		$agency_det = $stc->fetchAll();
		//print_r($agency_det);exit("ok");
		$checkcount = count($agency_det);

		if ($checkcount > 0) {
			$check_user = "Select username from {$table_prefix}users where username = :username ;";
			$user_det = $this->db->prepare($check_user);
			$user_det->bindParam(":username", $username);
			$user_det->execute();
			$user_data = $user_det->fetchAll();

			if ($user_data) {

				$response = array ('ERROR' => 'Username already exists in users');
				return $this->response->withJson($response);
			} else {
				$stc = "select * from " . $table_prefix . "publishers where username1=:username";
				$std = $this->db->prepare($stc);
				$std->bindParam("username", $username);
				$std->execute();
				$users = $std->fetchAll();
				if (!$users) {
					$addcl = "INSERT INTO " . $table_prefix . "publishers (`name`,`contact`,`email`,`username1`,`password1`,`category`,`pubtype`,`enviroment_desktop`,`enviroment_mobile`,`enviroment_mobileapp`,`agency_id`,`updated`) VALUES (:name,:contactname,
			:email,:username,:password,'','','','','',:agencyid,:updated);";

					$adv = $this->db->prepare($addcl);
					$adv->bindParam(":name", $name);
					$adv->bindParam(":contactname", $contactname);
					$adv->bindParam(":email", $email);
					$adv->bindParam(":username", $username);
					$adv->bindParam(":password", $password);
					$adv->bindParam(":agencyid", $agencyid);
					$adv->bindParam(":updated", $datetime);
					$adv->execute();

					$id = $this->db->lastInsertId();
					if ($id) {
					
					    //audit log maintain
						$create_user_id = $_SESSION['user_id'];
						$module = 'publishers_'.$name.'_'.$id;
						$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
						$audit = $this->db->prepare($addaudit);
						$audit->bindParam(":module", $module);
						$audit->bindParam(":create_user_id", $create_user_id);
						$audit->bindParam(":created_date", $datetime);
						$audit->execute();

						$response = array ('id' => $id, 'response' => 'ok', 'msg' => 'Publisher has been added successfully with clientid');
						return $this->response->withJson($response);
					}
				} else {
					$response = array ('response' => 'error', 'msg' => 'Username already exists!');
					return $this->response->withJson($response);
				}
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Invalid Agency id!');
			return $this->response->withJson($response);
		}
	}
});
/********************************Publisher Add End*******************************/

$app->post('/edit_publisher_new/[{publisherid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$name = (isset ($input['name'])) ? $input['name'] : '';
		$contact = (isset ($input['contact'])) ? $input['contact'] : '';
		$email = (isset ($input['email'])) ? $input['email'] : '';
		$username = (isset ($input['username'])) ? $input['username'] : '';
		$mode = $input['mode'];
		$datetime = date('Y-m-d H:i:s');
		$publisherid = $args['publisherid'];
		$results = array ();
		if ($mode != 'edit') {
			$response = array ('response' => 'error', 'msg' => 'mode must be edit');
			return $this->response->withJson($response);
			return $response;
			exit;
		}

		$getpublisher = "SELECT * FROM {$table_prefix}publishers where id =:publisherid";
		$pub_edit = $this->db->prepare($getpublisher);
		$pub_edit->bindParam(":publisherid", $publisherid);
		$pub_edit->execute();
		$stmt = $pub_edit->fetchAll();

		if (count($stmt) > 0) {

			if (isset ($input['name'])) {
				$name = $input['name'];
				if (empty ($name)) {
					$results = json_encode(array ('ERROR' => 'Please enter website name'));
					return $results;
				}
			} else {
				$name = $stmt[0]['name'];
			}

			if (isset ($input['contact'])) {
				$contact = $input['contact'];
				if (empty ($contact)) {
					$results = json_encode(array ('ERROR' => 'Please enter contact'));
					return $results;
				}
			} else {
				$contact = $stmt[0]['contact'];
			}

			if (isset ($input['email'])) {
				$email = $input['email'];
				if (empty ($email)) {
					$results = array ('response' => 'error', 'ERROR' => 'Please enter email');
					return $this->response->withJson($results);
				}
				/* 				if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
																	$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
																	return $this->response->withJson($results);
																} */
			} else {
				$email = $stmt[0]['email'];
			}

			if (isset ($input['username'])) {
				$username = $input['username'];
				if (empty ($username)) {
					$results = json_encode(array ('ERROR' => 'Please enter username'));
					return $results;
				}
			} else {
				$username = $stmt[0]['username'];
			}


			$update_publisher = "update {$table_prefix}publishers set  `name`=:name,`contact`=:contact,`email`=:email,`username1`=:username,updated=:updated where id=:publisherid";
			$publisher_query = $this->db->prepare($update_publisher);
			$publisher_query->bindParam(":name", $name);
			$publisher_query->bindParam(":contact", $contact);
			$publisher_query->bindParam(":email", $email);
			$publisher_query->bindParam(":username", $username);
			$publisher_query->bindParam(":updated", $datetime);
			$publisher_query->bindParam(":publisherid", $publisherid);
			$publisher_query->execute();
			
			//audit log maintain
			$update_user_id = $_SESSION['user_id'];
			$module = 'publishers_'.$name.'_'.$publisherid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `update_user_id`,  `updated_date`) VALUES (:module,:update_user_id,:updated_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":update_user_id", $update_user_id);
			$audit->bindParam(":updated_date", $datetime);
			$audit->execute();

			$results = array ('response' => 'ok', 'statuscode' => '200', 'msg' => 'Publisher details has been updated successfully!');
			return $this->response->withJson($results);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Publisher id!');
			return $this->response->withJson($response);
		}
	}
});

/********************************Publisher List Start*******************************/

$app->get('/get_all_publisher/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$publisherdetails = "SELECT * FROM {$table_prefix}publishers where agency_id = :agencyid Order by updated Desc";

		$get_details = $this->db->prepare($publisherdetails);
		$get_details->bindParam(":agencyid", $agencyid);
		$get_details->execute();
		$publisher = $get_details->fetchAll();
		$websitedetail = array ();

		if (count($publisher) > 0) {
			if ($publisher) {
				$response = array ('data' => $publisher, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter valid agency Id!'
			);

			return $this->response->withJson($response);
		}
	}
});

/********************************Publisher List End*******************************/

/********************************Publisher Get Details Start*******************************/

$app->get('/get_publisher/[{publisherid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$publisherid = $args['publisherid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$publisherdetails = "SELECT * FROM {$table_prefix}publishers where id = :publisherid";

		$get_details = $this->db->prepare($publisherdetails);
		$get_details->bindParam(":publisherid", $publisherid);
		$get_details->execute();
		$publisher = $get_details->fetchAll();
		$websitedetail = array ();

		if (count($publisher) > 0) {
			$password = $publisher[0]['password1'];
			$publisherdetail = array (
				'publisherid' => $publisherid,
				'name' => $publisher[0]['name'],
				'contact' => $publisher[0]['contact'],
				'email' => $publisher[0]['email'],
				'username' => $publisher[0]['username1'],
				'password' => $password,
				'category' => $publisher[0]['category']
			);

			if ($publisher) {
				$response = array ('data' => $publisherdetail, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter valid agency Id!'
			);

			return $this->response->withJson($response);
		}
	}
});

/********************************Publisher Get Details End*******************************/

/********************************Publisher Delete Start*******************************/

$app->delete('/delete_publisher_new/[{pubid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$id = $args['pubid'];

		$stc = "select * from " . $table_prefix . "publishers where id in ($id)";
		$std = $this->db->prepare($stc);
		//$std->bindParam("id", $id);
		$std->execute();
		$pub_det = $std->fetchAll();
		$datetime = date('Y-m-d H:i:s');
		if ($pub_det) {
			foreach ($pub_det as $key => $publisher) {
				$id1 .= $publisher['id'] . ',';
			}
			$id = trim($id1, ',');

			$web = "select * from " . $table_prefix . "affiliates where publisher_id in ($id)";
			$website = $this->db->prepare($web);
			//$std->bindParam("clientid", $clientid);
			$website->execute();
			$website_det = $website->fetchAll();

			if ($website_det) {
				foreach ($website_det as $key => $web) {
					$affiliateid1 .= $web['affiliateid'] . ',';
					$accountid1 .= $web['account_id'] . ',';
				}
				$affiliateid = rtrim($affiliateid1, ',');
				$accountid = trim($accountid1, ',');

				$zones = "SELECT * FROM " . $table_prefix . "zones where affiliateid in ($affiliateid)";
				$zon = $this->db->prepare($zones);
				$zon->execute();
				$zone_det = $zon->fetchAll();

				if ($zone_det) {
					foreach ($zone_det as $key => $zone) {
						$zoneid1 .= $zone['zoneid'] . ',';
					}
					$zoneid = rtrim($zoneid1, ',');

					$del_adassoc = "DELETE FROM {$table_prefix}ad_zone_assoc WHERE zone_id in($zoneid)";
					$del_ad = $this->db->prepare($del_adassoc);
					$del_ad->execute();

					$del_placeassoc = "DELETE FROM {$table_prefix}placement_zone_assoc WHERE zone_id in($zoneid)";
					$del_place_ad = $this->db->prepare($del_placeassoc);
					$del_place_ad->execute();

					$del_adhourly = "DELETE FROM {$table_prefix}data_summary_ad_hourly WHERE zone_id in($zoneid)";
					$del_ad_hourly = $this->db->prepare($del_adhourly);
					$del_ad_hourly->execute();

					$del_device = "DELETE FROM {$table_prefix}Stats_Devicetype WHERE zone_id in($zoneid)";
					$del_device_type = $this->db->prepare($del_device);
					$del_device_type->execute();
				}

				$deletezoneassoc = "DELETE FROM {$table_prefix}zones WHERE affiliateid in($affiliateid)";
				$zon_assoc = $this->db->prepare($deletezoneassoc);
				$zon_assoc->execute();

				$deletepub = "DELETE FROM {$table_prefix}affiliates WHERE account_id in($accountid)";
				$del_data = $this->db->prepare($deletepub);
				$del_data->execute();

				$del_channel = "DELETE FROM {$table_prefix}channel WHERE affiliateid in($affiliateid)";
				$del_chnl = $this->db->prepare($del_channel);
				$del_chnl->execute();

				$deleteacc = "DELETE FROM {$table_prefix}accounts WHERE account_id in($accountid)";
				$del_acc = $this->db->prepare($deleteacc);
				$del_acc->execute();

				$deleteusers = "DELETE FROM {$table_prefix}users WHERE default_account_id in($accountid)";
				$djax_query_deleteuser = $this->db->prepare($deleteusers);
				$djax_query_deleteuser->execute();

				$deleteuserassoc = "DELETE FROM {$table_prefix}account_user_assoc WHERE account_id in($accountid)";
				$del_assoc = $this->db->prepare($deleteuserassoc);
				$del_assoc->execute();

				$deletepermission = "DELETE FROM {$table_prefix}account_user_permission_assoc WHERE account_id in($accountid)";
				$del_user_permission = $this->db->prepare($deletepermission);
				$del_user_permission->execute();
			}
			$del_pub = "DELETE FROM " . $table_prefix . "publishers WHERE id in ($id)";
			$cmp = $this->db->prepare($del_pub);
			$success = $cmp->execute();

			if ($success) {
			
			    $publishername = $pub_det[0]['name'];
				$datetime = date('Y-m-d H:i:s');
				//audit log maintain
				$delete_user_id = $_SESSION['user_id'];
				$module = 'publishers_'.$publishername.'_'.$id;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `delete_user_id`,  `deleted_date`) VALUES (:module,:delete_user_id,:deleted_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":delete_user_id", $delete_user_id);
				$audit->bindParam(":deleted_date", $datetime);
				$audit->execute();
			
				$response = array ('response' => 'success', 'statuscode' => '200', 'msg' => 'Publisher has been deleted successfully!');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid publisher id!');
			return $this->response->withJson($response);
		}
	}
});

/********************************Publisher Delete End*******************************/

$app->post('/add_website_new/[{pubid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {
		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();
		$pubid = $args['pubid'];
		$agencyid_det = "select * from " . $table_prefix . "publishers where id=" . $pubid;
		$agencyid_tab = $this->db->prepare($agencyid_det);
		$agencyid_tab->execute();
		$check = $agencyid_tab->fetchAll();
		//print_r($check);exit("ok");

		if (count($check) > 0) {
			$agencyid = $check[0]['agency_id'];
			$contactname = $check[0]['name'];
			$email_id = $check[0]['email'];
			$username = $check[0]['username1'];
			$password = $check[0]['password1'];

			$email = $input['email'];
			/* if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
													$results = array('response' => 'error', 'ERROR' => 'Invalid email format');
													return $this->response->withJson($results);
												} */
			$website = $input['website'];
			if (!filter_var($website, FILTER_VALIDATE_URL)) {
				$results = array ('response' => 'error', 'ERROR' => 'Please enter a valid Website name(website name should start with the prefix of http:// or https://)');
				return $this->response->withJson($results);
			}
			$name = $input['name'];
			$contact = $input['contact'];

			if (empty ($website) || empty ($name) || empty ($contact) || empty ($email)) {
				$response = array ('ERROR' => 'Please enter all required data');
				return $this->response->withJson($response);
			} else {
				$addacc = "INSERT INTO {$table_prefix}accounts(`account_type`, `account_name`) VALUES ('TRAFFICKER',:websitename);";
				$acc_dat = $this->db->prepare($addacc);
				$acc_dat->bindParam(":websitename", $name);
				$acc_dat->execute();
				$accountid = $this->db->lastInsertId();

				$addweb = "INSERT INTO {$table_prefix}affiliates(`agencyid`,`name`,`contact`,`email`,`website`,`updated`,`account_id`,`publisher_id`) VALUES (:agencyid,:websitename,:contact,:email,:website,:updated,:acccountid,:pubid);";
				$web_det = $this->db->prepare($addweb);
				$web_det->bindParam(":agencyid", $agencyid);
				$web_det->bindParam(":websitename", $name);
				$web_det->bindParam(":contact", $contact);
				$web_det->bindParam(":email", $email);
				$web_det->bindParam(":website", $website);
				$web_det->bindParam(":updated", $datetime);
				$web_det->bindParam(":acccountid", $accountid);
				$web_det->bindParam(":pubid", $pubid);
				$web_det->execute();
				$websiteid = $this->db->lastInsertId();

				$user_det = "SELECT user_id from " . $table_prefix . "users as u," . $table_prefix . "affiliates as a where u.default_account_id = a.account_id AND a.publisher_id = $pubid";
				$user_tab = $this->db->prepare($user_det);
				$user_tab->execute();
				$check_user = $user_tab->fetchAll();
				$userid = $check_user[0]['user_id'];
				//print_r($userid);exit("ok");
				if ($check_user) {
					$userpermission = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:acccountid,:user_id,:datetime);";
					$add_permission = $this->db->prepare($userpermission);
					$add_permission->bindParam(":acccountid", $accountid);
					$add_permission->bindParam(":user_id", $userid);
					$add_permission->bindParam(":datetime", $datetime);
					$add_permission->execute();

					$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(`account_id`, `user_id`, `permission_id`, `is_allowed`) VALUES
					(:acccountid,:userid,10,1),
					(:acccountid,:userid,4,1),
					(:acccountid,:userid,2,1),
					(:acccountid,:userid,1,1),
					(:acccountid,:userid,11,1);";

					$assoc = $this->db->prepare($userper_assc);
					$assoc->bindParam(":acccountid", $accountid);
					$assoc->bindParam(":userid", $userid);
					$assoc->execute();
				} else {
					$addusr = "INSERT INTO " . $table_prefix . "users (`contact_name`, `email_address`,
					`username`, `password`,`language`,`default_account_id`,`active`,`date_created`,`sso_user_id`,`date_last_login`,`email_updated`) 
					VALUES (:contactname,:email,:username,:password,'en',:accountid,1,:datetime,NULL,NULL,NULL);";
					$usr = $this->db->prepare($addusr);
					$usr->bindParam(":contactname", $contactname);
					$usr->bindParam(":email", $email_id);
					$usr->bindParam(":username", $username);
					//$usr->bindParam(":comments", $comments);
					$usr->bindParam(":password", $password);
					$usr->bindParam(":accountid", $accountid);
					$usr->bindParam(":datetime", $datetime);
					$usr->execute();

					$user_id = $this->db->lastInsertId();

					$userpermission = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:acccountid,:user_id,:datetime);";
					$add_permission = $this->db->prepare($userpermission);
					$add_permission->bindParam(":acccountid", $accountid);
					$add_permission->bindParam(":user_id", $user_id);
					$add_permission->bindParam(":datetime", $datetime);
					$add_permission->execute();

					$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(`account_id`, `user_id`, `permission_id`, `is_allowed`) VALUES
					(:acccountid,:userid,10,1),
					(:acccountid,:userid,4,1),
					(:acccountid,:userid,2,1),
					(:acccountid,:userid,1,1),
					(:acccountid,:userid,11,1);";

					$assoc = $this->db->prepare($userper_assc);
					$assoc->bindParam(":acccountid", $accountid);
					$assoc->bindParam(":userid", $user_id);
					$assoc->execute();
				}
				
				//audit log maintain
				$create_user_id = $_SESSION['user_id'];
				$module = 'affiliates_'.$name.'_'.$websiteid;
				$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `create_user_id`,  `created_date`) VALUES (:module,:create_user_id,:created_date);";
				$audit = $this->db->prepare($addaudit);
				$audit->bindParam(":module", $module);
				$audit->bindParam(":create_user_id", $create_user_id);
				$audit->bindParam(":created_date", $datetime);
				$audit->execute();
				
				$response = array (
					'response' => 'success',
					'statuscode' => '200',
					'msg' => 'Website added successfully!',
					'affiliate_id' => $websiteid
				);
			}
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Invalid Agency id!');
			return $this->response->withJson($response);
		}
	}
});

$app->get('/get_publisherwise_website/[{pubid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$pubid = $args['pubid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$publisherdetails = "SELECT * FROM {$table_prefix}affiliates where publisher_id = :pubid Order by updated Desc";

		$get_details = $this->db->prepare($publisherdetails);
		$get_details->bindParam(":pubid", $pubid);
		$get_details->execute();
		$publisher = $get_details->fetchAll();
		$websitedetail = array ();

		if (count($publisher) > 0) {
			if ($publisher) {
				$response = array ('data' => $publisher, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array ('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter valid publisher Id!'
			);

			return $this->response->withJson($response);
		}
	}
});


$app->delete('/advertiser_delete/[{clientid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$clientid = $args['clientid'];
		//print_r($clientid);exit("ok");
		$stc = "select * from " . $table_prefix . "clients where clientid in ($clientid)";
		$std = $this->db->prepare($stc);
		//$std->bindParam("clientid", $clientid);
		$std->execute();
		$users = $std->fetchAll();
		//$account_id = $users[0]['account_id'];

		if ($users) {
			foreach ($users as $key => $user) {
				$account_id1 .= $user['account_id'] . ',';
				$client_id1 .= $user['clientid'] . ',';
			}
			$account_id = rtrim($account_id1, ',');
			$clientid = rtrim($client_id1, ',');

			$cam = "select * from " . $table_prefix . "campaigns where clientid in ($clientid)";
			$camp = $this->db->prepare($cam);
			//$std->bindParam("clientid", $clientid);
			$camp->execute();
			$campaigns = $camp->fetchAll();
			if ($campaigns) {
				foreach ($campaigns as $key => $camps) {
					$campaignid1 .= $camps['campaignid'] . ',';
				}
				$campaignid = rtrim($campaignid1, ',');

				$stc1 = "SELECT * FROM " . $table_prefix . "banners where campaignid in ($campaignid)";
				$std1 = $this->db->prepare($stc1);
				$std1->execute();
				$banner_det = $std1->fetchAll();

				if ($banner_det) {

					foreach ($banner_det as $key => $banner) {

						$bannerid1 .= $banner['bannerid'] . ',';
					}

					$bannerid = rtrim($bannerid1, ',');

					$del_ad = "DELETE FROM " . $table_prefix . "ad_zone_assoc   WHERE ad_id in ($bannerid)";
					$ad = $this->db->prepare($del_ad);
					$ad_assoc = $ad->execute();

					$del_adhourly = "DELETE FROM " . $table_prefix . "data_summary_ad_hourly WHERE ad_id in($bannerid)";
					$del_ad_hourly = $this->db->prepare($del_adhourly);
					$del_ad_hourly->execute();

				}


				$del_place = "DELETE FROM " . $table_prefix . "placement_zone_assoc  WHERE placement_id in ($campaignid)";
				$place1 = $this->db->prepare($del_place);
				$placement = $place1->execute();


				$del_ban = "DELETE FROM " . $table_prefix . "banners WHERE campaignid in ($campaignid)";
				$banner_del = $this->db->prepare($del_ban);
				$banner_del->execute();

				$del_cam = "DELETE FROM " . $table_prefix . "campaigns WHERE clientid in ($clientid)";
				$campaign_del = $this->db->prepare($del_cam);
				//$account_del->bindParam(":account_id", $account_id);
				$campaign_del->execute();
			}

			$del_acc = "DELETE FROM " . $table_prefix . "accounts WHERE account_id in ($account_id)";
			$account_del = $this->db->prepare($del_acc);
			//$account_del->bindParam(":account_id", $account_id);
			$acc_del = $account_del->execute();

			$del_pub = "DELETE FROM " . $table_prefix . "clients WHERE account_id in ($account_id)";
			$pub_del = $this->db->prepare($del_pub);
			//$pub_del->bindParam(":account_id", $account_id);
			$pub_del->execute();

			$check_user = "Select * from {$table_prefix}users where default_account_id = :account_id ;";
			$user_det = $this->db->prepare($check_user);
			$user_det->bindParam(":account_id", $account_id);
			$user_det->execute();
			$user_data = $user_det->fetchAll();

			if ($user_data) {
				foreach ($user_data as $key => $user) {
					$user_id1 .= $user['user_id'] . ',';
				}
				$user_id = rtrim($user_id1, ',');
				$acc_usr_pass_rec = "DELETE FROM " . $table_prefix . "password_recovery WHERE user_id in ($user_id)";
				$usr_pass_rec = $this->db->prepare($acc_usr_pass_rec);
				//$acc_usr_permission->bindParam(":account_id", $account_id);
				$usr_pass_rec->execute();
			}
			
			$del_usr = "DELETE FROM " . $table_prefix . "users WHERE default_account_id in ($account_id)";
			$usr_del = $this->db->prepare($del_usr);
			//$usr_del->bindParam(":default_account_id", $account_id);
			$usr_del->execute();

			$acc_assoc = "DELETE FROM " . $table_prefix . "account_user_assoc WHERE account_id in ($account_id)";
			$del_acc_asc = $this->db->prepare($acc_assoc);
			//$del_acc_asc->bindParam(":account_id", $account_id);
			$del_acc_asc->execute();

			$acc_usr_prm = "DELETE FROM " . $table_prefix . "account_user_permission_assoc WHERE account_id in ($account_id)";
			$acc_usr_permission = $this->db->prepare($acc_usr_prm);
			//$acc_usr_permission->bindParam(":account_id", $account_id);
			$acc_usr_permission->execute();

			if ($acc_del) {
			$clientname = $users[0]['clientname'];
			$datetime = date('Y-m-d H:i:s');
			//audit log maintain
			$delete_user_id = $_SESSION['user_id'];
			$module = 'clients_'.$clientname.'_'.$clientid;
			$addaudit = "INSERT INTO " . $table_prefix . "audit_ui (`module`, `delete_user_id`,  `deleted_date`) VALUES (:module,:delete_user_id,:deleted_date);";
			$audit = $this->db->prepare($addaudit);
			$audit->bindParam(":module", $module);
			$audit->bindParam(":delete_user_id", $delete_user_id);
			$audit->bindParam(":deleted_date", $datetime);
			$audit->execute();
			
				$response = array ('response' => 'ok', 'msg' => 'Advertiser has been deleted successfully!');
				return $this->response->withJson($response);
			}
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid account id!');
			return $this->response->withJson($response);
		}
	}
});


$app->get('/get_category/', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
		return $response;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];


		$stc = "SELECT * FROM  djax_category_list ";

		$std = $this->db->prepare($stc);
		//$std->bindParam("agencyid", $agency_id);
		$std->execute();
		$users = $std->fetchAll();

		if ($users) {

			$response = array ('data' => $users, 'response' => 'success', 'statuscode' => '200', 'msg' => 'success');
			return $this->response->withJson($response);
		} else {
			$response = array ('response' => 'error', 'msg' => 'Please enter valid Agency id!');
			return $this->response->withJson($response);
		}
	}
});

$app->post('/addusernew_test/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array ('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array ();
		$agencyid = $args['agencyid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$input = $request->getParsedBody();

		$email = $input['email'];
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			$results = array ('response' => 'error', 'ERROR' => 'Invalid email format');
			return $this->response->withJson($results);
		}

		$contactname = $input['contactname'];
		$username = $input['username'];
		$language = $input['language'];
		$userid = $input['check_val'];
		$getid = explode(',', $userid);

		if (empty ($contactname) && empty ($email) && empty ($username)) {
			$response = array ('ok' => 'Please enter all required data');

			return $this->response->withJson($response);
		}

		$check_user = "Select username from {$table_prefix}users where username = :username ;";
		$user_det = $this->db->prepare($check_user);
		$user_det->bindParam(":username", $username);
		$user_det->execute();
		$user_data = $user_det->fetchAll();

		if ($user_data) {
			$response = array ('response' => 'error', 'msg' => 'Username already exists');

			return $this->response->withJson($response);
		}

		$stc = "select account_id from {$table_prefix}agency where agencyid=:agencyid";
		$userper = $this->db->prepare($stc);
		$userper->bindParam(":agencyid", $agencyid);
		$userper->execute();
		$percount = $userper->fetchAll();
		$accountid = $percount[0]['account_id'];

		//print_r($account_id);exit("ok");
		if ($accountid) {

			$adduser = "INSERT INTO {$table_prefix}users(`contact_name`, `email_address`,`language`, `username`, `password`,`default_account_id`,`active`,`date_created`,`email_updated`) 
				VALUES (:contactname,:email,:language,:username,'',:accountid,1,:datetime,:email_updated);";
			$users = $this->db->prepare($adduser);
			$users->bindParam(":contactname", $contactname);
			$users->bindParam(":email", $email);
			$users->bindParam(":language", $language);
			$users->bindParam(":username", $username);
			$users->bindParam(":accountid", $accountid);
			$users->bindParam(":datetime", $datetime);
			$users->bindParam(":email_updated", $datetime);
			$users->execute();

			$userid = $this->db->lastInsertId();


			$user_perm = "INSERT INTO {$table_prefix}account_user_assoc(`account_id`,`user_id`,`linked`) VALUES (:accountid,:userid,:datetime);";

			$user_dat_perm = $this->db->prepare($user_perm);
			$user_dat_perm->bindParam(":accountid", $accountid);
			$user_dat_perm->bindParam(":userid", $userid);
			$user_dat_perm->bindParam(":datetime", $datetime);
			$user_dat_perm->execute();

			foreach ($getid as $permission) {
				$userper_assc = "INSERT INTO " . $table_prefix . "account_user_permission_assoc(account_id, user_id, permission_id, is_allowed) VALUES
			(:account_id,:user_id,:permission_id,1);";
				$assoc = $this->db->prepare($userper_assc);
				$assoc->bindParam(":account_id", $accountid);
				$assoc->bindParam(":user_id", $userid);
				$assoc->bindParam(":permission_id", $permission);
				$assoc->execute();
			}

			$recoveryId = strtoupper(bin2hex(random_bytes(12)));
			$recoveryId = substr(chunk_split($recoveryId, 8, "-"), 0, -1);

			$user_type = "user";
			$user_recovery = "INSERT INTO {$table_prefix}password_recovery(user_type, user_id, recovery_id, updated)
									VALUES ('" . $user_type . "','" . $userid . "','" . $recoveryId . "','" . $datetime . "')";
			$user_dat_recovery = $this->db->prepare($user_recovery);
			$user_dat_recovery->execute();

			$mail = "Select email_address from {$table_prefix}users where user_id = 1;";
			$mail_det = $this->db->prepare($mail);
			$mail_det->execute();
			$mail_data = $mail_det->fetchAll();

			$from = $mail_data[0]['email_address'];
			include_once ('../../config.php');
			$email_sent = mail($to, $subject, $message, $headers);
			$recoveryUrl = $agencypath . "password_recovery.php?id={$recoveryId}";
			//print_r($from);exit("ok");
			$to = $email;

			$subject = 'Welcome to Adsphere Hub: set up your password';

			$headers .= "MIME-Version: 1.0\r\n";
			$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
			$headers .= 'From: ' . $from . "\r\n";
			$message = '<html><style type="text/css">strong {background: #eee;font-size: 10px;}</style><body>';

			//$message .= '<table width="70%" style="border-color: rgb(102, 102, 102); background: none repeat scroll 0% 0% rgb(226, 226, 226);"  cellspacing="10" cellpadding="10" >';

			$message .= "<p>Dear " . $contactname . ",</p>";
			$message .= "<p>A username has been created for you, enabling you to log in on Adsphere Hub.</p>";
			$message .= "<p>Your username is  '" . $username . "'  </p>";
			$message .= "<p>For security reasons, the password for your username has not been defined yet.</p>";
			$message .= "<p>To enter your password, please click the following link: </p>";
			$message .= "<p><a href='$recoveryUrl' title='Advertiser Login'>$recoveryUrl</a></p>";
			$message .= "<p>Please make sure to enter a safe and unique password.</p>";
			$message .= '<p>Sincerely,</p>';
			$message .= "<p><a href='$from' title='adminmail'>$from</a></p>";
			$message .= "</body></html>";
			//$message .= "</table>";

			mail($to, $subject, $message, $headers);
			$response = array (
				'response' => 'ok',
				'msg' => 'User Created sucessfully'
			);

			return $this->response->withJson($response);
		} else {
			$response = array (
				'response' => 'Error',
				'msg' => 'Invalid Account Id!'
			);
		}
		return $this->response->withJson($response);
	}
});

$app->get('/get_tracker_campaigns/[{clientid},{trackerid}]', function ($request, $response, $args) {
	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$clientid = $args['clientid'];
		$trackerid = $args['trackerid'];

		$clients = "SELECT * FROM " . $table_prefix . "clients where clientid =:clientid";
		$stc = $this->db->prepare($clients);
		$stc->bindParam("clientid", $clientid);
		$stc->execute();
		$client_det = $stc->fetchAll();
		if ($client_det) {
			$stc = "SELECT c.campaignid,c.campaignname,c.clientid,t.status as track_status FROM " . $table_prefix . "campaigns as c, " . $table_prefix . "trackers as t  where t.trackerid=$trackerid AND c.clientid=:clientid";
			$std = $this->db->prepare($stc);
			$std->bindParam("clientid", $clientid);
			$std->execute();
			$campaign_det = $std->fetchAll();
			$datetime = date('Y-m-d H:i:s');

			if (count($campaign_det) > 0) {
				if ($campaign_det) {
					$response = array ('data' => $campaign_det, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
					return $this->response->withJson($response);
				} else {
					$response = array ('response' => 'ok', 'msg' => 'No Data');
					return $this->response->withJson($response);
				}
			} else {

				$response = array (
					'response' => 'error',
					'msg' => 'No campaigns available for this trackerid!'
				);

				return $this->response->withJson($response);
			}
		} else {
			$response = array (
				'response' => 'error',
				'msg' => 'Enter Valid Tracker Id!',
				'statuscode' => '200'
			);

			return $this->response->withJson($response);
		}
	}
});

$app->get('/get_timezone/[{userid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$errors = $request->getAttribute('errors');
		return $this->response->withJson($errors);
	} else {

		$datetime = date('Y-m-d H:i:s');
		$results = array();
		$userid = $args['userid'];
		$table_prefix = $this->get('settings')['path']['table_prefix'];

		$userdetails = "SELECT usr.default_account_id FROM {$table_prefix}users as usr where user_id = :userid";

		$getuser_details = $this->db->prepare($userdetails);
		$getuser_details->bindParam(":userid", $userid);
		$getuser_details->execute();
		$userdet = $getuser_details->fetchAll();
		$accountid = $userdet[0]['default_account_id'];

		$userdetails1 = "SELECT acc.account_id FROM {$table_prefix}account_preference_assoc as acc where account_id = $accountid and preference_id=16";

		$getuser_details1 = $this->db->prepare($userdetails1);
		$getuser_details1->execute();
		$userdet1 = $getuser_details1->fetchAll();

		if (count($userdet1) > 0) {
			$timezonedetails = "SELECT val.value FROM {$table_prefix}account_preference_assoc as val where account_id = $accountid and preference_id=16";
		} else {

			$timezonedetails = "SELECT val.value FROM {$table_prefix}account_preference_assoc as val where account_id = 1 and preference_id=16";
		}
		$get_details = $this->db->prepare($timezonedetails);
		$get_details->execute();
		$timezone = $get_details->fetchAll();

		if (count($timezone) > 0) {
			if ($timezone) {
				$response = array('data' => $timezone, 'response' => 'success', 'msg' => 'success', 'statuscode' => '200');
				return $this->response->withJson($response);
			} else {
				$response = array('response' => 'success', 'msg' => 'No Data', 'statuscode' => '200');
				return $this->response->withJson($response);
			}
		} else {
			$response = array(
				'response' => 'error',
				'msg' => 'Enter valid user id!'
			);

			return $this->response->withJson($response);
		}
	}
});

$app->post('/timezone/[{agencyid}]', function ($request, $response, $args) {

	if ($request->getAttribute('has_errors')) {
		//There are errors, read them
		$response = array('response' => 'error', 'msg' => 'Please check with input parameters');
		return $this->response->withJson($response);
		return $response;
		exit;
	} else {

		$input = $request->getParsedBody();
		$table_prefix = $this->get('settings')['path']['table_prefix'];
		$datetime = date('Y-m-d H:i:s');

		$agencyid = $args['agencyid'];
		$values = $input['value'];

		$accounts = "select account_id from " . $table_prefix . "agency where agencyid=$agencyid";
		$acc = $this->db->prepare($accounts);
		$acc->execute();
		$account = $acc->fetchAll();
		$accountid = $account[0]['account_id'];

		$accounts1 = "select account_id from " . $table_prefix . "account_preference_assoc where account_id=$accountid and preference_id=16";
		$acc1 = $this->db->prepare($accounts1);
		$acc1->execute();
		$account1 = $acc1->fetchAll();

		$acco = count($account1);

		if ($acco > 0) {
			$pub_web = "update " . $table_prefix . "account_preference_assoc set value=:value where account_id=$accountid and preference_id=16";
			$stp1 = $this->db->prepare($pub_web);
			$stp1->bindParam(":value", $values);
			$stp1->execute();
		} else {
			$pub_web = "INSERT INTO " . $table_prefix . "account_preference_assoc(`account_id`,`preference_id`,`value`) VALUES
		
		      ( $accountid ,16,'" . $values . "')";

			$stp1 = $this->db->prepare($pub_web);
			$stp1->execute();
		}

		$_SESSION['timezone'] = $values;

		$response = array('response' => 'ok', 'msg' => 'timezone have been updated successfully');
		return $this->response->withJson($response);

	}
});