<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['websites']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        input[type="button"]:hover {
            color: #fff !important;

        }

        .cancel-style:hover {
            color: #fff !important
        }

        .swal-button--danger {
            background-color: #2523b3;
            width: 100px;
        }

        .swal-button--cancel {
            color: white;
            width: 100px;
            background-color: #ff3e1d;
        }

        .swal-button--cancel:not([disabled]):hover {
            background-color: red;
        }

        .swal-button--danger:not([disabled]):hover {
            background-color: #2523b3;
        }

        .swal-footer {
            text-align: center;
        }

        .alert {
            display: none;
        }

        td {
            max-width: 200px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        td:hover {
            text-overflow: clip;
            white-space: normal;
            word-break: break-all;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }
    </style>
</head>

<body onload="get_all_publisher();">
    <div class="loader"></div>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->
            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->
                <!-- Content wrapper <i class="menu-icon tf-icons bx bx-plus"></i> -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="card my-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6 d-flex justify-content-center justify-content-sm-center justify-content-md-start justify-content-lg-start justify-content-xl-start justify-content-xxl-start">
                                        <p class="h3">
                                            <?php echo $GLOBALS['website']; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col col-12 col-sm-12 col-md-3 col-lg-3 col-xl-3 col-xxl-3 mb-2">
                                        <select id="publist" name="publist" class="form-select text-dark " onchange="getWebsiteDetails('changed')">

                                        </select>
                                    </div>

                                    <div class="col col-12 col-sm-12 col-md-1 col-lg-1 col-xl-1 col-xxl-1 mb-2 d-flex justify-content-center justify-content-sm-center justify-content-md-center justify-content-lg-end justify-content-xl-end justify-content-xxl-end">

                                    </div>
                                    <div class="col col-12 col-sm-12 col-md-8 col-lg-8 col-xl-8 col-xxl-8 h-75 d-flex justify-content-center justify-content-sm-center justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                        <button type="button" class="btn btn-warning" id="backTo_pubList" onclick="window.location.href='publishers_list.php'" style="display:none;">
                                            <i class="bx bx-arrow-back bg-label-white"></i>
                                            <?php echo $GLOBALS['strback']; ?>
                                        </button>&nbsp;
                                        <button type="button" class="btn btn-warning" id="delete_website" onclick="delete_all_websites();" style=""><i class="bx bx-trash" aria-hidden="true" title="Delete"></i>
                                            <?php echo $GLOBALS['delete']; ?>
                                        </button>&nbsp;
                                        <button class="btn btn-warning" type="button" id="website_add" onclick="website_add()" style=""><i class="menu-icon tf-icons bx bx-plus"></i>
                                            <?php echo $GLOBALS['add_websites']; ?>
                                        </button>
                                        <!--&nbsp;
                                        <button class="btn btn-warning" type="button" id="publisher_add"
                                            onclick="window.location.href='website_import.php'"><i
                                                class="menu-icon tf-icons bx bx-file"></i>
                                            <?php echo $GLOBALS['import_websites']; ?>
                                        </button>-->
                                    </div>
                                </div>
                                <hr />
                                <div class="row mt-1">
                                    <div class="col-12">
                                        <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess"><i class="fa fa-check-circle"></i> </p>
                                        <p id="warning" class="h6 alert text-black" style="background: #ffffb3; display:none;"><strong>
                                                <?php echo $GLOBALS['warning']; ?>
                                            </strong>&nbsp;<span id="warning_msg"></span></p>
                                        <!-- <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed"><i class="fa fa-times-circle"></i> </p> -->
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="table-responsive text-nowrap">
                                        <table id="websites_table" class="table table-striped table-hover">
                                            <thead>
                                                <tr class="text-nowrap">
                                                    <th class="th-color text-center">
                                                        <input type="checkbox" class="form-check-input check-rule" id="select-all" name="select_all">
                                                    </th>
                                                    <th class="th-color text-start">
                                                        <?php echo $GLOBALS['strName']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['updated']; ?>
                                                    </th>
                                                    <th class="th-color text-center">
                                                        <?php echo $GLOBALS['action']; ?>
                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script>
        const live_URL = '<?php echo $apiinvenpath; ?>';
        const token = 'Bearer ' + document.getElementById('token').value;
        var agencyid = document.getElementById('agencyid').value;

        var permissions = [];
        //API's
        let getWebsite_url = live_URL + '/get_publisherwise_website/';
        let getallwebsite = live_URL + '/get_all_website/';
        let delete_url = live_URL + '/delete_website/';
        let userid = '<?php echo $_SESSION['user_id']; ?>';
        var pubname = '<?php echo $_REQUEST['pubid']; ?>';
        var pid = '<?php echo $_REQUEST['pub_id']; ?>';
        document.getElementById('backTo_pubList').style.display = (pubname == "") ? "none" : "block";
        if (pubname) {
            $('#publist').attr("disabled", true);
        }
        var pubValue = localStorage.getItem('pubValue');
        $(document).ready(function() {
            $('#delete_website').prop('disabled', true);
        });

        function get_all_publisher() {
            // var camplist_option = $('#camplist option:selected').val();
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_publisher/' + agencyid,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                var pub_name = [];
                console.log("nith", data.msg);
                if (data.msg == "Enter valid agency Id!") {

                    defaultValue = `<option value="0" selected><?php echo $GLOBALS['all_publishers']; ?></option>`;
                    document.getElementById('publist').innerHTML = defaultValue;
                    $('#website_add').attr("disabled", true);
                    $('#publist').show();
                    $('#warning').hide();

                    getWebsiteDetails();
                } else if (!data.data) {

                    defaultValue = `<option value="0" selected><?php echo $GLOBALS['all_publishers']; ?></option>`;
                    document.getElementById('publist').innerHTML = defaultValue;
                    $('#website_add').attr("disabled", true);
                    $('#publist').hide();
                    $('#warning').show();
                    $('#warning_msg').html("<?php echo $GLOBALS['websites_warning']; ?>");
                    getWebsiteDetails();
                } else {
                    $('#publist').show();
                    data.data.map((data) => {
                        getpubLength = (data.name.length > 30) ? (data.name.slice(0, 30) + '...') : data.name;
                        defaultValue = `<option value="0" selected><?php echo $GLOBALS['all_publishers']; ?></option>`;
                        pub_name += `<option value=${data.id} title="${data.name}">${getpubLength}</option>`;
                        document.getElementById('publist').innerHTML = defaultValue + pub_name;


                    });
                    if (pubname != "") {
                        document.getElementById('publist').value = pubname;
                    } else if (pubValue != '' && pubValue != null && pubValue != 'undefined') {
                        $('#publist option').each(function() {
                            if (this.value == pubValue) {
                                $("#publist").val(pubValue);
                            }
                        });
                        // document.getElementById('advlist').value = advValue;
                    }
                    getWebsiteDetails();
                }
            });
        }

        getWebsiteDetails = (changed) => {
            $(".loader").show();
            if (pubname != "") {

                var pubid = pubname;
            } else {
                var pubid = $("#publist option:selected").val();
            }

            if (pubid == 0) {
                $('#website_add').attr("disabled", true);
            } else {
                $('#website_add').attr("disabled", false);
            }
            let rows_selected = [],
                websiteTable;

            $.ajax({
                url: (pubid == 0) ? getallwebsite + agencyid : getWebsite_url + pubid,
                type: 'GET',
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                success: function(data) {

                    if (data.msg == 'No Data' || data.msg == 'Enter valid agency Id!' || data.msg == 'Enter valid publisher Id!') {
                        $(".loader").hide();
                        $('#websites_table').DataTable({
                            ordering: false,
                            destroy: true,
                            responsive: true,
                            bPaginate: false,
                            bInfo: false,
                            data: [],
                            searching: false,
                            oLanguage: {
                                sEmptyTable: `<?php echo $GLOBALS['strNo_Data_Meassages']; ?>`
                            }
                        });
                    } else {
                        $(".loader").hide();
                        websiteTable = $('#websites_table').DataTable({
                            destroy: true,
                            targets: 0,
                            searchable: false,
                            orderable: false,
                            stateSave: true,
                            //className: 'dt-body-center',
                            responsive: false,
                            data: data.data,
                            columns: [{
                                    data: 'pubid',
                                    className: "text-center",
                                    orderable: false,
                                    render: function(data, type, row, meta) {
                                        return '<input type="checkbox" class="data-checked form-check-input select-checkbox" value="' + row.affiliateid + '"data-website-id="' + row.affiliateid + '" name="checkrow" id="checkrow" >';
                                    }
                                },
                                {
                                    'data': null,
                                    title: 'Name',
                                    className: "text-start",
                                    wrap: true,
                                    "render": function(web) {
                                        if (pubname != '') {
                                            return '<a href="websites_edit.php?pubid=' + web.publisher_id + '&' + 'affiliateid=' + web.affiliateid + '&' + 'params=1">' + web.name + '</a>'
                                        } else {
                                            return '<a href="websites_edit.php?pub_id=' + web.publisher_id + '&' + 'affiliateid=' + web.affiliateid + '">' + web.name + '</a>'
                                        }
                                        //return '<a href="websites_edit.php?pub_id=' + web.publisher_id + '&affiliate_id=' + web.affiliateid + '&website=' + web.name + '">' + web.name + '</a>'
                                    }
                                },
                                {
                                    data: 'updated',
                                    className: "text-center",
                                    render: function(data, type, row, meta) {
                                        return row.updated;
                                    }
                                },
                                {
                                    data: 'contact',
                                    className: "text-center",
                                    render: function(data, type, row, meta) {
                                        if (pubname != '') {
                                            var zoneicon = '<a class="btn btn-icon btn-xs btn-warning" href="zonelist.php?pubid=' + row.publisher_id + '&affiliate_id=' + row.affiliateid + '"> <i class="bx bx-list-ul  fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['strInventory_Zone_List']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="delivery_rule_set.php?pubid=' + row.publisher_id + '&affiliateid=' + row.affiliateid + '"> <i class="fa fa-bullseye fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['menu_site_rule']; ?>"></i></a>&nbsp;';

                                            var addzone = '<a class="btn btn-icon btn-xs btn-warning delete_permission" href="zone_add.php?affiliate_id=' + row.affiliateid + '&pubid=' + row.publisher_id + '&params=1"> <i class="bx bx-plus fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['strInventory_AddZone']; ?>"></i></a>&nbsp;'

                                            return '<div class="row"><div>' + addzone + ' ' + zoneicon + ' </div></div>';
                                        } else {
                                            var zoneicon = '<a class="btn btn-icon btn-xs btn-warning" href="zonelist.php?pub_id=' + row.publisher_id + '&affiliate_id=' + row.affiliateid + '"> <i class="bx bx-list-ul  fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['strInventory_Zone_List']; ?>"></i></a>&nbsp;&nbsp;<a class="btn btn-icon btn-xs btn-warning" href="delivery_rule_set.php?pub_id=' + row.publisher_id + '&affiliateid=' + row.affiliateid + '"> <i class="fa fa-bullseye fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['menu_site_rule']; ?>"></i></a>&nbsp;';

                                            var addzone = '<a class="btn btn-icon btn-xs btn-warning delete_permission" href="zone_add.php?affiliate_id=' + row.affiliateid + '&pub_id=' + row.publisher_id + '&params=1"> <i class="bx bx-plus fa-4x" style="font-size:14px" title="<?php echo $GLOBALS['strInventory_AddZone']; ?>"></i></a>&nbsp;'

                                            return '<div class="row"><div>' + addzone + ' ' + zoneicon + ' </div></div>';

                                        }

                                    }
                                },
                            ]
                        });

                        // Handle click on checkbox
                        $('#websites_table tbody').on('click', 'input[type="checkbox"]', function(e) {
                            let $row = $(this).closest('tr');
                            let data = websiteTable.row($row).data();
                            let rowId = websiteTable.row(this).data[0];
                            let index = $.inArray(rowId, rows_selected);

                            if (this.checked && index === -1) {
                                rows_selected.push(rowId);
                            } else if (!this.checked && index !== -1) {
                                rows_selected.splice(index, 1);
                            }

                            if (this.checked) {
                                $row.addClass('selected');
                                document.getElementById('delete_website').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $row.removeClass('selected');
                                document.getElementById('delete_website').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }
                            updateDataTableSelectAllCtrl(websiteTable);
                            e.stopPropagation();
                        });

                        // Handle click on "Select all" control
                        $('thead input[name="select_all"]', websiteTable.table().container()).on('click', function(e) {
                            if (this.checked) {
                                $('#websites_table tbody input[type="checkbox"]:not(:checked)').trigger('click');
                                document.getElementById('delete_website').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            } else {
                                $('#websites_table tbody input[type="checkbox"]:checked').trigger('click');
                                document.getElementById('delete_website').disabled = $('.data-checked:checked').length > 0 ? false : true;
                            }
                            e.stopPropagation();
                        });

                        // Handle table draw event
                        websiteTable.on('draw', function() {
                            updateDataTableSelectAllCtrl(websiteTable);
                        });
                    }
                }

            });
            $.ajax({
                type: "GET",
                url: live_URL + '/get_permissions/' + userid,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                dataType: "json",
                encode: true,
            }).done(function(data) {
                let get_data = data.data;
                if (get_data) {
                    for (var i = 0; i < get_data.length; i++) {
                        permissions[i] = get_data[i];
                    }
                } else {
                    permissions = '';
                }
                if (permissions.includes('38')) {
                    $('#website_add').hide();
                } else {
                    $('#website_add').show();
                }
                if (permissions.includes('39')) {
                    // $('input[type="checkbox"]').hide();
                    $('#websites_table').DataTable().column(0).visible(false);
                    $('#delete_website').hide();

                } else {
                    $('#websites_table').DataTable().column(0).visible(true);
                    $('#delete_website').show();
                }
                if (permissions.includes('40')) {

                    $('.delete_permission').hide();

                } else {
                    $('.delete_permission').show();
                }

            });
            localStorage.setItem('pubValue', $("#publist option:selected").val());
        };

        $(document).on('click', '.data-checked', function() {
            document.getElementById('delete_website').disabled = $('.data-checked:checked').length > 0 ? false : true;
            document.getElementById('select-all').checked = ($('.data-checked:checked').length == $('.data-checked').length) ? true : false;
        });

        function updateDataTableSelectAllCtrl(table) {
            var $table = table.table().node();
            var $chkbox_all = $('tbody input[type="checkbox"]', $table);
            var $chkbox_checked = $('tbody input[type="checkbox"]:checked', $table);
            var chkbox_select_all = $('thead input[name="select_all"]', $table).get(0);

            // If none of the checkboxes are checked
            if ($chkbox_checked.length === 0) {
                chkbox_select_all.checked = false;
                if (chkbox_select_all) {
                    chkbox_select_all = false;
                }
                // If all of the checkboxes are checked
            } else if ($chkbox_checked.length === $chkbox_all.length) {
                chkbox_select_all.checked = true;
                if (chkbox_select_all) {
                    chkbox_select_all.indeterminate = false;
                }
                // If some of the checkboxes are checked
            } else {
                chkbox_select_all.checked = false;
            }
        }

        function delete_website(web_id) {
            swal({
                title: `<?php echo $GLOBALS['website_delete']; ?>`,
                buttons: {
                    cancel: `<?php echo $GLOBALS['strCancel']; ?>`,
                    danger: "Confirm",
                },
            }).then(function(isConfirm) {
                if (isConfirm) {
                    $.ajax({
                        type: "DELETE",
                        url: delete_url + web_id,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        if (data.msg = "Website has been deleted successfully" && data.statuscode == 200) {
                            $("#alertsuccess").show('medium');
                            $("#alertsuccess").html('<?php echo $GLOBALS['website_delete_msg']; ?>');
                            setTimeout(function() {
                                $("#alertsuccess").hide('medium');
                            }, 1000);
                            setTimeout(function() {
                                location.reload();
                            }, 1000);
                        } else {
                            $("#alertfailed").show('medium');
                            $("#alertfailed").html('data.msg');
                            setTimeout(function() {
                                $("#alertfailed").hide('medium');
                            }, 1000);
                        }
                    });
                }
            });
        }

        function delete_all_websites() {
            var websiteData = [];
            var selected = $('.data-checked:checked');
            selected.each(function() {
                websiteData.push($(this).attr('data-website-id'));
            });
            if (websiteData.length <= 0) {
                alert("Please select records.");
            } else {
                swal({
                    title: `<?php echo $GLOBALS['websites_delete']; ?>`,
                    buttons: {
                        cancel: "Cancel",
                        danger: "Ok",
                    },
                }).then(function(isConfirm) {
                    if (isConfirm) {
                        $.ajax({
                            type: "DELETE",
                            url: delete_url + websiteData,
                            beforeSend: function(xhr) {
                                xhr.setRequestHeader('Authorization', token);
                            },
                            dataType: "json",
                            encode: true,
                        }).done(function(data) {

                            if (data.msg = "Website has been deleted successfully" && data.statuscode == 200) {
                                $("#alertsuccess").show('medium');
                                $("#alertsuccess").html('<?php echo $GLOBALS['websites_delete_msg']; ?>');
                                setTimeout(function() {
                                    $("#alertsuccess").hide('medium');
                                }, 1500);
                                setTimeout(function() {
                                    location.reload();
                                }, 1500);
                            }
                            // } else {
                            //     $("#alertfailed").show('medium');
                            //     $("#alertfailed").html(data.msg);
                            //     setTimeout(function() {
                            //         $("#alertfailed").hide('medium');
                            //     }, 1500);
                            // }
                        });
                    }
                });
            }
        }

        function website_add() {

            let publisherid = $('#publist').val();
            window.location.href = pubname == '' ? 'websites_add.php?pub_id=' + publisherid + '' :
                'websites_add.php?pubid=' + pubname + '';

        }
    </script>

</body>

</html>