<?php
//session_start();
include('../config.php');
include('../common.php');

?>

<!DOCTYPE html>
<html lang="en" class="light-style customizer-hide" dir="ltr" data-theme="theme-default" data-assets-path="../assets/"
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

    <title>
        <?php echo $projecttitle; ?>
    </title>
    <?php include('head.php'); ?>
    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo $faviconpath; ?>" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet" />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="../assets/vendor/fonts/boxicons.css" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="../assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="../assets/vendor/css/theme-default.css" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="../assets/css/demo.css" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />

    <!-- Page CSS -->
    <!-- Page -->
    <link rel="stylesheet" href="../assets/vendor/css/pages/page-auth.css" />
    <!-- Helpers -->
    <script src="../assets/vendor/js/helpers.js"></script>

    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../assets/js/config.js"></script>
    <style>
        @media screen and (min-width:420px) {
            button {
                width: 100%;
                margin: auto;
                margin-bottom: 10%;
            }

            img {
                width: 90%;
                margin: auto;
            }

            .form-control {
                height: 35px;
            }

            .btn-primary,
            .btn-primary:hover {
                background-color: #5f61e6 !important;
                color: #fff !important;
                border: #5f61e6  1px solid;
            }

            .alert {
                display: none;
            }
        }

        @media screen and (max-width: 419px) {
            form {
                width: 90%;
                margin: auto;
            }

            label {
                display: flex;
                justify-content: start;

            }

            button {
                width: 50%;
                margin: auto;
            }

            img {
                width: 70%;
                margin: auto;
            }

            .form-group {
                margin-top: 5%;
                margin-bottom: 5%;
            }

            .form-control {
                height: 35px;
            }

            .alert {
                display: none;
            }
        }

        @media screen and (max-width: 330px) {
            form {
                width: 60%;
                margin: auto;
            }

            label {
                display: flex;
                justify-content: center;
            }

            button,
            img {
                width: 50%;
                margin: auto;
            }

            .form-control {
                height: 35px;
            }

            .alert {
                display: none;
            }
        }

        /* form focus */
        .form-control:focus,
        .form-select:focus,
        .input-group:focus-within .form-control,
        .input-group:focus-within .input-group-text {
            border-color: #5f61e6;
        }

        .bgcolor {
            background-color: #e6e6e6;
        }

        .loader {
            display: none;
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 999;
            background: rgba(255, 255, 255, 0.8) url("../assets/img/loader.gif") center no-repeat;
        }
    </style>
</head>

<body onload="getuser()">
    <div class="loader"></div>
    <!-- Content -->

    <div class="container-xxl bg-login">
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="">
                <!-- Register -->
                <div class="card login-size">
                    <div class="card-body">
                        <div class="container">
                            <div class="div" id="setpassword" style="display:none">
                                <div class="row mt-2">
                                    <center><img src="<?php echo $logopath; ?>" width="170px;" alt="no logo"></img>
                                    </center>
                                    <h5 class="mt-2 mb-4 text-center text-dark">
                                        <?php echo $GLOBALS['']; ?>
                                        Create Password
                                    </h5>

                                    <p class="alert bg-success alert-dismissible fade show text-white" id="alertsuccess"
                                        style="display: none;"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['password_success']; ?>
                                    </p>

                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed1"
                                        style="display: none;">
                                        <i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['password_not_updated']; ?>
                                    </p>
                                </div>

                                <div class="form-group mb-3 mb-sm-3 mb-md-3 mb-lg-3 mb-xl-3 mb-xxl-3">
                                    <label for="email" class="form-label text-dark">
                                        <?php echo $GLOBALS['strUsername']; ?>
                                    </label>
                                    <input type="text" class="form-control" id="username" name="username" readonly>

                                </div>
                                <div class="form-group mb-3 mb-sm-3 mb-md-3 mb-lg-3 mb-xl-3 mb-xxl-3">
                                    <label for="inputName" class="form-label text-dark">
                                        <?php echo $GLOBALS['newpassword']; ?>
                                    </label>
                                    <input type="password" class="form-control" id="password1" name="password1"
                                        placeholder="Min length 12 characters"
                                        onchange="newpassword_validtion(this.value);"
                                        onkeyup="newpassword_validtion(this.value);">
                                    <span id="message" style="color:red"> </span>
                                </div>
                                <div class="form-group mb-3 mb-sm-3 mb-md-3 mb-lg-3 mb-xl-3 mb-xxl-3">
                                    <label for="inputName" class="form-label text-dark">
                                        <?php echo $GLOBALS['reenterpassword']; ?>
                                    </label>
                                    <input type="password" class="form-control" id="password2" name="password2"
                                    placeholder="Re-enter your password"
                                        onchange="repassword_validtion(this.value);"
                                        onkeyup="repassword_validtion(this.value);">
                                    <span id="message2" style="color:red"> </span>
                                </div>
                                <div class="mt-5">
                                    <button type="button" id="submitbtn" class="btn btn-warning submitbtn"
                                        onclick="savepassword()">
                                        <?php echo $GLOBALS['strSubmit']; ?>
                                    </button>
                                </div>
                            </div>
                            <div class="div" id="sentemail" style="display:none">
                                <div class="row">
                                    <center><img src="<?php echo $logopath; ?>" width="170px;" alt="no logo"></img>
                                    </center>
                                    <p class="alert alert-warning mt-2" id="alertwarning"><i
                                            class="fa-solid fa-circle-xmark"></i>
                                        <?php echo $GLOBALS['expire_password']; ?>
                                    </p>
                                    <p class="alert bg-success alert-dismissible fade show text-white" id="mail_success"
                                        style="display: none;"><i class="fa fa-check-circle"></i>
                                        <?php echo $GLOBALS['sent_mail_success']; ?>
                                    </p>
                                    <p class="alert alert-warning"
                                        id="userwarning" style="display: none;"><i class="fa fa-circle-info"></i>
                                        <?php echo $GLOBALS['user_not_found']; ?>
                                    </p>
                                    <div class="form-group mb-3 mb-sm-3 mb-md-3 mb-lg-3 mb-xl-3 mb-xxl-3">
                                        <label for="inputName" class="form-label text-dark">
                                            <?php echo $GLOBALS['enter_mail']; ?>
                                        </label>
                                        <input type="text" class="form-control" id="email" name="email"
                                        placeholder="Enter email address"
                                            onchange="email_validtion(this.value);"
                                            onkeyup="email_validtion(this.value);"><br>
                                        <span id="email_val" style="color:red"> </span>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="button" id="sentbtn" class="btn btn-primary submitbtn"
                                        onclick="resentmail()">
                                        <?php echo $GLOBALS['strSubmit']; ?>
                                    </button>
                                </div>
                            </div>
                            <!-- </div> -->
                        </div>
                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>

    <!-- / Content -->

    <!-- <div class="buy-now">
        <a
        href="https://themeselection.com/products/sneat-bootstrap-html-admin-template/"
        target="_blank"
        class="btn btn-danger btn-buy-now"
        >Upgrade to Pro</a
        >
    </div> -->

    <!-- Core JS -->
    <!-- build:js assets/vendor/js/core.js -->
    <script src="../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../assets/vendor/libs/popper/popper.js"></script>
    <script src="../assets/vendor/js/bootstrap.js"></script>
    <script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>

    <script src="../assets/vendor/js/menu.js"></script>
    <!-- endbuild -->

    <!-- Vendors JS -->

    <!-- Main JS -->
    <script src="../assets/js/main.js"></script>
    <script src="../js/sweetalert.min.js"></script>

    <!-- Page JS -->

    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script>
        var live_URL = '<?php echo $apisignpath; ?>';


        var id = '<?php echo $_REQUEST['id']; ?>';
        // $("#setpassword").hide();
        // $("#sentemail").hide();

        function getuser() {

            $.ajax({
                url: live_URL + '/get_user/' + id,
                type: 'GET',

                dataType: 'json',
                encode: true,
                success: function (data) {
                    if (data.msg == 'url link is expired' || data.msg == 'No data found') {
                        $("#setpassword").hide();
                        $("#sentemail").show();
                        $("#alertwarning").show();
                    } else {
                        $("#setpassword").show();
                        $("#sentemail").hide();
                        $("#username").val(data.username);
                    }
                },
                //error: function () { },
            });
        }

        function newpassword_validtion(that) {
            if (that == "") {
                document.getElementById("message").innerHTML = '<?php echo $GLOBALS['fill_password']; ?>';
                return false;
            } else if (that.length < 8) {
                document.getElementById("message").innerHTML = "<?php echo $GLOBALS['password_length']; ?>";
                return false;
            } else if (that.length > 15) {
                document.getElementById("message").innerHTML = "<?php echo $GLOBALS['password_length2']; ?>";
                return false;
            } else {
                document.getElementById("message").innerHTML = "";
            }
        }

        function repassword_validtion(that) {
            var pw1 = document.getElementById("password1").value;
            if (that == "") {
                document.getElementById("message2").innerHTML = "<?php echo $GLOBALS['fill_password']; ?>";
                return false;
            } else if (pw1 != that) {
                document.getElementById("message2").innerHTML = "<?php echo $GLOBALS['same_password']; ?>";
                return false;
            } else {
                document.getElementById("message2").innerHTML = "";
            }
        }

        function email_validtion(that) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if (that == '') {
                $("#email_val").html("<?php echo $GLOBALS['enter_emailid']; ?>");
                $("#email_val").css("color", "red").val(that);
            } else if (regex.test(that) == false) {
                $("#email_val").html("<span style='padding-top:10px;'><?php echo $GLOBALS['enter_right_emailid']; ?></span>");
                //$("#txtContactEmail").val('');
                $("#email_val").css("color", "red").val(that);
            } else {
                $("#email_val").html("");
            }
        }

        function savepassword() {
            var pw1 = document.getElementById("password1").value;
            var pw2 = document.getElementById("password2").value;
            //check empty password field
            if (pw1 == "") {
                document.getElementById("message").innerHTML = "<?php echo $GLOBALS['fill_password']; ?>";
                return false;
            } else {
                document.getElementById("message").innerHTML = "";
            }
            //check empty confirm password field  
            if (pw2 == "") {
                document.getElementById("message2").innerHTML = "<?php echo $GLOBALS['fill_password']; ?>";
                return false;
            } else {
                document.getElementById("message2").innerHTML = "";
            }
            //minimum password length validation
            if (pw1.length < 8) {
                document.getElementById("message").innerHTML = "<?php echo $GLOBALS['password_length']; ?>'";
                return false;
            } else {
                document.getElementById("message").innerHTML = "";
            }

            //maximum length of password validation
            if (pw1.length > 15) {
                document.getElementById("message").innerHTML = "<?php echo $GLOBALS['password_length2']; ?>'";
                return false;
            } else {
                document.getElementById("message").innerHTML = "";
            }
            if (pw1 != pw2) {
                document.getElementById("message2").innerHTML = "<?php echo $GLOBALS['same_password']; ?>";
                return false;
            }

            var username = $("#username").val();
            var password = $("#password1").val();
            var password2 = $("#password2").val();

            var formData = {
                "password": password
            };
            $.ajax({
                url: live_URL + '/user_password/' + id,
                type: 'POST',

                data: formData,
            }).done(function (data) {
                if (data.data.msg == 'password updated successfully!'&& data.data.statuscode== "200") {
                    window.scrollTo(0, 0);
                    $("#alertsuccess").show('medium');
                    setTimeout(function () {
                        $("#alertsuccess").hide('medium');
                    }, 1700);
                    setTimeout(function () {
                        location.reload();
                        window.location.href = "index.php";
                    }, 1700);
                } else {
                    window.scrollTo(0, 0);
                    $("#alertfailed").show('medium');
                    setTimeout(function () {
                        $("#alertfailed").hide('medium');
                        location.reload();
                    }, 2000);
                }
            });
        }

        function resentmail() {
            var email = document.getElementById("email").value;

            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;

            if (email == '') {
                $("#email_val").html("<?php echo $GLOBALS['enter_emailid']; ?>");
                $("#email_val").css("color", "red").val(email);
            } else if (regex.test(email) == false) {
                $("#email_val").html("<span style='padding-top:10px;'><?php echo $GLOBALS['enter_right_emailid']; ?></span>");
                //$("#txtContactEmail").val('');
                $("#email_val").css("color", "red").val(email);
            } else {
                $("#email_val").html("");
            }

            var formData = {
                "email": email
            };
            
            if (email != '' && regex.test(email) == true) {
                $(".loader").show();
                $.ajax({
                    url: live_URL + '/user_password_resend/' + id,
                    type: 'POST',

                    data: formData,
                }).done(function (data) {
                    $(".loader").hide();
                    if (data.msg == 'Mail sent successfully') {
                        window.scrollTo(0, 0);
                        $("#mail_success").show('medium');
                        setTimeout(function () {
                            $("#mail_success").hide('medium');
                            location.reload();
                            window.location.href = "index.php";
                        }, 2000);
                    } else if (data.msg == 'User not found') {
                        window.scrollTo(0, 0);
                        $("#alertwarning").hide('medium');
                        $("#userwarning").show('medium');
                        setTimeout(function () {
                            $("#userwarning").hide('medium');
                            location.reload();
                            //window.location.href = "index.php";
                        }, 2000);
                    } else {
                        window.scrollTo(0, 0);
                        $("#alertfailed").show('medium');
                        setTimeout(function () {
                            $("#alertfailed").hide('medium');
                            location.reload();
                        }, 2000);
                    }
                });
            }
        }

    </script>

</body>

</html>