<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['tracker']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        /* #trackername,
        #description,
        #type,
        #status {
            width: 50%;
            display: inline;
        } */

        #uniquewindow_day,
        #uniquewindow_hours,
        #uniquewindow_minutes,
        #uniquewindow_sec {
            width: 3rem;
            display: inline;
        }

        #is_unique {
            margin-left: 62%;
            margin-top: 7%;
        }

        .alert {
            display: none;
        }

        thead,
        tbody {
            display: block;
        }

        tbody {
            max-height: 450px;
            overflow-y: auto;
            overflow-x: auto;
        }

        tr,
        td {
            width: 1000px;
        }
    </style>
</head>

<body onload="get_variable();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top mt-5 mb-4">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="adv_tracker_edit.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['tracker_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_campaigns.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['link_campaigns']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><span class="text-primary">
                                            <?php echo $GLOBALS['variables']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_append.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['append_tracker_code']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_invocation.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['invocation_code']; ?>
                                        </span></a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="" role="tabpanel">
                                    <div>
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['variable_update_success_msg']; ?>
                                        </p>
                                        <p class="alert bg-danger alert-dismissible fade show text-white"
                                            id="alertfailed">
                                            <i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['variable_update_failed_msg']; ?>
                                        </p>
                                    </div>
                                    <!-- <div class="card-body"> -->
                                    <div class="row mt-3">
                                        <h5>
                                            <?php echo $GLOBALS['tracking_settings']; ?>
                                        </h5>
                                        <hr class="solid">
                                        <div class="mb-4 col-md-3">
                                            <label for="inputName" class="col-form-label" style="margin-left: 3rem;">
                                                <?php echo $GLOBALS['tracker_type']; ?>
                                            </label>
                                        </div>
                                        <div class="mb-4 col-md-6">
                                            <select id="tracktype" name="tracktype" class="form-select text-dark"
                                                onchange="tracktype()">
                                                <option value="js">
                                                    <?php echo $GLOBALS['js_variables']; ?>
                                                </option>
                                                <option value="default" selected>
                                                    <?php echo $GLOBALS['js_variables_backward']; ?>
                                                </option>
                                                <option value="dom">
                                                    <?php echo $GLOBALS['html_dom']; ?>
                                                </option>
                                                <option value="custom">
                                                    <?php echo $GLOBALS['js_code']; ?>
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <h5>
                                            <?php echo $GLOBALS['variables']; ?>
                                        </h5>
                                    </div>
                                    <div class="table-responsive text-nowrap">
                                        <table id="track_variable" class="table table-striped table-responsive ">
                                            <tbody id="table_body">
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="row">
                                        <div class="mb-1 col-md-3">
                                            <label for="inputName" class="col-form-label" style="">
                                                <?php echo $GLOBALS['add_variable']; ?> &nbsp; <button
                                                    class="btn rounded-pill btn-icon text-primary" id="addBtn"><i
                                                        class="fa-solid fa-circle-plus" id="variable"></i></button>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="row mb-3 mt-3">
                                        <div class="col">
                                            <button type="button" id="submitbtn" style="float:right;"
                                                class="btn btn-primary submitbtn" onclick="addvariable()">
                                                <?php echo $GLOBALS['save_changes']; ?>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- </div> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var trackerid = '<?php echo $_REQUEST['trackerid']; ?>';

        var row_id = 0;

        function tracktype() {
            var select_option = $('#tracktype option:selected').val();
            if (select_option == "js" || select_option == "default" || select_option == "dom") {
                $(".varcode").hide();
            } else {
                $(".varcode").show();
            }
        }

        $('#addBtn').on('click', function () {
            var select_option = $('#tracktype option:selected').val();

            $('#track_variable').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="client-browser">           
                                            <div class="row">
                                                <div class="mb-3 col-md-12" id="">
                                                    <p><?php echo $GLOBALS['track_variable']; ?></p>
                                                    <hr class="solid">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 3rem;">
                                                        <?php echo $GLOBALS['variable_name']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <input type="text" class="form-control" id="name" name="name">
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <button class="btn rounded-pill btn-icon text-primary remove"
                                                        style="float:right;" value="" id="remove">
                                                        <i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 3rem;">
                                                        <?php echo $GLOBALS['strInventory_Description']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <input type="text" class="form-control" id="description"
                                                        name="description">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 3rem;">
                                                        <?php echo $GLOBALS['data_type']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <select id="datatype" name="datatype"
                                                        class="form-select text-dark">
                                                        <option value="string" selected>
                                                            <?php echo $GLOBALS['string']; ?>
                                                        </option>
                                                        <option value="numeric">
                                                            <?php echo $GLOBALS['num']; ?>
                                                        </option>
                                                        <option value="date">
                                                            <?php echo $GLOBALS['strReport_Website_Data']; ?>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 3rem;">
                                                        <?php echo $GLOBALS['purpose']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <select id="purpose" name="purpose" class="form-select text-dark">
                                                        <option value="" selected>
                                                            <?php echo $GLOBALS['generic']; ?>
                                                        </option>
                                                        <option value="basket_value">
                                                            <?php echo $GLOBALS['basket_val']; ?>
                                                        </option>
                                                        <option value="num_items">
                                                            <?php echo $GLOBALS['no_of_items']; ?>
                                                        </option>
                                                        <option value="post_code">
                                                            <?php echo $GLOBALS['postcode']; ?>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 3rem;">
                                                        <?php echo $GLOBALS['reject_if_empty']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <input class="form-check-input" type="checkbox" id="reject_if_empty"
                                                        name="reject_if_empty">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="mb-3 col-md-3">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 3rem;margin-top: 2%;">
                                                        <?php echo $GLOBALS['dedup_conversions']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-2">
                                                    <input class="form-check-input" type="checkbox" id="is_unique"
                                                        name="is_unique" onclick="dedupconversion(${row_id})">
                                                </div>
                                            </div>
                                            <div class="uniquewindow" style="display:none;">
                                            <div class="row">  
                                            <div class="mb-3 col-md-4"> </div>                                               
                                                <div class="mb-3 col-md-4">                                                   
                                                    <label for="inputName" class="col-form-label"
                                                        style="">
                                                        <?php echo $GLOBALS['unique_window']; ?>
                                                    </label>
                                                        <input type="text" class="form-control" id="uniquewindow_day"
                                                        name="uniquewindow_day">
                                                    <label for="inputName" class="col-form-label"
                                                        style="">
                                                        <?php echo $GLOBALS['day']; ?>
                                                    </label>
                                                        <input type="text" class="form-control" id="uniquewindow_hours"
                                                        name="uniquewindow_hours">
                                                    <label for="inputName" class="col-form-label"
                                                        style="">
                                                        <?php echo $GLOBALS['hour']; ?>
                                                    </label>
                                                        <input type="text" class="form-control" id="uniquewindow_minutes"
                                                        name="uniquewindow_minutes">
                                                    <label for="inputName" class="col-form-label"
                                                        style="">
                                                        <?php echo $GLOBALS['minutes']; ?>
                                                    </label>
                                                        <input type="text" class="form-control" id="uniquewindow_sec"
                                                        name="uniquewindow_sec">
                                                    <label for="inputName" class="col-form-label"
                                                        style="">
                                                        <?php echo $GLOBALS['seconds']; ?>
                                                    </label> 
                                                </div>
                                            </div>
                                            </div>
                                            </div>
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 26%;">
                                                        <?php echo $GLOBALS['hidden_var']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <select id="visibility1" name="visibility"
                                                        class="form-select text-dark" onchange="sel_website(this.value,${row_id})">
                                                        <option value="none" selected>
                                                            <?php echo $GLOBALS['no_web']; ?>
                                                        </option>
                                                        <option value="some">
                                                            <?php echo $GLOBALS['some_web']; ?>
                                                        </option>
                                                        <option value="all">
                                                            <?php echo $GLOBALS['all_web']; ?>
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="somewebsite" style="display:none;">
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <input class="form-check-input hide_data" type="radio" name="hidden" id="hide"
                                                    value="hide">
                                                    <label class="form-check-label" for="hide">
                                                        <?php echo $GLOBALS['hide']; ?>
                                                    </label>
                                                    <textarea class="form-control text-dark" id="hide_value" name="variablecode" rows="3" cols="40" value=""></textarea>
                                                    <button type="button" id="hide_val" class="btn btn-secondary btn-sm mt-2" onclick="hide_code(${row_id})"><i class="fa-solid fa-angles-right fa-sm"></i></button>
                                                </div>  
                                                <div class="mb-3 col-md-4">
                                                    <input class="form-check-input show_data" type="radio" name="hidden" id="show"
                                                    value="show">
                                                    <label class="form-check-label" for="show">
                                                        <?php echo $GLOBALS['show:']; ?>
                                                    </label>
                                                    <textarea class="form-control text-dark" id="show_value" name="variablecode" rows="3" cols="40"></textarea>
                                                    <button type="button" id="show_val" class="btn btn-secondary btn-sm mt-2" onclick="show_code(${row_id})"><i class="fa-solid fa-angles-left fa-sm"></i></button>
                                                </div>                  
                                            </div>
                                            </div>
                                            <div class="varcode">
                                            <div class="row">
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputName" class="col-form-label"
                                                        style="margin-left: 26%;">
                                                        <?php echo $GLOBALS['js_track_code']; ?>
                                                    </label>
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                <textarea class="form-control text-dark" id="variablecode" name="variablecode" rows="3" cols="40"></textarea>
                                                </div>
                                            </div>
                                            </div>
                                            <hr class="solid">                            
                                        </div>
                                    </td></tr>`);
            var value = $('tr#R' + row_id + ' #visibility1 option:selected').val();
            sel_website(value, row_id);
            tracktype();
        });

        function sel_website(value, id) {
            if (value == "some") {
                $('tr#R' + id + ' .somewebsite').show();
                $('.hide_data').prop('checked', true);
            } else {
                $('tr#R' + id + ' .somewebsite').hide();
            }
        }

        // function hide_code(row_id) {
        //     $('tr#R' + row_id + ' #show_value').val('[id123]website.com');
        //     $('tr#R' + row_id + ' #hide_value').val('');
        // }

        // function show_code(row_id) {
        //     $('tr#R' + row_id + ' #hide_value').val('[id123]website.com');
        //     $('tr#R' + row_id + ' #show_value').val('');
        // }

        function dedupconversion(row_id) {
            if ($('tr#R' + row_id + ' #is_unique').prop('checked') == true) {
                $('tr#R' + row_id + ' .uniquewindow').show();
            } else {
                $('tr#R' + row_id + ' .uniquewindow').hide();
            }
        }

        $('#track_variable').on('click', '.remove', function () {
            var child = $(this).closest('tr').nextAll();
            child.each(function () {
                var id = $(this).attr('id');
                var dig = parseInt(id.substring(1));
                $(this).attr('id', `R${dig - 1}`);
            });
            $(this).closest('tr').remove();
            row_id--;

        });


        function addvariable() {
            var rows = $('#track_variable tbody tr').length;
            var formData = [];
            var error = false;
            for (var i = 0; i < rows; i++) {
                var j = i + 1;
                var rule_id = $('#track_variable tr#R' + j + ' div:first').attr('id');
                var name = $('tr#R' + j + ' #name').val();
                var description = $('tr#R' + j + ' #description').val();
                var datatype = $('tr#R' + j + ' #datatype option:selected').val();
                var purpose = $('tr#R' + j + ' #purpose option:selected').val();

                var reject_if_empty;
                if ($('tr#R' + j + ' #reject_if_empty').prop('checked') == true) {
                    reject_if_empty = 1;
                } else {
                    reject_if_empty = 0;
                }

                if ($('tr#R' + j + ' #is_unique').prop('checked') == true) {
                    is_unique = 1;
                } else {
                    is_unique = 0;
                }
                var days = $('tr#R' + j + ' #uniquewindow_day').val();
                var hours = $('tr#R' + j + ' #uniquewindow_hours').val();
                var minutes = $('tr#R' + j + ' #uniquewindow_minutes').val();
                var seconds = $('tr#R' + j + ' #uniquewindow_sec').val();

                var unique_window = (days * 86400 + hours * 3600 + minutes * 60 + seconds * 1);

                var hidden;
                if ($('tr#R' + j + ' #hide').prop('checked') == true) {
                    hidden = 't';
                } else {
                    hidden = 'f';
                }
                var variablecode = $('tr#R' + j + ' #variablecode').val();

                formData[i] = {
                    "name": name,
                    "description": description,
                    "datatype": datatype,
                    "purpose": purpose,
                    "reject_if_empty": reject_if_empty,
                    "is_unique": is_unique,
                    "unique_window": unique_window,
                    "hidden": hidden,
                    "variablecode": variablecode
                };
            }
            var result = {
                "data": formData
            };
            if (name != '') {
                $.ajax({
                    type: "POST",
                    url: live_URL + '/add_variable/' + trackerid,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: result,
                    dataType: "json",
                    encode: true,
                }).done(function (data) {
                    if (data.msg == "Variable has been added successfully!") {
                        window.scrollTo(0, 0);
                        $("#alertsuccess").show('medium');
                        setTimeout(function () {
                            $("#alertsuccess").hide('medium');
                        }, 2000);
                        setTimeout(function () {
                            location.reload();
                        }, 1200);
                    } else {
                        window.scrollTo(0, 0);
                        $("#alertfailed").show('medium');
                        setTimeout(function () {
                            $("#alertfailed").hide('medium');
                        }, 2000);
                    }
                });
            }
        }

        function get_variable() {
            $.ajax({
                url: live_URL + '/get_tracker_variables/' + trackerid,
                type: "GET",
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {

                var getdata = data.data;
                var data_length;
                if (getdata) {
                    data_length = getdata.length;
                    var i = 0;
                    $.each(getdata, function (index, value) {
                        var name = value['name'];
                        var description = value['description'];
                        var datatype = value['datatype'];
                        var purpose = value['purpose'];
                        var reject_if_empty = value['reject_if_empty'];
                        var is_unique = value['is_unique'];
                        var unique_window = value['unique_window'];
                        var hidden = value['hidden'];
                        var variablecode = value['variablecode'];
                        i++;
                        var select_option = $('#tracktype option:selected').val();
                        addBtn.click();
                        $('tr#R' + i + ' #name').val(name);
                        $('tr#R' + i + ' #description').val(description);
                        $('tr#R' + i + ' #datatype').val(datatype);
                        $('tr#R' + i + ' #purpose').val(purpose);
                        $('tr#R' + i + ' #variablecode').val(variablecode);
                    
                        if (reject_if_empty == 1) {
                            $('tr#R' + i + ' #reject_if_empty').prop('checked', true);
                        } else {
                            $('tr#R' + i + ' #reject_if_empty').prop('checked', false);
                        }
                        if (is_unique == 1) {
                            $('tr#R' + i + ' #is_unique').prop('checked', true);
                            $('tr#R' + i + ' .uniquewindow').show();
                        } else {
                            $('tr#R' + i + ' #is_unique').prop('checked', false);
                            $('tr#R' + i + ' .uniquewindow').hide();
                        }
                        var d = Math.floor(unique_window / 86400);
                        var h = Math.floor(unique_window % 86400 / 3600);
                        var m = Math.floor(unique_window % 3600 / 60);
                        var s = Math.floor(unique_window % 3600 % 60);
                        $('tr#R' + i + ' #uniquewindow_day').val(d);
                        $('tr#R' + i + ' #uniquewindow_hours').val(h);
                        $('tr#R' + i + ' #uniquewindow_minutes').val(m);
                        $('tr#R' + i + ' #uniquewindow_sec').val(s);

                        if (hidden == 't') {
                            $('tr#R' + i + ' #visibility1').val("some");
                            $('tr#R' + i + ' .somewebsite').show();
                            $('.show_data').prop('checked', true);
                        } else if (hidden == 'f') {
                            $('tr#R' + i + ' #visibility1').val("all");
                            $('tr#R' + i + ' .somewebsite').hide();
                        }
                        if (variablecode == '') {
                            $('tr#R' + i + ' #visibility1').val("none");
                            $('tr#R' + i + ' .somewebsite').hide();
                            $('tr#R' + i + ' .varcode').hide();
                            //$('.hide_data').prop('checked', true);
                        } else if (variablecode != '') {
                            $('tr#R' + i + ' #visibility1').val("none");
                            $('tr#R' + i + ' .somewebsite').hide();
                            $('#tracktype').val('custom');
                            select_option = 'custom';
                            if (select_option == 'custom') {
                                $('tr#R' + i + ' .varcode').show();
                            }
                        }
                    });
                }
            });
        }
    </script>


</body>

</html>