<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['tracker']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        #trackername,
        #description,
        #type,
        #status {
            width: 50%;
            display: inline;
        }

        #check {
            margin-left: 4rem;
        }

        .alert {
            display: none;
        }

        thead,
        tbody {
            display: block;
        }

        tbody {
            max-height: 450px;
            overflow-y: auto;
            overflow-x: auto;
        }

        tr,
        td {
            width: 1000px;
        }
    </style>
</head>

<body onload="track_invocationtag();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top mt-5 mb-4">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="adv_tracker_edit.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['tracker_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_campaigns.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['link_campaigns']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_variables.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['variables']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_append.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['append_tracker_code']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><span class="text-primary">
                                            <?php echo $GLOBALS['invocation_code']; ?>
                                        </span></a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="" role="tabpanel">
                                    <!-- <div class="card-body"> -->
                                    <div class="row mt-3">
                                        <h5 class="text-secondary">
                                            <?php echo $GLOBALS['banner_invocation']; ?>
                                        </h5>
                                        <hr class="solid">
                                    </div>
                                    <div class="row" id="invocation_tag">
                                        <div class="mb-4 col-md-3">
                                            <select id="invtype" name="invtype" class="form-select text-dark"
                                                onchange="track_invocationtag()">
                                                <option value="img">
                                                    <?php echo $GLOBALS['img_tag']; ?>
                                                </option>
                                                <option value="js" selected>
                                                    <?php echo $GLOBALS['javascript_tag']; ?>
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="mb-3 col-md-4">
                                            <label for="inputName" class="col-form-label" style="">
                                                <?php echo $GLOBALS['track_code']; ?>
                                            </label>
                                        </div>
                                        <div class="mb-3 col-md-12">
                                            <textarea readonly class="form-control text-dark" id="bannercode"
                                                name="bannercode" rows="15" cols="80"
                                                onmouseover="this.select()"></textarea>
                                        </div>
                                    </div>
                                    <hr class="solid">
                                    <div id="tag_settings">
                                        <div class="row">
                                            <div class="mb-3 col-md-4">
                                                <label for="inputName" class="col-form-label" style="">
                                                    <?php echo $GLOBALS['tag_settings']; ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="row mb-3">
                                            <div class="col col-6 col-sm-6 col-md-4 col-lg-4 col-xl-4 col-xxl-4">
                                                <label for="inputName">
                                                    <?php echo $GLOBALS['always_display_append_code']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-2 col-sm-2 col-md-1 col-lg-1 col-xl-1 col-xxl-1">
                                                <input class="form-check-input" type="radio" name="append" id="append"
                                                    value="1">
                                                <label class="form-check-label" for="no">
                                                    <?php echo $GLOBALS['yes']; ?>
                                                </label>
                                            </div>
                                            <div class="col col-2 col-sm-2 col-md-1 col-lg-1 col-xl-1 col-xxl-1">
                                                <input class="form-check-input" type="radio" name="append" id="append"
                                                    value="0" checked>
                                                <label class="form-check-label" for="no1">
                                                    <?php echo $GLOBALS['No']; ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="solid">
                                    <div class="row mb-3 mt-3">
                                        <div class="col">
                                            <button type="button" id="refresh" style="float:right;"
                                                class="btn btn-primary submitbtn" onclick="track_invocationtag()">
                                                <?php echo $GLOBALS['refresh']; ?>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- </div> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var trackerid = '<?php echo $_REQUEST['trackerid']; ?>';

        function track_invocationtag() {
            var invocationtag = $('#invtype option:selected').val();
            var append = $('#append').val();
            //alert(append);
            if (invocationtag == 'js') {
                var invocation_url = live_URL + '/track_javascript/';
                var formData = {
                    "append": append,
                };
            } else if (invocationtag == 'img') {
                var invocation_url = live_URL + '/track_imagetag/';
                var formData = {
                    "append": append,
                };
            }
            $.ajax({
                url: invocation_url + trackerid,
                type: 'POST',
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: formData,
                success: function (data) {
                    if (invocationtag == 'js') {
                        var invocation_tags = data.Trackerjavascripttag;
                        $('#tag_settings').show();
                    } else if (invocationtag == 'img') {
                        var invocation_tags = data.Trackerimagetag;
                        $('#tag_settings').hide();
                    }
                    $('#bannercode').val(invocation_tags);
                }
            });
        }
    </script>


</body>

</html>