<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/'
    data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>
        <?php echo $projecttitle; ?> -
        <?php echo $GLOBALS['tracker']; ?>
    </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        #trackername,
        #description,
        #type,
        #status {
            width: 50%;
            display: inline;
        }

        #check {
            margin-left: 4rem;
        }

        .alert {
            display: none;
        }

        thead,
        tbody {
            display: block;
        }

        tbody {
            max-height: 450px;
            overflow-y: auto;
            overflow-x: auto;
        }

        tr,
        td {
            width: 1000px;
        }
    </style>
</head>

<body onload="get_append_code();">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top mt-5 mb-4">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="adv_tracker_edit.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['tracker_properties']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_campaigns.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['link_campaigns']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_variables.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['variables']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link active" href="#"><span class="text-primary">
                                            <?php echo $GLOBALS['append_tracker_code']; ?>
                                        </span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link"
                                        href="tracker_invocation.php?clientid=<?php echo $_GET['clientid']; ?>&trackerid=<?php echo $_GET['trackerid']; ?>"><span
                                            class="text-dark">
                                            <?php echo $GLOBALS['invocation_code']; ?>
                                        </span></a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="" role="tabpanel">
                                    <!-- <div class="card-body"> -->
                                    <div>
                                        <p class="alert bg-success alert-dismissible fade show text-white"
                                            id="alertsuccess"><i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['append_success_msg']; ?>
                                        </p>
                                        <p class="alert bg-danger alert-dismissible fade show text-white"
                                            id="alertfailed">
                                            <i class="fa fa-check-circle"></i>
                                            <?php echo $GLOBALS['append_failed_msg']; ?>
                                        </p>
                                    </div>
                                    <div class="row mt-3">
                                        <h5>
                                            <?php echo $GLOBALS['append_tracker_code']; ?>
                                        </h5>
                                        <hr class="solid">
                                    </div>
                                    <div class="row" id="append_new_tag">
                                        <div class="mb-3 col">
                                            <a href="#"><i class="fa-solid fa-circle-plus" id=""></i>
                                                <?php echo $GLOBALS['append_new_tag']; ?> &nbsp;
                                            </a>
                                        </div>
                                    </div>
                                    <div class="table-responsive text-nowrap">
                                        <table id="tracker_code" class="table table-striped table-responsive ">
                                            <tbody id="table_body">
                                            </tbody>
                                        </table>
                                    </div>
                                    <div class="row mb-3 mt-3">
                                        <div class="col">
                                            <button type="button" id="submitbtn" style="float:right;"
                                                class="btn btn-primary submitbtn" onclick="addappendtracker()">
                                                <?php echo $GLOBALS['save_changes']; ?>
                                            </button>
                                        </div>
                                    </div>
                                    <!-- </div> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php include('footer.php'); ?>
            </div>
        </div>
    </div>
    <script src="../js/sweetalert.min.js"></script>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var clientid = '<?php echo $_REQUEST['clientid']; ?>';
        var trackerid = '<?php echo $_REQUEST['trackerid']; ?>';
        var row_id = 0;
        //$(".tracker_code").hide();

        $('#append_new_tag').on('click', function () {
            $('#tracker_code').append(`<tr id="R${++row_id}"><td><div class="container mt-3" id="append_tracker">
                        <div class="row">
                            <div class="mb-3 col-md-4">
                                <label for="inputName" class="col-form-label" style="">
                                    <span id='rowid'></span><?php echo $GLOBALS['track_code']; ?>
                                </label><span id="len" class="text-secondary"></span>
                            </div>
                            <div class="mb-3 col-md-8">
                                <button class="btn rounded-pill btn-icon text-primary remove"
                                    style="float:right;" value="" id="remove">
                                    <i class="fa-sharp fa-solid fa-circle-xmark fa-2x"></i></button>
                            </div>
                         </div>
                        <div class="row">
                            <div class="mb-3 col-md-10">
                                <textarea class="form-control text-dark" id="tag" name="tag"
                                    rows="5" cols="40"></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col-md-10">
                                <input class="form-check-input" type="checkbox" id="autotrack"
                                    name="autotrack" value="1">&nbsp;<?php echo $GLOBALS['auto_change_code']; ?>
                            </div>
                            <div class="mb-3 col-md-2">
                                <button class="btn text-primary pause" id="pause" value="pause" style="float:right;" onclick="pause_append(this.value,${row_id})">
                                <i class="fa-solid fa-xmark" id="icon_pause"></i><?php echo $GLOBALS['strInventory_Campaign_List_Paused']; ?></button>
                            </div>
                        </div>
                        <hr class="solid">
                </div></td></tr>`);
            var pauseval = $('tr#R' + row_id + ' #pause').val();
            $('tr#R' + row_id + ' #rowid').html(row_id + '.');
            //$('tr#R' + row_id + ' #icon_start').hide();
        });

        function pause_append(pauseval, row_id) {
            if (pauseval == "pause") {
                $('tr#R' + row_id + ' #pause').text('Restart');
                $('tr#R' + row_id + ' #icon_pause').hide();
                $('tr#R' + row_id + ' #icon_start').show();
                var pauseval = $('tr#R' + row_id + ' #pause').val("restart");
                var x = '(Paused)';
                $('tr#R' + row_id + ' #len').html(x);
            } else {
                $('tr#R' + row_id + ' #pause').text("Paused");
                $('tr#R' + row_id + ' #icon_pause').show();
                $('tr#R' + row_id + ' #icon_start').hide();
                var pauseval = $('tr#R' + row_id + ' #pause').val("pause");
                var x = '';
                $('tr#R' + row_id + ' #len').html(x);
            }
        }

        $('#tracker_code').on('click', '.remove', function () {
            var child = $(this).closest('tr').nextAll();
            child.each(function () {
                var id = $(this).attr('id');
                var dig = parseInt(id.substring(1));
                $(this).attr('id', `R${dig - 1}`);
            });
            $(this).closest('tr').remove();
            row_id--;
        });



        function addappendtracker() {
            var rows = $('#tracker_code tbody tr').length;
            var formData = [];
            var error = false;
            for (var i = 0; i < rows; i++) {
                var j = i + 1;
                var rule_id = $('#tracker_code tr#R' + j + ' div:first').attr('id');
                var tag = $('tr#R' + j + ' #tag').val();
                var autotrack;
                if ($('tr#R' + j + ' #autotrack').prop('checked') == true) {
                    autotrack = 't';
                } else {
                    autotrack = 'f';
                }

                formData[i] = {
                    "tag": tag,
                    "autotrack": autotrack
                };
            }

            var result = {
                "data": formData
            };
            if (tag != '') {
                $.ajax({
                    type: "POST",
                    url: live_URL + '/add_append_tracker/' + trackerid,
                    beforeSend: function (xhr) {
                        xhr.setRequestHeader('Authorization', token);
                    },
                    data: result,
                    dataType: "json",
                    encode: true,
                }).done(function (data) {

                    if (data.msg == "Append tracker code has been added successfully!") {
                        window.scrollTo(0, 0);
                        $("#alertsuccess").show('medium');
                        setTimeout(function () {
                            $("#alertsuccess").hide('medium');
                        }, 2000);
                        setTimeout(function () {
                            location.reload();
                        }, 1200);
                    } else {
                        window.scrollTo(0, 0);
                        $("#alertfailed").show('medium');
                        setTimeout(function () {
                            $("#alertfailed").hide('medium');
                        }, 2000);
                    }
                });
            }
        }

        function get_append_code() {
            $.ajax({
                url: live_URL + '/get_append_code/' + trackerid,
                type: "GET",
                beforeSend: function (xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function (data) {

                var getdata = data.data;
                if (getdata) {
                    var data_length;
                    data_length = getdata.length;
                    var i = 0;
                    $.each(getdata, function (index, value) {
                        i++;
                        append_new_tag.click();
                        var tagcode = value['tagcode'];
                        var autotrack = value['autotrack'];

                        $('tr#R' + i + ' #tag').val(tagcode);
                        if (autotrack == 't') {
                            $('tr#R' + i + ' #autotrack').prop('checked', true);
                        } else {
                            $('tr#R' + i + ' #autotrack').prop('checked', false);
                        }
                    });
                }
            });
        }
    </script>


</body>

</html>