<?php
include('session.php');
include('../config.php');
include('../common.php');
?>
<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path='../assets/' data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $projecttitle; ?> - <?php echo $GLOBALS['edit_del_rule_set']; ?> </title>
    <meta name="description" content="" />
    <?php include('head.php'); ?>
    <style>
        .cancel-style {
            color: red !important
        }

        .cancel-style:hover {
            color: #fff !important
        }

        .alert {
            display: none;
        }

        .swal-footer {
            text-align: center;
        }
    </style>
</head>

<body onload="">
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php include('sidebar.php'); ?>

            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php include('navbar.php'); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <!-- Content -->
                    <div class="container">
                        <div class="nav-align-top my-4">
                            <ul class="nav nav-tabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active text-primary" aria-current="page" href="#"><?php echo $GLOBALS['edit_del_rule_set']; ?></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="delivery_option_pub.php?channelid=<?php echo $_GET['channelid']; ?>&affiliate_id=<?php echo $_GET['affiliate_id']; ?>"><?php echo $GLOBALS['delivery_options']; ?></a>
                                </li>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="delivery_options_banner" role="tabpanel">
                                    <p class="alert bg-success fade show text-white" id="alertsuccess"><i class="fa fa-check-circle"></i> <?php echo $GLOBALS['del_rule_update_msg']; ?> </p>
                                    <p class="alert bg-danger alert-dismissible fade show text-white" id="alertfailed"><i class="fa fa-times-circle"></i> <?php echo $GLOBALS['del_rule_update_fail']; ?> </p>
                                    <input type="hidden" name="channel_id" id="channel_id" value="<?php echo $_GET['channelid']; ?>">
                                    <div class="row mb-3">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                        <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['website']; ?><span style="color: red;">*</span></label>
                                            <select id="website" class="form-select text-dark mb-2 website" onchange="">
                                            
                                            </select>
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;"><?php echo $GLOBALS['strName']; ?><span style="color: red;">*</span> </label>
                                            <input type="text" name="rule_name" id="rule_name" class="form-control mb-2 text-dark" placeholder="<?php echo $GLOBALS['strName']; ?>" onchange="nameValidation();" onkeyup="nameValidation();" />
                                            <p id="rule_set_error" class="h6 text-danger"><?php echo $GLOBALS['strName_validation']; ?></p>
                                        </div>

                                    </div>
                                    <div class="row mb-3">
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['strInventory_Description']; ?> </label>
                                            <input type="text" name="rule_description" id="rule_description" class="form-control mb-2 text-dark" placeholder="" />
                                        </div>
                                        <div class="col col-12 col-sm-12 col-md-6 col-lg-6 col-xl-6 col-xxl-6">
                                            <label class="form-label mb-2" style="font-size: 1.4ch;"> <?php echo $GLOBALS['strInventory_Comments']; ?> </label>
                                            <textarea name="rule_comments" id="rule_comments" class="form-control mb-2 text-dark" rows="2"></textarea>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <div class="col col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 col-xxl-12 d-flex justify-content-end justify-content-sm-end justify-content-md-end justify-content-lg-end justify-content-xl-end justify-content-xxl-end">
                                            <button class="btn btn-outline-danger cancel-style" type="button" id="cancel" onclick="cancel()"><?php echo $GLOBALS['strCancel']; ?></button>&nbsp;
                                            <button class="btn btn-primary" type="button" id="save_changes" onclick="save_rule()"><?php echo $GLOBALS['strUpdate']; ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php include('footer.php'); ?>
                </div>
            </div>
        </div>
    </div>
    <script>
        var live_URL = '<?php echo $apiinvenpath; ?>';
        var token = 'Bearer ' + document.getElementById('token').value;
        var agencyid = '<?php echo $_SESSION['agencyid']; ?>';
        var publisherId = '<?php echo $_SESSION['publisher_id']; ?>';
        var channelid = '<?php echo $_REQUEST['channelid']; ?>';
        var getaffiliateid = '<?php echo $_GET['affiliate_id']; ?>';
        var error = false;
        $(document).ready(function() {
            $('#rule_set_error').hide();
            $.ajax({
                type: "GET",
                url: live_URL + '/gettargetingchannel/' + channelid,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log(data.data);
                var affiliateid = data.data.affiliateid;
                get_websites(affiliateid);
                $('#rule_name').val(data.data.name);
                $('#rule_description').val(data.data.description);
                $('#rule_comments').val(data.data.comments);
            });

        });

        function get_websites(id) {
            $.ajax({
                type: "GET",
                url: live_URL + '/get_all_website/' + agencyid,
                beforeSend: function(xhr) {
                    xhr.setRequestHeader('Authorization', token);
                },
                data: {},
                dataType: "json",
                encode: true,
            }).done(function(data) {
                console.log(data.data);
                var websites = [];
                data.data.map((data) => {
                    websites += `<option value=${data.affiliateid}>${data.name}</option>`;
                });
                $('#website').html(websites);
                if (id != '') {
                    $('#website').val(id);
                    $('#website').attr('disabled', true);
                } else {
                    $('#website').attr('disabled', false);
                }
            });
        }

        nameValidation = () => {
            var name = $('#rule_name').val();
            if (name == null || name == "") {
                $('#rule_set_error').show();
            } else {
                $('#rule_set_error').hide();
            }
        };

        $("#rule_name").bind("paste", function(e) {
            var pastedData = e.originalEvent.clipboardData.getData('text');
            if (pastedData == null || pastedData == "") {
                $('#rule_set_error').show();
            } else {
                $('#rule_set_error').hide();
            }
        });

        function cancel() {
            if (getaffiliateid) {
                    window.location.href = "delivery_rule_set.php?affiliate_id=" + getaffiliateid;
                } else {
                    window.location.href = "delivery_rule_set.php";
                }
        }

        function save_rule() {
            var formdata = [];
            var affiliate_id = $('#website').val();
            var name = $('#rule_name').val();
            var description = $('#rule_description').val();
            var comments = $('#rule_comments').val();

            if (name == '') {
                $('#rule_set_error').show();
                return false;
            } else {
                $('#rule_set_error').hide();
                if (error == false) {
                    var formData = {
                        "affiliateid": affiliate_id,
                        "name": name,
                        "description": description,
                        "comments": comments,
                    };

                    //console.log(formData);
                    $.ajax({
                        type: "POST",
                        url: live_URL + '/edit_targeting_channel/' + channelid,
                        beforeSend: function(xhr) {
                            xhr.setRequestHeader('Authorization', token);
                        },
                        data: formData,
                        dataType: "json",
                        encode: true,
                    }).done(function(data) {
                        if (data.statuscode == 200 && data.msg == "Delivery rule set updated successfully") {
                            $("#alertsuccess").show('medium');
                            setTimeout(function() {
                                $("#alertsuccess").hide('medium');
                            }, 2000);
                            setTimeout(function() {
                                location.reload();
                            }, 1500);
                        } else {
                            $("#alertfailed").show('medium');
                            setTimeout(function() {
                                $("#alertfailed").hide('medium');
                            }, 2000);
                        }
                    });
                }
            }
        }
    </script>
</body>

</html>